/*
 * Decompiled with CFR 0.152.
 */
package avail.optimizer;

import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2NamedOperandType;
import avail.interpreter.levelTwo.L2OperandType;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2PcOperand;
import avail.interpreter.levelTwo.operand.L2PcVectorOperand;
import avail.interpreter.levelTwo.operand.TypeRestriction;
import avail.interpreter.levelTwo.operation.L2_JUMP;
import avail.interpreter.levelTwo.operation.L2_UNREACHABLE_CODE;
import avail.interpreter.levelTwo.register.L2Register;
import avail.optimizer.L2BasicBlock;
import avail.optimizer.L2ControlFlowGraph;
import avail.optimizer.L2ControlFlowGraphVisualizer;
import avail.optimizer.L2Synonym;
import avail.optimizer.L2ValueManifest;
import avail.optimizer.values.L2SemanticValue;
import avail.utility.Strings;
import avail.utility.dot.DotWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 52\u00020\u0001:\u00015BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J$\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00132\n\u0010\u001c\u001a\u00060\u001fR\u00020\u001d2\u0006\u0010 \u001a\u00020\nH\u0002J\u0010\u0010!\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0013H\u0002J0\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u00172\n\u0010$\u001a\u00060\u001fR\u00020\u001d2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\n0&H\u0002J\u0016\u0010'\u001a\u00020\u001b2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00130)H\u0002J,\u0010*\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020+2\n\u0010\u001c\u001a\u00060\u001fR\u00020\u001d2\u0006\u0010 \u001a\u00020\n2\u0006\u0010,\u001a\u00020-H\u0002J\u001c\u0010.\u001a\u00020\u00032\u0006\u0010.\u001a\u00020/2\n\u0010\u001c\u001a\u00060\u001fR\u00020\u001dH\u0002J\u0006\u00100\u001a\u00020\u001bJ$\u00101\u001a\u00020\u001b*\u000602j\u0002`32\u0006\u00101\u001a\u0002042\n\u0010\u001c\u001a\u00060\u001fR\u00020\u001dH\u0002R\u0012\u0010\r\u001a\u00060\u000ej\u0002`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00030\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00060\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00180\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lavail/optimizer/L2ControlFlowGraphVisualizer;", "", "fileName", "", "name", "charactersPerLine", "", "controlFlowGraph", "Lavail/optimizer/L2ControlFlowGraph;", "visualizeLiveness", "", "visualizeManifest", "visualizeRegisterDescriptions", "accumulator", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "(Ljava/lang/String;Ljava/lang/String;ILavail/optimizer/L2ControlFlowGraph;ZZZLjava/lang/Appendable;)V", "basicBlockNames", "", "Lavail/optimizer/L2BasicBlock;", "basicBlockNumbers", "blocksByZone", "", "Lavail/optimizer/L2ControlFlowGraph$Zone;", "", "subgraphNumber", "banner", "", "writer", "Lavail/utility/dot/DotWriter;", "basicBlock", "Lavail/utility/dot/DotWriter$GraphWriter;", "started", "basicBlockName", "cluster", "zone", "graph", "isStarted", "Lkotlin/Function1;", "computeClusters", "blocks", "", "edge", "Lavail/interpreter/levelTwo/operand/L2PcOperand;", "edgeCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "instruction", "Lavail/interpreter/levelTwo/L2Instruction;", "visualize", "manifest", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "Lavail/optimizer/L2ValueManifest;", "Companion", "avail"})
public final class L2ControlFlowGraphVisualizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String fileName;
    @NotNull
    private final String name;
    private final int charactersPerLine;
    @NotNull
    private final L2ControlFlowGraph controlFlowGraph;
    private final boolean visualizeLiveness;
    private final boolean visualizeManifest;
    private final boolean visualizeRegisterDescriptions;
    @NotNull
    private final Appendable accumulator;
    @NotNull
    private final Map<L2BasicBlock, Integer> basicBlockNumbers;
    @NotNull
    private final Map<L2BasicBlock, String> basicBlockNames;
    @NotNull
    private final Map<L2ControlFlowGraph.Zone, Set<L2BasicBlock>> blocksByZone;
    private int subgraphNumber;
    @NotNull
    private static final String errorTextColor = "#e04040/ff6060";
    @NotNull
    private static final String commentTextColor = "#404040/a0a0a0";
    private static final Pattern matchUglies = Pattern.compile("[\"\\\\]");

    public L2ControlFlowGraphVisualizer(@NotNull String fileName, @NotNull String name2, int charactersPerLine, @NotNull L2ControlFlowGraph controlFlowGraph, boolean visualizeLiveness, boolean visualizeManifest, boolean visualizeRegisterDescriptions, @NotNull Appendable accumulator) {
        Pair<L2BasicBlock, CallSite> pair;
        boolean bl;
        Map map;
        Iterable $this$associateTo$iv$iv;
        Iterable $this$associate$iv;
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(controlFlowGraph, "controlFlowGraph");
        Intrinsics.checkNotNullParameter(accumulator, "accumulator");
        this.fileName = fileName;
        this.name = name2;
        this.charactersPerLine = charactersPerLine;
        this.controlFlowGraph = controlFlowGraph;
        this.visualizeLiveness = visualizeLiveness;
        this.visualizeManifest = visualizeManifest;
        this.visualizeRegisterDescriptions = visualizeRegisterDescriptions;
        this.accumulator = accumulator;
        Iterable iterable = CollectionsKt.withIndex((Iterable)this.controlFlowGraph.getBasicBlockOrder());
        L2ControlFlowGraphVisualizer l2ControlFlowGraphVisualizer = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        void var12_13 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object t : $this$associateTo$iv$iv) {
            map = destination$iv$iv;
            IndexedValue it = (IndexedValue)t;
            bl = false;
            pair = TuplesKt.to(it.getValue(), it.getIndex());
            map.put(pair.getFirst(), pair.getSecond());
        }
        l2ControlFlowGraphVisualizer.basicBlockNumbers = destination$iv$iv;
        $this$associate$iv = CollectionsKt.withIndex((Iterable)this.controlFlowGraph.getBasicBlockOrder());
        l2ControlFlowGraphVisualizer = this;
        $i$f$associate = false;
        capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        $this$associateTo$iv$iv = $this$associate$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        $i$f$associateTo = false;
        for (Object object : $this$associateTo$iv$iv) {
            map = destination$iv$iv;
            pair = (IndexedValue)object;
            bl = false;
            int index2 = ((IndexedValue)((Object)pair)).component1();
            L2BasicBlock block = (L2BasicBlock)((IndexedValue)((Object)pair)).component2();
            int offset = block.offset();
            int id = offset == -1 ? index2 : offset;
            String prefix = offset == -1 ? "[id: " + id + "]" : "[pc: " + id + "]";
            String clean = matchUglies.matcher(block.name()).replaceAll("");
            pair = TuplesKt.to(block, prefix + " " + clean);
            map.put(pair.getFirst(), pair.getSecond());
        }
        l2ControlFlowGraphVisualizer.basicBlockNames = destination$iv$iv;
        this.blocksByZone = new LinkedHashMap();
        this.subgraphNumber = 1;
    }

    private final void banner(DotWriter writer) throws IOException {
        String string2 = "\n%s.dot\nCopyright \u00a9 %s, %s.\nAll rights reserved.\n\nGenerated by %s - do not modify!\n\n";
        Object[] objectArray = new Object[]{this.fileName, writer.getCopyrightOwner(), LocalDateTime.ofInstant(Instant.now(), ZoneId.systemDefault()).getYear(), L2ControlFlowGraphVisualizer.class.getSimpleName()};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
        writer.blockComment(string3);
    }

    private final String basicBlockName(L2BasicBlock basicBlock2) {
        Object object = this.basicBlockNames.get(basicBlock2);
        if (object == null) {
            object = "(not generated: " + basicBlock2.name() + ")";
        }
        return object;
    }

    private final void basicBlock(L2BasicBlock basicBlock2, DotWriter.GraphWriter writer, boolean started) {
        StringBuilder stringBuilder;
        StringBuilder $this$basicBlock_u24lambda_u2d2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Pair[] pairArray = new Pair[]{TuplesKt.to("border", "0"), TuplesKt.to("cellspacing", "0")};
        Strings.INSTANCE.tag($this$basicBlock_u24lambda_u2d2, "table", pairArray, (Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(basicBlock2, started, writer, this){
            final /* synthetic */ L2BasicBlock $basicBlock;
            final /* synthetic */ boolean $started;
            final /* synthetic */ DotWriter.GraphWriter $writer;
            final /* synthetic */ L2ControlFlowGraphVisualizer this$0;
            {
                this.$basicBlock = $basicBlock;
                this.$started = $started;
                this.$writer = $writer;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull StringBuilder $this$tag) {
                Pair<String, String> pair;
                Intrinsics.checkNotNullParameter($this$tag, "$this$tag");
                List<L2Instruction> instructions = this.$basicBlock.instructions();
                L2Instruction first = !((Collection)instructions).isEmpty() ? this.$basicBlock.instructions().get(0) : null;
                if (!this.$started) {
                    pair = TuplesKt.to("#202080/303000", "#ffffff/e0e0e0");
                } else {
                    boolean bl;
                    block9: {
                        Iterable $this$any$iv = this.$basicBlock.instructions();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                L2Instruction it = (L2Instruction)element$iv;
                                boolean bl2 = false;
                                if (!(it.getOperation() == L2_UNREACHABLE_CODE.INSTANCE)) continue;
                                bl = true;
                                break block9;
                            }
                            bl = false;
                        }
                    }
                    pair = bl ? TuplesKt.to("#400000/600000", "#ffffff/ffffff") : (this.$basicBlock.isLoopHead() ? TuplesKt.to("#9070ff/302090", "#000000/f0f0f0") : (first != null && first.isEntryPoint() ? TuplesKt.to("#ffd394/604000", "#000000/e0e0e0") : TuplesKt.to("#c1f0f6/104048", "#000000/e0e0e0")));
                }
                Pair<String, String> pair2 = pair;
                String fillcolor = pair2.component1();
                String fontcolor = pair2.component2();
                Strings.INSTANCE.tag($this$tag, "tr", new Pair[0], (Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(this.$writer, fillcolor, fontcolor, this.$basicBlock, this.this$0){
                    final /* synthetic */ DotWriter.GraphWriter $writer;
                    final /* synthetic */ String $fillcolor;
                    final /* synthetic */ String $fontcolor;
                    final /* synthetic */ L2BasicBlock $basicBlock;
                    final /* synthetic */ L2ControlFlowGraphVisualizer this$0;
                    {
                        this.$writer = $writer;
                        this.$fillcolor = $fillcolor;
                        this.$fontcolor = $fontcolor;
                        this.$basicBlock = $basicBlock;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull StringBuilder $this$tag) {
                        Intrinsics.checkNotNullParameter($this$tag, "$this$tag");
                        Pair[] pairArray = new Pair[]{TuplesKt.to("align", "left"), TuplesKt.to("balign", "left"), TuplesKt.to("border", "1"), TuplesKt.to("sides", "LTB"), TuplesKt.to("bgcolor", this.$writer.adjust(this.$fillcolor))};
                        Strings.INSTANCE.tag($this$tag, "td", pairArray, (Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(this.$writer, this.$fontcolor, this.$basicBlock){
                            final /* synthetic */ DotWriter.GraphWriter $writer;
                            final /* synthetic */ String $fontcolor;
                            final /* synthetic */ L2BasicBlock $basicBlock;
                            {
                                this.$writer = $writer;
                                this.$fontcolor = $fontcolor;
                                this.$basicBlock = $basicBlock;
                                super(1);
                            }

                            public final void invoke(@NotNull StringBuilder $this$tag) {
                                Intrinsics.checkNotNullParameter($this$tag, "$this$tag");
                                Pair[] pairArray = new Pair[]{TuplesKt.to("face", "Courier"), TuplesKt.to("color", this.$writer.adjust(this.$fontcolor))};
                                Strings.INSTANCE.tag($this$tag, "font", pairArray, (Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(this.$basicBlock){
                                    final /* synthetic */ L2BasicBlock $basicBlock;
                                    {
                                        this.$basicBlock = $basicBlock;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull StringBuilder $this$tag) {
                                        Intrinsics.checkNotNullParameter($this$tag, "$this$tag");
                                        $this$tag.append(avail.optimizer.L2ControlFlowGraphVisualizer$Companion.access$escape(L2ControlFlowGraphVisualizer.Companion, this.$basicBlock.name()));
                                    }
                                });
                            }
                        });
                        pairArray = new Pair[]{TuplesKt.to("align", "right"), TuplesKt.to("border", "1"), TuplesKt.to("sides", "RTB"), TuplesKt.to("bgcolor", this.$writer.adjust(this.$fillcolor))};
                        Strings.INSTANCE.tag($this$tag, "td", pairArray, (Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(this.$writer, this.this$0, this.$basicBlock){
                            final /* synthetic */ DotWriter.GraphWriter $writer;
                            final /* synthetic */ L2ControlFlowGraphVisualizer this$0;
                            final /* synthetic */ L2BasicBlock $basicBlock;
                            {
                                this.$writer = $writer;
                                this.this$0 = $receiver;
                                this.$basicBlock = $basicBlock;
                                super(1);
                            }

                            public final void invoke(@NotNull StringBuilder $this$tag) {
                                Intrinsics.checkNotNullParameter($this$tag, "$this$tag");
                                Pair[] pairArray = new Pair[]{TuplesKt.to("face", "Courier"), TuplesKt.to("color", this.$writer.adjust("#404040/a0a0a0"))};
                                Strings.INSTANCE.tag($this$tag, "font", pairArray, (Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(this.this$0, this.$basicBlock){
                                    final /* synthetic */ L2ControlFlowGraphVisualizer this$0;
                                    final /* synthetic */ L2BasicBlock $basicBlock;
                                    {
                                        this.this$0 = $receiver;
                                        this.$basicBlock = $basicBlock;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull StringBuilder $this$tag) {
                                        Intrinsics.checkNotNullParameter($this$tag, "$this$tag");
                                        Object object = (Integer)L2ControlFlowGraphVisualizer.access$getBasicBlockNumbers$p(this.this$0).get(this.$basicBlock);
                                        if (object == null) {
                                            object = "?";
                                        }
                                        $this$tag.append("#" + object);
                                    }
                                });
                            }
                        });
                    }
                });
                if (!((Collection)instructions).isEmpty()) {
                    void $this$forEachIndexed$iv;
                    Iterable iterable = this.$basicBlock.instructions();
                    DotWriter.GraphWriter graphWriter = this.$writer;
                    L2ControlFlowGraphVisualizer l2ControlFlowGraphVisualizer = this.this$0;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (T item$iv : $this$forEachIndexed$iv) {
                        void instruction2;
                        int n;
                        if ((n = index$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        L2Instruction l2Instruction = (L2Instruction)item$iv;
                        int port = n;
                        boolean bl = false;
                        Strings.INSTANCE.tag($this$tag, "tr", new Pair[0], (Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(port, (L2Instruction)instruction2, graphWriter, l2ControlFlowGraphVisualizer){
                            final /* synthetic */ int $port;
                            final /* synthetic */ L2Instruction $instruction;
                            final /* synthetic */ DotWriter.GraphWriter $writer;
                            final /* synthetic */ L2ControlFlowGraphVisualizer this$0;
                            {
                                this.$port = $port;
                                this.$instruction = $instruction;
                                this.$writer = $writer;
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull StringBuilder $this$tag) {
                                Intrinsics.checkNotNullParameter($this$tag, "$this$tag");
                                Pair[] pairArray = new Pair[]{TuplesKt.to("colspan", "2"), TuplesKt.to("align", "left"), TuplesKt.to("balign", "left"), TuplesKt.to("border", "1"), TuplesKt.to("port", String.valueOf(this.$port + 1)), TuplesKt.to("valign", "top")};
                                List<Pair> cellAttributes = CollectionsKt.mutableListOf(pairArray);
                                if (this.$instruction.isPlaceholder()) {
                                    cellAttributes.add(TuplesKt.to("bgcolor", this.$writer.adjust("#ff9090/#500000")));
                                }
                                Collection $this$toTypedArray$iv = cellAttributes;
                                boolean $i$f$toTypedArray = false;
                                Collection thisCollection$iv = $this$toTypedArray$iv;
                                Pair[] pairArray2 = thisCollection$iv.toArray(new Pair[0]);
                                Intrinsics.checkNotNull(pairArray2, "null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                                pairArray = pairArray2;
                                Strings.INSTANCE.tag($this$tag, "td", Arrays.copyOf(pairArray, pairArray.length), (Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(this.this$0, this.$instruction, this.$writer){
                                    final /* synthetic */ L2ControlFlowGraphVisualizer this$0;
                                    final /* synthetic */ L2Instruction $instruction;
                                    final /* synthetic */ DotWriter.GraphWriter $writer;
                                    {
                                        this.this$0 = $receiver;
                                        this.$instruction = $instruction;
                                        this.$writer = $writer;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull StringBuilder $this$tag) {
                                        Intrinsics.checkNotNullParameter($this$tag, "$this$tag");
                                        $this$tag.append(L2ControlFlowGraphVisualizer.access$instruction(this.this$0, this.$instruction, this.$writer));
                                    }
                                });
                            }
                        });
                    }
                } else {
                    Strings.INSTANCE.tag($this$tag, "tr", new Pair[0], basicBlock.rhs.1.4.INSTANCE);
                }
            }
        });
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        String rhs2 = string2;
        try {
            writer.node(this.basicBlockName(basicBlock2), (Function1<? super DotWriter.AttributeWriter, Unit>)new Function1<DotWriter.AttributeWriter, Unit>(rhs2){
                final /* synthetic */ String $rhs;
                {
                    this.$rhs = $rhs;
                    super(1);
                }

                public final void invoke(@NotNull DotWriter.AttributeWriter it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    it.attribute("label", this.$rhs);
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void edge(L2PcOperand edge2, DotWriter.GraphWriter writer, boolean started, AtomicInteger edgeCounter) {
        StringBuilder index$iv2;
        int n;
        L2NamedOperandType[] types;
        boolean isTargetTheUnreachableBlock;
        L2BasicBlock targetBlock;
        L2Instruction sourceInstruction;
        L2BasicBlock sourceBlock;
        block7: {
            L2Operand[] operands;
            boolean bl;
            block6: {
                void $this$any$iv;
                sourceBlock = edge2.sourceBlock();
                sourceInstruction = edge2.getInstruction();
                targetBlock = edge2.targetBlock();
                Iterable iterable = targetBlock.instructions();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        L2Instruction it = (L2Instruction)element$iv;
                        boolean bl2 = false;
                        if (!(it.getOperation() == L2_UNREACHABLE_CODE.INSTANCE)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            isTargetTheUnreachableBlock = bl;
            types = sourceInstruction.getOperation().operandTypes();
            L2Operand[] $this$indexOfFirst$iv = operands = sourceInstruction.getOperands();
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length;
            for (int index$iv2 = 0; index$iv2 < n2; ++index$iv2) {
                L2Operand it = $this$indexOfFirst$iv[index$iv2];
                boolean bl3 = false;
                boolean bl4 = Intrinsics.areEqual(it, edge2) || it instanceof L2PcVectorOperand && ((L2PcVectorOperand)it).getEdges().contains(edge2);
                if (!bl4) continue;
                n = index$iv2;
                break block7;
            }
            n = -1;
        }
        int operandIndex = n;
        L2NamedOperandType type2 = types[operandIndex];
        StringBuilder $this$edge_u24lambda_u2d5 = index$iv2 = new StringBuilder();
        boolean bl = false;
        Pair[] pairArray = new Pair[]{TuplesKt.to("border", "0"), TuplesKt.to("cellspacing", "0")};
        Strings.INSTANCE.tag($this$edge_u24lambda_u2d5, "table", pairArray, (Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(this, edge2, writer, type2){
            final /* synthetic */ L2ControlFlowGraphVisualizer this$0;
            final /* synthetic */ L2PcOperand $edge;
            final /* synthetic */ DotWriter.GraphWriter $writer;
            final /* synthetic */ L2NamedOperandType $type;
            {
                this.this$0 = $receiver;
                this.$edge = $edge;
                this.$writer = $writer;
                this.$type = $type;
                super(1);
            }

            public final void invoke(@NotNull StringBuilder $this$tag) {
                Intrinsics.checkNotNullParameter($this$tag, "$this$tag");
                Strings.INSTANCE.tag($this$tag, "tr", new Pair[0], (Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(this.this$0, this.$edge, this.$writer, this.$type){
                    final /* synthetic */ L2ControlFlowGraphVisualizer this$0;
                    final /* synthetic */ L2PcOperand $edge;
                    final /* synthetic */ DotWriter.GraphWriter $writer;
                    final /* synthetic */ L2NamedOperandType $type;
                    {
                        this.this$0 = $receiver;
                        this.$edge = $edge;
                        this.$writer = $writer;
                        this.$type = $type;
                        super(1);
                    }

                    public final void invoke(@NotNull StringBuilder $this$tag) {
                        Intrinsics.checkNotNullParameter($this$tag, "$this$tag");
                        Pair[] pairArray = new Pair[]{TuplesKt.to("balign", "left")};
                        Strings.INSTANCE.tag($this$tag, "td", pairArray, (Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(this.this$0, this.$edge, this.$writer, this.$type){
                            final /* synthetic */ L2ControlFlowGraphVisualizer this$0;
                            final /* synthetic */ L2PcOperand $edge;
                            final /* synthetic */ DotWriter.GraphWriter $writer;
                            final /* synthetic */ L2NamedOperandType $type;
                            {
                                this.this$0 = $receiver;
                                this.$edge = $edge;
                                this.$writer = $writer;
                                this.$type = $type;
                                super(1);
                            }

                            public final void invoke(@NotNull StringBuilder $this$tag) {
                                Intrinsics.checkNotNullParameter($this$tag, "$this$tag");
                                Pair[] pairArray = new Pair[]{TuplesKt.to("face", "Helvetica")};
                                Strings.INSTANCE.tag($this$tag, "font", pairArray, (Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(this.$type){
                                    final /* synthetic */ L2NamedOperandType $type;
                                    {
                                        this.$type = $type;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull StringBuilder $this$tag) {
                                        Intrinsics.checkNotNullParameter($this$tag, "$this$tag");
                                        Strings.INSTANCE.tag($this$tag, "b", new Pair[0], (Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(this.$type){
                                            final /* synthetic */ L2NamedOperandType $type;
                                            {
                                                this.$type = $type;
                                                super(1);
                                            }

                                            public final void invoke(@NotNull StringBuilder $this$tag) {
                                                Intrinsics.checkNotNullParameter($this$tag, "$this$tag");
                                                $this$tag.append(avail.optimizer.L2ControlFlowGraphVisualizer$Companion.access$escape(L2ControlFlowGraphVisualizer.Companion, this.$type.name()));
                                            }
                                        });
                                    }
                                });
                                $this$tag.append("<br/>");
                                if ((L2ControlFlowGraphVisualizer.access$getVisualizeLiveness$p(this.this$0) || L2ControlFlowGraphVisualizer.access$getVisualizeManifest$p(this.this$0)) && this.$edge.getForcedClampedEntities() != null) {
                                    Strings.INSTANCE.tag($this$tag, "i", new Pair[0], edge.edgeLabel.1.2.INSTANCE);
                                    $this$tag.append("<br/>");
                                    Strings.INSTANCE.tag($this$tag, "b", new Pair[0], (Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(this.$edge){
                                        final /* synthetic */ L2PcOperand $edge;
                                        {
                                            this.$edge = $edge;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull StringBuilder $this$tag) {
                                            Intrinsics.checkNotNullParameter($this$tag, "$this$tag");
                                            $this$tag.append(Strings.INSTANCE.repeated("&nbsp;", 4));
                                            $this$tag.append(avail.optimizer.L2ControlFlowGraphVisualizer$Companion.access$escape(L2ControlFlowGraphVisualizer.Companion, this.$edge.getForcedClampedEntities()));
                                        }
                                    });
                                    $this$tag.append("<br/>");
                                }
                                if (L2ControlFlowGraphVisualizer.access$getVisualizeLiveness$p(this.this$0)) {
                                    if (!((Collection)this.$edge.getAlwaysLiveInRegisters()).isEmpty()) {
                                        Strings.INSTANCE.tag($this$tag, "i", new Pair[0], edge.edgeLabel.1.4.INSTANCE);
                                        $this$tag.append("<br/>");
                                        Strings.INSTANCE.tag($this$tag, "b", new Pair[0], (Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(this.$edge){
                                            final /* synthetic */ L2PcOperand $edge;
                                            {
                                                this.$edge = $edge;
                                                super(1);
                                            }

                                            public final void invoke(@NotNull StringBuilder $this$tag) {
                                                Intrinsics.checkNotNullParameter($this$tag, "$this$tag");
                                                $this$tag.append(Strings.INSTANCE.repeated("&nbsp;", 4));
                                                Iterable $this$sortedBy$iv = this.$edge.getAlwaysLiveInRegisters();
                                                boolean $i$f$sortedBy = false;
                                                CollectionsKt.joinTo$default(CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                                                    public final int compare(T a, T b) {
                                                        L2Register it = (L2Register)a;
                                                        boolean bl = false;
                                                        Comparable comparable = Integer.valueOf(it.finalIndex());
                                                        it = (L2Register)b;
                                                        Comparable comparable2 = comparable;
                                                        bl = false;
                                                        return ComparisonsKt.compareValues(comparable2, it.finalIndex());
                                                    }
                                                }), $this$tag, ", ", null, null, 0, null, edge.edgeLabel.1.2.INSTANCE, 60, null);
                                            }
                                        });
                                        $this$tag.append("<br/>");
                                    }
                                    Set<L2Register> notAlwaysLiveInRegisters = CollectionsKt.toMutableSet((Iterable)this.$edge.getSometimesLiveInRegisters());
                                    notAlwaysLiveInRegisters.removeAll((Collection)this.$edge.getAlwaysLiveInRegisters());
                                    if (!((Collection)notAlwaysLiveInRegisters).isEmpty()) {
                                        Strings.INSTANCE.tag($this$tag, "i", new Pair[0], edge.edgeLabel.1.6.INSTANCE);
                                        $this$tag.append("<br/>");
                                        Strings.INSTANCE.tag($this$tag, "b", new Pair[0], (Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(notAlwaysLiveInRegisters){
                                            final /* synthetic */ Set<L2Register> $notAlwaysLiveInRegisters;
                                            {
                                                this.$notAlwaysLiveInRegisters = $notAlwaysLiveInRegisters;
                                                super(1);
                                            }

                                            public final void invoke(@NotNull StringBuilder $this$tag) {
                                                Intrinsics.checkNotNullParameter($this$tag, "$this$tag");
                                                $this$tag.append(Strings.INSTANCE.repeated("&nbsp;", 4));
                                                Iterable $this$sortedBy$iv = this.$notAlwaysLiveInRegisters;
                                                boolean $i$f$sortedBy = false;
                                                CollectionsKt.joinTo$default(CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                                                    public final int compare(T a, T b) {
                                                        L2Register it = (L2Register)a;
                                                        boolean bl = false;
                                                        Comparable comparable = Integer.valueOf(it.finalIndex());
                                                        it = (L2Register)b;
                                                        Comparable comparable2 = comparable;
                                                        bl = false;
                                                        return ComparisonsKt.compareValues(comparable2, it.finalIndex());
                                                    }
                                                }), $this$tag, ", ", null, null, 0, null, edge.edgeLabel.1.2.INSTANCE, 60, null);
                                            }
                                        });
                                        $this$tag.append("<br/>");
                                    }
                                }
                                L2ValueManifest manifest2 = this.$edge.manifestOrNull();
                                if (L2ControlFlowGraphVisualizer.access$getVisualizeManifest$p(this.this$0) && manifest2 != null) {
                                    L2ControlFlowGraphVisualizer.access$manifest(this.this$0, $this$tag, manifest2, this.$writer);
                                }
                            }
                        });
                    }
                });
            }
        });
        String string2 = index$iv2.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        String edgeLabel2 = string2;
        try {
            int sourceSubscript = sourceBlock.instructions().indexOf(sourceInstruction) + 1;
            writer.edge(edge2.isBackward() ? DotWriter.Companion.node(this.basicBlockName(sourceBlock), String.valueOf(sourceSubscript), DotWriter.CompassPoint.E) : DotWriter.Companion.node(this.basicBlockName(sourceBlock), String.valueOf(sourceSubscript)), edge2.isBackward() ? DotWriter.Companion.node(this.basicBlockName(targetBlock), "1") : DotWriter.Companion.node(this.basicBlockName(targetBlock)), (Function1<? super DotWriter.AttributeWriter, Unit>)new Function1<DotWriter.AttributeWriter, Unit>(edgeCounter, started, isTargetTheUnreachableBlock, edge2, sourceBlock, type2, edgeLabel2){
                final /* synthetic */ AtomicInteger $edgeCounter;
                final /* synthetic */ boolean $started;
                final /* synthetic */ boolean $isTargetTheUnreachableBlock;
                final /* synthetic */ L2PcOperand $edge;
                final /* synthetic */ L2BasicBlock $sourceBlock;
                final /* synthetic */ L2NamedOperandType $type;
                final /* synthetic */ String $edgeLabel;
                {
                    this.$edgeCounter = $edgeCounter;
                    this.$started = $started;
                    this.$isTargetTheUnreachableBlock = $isTargetTheUnreachableBlock;
                    this.$edge = $edge;
                    this.$sourceBlock = $sourceBlock;
                    this.$type = $type;
                    this.$edgeLabel = $edgeLabel;
                    super(1);
                }

                public final void invoke(@NotNull DotWriter.AttributeWriter attr) {
                    Intrinsics.checkNotNullParameter(attr, "attr");
                    attr.attribute("id", String.valueOf(this.$edgeCounter.getAndIncrement()));
                    if (!this.$started) {
                        attr.attribute("color", "#4040ff/8080ff");
                        attr.attribute("style", "dotted");
                    } else if (this.$isTargetTheUnreachableBlock) {
                        attr.attribute("color", "#804040/c06060");
                        attr.attribute("style", "dotted");
                    } else if (this.$edge.isBackward()) {
                        attr.attribute("constraint", "false");
                        attr.attribute("color", this.$sourceBlock.getZone() == null ? "#9070ff/6050ff" : "#90f0a0/60ff70");
                        attr.attribute("style", "dashed");
                    } else {
                        L2NamedOperandType.Purpose purpose = this.$type.purpose();
                        Intrinsics.checkNotNull((Object)((Object)purpose));
                        switch (edge.WhenMappings.$EnumSwitchMapping$0[purpose.ordinal()]) {
                            case 1: {
                                break;
                            }
                            case 2: {
                                attr.attribute("color", "#e54545/c03030");
                                break;
                            }
                            case 3: {
                                attr.attribute("style", "dashed");
                                break;
                            }
                            case 4: {
                                attr.attribute("style", "dashed");
                                attr.attribute("color", "#6aaf6a");
                                break;
                            }
                            case 5: {
                                attr.attribute("style", "dashed");
                                attr.attribute("color", "#6080ff");
                            }
                        }
                    }
                    attr.attribute("label", this.$edgeLabel);
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private final void manifest(StringBuilder $this$manifest, L2ValueManifest manifest2, DotWriter.GraphWriter writer) {
        L2Synonym[] synonyms = manifest2.synonymsArray();
        if (!(synonyms.length == 0)) {
            Strings.INSTANCE.tag($this$manifest, "i", new Pair[0], manifest.1.INSTANCE);
            ArraysKt.sort((Object[])synonyms);
            for (L2Synonym synonym : synonyms) {
                TypeRestriction restriction = manifest2.restrictionFor(synonym.pickSemanticValue());
                Iterable<L2Register> defs = manifest2.definitionsForDescribing(synonym);
                EnumSet<L2Register.RegisterKind> kindsOfRegisters = EnumSet.noneOf(L2Register.RegisterKind.class);
                for (L2Register l2Register : defs) {
                    kindsOfRegisters.add(l2Register.getRegisterKind());
                }
                Function1 body2 = new Function1<StringBuilder, Unit>(synonym, restriction, defs){
                    final /* synthetic */ L2Synonym $synonym;
                    final /* synthetic */ TypeRestriction $restriction;
                    final /* synthetic */ Iterable<L2Register> $defs;
                    {
                        this.$synonym = $synonym;
                        this.$restriction = $restriction;
                        this.$defs = $defs;
                        super(1);
                    }

                    public final void invoke(@NotNull StringBuilder $this$null) {
                        Intrinsics.checkNotNullParameter($this$null, "$this$null");
                        $this$null.append("<br/>");
                        $this$null.append(Strings.INSTANCE.repeated("&nbsp;", 4));
                        $this$null.append(avail.optimizer.L2ControlFlowGraphVisualizer$Companion.access$escape(L2ControlFlowGraphVisualizer.Companion, this.$synonym));
                        $this$null.append("<br/>");
                        $this$null.append(Strings.INSTANCE.repeated("&nbsp;", 8));
                        $this$null.append(":&nbsp;");
                        $this$null.append(avail.optimizer.L2ControlFlowGraphVisualizer$Companion.access$escape(L2ControlFlowGraphVisualizer.Companion, this.$restriction));
                        $this$null.append("<br/>");
                        $this$null.append(Strings.INSTANCE.repeated("&nbsp;", 8));
                        CollectionsKt.joinTo$default(this.$defs, $this$null, ", ", "in {", "}", 0, null, manifest.body.1.INSTANCE, 48, null);
                    }
                };
                if (Intrinsics.areEqual(restriction.kinds(), kindsOfRegisters)) {
                    body2.invoke($this$manifest);
                    continue;
                }
                Pair[] pairArray = new Pair[]{TuplesKt.to("color", writer.adjust(errorTextColor))};
                Strings.INSTANCE.tag($this$manifest, "font", pairArray, body2);
            }
        }
        Map<L2SemanticValue, List<L2Instruction>> postponements = manifest2.getPostponedInstructions();
        boolean bl = false;
        $this$manifest.append("<br/>");
        Strings.INSTANCE.tag($this$manifest, "i", new Pair[0], manifest.2.1.INSTANCE);
        $this$manifest.append("<br/>");
        Iterable $this$sortedBy$iv = postponements.entrySet();
        boolean $i$f$sortedBy = false;
        List sortedSubmap = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (L2SemanticValue)it.getKey();
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((L2SemanticValue)it.getKey()));
            }
        });
        Iterable $this$forEach$iv = sortedSubmap;
        boolean $i$f$forEach = false;
        for (L2Register l2Register : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)((Object)l2Register);
            boolean bl2 = false;
            L2SemanticValue semanticValue = (L2SemanticValue)entry.getKey();
            List oldInstructions = (List)entry.getValue();
            Pair[] pairArray = new Pair[]{TuplesKt.to("color", writer.adjust(errorTextColor))};
            Strings.INSTANCE.tag($this$manifest, "font", pairArray, (Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(semanticValue, (List<L2Instruction>)oldInstructions){
                final /* synthetic */ L2SemanticValue $semanticValue;
                final /* synthetic */ List<L2Instruction> $oldInstructions;
                {
                    this.$semanticValue = $semanticValue;
                    this.$oldInstructions = $oldInstructions;
                    super(1);
                }

                public final void invoke(@NotNull StringBuilder $this$tag) {
                    Intrinsics.checkNotNullParameter($this$tag, "$this$tag");
                    $this$tag.append(Strings.INSTANCE.repeated("&nbsp;", 4));
                    $this$tag.append((Object)((Object)this.$semanticValue.getKind()));
                    $this$tag.append("/");
                    $this$tag.append(avail.optimizer.L2ControlFlowGraphVisualizer$Companion.access$escape(L2ControlFlowGraphVisualizer.Companion, this.$semanticValue));
                    $this$tag.append(" = ");
                    switch (this.$oldInstructions.size()) {
                        case 0: {
                            $this$tag.append("ERROR: No instructions");
                            break;
                        }
                        case 1: {
                            $this$tag.append(avail.optimizer.L2ControlFlowGraphVisualizer$Companion.access$escape(L2ControlFlowGraphVisualizer.Companion, this.$oldInstructions.get(0)));
                            break;
                        }
                        default: {
                            Iterable $this$forEach$iv = this.$oldInstructions;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                L2Instruction it = (L2Instruction)element$iv;
                                boolean bl = false;
                                $this$tag.append("<br/>");
                                $this$tag.append(Strings.INSTANCE.repeated("&nbsp;", 8));
                                $this$tag.append(avail.optimizer.L2ControlFlowGraphVisualizer$Companion.access$escape(L2ControlFlowGraphVisualizer.Companion, it));
                            }
                        }
                    }
                    $this$tag.append("<br/>");
                }
            });
        }
    }

    private final void computeClusters(Iterable<L2BasicBlock> blocks) {
        for (L2BasicBlock block : blocks) {
            L2ControlFlowGraph.Zone zone = block.getZone();
            if (zone == null) continue;
            this.blocksByZone.computeIfAbsent(zone, L2ControlFlowGraphVisualizer::computeClusters$lambda-9).add(block);
        }
    }

    private final void cluster(L2ControlFlowGraph.Zone zone, DotWriter.GraphWriter graph, Function1<? super L2BasicBlock, Boolean> isStarted) throws IOException {
        int n = this.subgraphNumber;
        this.subgraphNumber = n + 1;
        graph.subgraph("cluster_" + n, (Function1<? super DotWriter.GraphWriter, Unit>)new Function1<DotWriter.GraphWriter, Unit>(zone, this, isStarted){
            final /* synthetic */ L2ControlFlowGraph.Zone $zone;
            final /* synthetic */ L2ControlFlowGraphVisualizer this$0;
            final /* synthetic */ Function1<L2BasicBlock, Boolean> $isStarted;
            {
                this.$zone = $zone;
                this.this$0 = $receiver;
                this.$isStarted = $isStarted;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull DotWriter.GraphWriter gw) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter(gw, "gw");
                gw.attribute("fontcolor", "#000000/ffffff");
                gw.attribute("labeljust", "l");
                gw.attribute("label", this.$zone.getZoneName());
                gw.attribute("color", this.$zone.getZoneType().getColor());
                gw.attribute("bgcolor", this.$zone.getZoneType().getBgcolor());
                gw.defaultAttributeBlock(DotWriter.DefaultAttributeBlockType.GRAPH, cluster.1.INSTANCE);
                V v = L2ControlFlowGraphVisualizer.access$getBlocksByZone$p(this.this$0).get(this.$zone);
                Intrinsics.checkNotNull(v);
                Iterable iterable = (Iterable)v;
                L2ControlFlowGraphVisualizer l2ControlFlowGraphVisualizer = this.this$0;
                Function1<L2BasicBlock, Boolean> function1 = this.$isStarted;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    L2BasicBlock block = (L2BasicBlock)element$iv;
                    boolean bl = false;
                    L2ControlFlowGraphVisualizer.access$basicBlock(l2ControlFlowGraphVisualizer, block, gw, function1.invoke(block));
                }
            }
        });
    }

    public final void visualize() {
        DotWriter writer = new DotWriter(this.name, true, this.charactersPerLine, this.accumulator, true, "The Avail Foundation");
        try {
            this.banner(writer);
            writer.graph((Function1<? super DotWriter.GraphWriter, Unit>)new Function1<DotWriter.GraphWriter, Unit>(this){
                final /* synthetic */ L2ControlFlowGraphVisualizer this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull DotWriter.GraphWriter graph) {
                    L2PcOperand it;
                    boolean $i$f$forEach;
                    Iterable $this$forEach$iv$iv;
                    L2BasicBlock p0;
                    boolean bl;
                    T element$iv$iv;
                    Iterable $this$deepForEach$iv;
                    void $this$filterTo$iv$iv;
                    Object it2;
                    L2BasicBlock it3;
                    void $this$filterTo$iv$iv2;
                    Iterable $this$filter$iv;
                    Intrinsics.checkNotNullParameter(graph, "graph");
                    graph.attribute("bgcolor", "#00ffff/000000");
                    graph.attribute("rankdir", "TB");
                    graph.attribute("newrank", "true");
                    graph.attribute("overlap", "false");
                    graph.attribute("splines", "true");
                    graph.defaultAttributeBlock(DotWriter.DefaultAttributeBlockType.NODE, visualize.1.INSTANCE);
                    graph.defaultAttributeBlock(DotWriter.DefaultAttributeBlockType.EDGE, visualize.2.INSTANCE);
                    Set<T> startedBlocks = CollectionsKt.toSet((Iterable)L2ControlFlowGraphVisualizer.access$getControlFlowGraph$p(this.this$0).getBasicBlockOrder());
                    Set unstartedBlocks = new LinkedHashSet<E>();
                    Object $this$forEach$iv = startedBlocks;
                    boolean $i$f$forEach2 = false;
                    Iterator<T> iterator2 = $this$forEach$iv.iterator();
                    while (iterator2.hasNext()) {
                        T element$iv = iterator2.next();
                        L2BasicBlock startedBlock = (L2BasicBlock)element$iv;
                        boolean bl2 = false;
                        SequencesKt.toCollection(SequencesKt.filterNot(SequencesKt.map(CollectionsKt.asSequence((Iterable)startedBlock.successorEdges()), visualize.3.1.INSTANCE), (Function1)new Function1<L2BasicBlock, Boolean>(startedBlocks){

                            @NotNull
                            public final Boolean invoke(@NotNull L2BasicBlock p0) {
                                Intrinsics.checkNotNullParameter(p0, "p0");
                                return ((Set)this.receiver).contains(p0);
                            }
                        }), (Collection)unstartedBlocks);
                    }
                    L2ControlFlowGraphVisualizer.access$computeClusters(this.this$0, startedBlocks);
                    L2ControlFlowGraphVisualizer.access$computeClusters(this.this$0, unstartedBlocks);
                    for (L2ControlFlowGraph.Zone zone : L2ControlFlowGraphVisualizer.access$getBlocksByZone$p(this.this$0).keySet()) {
                        L2ControlFlowGraphVisualizer.access$cluster(this.this$0, zone, graph, new Function1<L2BasicBlock, Boolean>((Set<L2BasicBlock>)unstartedBlocks){
                            final /* synthetic */ Set<L2BasicBlock> $unstartedBlocks;
                            {
                                this.$unstartedBlocks = $unstartedBlocks;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull L2BasicBlock it) {
                                Intrinsics.checkNotNullParameter(it, "it");
                                return !this.$unstartedBlocks.contains(it);
                            }
                        });
                    }
                    $this$forEach$iv = L2ControlFlowGraphVisualizer.access$getControlFlowGraph$p(this.this$0).getBasicBlockOrder();
                    boolean $i$f$filter22 = false;
                    iterator2 = $this$filter$iv;
                    Iterator<T> destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv2 : $this$filterTo$iv$iv2) {
                        it3 = (L2BasicBlock)element$iv$iv2;
                        boolean bl3 = false;
                        if (!(it3.getZone() == null)) continue;
                        destination$iv$iv.add(element$iv$iv2);
                    }
                    $this$filter$iv = (List)((Object)destination$iv$iv);
                    L2ControlFlowGraphVisualizer $i$f$filter22 = this.this$0;
                    boolean $i$f$forEach222 = false;
                    destination$iv$iv = $this$forEach$iv.iterator();
                    while (destination$iv$iv.hasNext()) {
                        E element$iv = destination$iv$iv.next();
                        it2 = (L2BasicBlock)element$iv;
                        boolean bl4 = false;
                        L2ControlFlowGraphVisualizer.access$basicBlock($i$f$filter22, (L2BasicBlock)it2, graph, true);
                    }
                    $this$forEach$iv = unstartedBlocks;
                    boolean $i$f$filter32 = false;
                    Iterable $i$f$forEach222 = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (E element$iv$iv3 : $this$filterTo$iv$iv) {
                        it3 = (L2BasicBlock)element$iv$iv3;
                        boolean bl5 = false;
                        if (!(it3.getZone() == null)) continue;
                        destination$iv$iv.add(element$iv$iv3);
                    }
                    $this$filter$iv = (List)((Object)destination$iv$iv);
                    Object $i$f$filter32 = this.this$0;
                    boolean $i$f$forEach3 = false;
                    destination$iv$iv = $this$forEach$iv.iterator();
                    while (destination$iv$iv.hasNext()) {
                        T element$iv = destination$iv$iv.next();
                        it2 = (L2BasicBlock)element$iv;
                        boolean bl6 = false;
                        L2ControlFlowGraphVisualizer.access$basicBlock((L2ControlFlowGraphVisualizer)$i$f$filter32, (L2BasicBlock)it2, graph, false);
                    }
                    AtomicInteger edgeCounter = new AtomicInteger(1);
                    $i$f$filter32 = L2ControlFlowGraphVisualizer.access$getControlFlowGraph$p(this.this$0).getBasicBlockOrder();
                    L2ControlFlowGraphVisualizer l2ControlFlowGraphVisualizer = this.this$0;
                    boolean $i$f$deepForEach = false;
                    Iterable $this$forEach$iv$iv2 = $this$deepForEach$iv;
                    boolean $i$f$forEach4 = false;
                    Iterator<T> iterator3 = $this$forEach$iv$iv2.iterator();
                    while (iterator3.hasNext()) {
                        T b$iv = element$iv$iv = iterator3.next();
                        bl = false;
                        p0 = (L2BasicBlock)b$iv;
                        boolean bl7 = false;
                        $this$forEach$iv$iv = p0.predecessorEdges();
                        $i$f$forEach = false;
                        for (T element$iv$iv4 : $this$forEach$iv$iv) {
                            it = (L2PcOperand)element$iv$iv4;
                            boolean bl8 = false;
                            L2ControlFlowGraphVisualizer.access$edge(l2ControlFlowGraphVisualizer, it, graph, true, edgeCounter);
                        }
                    }
                    $this$deepForEach$iv = unstartedBlocks;
                    l2ControlFlowGraphVisualizer = this.this$0;
                    $i$f$deepForEach = false;
                    $this$forEach$iv$iv2 = $this$deepForEach$iv;
                    $i$f$forEach4 = false;
                    iterator3 = $this$forEach$iv$iv2.iterator();
                    while (iterator3.hasNext()) {
                        T b$iv = element$iv$iv = iterator3.next();
                        bl = false;
                        p0 = (L2BasicBlock)b$iv;
                        boolean bl9 = false;
                        $this$forEach$iv$iv = p0.predecessorEdges();
                        $i$f$forEach = false;
                        for (T element$iv$iv4 : $this$forEach$iv$iv) {
                            it = (L2PcOperand)element$iv$iv4;
                            boolean bl10 = false;
                            L2ControlFlowGraphVisualizer.access$edge(l2ControlFlowGraphVisualizer, it, graph, false, edgeCounter);
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private final String instruction(L2Instruction instruction2, DotWriter.GraphWriter writer) {
        Object object;
        StringBuilder stringBuilder;
        StringBuilder $this$instruction_u24lambda_u2d11 = stringBuilder = new StringBuilder();
        boolean bl = false;
        L2Operand[] $this$forEach$iv = instruction2.getOperands();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            L2Operand element$iv;
            L2Operand operand = element$iv = $this$forEach$iv[i];
            boolean bl2 = false;
            if (operand.getOperandType() != L2OperandType.COMMENT) continue;
            object = new Pair[]{TuplesKt.to("face", "Helvetica"), TuplesKt.to("color", writer.adjust(operand.isMisconnected(), errorTextColor, commentTextColor))};
            Strings.INSTANCE.tag($this$instruction_u24lambda_u2d11, "font", (Pair<String, String>[])object, (Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(operand){
                final /* synthetic */ L2Operand $operand;
                {
                    this.$operand = $operand;
                    super(1);
                }

                public final void invoke(@NotNull StringBuilder $this$tag) {
                    Intrinsics.checkNotNullParameter($this$tag, "$this$tag");
                    Strings.INSTANCE.tag($this$tag, "i", new Pair[0], (Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(this.$operand){
                        final /* synthetic */ L2Operand $operand;
                        {
                            this.$operand = $operand;
                            super(1);
                        }

                        public final void invoke(@NotNull StringBuilder $this$tag) {
                            Intrinsics.checkNotNullParameter($this$tag, "$this$tag");
                            $this$tag.append(avail.optimizer.L2ControlFlowGraphVisualizer$Companion.access$escape(L2ControlFlowGraphVisualizer.Companion, this.$operand));
                        }
                    });
                }
            });
            $this$instruction_u24lambda_u2d11.append("<br/>");
        }
        int escapeIndex = $this$instruction_u24lambda_u2d11.length();
        EnumSet<Enum> enumSet = EnumSet.complementOf(EnumSet.of((Enum)L2OperandType.PC, (Enum)L2OperandType.COMMENT));
        Intrinsics.checkNotNullExpressionValue(enumSet, "complementOf(\n\t\t\t\tEnumSe\u2026, L2OperandType.COMMENT))");
        Set desiredTypes = enumSet;
        if (instruction2.getOperation() == L2_JUMP.INSTANCE && instruction2.getOffset() != -1 && L2_JUMP.jumpTarget(instruction2).offset() == instruction2.getOffset()) {
            L2PcOperand edge2 = L2_JUMP.jumpTarget(instruction2);
            Pair[] pairArray = new Pair[]{TuplesKt.to("color", writer.adjust(edge2.isMisconnected(), errorTextColor, "#404040/808080"))};
            Strings.INSTANCE.tag($this$instruction_u24lambda_u2d11, "font", pairArray, (Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(this, instruction2, (Set<? extends L2OperandType>)desiredTypes){
                final /* synthetic */ L2ControlFlowGraphVisualizer this$0;
                final /* synthetic */ L2Instruction $instruction;
                final /* synthetic */ Set<L2OperandType> $desiredTypes;
                {
                    this.this$0 = $receiver;
                    this.$instruction = $instruction;
                    this.$desiredTypes = $desiredTypes;
                    super(1);
                }

                public final void invoke(@NotNull StringBuilder $this$tag) {
                    Intrinsics.checkNotNullParameter($this$tag, "$this$tag");
                    Strings.INSTANCE.tag($this$tag, "i", new Pair[0], (Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(this.this$0, this.$instruction, this.$desiredTypes){
                        final /* synthetic */ L2ControlFlowGraphVisualizer this$0;
                        final /* synthetic */ L2Instruction $instruction;
                        final /* synthetic */ Set<L2OperandType> $desiredTypes;
                        {
                            this.this$0 = $receiver;
                            this.$instruction = $instruction;
                            this.$desiredTypes = $desiredTypes;
                            super(1);
                        }

                        public final void invoke(@NotNull StringBuilder $this$tag) {
                            Intrinsics.checkNotNullParameter($this$tag, "$this$tag");
                            int escapableStart = $this$tag.length();
                            if (L2ControlFlowGraphVisualizer.access$getVisualizeRegisterDescriptions$p(this.this$0)) {
                                this.$instruction.getOperation().appendToWithWarnings(this.$instruction, this.$desiredTypes, $this$tag, instruction.1.1.INSTANCE);
                            } else {
                                this.$instruction.getOperation().simpleAppendTo(this.$instruction, $this$tag);
                            }
                            $this$tag.replace(escapableStart, $this$tag.length(), avail.optimizer.L2ControlFlowGraphVisualizer$Companion.access$escape(L2ControlFlowGraphVisualizer.Companion, $this$tag.substring(escapableStart)));
                        }
                    });
                }
            });
            $this$instruction_u24lambda_u2d11.append("<br/>");
        } else {
            boolean bl3;
            ArrayDeque<Integer> styleChanges = new ArrayDeque<Integer>();
            if (this.visualizeRegisterDescriptions) {
                instruction2.appendToWithWarnings($this$instruction_u24lambda_u2d11, desiredTypes, (Function1<? super Boolean, Unit>)new Function1<Boolean, Unit>(styleChanges, $this$instruction_u24lambda_u2d11){
                    final /* synthetic */ ArrayDeque<Integer> $styleChanges;
                    final /* synthetic */ StringBuilder $this_buildString;
                    {
                        this.$styleChanges = $styleChanges;
                        this.$this_buildString = $receiver;
                        super(1);
                    }

                    public final void invoke(boolean it) {
                        boolean bl;
                        boolean bl2 = bl = it == (this.$styleChanges.size() % 2 == 0);
                        if (_Assertions.ENABLED && !bl) {
                            String string2 = "Assertion failed";
                            throw new AssertionError((Object)string2);
                        }
                        this.$styleChanges.add(this.$this_buildString.length());
                    }
                });
            } else {
                instruction2.getOperation().simpleAppendTo(instruction2, $this$instruction_u24lambda_u2d11);
            }
            styleChanges.add($this$instruction_u24lambda_u2d11.length());
            StringBuilder escaped = new StringBuilder();
            boolean warningFlag = false;
            int regionStart = escapeIndex;
            while (!styleChanges.isEmpty()) {
                Integer here = styleChanges.remove();
                Intrinsics.checkNotNullExpressionValue(here, "here");
                escaped.append(L2ControlFlowGraphVisualizer.Companion.escape($this$instruction_u24lambda_u2d11.substring(regionStart, here)));
                if (!styleChanges.isEmpty()) {
                    boolean bl4 = warningFlag = !warningFlag;
                    if (warningFlag) {
                        escaped.append("<font color=\"").append(writer.adjust(errorTextColor)).append("\"><i>");
                    } else {
                        escaped.append("</i></font>");
                    }
                }
                regionStart = here;
            }
            boolean bl5 = bl3 = regionStart == $this$instruction_u24lambda_u2d11.length();
            if (_Assertions.ENABLED && !bl3) {
                object = "Assertion failed";
                throw new AssertionError(object);
            }
            boolean bl6 = bl3 = !warningFlag;
            if (_Assertions.ENABLED && !bl3) {
                object = "Assertion failed";
                throw new AssertionError(object);
            }
            $this$instruction_u24lambda_u2d11.replace(escapeIndex, $this$instruction_u24lambda_u2d11.length(), escaped.toString());
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    private static final Set computeClusters$lambda-9(L2ControlFlowGraph.Zone it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new LinkedHashSet();
    }

    public static final /* synthetic */ Map access$getBlocksByZone$p(L2ControlFlowGraphVisualizer $this) {
        return $this.blocksByZone;
    }

    public static final /* synthetic */ void access$basicBlock(L2ControlFlowGraphVisualizer $this, L2BasicBlock basicBlock2, DotWriter.GraphWriter writer, boolean started) {
        $this.basicBlock(basicBlock2, writer, started);
    }

    public static final /* synthetic */ L2ControlFlowGraph access$getControlFlowGraph$p(L2ControlFlowGraphVisualizer $this) {
        return $this.controlFlowGraph;
    }

    public static final /* synthetic */ void access$computeClusters(L2ControlFlowGraphVisualizer $this, Iterable blocks) {
        $this.computeClusters(blocks);
    }

    public static final /* synthetic */ void access$cluster(L2ControlFlowGraphVisualizer $this, L2ControlFlowGraph.Zone zone, DotWriter.GraphWriter graph, Function1 isStarted) {
        $this.cluster(zone, graph, isStarted);
    }

    public static final /* synthetic */ void access$edge(L2ControlFlowGraphVisualizer $this, L2PcOperand edge2, DotWriter.GraphWriter writer, boolean started, AtomicInteger edgeCounter) {
        $this.edge(edge2, writer, started, edgeCounter);
    }

    public static final /* synthetic */ Map access$getBasicBlockNumbers$p(L2ControlFlowGraphVisualizer $this) {
        return $this.basicBlockNumbers;
    }

    public static final /* synthetic */ String access$instruction(L2ControlFlowGraphVisualizer $this, L2Instruction instruction2, DotWriter.GraphWriter writer) {
        return $this.instruction(instruction2, writer);
    }

    public static final /* synthetic */ boolean access$getVisualizeLiveness$p(L2ControlFlowGraphVisualizer $this) {
        return $this.visualizeLiveness;
    }

    public static final /* synthetic */ boolean access$getVisualizeManifest$p(L2ControlFlowGraphVisualizer $this) {
        return $this.visualizeManifest;
    }

    public static final /* synthetic */ void access$manifest(L2ControlFlowGraphVisualizer $this, StringBuilder $receiver, L2ValueManifest manifest2, DotWriter.GraphWriter writer) {
        $this.manifest($receiver, manifest2, writer);
    }

    public static final /* synthetic */ boolean access$getVisualizeRegisterDescriptions$p(L2ControlFlowGraphVisualizer $this) {
        return $this.visualizeRegisterDescriptions;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lavail/optimizer/L2ControlFlowGraphVisualizer$Companion;", "", "()V", "commentTextColor", "", "errorTextColor", "matchUglies", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "escape", "value", "avail"})
    public static final class Companion {
        private Companion() {
        }

        private final String escape(Object value) {
            int cp;
            StringBuilder stringBuilder;
            StringBuilder $this$escape_u24lambda_u2d0 = stringBuilder = new StringBuilder();
            boolean bl = false;
            String s = String.valueOf(value);
            int limit = s.length();
            for (int i = 0; i < limit; i += Character.charCount(cp)) {
                cp = s.codePointAt(i);
                if (cp > 127 || cp == 34 || cp == 60 || cp == 62 || cp == 38) {
                    $this$escape_u24lambda_u2d0.append("&#");
                    $this$escape_u24lambda_u2d0.append(cp);
                    $this$escape_u24lambda_u2d0.append(';');
                    continue;
                }
                if (cp == 10) {
                    $this$escape_u24lambda_u2d0.append("<br/>");
                    continue;
                }
                if (cp == 9) {
                    $this$escape_u24lambda_u2d0.append(Strings.INSTANCE.repeated("&nbsp;", 4));
                    continue;
                }
                $this$escape_u24lambda_u2d0.appendCodePoint(cp);
            }
            String string2 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

