/*
 * Decompiled with CFR 0.152.
 */
package avail.anvil.projects.manager;

import avail.anvil.AvailWorkbench;
import avail.anvil.SwingHelperKt;
import avail.anvil.icons.ProjectManagerIcons;
import avail.anvil.projects.GlobalAvailConfiguration;
import avail.anvil.projects.KnownAvailProject;
import avail.anvil.projects.manager.AvailProjectManagerWindow;
import avail.anvil.projects.manager.KnownProjectRow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.availlang.artifact.environment.project.AvailProject;
import org.availlang.json.UtilityKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u00101\u001a\u000202H\u0000\u00a2\u0006\u0002\b3J\u0006\u00104\u001a\u000202R\u0014\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0019\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001c\u001a\u00020\u0014\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001d\u0010\n\u001a\u0004\b\u001e\u0010\u0016R\u0011\u0010\u001f\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0016R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010*\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b+\u0010\u0010R\u0014\u0010,\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b-\u0010\nR\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lavail/anvil/projects/manager/KnownProjectsPanel;", "Ljavax/swing/JPanel;", "config", "Lavail/anvil/projects/GlobalAvailConfiguration;", "manager", "Lavail/anvil/projects/manager/AvailProjectManagerWindow;", "(Lavail/anvil/projects/GlobalAvailConfiguration;Lavail/anvil/projects/manager/AvailProjectManagerWindow;)V", "alphabetically", "Ljavax/swing/JRadioButton;", "getAlphabetically$annotations", "()V", "bottomPanel", "value", "", "byLastOpened", "setByLastOpened", "(Z)V", "getConfig$avail", "()Lavail/anvil/projects/GlobalAvailConfiguration;", "createButton", "Ljavax/swing/JButton;", "getCreateButton", "()Ljavax/swing/JButton;", "innerPanel", "lastOpened", "getLastOpened$annotations", "getManager$avail", "()Lavail/anvil/projects/manager/AvailProjectManagerWindow;", "openProjectButton", "getOpenProjectButton$annotations", "getOpenProjectButton", "preferences", "getPreferences", "projectList", "", "Lavail/anvil/projects/KnownAvailProject;", "rowMap", "", "", "Lavail/anvil/projects/manager/KnownProjectRow;", "scrollPane", "Ljavax/swing/JScrollPane;", "sortAscending", "setSortAscending", "sortButton", "getSortButton$annotations", "sortButtonGroup", "Ljavax/swing/ButtonGroup;", "topPanel", "repopulateProjects", "", "repopulateProjects$avail", "updateFavorite", "avail"})
public final class KnownProjectsPanel
extends JPanel {
    @NotNull
    private final GlobalAvailConfiguration config;
    @NotNull
    private final AvailProjectManagerWindow manager;
    @NotNull
    private final Map<String, KnownProjectRow> rowMap;
    @NotNull
    private List<KnownAvailProject> projectList;
    private boolean byLastOpened;
    private boolean sortAscending;
    @NotNull
    private final JPanel topPanel;
    @NotNull
    private final ButtonGroup sortButtonGroup;
    @NotNull
    private final JRadioButton alphabetically;
    @NotNull
    private final JRadioButton lastOpened;
    @NotNull
    private final JButton sortButton;
    @NotNull
    private final JPanel innerPanel;
    @NotNull
    private final JScrollPane scrollPane;
    @NotNull
    private final JButton openProjectButton;
    @NotNull
    private final JButton createButton;
    @NotNull
    private final JButton preferences;
    @NotNull
    private final JPanel bottomPanel;

    public KnownProjectsPanel(@NotNull GlobalAvailConfiguration config, @NotNull AvailProjectManagerWindow manager) {
        Serializable $this$bottomPanel_u24lambda_u2d22;
        JComponent $this$preferences_u24lambda_u2d21;
        JComponent $this$createButton_u24lambda_u2d19;
        JComponent $this$openProjectButton_u24lambda_u2d16;
        JComponent $this$scrollPane_u24lambda_u2d12;
        JComponent $this$innerPanel_u24lambda_u2d11;
        JComponent $this$sortButton_u24lambda_u2d9;
        JComponent $this$lastOpened_u24lambda_u2d6;
        JComponent $this$alphabetically_u24lambda_u2d4;
        JLabel jLabel;
        JComponent $this$topPanel_u24lambda_u2d2;
        Serializable serializable;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.config = config;
        this.manager = manager;
        this.rowMap = new LinkedHashMap();
        this.projectList = this.config.getKnownProjectsByLastOpenedDescending();
        this.byLastOpened = true;
        JPanel jPanel = serializable = new JPanel();
        KnownProjectsPanel knownProjectsPanel = this;
        boolean bl = false;
        $this$topPanel_u24lambda_u2d2.setLayout(new FlowLayout(0));
        $this$topPanel_u24lambda_u2d2.setMinimumSize(new Dimension(720, 50));
        $this$topPanel_u24lambda_u2d2.setPreferredSize(new Dimension(750, 50));
        $this$topPanel_u24lambda_u2d2.setMaximumSize(new Dimension(750, 50));
        JLabel $this$topPanel_u24lambda_u2d2_u24lambda_u2d1 = jLabel = new JLabel("Sort by: ");
        boolean bl2 = false;
        $this$topPanel_u24lambda_u2d2_u24lambda_u2d1.setFont($this$topPanel_u24lambda_u2d2_u24lambda_u2d1.getFont().deriveFont($this$topPanel_u24lambda_u2d2_u24lambda_u2d1.getFont().getStyle() | 1));
        JLabel sortLabel = jLabel;
        $this$topPanel_u24lambda_u2d2.add(sortLabel);
        knownProjectsPanel.topPanel = serializable;
        this.sortButtonGroup = new ButtonGroup();
        $this$topPanel_u24lambda_u2d2 = serializable = new JRadioButton("Alphabetically");
        knownProjectsPanel = this;
        boolean bl3 = false;
        ((AbstractButton)$this$alphabetically_u24lambda_u2d4).addActionListener(arg_0 -> KnownProjectsPanel.alphabetically$lambda-4$lambda-3(this, (JRadioButton)$this$alphabetically_u24lambda_u2d4, arg_0));
        this.sortButtonGroup.add((AbstractButton)$this$alphabetically_u24lambda_u2d4);
        this.topPanel.add($this$alphabetically_u24lambda_u2d4);
        knownProjectsPanel.alphabetically = serializable;
        $this$alphabetically_u24lambda_u2d4 = serializable = new JRadioButton("Last Opened");
        knownProjectsPanel = this;
        boolean bl4 = false;
        ((AbstractButton)$this$lastOpened_u24lambda_u2d6).setSelected(true);
        ((AbstractButton)$this$lastOpened_u24lambda_u2d6).addActionListener(arg_0 -> KnownProjectsPanel.lastOpened$lambda-6$lambda-5(this, (JRadioButton)$this$lastOpened_u24lambda_u2d6, arg_0));
        this.sortButtonGroup.add((AbstractButton)$this$lastOpened_u24lambda_u2d6);
        this.topPanel.add($this$lastOpened_u24lambda_u2d6);
        knownProjectsPanel.lastOpened = serializable;
        $this$lastOpened_u24lambda_u2d6 = serializable = new JButton(ProjectManagerIcons.INSTANCE.arrowDropUp(19));
        knownProjectsPanel = this;
        boolean bl5 = false;
        ((AbstractButton)$this$sortButton_u24lambda_u2d9).setContentAreaFilled(false);
        ((AbstractButton)$this$sortButton_u24lambda_u2d9).setBorderPainted(false);
        ((AbstractButton)$this$sortButton_u24lambda_u2d9).addActionListener(arg_0 -> KnownProjectsPanel.sortButton$lambda-9$lambda-8(this, (JButton)$this$sortButton_u24lambda_u2d9, arg_0));
        this.topPanel.add($this$sortButton_u24lambda_u2d9);
        knownProjectsPanel.sortButton = serializable;
        $this$sortButton_u24lambda_u2d9 = serializable = new JPanel();
        knownProjectsPanel = this;
        boolean bl6 = false;
        $this$innerPanel_u24lambda_u2d11.setLayout(new BoxLayout($this$innerPanel_u24lambda_u2d11, 1));
        Iterable $this$forEach$iv = this.projectList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KnownAvailProject it = (KnownAvailProject)element$iv;
            boolean bl7 = false;
            KnownProjectRow row = new KnownProjectRow(it, this.config, this);
            this.rowMap.put(it.getId(), row);
            $this$innerPanel_u24lambda_u2d11.add(row);
            if (!Intrinsics.areEqual((Object)it.getId(), (Object)this.config.getFavorite())) continue;
            row.openProject$avail();
        }
        knownProjectsPanel.innerPanel = serializable;
        serializable = SwingHelperKt.createScrollPane$default(this.innerPanel, 0, 0, 6, null);
        $this$innerPanel_u24lambda_u2d11 = serializable;
        knownProjectsPanel = this;
        boolean bl8 = false;
        ((JScrollPane)$this$scrollPane_u24lambda_u2d12).setVerticalScrollBarPolicy(20);
        ((JScrollPane)$this$scrollPane_u24lambda_u2d12).setHorizontalScrollBarPolicy(30);
        knownProjectsPanel.scrollPane = serializable;
        serializable = new JButton("Open");
        $this$scrollPane_u24lambda_u2d12 = serializable;
        knownProjectsPanel = this;
        boolean bl9 = false;
        $this$openProjectButton_u24lambda_u2d16.setOpaque(true);
        int currentHeight = $this$openProjectButton_u24lambda_u2d16.getHeight();
        int currentWidth = $this$openProjectButton_u24lambda_u2d16.getWidth();
        $this$openProjectButton_u24lambda_u2d16.setMinimumSize(new Dimension(currentWidth + 100, currentHeight + 40));
        $this$openProjectButton_u24lambda_u2d16.setPreferredSize(new Dimension(currentWidth + 100, currentHeight + 40));
        $this$openProjectButton_u24lambda_u2d16.setMaximumSize(new Dimension(currentWidth + 100, currentHeight + 40));
        ((AbstractButton)$this$openProjectButton_u24lambda_u2d16).addActionListener(arg_0 -> KnownProjectsPanel.openProjectButton$lambda-16$lambda-15(this, arg_0));
        knownProjectsPanel.openProjectButton = serializable;
        serializable = new JButton("Create");
        $this$openProjectButton_u24lambda_u2d16 = serializable;
        knownProjectsPanel = this;
        boolean bl10 = false;
        $this$createButton_u24lambda_u2d19.setOpaque(true);
        currentHeight = $this$createButton_u24lambda_u2d19.getHeight();
        currentWidth = $this$createButton_u24lambda_u2d19.getWidth();
        $this$createButton_u24lambda_u2d19.setMinimumSize(new Dimension(currentWidth + 100, currentHeight + 40));
        $this$createButton_u24lambda_u2d19.setPreferredSize(new Dimension(currentWidth + 100, currentHeight + 40));
        $this$createButton_u24lambda_u2d19.setMaximumSize(new Dimension(currentWidth + 100, currentHeight + 40));
        ((AbstractButton)$this$createButton_u24lambda_u2d19).addActionListener(arg_0 -> KnownProjectsPanel.createButton$lambda-19$lambda-18(this, arg_0));
        knownProjectsPanel.createButton = serializable;
        serializable = new JButton("Preferences");
        $this$createButton_u24lambda_u2d19 = serializable;
        knownProjectsPanel = this;
        boolean bl11 = false;
        $this$preferences_u24lambda_u2d21.setOpaque(true);
        currentHeight = $this$preferences_u24lambda_u2d21.getHeight();
        currentWidth = $this$preferences_u24lambda_u2d21.getWidth();
        $this$preferences_u24lambda_u2d21.setMinimumSize(new Dimension(currentWidth + 150, currentHeight + 40));
        $this$preferences_u24lambda_u2d21.setPreferredSize(new Dimension(currentWidth + 150, currentHeight + 40));
        $this$preferences_u24lambda_u2d21.setMaximumSize(new Dimension(currentWidth + 150, currentHeight + 40));
        ((AbstractButton)$this$preferences_u24lambda_u2d21).addActionListener(KnownProjectsPanel::preferences$lambda-21$lambda-20);
        knownProjectsPanel.preferences = serializable;
        serializable = new JPanel();
        $this$preferences_u24lambda_u2d21 = serializable;
        knownProjectsPanel = this;
        boolean bl12 = false;
        $this$bottomPanel_u24lambda_u2d22.setLayout(new FlowLayout(2));
        $this$bottomPanel_u24lambda_u2d22.setMinimumSize(new Dimension(600, 50));
        $this$bottomPanel_u24lambda_u2d22.setPreferredSize(new Dimension(750, 50));
        $this$bottomPanel_u24lambda_u2d22.setMaximumSize(new Dimension(750, 50));
        $this$bottomPanel_u24lambda_u2d22.setBackground(new Color(60, 63, 65));
        $this$bottomPanel_u24lambda_u2d22.add(this.preferences);
        $this$bottomPanel_u24lambda_u2d22.add(this.createButton);
        $this$bottomPanel_u24lambda_u2d22.add(this.openProjectButton);
        knownProjectsPanel.bottomPanel = serializable;
        $this$bottomPanel_u24lambda_u2d22 = serializable = new BoxLayout(this, 1);
        knownProjectsPanel = this;
        boolean bl13 = false;
        this.setAlignmentX(0.0f);
        knownProjectsPanel.setLayout((LayoutManager)((Object)serializable));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add(this.topPanel);
        this.add(this.scrollPane);
        this.add(this.bottomPanel);
    }

    @NotNull
    public final GlobalAvailConfiguration getConfig$avail() {
        return this.config;
    }

    @NotNull
    public final AvailProjectManagerWindow getManager$avail() {
        return this.manager;
    }

    public final void updateFavorite() {
        Iterable $this$forEach$iv = this.rowMap.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KnownProjectRow it = (KnownProjectRow)element$iv;
            boolean bl = false;
            it.updateFavoriteButtonIcon$avail();
        }
    }

    private final void setByLastOpened(boolean value) {
        if (this.byLastOpened == value) {
            return;
        }
        this.byLastOpened = value;
        this.repopulateProjects$avail();
    }

    private final void setSortAscending(boolean value) {
        if (this.sortAscending == value) {
            return;
        }
        this.sortAscending = value;
        this.repopulateProjects$avail();
    }

    private static /* synthetic */ void getAlphabetically$annotations() {
    }

    private static /* synthetic */ void getLastOpened$annotations() {
    }

    private static /* synthetic */ void getSortButton$annotations() {
    }

    @NotNull
    public final JButton getOpenProjectButton() {
        return this.openProjectButton;
    }

    public static /* synthetic */ void getOpenProjectButton$annotations() {
    }

    @NotNull
    public final JButton getCreateButton() {
        return this.createButton;
    }

    @NotNull
    public final JButton getPreferences() {
        return this.preferences;
    }

    public final void repopulateProjects$avail() {
        this.projectList = this.byLastOpened & this.sortAscending ? this.config.getKnownProjectsByLastOpenedAscending() : (this.byLastOpened & !this.sortAscending ? this.config.getKnownProjectsByLastOpenedDescending() : (!this.byLastOpened & this.sortAscending ? this.config.getKnownProjectsByAlphaAscending() : this.config.getKnownProjectsByAlphaDescending()));
        this.rowMap.clear();
        SwingUtilities.invokeLater(() -> KnownProjectsPanel.repopulateProjects$lambda-25(this));
    }

    private static final void alphabetically$lambda-4$lambda-3(KnownProjectsPanel this$0, JRadioButton $this_apply, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        this$0.setByLastOpened(!$this_apply.isSelected());
    }

    private static final void lastOpened$lambda-6$lambda-5(KnownProjectsPanel this$0, JRadioButton $this_apply, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        this$0.setByLastOpened($this_apply.isSelected());
    }

    private static final void sortButton$lambda-9$lambda-8$lambda-7(JButton $this_apply, boolean $newSortAscending, KnownProjectsPanel this$0) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if ($newSortAscending) {
            $this_apply.setToolTipText("Ascending");
            icon = ProjectManagerIcons.INSTANCE.arrowDropUp(19);
        } else {
            $this_apply.setToolTipText("Descending");
            icon = ProjectManagerIcons.INSTANCE.arrowDropDown(19);
        }
        $this_apply.setIcon(icon);
        this$0.repopulateProjects$avail();
    }

    private static final void sortButton$lambda-9$lambda-8(KnownProjectsPanel this$0, JButton $this_apply, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        boolean currentSortAscending = this$0.sortAscending;
        boolean newSortAscending = !currentSortAscending;
        this$0.setSortAscending(newSortAscending);
        SwingUtilities.invokeLater(() -> KnownProjectsPanel.sortButton$lambda-9$lambda-8$lambda-7($this_apply, newSortAscending, this$0));
    }

    private static final void openProjectButton$lambda-16$lambda-15$lambda-14$lambda-13(KnownProjectsPanel this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.manager.hideProjectManager();
    }

    private static final void openProjectButton$lambda-16$lambda-15(KnownProjectsPanel this$0, ActionEvent it) {
        JFileChooser jFileChooser;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        JFileChooser $this$openProjectButton_u24lambda_u2d16_u24lambda_u2d15_u24lambda_u2d14 = jFileChooser = new JFileChooser();
        boolean bl = false;
        $this$openProjectButton_u24lambda_u2d16_u24lambda_u2d15_u24lambda_u2d14.setDialogTitle("Select Avail Project Configuration File to Open");
        $this$openProjectButton_u24lambda_u2d16_u24lambda_u2d15_u24lambda_u2d14.setFileSelectionMode(0);
        String[] stringArray = new String[]{"json"};
        $this$openProjectButton_u24lambda_u2d16_u24lambda_u2d15_u24lambda_u2d14.setFileFilter(new FileNameExtensionFilter("*.json", stringArray));
        $this$openProjectButton_u24lambda_u2d16_u24lambda_u2d15_u24lambda_u2d14.addChoosableFileFilter(new FileFilter(){

            @NotNull
            public String getDescription() {
                return "Avail Project Config (*.json)";
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean accept(@Nullable File f) {
                boolean bl;
                boolean bl2 = bl = f != null;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                File file2 = f;
                Intrinsics.checkNotNull((Object)file2);
                if (!file2.isFile()) return false;
                if (!f.canWrite()) return false;
                String string3 = f.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"f.absolutePath");
                String string4 = string3.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                if (!StringsKt.endsWith$default((String)string4, (String)".json", (boolean)false, (int)2, null)) return false;
                return true;
            }
        });
        int result2 = $this$openProjectButton_u24lambda_u2d16_u24lambda_u2d15_u24lambda_u2d14.showDialog(this$0, "Select Project Config File");
        if (result2 == 0) {
            AvailProject availProject;
            File configFile = $this$openProjectButton_u24lambda_u2d16_u24lambda_u2d15_u24lambda_u2d14.getSelectedFile();
            String string2 = configFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"configFile.absolutePath");
            String string3 = configFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"configFile.name");
            String string4 = StringsKt.removeSuffix((String)string2, (CharSequence)string3);
            String string5 = File.separator;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"separator");
            String projectPath = StringsKt.removeSuffix((String)string4, (CharSequence)string5);
            try {
                Intrinsics.checkNotNullExpressionValue((Object)configFile, (String)"configFile");
                availProject = AvailProject.Companion.from(projectPath, UtilityKt.jsonObject$default((String)FilesKt.readText((File)configFile, (Charset)Charsets.UTF_8), null, (int)2, null));
            }
            catch (Throwable e) {
                e.printStackTrace();
                availProject = null;
            }
            AvailProject availProject2 = availProject;
            if (availProject2 != null) {
                AvailProject project = availProject2;
                GlobalAvailConfiguration globalAvailConfiguration = this$0.config;
                String string6 = configFile.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"configFile.absolutePath");
                globalAvailConfiguration.add(project, string6);
                GlobalAvailConfiguration globalAvailConfiguration2 = this$0.config;
                String string7 = configFile.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"configFile.absolutePath");
                AvailWorkbench.Companion.launchWorkbenchWithProject(project, globalAvailConfiguration2, string7);
                SwingUtilities.invokeLater(() -> KnownProjectsPanel.openProjectButton$lambda-16$lambda-15$lambda-14$lambda-13(this$0));
            }
        }
    }

    private static final void createButton$lambda-19$lambda-18$lambda-17(KnownProjectsPanel this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.manager.redraw$avail();
    }

    private static final void createButton$lambda-19$lambda-18(KnownProjectsPanel this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.manager.setDisplayed(AvailProjectManagerWindow.DisplayedPanel.CREATE_PROJECT);
        SwingUtilities.invokeLater(() -> KnownProjectsPanel.createButton$lambda-19$lambda-18$lambda-17(this$0));
    }

    private static final void preferences$lambda-21$lambda-20(ActionEvent it) {
        System.out.println((Object)"Create Button Doesn't have a target screen yet!");
    }

    private static final void repopulateProjects$lambda-25(KnownProjectsPanel this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.innerPanel.removeAll();
        Iterable $this$forEach$iv = this$0.projectList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KnownAvailProject it = (KnownAvailProject)element$iv;
            boolean bl = false;
            KnownProjectRow row = new KnownProjectRow(it, this$0.config, this$0);
            this$0.rowMap.put(it.getId(), row);
            this$0.innerPanel.add(row);
        }
        this$0.innerPanel.revalidate();
        this$0.innerPanel.repaint();
    }
}

