/*
 * Decompiled with CFR 0.152.
 */
package avail.compiler;

import avail.builder.ModuleName;
import avail.compiler.ImportValidationException;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.maps.A_Map;
import avail.descriptor.maps.MapDescriptor;
import avail.descriptor.module.A_Module;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.availlang.persistence.MalformedSerialStreamException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB?\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\rJ\b\u0010\u001c\u001a\u00020\u001dH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lavail/compiler/ModuleImport;", "", "moduleName", "Lavail/descriptor/tuples/A_String;", "acceptableVersions", "Lavail/descriptor/sets/A_Set;", "isExtension", "", "names", "renames", "Lavail/descriptor/maps/A_Map;", "excludes", "wildcard", "(Lavail/descriptor/tuples/A_String;Lavail/descriptor/sets/A_Set;ZLavail/descriptor/sets/A_Set;Lavail/descriptor/maps/A_Map;Lavail/descriptor/sets/A_Set;Z)V", "getAcceptableVersions", "()Lavail/descriptor/sets/A_Set;", "getExcludes", "()Z", "getModuleName", "()Lavail/descriptor/tuples/A_String;", "getNames", "getRenames", "()Lavail/descriptor/maps/A_Map;", "tupleForSerialization", "Lavail/descriptor/tuples/A_Tuple;", "getTupleForSerialization$avail", "()Lavail/descriptor/tuples/A_Tuple;", "getWildcard", "validate", "", "Companion", "avail"})
public final class ModuleImport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isExtension;
    private final boolean wildcard;
    @NotNull
    private final A_String moduleName;
    @NotNull
    private final A_Set acceptableVersions;
    @NotNull
    private final A_Set names;
    @NotNull
    private final A_Map renames;
    @NotNull
    private final A_Set excludes;

    public ModuleImport(@NotNull A_String moduleName2, @NotNull A_Set acceptableVersions, boolean isExtension, @NotNull A_Set names, @NotNull A_Map renames, @NotNull A_Set excludes, boolean wildcard) throws ImportValidationException {
        Intrinsics.checkNotNullParameter((Object)moduleName2, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)acceptableVersions, (String)"acceptableVersions");
        Intrinsics.checkNotNullParameter((Object)names, (String)"names");
        Intrinsics.checkNotNullParameter((Object)renames, (String)"renames");
        Intrinsics.checkNotNullParameter((Object)excludes, (String)"excludes");
        this.isExtension = isExtension;
        this.wildcard = wildcard;
        this.moduleName = moduleName2.makeShared();
        this.acceptableVersions = acceptableVersions.makeShared();
        this.names = names.makeShared();
        this.renames = renames.makeShared();
        this.excludes = excludes.makeShared();
        this.validate();
    }

    public final boolean isExtension() {
        return this.isExtension;
    }

    public final boolean getWildcard() {
        return this.wildcard;
    }

    @NotNull
    public final A_String getModuleName() {
        return this.moduleName;
    }

    @NotNull
    public final A_Set getAcceptableVersions() {
        return this.acceptableVersions;
    }

    @NotNull
    public final A_Set getNames() {
        return this.names;
    }

    @NotNull
    public final A_Map getRenames() {
        return this.renames;
    }

    @NotNull
    public final A_Set getExcludes() {
        return this.excludes;
    }

    private final void validate() throws ImportValidationException {
        A_Set redundantExclusions;
        A_Set renameOriginals = A_Tuple.Companion.getAsSet(A_Map.Companion.getValuesAsTuple(this.renames));
        if (this.wildcard) {
            if (!A_Set.Companion.isSubsetOf(this.names, renameOriginals)) {
                throw new ImportValidationException("wildcard import not to be specified or explicit positive imports only to be used to force inclusion of source names of renames");
            }
        } else if (A_Set.Companion.getSetSize(this.excludes) != 0) {
            throw new ImportValidationException("wildcard import to be specified or explicit negative imports not to be specified");
        }
        if (A_Set.Companion.getSetSize(redundantExclusions = A_Set.Companion.setIntersectionCanDestroy(renameOriginals, this.excludes, false)) != 0) {
            StringBuilder stringBuilder;
            StringBuilder $this$validate_u24lambda_u2d0 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$validate_u24lambda_u2d0.append("source names of renames not to overlap explicit negative imports (the redundant name");
            if (A_Set.Companion.getSetSize(redundantExclusions) == 1) {
                $this$validate_u24lambda_u2d0.append(" is ");
            } else {
                $this$validate_u24lambda_u2d0.append("s are ");
            }
            CollectionsKt.joinTo$default((Iterable)redundantExclusions, (Appendable)$this$validate_u24lambda_u2d0, (CharSequence)", ", null, null, (int)0, null, null, (int)124, null);
            $this$validate_u24lambda_u2d0.append(')');
            String string2 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
            String message = string2;
            throw new ImportValidationException(message);
        }
    }

    @NotNull
    public final A_Tuple getTupleForSerialization$avail() {
        A_BasicObject[] a_BasicObjectArray = new A_BasicObject[]{this.moduleName, this.acceptableVersions, AtomDescriptor.Companion.objectFromBoolean(this.isExtension), this.names, this.renames, this.excludes, AtomDescriptor.Companion.objectFromBoolean(this.wildcard)};
        return ObjectTupleDescriptor.Companion.tupleFromArray(a_BasicObjectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lavail/compiler/ModuleImport$Companion;", "", "()V", "extend", "Lavail/compiler/ModuleImport;", "module", "Lavail/descriptor/module/A_Module;", "fromSerializedTuple", "serializedTuple", "Lavail/descriptor/tuples/A_Tuple;", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ModuleImport extend(@NotNull A_Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            try {
                ModuleName name2 = new ModuleName(A_Module.Companion.getModuleNameNative(module), false, 2, null);
                return new ModuleImport(StringDescriptor.Companion.stringFrom(name2.getLocalName()), A_Module.Companion.getVersions(module), true, SetDescriptor.Companion.getEmptySet(), MapDescriptor.Companion.getEmptyMap(), SetDescriptor.Companion.getEmptySet(), true);
            }
            catch (ImportValidationException e) {
                if (_Assertions.ENABLED) {
                    boolean bl = false;
                    String string2 = "This shouldn't happen";
                    throw new AssertionError((Object)string2);
                }
                throw new RuntimeException(e);
            }
        }

        @NotNull
        public final ModuleImport fromSerializedTuple(@NotNull A_Tuple serializedTuple) throws MalformedSerialStreamException {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)serializedTuple, (String)"serializedTuple");
            int tupleSize = A_Tuple.Companion.getTupleSize(serializedTuple);
            boolean bl2 = bl = tupleSize == 7;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            try {
                return new ModuleImport(A_Tuple.Companion.tupleAt(serializedTuple, 1), A_Tuple.Companion.tupleAt(serializedTuple, 2), A_Atom.Companion.getExtractBoolean(A_Tuple.Companion.tupleAt(serializedTuple, 3)), A_Tuple.Companion.tupleAt(serializedTuple, 4), A_Tuple.Companion.tupleAt(serializedTuple, 5), A_Tuple.Companion.tupleAt(serializedTuple, 6), A_Atom.Companion.getExtractBoolean(A_Tuple.Companion.tupleAt(serializedTuple, 7)));
            }
            catch (ImportValidationException e) {
                throw new MalformedSerialStreamException((Throwable)e);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

