/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.functions;

import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceMetaDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operation.L2_GET_TYPE;
import avail.optimizer.L1Translator;
import avail.optimizer.L2Generator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0014J\b\u0010\r\u001a\u00020\u000bH\u0014JH\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\n2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u00060\u0018R\u00020\u0016H\u0016\u00a8\u0006\u0019"}, d2={"Lavail/interpreter/primitive/functions/P_ParamTypeAt;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "fallibilityForArgumentTypes", "Lavail/interpreter/Primitive$Fallibility;", "argumentTypes", "", "Lavail/descriptor/types/A_Type;", "privateBlockTypeRestriction", "privateFailureVariableType", "tryToGenerateSpecialPrimitiveInvocation", "", "functionToCallReg", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "arguments", "translator", "Lavail/optimizer/L1Translator;", "callSiteHelper", "Lavail/optimizer/L1Translator$CallSiteHelper;", "avail"})
public final class P_ParamTypeAt
extends Primitive {
    @NotNull
    public static final P_ParamTypeAt INSTANCE = new P_ParamTypeAt();

    private P_ParamTypeAt() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject functionType = interpreter.argument(0);
        AvailObject indexObject = interpreter.argument(1);
        A_Type parametersType = A_Type.Companion.getArgsTupleType(functionType);
        A_Type sizeRange = A_Type.Companion.getSizeRange(parametersType);
        if (A_Number.Companion.lessThan(A_Type.Companion.getUpperBound(sizeRange), indexObject)) {
            return interpreter.primitiveFailure(AvailErrorCode.E_SUBSCRIPT_OUT_OF_BOUNDS);
        }
        if (!A_Number.Companion.isInt(indexObject)) {
            return interpreter.primitiveSuccess(A_Type.Companion.getDefaultType(parametersType));
        }
        int index2 = A_Number.Companion.getExtractInt(indexObject);
        return interpreter.primitiveSuccess(A_Type.Companion.typeAtIndex(A_Type.Companion.getArgsTupleType(functionType), index2));
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_SUBSCRIPT_OUT_OF_BOUNDS};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(FunctionTypeDescriptor.Companion.functionMeta(), IntegerRangeTypeDescriptor.Companion.getNaturalNumbers()), InstanceMetaDescriptor.Companion.anyMeta(), null, 4, null);
    }

    @Override
    @NotNull
    public Primitive.Fallibility fallibilityForArgumentTypes(@NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        A_Type functionMeta = argumentTypes.get(0);
        A_Type indexType = argumentTypes.get(1);
        AvailObject functionType = A_Type.Companion.getInstance(functionMeta);
        A_Type sizeRange = A_Type.Companion.getSizeRange(A_Type.Companion.getArgsTupleType(functionType));
        if (sizeRange.isBottom()) {
            return Primitive.Fallibility.CallSiteCanFail;
        }
        if (A_Number.Companion.lessOrEqual(A_Type.Companion.getUpperBound(indexType), A_Type.Companion.getLowerBound(sizeRange))) {
            return Primitive.Fallibility.CallSiteCannotFail;
        }
        if (A_Number.Companion.greaterThan(A_Type.Companion.getLowerBound(indexType), A_Type.Companion.getUpperBound(sizeRange))) {
            return Primitive.Fallibility.CallSiteMustFail;
        }
        return Primitive.Fallibility.CallSiteCannotFail;
    }

    @Override
    public boolean tryToGenerateSpecialPrimitiveInvocation(@NotNull L2ReadBoxedOperand functionToCallReg, @NotNull A_RawFunction rawFunction, @NotNull List<L2ReadBoxedOperand> arguments, @NotNull List<? extends A_Type> argumentTypes, @NotNull L1Translator translator, @NotNull L1Translator.CallSiteHelper callSiteHelper) {
        Intrinsics.checkNotNullParameter((Object)functionToCallReg, (String)"functionToCallReg");
        Intrinsics.checkNotNullParameter((Object)rawFunction, (String)"rawFunction");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        Intrinsics.checkNotNullParameter((Object)callSiteHelper, (String)"callSiteHelper");
        L2ReadBoxedOperand functionTypeRead = arguments.get(0);
        A_Type functionMeta = argumentTypes.get(0);
        A_Type indexType = argumentTypes.get(1);
        L2Instruction functionTypeDefinition = functionTypeRead.definition().getInstruction();
        A_Number exactIndex = A_Type.Companion.getLowerBound(indexType);
        if (!A_Type.Companion.getUpperBound(indexType).equals(exactIndex)) {
            return false;
        }
        A_Type argsRange = A_Type.Companion.getSizeRange(A_Type.Companion.getArgsTupleType(A_Type.Companion.getInstance(functionMeta)));
        A_Number minArgs = A_Type.Companion.getLowerBound(argsRange);
        if (!A_Number.Companion.isInt(minArgs) || A_Number.Companion.greaterThan(exactIndex, minArgs)) {
            return false;
        }
        if (!(functionTypeDefinition.getOperation() instanceof L2_GET_TYPE)) {
            return false;
        }
        L2ReadBoxedOperand function = L2_GET_TYPE.sourceValueOf(functionTypeDefinition);
        L2Generator generator = translator.getGenerator();
        L2ReadBoxedOperand read2 = generator.extractParameterTypeFromFunction(function, A_Number.Companion.getExtractInt(exactIndex));
        callSiteHelper.useAnswer(read2);
        return true;
    }
}

