/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.methods;

import avail.compiler.splitter.MessageSplitter;
import avail.descriptor.module.A_Module;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.SetTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AmbiguousNameException;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.MalformedMessageException;
import avail.exceptions.SignatureException;
import avail.interpreter.Primitive;
import avail.interpreter.execution.AvailLoader;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.primitive.style.P_BootstrapDefinitionStyler;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\nH\u0014\u00a8\u0006\f"}, d2={"Lavail/interpreter/primitive/methods/P_GrammaticalRestriction;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "bootstrapStyler", "Lavail/interpreter/primitive/style/P_BootstrapDefinitionStyler;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_GrammaticalRestriction
extends Primitive {
    @NotNull
    public static final P_GrammaticalRestriction INSTANCE = new P_GrammaticalRestriction();

    private P_GrammaticalRestriction() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.Unknown};
        super(2, flagArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject parentStrings = interpreter.argument(0);
        AvailObject excludedStringSets = interpreter.argument(1);
        AvailLoader availLoader = interpreter.availLoaderOrNull();
        if (availLoader == null) {
            return interpreter.primitiveFailure(AvailErrorCode.E_LOADING_IS_OVER);
        }
        AvailLoader loader = availLoader;
        if (!loader.getPhase().isExecuting()) {
            return interpreter.primitiveFailure(AvailErrorCode.E_CANNOT_DEFINE_DURING_COMPILATION);
        }
        AvailObject excludedAtomSets2 = ObjectTupleDescriptor.Companion.generateObjectTupleFrom(A_Tuple.Companion.getTupleSize(excludedStringSets), (Function1<? super Integer, ? extends A_BasicObject>)((Function1)new Function1<Integer, A_BasicObject>(excludedStringSets, loader){
            final /* synthetic */ AvailObject $excludedStringSets;
            final /* synthetic */ AvailLoader $loader;
            {
                this.$excludedStringSets = $excludedStringSets;
                this.$loader = $loader;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final A_BasicObject invoke(int it) {
                void $this$fold$iv;
                void initial$iv;
                Iterable iterable = A_Tuple.Companion.tupleAt(this.$excludedStringSets, it);
                A_Set a_Set = SetDescriptor.Companion.getEmptySet();
                AvailLoader availLoader = this.$loader;
                boolean $i$f$fold = false;
                A_Set accumulator$iv = initial$iv;
                for (T element$iv : $this$fold$iv) {
                    void string2;
                    AvailObject availObject = (AvailObject)element$iv;
                    void set2 = accumulator$iv;
                    boolean bl = false;
                    A_Set atoms = A_Module.Companion.trueNamesForStringName(availLoader.getModule(), (A_String)string2);
                    if (A_Set.Companion.getSetSize(atoms) == 0) {
                        A_BasicObject[] a_BasicObjectArray = new A_BasicObject[]{AvailLoader.lookupName$default(availLoader, (A_String)string2, null, 2, null)};
                        atoms = SetDescriptor.Companion.set(a_BasicObjectArray);
                    }
                    accumulator$iv = A_Set.Companion.setUnionCanDestroy((A_Set)set2, atoms, true);
                }
                return accumulator$iv;
            }
        }));
        try {
            void $this$fold$iv;
            Iterable iterable = parentStrings;
            A_Set initial$iv = SetDescriptor.Companion.getEmptySet();
            boolean $i$f$fold = false;
            A_Set accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void string2;
                AvailObject availObject = (AvailObject)element$iv;
                A_Set set2 = accumulator$iv;
                boolean bl = false;
                A_Set atoms = A_Module.Companion.trueNamesForStringName(loader.getModule(), (A_String)string2);
                if (A_Set.Companion.getSetSize(atoms) == 0) {
                    A_BasicObject[] a_BasicObjectArray = new A_BasicObject[]{AvailLoader.lookupName$default(loader, (A_String)string2, null, 2, null)};
                    atoms = SetDescriptor.Companion.set(a_BasicObjectArray);
                }
                accumulator$iv = A_Set.Companion.setUnionCanDestroy(set2, atoms, true);
            }
            A_Set parentAtoms = accumulator$iv;
            loader.addGrammaticalRestrictions(parentAtoms, excludedAtomSets2);
        }
        catch (MalformedMessageException e) {
            return interpreter.primitiveFailure(e);
        }
        catch (SignatureException e) {
            return interpreter.primitiveFailure(e);
        }
        catch (AmbiguousNameException e) {
            return interpreter.primitiveFailure(e);
        }
        return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(SetTypeDescriptor.Companion.setTypeForSizesContentType(IntegerRangeTypeDescriptor.Companion.getNaturalNumbers(), TupleTypeDescriptor.Companion.getStringType()), TupleTypeDescriptor.Companion.zeroOrMoreOf(SetTypeDescriptor.Companion.setTypeForSizesContentType(IntegerRangeTypeDescriptor.Companion.getWholeNumbers(), TupleTypeDescriptor.Companion.getStringType()))), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_LOADING_IS_OVER, AvailErrorCode.E_CANNOT_DEFINE_DURING_COMPILATION, AvailErrorCode.E_AMBIGUOUS_NAME, AvailErrorCode.E_INCORRECT_NUMBER_OF_ARGUMENTS};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(A_Set.Companion.setUnionCanDestroy(SetDescriptor.Companion.set(availErrorCodeArray), MessageSplitter.Companion.getPossibleErrors(), true));
    }

    @Override
    @NotNull
    public P_BootstrapDefinitionStyler bootstrapStyler() {
        return P_BootstrapDefinitionStyler.INSTANCE;
    }
}

