/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.pojos;

import avail.AvailRuntime;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.maps.A_Map;
import avail.descriptor.methods.MethodDescriptor;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.BottomTypeDescriptor;
import avail.descriptor.types.PojoTypeDescriptor;
import avail.descriptor.types.VariableTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.MarshalingException;
import avail.interpreter.Primitive;
import avail.interpreter.levelOne.L1InstructionWriter;
import avail.interpreter.levelOne.L1Operation;
import avail.utility.Mutable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0000\u00a2\u0006\u0002\b\fJC\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\b2\u0010\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u00112\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014J9\u0010\u0015\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u00112\u0006\u0010\u0010\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019J/\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00062\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0011\"\u00020\u0006\u00a2\u0006\u0002\u0010 \u00a8\u0006!"}, d2={"Lavail/interpreter/primitive/pojos/PrimitiveHelper;", "", "()V", "lookupField", "Ljava/lang/reflect/Field;", "pojoType", "Lavail/descriptor/types/A_Type;", "fieldName", "Lavail/descriptor/tuples/A_String;", "errorOut", "Lavail/utility/Mutable;", "Lavail/exceptions/AvailErrorCode;", "lookupField$avail", "lookupMethod", "Ljava/lang/reflect/Method;", "methodName", "marshaledTypes", "", "Ljava/lang/Class;", "lookupMethod$avail", "(Lavail/descriptor/types/A_Type;Lavail/descriptor/tuples/A_String;[Ljava/lang/Class;Lavail/utility/Mutable;)Ljava/lang/reflect/Method;", "marshalValues", "Lavail/descriptor/tuples/A_Tuple;", "args", "marshalValues$avail", "(Lavail/descriptor/tuples/A_Tuple;Lavail/descriptor/tuples/A_Tuple;Lavail/utility/Mutable;)[Ljava/lang/Object;", "rawPojoInvokerFunctionFromFunctionType", "Lavail/descriptor/functions/A_RawFunction;", "primitive", "Lavail/interpreter/Primitive;", "functionType", "outerTypes", "(Lavail/interpreter/Primitive;Lavail/descriptor/types/A_Type;[Lavail/descriptor/types/A_Type;)Lavail/descriptor/functions/A_RawFunction;", "avail"})
public final class PrimitiveHelper {
    @NotNull
    public static final PrimitiveHelper INSTANCE = new PrimitiveHelper();

    private PrimitiveHelper() {
    }

    @Nullable
    public final Method lookupMethod$avail(@NotNull A_Type pojoType, @NotNull A_String methodName, @NotNull Class<?>[] marshaledTypes, @NotNull Mutable<AvailErrorCode> errorOut) {
        Intrinsics.checkNotNullParameter((Object)pojoType, (String)"pojoType");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter(marshaledTypes, (String)"marshaledTypes");
        Intrinsics.checkNotNullParameter(errorOut, (String)"errorOut");
        if (!pojoType.isPojoType() || !pojoType.isPojoFusedType()) {
            Method method;
            try {
                method = PojoTypeDescriptor.Companion.marshalDefiningType(pojoType).getMethod(methodName.asNativeString(), Arrays.copyOf(marshaledTypes, marshaledTypes.length));
            }
            catch (NoSuchMethodException e) {
                errorOut.setValue(AvailErrorCode.E_JAVA_METHOD_NOT_AVAILABLE);
                method = null;
            }
            return method;
        }
        Set methods = new LinkedHashSet();
        A_Map.Companion.forEach(pojoType.javaAncestors(), (Function2<? super AvailObject, ? super AvailObject, Unit>)((Function2)new Function2<AvailObject, AvailObject, Unit>((Set<Method>)methods, methodName, marshaledTypes){
            final /* synthetic */ Set<Method> $methods;
            final /* synthetic */ A_String $methodName;
            final /* synthetic */ Class<?>[] $marshaledTypes;
            {
                this.$methods = $methods;
                this.$methodName = $methodName;
                this.$marshaledTypes = $marshaledTypes;
                super(2);
            }

            public final void invoke(@NotNull AvailObject availObject, @NotNull AvailObject ancestor) {
                Intrinsics.checkNotNullParameter((Object)availObject, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)ancestor, (String)"ancestor");
                Class<?> javaClass = PojoTypeDescriptor.Companion.marshalDefiningType(ancestor);
                try {
                    Method method = javaClass.getMethod(this.$methodName.asNativeString(), Arrays.copyOf(this.$marshaledTypes, this.$marshaledTypes.length));
                    Intrinsics.checkNotNullExpressionValue((Object)method, (String)"javaClass.getMethod(\n\t\t\t\u2026tring(), *marshaledTypes)");
                    this.$methods.add(method);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }));
        switch (methods.size()) {
            case 1: {
                return (Method)CollectionsKt.single((Iterable)methods);
            }
            case 0: {
                errorOut.setValue(AvailErrorCode.E_JAVA_METHOD_NOT_AVAILABLE);
                break;
            }
            default: {
                errorOut.setValue(AvailErrorCode.E_JAVA_METHOD_REFERENCE_IS_AMBIGUOUS);
            }
        }
        return null;
    }

    @Nullable
    public final Field lookupField$avail(@NotNull A_Type pojoType, @NotNull A_String fieldName, @NotNull Mutable<AvailErrorCode> errorOut) {
        Intrinsics.checkNotNullParameter((Object)pojoType, (String)"pojoType");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter(errorOut, (String)"errorOut");
        if (!pojoType.isPojoType() || !pojoType.isPojoFusedType()) {
            Field field;
            Class<?> javaClass = PojoTypeDescriptor.Companion.marshalDefiningType(pojoType);
            try {
                field = javaClass.getField(fieldName.asNativeString());
            }
            catch (NoSuchFieldException e) {
                errorOut.setValue(AvailErrorCode.E_JAVA_FIELD_NOT_AVAILABLE);
                field = null;
            }
            return field;
        }
        Set fields = new LinkedHashSet();
        A_Map.Companion.forEach(pojoType.javaAncestors(), (Function2<? super AvailObject, ? super AvailObject, Unit>)((Function2)new Function2<AvailObject, AvailObject, Unit>((Set<Field>)fields, fieldName){
            final /* synthetic */ Set<Field> $fields;
            final /* synthetic */ A_String $fieldName;
            {
                this.$fields = $fields;
                this.$fieldName = $fieldName;
                super(2);
            }

            public final void invoke(@NotNull AvailObject availObject, @NotNull AvailObject ancestor) {
                Intrinsics.checkNotNullParameter((Object)availObject, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)ancestor, (String)"ancestor");
                Class<?> javaClass = PojoTypeDescriptor.Companion.marshalDefiningType(ancestor);
                try {
                    Field field = javaClass.getField(this.$fieldName.asNativeString());
                    Intrinsics.checkNotNullExpressionValue((Object)field, (String)"javaClass.getField(fieldName.asNativeString())");
                    this.$fields.add(field);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
        }));
        switch (fields.size()) {
            case 1: {
                return (Field)CollectionsKt.single((Iterable)fields);
            }
            case 0: {
                errorOut.setValue(AvailErrorCode.E_JAVA_FIELD_NOT_AVAILABLE);
                break;
            }
            default: {
                errorOut.setValue(AvailErrorCode.E_JAVA_FIELD_REFERENCE_IS_AMBIGUOUS);
            }
        }
        return null;
    }

    @NotNull
    public final A_RawFunction rawPojoInvokerFunctionFromFunctionType(@NotNull Primitive primitive2, @NotNull A_Type functionType, A_Type ... outerTypes2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)primitive2, (String)"primitive");
        Intrinsics.checkNotNullParameter((Object)functionType, (String)"functionType");
        Intrinsics.checkNotNullParameter((Object)outerTypes2, (String)"outerTypes");
        A_Type argTypes2 = A_Type.Companion.getArgsTupleType(functionType);
        int numArgs = A_Number.Companion.getExtractInt(A_Type.Companion.getLowerBound(A_Type.Companion.getSizeRange(argTypes2)));
        int n = 0;
        A_Type[] a_TypeArray = new A_Type[numArgs];
        while (n < numArgs) {
            int n2 = n++;
            a_TypeArray[n2] = A_Type.Companion.typeAtIndex(argTypes2, n2 + 1);
        }
        A_Type[] argTypesArray = a_TypeArray;
        A_Type returnType = A_Type.Companion.getReturnType(functionType);
        L1InstructionWriter writer = new L1InstructionWriter(NilDescriptor.Companion.getNil(), 0, NilDescriptor.Companion.getNil());
        writer.setPrimitive(primitive2);
        writer.argumentTypes(Arrays.copyOf(argTypesArray, argTypesArray.length));
        writer.setReturnType(returnType);
        writer.setReturnTypeIfPrimitiveFails(BottomTypeDescriptor.Companion.getBottom());
        int failureLocal = writer.createLocal(VariableTypeDescriptor.Companion.variableTypeFor(PojoTypeDescriptor.Companion.pojoTypeForClass(Throwable.class)));
        boolean bl2 = bl = failureLocal == numArgs + 1;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        A_Type[] $this$forEach$iv = outerTypes2;
        boolean $i$f$forEach = false;
        int n3 = $this$forEach$iv.length;
        for (int i = 0; i < n3; ++i) {
            A_Type element$iv;
            A_Type outerType = element$iv = $this$forEach$iv[i];
            boolean bl3 = false;
            writer.createOuter(outerType);
        }
        int[] nArray = new int[]{writer.addLiteral(MethodDescriptor.SpecialMethodAtom.GET_RETHROW_JAVA_EXCEPTION.getBundle()), writer.addLiteral(AvailRuntime.HookType.RAISE_JAVA_EXCEPTION_IN_AVAIL.getFunctionType())};
        writer.write(0, L1Operation.L1_doCall, nArray);
        nArray = new int[]{failureLocal};
        writer.write(0, L1Operation.L1_doPushLocal, nArray);
        nArray = new int[]{1};
        writer.write(0, L1Operation.L1_doMakeTuple, nArray);
        nArray = new int[]{writer.addLiteral(MethodDescriptor.SpecialMethodAtom.APPLY.getBundle()), writer.addLiteral(BottomTypeDescriptor.Companion.getBottom())};
        writer.write(0, L1Operation.L1_doCall, nArray);
        return writer.compiledCode();
    }

    @Nullable
    public final Object[] marshalValues$avail(@NotNull A_Tuple marshaledTypes, @NotNull A_Tuple args, @NotNull Mutable<AvailErrorCode> errorOut) {
        Object[] objectArray;
        int n;
        Intrinsics.checkNotNullParameter((Object)marshaledTypes, (String)"marshaledTypes");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter(errorOut, (String)"errorOut");
        int n2 = n = A_Tuple.Companion.getTupleSize(marshaledTypes) == A_Tuple.Companion.getTupleSize(args) ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        try {
            n = 0;
            int n3 = A_Tuple.Companion.getTupleSize(args);
            Object[] objectArray2 = new Object[n3];
            while (n < n3) {
                int n4 = n++;
                objectArray2[n4] = A_Tuple.Companion.tupleAt(args, n4 + 1).marshalToJava((Class)A_Tuple.Companion.tupleAt(marshaledTypes, n4 + 1).javaObjectNotNull());
            }
            objectArray = objectArray2;
        }
        catch (MarshalingException e) {
            errorOut.setValue(AvailErrorCode.E_JAVA_MARSHALING_FAILED);
            return null;
        }
        return objectArray;
    }
}

