/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.sockets;

import avail.AvailRuntime;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.fiber.FiberDescriptor;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FiberTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.io.SimpleCompletionHandler;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.AsynchronousSocketChannel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/sockets/P_SocketIPv4Connect;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_SocketIPv4Connect
extends Primitive {
    @NotNull
    public static final P_SocketIPv4Connect INSTANCE = new P_SocketIPv4Connect();

    private P_SocketIPv4Connect() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.HasSideEffect};
        super(6, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Primitive.Result result2;
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(6);
        AvailObject handle2 = interpreter.argument(0);
        AvailObject addressTuple = interpreter.argument(1);
        AvailObject port = interpreter.argument(2);
        AvailObject succeed2 = interpreter.argument(3);
        AvailObject fail2 = interpreter.argument(4);
        AvailObject priority = interpreter.argument(5);
        AvailObject pojo = A_Atom.Companion.getAtomProperty(handle2, AtomDescriptor.SpecialAtom.SOCKET_KEY.getAtom());
        if (pojo.isNil()) {
            return interpreter.primitiveFailure(A_Atom.Companion.isAtomSpecial(handle2) ? AvailErrorCode.E_SPECIAL_ATOM : AvailErrorCode.E_INVALID_HANDLE);
        }
        AsynchronousSocketChannel socket = (AsynchronousSocketChannel)pojo.javaObjectNotNull();
        int n = 0;
        Object object = new byte[4];
        while (n < 4) {
            int n2 = n++;
            object[n2] = (byte)A_Number.Companion.getExtractUnsignedByte(A_Tuple.Companion.tupleAt(addressTuple, n2 + 1));
        }
        byte[] addressBytes = object;
        try {
            InetAddress inetAddress = InetAddress.getByAddress(addressBytes);
            Intrinsics.checkNotNull((Object)inetAddress, (String)"null cannot be cast to non-null type java.net.Inet4Address");
            object = new InetSocketAddress((Inet4Address)inetAddress, A_Number.Companion.getExtractUnsignedShort(port));
        }
        catch (UnknownHostException e) {
            if (_Assertions.ENABLED) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            return interpreter.primitiveFailure(AvailErrorCode.E_IO_ERROR);
        }
        Object address = object;
        A_Fiber current = interpreter.fiber();
        A_Fiber newFiber2 = FiberDescriptor.Companion.newFiber$default(FiberDescriptor.Companion, A_Type.Companion.typeUnion(A_Type.Companion.getReturnType(succeed2.kind()), A_Type.Companion.getReturnType(fail2.kind())), interpreter.runtime, A_Fiber.Companion.getTextInterface(current), A_Number.Companion.getExtractInt(priority), null, (Function0)new Function0<A_String>(addressTuple, port){
            final /* synthetic */ AvailObject $addressTuple;
            final /* synthetic */ AvailObject $port;
            {
                this.$addressTuple = $addressTuple;
                this.$port = $port;
                super(0);
            }

            @NotNull
            public final A_String invoke() {
                Object[] objectArray = new Object[]{this.$addressTuple.toString(), A_Number.Companion.getExtractInt(this.$port)};
                return StringDescriptor.Companion.formatString("Socket IPv4 connect, %s:%d", objectArray);
            }
        }, 16, null);
        A_Fiber.Companion.setAvailLoader(newFiber2, A_Fiber.Companion.getAvailLoader(current));
        A_Fiber.Companion.setHeritableFiberGlobals(newFiber2, A_Fiber.Companion.getHeritableFiberGlobals(current).makeShared());
        newFiber2.makeShared();
        succeed2.makeShared();
        fail2.makeShared();
        AvailRuntime runtime = AvailRuntime.Companion.currentRuntime();
        try {
            socket.connect((SocketAddress)address, Unit.INSTANCE, new SimpleCompletionHandler((Function1)new Function1<SimpleCompletionHandler.Companion.SuccessHelper<Void>, Unit>(runtime, newFiber2, succeed2){
                final /* synthetic */ AvailRuntime $runtime;
                final /* synthetic */ A_Fiber $newFiber;
                final /* synthetic */ AvailObject $succeed;
                {
                    this.$runtime = $runtime;
                    this.$newFiber = $newFiber;
                    this.$succeed = $succeed;
                    super(1);
                }

                public final void invoke(@NotNull SimpleCompletionHandler.Companion.SuccessHelper<Void> $this$$receiver) {
                    Intrinsics.checkNotNullParameter($this$$receiver, (String)"$this$$receiver");
                    this.$runtime.runOutermostFunction(this.$newFiber, this.$succeed, CollectionsKt.emptyList());
                }
            }, (Function1)new Function1<SimpleCompletionHandler.Companion.FailureHelper<Void>, Unit>(runtime, newFiber2, fail2){
                final /* synthetic */ AvailRuntime $runtime;
                final /* synthetic */ A_Fiber $newFiber;
                final /* synthetic */ AvailObject $fail;
                {
                    this.$runtime = $runtime;
                    this.$newFiber = $newFiber;
                    this.$fail = $fail;
                    super(1);
                }

                public final void invoke(@NotNull SimpleCompletionHandler.Companion.FailureHelper<Void> $this$$receiver) {
                    Intrinsics.checkNotNullParameter($this$$receiver, (String)"$this$$receiver");
                    this.$runtime.runOutermostFunction(this.$newFiber, this.$fail, CollectionsKt.listOf((Object)AvailErrorCode.E_IO_ERROR.numericCode()));
                }
            }));
            result2 = interpreter.primitiveSuccess(newFiber2);
        }
        catch (SecurityException e) {
            result2 = interpreter.primitiveFailure(AvailErrorCode.E_PERMISSION_DENIED);
        }
        return result2;
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        A_BasicObject[] a_BasicObjectArray = new A_BasicObject[]{PrimitiveTypeDescriptor.Types.ATOM.getO(), TupleTypeDescriptor.Companion.tupleTypeForSizesTypesDefaultType(IntegerRangeTypeDescriptor.Companion.singleInt(4), TupleDescriptor.Companion.getEmptyTuple(), IntegerRangeTypeDescriptor.Companion.getBytes()), IntegerRangeTypeDescriptor.Companion.getUnsignedShorts(), FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, TupleDescriptor.Companion.getEmptyTuple(), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null), FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(InstanceTypeDescriptor.Companion.instanceType(AvailErrorCode.E_IO_ERROR.numericCode())), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null), IntegerRangeTypeDescriptor.Companion.getBytes()};
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tupleFromArray(a_BasicObjectArray), FiberTypeDescriptor.Companion.mostGeneralFiberType(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_INVALID_HANDLE, AvailErrorCode.E_SPECIAL_ATOM, AvailErrorCode.E_INCORRECT_ARGUMENT_TYPE, AvailErrorCode.E_IO_ERROR, AvailErrorCode.E_PERMISSION_DENIED};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

