/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.types;

import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceMetaDescriptor;
import avail.descriptor.types.SetTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0014J\b\u0010\r\u001a\u00020\u000bH\u0014\u00a8\u0006\u000e"}, d2={"Lavail/interpreter/primitive/types/P_Instances;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "fallibilityForArgumentTypes", "Lavail/interpreter/Primitive$Fallibility;", "argumentTypes", "", "Lavail/descriptor/types/A_Type;", "privateBlockTypeRestriction", "privateFailureVariableType", "avail"})
public final class P_Instances
extends Primitive {
    @NotNull
    public static final P_Instances INSTANCE = new P_Instances();

    private P_Instances() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(1, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(1);
        AvailObject type = interpreter.argument(0);
        return !type.isEnumeration() ? interpreter.primitiveFailure(AvailErrorCode.E_NOT_AN_ENUMERATION) : interpreter.primitiveSuccess(A_Type.Companion.getInstances(type));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(InstanceMetaDescriptor.Companion.topMeta()), SetTypeDescriptor.Companion.mostGeneralSetType(), null, 4, null);
    }

    @Override
    @NotNull
    public Primitive.Fallibility fallibilityForArgumentTypes(@NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        A_Type meta = argumentTypes.get(0);
        return A_Type.Companion.getInstance(meta).isEnumeration() ? Primitive.Fallibility.CallSiteCannotFail : Primitive.Fallibility.CallSiteCanFail;
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_NOT_AN_ENUMERATION};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

