/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.variables;

import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.VariableTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.VariableSetException;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operation.L2ControlFlowOperation;
import avail.interpreter.levelTwo.operation.L2_SET_VARIABLE;
import avail.interpreter.levelTwo.operation.L2_SET_VARIABLE_NO_CHECK;
import avail.optimizer.L1Translator;
import avail.optimizer.L2BasicBlock;
import avail.optimizer.L2Generator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014JH\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016R\u00020\u0014H\u0016\u00a8\u0006\u0017"}, d2={"Lavail/interpreter/primitive/variables/P_SetValue;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "tryToGenerateSpecialPrimitiveInvocation", "", "functionToCallReg", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "arguments", "", "argumentTypes", "translator", "Lavail/optimizer/L1Translator;", "callSiteHelper", "Lavail/optimizer/L1Translator$CallSiteHelper;", "avail"})
public final class P_SetValue
extends Primitive {
    @NotNull
    public static final P_SetValue INSTANCE = new P_SetValue();

    private P_SetValue() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.HasSideEffect};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Primitive.Result result2;
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject variable = interpreter.argument(0);
        AvailObject value = interpreter.argument(1);
        try {
            variable.setValue(value);
            result2 = interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
        }
        catch (VariableSetException e) {
            result2 = interpreter.primitiveFailure(e);
        }
        return result2;
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(VariableTypeDescriptor.Companion.getMostGeneralVariableType(), PrimitiveTypeDescriptor.Types.ANY.getO()), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }

    @Override
    public boolean tryToGenerateSpecialPrimitiveInvocation(@NotNull L2ReadBoxedOperand functionToCallReg, @NotNull A_RawFunction rawFunction, @NotNull List<L2ReadBoxedOperand> arguments, @NotNull List<? extends A_Type> argumentTypes, @NotNull L1Translator translator, @NotNull L1Translator.CallSiteHelper callSiteHelper) {
        Intrinsics.checkNotNullParameter((Object)functionToCallReg, (String)"functionToCallReg");
        Intrinsics.checkNotNullParameter((Object)rawFunction, (String)"rawFunction");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        Intrinsics.checkNotNullParameter((Object)callSiteHelper, (String)"callSiteHelper");
        L2ReadBoxedOperand varReg = arguments.get(0);
        L2ReadBoxedOperand valueReg = arguments.get(1);
        A_Type varType = varReg.type();
        A_Type valueType = valueReg.type();
        A_Type varInnerType = A_Type.Companion.getWriteType(varType);
        L2ControlFlowOperation setOperation = A_Type.Companion.isSubtypeOf(valueType, varInnerType) ? (L2ControlFlowOperation)L2_SET_VARIABLE_NO_CHECK.INSTANCE : (L2ControlFlowOperation)L2_SET_VARIABLE.INSTANCE;
        L2Generator generator = translator.getGenerator();
        L2BasicBlock success2 = generator.createBasicBlock("set local success");
        L2BasicBlock failure = generator.createBasicBlock("set local failure");
        L2Operand[] l2OperandArray = new L2Operand[]{varReg, valueReg, L2Generator.Companion.edgeTo(success2), L2Generator.Companion.edgeTo(failure)};
        translator.addInstruction(setOperation, l2OperandArray);
        L2Generator.startBlock$default(generator, failure, false, null, 6, null);
        translator.generateGeneralFunctionInvocation(functionToCallReg, arguments, false, callSiteHelper);
        L2Generator.startBlock$default(generator, success2, false, null, 6, null);
        callSiteHelper.useAnswer(generator.boxedConstant(NilDescriptor.Companion.getNil()));
        return true;
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_CANNOT_STORE_INCORRECTLY_TYPED_VALUE, AvailErrorCode.E_CANNOT_MODIFY_FINAL_JAVA_FIELD, AvailErrorCode.E_JAVA_MARSHALING_FAILED, AvailErrorCode.E_CANNOT_OVERWRITE_WRITE_ONCE_VARIABLE, AvailErrorCode.E_OBSERVED_VARIABLE_WRITTEN_WHILE_UNTRACED};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

