/*
 * Decompiled with CFR 0.152.
 */
package avail.optimizer.jvm;

import avail.optimizer.jvm.ReferencedInGeneratedCode;
import java.lang.reflect.Field;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B7\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lavail/optimizer/jvm/CheckedField;", "", "verifyAnnotation", "", "isStatic", "receiverClass", "Ljava/lang/Class;", "fieldNameString", "", "fieldClass", "(ZZLjava/lang/Class;Ljava/lang/String;Ljava/lang/Class;)V", "fieldTypeDescriptorString", "isFinal", "receiverClassInternalName", "valueIfFinalAndStatic", "generateRead", "", "methodVisitor", "Lorg/objectweb/asm/MethodVisitor;", "generateWrite", "Companion", "avail"})
public final class CheckedField {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isStatic;
    @NotNull
    private final String fieldNameString;
    private final boolean isFinal;
    @Nullable
    private Object valueIfFinalAndStatic;
    @NotNull
    private final String receiverClassInternalName;
    @NotNull
    private final String fieldTypeDescriptorString;

    /*
     * WARNING - void declaration
     */
    private CheckedField(boolean verifyAnnotation, boolean isStatic, Class<?> receiverClass, String fieldNameString, Class<?> fieldClass) {
        Object object;
        int modifiers;
        boolean e3;
        Object object2;
        this.isStatic = isStatic;
        this.fieldNameString = fieldNameString;
        try {
            Field field = receiverClass.getField(this.fieldNameString);
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"{\n\t\t\t\treceiverClass.getField(fieldNameString)\n\t\t\t}");
            object2 = field;
        }
        catch (NoSuchFieldException e2) {
            throw new RuntimeException(e2);
        }
        catch (SecurityException e3) {
            throw new RuntimeException(e3);
        }
        Field field = object2;
        if (verifyAnnotation) {
            ReferencedInGeneratedCode e3 = field.getAnnotation(ReferencedInGeneratedCode.class);
            if (e3 == null) {
                throw new IllegalStateException(("Field " + this.fieldNameString + " should have had ReferencedInGeneratedCode annotation").toString());
            }
            object2 = e3;
        }
        boolean bl = e3 = ((modifiers = field.getModifiers()) & 1) != 0;
        if (_Assertions.ENABLED && !e3) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean bl2 = e3 = (modifiers & 8) != 0 == this.isStatic;
        if (_Assertions.ENABLED && !e3) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        this.isFinal = (modifiers & 0x10) != 0;
        Class<?> actualFieldType = field.getType();
        boolean bl3 = Intrinsics.areEqual(fieldClass, actualFieldType);
        if (_Assertions.ENABLED && !bl3) {
            String string4 = "Assertion failed";
            throw new AssertionError((Object)string4);
        }
        String string5 = Type.getInternalName(field.getDeclaringClass());
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getInternalName(field.declaringClass)");
        this.receiverClassInternalName = string5;
        String string6 = Type.getDescriptor(field.getType());
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getDescriptor(field.type)");
        this.fieldTypeDescriptorString = string6;
        CheckedField checkedField = this;
        if (this.isStatic && this.isFinal) {
            Object object3;
            CheckedField checkedField2 = checkedField;
            try {
                checkedField = checkedField2;
                object3 = field.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                void e4;
                CheckedField checkedField3 = checkedField2;
                throw new RuntimeException((Throwable)e4);
            }
            object = object3;
        } else {
            object = null;
        }
        checkedField.valueIfFinalAndStatic = object;
    }

    public final void generateRead(@NotNull MethodVisitor methodVisitor) {
        Intrinsics.checkNotNullParameter((Object)methodVisitor, (String)"methodVisitor");
        if (this.isStatic) {
            if (this.isFinal && this.valueIfFinalAndStatic == null) {
                methodVisitor.visitInsn(1);
            } else {
                methodVisitor.visitFieldInsn(178, this.receiverClassInternalName, this.fieldNameString, this.fieldTypeDescriptorString);
            }
        } else {
            methodVisitor.visitFieldInsn(180, this.receiverClassInternalName, this.fieldNameString, this.fieldTypeDescriptorString);
        }
    }

    public final void generateWrite(@NotNull MethodVisitor methodVisitor) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)methodVisitor, (String)"methodVisitor");
        boolean bl2 = bl = !this.isFinal;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        if (this.isStatic) {
            methodVisitor.visitFieldInsn(179, this.receiverClassInternalName, this.fieldNameString, this.fieldTypeDescriptorString);
        } else {
            methodVisitor.visitFieldInsn(181, this.receiverClassInternalName, this.fieldNameString, this.fieldTypeDescriptorString);
        }
    }

    public /* synthetic */ CheckedField(boolean verifyAnnotation, boolean isStatic, Class receiverClass, String fieldNameString, Class fieldClass, DefaultConstructorMarker $constructor_marker) {
        this(verifyAnnotation, isStatic, receiverClass, fieldNameString, fieldClass);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\u00020\u0004\"\u000e\b\u0000\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050\u00062\u0006\u0010\u0007\u001a\u0002H\u0005\u00a2\u0006\u0002\u0010\bJ&\u0010\t\u001a\u00020\u00042\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000bJ&\u0010\u000f\u001a\u00020\u00042\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000bJ&\u0010\u0010\u001a\u00020\u00042\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000bJ&\u0010\u0011\u001a\u00020\u00042\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000b\u00a8\u0006\u0012"}, d2={"Lavail/optimizer/jvm/CheckedField$Companion;", "", "()V", "enumField", "Lavail/optimizer/jvm/CheckedField;", "T", "", "enumInstance", "(Ljava/lang/Enum;)Lavail/optimizer/jvm/CheckedField;", "instanceField", "receiverClass", "Ljava/lang/Class;", "fieldName", "", "fieldClass", "javaLibraryInstanceField", "javaLibraryStaticField", "staticField", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CheckedField instanceField(@NotNull Class<?> receiverClass, @NotNull String fieldName, @NotNull Class<?> fieldClass) {
            Intrinsics.checkNotNullParameter(receiverClass, (String)"receiverClass");
            Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
            Intrinsics.checkNotNullParameter(fieldClass, (String)"fieldClass");
            return new CheckedField(true, false, receiverClass, fieldName, fieldClass, null);
        }

        @NotNull
        public final CheckedField staticField(@NotNull Class<?> receiverClass, @NotNull String fieldName, @NotNull Class<?> fieldClass) {
            Intrinsics.checkNotNullParameter(receiverClass, (String)"receiverClass");
            Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
            Intrinsics.checkNotNullParameter(fieldClass, (String)"fieldClass");
            return new CheckedField(true, true, receiverClass, fieldName, fieldClass, null);
        }

        @NotNull
        public final <T extends Enum<T>> CheckedField enumField(@NotNull T enumInstance) {
            Intrinsics.checkNotNullParameter(enumInstance, (String)"enumInstance");
            Class<?> clazz = enumInstance.getClass();
            Class<?> clazz2 = clazz.getSuperclass();
            Intrinsics.checkNotNullExpressionValue(clazz2, (String)"clazz.superclass");
            Class<?> zuper = clazz2;
            Class<?> enumClass = Intrinsics.areEqual(zuper, Enum.class) ? clazz : zuper;
            return new CheckedField(false, true, enumClass, enumInstance.name(), enumClass, null);
        }

        @NotNull
        public final CheckedField javaLibraryInstanceField(@NotNull Class<?> receiverClass, @NotNull String fieldName, @NotNull Class<?> fieldClass) {
            Intrinsics.checkNotNullParameter(receiverClass, (String)"receiverClass");
            Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
            Intrinsics.checkNotNullParameter(fieldClass, (String)"fieldClass");
            return new CheckedField(false, false, receiverClass, fieldName, fieldClass, null);
        }

        @NotNull
        public final CheckedField javaLibraryStaticField(@NotNull Class<?> receiverClass, @NotNull String fieldName, @NotNull Class<?> fieldClass) {
            Intrinsics.checkNotNullParameter(receiverClass, (String)"receiverClass");
            Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
            Intrinsics.checkNotNullParameter(fieldClass, (String)"fieldClass");
            return new CheckedField(false, true, receiverClass, fieldName, fieldClass, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

