/*
 * Decompiled with CFR 0.152.
 */
package avail.serialization;

import avail.serialization.IndexCompressor;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0016J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lavail/serialization/FourStreamIndexCompressor;", "Lavail/serialization/IndexCompressor;", "()V", "currentIndex", "", "pointers", "", "predecessors", "successors", "compress", "index", "decompress", "incrementIndex", "", "moveToHead", "pointer", "avail"})
public final class FourStreamIndexCompressor
implements IndexCompressor {
    @NotNull
    private final int[] pointers;
    @NotNull
    private final int[] successors;
    @NotNull
    private final int[] predecessors;
    private int currentIndex;

    public FourStreamIndexCompressor() {
        int n;
        int n2 = 0;
        int[] nArray = new int[4];
        FourStreamIndexCompressor fourStreamIndexCompressor = this;
        while (n2 < 4) {
            n = n2++;
            nArray[n] = 0;
        }
        fourStreamIndexCompressor.pointers = nArray;
        n2 = 0;
        nArray = new int[5];
        fourStreamIndexCompressor = this;
        while (n2 < 5) {
            n = n2++;
            nArray[n] = (n + 1) % 5;
        }
        fourStreamIndexCompressor.successors = nArray;
        n2 = 0;
        nArray = new int[5];
        fourStreamIndexCompressor = this;
        while (n2 < 5) {
            n = n2++;
            nArray[n] = (n + 4) % 5;
        }
        fourStreamIndexCompressor.predecessors = nArray;
    }

    @Override
    public int compress(int index2) {
        for (int pointerNumber = 0; pointerNumber < 4; ++pointerNumber) {
            int delta = index2 - this.pointers[pointerNumber];
            boolean bl = -16 <= delta ? delta < 16 : false;
            if (!bl) continue;
            this.pointers[pointerNumber] = index2;
            this.moveToHead(pointerNumber);
            return (delta + 16 << 2) + pointerNumber;
        }
        int victimPointer = this.predecessors[4];
        this.pointers[victimPointer] = index2;
        this.moveToHead(victimPointer);
        return this.currentIndex - index2 + 128;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int decompress(int index2) {
        int n;
        if (index2 < 128) {
            int victimPointer = index2 & 3;
            int delta = (index2 >> 2) - 16;
            int[] nArray = this.pointers;
            nArray[victimPointer] = nArray[victimPointer] + delta;
            this.moveToHead(victimPointer);
            n = this.pointers[victimPointer];
        } else {
            void var3_5;
            int absoluteIndex;
            int victimPointer = this.predecessors[4];
            this.pointers[victimPointer] = absoluteIndex = this.currentIndex - (index2 - 128);
            this.moveToHead(victimPointer);
            n = var3_5;
        }
        return n;
    }

    @Override
    public void incrementIndex() {
        int n = this.currentIndex;
        this.currentIndex = n + 1;
    }

    @Override
    public int currentIndex() {
        return this.currentIndex;
    }

    private final void moveToHead(int pointer) {
        int oldHead;
        int oldSuccessor;
        int oldPredecessor = this.predecessors[pointer];
        this.successors[oldPredecessor] = oldSuccessor = this.successors[pointer];
        this.predecessors[oldSuccessor] = oldPredecessor;
        this.successors[pointer] = oldHead = this.successors[4];
        this.predecessors[pointer] = 4;
        this.predecessors[oldHead] = pointer;
        this.successors[4] = pointer;
    }
}

