/*
 * Decompiled with CFR 0.152.
 */
package avail.utility;

import avail.utility.Graph;
import avail.utility.evaluation.Combinator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.reflect.KProperty1;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 K*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0003KLMB\u0015\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000\u00a2\u0006\u0002\u0010\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u001b\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00028\u00002\u0006\u0010*\u001a\u00028\u0000\u00a2\u0006\u0002\u0010+J\u0013\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00028\u0000\u00a2\u0006\u0002\u0010.J\u0014\u0010/\u001a\u00020(2\f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u000000J\u001a\u00101\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u00102\u001a\b\u0012\u0004\u0012\u00028\u000000J\u0006\u00103\u001a\u00020(J\u0013\u00104\u001a\u00020(2\u0006\u0010-\u001a\u00028\u0000\u00a2\u0006\u0002\u0010.J\u001b\u00105\u001a\u00020(2\u0006\u0010)\u001a\u00028\u00002\u0006\u0010*\u001a\u00028\u0000\u00a2\u0006\u0002\u0010+J\u0013\u00106\u001a\u00020(2\u0006\u0010)\u001a\u00028\u0000\u00a2\u0006\u0002\u0010.J\u0013\u00107\u001a\u00020(2\u0006\u0010*\u001a\u00028\u0000\u00a2\u0006\u0002\u0010.J\u0013\u00108\u001a\u00020(2\u0006\u0010-\u001a\u00028\u0000\u00a2\u0006\u0002\u0010.J\u001b\u00109\u001a\u00020(2\u0006\u0010)\u001a\u00028\u00002\u0006\u0010*\u001a\u00028\u0000\u00a2\u0006\u0002\u0010+J\u0013\u0010:\u001a\u00020(2\u0006\u0010-\u001a\u00028\u0000\u00a2\u0006\u0002\u0010.J\u001b\u0010;\u001a\u00020\u00122\u0006\u0010)\u001a\u00028\u00002\u0006\u0010*\u001a\u00028\u0000\u00a2\u0006\u0002\u0010<J\u0013\u0010=\u001a\u00020\u00122\u0006\u0010-\u001a\u00028\u0000\u00a2\u0006\u0002\u0010>J&\u0010?\u001a\u00020(2\u001e\u0010@\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0B\u0012\u0004\u0012\u00020(0AJ4\u0010C\u001a\u00020(2\u001e\u0010@\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0B\u0012\u0004\u0012\u00020(0A2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020(0BJ\u0019\u0010E\u001a\b\u0012\u0004\u0012\u00028\u00000\u00192\u0006\u0010-\u001a\u00028\u0000\u00a2\u0006\u0002\u0010FJ\u001b\u0010G\u001a\u00020(2\u0006\u0010)\u001a\u00028\u00002\u0006\u0010*\u001a\u00028\u0000\u00a2\u0006\u0002\u0010+J\u0013\u0010H\u001a\u00020(2\u0006\u0010-\u001a\u00028\u0000\u00a2\u0006\u0002\u0010.J\u0019\u0010I\u001a\b\u0012\u0004\u0012\u00028\u00000\u00192\u0006\u0010-\u001a\u00028\u0000\u00a2\u0006\u0002\u0010FJ\u001a\u0010J\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u0000R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00008F\u00a2\u0006\f\u0012\u0004\b\u0007\u0010\u0005\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013R \u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\tR\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001d\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u00008F\u00a2\u0006\f\u0012\u0004\b!\u0010\u0005\u001a\u0004\b\"\u0010\tR\u0011\u0010#\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001fR\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\u00198F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001b\u00a8\u0006N"}, d2={"Lavail/utility/Graph;", "Vertex", "", "graph", "(Lavail/utility/Graph;)V", "()V", "dagWithoutRedundantEdges", "getDagWithoutRedundantEdges$annotations", "getDagWithoutRedundantEdges", "()Lavail/utility/Graph;", "firstCycle", "", "getFirstCycle", "()Ljava/util/List;", "inEdges", "", "", "isCyclic", "", "()Z", "isEmpty", "outEdges", "reverse", "getReverse", "roots", "", "getRoots", "()Ljava/util/Set;", "size", "", "getSize", "()I", "spanningDag", "getSpanningDag$annotations", "getSpanningDag", "vertexCount", "getVertexCount", "vertices", "getVertices", "addEdge", "", "sourceVertex", "targetVertex", "(Ljava/lang/Object;Ljava/lang/Object;)V", "addVertex", "vertex", "(Ljava/lang/Object;)V", "addVertices", "", "ancestryOfAll", "seeds", "clear", "exciseVertex", "excludeEdge", "excludeEdgesFrom", "excludeEdgesTo", "excludeVertex", "includeEdge", "includeVertex", "includesEdge", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "includesVertex", "(Ljava/lang/Object;)Z", "parallelVisit", "visitAction", "Lkotlin/Function2;", "Lkotlin/Function0;", "parallelVisitThen", "afterTraversal", "predecessorsOf", "(Ljava/lang/Object;)Ljava/util/Set;", "removeEdge", "removeVertex", "successorsOf", "withoutRedundantEdges", "Companion", "GraphPreconditionFailure", "ParallelVisitor", "avail"})
public final class Graph<Vertex> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Vertex, Set<Vertex>> outEdges;
    @NotNull
    private final Map<Vertex, Set<Vertex>> inEdges;

    public Graph() {
        this.outEdges = new LinkedHashMap();
        this.inEdges = new LinkedHashMap();
    }

    public Graph(@NotNull Graph<Vertex> graph) {
        Set v;
        Object k;
        Map.Entry entry;
        Map<Vertex, Set<Vertex>> map;
        Iterable $this$associateTo$iv;
        Intrinsics.checkNotNullParameter(graph, (String)"graph");
        this();
        Iterable iterable = graph.outEdges.entrySet();
        Map<Vertex, Set<Vertex>> destination$iv = this.outEdges;
        boolean $i$f$associateTo = false;
        for (Object element$iv : $this$associateTo$iv) {
            map = destination$iv;
            entry = (Map.Entry)element$iv;
            boolean bl = false;
            k = entry.getKey();
            v = (Set)entry.getValue();
            entry = TuplesKt.to(k, (Object)CollectionsKt.toMutableSet((Iterable)v));
            map.put((Vertex)entry.getFirst(), (Set<Vertex>)entry.getSecond());
        }
        $this$associateTo$iv = graph.inEdges.entrySet();
        destination$iv = this.inEdges;
        $i$f$associateTo = false;
        for (Object element$iv : $this$associateTo$iv) {
            map = destination$iv;
            entry = (Map.Entry)element$iv;
            boolean bl = false;
            k = entry.getKey();
            v = (Set)entry.getValue();
            entry = TuplesKt.to(k, (Object)CollectionsKt.toMutableSet((Iterable)v));
            map.put((Vertex)entry.getFirst(), (Set<Vertex>)entry.getSecond());
        }
    }

    public final void clear() {
        this.outEdges.clear();
        this.inEdges.clear();
    }

    public final void addVertex(Vertex vertex) {
        Companion.ensure(!this.outEdges.containsKey(vertex), "vertex is already in graph");
        this.outEdges.put(vertex, new LinkedHashSet());
        this.inEdges.put(vertex, new LinkedHashSet());
    }

    public final void addVertices(@NotNull Collection<? extends Vertex> vertices) {
        Intrinsics.checkNotNullParameter(vertices, (String)"vertices");
        for (Vertex vertex : vertices) {
            Companion.ensure(!this.outEdges.containsKey(vertex), "vertex is already in graph");
            this.outEdges.put(vertex, new LinkedHashSet());
            this.inEdges.put(vertex, new LinkedHashSet());
        }
    }

    public final void includeVertex(Vertex vertex) {
        if (!this.outEdges.containsKey(vertex)) {
            this.outEdges.put(vertex, new LinkedHashSet());
            this.inEdges.put(vertex, new LinkedHashSet());
        }
    }

    public final void removeVertex(Vertex vertex) {
        Companion.ensure(this.outEdges.containsKey(vertex), "vertex is not present");
        this.excludeVertex(vertex);
    }

    public final void excludeVertex(Vertex vertex) {
        Set<Vertex> outVertices = this.outEdges.get(vertex);
        if (outVertices != null) {
            Set<Vertex> set2 = this.inEdges.get(vertex);
            if (set2 == null) {
                throw new IllegalStateException("Inconsistent edge information in graph".toString());
            }
            Set<Vertex> inVertices = set2;
            Companion.ensure(outVertices.isEmpty(), "vertex has outbound edges");
            Companion.ensure(inVertices.isEmpty(), "vertex has inbound edges");
            this.outEdges.remove(vertex);
            this.inEdges.remove(vertex);
        }
    }

    public final void exciseVertex(Vertex vertex) {
        this.excludeEdgesFrom(vertex);
        this.excludeEdgesTo(vertex);
        this.excludeVertex(vertex);
    }

    public final boolean includesVertex(Vertex vertex) {
        return this.outEdges.containsKey(vertex);
    }

    public final void addEdge(Vertex sourceVertex, Vertex targetVertex) {
        Set<Vertex> sourceOutSet = this.outEdges.get(sourceVertex);
        Companion.notNull(sourceOutSet, "source vertex is not present");
        Set<Vertex> targetInSet = this.inEdges.get(targetVertex);
        Companion.notNull(targetInSet, "target vertex is not present");
        Set<Vertex> set2 = sourceOutSet;
        Intrinsics.checkNotNull(set2);
        Companion.ensure(!set2.contains(targetVertex), "edge is already present");
        sourceOutSet.add(targetVertex);
        Set<Vertex> set3 = targetInSet;
        Intrinsics.checkNotNull(set3);
        set3.add(sourceVertex);
    }

    public final void includeEdge(Vertex sourceVertex, Vertex targetVertex) {
        Set<Vertex> sourceOutSet = this.outEdges.get(sourceVertex);
        Companion.notNull(sourceOutSet, "source vertex is not in graph");
        Set<Vertex> targetInSet = this.inEdges.get(targetVertex);
        Companion.notNull(targetInSet, "target vertex is not in graph");
        Set<Vertex> set2 = sourceOutSet;
        Intrinsics.checkNotNull(set2);
        set2.add(targetVertex);
        Set<Vertex> set3 = targetInSet;
        Intrinsics.checkNotNull(set3);
        set3.add(sourceVertex);
    }

    public final void removeEdge(Vertex sourceVertex, Vertex targetVertex) {
        Set<Vertex> sourceOutSet = this.outEdges.get(sourceVertex);
        Companion.notNull(sourceOutSet, "source vertex is not in graph");
        Set<Vertex> targetInSet = this.inEdges.get(targetVertex);
        Companion.notNull(targetInSet, "target vertex is not in graph");
        Set<Vertex> set2 = sourceOutSet;
        Intrinsics.checkNotNull(set2);
        Companion.ensure(set2.contains(targetVertex), "edge is not in graph");
        sourceOutSet.remove(targetVertex);
        Set<Vertex> set3 = targetInSet;
        Intrinsics.checkNotNull(set3);
        set3.remove(sourceVertex);
    }

    public final void excludeEdge(Vertex sourceVertex, Vertex targetVertex) {
        Set<Vertex> sourceOutSet = this.outEdges.get(sourceVertex);
        Companion.notNull(sourceOutSet, "source vertex is not in graph");
        Set<Vertex> targetInSet = this.inEdges.get(targetVertex);
        Companion.notNull(targetInSet, "target vertex is not in graph");
        Set<Vertex> set2 = sourceOutSet;
        Intrinsics.checkNotNull(set2);
        set2.remove(targetVertex);
        Set<Vertex> set3 = targetInSet;
        Intrinsics.checkNotNull(set3);
        set3.remove(sourceVertex);
    }

    public final void excludeEdgesFrom(Vertex sourceVertex) {
        Set<Vertex> sourceOutSet = this.outEdges.get(sourceVertex);
        Companion.notNull(sourceOutSet, "source vertex is not in graph");
        Set<Vertex> set2 = sourceOutSet;
        Intrinsics.checkNotNull(set2);
        Iterable $this$forEach$iv = set2;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator2.next();
            boolean bl = false;
            Set<Vertex> set3 = this.inEdges.get(it);
            Intrinsics.checkNotNull(set3);
            set3.remove(sourceVertex);
        }
        sourceOutSet.clear();
    }

    public final void excludeEdgesTo(Vertex targetVertex) {
        Set<Vertex> targetInSet = this.inEdges.get(targetVertex);
        Companion.notNull(targetInSet, "target vertex is not in graph");
        Set<Vertex> set2 = targetInSet;
        Intrinsics.checkNotNull(set2);
        Iterable $this$forEach$iv = set2;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator2.next();
            boolean bl = false;
            Set<Vertex> set3 = this.outEdges.get(it);
            Intrinsics.checkNotNull(set3);
            set3.remove(targetVertex);
        }
        targetInSet.clear();
    }

    public final boolean includesEdge(Vertex sourceVertex, Vertex targetVertex) {
        Set<Vertex> sourceOutSet = this.outEdges.get(sourceVertex);
        Companion.notNull(sourceOutSet, "source vertex is not in graph");
        Set<Vertex> targetInSet = this.inEdges.get(targetVertex);
        Companion.notNull(targetInSet, "target vertex is not in graph");
        Set<Vertex> set2 = sourceOutSet;
        Intrinsics.checkNotNull(set2);
        return set2.contains(targetVertex);
    }

    public final int getSize() {
        return this.outEdges.size();
    }

    public final boolean isEmpty() {
        return this.outEdges.isEmpty();
    }

    @NotNull
    public final Set<Vertex> getVertices() {
        return CollectionsKt.toSet((Iterable)this.outEdges.keySet());
    }

    public final int getVertexCount() {
        return this.outEdges.size();
    }

    @NotNull
    public final Set<Vertex> successorsOf(Vertex vertex) {
        Companion.ensure(this.outEdges.containsKey(vertex), "source vertex is not in graph");
        Set<Vertex> set2 = this.outEdges.get(vertex);
        Intrinsics.checkNotNull(set2);
        return CollectionsKt.toSet((Iterable)set2);
    }

    @NotNull
    public final Set<Vertex> predecessorsOf(Vertex vertex) {
        Companion.ensure(this.inEdges.containsKey(vertex), "target vertex is not in graph");
        Set<Vertex> set2 = this.inEdges.get(vertex);
        Intrinsics.checkNotNull(set2);
        return CollectionsKt.toSet((Iterable)set2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Vertex> getRoots() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.inEdges.keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv;
            Object it = element$iv$iv = iterator2.next();
            boolean bl = false;
            Set<Vertex> set2 = this.inEdges.get(it);
            Intrinsics.checkNotNull(set2);
            if (!set2.isEmpty()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public final boolean isCyclic() {
        Map predecessorCountdowns = new LinkedHashMap();
        Deque stack = new ArrayDeque();
        Map<Vertex, Set<Vertex>> $this$forEach$iv = this.inEdges;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Vertex, Set<Vertex>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Vertex, Set<Vertex>> element$iv;
            Map.Entry<Vertex, Set<Vertex>> entry = element$iv = iterator2.next();
            boolean bl = false;
            Vertex vertex = entry.getKey();
            Set<Vertex> value = entry.getValue();
            int predecessorsSize = value.size();
            if (predecessorsSize == 0) {
                predecessorCountdowns.put(vertex, 1);
                stack.add(vertex);
                continue;
            }
            Integer n = predecessorsSize;
            predecessorCountdowns.put(vertex, n);
        }
        while (!stack.isEmpty()) {
            boolean bl;
            Object vertex = stack.removeLast();
            Object v = predecessorCountdowns.get(vertex);
            Intrinsics.checkNotNull(v);
            int countdown = ((Number)v).intValue();
            if (countdown == 1) {
                predecessorCountdowns.remove(vertex);
                Set<Vertex> set2 = this.outEdges.get(vertex);
                Intrinsics.checkNotNull(set2);
                stack.addAll((Collection)set2);
                continue;
            }
            boolean bl2 = bl = countdown > 1;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            predecessorCountdowns.put(vertex, countdown - 1);
        }
        return !predecessorCountdowns.isEmpty();
    }

    @NotNull
    public final List<Vertex> getFirstCycle() {
        boolean bl = this.isCyclic();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        Set stack = new LinkedHashSet();
        Set reached = new LinkedHashSet();
        Ref.ObjectRef solution = new Ref.ObjectRef();
        for (Vertex start : this.outEdges.keySet()) {
            boolean bl2 = stack.isEmpty();
            if (_Assertions.ENABLED && !bl2) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            Combinator.INSTANCE.recurse(start, (Function2)new Function2<Vertex, Function1<? super Vertex, ? extends Unit>, Unit>(solution, stack, reached, this){
                final /* synthetic */ Ref.ObjectRef<List<Vertex>> $solution;
                final /* synthetic */ Set<Vertex> $stack;
                final /* synthetic */ Set<Vertex> $reached;
                final /* synthetic */ Graph<Vertex> this$0;
                {
                    this.$solution = $solution;
                    this.$stack = $stack;
                    this.$reached = $reached;
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(Vertex vertex, @NotNull Function1<? super Vertex, Unit> body2) {
                    Intrinsics.checkNotNullParameter(body2, (String)"body");
                    if (this.$solution.element != null) {
                        return;
                    }
                    if (this.$stack.contains(vertex)) {
                        List list2 = CollectionsKt.toMutableList((Collection)this.$stack);
                        list2.add(vertex);
                        this.$solution.element = list2.subList(list2.indexOf(vertex), list2.size());
                        return;
                    }
                    if (!this.$reached.contains(vertex)) {
                        this.$reached.add(vertex);
                        this.$stack.add(vertex);
                        V v = Graph.access$getOutEdges$p(this.this$0).get(vertex);
                        Intrinsics.checkNotNull(v);
                        Iterable $this$forEach$iv = (Iterable)v;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator2 = $this$forEach$iv.iterator();
                        while (iterator2.hasNext()) {
                            T element$iv;
                            T successor = element$iv = iterator2.next();
                            boolean bl = false;
                            body2.invoke(successor);
                        }
                        this.$stack.remove(vertex);
                    }
                }
            });
            if (solution.element == null) continue;
        }
        Object object = solution.element;
        Intrinsics.checkNotNull((Object)object);
        return (List)object;
    }

    @NotNull
    public final Graph<Vertex> getReverse() {
        Set v;
        Object k;
        Map.Entry entry;
        Map<Vertex, Set<Vertex>> map;
        Iterable $this$associateTo$iv;
        Graph<Vertex> result2 = new Graph<Vertex>();
        Iterable iterable = this.outEdges.entrySet();
        Map<Vertex, Set<Vertex>> destination$iv = result2.inEdges;
        boolean $i$f$associateTo = false;
        for (Object element$iv : $this$associateTo$iv) {
            map = destination$iv;
            entry = (Map.Entry)element$iv;
            boolean bl = false;
            k = entry.getKey();
            v = (Set)entry.getValue();
            entry = TuplesKt.to(k, (Object)CollectionsKt.toMutableSet((Iterable)v));
            map.put((Vertex)entry.getFirst(), (Set<Vertex>)entry.getSecond());
        }
        $this$associateTo$iv = this.inEdges.entrySet();
        destination$iv = result2.outEdges;
        $i$f$associateTo = false;
        for (Object element$iv : $this$associateTo$iv) {
            map = destination$iv;
            entry = (Map.Entry)element$iv;
            boolean bl = false;
            k = entry.getKey();
            v = (Set)entry.getValue();
            entry = TuplesKt.to(k, (Object)CollectionsKt.toMutableSet((Iterable)v));
            map.put((Vertex)entry.getFirst(), (Set<Vertex>)entry.getSecond());
        }
        return result2;
    }

    public final void parallelVisitThen(@NotNull Function2<? super Vertex, ? super Function0<Unit>, Unit> visitAction, @NotNull Function0<Unit> afterTraversal) {
        Intrinsics.checkNotNullParameter(visitAction, (String)"visitAction");
        Intrinsics.checkNotNullParameter(afterTraversal, (String)"afterTraversal");
        new ParallelVisitor(visitAction, afterTraversal).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void parallelVisit(@NotNull Function2<? super Vertex, ? super Function0<Unit>, Unit> visitAction) {
        boolean bl;
        Intrinsics.checkNotNullParameter(visitAction, (String)"visitAction");
        boolean bl2 = bl = !this.isCyclic();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        AtomicBoolean safetyCheck = new AtomicBoolean(false);
        ArrayDeque<Function0<Unit>> workQueue = new ArrayDeque<Function0<Unit>>();
        Object monitor = new Object();
        Function2 wrappedAction2 = new Function2<Vertex, Function0<? extends Unit>, Unit>(monitor, workQueue, visitAction){
            final /* synthetic */ Object $monitor;
            final /* synthetic */ ArrayDeque<Function0<Unit>> $workQueue;
            final /* synthetic */ Function2<Vertex, Function0<Unit>, Unit> $visitAction;
            {
                this.$monitor = $monitor;
                this.$workQueue = $workQueue;
                this.$visitAction = $visitAction;
                super(2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(Vertex vertex, @NotNull Function0<Unit> doneOne) {
                Intrinsics.checkNotNullParameter(doneOne, (String)"doneOne");
                Object object = this.$monitor;
                ArrayDeque<Function0<Unit>> arrayDeque = this.$workQueue;
                Object object2 = this.$monitor;
                Function2<Vertex, Function0<Unit>, Unit> function2 = this.$visitAction;
                Object object3 = object;
                synchronized (object3) {
                    boolean bl = false;
                    arrayDeque.add(new Function0<Unit>(function2, vertex, doneOne){
                        final /* synthetic */ Function2<Vertex, Function0<Unit>, Unit> $visitAction;
                        final /* synthetic */ Vertex $vertex;
                        final /* synthetic */ Function0<Unit> $doneOne;
                        {
                            this.$visitAction = $visitAction;
                            this.$vertex = $vertex;
                            this.$doneOne = $doneOne;
                            super(0);
                        }

                        public final void invoke() {
                            this.$visitAction.invoke(this.$vertex, this.$doneOne);
                        }
                    });
                    object2.notify();
                    Unit unit = Unit.INSTANCE;
                }
            }
        };
        Ref.BooleanRef allDoneFlag = new Ref.BooleanRef();
        this.parallelVisitThen(wrappedAction2, (Function0<Unit>)((Function0)new Function0<Unit>(safetyCheck, monitor, allDoneFlag){
            final /* synthetic */ AtomicBoolean $safetyCheck;
            final /* synthetic */ Object $monitor;
            final /* synthetic */ Ref.BooleanRef $allDoneFlag;
            {
                this.$safetyCheck = $safetyCheck;
                this.$monitor = $monitor;
                this.$allDoneFlag = $allDoneFlag;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                boolean bl;
                boolean old = this.$safetyCheck.getAndSet(true);
                boolean bl2 = bl = !old;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string2 = "Reached end of graph traversal twice";
                    throw new AssertionError((Object)string2);
                }
                Object object = this.$monitor;
                Ref.BooleanRef booleanRef = this.$allDoneFlag;
                Object object2 = this.$monitor;
                Object object3 = object;
                synchronized (object3) {
                    boolean bl4 = false;
                    booleanRef.element = true;
                    object2.notify();
                    Unit unit = Unit.INSTANCE;
                }
            }
        }));
        boolean isDone = false;
        Object object = monitor;
        synchronized (object) {
            boolean bl3 = false;
            while (true) {
                if (!((Collection)workQueue).isEmpty()) {
                    workQueue.remove().invoke();
                    continue;
                }
                isDone = allDoneFlag.element;
                if (!isDone) {
                    monitor.wait();
                }
                if (isDone) break;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public final Graph<Vertex> ancestryOfAll(@NotNull Collection<? extends Vertex> seeds) {
        Object vertex;
        Object element$iv;
        Iterator iterator2;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter(seeds, (String)"seeds");
        Set ancestrySet = CollectionsKt.toMutableSet((Iterable)seeds);
        Set newAncestors = null;
        newAncestors = CollectionsKt.toMutableSet((Iterable)seeds);
        while (!((Collection)newAncestors).isEmpty()) {
            Set previousAncestors = newAncestors;
            newAncestors = new LinkedHashSet();
            $this$forEach$iv = previousAncestors;
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                vertex = element$iv = iterator2.next();
                boolean bl = false;
                newAncestors.addAll(this.predecessorsOf(vertex));
            }
            newAncestors.removeAll(ancestrySet);
            ancestrySet.addAll(newAncestors);
        }
        Graph ancestryGraph = new Graph(this);
        $this$forEach$iv = CollectionsKt.toList((Iterable)ancestryGraph.outEdges.keySet());
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            vertex = element$iv = iterator2.next();
            boolean bl = false;
            if (ancestrySet.contains(vertex)) continue;
            ancestryGraph.exciseVertex(vertex);
        }
        return ancestryGraph;
    }

    @NotNull
    public final Graph<Vertex> getSpanningDag() {
        Graph<Vertex> spanningDag2 = new Graph<Vertex>();
        spanningDag2.addVertices((Collection)this.getVertices());
        Set stackSet = new LinkedHashSet();
        List stackList = new ArrayList();
        List scanned = new ArrayList();
        this.outEdges.entrySet().stream().sorted(Comparator.comparingInt(Graph::_get_spanningDag_$lambda-11).thenComparing(Graph::_get_spanningDag_$lambda-12)).map(arg_0 -> Graph._get_spanningDag_$lambda-13((KProperty1)spanningDag.3.INSTANCE, arg_0)).forEach(arg_0 -> Graph._get_spanningDag_$lambda-14(stackSet, stackList, spanningDag2, scanned, this, arg_0));
        return spanningDag2;
    }

    public static /* synthetic */ void getSpanningDag$annotations() {
    }

    @NotNull
    public final Graph<Vertex> getDagWithoutRedundantEdges() {
        boolean bl;
        boolean bl2 = bl = !this.isCyclic();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        Map ancestorSets = new LinkedHashMap();
        this.parallelVisit((Function2)new Function2<Vertex, Function0<? extends Unit>, Unit>(this, ancestorSets){
            final /* synthetic */ Graph<Vertex> this$0;
            final /* synthetic */ Map<Vertex, Set<Vertex>> $ancestorSets;
            {
                this.this$0 = $receiver;
                this.$ancestorSets = $ancestorSets;
                super(2);
            }

            public final void invoke(Vertex vertex, @NotNull Function0<Unit> completionAction) {
                Intrinsics.checkNotNullParameter(completionAction, (String)"completionAction");
                Set ancestorSet = null;
                Set<Vertex> predecessors = this.this$0.predecessorsOf(vertex);
                if (predecessors.isEmpty()) {
                    ancestorSet = SetsKt.emptySet();
                } else if (predecessors.size() == 1) {
                    Object predecessor = CollectionsKt.single((Iterable)predecessors);
                    Set<Vertex> set2 = this.$ancestorSets.get(predecessor);
                    Intrinsics.checkNotNull(set2);
                    ancestorSet = CollectionsKt.toMutableSet((Iterable)set2);
                    ancestorSet.add(predecessor);
                } else {
                    ancestorSet = new LinkedHashSet<E>();
                    for (Vertex predecessor : predecessors) {
                        Set<Vertex> set3 = this.$ancestorSets.get(predecessor);
                        Intrinsics.checkNotNull(set3);
                        ancestorSet.addAll((Collection)set3);
                        ancestorSet.add(predecessor);
                    }
                }
                this.$ancestorSets.put(vertex, ancestorSet);
                completionAction.invoke();
            }
        });
        Graph result2 = new Graph();
        result2.addVertices((Collection)this.getVertices());
        Map<Vertex, Set<Vertex>> $this$forEach$iv = this.inEdges;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Vertex, Set<Vertex>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Vertex, Set<Vertex>> element$iv;
            Map.Entry<Vertex, Set<Vertex>> entry = element$iv = iterator2.next();
            boolean bl3 = false;
            Vertex destination = entry.getKey();
            Set<Vertex> destinationPredecessors = entry.getValue();
            Iterable $this$forEach$iv2 = destinationPredecessors;
            boolean $i$f$forEach2 = false;
            Iterator iterator3 = $this$forEach$iv2.iterator();
            while (iterator3.hasNext()) {
                Object element$iv2;
                Object source2 = element$iv2 = iterator3.next();
                boolean bl4 = false;
                boolean isRedundant = false;
                for (Vertex destinationPredecessor : destinationPredecessors) {
                    Object v = ancestorSets.get(destinationPredecessor);
                    Intrinsics.checkNotNull(v);
                    if (!((Set)v).contains(source2)) continue;
                    isRedundant = true;
                    break;
                }
                if (isRedundant) continue;
                result2.addEdge(source2, destination);
            }
        }
        return result2;
    }

    public static /* synthetic */ void getDagWithoutRedundantEdges$annotations() {
    }

    @NotNull
    public final Graph<Vertex> withoutRedundantEdges(@NotNull Graph<Vertex> spanningDag2) {
        Intrinsics.checkNotNullParameter(spanningDag2, (String)"spanningDag");
        Graph<Vertex> reduced = spanningDag2.getDagWithoutRedundantEdges();
        Map<Vertex, Set<Vertex>> $this$forEach$iv = this.outEdges;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Vertex, Set<Vertex>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Vertex, Set<Vertex>> element$iv;
            Map.Entry<Vertex, Set<Vertex>> entry = element$iv = iterator2.next();
            boolean bl = false;
            Vertex vertex = entry.getKey();
            Set<Vertex> originalSuccessors = entry.getValue();
            Set<Vertex> dagSuccessors = spanningDag2.successorsOf(vertex);
            if (dagSuccessors.size() >= originalSuccessors.size()) continue;
            Iterable $this$forEach$iv2 = originalSuccessors;
            boolean $i$f$forEach2 = false;
            Iterator iterator3 = $this$forEach$iv2.iterator();
            while (iterator3.hasNext()) {
                Object element$iv2;
                Object successor = element$iv2 = iterator3.next();
                boolean bl2 = false;
                if (dagSuccessors.contains(successor)) continue;
                reduced.addEdge(vertex, successor);
            }
        }
        return reduced;
    }

    private static final int _get_spanningDag_$lambda-11(Map.Entry e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return ((Set)e.getValue()).size();
    }

    private static final String _get_spanningDag_$lambda-12(Map.Entry e) {
        return String.valueOf(e.getKey());
    }

    private static final Object _get_spanningDag_$lambda-13(KProperty1 $tmp0, Map.Entry p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Function1)$tmp0).invoke((Object)p0);
    }

    private static final void _get_spanningDag_$lambda-14(Set $stackSet, List $stackList, Graph $spanningDag, List $scanned, Graph this$0, Object startVertex) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$stackSet, (String)"$stackSet");
        Intrinsics.checkNotNullParameter((Object)$stackList, (String)"$stackList");
        Intrinsics.checkNotNullParameter((Object)$spanningDag, (String)"$spanningDag");
        Intrinsics.checkNotNullParameter((Object)$scanned, (String)"$scanned");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        boolean bl2 = bl = $stackSet.isEmpty() && $stackList.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        Combinator.INSTANCE.recurse(startVertex, (Function2)new Function2<Vertex, Function1<? super Vertex, ? extends Unit>, Unit>($stackSet, $stackList, $spanningDag, $scanned, this$0){
            final /* synthetic */ Set<Vertex> $stackSet;
            final /* synthetic */ List<Vertex> $stackList;
            final /* synthetic */ Graph<Vertex> $spanningDag;
            final /* synthetic */ List<Vertex> $scanned;
            final /* synthetic */ Graph<Vertex> this$0;
            {
                this.$stackSet = $stackSet;
                this.$stackList = $stackList;
                this.$spanningDag = $spanningDag;
                this.$scanned = $scanned;
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(Vertex vertex, @NotNull Function1<? super Vertex, Unit> body2) {
                Intrinsics.checkNotNullParameter(body2, (String)"body");
                if (!this.$stackSet.contains(vertex)) {
                    if (!((Collection)this.$stackList).isEmpty()) {
                        this.$spanningDag.addEdge(this.$stackList.get(this.$stackList.size() - 1), vertex);
                    }
                    if (!this.$scanned.contains(vertex)) {
                        this.$scanned.add(vertex);
                        this.$stackSet.add(vertex);
                        this.$stackList.add(vertex);
                        V v = Graph.access$getOutEdges$p(this.this$0).get(vertex);
                        Intrinsics.checkNotNull(v);
                        Iterable $this$forEach$iv = (Iterable)v;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator2 = $this$forEach$iv.iterator();
                        while (iterator2.hasNext()) {
                            T element$iv;
                            T p = element$iv = iterator2.next();
                            boolean bl = false;
                            body2.invoke(p);
                        }
                        this.$stackSet.remove(vertex);
                        this.$stackList.remove(vertex);
                    }
                }
            }
        });
    }

    public static final /* synthetic */ Map access$getOutEdges$p(Graph $this) {
        return $this.outEdges;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0011\b\u0000\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lavail/utility/Graph$GraphPreconditionFailure;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "message", "", "(Ljava/lang/String;)V", "avail"})
    public static final class GraphPreconditionFailure
    extends RuntimeException {
        public GraphPreconditionFailure(@Nullable String message) {
            super(message);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B5\b\u0000\u0012\u001e\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0005H\u0002J\u0006\u0010\u0013\u001a\u00020\u0005J\u0016\u0010\u0014\u001a\u00020\u00052\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0005H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R&\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lavail/utility/Graph$ParallelVisitor;", "", "visitAction", "Lkotlin/Function2;", "Lkotlin/Function0;", "", "afterTraversal", "(Lavail/utility/Graph;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function0;)V", "completionCountdown", "Ljava/util/concurrent/atomic/AtomicInteger;", "getCompletionCountdown", "()Ljava/util/concurrent/atomic/AtomicInteger;", "predecessorCountdowns", "", "queue", "Ljava/util/Deque;", "getQueue", "()Ljava/util/Deque;", "computePredecessorCountdowns", "execute", "queueSuccessors", "vertices", "", "visitRemainingVertices", "avail"})
    private final class ParallelVisitor {
        @NotNull
        private final Function2<Vertex, Function0<Unit>, Unit> visitAction;
        @NotNull
        private final Function0<Unit> afterTraversal;
        @NotNull
        private final Map<Vertex, AtomicInteger> predecessorCountdowns;
        @NotNull
        private final Deque<Vertex> queue;
        @NotNull
        private final AtomicInteger completionCountdown;

        public ParallelVisitor(@NotNull Function2<? super Vertex, ? super Function0<Unit>, Unit> visitAction, Function0<Unit> afterTraversal) {
            Intrinsics.checkNotNullParameter(visitAction, (String)"visitAction");
            Intrinsics.checkNotNullParameter(afterTraversal, (String)"afterTraversal");
            this.visitAction = visitAction;
            this.afterTraversal = afterTraversal;
            this.predecessorCountdowns = new LinkedHashMap();
            this.queue = new ArrayDeque();
            this.completionCountdown = new AtomicInteger(-1);
        }

        @NotNull
        public final Deque<Vertex> getQueue() {
            return this.queue;
        }

        @NotNull
        public final AtomicInteger getCompletionCountdown() {
            return this.completionCountdown;
        }

        private final synchronized void computePredecessorCountdowns() {
            boolean bl = this.predecessorCountdowns.isEmpty();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            bl = this.queue.isEmpty();
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            this.completionCountdown.set(Graph.this.getVertexCount());
            Map $this$forEach$iv = Graph.this.inEdges;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator2.next();
                boolean bl2 = false;
                Object vertex = entry.getKey();
                Set value = (Set)entry.getValue();
                int predecessorsSize = value.size();
                if (predecessorsSize == 0) {
                    this.predecessorCountdowns.put(vertex, new AtomicInteger(1));
                    this.queue.addLast(vertex);
                    continue;
                }
                this.predecessorCountdowns.put(vertex, new AtomicInteger(predecessorsSize));
            }
        }

        private final synchronized void visitRemainingVertices() {
            if (this.predecessorCountdowns.isEmpty()) {
                boolean bl = this.queue.isEmpty();
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                return;
            }
            while (!this.queue.isEmpty()) {
                boolean bl;
                AtomicInteger countdown;
                Object vertex = this.queue.removeFirst();
                AtomicInteger atomicInteger = countdown = this.predecessorCountdowns.get(vertex);
                Intrinsics.checkNotNull((Object)atomicInteger);
                int value = atomicInteger.decrementAndGet();
                boolean bl2 = bl = value >= 0;
                if (_Assertions.ENABLED && !bl) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
                if (value != 0) continue;
                this.predecessorCountdowns.remove(vertex);
                AtomicBoolean alreadyRan = new AtomicBoolean(false);
                this.visitAction.invoke(vertex, (Object)new Function0<Unit>(alreadyRan, this, Graph.this, vertex){
                    final /* synthetic */ AtomicBoolean $alreadyRan;
                    final /* synthetic */ ParallelVisitor this$0;
                    final /* synthetic */ Graph<Vertex> this$1;
                    final /* synthetic */ Vertex $vertex;
                    {
                        this.$alreadyRan = $alreadyRan;
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        this.$vertex = $vertex;
                        super(0);
                    }

                    public final void invoke() {
                        boolean bl;
                        boolean old = this.$alreadyRan.getAndSet(true);
                        boolean bl2 = bl = !old;
                        if (_Assertions.ENABLED && !bl) {
                            boolean bl3 = false;
                            String string2 = "Ran completion action twice for vertex";
                            throw new AssertionError((Object)string2);
                        }
                        ParallelVisitor.access$queueSuccessors(this.this$0, this.this$1.successorsOf(this.$vertex));
                        if (this.this$0.getCompletionCountdown().decrementAndGet() == 0) {
                            bl = this.this$0.getQueue().isEmpty();
                            if (_Assertions.ENABLED && !bl) {
                                String string3 = "Assertion failed";
                                throw new AssertionError((Object)string3);
                            }
                            bl = ParallelVisitor.access$getPredecessorCountdowns$p(this.this$0).isEmpty();
                            if (_Assertions.ENABLED && !bl) {
                                String string4 = "Assertion failed";
                                throw new AssertionError((Object)string4);
                            }
                            ParallelVisitor.access$getAfterTraversal$p(this.this$0).invoke();
                        } else {
                            ParallelVisitor.access$visitRemainingVertices(this.this$0);
                        }
                    }
                });
            }
        }

        private final synchronized void queueSuccessors(Set<? extends Vertex> vertices) {
            this.queue.addAll(vertices);
        }

        public final void execute() {
            this.computePredecessorCountdowns();
            if (this.predecessorCountdowns.isEmpty()) {
                this.afterTraversal.invoke();
                return;
            }
            this.visitRemainingVertices();
        }

        public static final /* synthetic */ void access$queueSuccessors(ParallelVisitor $this, Set vertices) {
            $this.queueSuccessors(vertices);
        }

        public static final /* synthetic */ Map access$getPredecessorCountdowns$p(ParallelVisitor $this) {
            return $this.predecessorCountdowns;
        }

        public static final /* synthetic */ Function0 access$getAfterTraversal$p(ParallelVisitor $this) {
            return $this.afterTraversal;
        }

        public static final /* synthetic */ void access$visitRemainingVertices(ParallelVisitor $this) {
            $this.visitRemainingVertices();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J\u001c\u0010\t\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007\u00a8\u0006\u000b"}, d2={"Lavail/utility/Graph$Companion;", "", "()V", "ensure", "", "condition", "", "message", "", "notNull", "o", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @Contract(value="false, _ -> fail")
        public final void ensure(boolean condition, @Nullable String message) throws GraphPreconditionFailure {
            if (!condition) {
                throw new GraphPreconditionFailure(message);
            }
        }

        @Contract(value="null, _ -> fail")
        public final void notNull(@Nullable Object o, @Nullable String message) throws GraphPreconditionFailure {
            if (o == null) {
                throw new GraphPreconditionFailure(message);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

