/*
 * Decompiled with CFR 0.152.
 */
package avail.builder;

import avail.builder.AvailBuilder;
import avail.builder.BuildLoader;
import avail.builder.ModuleName;
import avail.builder.ModuleNameResolver;
import avail.builder.ResolvedModuleName;
import avail.builder.UnresolvedDependencyException;
import avail.compiler.AvailCompiler;
import avail.compiler.CompilationContext;
import avail.compiler.ModuleHeader;
import avail.compiler.ModuleManifestEntry;
import avail.compiler.problems.Problem;
import avail.compiler.problems.ProblemHandler;
import avail.compiler.problems.ProblemType;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.fiber.FiberDescriptor;
import avail.descriptor.functions.A_Function;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.module.A_Module;
import avail.descriptor.module.ModuleDescriptor;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.types.A_Type;
import avail.interpreter.execution.AvailLoader;
import avail.interpreter.execution.Interpreter;
import avail.persistence.cache.Repository;
import avail.serialization.Deserializer;
import avail.serialization.Serializer;
import avail.utility.evaluation.Combinator;
import avail.utility.structures.RunTree;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import org.availlang.persistence.IndexedFile;
import org.availlang.persistence.MalformedSerialStreamException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001Bk\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00126\u0010\u0004\u001a2\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u0012\u0004\u0012\u00020\u000b0\u0005j\u0002`\f\u0012\u001c\u0010\r\u001a\u0018\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\u000ej\u0002`\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J&\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000b0\tH\u0002J\u0006\u0010\"\u001a\u00020\u000bJ\u001e\u0010#\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000b0\tH\u0002J>\u0010$\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\n\u0010%\u001a\u00060&R\u00020'2\n\u0010(\u001a\u00060)R\u00020'2\u0006\u0010*\u001a\u00020+2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000b0\tH\u0002J\u0014\u0010,\u001a\u00020\u000b2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000b0\tJ\u0018\u0010.\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010/\u001a\u00020\u0007H\u0002J\u001e\u00100\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u001e2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000b0\tH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u0018\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\u000ej\u0002`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u0004\u001a2\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u0012\u0004\u0012\u00020\u000b0\u0005j\u0002`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lavail/builder/BuildLoader;", "", "availBuilder", "Lavail/builder/AvailBuilder;", "localTracker", "Lkotlin/Function5;", "Lavail/builder/ModuleName;", "", "", "Lkotlin/Function0;", "Lavail/descriptor/phrases/A_Phrase;", "", "Lavail/compiler/CompilerProgressReporter;", "globalTracker", "Lkotlin/Function2;", "Lavail/compiler/GlobalProgressReporter;", "problemHandler", "Lavail/compiler/problems/ProblemHandler;", "(Lavail/builder/AvailBuilder;Lkotlin/jvm/functions/Function5;Lkotlin/jvm/functions/Function2;Lavail/compiler/problems/ProblemHandler;)V", "getAvailBuilder", "()Lavail/builder/AvailBuilder;", "bytesCompiled", "Ljava/util/concurrent/atomic/AtomicLong;", "globalCodeSize", "assembleStylingRecord", "Lavail/persistence/cache/Repository$StylingRecord;", "context", "Lavail/compiler/CompilationContext;", "compileModule", "moduleName", "Lavail/builder/ResolvedModuleName;", "compilationKey", "Lavail/persistence/cache/Repository$ModuleCompilationKey;", "completionAction", "load", "loadModule", "loadRepositoryModule", "version", "Lavail/persistence/cache/Repository$ModuleVersion;", "Lavail/persistence/cache/Repository;", "compilation", "Lavail/persistence/cache/Repository$ModuleCompilation;", "sourceDigest", "", "loadThen", "afterAll", "postLoad", "lastPosition", "scheduleLoadModule", "target", "avail"})
public final class BuildLoader {
    @NotNull
    private final AvailBuilder availBuilder;
    @NotNull
    private final Function5<ModuleName, Long, Long, Integer, Function0<? extends A_Phrase>, Unit> localTracker;
    @NotNull
    private final Function2<Long, Long, Unit> globalTracker;
    @NotNull
    private final ProblemHandler problemHandler;
    private final long globalCodeSize;
    @NotNull
    private final AtomicLong bytesCompiled;

    public BuildLoader(@NotNull AvailBuilder availBuilder, @NotNull Function5<? super ModuleName, ? super Long, ? super Long, ? super Integer, ? super Function0<? extends A_Phrase>, Unit> localTracker, @NotNull Function2<? super Long, ? super Long, Unit> globalTracker, @NotNull ProblemHandler problemHandler) {
        Intrinsics.checkNotNullParameter(availBuilder, "availBuilder");
        Intrinsics.checkNotNullParameter(localTracker, "localTracker");
        Intrinsics.checkNotNullParameter(globalTracker, "globalTracker");
        Intrinsics.checkNotNullParameter(problemHandler, "problemHandler");
        this.availBuilder = availBuilder;
        this.localTracker = localTracker;
        this.globalTracker = globalTracker;
        this.problemHandler = problemHandler;
        this.bytesCompiled = new AtomicLong(0L);
        long size = 0L;
        for (ResolvedModuleName mod : this.availBuilder.getModuleGraph().getVertices()) {
            size += mod.getModuleSize();
        }
        this.globalCodeSize = size;
    }

    @NotNull
    public final AvailBuilder getAvailBuilder() {
        return this.availBuilder;
    }

    private final void scheduleLoadModule(ResolvedModuleName target, Function0<Unit> completionAction) {
        if (this.availBuilder.getShouldStopBuild()) {
            this.postLoad(target, 0L);
            this.availBuilder.getRuntime().execute(50, completionAction);
            return;
        }
        this.availBuilder.getRuntime().execute(50, new Function0<Unit>(this, completionAction, target){
            final /* synthetic */ BuildLoader this$0;
            final /* synthetic */ Function0<Unit> $completionAction;
            final /* synthetic */ ResolvedModuleName $target;
            {
                this.this$0 = $receiver;
                this.$completionAction = $completionAction;
                this.$target = $target;
                super(0);
            }

            public final void invoke() {
                if (this.this$0.getAvailBuilder().getShouldStopBuild()) {
                    this.this$0.getAvailBuilder().getRuntime().execute(50, this.$completionAction);
                } else {
                    BuildLoader.access$loadModule(this.this$0, this.$target, this.$completionAction);
                }
            }
        });
    }

    private final void loadModule(ResolvedModuleName moduleName2, Function0<Unit> completionAction) {
        boolean bl;
        this.globalTracker.invoke(this.bytesCompiled.get(), this.globalCodeSize);
        boolean isLoaded = this.availBuilder.getLoadedModule(moduleName2) != null;
        boolean bl2 = bl = isLoaded == this.availBuilder.getRuntime().includesModuleNamed(StringDescriptor.Companion.stringFrom(moduleName2.getQualifiedName()));
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        if (isLoaded) {
            Level level = Level.FINEST;
            Intrinsics.checkNotNullExpressionValue(level, "FINEST");
            Object[] objectArray = new Object[]{moduleName2.getQualifiedName()};
            AvailBuilder.Companion.log$avail(level, "Already loaded: %s", objectArray);
            this.postLoad(moduleName2, 0L);
            this.availBuilder.getRuntime().execute(50, completionAction);
        } else {
            Repository repository = moduleName2.getRepository();
            Repository.ModuleArchive archive = repository.getArchive(moduleName2.getRootRelativeName());
            archive.digestForFile(moduleName2, false, (Function1<? super byte[], Unit>)new Function1<byte[], Unit>(moduleName2, archive, this, completionAction){
                final /* synthetic */ ResolvedModuleName $moduleName;
                final /* synthetic */ Repository.ModuleArchive $archive;
                final /* synthetic */ BuildLoader this$0;
                final /* synthetic */ Function0<Unit> $completionAction;
                {
                    this.$moduleName = $moduleName;
                    this.$archive = $archive;
                    this.this$0 = $receiver;
                    this.$completionAction = $completionAction;
                    super(1);
                }

                public final void invoke(@NotNull byte[] digest) {
                    AvailBuilder.LoadedModule loadedPredecessor;
                    Intrinsics.checkNotNullParameter(digest, "digest");
                    Repository.ModuleVersionKey versionKey = new Repository.ModuleVersionKey(this.$moduleName, digest);
                    Repository.ModuleVersion moduleVersion = this.$archive.getVersion(versionKey);
                    if (moduleVersion == null) {
                        throw new IllegalStateException("Version should have been populated during tracing".toString());
                    }
                    Repository.ModuleVersion version = moduleVersion;
                    List<String> imports = version.getImports();
                    ModuleNameResolver resolver = this.this$0.getAvailBuilder().getRuntime().getModuleNameResolver();
                    Map loadedModulesByName = new LinkedHashMap<K, V>();
                    for (String localName2 : imports) {
                        ResolvedModuleName resolvedName = null;
                        try {
                            resolvedName = resolver.resolve(this.$moduleName.asSibling(localName2), this.$moduleName);
                        }
                        catch (UnresolvedDependencyException e) {
                            this.this$0.getAvailBuilder().setStopBuildReason("A module predecessor was malformed or absent: " + this.$moduleName.getQualifiedName() + " -> " + localName2 + "\n");
                            this.$completionAction.invoke();
                            return;
                        }
                        Intrinsics.checkNotNull(this.this$0.getAvailBuilder().getLoadedModule(resolvedName));
                        loadedModulesByName.put(localName2, loadedPredecessor);
                    }
                    long[] predecessorCompilationTimes = new long[imports.size()];
                    int resolvedName = predecessorCompilationTimes.length;
                    for (int i = 0; i < resolvedName; ++i) {
                        V v = loadedModulesByName.get(imports.get(i));
                        Intrinsics.checkNotNull(v);
                        loadedPredecessor = (AvailBuilder.LoadedModule)v;
                        predecessorCompilationTimes[i] = loadedPredecessor.getCompilation$avail().getCompilationTime();
                    }
                    Repository.ModuleCompilationKey compilationKey = new Repository.ModuleCompilationKey(predecessorCompilationTimes);
                    Repository.ModuleCompilation compilation = version.getCompilation(compilationKey);
                    if (compilation != null) {
                        BuildLoader.access$loadRepositoryModule(this.this$0, this.$moduleName, version, compilation, versionKey.getSourceDigest(), this.$completionAction);
                    } else {
                        BuildLoader.access$compileModule(this.this$0, this.$moduleName, compilationKey, this.$completionAction);
                    }
                }
            }, loadModule.2.INSTANCE);
        }
    }

    private final void loadRepositoryModule(ResolvedModuleName moduleName2, Repository.ModuleVersion version, Repository.ModuleCompilation compilation, byte[] sourceDigest, Function0<Unit> completionAction) {
        this.localTracker.invoke(moduleName2, moduleName2.getModuleSize(), 0L, 0, loadRepositoryModule.1.INSTANCE);
        A_Module module = ModuleDescriptor.Companion.newModule(this.availBuilder.getRuntime(), StringDescriptor.Companion.stringFrom(moduleName2.getQualifiedName()));
        A_Module.Companion.getAndSetTupleOfBlockPhrases(module, IntegerDescriptor.Companion.fromLong(compilation.getRecordNumberOfBlockPhrases()));
        A_Module.Companion.setStylingRecordIndex(module, compilation.getRecordNumberOfStyling());
        A_Module.Companion.setManifestEntriesIndex(module, compilation.getRecordNumberOfManifestEntries());
        AvailLoader availLoader = new AvailLoader(this.availBuilder.getRuntime(), module, this.availBuilder.getTextInterface());
        availLoader.prepareForLoadingModuleBody();
        Function1 fail2 = new Function1<Throwable, Unit>(module, availLoader, this, moduleName2, completionAction){
            final /* synthetic */ A_Module $module;
            final /* synthetic */ AvailLoader $availLoader;
            final /* synthetic */ BuildLoader this$0;
            final /* synthetic */ ResolvedModuleName $moduleName;
            final /* synthetic */ Function0<Unit> $completionAction;
            {
                this.$module = $module;
                this.$availLoader = $availLoader;
                this.this$0 = $receiver;
                this.$moduleName = $moduleName;
                this.$completionAction = $completionAction;
                super(1);
            }

            public final void invoke(@NotNull Throwable e) {
                Intrinsics.checkNotNullParameter(e, "e");
                A_Module.Companion.removeFrom(this.$module, this.$availLoader, new Function0<Unit>(this.this$0, this.$moduleName, e, this.$completionAction){
                    final /* synthetic */ BuildLoader this$0;
                    final /* synthetic */ ResolvedModuleName $moduleName;
                    final /* synthetic */ Throwable $e;
                    final /* synthetic */ Function0<Unit> $completionAction;
                    {
                        this.this$0 = $receiver;
                        this.$moduleName = $moduleName;
                        this.$e = $e;
                        this.$completionAction = $completionAction;
                        super(0);
                    }

                    public final void invoke() {
                        BuildLoader.access$postLoad(this.this$0, this.$moduleName, 0L);
                        ProblemType problemType = ProblemType.EXECUTION;
                        Object[] objectArray = new Object[1];
                        String string2 = this.$e.getLocalizedMessage();
                        if (string2 == null) {
                            string2 = this.$e.toString();
                        }
                        objectArray[0] = string2;
                        Object[] objectArray2 = objectArray;
                        Problem problem2 = new Problem(this.$moduleName, this.this$0, this.$completionAction, problemType, objectArray2){
                            final /* synthetic */ BuildLoader this$0;
                            final /* synthetic */ Function0<Unit> $completionAction;
                            {
                                this.this$0 = $receiver;
                                this.$completionAction = $completionAction;
                                super($moduleName, 1, 1L, $super_call_param$1, "Problem loading module: {0}", $super_call_param$2);
                            }

                            public void abortCompilation() {
                                this.this$0.getAvailBuilder().setStopBuildReason("Problem loading module");
                                this.$completionAction.invoke();
                            }
                        };
                        BuildLoader.access$getProblemHandler$p(this.this$0).handle(problem2);
                    }
                });
            }
        };
        try {
            byte[] bytes = version.getModuleHeader();
            ByteArrayInputStream inputStream = IndexedFile.Companion.validatedBytesFrom(bytes);
            Deserializer deserializer2 = new Deserializer(inputStream, this.availBuilder.getRuntime(), null, 4, null);
            ModuleHeader header = new ModuleHeader(moduleName2);
            header.deserializeHeaderFrom(deserializer2);
            String errorString = header.applyToModule(availLoader);
            if (errorString != null) {
                throw new RuntimeException(errorString);
            }
        }
        catch (MalformedSerialStreamException e) {
            fail2.invoke(e);
            return;
        }
        catch (RuntimeException e) {
            fail2.invoke(e);
            return;
        }
        Deserializer deserializer3 = null;
        try {
            byte[] bytes = compilation.getBytes();
            ByteArrayInputStream inputStream = IndexedFile.Companion.validatedBytesFrom(bytes);
            deserializer3 = new Deserializer(inputStream, this.availBuilder.getRuntime(), loadRepositoryModule.2.INSTANCE);
            deserializer3.setCurrentModule(module);
        }
        catch (MalformedSerialStreamException e) {
            fail2.invoke(e);
            return;
        }
        catch (RuntimeException e) {
            fail2.invoke(e);
            return;
        }
        Combinator.INSTANCE.recurse((Function1<? super Function0<Unit>, Unit>)new Function1<Function0<? extends Unit>, Unit>(availLoader, this, deserializer3, (Function1<? super Throwable, Unit>)fail2, module, moduleName2, sourceDigest, version, compilation, completionAction){
            final /* synthetic */ AvailLoader $availLoader;
            final /* synthetic */ BuildLoader this$0;
            final /* synthetic */ Deserializer $deserializer;
            final /* synthetic */ Function1<Throwable, Unit> $fail;
            final /* synthetic */ A_Module $module;
            final /* synthetic */ ResolvedModuleName $moduleName;
            final /* synthetic */ byte[] $sourceDigest;
            final /* synthetic */ Repository.ModuleVersion $version;
            final /* synthetic */ Repository.ModuleCompilation $compilation;
            final /* synthetic */ Function0<Unit> $completionAction;
            {
                this.$availLoader = $availLoader;
                this.this$0 = $receiver;
                this.$deserializer = $deserializer;
                this.$fail = $fail;
                this.$module = $module;
                this.$moduleName = $moduleName;
                this.$sourceDigest = $sourceDigest;
                this.$version = $version;
                this.$compilation = $compilation;
                this.$completionAction = $completionAction;
                super(1);
            }

            public final void invoke(@NotNull Function0<Unit> runNext) {
                Intrinsics.checkNotNullParameter(runNext, "runNext");
                this.$availLoader.setPhase(AvailLoader.Phase.LOADING);
                A_Function function = null;
                try {
                    function = this.this$0.getAvailBuilder().getShouldStopBuild() ? null : (A_Function)this.$deserializer.deserialize();
                }
                catch (MalformedSerialStreamException e) {
                    this.$fail.invoke(e);
                    return;
                }
                catch (RuntimeException e) {
                    this.$fail.invoke(e);
                    return;
                }
                if (function != null) {
                    A_Fiber fiber2 = FiberDescriptor.Companion.newLoaderFiber(A_Type.Companion.getReturnType(function.kind()), this.$availLoader, (Function0<? extends A_String>)new Function0<A_String>(function){
                        final /* synthetic */ A_Function $function;
                        {
                            this.$function = $function;
                            super(0);
                        }

                        @NotNull
                        public final A_String invoke() {
                            A_RawFunction code = this.$function.code();
                            Object[] objectArray = new Object[]{A_RawFunction.Companion.getMethodName(code), A_Module.Companion.getShortModuleNameNative(A_RawFunction.Companion.getModule(code)), A_RawFunction.Companion.getCodeStartingLineNumber(code)};
                            return StringDescriptor.Companion.formatString("Load repo module %s, in %s:%d", objectArray);
                        }
                    });
                    long before = A_Fiber.Companion.getFiberHelper(fiber2).fiberTime();
                    A_Fiber.Companion.setSuccessAndFailure(fiber2, (Function1<? super AvailObject, Unit>)new Function1<AvailObject, Unit>(fiber2, before, this.$module, runNext){
                        final /* synthetic */ A_Fiber $fiber;
                        final /* synthetic */ long $before;
                        final /* synthetic */ A_Module $module;
                        final /* synthetic */ Function0<Unit> $runNext;
                        {
                            this.$fiber = $fiber;
                            this.$before = $before;
                            this.$module = $module;
                            this.$runNext = $runNext;
                            super(1);
                        }

                        public final void invoke(@NotNull AvailObject it) {
                            Intrinsics.checkNotNullParameter(it, "it");
                            long after = A_Fiber.Companion.getFiberHelper(this.$fiber).fiberTime();
                            Interpreter.Companion.current().recordTopStatementEvaluation(after - this.$before, this.$module);
                            this.$runNext.invoke();
                        }
                    }, this.$fail);
                    this.$availLoader.setPhase(AvailLoader.Phase.EXECUTING_FOR_LOAD);
                    if (AvailLoader.Companion.getDebugLoadedStatements()) {
                        String string2 = this.$module + ":" + A_RawFunction.Companion.getCodeStartingLineNumber(function.code()) + " Running precompiled -- " + function;
                        System.out.println((Object)string2);
                    }
                    this.this$0.getAvailBuilder().getRuntime().runOutermostFunction(fiber2, function, CollectionsKt.emptyList());
                } else if (this.this$0.getAvailBuilder().getShouldStopBuild()) {
                    A_Module.Companion.removeFrom(this.$module, this.$availLoader, new Function0<Unit>(this.this$0, this.$moduleName, this.$completionAction){
                        final /* synthetic */ BuildLoader this$0;
                        final /* synthetic */ ResolvedModuleName $moduleName;
                        final /* synthetic */ Function0<Unit> $completionAction;
                        {
                            this.this$0 = $receiver;
                            this.$moduleName = $moduleName;
                            this.$completionAction = $completionAction;
                            super(0);
                        }

                        public final void invoke() {
                            BuildLoader.access$postLoad(this.this$0, this.$moduleName, 0L);
                            this.$completionAction.invoke();
                        }
                    });
                } else {
                    A_Module.Companion.serializedObjects(this.$module, this.$deserializer.serializedObjects());
                    this.this$0.getAvailBuilder().getRuntime().addModule(this.$module);
                    AvailBuilder.LoadedModule loadedModule = new AvailBuilder.LoadedModule(this.$moduleName, this.$sourceDigest, this.$module, this.$version, this.$compilation);
                    this.this$0.getAvailBuilder().putLoadedModule$avail(this.$moduleName, loadedModule);
                    BuildLoader.access$postLoad(this.this$0, this.$moduleName, 0L);
                    this.$completionAction.invoke();
                }
            }
        });
    }

    private final void compileModule(ResolvedModuleName moduleName2, Repository.ModuleCompilationKey compilationKey, Function0<Unit> completionAction) {
        Repository repository = moduleName2.getRepository();
        Repository.ModuleArchive archive = repository.getArchive(moduleName2.getRootRelativeName());
        archive.digestForFile(moduleName2, false, (Function1<? super byte[], Unit>)new Function1<byte[], Unit>(moduleName2, this, completionAction, repository, archive, compilationKey){
            final /* synthetic */ ResolvedModuleName $moduleName;
            final /* synthetic */ BuildLoader this$0;
            final /* synthetic */ Function0<Unit> $completionAction;
            final /* synthetic */ Repository $repository;
            final /* synthetic */ Repository.ModuleArchive $archive;
            final /* synthetic */ Repository.ModuleCompilationKey $compilationKey;
            {
                this.$moduleName = $moduleName;
                this.this$0 = $receiver;
                this.$completionAction = $completionAction;
                this.$repository = $repository;
                this.$archive = $archive;
                this.$compilationKey = $compilationKey;
                super(1);
            }

            public final void invoke(@NotNull byte[] digest) {
                Intrinsics.checkNotNullParameter(digest, "digest");
                Repository.ModuleVersionKey versionKey = new Repository.ModuleVersionKey(this.$moduleName, digest);
                Ref.LongRef lastPosition = new Ref.LongRef();
                AtomicBoolean ranOnce = new AtomicBoolean(false);
                AvailCompiler.Companion.create(this.$moduleName, this.this$0.getAvailBuilder().getRuntime(), this.this$0.getAvailBuilder().getTextInterface(), this.this$0.getAvailBuilder().getPollForAbort(), (Function5<? super ModuleName, ? super Long, ? super Long, ? super Integer, ? super Function0<? extends A_Phrase>, Unit>)new Function5<ModuleName, Long, Long, Integer, Function0<? extends A_Phrase>, Unit>(this.$moduleName, this.this$0, lastPosition){
                    final /* synthetic */ ResolvedModuleName $moduleName;
                    final /* synthetic */ BuildLoader this$0;
                    final /* synthetic */ Ref.LongRef $lastPosition;
                    {
                        this.$moduleName = $moduleName;
                        this.this$0 = $receiver;
                        this.$lastPosition = $lastPosition;
                        super(5);
                    }

                    public final void invoke(@NotNull ModuleName moduleName2, long moduleSize, long position, int line, @NotNull Function0<? extends A_Phrase> phrase) {
                        Intrinsics.checkNotNullParameter(moduleName2, "moduleName2");
                        Intrinsics.checkNotNullParameter(phrase, "phrase");
                        boolean bl = Intrinsics.areEqual(this.$moduleName, moduleName2);
                        if (_Assertions.ENABLED && !bl) {
                            String string2 = "Assertion failed";
                            throw new AssertionError((Object)string2);
                        }
                        BuildLoader.access$getLocalTracker$p(this.this$0).invoke(this.$moduleName, moduleSize, Math.min(position, moduleSize - 1L), line, phrase);
                        BuildLoader.access$getGlobalTracker$p(this.this$0).invoke(BuildLoader.access$getBytesCompiled$p(this.this$0).addAndGet(position - this.$lastPosition.element), BuildLoader.access$getGlobalCodeSize$p(this.this$0));
                        this.$lastPosition.element = position;
                    }
                }, new Function0<Unit>(this.this$0, this.$moduleName, lastPosition, this.$completionAction){
                    final /* synthetic */ BuildLoader this$0;
                    final /* synthetic */ ResolvedModuleName $moduleName;
                    final /* synthetic */ Ref.LongRef $lastPosition;
                    final /* synthetic */ Function0<Unit> $completionAction;
                    {
                        this.this$0 = $receiver;
                        this.$moduleName = $moduleName;
                        this.$lastPosition = $lastPosition;
                        this.$completionAction = $completionAction;
                        super(0);
                    }

                    public final void invoke() {
                        BuildLoader.access$postLoad(this.this$0, this.$moduleName, this.$lastPosition.element);
                        this.$completionAction.invoke();
                    }
                }, BuildLoader.access$getProblemHandler$p(this.this$0), (Function1<? super AvailCompiler, Unit>)new Function1<AvailCompiler, Unit>(ranOnce, this.$repository, this.this$0, this.$archive, versionKey, this.$compilationKey, this.$moduleName, lastPosition, this.$completionAction){
                    final /* synthetic */ AtomicBoolean $ranOnce;
                    final /* synthetic */ Repository $repository;
                    final /* synthetic */ BuildLoader this$0;
                    final /* synthetic */ Repository.ModuleArchive $archive;
                    final /* synthetic */ Repository.ModuleVersionKey $versionKey;
                    final /* synthetic */ Repository.ModuleCompilationKey $compilationKey;
                    final /* synthetic */ ResolvedModuleName $moduleName;
                    final /* synthetic */ Ref.LongRef $lastPosition;
                    final /* synthetic */ Function0<Unit> $completionAction;
                    {
                        this.$ranOnce = $ranOnce;
                        this.$repository = $repository;
                        this.this$0 = $receiver;
                        this.$archive = $archive;
                        this.$versionKey = $versionKey;
                        this.$compilationKey = $compilationKey;
                        this.$moduleName = $moduleName;
                        this.$lastPosition = $lastPosition;
                        this.$completionAction = $completionAction;
                        super(1);
                    }

                    public final void invoke(@NotNull AvailCompiler compiler2) {
                        Intrinsics.checkNotNullParameter(compiler2, "compiler");
                        compiler2.parseModule((Function1<? super A_Module, Unit>)new Function1<A_Module, Unit>(this.$ranOnce, compiler2, this.$repository, this.this$0, this.$archive, this.$versionKey, this.$compilationKey, this.$moduleName, this.$lastPosition, this.$completionAction){
                            final /* synthetic */ AtomicBoolean $ranOnce;
                            final /* synthetic */ AvailCompiler $compiler;
                            final /* synthetic */ Repository $repository;
                            final /* synthetic */ BuildLoader this$0;
                            final /* synthetic */ Repository.ModuleArchive $archive;
                            final /* synthetic */ Repository.ModuleVersionKey $versionKey;
                            final /* synthetic */ Repository.ModuleCompilationKey $compilationKey;
                            final /* synthetic */ ResolvedModuleName $moduleName;
                            final /* synthetic */ Ref.LongRef $lastPosition;
                            final /* synthetic */ Function0<Unit> $completionAction;
                            {
                                this.$ranOnce = $ranOnce;
                                this.$compiler = $compiler;
                                this.$repository = $repository;
                                this.this$0 = $receiver;
                                this.$archive = $archive;
                                this.$versionKey = $versionKey;
                                this.$compilationKey = $compilationKey;
                                this.$moduleName = $moduleName;
                                this.$lastPosition = $lastPosition;
                                this.$completionAction = $completionAction;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke(@NotNull A_Module module) {
                                boolean bl;
                                Intrinsics.checkNotNullParameter(module, "module");
                                boolean old = this.$ranOnce.getAndSet(true);
                                boolean bl2 = bl = !old;
                                if (_Assertions.ENABLED && !bl) {
                                    boolean $i$a$-assert-BuildLoader$compileModule$1$3$1$22 = false;
                                    String $i$a$-assert-BuildLoader$compileModule$1$3$1$22 = "Completed module compilation twice!";
                                    throw new AssertionError((Object)$i$a$-assert-BuildLoader$compileModule$1$3$1$22);
                                }
                                CompilationContext context = this.$compiler.getCompilationContext();
                                IndexedFile.ByteArrayOutputStream stream = context.getSerializerOutputStream();
                                IndexedFile.Companion.appendCRC(stream);
                                IndexedFile.ByteArrayOutputStream blockPhrasesOutputStream = new IndexedFile.ByteArrayOutputStream(5000);
                                AvailObject bodyObjectsTuple = context.getSerializer$avail().serializedObjectsTuple();
                                Map bodyObjectsMap = new LinkedHashMap<K, V>();
                                Iterable $this$forEachIndexed$iv = bodyObjectsTuple;
                                boolean $i$f$forEachIndexed = false;
                                int index$iv = 0;
                                for (T item$iv : $this$forEachIndexed$iv) {
                                    void element;
                                    int n;
                                    if ((n = index$iv++) < 0) {
                                        CollectionsKt.throwIndexOverflow();
                                    }
                                    AvailObject availObject = (AvailObject)item$iv;
                                    int zeroIndex = n;
                                    boolean bl3 = false;
                                    bodyObjectsMap.put(element, zeroIndex + 1);
                                }
                                int delta = bodyObjectsMap.size() + 1;
                                Serializer blockPhraseSerializer2 = new Serializer(blockPhrasesOutputStream, module, (Function1<? super A_BasicObject, Integer>)new Function1<A_BasicObject, Integer>((Map<AvailObject, Integer>)bodyObjectsMap, delta){
                                    final /* synthetic */ Map<AvailObject, Integer> $bodyObjectsMap;
                                    final /* synthetic */ int $delta;
                                    {
                                        this.$bodyObjectsMap = $bodyObjectsMap;
                                        this.$delta = $delta;
                                        super(1);
                                    }

                                    @NotNull
                                    public final Integer invoke(@NotNull A_BasicObject obj) {
                                        Intrinsics.checkNotNullParameter(obj, "obj");
                                        Integer i = this.$bodyObjectsMap.get(obj);
                                        return i == null ? 0 : i - this.$delta;
                                    }
                                });
                                blockPhraseSerializer2.serialize(A_Module.Companion.getAndSetTupleOfBlockPhrases(module, NilDescriptor.Companion.getNil()));
                                IndexedFile.Companion.appendCRC(blockPhrasesOutputStream);
                                AvailLoader loader = context.getLoader();
                                List<ModuleManifestEntry> list2 = loader.getManifestEntries();
                                Intrinsics.checkNotNull(list2);
                                List<ModuleManifestEntry> manifestEntries = list2;
                                long compilationTime = System.currentTimeMillis();
                                byte[] byArray = stream.toByteArray();
                                Intrinsics.checkNotNullExpressionValue(byArray, "stream.toByteArray()");
                                byte[] byArray2 = blockPhrasesOutputStream.toByteArray();
                                Intrinsics.checkNotNullExpressionValue(byArray2, "blockPhrasesOutputStream.toByteArray()");
                                Repository.ModuleCompilation compilation = this.$repository.new Repository.ModuleCompilation(compilationTime, byArray, byArray2, manifestEntries, BuildLoader.access$assembleStylingRecord(this.this$0, context));
                                this.$archive.putCompilation(this.$versionKey, this.$compilationKey, compilation);
                                IndexedFile.ByteArrayOutputStream out2 = new IndexedFile.ByteArrayOutputStream(100);
                                IndexedFile.Companion.appendCRC(out2);
                                Repository.ModuleVersion moduleVersion = this.$archive.getVersion(this.$versionKey);
                                Intrinsics.checkNotNull(moduleVersion);
                                Repository.ModuleVersion version = moduleVersion;
                                byte[] byArray3 = out2.toByteArray();
                                Intrinsics.checkNotNullExpressionValue(byArray3, "out.toByteArray()");
                                version.putComments(byArray3);
                                A_Module.Companion.getAndSetTupleOfBlockPhrases(module, IntegerDescriptor.Companion.fromLong(compilation.getRecordNumberOfBlockPhrases()));
                                A_Module.Companion.setManifestEntriesIndex(module, compilation.getRecordNumberOfManifestEntries());
                                A_Module.Companion.setStylingRecordIndex(module, compilation.getRecordNumberOfStyling());
                                this.$repository.commitIfStaleChanges(2000L);
                                BuildLoader.access$postLoad(this.this$0, this.$moduleName, this.$lastPosition.element);
                                A_Module.Companion.serializedObjects(module, bodyObjectsTuple);
                                this.this$0.getAvailBuilder().putLoadedModule$avail(this.$moduleName, new AvailBuilder.LoadedModule(this.$moduleName, this.$versionKey.getSourceDigest(), module, version, compilation));
                                this.$completionAction.invoke();
                            }
                        }, new Function0<Unit>(this.this$0, this.$moduleName, this.$lastPosition, this.$completionAction){
                            final /* synthetic */ BuildLoader this$0;
                            final /* synthetic */ ResolvedModuleName $moduleName;
                            final /* synthetic */ Ref.LongRef $lastPosition;
                            final /* synthetic */ Function0<Unit> $completionAction;
                            {
                                this.this$0 = $receiver;
                                this.$moduleName = $moduleName;
                                this.$lastPosition = $lastPosition;
                                this.$completionAction = $completionAction;
                                super(0);
                            }

                            public final void invoke() {
                                BuildLoader.access$postLoad(this.this$0, this.$moduleName, this.$lastPosition.element);
                                this.$completionAction.invoke();
                            }
                        });
                    }
                });
            }
        }, compileModule.2.INSTANCE);
    }

    private final Repository.StylingRecord assembleStylingRecord(CompilationContext context) {
        AvailLoader loader = context.getLoader();
        A_String.SurrogateIndexConverter converter = context.getSurrogateIndexConverter();
        List styleRanges2 = (List)loader.lockStyles((Function1)new Function1<RunTree<String>, List<? extends Pair<? extends IntRange, ? extends String>>>(converter){
            final /* synthetic */ A_String.SurrogateIndexConverter $converter;
            {
                this.$converter = $converter;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Pair<IntRange, String>> invoke(@NotNull RunTree<String> $this$lockStyles) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter($this$lockStyles, "$this$lockStyles");
                Iterable iterable = $this$lockStyles;
                A_String.SurrogateIndexConverter surrogateIndexConverter2 = this.$converter;
                boolean $i$f$map = false;
                void var5_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    Triple triple = (Triple)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    long start = ((Number)triple.component1()).longValue();
                    long pastEnd = ((Number)triple.component2()).longValue();
                    String style = (String)triple.component3();
                    int utf16Start = surrogateIndexConverter2.availIndexToJavaIndex((int)start);
                    int utf16PastEnd = surrogateIndexConverter2.availIndexToJavaIndex((int)pastEnd);
                    collection.add(TuplesKt.to(RangesKt.until(utf16Start, utf16PastEnd), style));
                }
                return (List)destination$iv$iv;
            }
        });
        List uses2 = (List)loader.lockUsesToDefinitions((Function1)new Function1<RunTree<LongRange>, List<? extends Pair<? extends IntRange, ? extends IntRange>>>(converter){
            final /* synthetic */ A_String.SurrogateIndexConverter $converter;
            {
                this.$converter = $converter;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Pair<IntRange, IntRange>> invoke(@NotNull RunTree<LongRange> $this$lockUsesToDefinitions) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter($this$lockUsesToDefinitions, "$this$lockUsesToDefinitions");
                Iterable iterable = $this$lockUsesToDefinitions;
                A_String.SurrogateIndexConverter surrogateIndexConverter2 = this.$converter;
                boolean $i$f$map = false;
                void var5_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    Triple triple = (Triple)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    long useStart = ((Number)triple.component1()).longValue();
                    long usePastEnd = ((Number)triple.component2()).longValue();
                    LongRange defRange = (LongRange)triple.component3();
                    int utf16UseStart = surrogateIndexConverter2.availIndexToJavaIndex((int)useStart);
                    int utf16UsePastEnd = surrogateIndexConverter2.availIndexToJavaIndex((int)usePastEnd);
                    int utf16DefStart = surrogateIndexConverter2.availIndexToJavaIndex((int)defRange.getFirst());
                    int utf16DefEnd = surrogateIndexConverter2.availIndexToJavaIndex((int)defRange.getLast());
                    collection.add(new Pair<IntRange, IntRange>(RangesKt.until(utf16UseStart, utf16UsePastEnd), new IntRange(utf16DefStart, utf16DefEnd)));
                }
                return (List)destination$iv$iv;
            }
        });
        return new Repository.StylingRecord(styleRanges2, uses2);
    }

    private final void postLoad(ResolvedModuleName moduleName2, long lastPosition) {
        long moduleSize = moduleName2.getModuleSize();
        long newPosition = this.bytesCompiled.addAndGet(moduleSize - lastPosition);
        if (!this.availBuilder.getShouldStopBuild()) {
            this.globalTracker.invoke(newPosition, this.globalCodeSize);
        }
        this.localTracker.invoke(moduleName2, moduleSize, moduleSize, Integer.MAX_VALUE, postLoad.1.INSTANCE);
    }

    public final void loadThen(@NotNull Function0<Unit> afterAll) {
        Intrinsics.checkNotNullParameter(afterAll, "afterAll");
        this.bytesCompiled.set(0L);
        int vertexCountBefore = this.availBuilder.getModuleGraph().getVertexCount();
        this.availBuilder.getModuleGraph().parallelVisitThen((Function2<ResolvedModuleName, Function0<Unit>, Unit>)new Function2<ResolvedModuleName, Function0<? extends Unit>, Unit>(this){
            final /* synthetic */ BuildLoader this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull ResolvedModuleName vertex, @NotNull Function0<Unit> done) {
                Intrinsics.checkNotNullParameter(vertex, "vertex");
                Intrinsics.checkNotNullParameter(done, "done");
                BuildLoader.access$scheduleLoadModule(this.this$0, vertex, done);
            }
        }, new Function0<Unit>(this, vertexCountBefore, afterAll){
            final /* synthetic */ BuildLoader this$0;
            final /* synthetic */ int $vertexCountBefore;
            final /* synthetic */ Function0<Unit> $afterAll;
            {
                this.this$0 = $receiver;
                this.$vertexCountBefore = $vertexCountBefore;
                this.$afterAll = $afterAll;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                try {
                    boolean bl;
                    boolean bl2 = bl = this.this$0.getAvailBuilder().getModuleGraph().getVertexCount() == this.$vertexCountBefore;
                    if (_Assertions.ENABLED && !bl) {
                        String string2 = "Assertion failed";
                        throw new AssertionError((Object)string2);
                    }
                    this.this$0.getAvailBuilder().getRuntime().getModuleNameResolver().commitRepositories();
                    this.this$0.getAvailBuilder().trimGraphToLoadedModules$avail();
                }
                finally {
                    this.$afterAll.invoke();
                }
            }
        });
    }

    public final void load() {
        Semaphore semaphore = new Semaphore(0);
        this.loadThen(new Function0<Unit>(semaphore){
            final /* synthetic */ Semaphore $semaphore;
            {
                this.$semaphore = $semaphore;
                super(0);
            }

            public final void invoke() {
                this.$semaphore.release();
            }
        });
        semaphore.acquireUninterruptibly();
    }

    public static final /* synthetic */ void access$loadModule(BuildLoader $this, ResolvedModuleName moduleName2, Function0 completionAction) {
        $this.loadModule(moduleName2, completionAction);
    }

    public static final /* synthetic */ void access$loadRepositoryModule(BuildLoader $this, ResolvedModuleName moduleName2, Repository.ModuleVersion version, Repository.ModuleCompilation compilation, byte[] sourceDigest, Function0 completionAction) {
        $this.loadRepositoryModule(moduleName2, version, compilation, sourceDigest, completionAction);
    }

    public static final /* synthetic */ void access$compileModule(BuildLoader $this, ResolvedModuleName moduleName2, Repository.ModuleCompilationKey compilationKey, Function0 completionAction) {
        $this.compileModule(moduleName2, compilationKey, completionAction);
    }

    public static final /* synthetic */ void access$postLoad(BuildLoader $this, ResolvedModuleName moduleName2, long lastPosition) {
        $this.postLoad(moduleName2, lastPosition);
    }

    public static final /* synthetic */ ProblemHandler access$getProblemHandler$p(BuildLoader $this) {
        return $this.problemHandler;
    }

    public static final /* synthetic */ Function5 access$getLocalTracker$p(BuildLoader $this) {
        return $this.localTracker;
    }

    public static final /* synthetic */ Function2 access$getGlobalTracker$p(BuildLoader $this) {
        return $this.globalTracker;
    }

    public static final /* synthetic */ AtomicLong access$getBytesCompiled$p(BuildLoader $this) {
        return $this.bytesCompiled;
    }

    public static final /* synthetic */ long access$getGlobalCodeSize$p(BuildLoader $this) {
        return $this.globalCodeSize;
    }

    public static final /* synthetic */ Repository.StylingRecord access$assembleStylingRecord(BuildLoader $this, CompilationContext context) {
        return $this.assembleStylingRecord(context);
    }

    public static final /* synthetic */ void access$scheduleLoadModule(BuildLoader $this, ResolvedModuleName target, Function0 completionAction) {
        $this.scheduleLoadModule(target, completionAction);
    }
}

