/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.effects;

import avail.descriptor.bundles.A_Bundle;
import avail.descriptor.methods.A_Method;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.interpreter.effects.LoadingEffect;
import avail.interpreter.levelOne.L1InstructionWriter;
import avail.interpreter.levelOne.L1Operation;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lavail/interpreter/effects/LoadingEffectToRunPrimitive;", "Lavail/interpreter/effects/LoadingEffect;", "primitiveBundle", "Lavail/descriptor/bundles/A_Bundle;", "arguments", "", "Lavail/descriptor/representation/A_BasicObject;", "(Lavail/descriptor/bundles/A_Bundle;[Lavail/descriptor/representation/A_BasicObject;)V", "getArguments$avail", "()[Lavail/descriptor/representation/A_BasicObject;", "[Lavail/descriptor/representation/A_BasicObject;", "writeEffectTo", "", "writer", "Lavail/interpreter/levelOne/L1InstructionWriter;", "avail"})
public final class LoadingEffectToRunPrimitive
extends LoadingEffect {
    @NotNull
    private final A_Bundle primitiveBundle;
    @NotNull
    private final A_BasicObject[] arguments;

    public LoadingEffectToRunPrimitive(@NotNull A_Bundle primitiveBundle, A_BasicObject ... arguments2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(primitiveBundle, "primitiveBundle");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        this.primitiveBundle = primitiveBundle;
        this.arguments = (A_BasicObject[])arguments2.clone();
        boolean bl2 = bl = A_Method.Companion.getNumArgs(A_Bundle.Companion.getBundleMethod(this.primitiveBundle)) == arguments2.length;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
    }

    @NotNull
    public final A_BasicObject[] getArguments$avail() {
        return this.arguments;
    }

    @Override
    public void writeEffectTo(@NotNull L1InstructionWriter writer) {
        Intrinsics.checkNotNullParameter(writer, "writer");
        for (A_BasicObject argument : this.arguments) {
            int[] nArray = new int[]{writer.addLiteral(argument)};
            writer.write(0, L1Operation.L1_doPushLiteral, nArray);
        }
        int[] nArray = new int[]{writer.addLiteral(this.primitiveBundle), writer.addLiteral(PrimitiveTypeDescriptor.Types.TOP.getO())};
        writer.write(0, L1Operation.L1_doCall, nArray);
    }
}

