/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo.operation;

import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.types.ContinuationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2JVMChunk;
import avail.interpreter.levelTwo.L2NamedOperandType;
import avail.interpreter.levelTwo.L2OperandType;
import avail.interpreter.levelTwo.L2Operation;
import avail.interpreter.levelTwo.operand.L2ArbitraryConstantOperand;
import avail.interpreter.levelTwo.operand.L2CommentOperand;
import avail.interpreter.levelTwo.operand.L2IntImmediateOperand;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2PcOperand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedVectorOperand;
import avail.interpreter.levelTwo.operand.L2WriteBoxedOperand;
import avail.interpreter.levelTwo.operand.L2WriteIntOperand;
import avail.interpreter.levelTwo.operand.TypeRestriction;
import avail.interpreter.levelTwo.operation.L2_CREATE_CONTINUATION;
import avail.interpreter.levelTwo.operation.L2_ENTER_L2_CHUNK;
import avail.interpreter.levelTwo.operation.L2_GET_CURRENT_CONTINUATION;
import avail.interpreter.levelTwo.operation.L2_GET_CURRENT_FUNCTION;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_ALREADY_REIFIED;
import avail.interpreter.levelTwo.operation.L2_REIFY;
import avail.interpreter.levelTwo.operation.L2_RETURN_FROM_REIFICATION_HANDLER;
import avail.interpreter.levelTwo.operation.L2_SAVE_ALL_AND_PC_TO_INT;
import avail.interpreter.levelTwo.operation.L2_SET_CONTINUATION;
import avail.interpreter.levelTwo.operation.L2_UNREACHABLE_CODE;
import avail.optimizer.L2BasicBlock;
import avail.optimizer.L2ControlFlowGraph;
import avail.optimizer.L2Generator;
import avail.optimizer.jvm.JVMTranslator;
import avail.optimizer.reoptimizer.L2Regenerator;
import avail.performance.Statistic;
import avail.performance.StatisticReport;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006\u001a"}, d2={"Lavail/interpreter/levelTwo/operation/L2_VIRTUAL_CREATE_LABEL;", "Lavail/interpreter/levelTwo/L2Operation;", "()V", "isPlaceholder", "", "()Z", "appendToWithWarnings", "", "instruction", "Lavail/interpreter/levelTwo/L2Instruction;", "desiredTypes", "", "Lavail/interpreter/levelTwo/L2OperandType;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "warningStyleChange", "Lkotlin/Function1;", "generateReplacement", "regenerator", "Lavail/optimizer/reoptimizer/L2Regenerator;", "translateToJVM", "translator", "Lavail/optimizer/jvm/JVMTranslator;", "method", "Lorg/objectweb/asm/MethodVisitor;", "avail"})
public final class L2_VIRTUAL_CREATE_LABEL
extends L2Operation {
    @NotNull
    public static final L2_VIRTUAL_CREATE_LABEL INSTANCE = new L2_VIRTUAL_CREATE_LABEL();

    private L2_VIRTUAL_CREATE_LABEL() {
        L2NamedOperandType[] l2NamedOperandTypeArray = new L2NamedOperandType[]{L2OperandType.WRITE_BOXED.named("output label"), L2OperandType.READ_BOXED.named("immutable function"), L2OperandType.READ_BOXED_VECTOR.named("arguments"), L2OperandType.INT_IMMEDIATE.named("frame size")};
        super(l2NamedOperandTypeArray);
    }

    @Override
    public boolean isPlaceholder() {
        return true;
    }

    @Override
    public void appendToWithWarnings(@NotNull L2Instruction instruction2, @NotNull Set<? extends L2OperandType> desiredTypes, @NotNull StringBuilder builder2, @NotNull Function1<? super Boolean, Unit> warningStyleChange) {
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        Intrinsics.checkNotNullParameter(desiredTypes, "desiredTypes");
        Intrinsics.checkNotNullParameter(builder2, "builder");
        Intrinsics.checkNotNullParameter(warningStyleChange, "warningStyleChange");
        boolean bl = Intrinsics.areEqual(this, instruction2.getOperation());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2WriteBoxedOperand outputLabel = (L2WriteBoxedOperand)instruction2.operand(0);
        L2ReadBoxedOperand function = (L2ReadBoxedOperand)instruction2.operand(1);
        L2ReadBoxedVectorOperand arguments2 = (L2ReadBoxedVectorOperand)instruction2.operand(2);
        L2IntImmediateOperand frameSize = (L2IntImmediateOperand)instruction2.operand(3);
        this.renderPreamble(instruction2, builder2);
        builder2.append(" ").append(outputLabel);
        builder2.append("\n\tfunction = ").append(function);
        builder2.append("\n\targuments = ").append(arguments2);
        builder2.append("\n\tframeSize = ").append(frameSize);
    }

    @Override
    public void generateReplacement(@NotNull L2Instruction instruction2, @NotNull L2Regenerator regenerator2) {
        L2Operand[] reificationOfframp;
        L2Operand[] alreadyReifiedEdgeSplit;
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        Intrinsics.checkNotNullParameter(regenerator2, "regenerator");
        boolean bl = Intrinsics.areEqual(this, instruction2.getOperation());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2Generator generator = regenerator2.getTargetGenerator();
        L2WriteBoxedOperand labelOutput = (L2WriteBoxedOperand)regenerator2.transformOperand(instruction2.operand(0));
        L2ReadBoxedOperand function = (L2ReadBoxedOperand)regenerator2.transformOperand(instruction2.operand(1));
        L2ReadBoxedVectorOperand arguments2 = (L2ReadBoxedVectorOperand)regenerator2.transformOperand(instruction2.operand(2));
        L2IntImmediateOperand frameSize = (L2IntImmediateOperand)instruction2.operand(3);
        if (generator.currentBlock().getZone() == null) {
            L2ControlFlowGraph.Zone zone = L2ControlFlowGraph.ZoneType.BEGIN_REIFICATION_FOR_LABEL.createZone("Reify caller for label");
            alreadyReifiedEdgeSplit = generator.createBasicBlock("already reified (edge split)");
            L2BasicBlock startReification = generator.createBasicBlock("start reification");
            L2BasicBlock onReification = generator.createBasicBlock("on reification", zone);
            reificationOfframp = generator.createBasicBlock("reification off-ramp", zone);
            L2BasicBlock afterReification = generator.createBasicBlock("after reification");
            L2BasicBlock callerIsReified = generator.createBasicBlock("caller is reified");
            L2BasicBlock unreachable = generator.createBasicBlock("unreachable");
            L2Operand[] l2OperandArray = new L2Operand[]{L2Generator.Companion.edgeTo((L2BasicBlock)alreadyReifiedEdgeSplit), L2Generator.Companion.edgeTo(startReification)};
            generator.addInstruction(L2_JUMP_IF_ALREADY_REIFIED.INSTANCE, l2OperandArray);
            L2Generator.startBlock$default(generator, (L2BasicBlock)alreadyReifiedEdgeSplit, false, null, 6, null);
            generator.jumpTo(callerIsReified);
            L2Generator.startBlock$default(generator, startReification, false, null, 6, null);
            l2OperandArray = new L2Operand[]{new L2IntImmediateOperand(1), new L2IntImmediateOperand(0), new L2ArbitraryConstantOperand(new Statistic(StatisticReport.REIFICATIONS, "Reification for label creation in L2: " + StringsKt.replace$default(generator.getCodeName(), '\n', ' ', false, 4, null))), L2Generator.Companion.edgeTo(onReification)};
            generator.addInstruction(L2_REIFY.INSTANCE, l2OperandArray);
            L2Generator.startBlock$default(generator, onReification, false, null, 6, null);
            l2OperandArray = new L2Operand[]{new L2IntImmediateOperand(L2JVMChunk.ChunkEntryPoint.TRANSIENT.getOffsetInDefaultChunk()), new L2CommentOperand("Transient, cannot be invalid.")};
            generator.addInstruction(L2_ENTER_L2_CHUNK.INSTANCE, l2OperandArray);
            L2WriteIntOperand tempOffset = generator.intWriteTemp(TypeRestriction.Companion.restrictionForType(IntegerRangeTypeDescriptor.Companion.getInt32(), TypeRestriction.RestrictionFlagEncoding.UNBOXED_INT_FLAG));
            L2WriteBoxedOperand tempRegisterDump = generator.boxedWriteTemp(TypeRestriction.Companion.restrictionForType(PrimitiveTypeDescriptor.Types.ANY.getO(), TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG));
            L2Operand[] l2OperandArray2 = new L2Operand[]{L2Generator.Companion.edgeTo(afterReification), tempOffset, tempRegisterDump, L2Generator.Companion.edgeTo((L2BasicBlock)reificationOfframp)};
            generator.addInstruction(L2_SAVE_ALL_AND_PC_TO_INT.INSTANCE, l2OperandArray2);
            L2Generator.startBlock$default(generator, (L2BasicBlock)reificationOfframp, false, null, 6, null);
            L2WriteBoxedOperand tempCaller = generator.boxedWrite(generator.getTopFrame().reifiedCaller(), TypeRestriction.Companion.restrictionForType(ContinuationTypeDescriptor.Companion.getMostGeneralContinuationType(), TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG));
            L2WriteBoxedOperand tempFunction = generator.boxedWrite(generator.getTopFrame().function(), TypeRestriction.Companion.restrictionForType(FunctionTypeDescriptor.Companion.mostGeneralFunctionType(), TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG));
            L2WriteBoxedOperand dummyContinuation = generator.boxedWriteTemp(TypeRestriction.Companion.restrictionForType(ContinuationTypeDescriptor.Companion.getMostGeneralContinuationType(), TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG));
            L2Operand[] l2OperandArray3 = new L2Operand[]{tempCaller};
            generator.addInstruction(L2_GET_CURRENT_CONTINUATION.INSTANCE, l2OperandArray3);
            l2OperandArray3 = new L2Operand[]{tempFunction};
            generator.addInstruction(L2_GET_CURRENT_FUNCTION.INSTANCE, l2OperandArray3);
            l2OperandArray3 = new L2Operand[]{generator.readBoxed(tempFunction), generator.readBoxed(tempCaller), new L2IntImmediateOperand(Integer.MAX_VALUE), new L2IntImmediateOperand(Integer.MAX_VALUE), new L2ReadBoxedVectorOperand(CollectionsKt.emptyList()), dummyContinuation, generator.readInt(tempOffset.onlySemanticValue(), unreachable), generator.readBoxed(tempRegisterDump), new L2CommentOperand("Dummy reification continuation.")};
            generator.addInstruction(L2_CREATE_CONTINUATION.INSTANCE, l2OperandArray3);
            l2OperandArray3 = new L2Operand[]{generator.readBoxed(dummyContinuation)};
            generator.addInstruction(L2_SET_CONTINUATION.INSTANCE, l2OperandArray3);
            generator.addInstruction(L2_RETURN_FROM_REIFICATION_HANDLER.INSTANCE, new L2Operand[0]);
            L2Generator.startBlock$default(generator, unreachable, false, null, 6, null);
            generator.addInstruction(L2_UNREACHABLE_CODE.INSTANCE, new L2Operand[0]);
            L2Generator.startBlock$default(generator, afterReification, false, null, 6, null);
            l2OperandArray3 = new L2Operand[]{new L2IntImmediateOperand(L2JVMChunk.ChunkEntryPoint.TRANSIENT.getOffsetInDefaultChunk()), new L2CommentOperand("Transient, cannot be invalid.")};
            generator.addInstruction(L2_ENTER_L2_CHUNK.INSTANCE, l2OperandArray3);
            generator.jumpTo(callerIsReified);
            L2Generator.startBlock$default(generator, callerIsReified, false, null, 6, null);
        }
        L2WriteBoxedOperand tempCallerWrite = generator.boxedWriteTemp(TypeRestriction.Companion.restrictionForType(ContinuationTypeDescriptor.Companion.getMostGeneralContinuationType(), TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG));
        alreadyReifiedEdgeSplit = new L2Operand[]{tempCallerWrite};
        generator.addInstruction(L2_GET_CURRENT_CONTINUATION.INSTANCE, alreadyReifiedEdgeSplit);
        L2BasicBlock fallThrough = generator.createBasicBlock("Fall-through for label creation", generator.currentBlock().getZone());
        L2WriteIntOperand writeOffset = generator.intWriteTemp(TypeRestriction.Companion.restrictionForType(IntegerRangeTypeDescriptor.Companion.getInt32(), TypeRestriction.RestrictionFlagEncoding.UNBOXED_INT_FLAG));
        L2WriteBoxedOperand writeRegisterDump = generator.boxedWriteTemp(TypeRestriction.Companion.restrictionForType(PrimitiveTypeDescriptor.Types.ANY.getO(), TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG));
        L2Operation l2Operation = L2_SAVE_ALL_AND_PC_TO_INT.INSTANCE;
        reificationOfframp = new L2Operand[4];
        L2BasicBlock l2BasicBlock = generator.getSpecialBlocks().get((Object)L2Generator.SpecialBlock.AFTER_OPTIONAL_PRIMITIVE);
        Intrinsics.checkNotNull(l2BasicBlock);
        reificationOfframp[0] = L2Generator.Companion.backEdgeTo(l2BasicBlock);
        reificationOfframp[1] = writeOffset;
        reificationOfframp[2] = writeRegisterDump;
        reificationOfframp[3] = L2Generator.Companion.edgeTo(fallThrough);
        generator.addInstruction(l2Operation, reificationOfframp);
        L2Instruction saveInstruction = CollectionsKt.last(generator.currentBlock().instructions());
        L2PcOperand referenceEdge = L2_SAVE_ALL_AND_PC_TO_INT.INSTANCE.referenceOf(saveInstruction);
        referenceEdge.setForcedClampedEntities(new LinkedHashSet());
        L2Generator.startBlock$default(generator, fallThrough, false, null, 6, null);
        int frameSizeInt = frameSize.getValue();
        List<L2ReadBoxedOperand> slots = CollectionsKt.toMutableList(arguments2.elements());
        L2ReadBoxedOperand nilRead = generator.boxedConstant(NilDescriptor.Companion.getNil());
        int n = frameSizeInt - slots.size();
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl2 = false;
            slots.add(nilRead);
        }
        L2Operand[] l2OperandArray = new L2Operand[]{generator.makeImmutable(function), generator.makeImmutable(generator.readBoxed(tempCallerWrite)), new L2IntImmediateOperand(0), new L2IntImmediateOperand(frameSizeInt + 1), new L2ReadBoxedVectorOperand(slots), labelOutput, generator.readInt(writeOffset.onlySemanticValue(), generator.unreachablePcOperand().targetBlock()), generator.readBoxed(writeRegisterDump), new L2CommentOperand("Create label.")};
        generator.addInstruction(L2_CREATE_CONTINUATION.INSTANCE, l2OperandArray);
    }

    @Override
    public void translateToJVM(@NotNull JVMTranslator translator, @NotNull MethodVisitor method, @NotNull L2Instruction instruction2) {
        Intrinsics.checkNotNullParameter(translator, "translator");
        Intrinsics.checkNotNullParameter(method, "method");
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " should have been replaced during optimization");
    }
}

