/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.integers;

import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.exceptions.ArithmeticException;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0014J\b\u0010\r\u001a\u00020\u000bH\u0014J\u001e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a8\u0006\u0011"}, d2={"Lavail/interpreter/primitive/integers/P_BitShiftLeft;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "fallibilityForArgumentTypes", "Lavail/interpreter/Primitive$Fallibility;", "argumentTypes", "", "Lavail/descriptor/types/A_Type;", "privateBlockTypeRestriction", "privateFailureVariableType", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "avail"})
public final class P_BitShiftLeft
extends Primitive {
    @NotNull
    public static final P_BitShiftLeft INSTANCE = new P_BitShiftLeft();

    private P_BitShiftLeft() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Primitive.Result result2;
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject baseInteger = interpreter.argument(0);
        AvailObject shiftFactor = interpreter.argument(1);
        try {
            result2 = interpreter.primitiveSuccess(A_Number.Companion.bitShift(baseInteger, shiftFactor, true));
        }
        catch (ArithmeticException e) {
            result2 = interpreter.primitiveFailure(e);
        }
        return result2;
    }

    @Override
    @NotNull
    public Primitive.Fallibility fallibilityForArgumentTypes(@NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        A_Type shiftFactors = argumentTypes.get(1);
        return A_Number.Companion.lessOrEqual(A_Type.Companion.getUpperBound(shiftFactors), IntegerDescriptor.Companion.getZero()) ? Primitive.Fallibility.CallSiteCannotFail : super.fallibilityForArgumentTypes(argumentTypes);
    }

    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction, @NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter(rawFunction, "rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        A_Type baseIntegers = argumentTypes.get(0);
        A_Type shiftFactors = argumentTypes.get(1);
        A_Number leastShift = A_Type.Companion.getLowerBound(shiftFactors);
        return A_Type.Companion.getUpperBound(shiftFactors).equals(leastShift) ? IntegerRangeTypeDescriptor.Companion.integerRangeType(A_Number.Companion.bitShift(A_Type.Companion.getLowerBound(baseIntegers), leastShift, false), A_Type.Companion.getLowerInclusive(baseIntegers), A_Number.Companion.bitShift(A_Type.Companion.getUpperBound(baseIntegers), leastShift, false), A_Type.Companion.getUpperInclusive(baseIntegers)) : (A_Number.Companion.greaterOrEqual(A_Type.Companion.getLowerBound(baseIntegers), IntegerDescriptor.Companion.getZero()) ? IntegerRangeTypeDescriptor.Companion.getWholeNumbers() : super.returnTypeGuaranteedByVM(rawFunction, argumentTypes));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(IntegerRangeTypeDescriptor.Companion.getIntegers(), IntegerRangeTypeDescriptor.Companion.getIntegers()), IntegerRangeTypeDescriptor.Companion.getIntegers(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_TOO_LARGE_TO_REPRESENT};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

