/*
 * Decompiled with CFR 0.152.
 */
package org.availlang.json;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import org.availlang.json.JSONFriendly;
import org.availlang.json.JSONIOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0010\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u0000 K2\u00020\u0001:\u0002KLB\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J:\u0010\u0013\u001a\u0002H\u0014\"\u0006\b\u0000\u0010\u0014\u0018\u00012\u0006\u0010\u0015\u001a\u00020\u00102\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002H\u00140\u0017\u00a2\u0006\u0002\b\u0018H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0006\u0010\u001c\u001a\u00020\u0010J\u0006\u0010\u001d\u001a\u00020\u001bJ\u0006\u0010\u001e\u001a\u00020\u001bJ\u0006\u0010\u001f\u001a\u00020\u001bJ)\u0010 \u001a\u00020\u001b2\b\u0010!\u001a\u0004\u0018\u00010\u00102\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0#\"\u00020$\u00a2\u0006\u0002\u0010%J\b\u0010&\u001a\u00020\u001bH\u0002J\b\u0010'\u001a\u00020\u001bH\u0002J\u0015\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\b+J\u0015\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b+J\u0015\u0010(\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b+J\u0010\u0010-\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020\u0010H\u0002J\b\u0010.\u001a\u00020\u001bH\u0002J\u0006\u0010/\u001a\u00020\u001bJ\u0006\u00100\u001a\u00020\u001bJ\b\u00101\u001a\u00020\u0010H\u0016J\b\u00102\u001a\u00020\u001bH\u0002J\u0010\u00103\u001a\u00020\u001b2\u0006\u00104\u001a\u000205H\u0016J\u000e\u00103\u001a\u00020\u001b2\u0006\u00104\u001a\u000206J\u0010\u00103\u001a\u00020\u001b2\u0006\u00104\u001a\u00020\u0005H\u0016J\u000e\u00103\u001a\u00020\u001b2\u0006\u00104\u001a\u000207J\u000e\u00103\u001a\u00020\u001b2\u0006\u00104\u001a\u000208J\u000e\u00103\u001a\u00020\u001b2\u0006\u00104\u001a\u00020\tJ\u000e\u00103\u001a\u00020\u001b2\u0006\u00104\u001a\u000209J\u0010\u00103\u001a\u00020\u001b2\b\u00104\u001a\u0004\u0018\u00010\u0010J\u000e\u00103\u001a\u00020\u001b2\u0006\u0010:\u001a\u00020;J\u000e\u00103\u001a\u00020\u001b2\u0006\u0010<\u001a\u00020\u0000J\u0014\u0010=\u001a\u00020\u001b2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020;0?J\u0014\u0010=\u001a\u00020\u001b2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020;0@J\u0014\u0010=\u001a\u00020\u001b2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020;0AJ0\u0010=\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002H\u00140\u0017\u00a2\u0006\u0002\b\u0018H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010BJ\u0014\u0010C\u001a\u00020\u001b2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00050?J\u0014\u0010C\u001a\u00020\u001b2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00050@J\u0014\u0010C\u001a\u00020\u001b2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00050AJ\u0014\u0010D\u001a\u00020\u001b2\f\u0010>\u001a\b\u0012\u0004\u0012\u0002070?J\u0014\u0010D\u001a\u00020\u001b2\f\u0010>\u001a\b\u0012\u0004\u0012\u0002070@J\u0014\u0010D\u001a\u00020\u001b2\f\u0010>\u001a\b\u0012\u0004\u0012\u0002070AJ\u0014\u0010E\u001a\u00020\u001b2\f\u0010>\u001a\b\u0012\u0004\u0012\u0002080?J\u0014\u0010E\u001a\u00020\u001b2\f\u0010>\u001a\b\u0012\u0004\u0012\u0002080@J\u0014\u0010E\u001a\u00020\u001b2\f\u0010>\u001a\b\u0012\u0004\u0012\u0002080AJ\u0014\u0010F\u001a\u00020\u001b2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\t0?J\u0014\u0010F\u001a\u00020\u001b2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\t0@J\u0014\u0010F\u001a\u00020\u001b2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\t0AJ\u0014\u0010G\u001a\u00020\u001b2\f\u0010>\u001a\b\u0012\u0004\u0012\u0002090?J\u0014\u0010G\u001a\u00020\u001b2\f\u0010>\u001a\b\u0012\u0004\u0012\u0002090@J\u0014\u0010G\u001a\u00020\u001b2\f\u0010>\u001a\b\u0012\u0004\u0012\u0002090AJ\b\u0010H\u001a\u00020\u001bH\u0016J0\u0010I\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002H\u00140\u0017\u00a2\u0006\u0002\b\u0018H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010BJ\u0014\u0010J\u001a\u00020\u001b2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00100?J\u0014\u0010J\u001a\u00020\u001b2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00100@J\u0014\u0010J\u001a\u00020\u001b2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00100AR\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006M"}, d2={"Lorg/availlang/json/JSONWriter;", "Ljava/lang/AutoCloseable;", "writer", "Ljava/io/Writer;", "prettyPrint", "", "(Ljava/io/Writer;Z)V", "addedArrayObjectValue", "currentIndentationLevel", "", "currentState", "Lorg/availlang/json/JSONWriter$JSONState;", "getCurrentState", "()Lorg/availlang/json/JSONWriter$JSONState;", "inArray", "newLineAndIndentation", "", "stack", "Ljava/util/LinkedList;", "at", "R", "key", "action", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "close", "", "contents", "endArray", "endObject", "flush", "format", "pattern", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "increaseIndentation", "insertNewLine", "privateWrite", "c", "", "privateWrite$avail_json", "text", "privateWriteItem", "reduceIndentation", "startArray", "startObject", "toString", "updateIndentation", "write", "value", "Ljava/math/BigDecimal;", "Ljava/math/BigInteger;", "", "", "", "friendly", "Lorg/availlang/json/JSONFriendly;", "other", "writeArray", "values", "", "", "Lkotlin/sequences/Sequence;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "writeBooleans", "writeDoubles", "writeFloats", "writeInts", "writeLongs", "writeNull", "writeObject", "writeStrings", "Companion", "JSONState", "avail-json"})
public class JSONWriter
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Writer writer;
    private final boolean prettyPrint;
    private int currentIndentationLevel;
    @NotNull
    private String newLineAndIndentation;
    private boolean inArray;
    private boolean addedArrayObjectValue;
    @NotNull
    private final LinkedList<JSONState> stack;

    /*
     * WARNING - void declaration
     */
    public JSONWriter(@NotNull Writer writer, boolean prettyPrint) {
        void $this$stack_u24lambda_u2d0;
        LinkedList linkedList;
        Intrinsics.checkNotNullParameter(writer, "writer");
        this.writer = writer;
        this.prettyPrint = prettyPrint;
        this.newLineAndIndentation = "";
        LinkedList linkedList2 = linkedList = new LinkedList();
        JSONWriter jSONWriter = this;
        boolean bl = false;
        $this$stack_u24lambda_u2d0.addFirst(JSONState.EXPECTING_SINGLE_VALUE);
        jSONWriter.stack = linkedList;
    }

    public /* synthetic */ JSONWriter(Writer writer, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            writer = new StringWriter();
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        this(writer, bl);
    }

    private final void updateIndentation() {
        if (this.prettyPrint) {
            int n = 0;
            int n2 = this.currentIndentationLevel;
            char[] cArray = new char[n2];
            JSONWriter jSONWriter = this;
            while (n < n2) {
                int n3 = n++;
                cArray[n3] = 9;
            }
            char[] cArray2 = cArray;
            jSONWriter.newLineAndIndentation = "\n" + new String(cArray2);
        }
    }

    private final void reduceIndentation() {
        if (this.prettyPrint) {
            this.currentIndentationLevel = RangesKt.coerceAtLeast(0, this.currentIndentationLevel - 1);
            this.updateIndentation();
        }
    }

    private final void increaseIndentation() {
        this.currentIndentationLevel = RangesKt.coerceAtLeast(0, this.currentIndentationLevel + 1);
        this.updateIndentation();
    }

    private final void insertNewLine() {
        this.privateWrite$avail_json(this.newLineAndIndentation);
    }

    @NotNull
    public final String contents() {
        return this.writer.toString();
    }

    public final void privateWrite$avail_json(int c) throws JSONIOException {
        boolean bl;
        boolean bl2 = bl = (c & 0xFFFF) == c;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        try {
            this.writer.write(c);
        }
        catch (IOException e) {
            throw new JSONIOException(e);
        }
    }

    public final void privateWrite$avail_json(char c) throws JSONIOException {
        try {
            this.writer.write(String.valueOf(c));
        }
        catch (IOException e) {
            throw new JSONIOException(e);
        }
    }

    public final void privateWrite$avail_json(@NotNull String text) throws JSONIOException {
        Intrinsics.checkNotNullParameter(text, "text");
        try {
            this.writer.write(text);
        }
        catch (IOException e) {
            throw new JSONIOException(e);
        }
    }

    private final JSONState getCurrentState() {
        JSONState jSONState = this.stack.peekFirst();
        Intrinsics.checkNotNullExpressionValue((Object)jSONState, "stack.peekFirst()");
        return jSONState;
    }

    private final void privateWriteItem(String text) throws JSONIOException {
        JSONState state = this.stack.removeFirst();
        state.checkCanWriteAnyValue$avail_json();
        state.writePrologueTo$avail_json(this);
        if (this.prettyPrint && state.getNewlineBeforeWrite() && state != JSONState.EXPECTING_VALUE_OR_ARRAY_END) {
            this.insertNewLine();
        }
        this.privateWrite$avail_json(text);
        this.stack.addFirst(state.nextStateAfterValue$avail_json());
    }

    public void writeNull() throws JSONIOException, IllegalStateException {
        this.privateWriteItem(String.valueOf(null));
    }

    public void write(boolean value) throws JSONIOException, IllegalStateException {
        String string2 = Boolean.toString(value);
        Intrinsics.checkNotNullExpressionValue(string2, "toString(value)");
        this.privateWriteItem(string2);
    }

    public void write(@NotNull BigDecimal value) throws JSONIOException, IllegalStateException {
        Intrinsics.checkNotNullParameter(value, "value");
        String string2 = value.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "value.toString()");
        this.privateWriteItem(string2);
    }

    public final void write(@NotNull BigInteger value) throws JSONIOException, IllegalStateException {
        Intrinsics.checkNotNullParameter(value, "value");
        String string2 = value.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "value.toString()");
        this.privateWriteItem(string2);
    }

    public final void write(int value) throws JSONIOException, IllegalStateException {
        this.privateWriteItem(String.valueOf(value));
    }

    public final void write(long value) throws JSONIOException, IllegalStateException {
        this.privateWriteItem(String.valueOf(value));
    }

    public final void write(float value) throws JSONIOException, IllegalStateException {
        this.privateWriteItem(value == Float.POSITIVE_INFINITY ? "Infinity" : (value == Float.NEGATIVE_INFINITY ? "-Infinity" : (Float.isNaN(value) ? "NaN" : String.valueOf(value))));
    }

    public final void write(double value) throws JSONIOException, IllegalStateException {
        this.privateWriteItem(value == Double.POSITIVE_INFINITY ? "Infinity" : (value == Double.NEGATIVE_INFINITY ? "-Infinity" : (Double.isNaN(value) ? "NaN" : String.valueOf(value))));
    }

    public final void format(@Nullable String pattern, Object ... args2) throws JSONIOException, IllegalStateException {
        Intrinsics.checkNotNullParameter(args2, "args");
        if (pattern == null) {
            this.writeNull();
        } else {
            JSONState state = this.stack.removeFirst();
            state.checkCanWriteStringValue$avail_json();
            state.writePrologueTo$avail_json(this);
            if (this.prettyPrint && state.getNewlineBeforeWrite() && state != JSONState.EXPECTING_VALUE_OR_ARRAY_END) {
                this.insertNewLine();
            }
            Object[] objectArray = Arrays.copyOf(args2, args2.length);
            String string2 = String.format(pattern, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(format, *args)");
            String value = string2;
            this.privateWrite$avail_json('\"');
            int codePoint = 0;
            int size = value.length();
            for (int i = 0; i < size; i += Character.charCount(codePoint)) {
                String string3;
                Object object;
                codePoint = value.codePointAt(i);
                if (Character.isISOControl(codePoint)) {
                    int n = codePoint;
                    if (n == 8) {
                        this.privateWrite$avail_json("\\b");
                        continue;
                    }
                    if (n == 9) {
                        this.privateWrite$avail_json("\\t");
                        continue;
                    }
                    if (n == 10) {
                        this.privateWrite$avail_json("\\n");
                        continue;
                    }
                    if (n == 12) {
                        this.privateWrite$avail_json("\\f");
                        continue;
                    }
                    if (n == 13) {
                        this.privateWrite$avail_json("\\r");
                        continue;
                    }
                    object = "\\u%04X";
                    Object[] objectArray2 = new Object[]{codePoint};
                    String string4 = String.format((String)object, Arrays.copyOf(objectArray2, objectArray2.length));
                    Intrinsics.checkNotNullExpressionValue(string4, "format(format, *args)");
                    this.privateWrite$avail_json(string4);
                    continue;
                }
                if (codePoint == 92) {
                    this.privateWrite$avail_json("\\\\");
                    continue;
                }
                if (codePoint == 34) {
                    this.privateWrite$avail_json("\\\"");
                    continue;
                }
                if (codePoint < 128) {
                    this.privateWrite$avail_json(codePoint);
                    continue;
                }
                if (Character.isSupplementaryCodePoint(codePoint)) {
                    string3 = "\\u%04X\\u%04X";
                    object = new Object[]{(int)Character.highSurrogate(codePoint), (int)Character.lowSurrogate(codePoint)};
                    String string5 = String.format(string3, Arrays.copyOf(object, ((Object[])object).length));
                    Intrinsics.checkNotNullExpressionValue(string5, "format(format, *args)");
                    this.privateWrite$avail_json(string5);
                    continue;
                }
                string3 = "\\u%04X";
                object = new Object[]{codePoint};
                String string6 = String.format(string3, Arrays.copyOf(object, ((Object[])object).length));
                Intrinsics.checkNotNullExpressionValue(string6, "format(format, *args)");
                this.privateWrite$avail_json(string6);
            }
            this.privateWrite$avail_json('\"');
            this.stack.addFirst(state.nextStateAfterValue$avail_json());
        }
    }

    public final void write(@Nullable String value) {
        if (value == null) {
            this.writeNull();
        } else {
            Object[] objectArray = new Object[]{value};
            this.format("%s", objectArray);
        }
    }

    public final void write(@NotNull JSONWriter other) {
        Intrinsics.checkNotNullParameter(other, "other");
        JSONState state = this.stack.removeFirst();
        state.checkCanWriteAnyValue$avail_json();
        state.writePrologueTo$avail_json(this);
        this.privateWrite$avail_json(other.toString());
        this.stack.addFirst(state.nextStateAfterValue$avail_json());
    }

    public final void write(@NotNull JSONFriendly friendly) {
        Intrinsics.checkNotNullParameter(friendly, "friendly");
        friendly.writeTo(this);
    }

    public final void startObject() throws JSONIOException {
        JSONState state = this.getCurrentState();
        state.checkCanWriteObjectStart$avail_json();
        state.writePrologueTo$avail_json(this);
        if (this.prettyPrint && this.inArray) {
            this.insertNewLine();
            this.addedArrayObjectValue = true;
        }
        this.privateWrite$avail_json('{');
        if (this.prettyPrint) {
            this.increaseIndentation();
        }
        this.stack.addFirst(JSONState.EXPECTING_FIRST_OBJECT_KEY_OR_OBJECT_END);
    }

    public final void endObject() throws JSONIOException, IllegalStateException {
        JSONState state = this.stack.removeFirst();
        state.checkCanWriteObjectEnd$avail_json();
        if (this.prettyPrint) {
            this.reduceIndentation();
            this.insertNewLine();
        }
        this.privateWrite$avail_json('}');
        this.stack.addFirst(this.stack.removeFirst().nextStateAfterValue$avail_json());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R writeObject(@NotNull Function1<? super JSONWriter, ? extends R> action2) throws JSONIOException, IllegalStateException {
        Intrinsics.checkNotNullParameter(action2, "action");
        boolean $i$f$writeObject = false;
        this.startObject();
        try {
            R r = action2.invoke(this);
            return r;
        }
        finally {
            InlineMarker.finallyStart(1);
            this.endObject();
            InlineMarker.finallyEnd(1);
        }
    }

    public final void startArray() throws JSONIOException, IllegalStateException {
        JSONState state = this.getCurrentState();
        state.checkCanWriteArrayStart$avail_json();
        state.writePrologueTo$avail_json(this);
        this.privateWrite$avail_json('[');
        if (this.prettyPrint) {
            this.increaseIndentation();
            this.inArray = true;
            this.addedArrayObjectValue = false;
        }
        this.stack.addFirst(JSONState.EXPECTING_FIRST_VALUE_OR_ARRAY_END);
    }

    public final void endArray() throws JSONIOException, IllegalStateException {
        JSONState state = this.stack.removeFirst();
        state.checkCanWriteArrayEnd$avail_json();
        if (this.prettyPrint) {
            this.reduceIndentation();
            if (this.addedArrayObjectValue) {
                this.insertNewLine();
            }
        }
        this.privateWrite$avail_json(']');
        this.stack.addFirst(this.stack.removeFirst().nextStateAfterValue$avail_json());
        if (this.prettyPrint) {
            this.addedArrayObjectValue = false;
            this.inArray = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R writeArray(@NotNull Function1<? super JSONWriter, ? extends R> action2) throws JSONIOException, IllegalStateException {
        Intrinsics.checkNotNullParameter(action2, "action");
        boolean $i$f$writeArray = false;
        this.startArray();
        try {
            R r = action2.invoke(this);
            return r;
        }
        finally {
            InlineMarker.finallyStart(1);
            this.endArray();
            InlineMarker.finallyEnd(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeInts(@NotNull Iterator<Integer> values2) throws JSONIOException, IllegalStateException {
        Intrinsics.checkNotNullParameter(values2, "values");
        JSONWriter this_$iv = this;
        boolean $i$f$writeArray = false;
        this_$iv.startArray();
        try {
            JSONWriter $this$writeInts_u24lambda_u2d1 = this_$iv;
            boolean bl = false;
            Iterator<Integer> $this$forEach$iv = values2;
            boolean $i$f$forEach = false;
            Iterator<Integer> iterator2 = $this$forEach$iv;
            while (iterator2.hasNext()) {
                Integer element$iv = iterator2.next();
                int p0 = ((Number)element$iv).intValue();
                boolean bl2 = false;
                $this$writeInts_u24lambda_u2d1.write(p0);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.endArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeLongs(@NotNull Iterator<Long> values2) throws JSONIOException, IllegalStateException {
        Intrinsics.checkNotNullParameter(values2, "values");
        JSONWriter this_$iv = this;
        boolean $i$f$writeArray = false;
        this_$iv.startArray();
        try {
            JSONWriter $this$writeLongs_u24lambda_u2d3 = this_$iv;
            boolean bl = false;
            Iterator<Long> $this$forEach$iv = values2;
            boolean $i$f$forEach = false;
            Iterator<Long> iterator2 = $this$forEach$iv;
            while (iterator2.hasNext()) {
                Long element$iv = iterator2.next();
                long p0 = ((Number)element$iv).longValue();
                boolean bl2 = false;
                $this$writeLongs_u24lambda_u2d3.write(p0);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.endArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeFloats(@NotNull Iterator<Float> values2) throws JSONIOException, IllegalStateException {
        Intrinsics.checkNotNullParameter(values2, "values");
        JSONWriter this_$iv = this;
        boolean $i$f$writeArray = false;
        this_$iv.startArray();
        try {
            JSONWriter $this$writeFloats_u24lambda_u2d5 = this_$iv;
            boolean bl = false;
            Iterator<Float> $this$forEach$iv = values2;
            boolean $i$f$forEach = false;
            Iterator<Float> iterator2 = $this$forEach$iv;
            while (iterator2.hasNext()) {
                Float element$iv = iterator2.next();
                float p0 = ((Number)element$iv).floatValue();
                boolean bl2 = false;
                $this$writeFloats_u24lambda_u2d5.write(p0);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.endArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeDoubles(@NotNull Iterator<Double> values2) throws JSONIOException, IllegalStateException {
        Intrinsics.checkNotNullParameter(values2, "values");
        JSONWriter this_$iv = this;
        boolean $i$f$writeArray = false;
        this_$iv.startArray();
        try {
            JSONWriter $this$writeDoubles_u24lambda_u2d7 = this_$iv;
            boolean bl = false;
            Iterator<Double> $this$forEach$iv = values2;
            boolean $i$f$forEach = false;
            Iterator<Double> iterator2 = $this$forEach$iv;
            while (iterator2.hasNext()) {
                Double element$iv = iterator2.next();
                double p0 = ((Number)element$iv).doubleValue();
                boolean bl2 = false;
                $this$writeDoubles_u24lambda_u2d7.write(p0);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.endArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeBooleans(@NotNull Iterator<Boolean> values2) throws JSONIOException, IllegalStateException {
        Intrinsics.checkNotNullParameter(values2, "values");
        JSONWriter this_$iv = this;
        boolean $i$f$writeArray = false;
        this_$iv.startArray();
        try {
            JSONWriter $this$writeBooleans_u24lambda_u2d9 = this_$iv;
            boolean bl = false;
            Iterator<Boolean> $this$forEach$iv = values2;
            boolean $i$f$forEach = false;
            Iterator<Boolean> iterator2 = $this$forEach$iv;
            while (iterator2.hasNext()) {
                Boolean element$iv = iterator2.next();
                boolean p0 = element$iv;
                boolean bl2 = false;
                $this$writeBooleans_u24lambda_u2d9.write(p0);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.endArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeStrings(@NotNull Iterator<String> values2) throws JSONIOException, IllegalStateException {
        Intrinsics.checkNotNullParameter(values2, "values");
        JSONWriter this_$iv = this;
        boolean $i$f$writeArray = false;
        this_$iv.startArray();
        try {
            JSONWriter $this$writeStrings_u24lambda_u2d11 = this_$iv;
            boolean bl = false;
            Iterator<String> $this$forEach$iv = values2;
            boolean $i$f$forEach = false;
            Iterator<String> iterator2 = $this$forEach$iv;
            while (iterator2.hasNext()) {
                String element$iv;
                String p0 = element$iv = iterator2.next();
                boolean bl2 = false;
                $this$writeStrings_u24lambda_u2d11.write(p0);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.endArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeArray(@NotNull Iterator<? extends JSONFriendly> values2) throws JSONIOException, IllegalStateException {
        Intrinsics.checkNotNullParameter(values2, "values");
        JSONWriter this_$iv = this;
        boolean $i$f$writeArray = false;
        this_$iv.startArray();
        try {
            JSONWriter $this$writeArray_u24lambda_u2d13 = this_$iv;
            boolean bl = false;
            Iterator<? extends JSONFriendly> $this$forEach$iv = values2;
            boolean $i$f$forEach = false;
            Iterator<? extends JSONFriendly> iterator2 = $this$forEach$iv;
            while (iterator2.hasNext()) {
                JSONFriendly element$iv;
                JSONFriendly p0 = element$iv = iterator2.next();
                boolean bl2 = false;
                $this$writeArray_u24lambda_u2d13.write(p0);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.endArray();
        }
    }

    public final void writeInts(@NotNull Iterable<Integer> values2) throws JSONIOException, IllegalStateException {
        Intrinsics.checkNotNullParameter(values2, "values");
        this.writeInts(values2.iterator());
    }

    public final void writeLongs(@NotNull Iterable<Long> values2) throws JSONIOException, IllegalStateException {
        Intrinsics.checkNotNullParameter(values2, "values");
        this.writeLongs(values2.iterator());
    }

    public final void writeFloats(@NotNull Iterable<Float> values2) throws JSONIOException, IllegalStateException {
        Intrinsics.checkNotNullParameter(values2, "values");
        this.writeFloats(values2.iterator());
    }

    public final void writeDoubles(@NotNull Iterable<Double> values2) throws JSONIOException, IllegalStateException {
        Intrinsics.checkNotNullParameter(values2, "values");
        this.writeDoubles(values2.iterator());
    }

    public final void writeBooleans(@NotNull Iterable<Boolean> values2) throws JSONIOException, IllegalStateException {
        Intrinsics.checkNotNullParameter(values2, "values");
        this.writeBooleans(values2.iterator());
    }

    public final void writeStrings(@NotNull Iterable<String> values2) throws JSONIOException, IllegalStateException {
        Intrinsics.checkNotNullParameter(values2, "values");
        this.writeStrings(values2.iterator());
    }

    public final void writeArray(@NotNull Iterable<? extends JSONFriendly> values2) throws JSONIOException, IllegalStateException {
        Intrinsics.checkNotNullParameter(values2, "values");
        this.writeArray(values2.iterator());
    }

    public final void writeInts(@NotNull Sequence<Integer> values2) throws JSONIOException, IllegalStateException {
        Intrinsics.checkNotNullParameter(values2, "values");
        this.writeInts(values2.iterator());
    }

    public final void writeLongs(@NotNull Sequence<Long> values2) throws JSONIOException, IllegalStateException {
        Intrinsics.checkNotNullParameter(values2, "values");
        this.writeLongs(values2.iterator());
    }

    public final void writeFloats(@NotNull Sequence<Float> values2) throws JSONIOException, IllegalStateException {
        Intrinsics.checkNotNullParameter(values2, "values");
        this.writeFloats(values2.iterator());
    }

    public final void writeDoubles(@NotNull Sequence<Double> values2) throws JSONIOException, IllegalStateException {
        Intrinsics.checkNotNullParameter(values2, "values");
        this.writeDoubles(values2.iterator());
    }

    public final void writeBooleans(@NotNull Sequence<Boolean> values2) throws JSONIOException, IllegalStateException {
        Intrinsics.checkNotNullParameter(values2, "values");
        this.writeBooleans(values2.iterator());
    }

    public final void writeStrings(@NotNull Sequence<String> values2) throws JSONIOException, IllegalStateException {
        Intrinsics.checkNotNullParameter(values2, "values");
        this.writeStrings(values2.iterator());
    }

    public final void writeArray(@NotNull Sequence<? extends JSONFriendly> values2) throws JSONIOException, IllegalStateException {
        Intrinsics.checkNotNullParameter(values2, "values");
        this.writeArray(values2.iterator());
    }

    public final /* synthetic */ <R> R at(String key, Function1<? super JSONWriter, ? extends R> action2) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(action2, "action");
        boolean $i$f$at = false;
        this.write(key);
        return action2.invoke(this);
    }

    public final void flush() throws JSONIOException {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new JSONIOException(e);
        }
    }

    @Override
    public void close() throws JSONIOException, IllegalStateException {
        boolean bl;
        JSONState state = this.getCurrentState();
        state.checkCanEndDocument$avail_json();
        boolean bl2 = bl = this.stack.size() == 1;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.flush();
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new JSONIOException(e);
        }
    }

    @NotNull
    public String toString() throws IllegalStateException {
        try {
            JSONState state = this.getCurrentState();
            state.checkCanEndDocument$avail_json();
            return this.writer.toString();
        }
        catch (Throwable e) {
            String string2 = "BROKEN: %s <%s>: %s";
            Object[] objectArray = new Object[]{e.getClass().getName(), e.getMessage(), this.writer.toString()};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
            return string3;
        }
    }

    public JSONWriter() {
        this(null, false, 3, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\t\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0007\u001a\u00020\bH\u0010\u00a2\u0006\u0002\b\tJ\r\u0010\n\u001a\u00020\bH\u0010\u00a2\u0006\u0002\b\u000bJ\r\u0010\f\u001a\u00020\bH\u0010\u00a2\u0006\u0002\b\rJ\r\u0010\u000e\u001a\u00020\bH\u0010\u00a2\u0006\u0002\b\u000fJ\r\u0010\u0010\u001a\u00020\bH\u0010\u00a2\u0006\u0002\b\u0011J\r\u0010\u0012\u001a\u00020\bH\u0010\u00a2\u0006\u0002\b\u0013J\r\u0010\u0014\u001a\u00020\bH\u0010\u00a2\u0006\u0002\b\u0015J\r\u0010\u0016\u001a\u00020\u0000H \u00a2\u0006\u0002\b\u0017J\u0015\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0010\u00a2\u0006\u0002\b\u001bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"\u00a8\u0006#"}, d2={"Lorg/availlang/json/JSONWriter$JSONState;", "", "(Ljava/lang/String;I)V", "newlineBeforeWrite", "", "getNewlineBeforeWrite", "()Z", "checkCanEndDocument", "", "checkCanEndDocument$avail_json", "checkCanWriteAnyValue", "checkCanWriteAnyValue$avail_json", "checkCanWriteArrayEnd", "checkCanWriteArrayEnd$avail_json", "checkCanWriteArrayStart", "checkCanWriteArrayStart$avail_json", "checkCanWriteObjectEnd", "checkCanWriteObjectEnd$avail_json", "checkCanWriteObjectStart", "checkCanWriteObjectStart$avail_json", "checkCanWriteStringValue", "checkCanWriteStringValue$avail_json", "nextStateAfterValue", "nextStateAfterValue$avail_json", "writePrologueTo", "writer", "Lorg/availlang/json/JSONWriter;", "writePrologueTo$avail_json", "EXPECTING_SINGLE_VALUE", "EXPECTING_END_OF_DOCUMENT", "EXPECTING_FIRST_OBJECT_KEY_OR_OBJECT_END", "EXPECTING_OBJECT_KEY_OR_OBJECT_END", "EXPECTING_OBJECT_VALUE", "EXPECTING_FIRST_VALUE_OR_ARRAY_END", "EXPECTING_VALUE_OR_ARRAY_END", "avail-json"})
    public static final abstract class JSONState
    extends Enum<JSONState> {
        private final boolean newlineBeforeWrite;
        public static final /* enum */ JSONState EXPECTING_SINGLE_VALUE = new EXPECTING_SINGLE_VALUE("EXPECTING_SINGLE_VALUE", 0);
        public static final /* enum */ JSONState EXPECTING_END_OF_DOCUMENT = new EXPECTING_END_OF_DOCUMENT("EXPECTING_END_OF_DOCUMENT", 1);
        public static final /* enum */ JSONState EXPECTING_FIRST_OBJECT_KEY_OR_OBJECT_END = new EXPECTING_FIRST_OBJECT_KEY_OR_OBJECT_END("EXPECTING_FIRST_OBJECT_KEY_OR_OBJECT_END", 2);
        public static final /* enum */ JSONState EXPECTING_OBJECT_KEY_OR_OBJECT_END = new EXPECTING_OBJECT_KEY_OR_OBJECT_END("EXPECTING_OBJECT_KEY_OR_OBJECT_END", 3);
        public static final /* enum */ JSONState EXPECTING_OBJECT_VALUE = new EXPECTING_OBJECT_VALUE("EXPECTING_OBJECT_VALUE", 4);
        public static final /* enum */ JSONState EXPECTING_FIRST_VALUE_OR_ARRAY_END = new EXPECTING_FIRST_VALUE_OR_ARRAY_END("EXPECTING_FIRST_VALUE_OR_ARRAY_END", 5);
        public static final /* enum */ JSONState EXPECTING_VALUE_OR_ARRAY_END = new EXPECTING_VALUE_OR_ARRAY_END("EXPECTING_VALUE_OR_ARRAY_END", 6);
        private static final /* synthetic */ JSONState[] $VALUES;

        private JSONState() {
        }

        public void checkCanEndDocument$avail_json() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public void checkCanWriteAnyValue$avail_json() throws IllegalStateException {
        }

        public void checkCanWriteStringValue$avail_json() throws IllegalStateException {
        }

        public void checkCanWriteObjectStart$avail_json() throws IllegalStateException {
        }

        public void checkCanWriteObjectEnd$avail_json() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public void checkCanWriteArrayStart$avail_json() throws IllegalStateException {
        }

        public void checkCanWriteArrayEnd$avail_json() throws IllegalStateException {
            throw new IllegalStateException();
        }

        @NotNull
        public abstract JSONState nextStateAfterValue$avail_json();

        public void writePrologueTo$avail_json(@NotNull JSONWriter writer) throws JSONIOException {
            Intrinsics.checkNotNullParameter(writer, "writer");
        }

        public boolean getNewlineBeforeWrite() {
            return this.newlineBeforeWrite;
        }

        public static JSONState[] values() {
            return (JSONState[])$VALUES.clone();
        }

        public static JSONState valueOf(String value) {
            return Enum.valueOf(JSONState.class, value);
        }

        public /* synthetic */ JSONState(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            $VALUES = jSONStateArray = new JSONState[]{JSONState.EXPECTING_SINGLE_VALUE, JSONState.EXPECTING_END_OF_DOCUMENT, JSONState.EXPECTING_FIRST_OBJECT_KEY_OR_OBJECT_END, JSONState.EXPECTING_OBJECT_KEY_OR_OBJECT_END, JSONState.EXPECTING_OBJECT_VALUE, JSONState.EXPECTING_FIRST_VALUE_OR_ARRAY_END, JSONState.EXPECTING_VALUE_OR_ARRAY_END};
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0001\u0018\u00002\u00020\u0001J\r\u0010\u0002\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b\u0004J\r\u0010\u0005\u001a\u00020\u0001H\u0010\u00a2\u0006\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/availlang/json/JSONWriter$JSONState$EXPECTING_SINGLE_VALUE;", "Lorg/availlang/json/JSONWriter$JSONState;", "checkCanEndDocument", "", "checkCanEndDocument$avail_json", "nextStateAfterValue", "nextStateAfterValue$avail_json", "avail-json"})
        static final class EXPECTING_SINGLE_VALUE
        extends JSONState {
            /*
             * WARNING - void declaration
             */
            EXPECTING_SINGLE_VALUE() {
                void var1_1;
            }

            @Override
            @NotNull
            public JSONState nextStateAfterValue$avail_json() {
                return EXPECTING_END_OF_DOCUMENT;
            }

            @Override
            public void checkCanEndDocument$avail_json() throws IllegalStateException {
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\n\b\u00c6\u0001\u0018\u00002\u00020\u0001J\r\u0010\u0006\u001a\u00020\u0007H\u0010\u00a2\u0006\u0002\b\bJ\r\u0010\t\u001a\u00020\nH\u0010\u00a2\u0006\u0002\b\u000bJ\r\u0010\f\u001a\u00020\nH\u0010\u00a2\u0006\u0002\b\rJ\r\u0010\u000e\u001a\u00020\nH\u0010\u00a2\u0006\u0002\b\u000fJ\r\u0010\u0010\u001a\u00020\nH\u0010\u00a2\u0006\u0002\b\u0011J\r\u0010\u0012\u001a\u00020\u0001H\u0010\u00a2\u0006\u0002\b\u0013R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0014"}, d2={"Lorg/availlang/json/JSONWriter$JSONState$EXPECTING_END_OF_DOCUMENT;", "Lorg/availlang/json/JSONWriter$JSONState;", "newlineBeforeWrite", "", "getNewlineBeforeWrite", "()Z", "checkCanEndDocument", "", "checkCanEndDocument$avail_json", "checkCanWriteAnyValue", "", "checkCanWriteAnyValue$avail_json", "checkCanWriteArrayStart", "checkCanWriteArrayStart$avail_json", "checkCanWriteObjectStart", "checkCanWriteObjectStart$avail_json", "checkCanWriteStringValue", "checkCanWriteStringValue$avail_json", "nextStateAfterValue", "nextStateAfterValue$avail_json", "avail-json"})
        static final class EXPECTING_END_OF_DOCUMENT
        extends JSONState {
            private final boolean newlineBeforeWrite;

            /*
             * WARNING - void declaration
             */
            EXPECTING_END_OF_DOCUMENT() {
                void var1_1;
                this.newlineBeforeWrite = true;
            }

            @Override
            @NotNull
            public JSONState nextStateAfterValue$avail_json() {
                throw new IllegalStateException();
            }

            @Override
            public void checkCanEndDocument$avail_json() throws IllegalStateException {
            }

            @NotNull
            public Void checkCanWriteAnyValue$avail_json() throws IllegalStateException {
                throw new IllegalStateException();
            }

            @NotNull
            public Void checkCanWriteStringValue$avail_json() throws IllegalStateException {
                throw new IllegalStateException();
            }

            @NotNull
            public Void checkCanWriteObjectStart$avail_json() throws IllegalStateException {
                throw new IllegalStateException();
            }

            @NotNull
            public Void checkCanWriteArrayStart$avail_json() throws IllegalStateException {
                throw new IllegalStateException();
            }

            @Override
            public boolean getNewlineBeforeWrite() {
                return this.newlineBeforeWrite;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c6\u0001\u0018\u00002\u00020\u0001J\r\u0010\u0006\u001a\u00020\u0007H\u0010\u00a2\u0006\u0002\b\bJ\r\u0010\t\u001a\u00020\u0007H\u0010\u00a2\u0006\u0002\b\nJ\r\u0010\u000b\u001a\u00020\fH\u0010\u00a2\u0006\u0002\b\rJ\r\u0010\u000e\u001a\u00020\u0007H\u0010\u00a2\u0006\u0002\b\u000fJ\r\u0010\u0010\u001a\u00020\u0001H\u0010\u00a2\u0006\u0002\b\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0012"}, d2={"Lorg/availlang/json/JSONWriter$JSONState$EXPECTING_FIRST_OBJECT_KEY_OR_OBJECT_END;", "Lorg/availlang/json/JSONWriter$JSONState;", "newlineBeforeWrite", "", "getNewlineBeforeWrite", "()Z", "checkCanWriteAnyValue", "", "checkCanWriteAnyValue$avail_json", "checkCanWriteArrayStart", "checkCanWriteArrayStart$avail_json", "checkCanWriteObjectEnd", "", "checkCanWriteObjectEnd$avail_json", "checkCanWriteObjectStart", "checkCanWriteObjectStart$avail_json", "nextStateAfterValue", "nextStateAfterValue$avail_json", "avail-json"})
        static final class EXPECTING_FIRST_OBJECT_KEY_OR_OBJECT_END
        extends JSONState {
            private final boolean newlineBeforeWrite;

            /*
             * WARNING - void declaration
             */
            EXPECTING_FIRST_OBJECT_KEY_OR_OBJECT_END() {
                void var1_1;
                this.newlineBeforeWrite = true;
            }

            @Override
            @NotNull
            public JSONState nextStateAfterValue$avail_json() {
                return EXPECTING_OBJECT_VALUE;
            }

            @NotNull
            public Void checkCanWriteAnyValue$avail_json() throws IllegalStateException {
                throw new IllegalStateException();
            }

            @NotNull
            public Void checkCanWriteObjectStart$avail_json() throws IllegalStateException {
                throw new IllegalStateException();
            }

            @Override
            public void checkCanWriteObjectEnd$avail_json() {
            }

            @NotNull
            public Void checkCanWriteArrayStart$avail_json() throws IllegalStateException {
                throw new IllegalStateException();
            }

            @Override
            public boolean getNewlineBeforeWrite() {
                return this.newlineBeforeWrite;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\r\u0010\u0006\u001a\u00020\u0007H\u0010\u00a2\u0006\u0002\b\bJ\r\u0010\t\u001a\u00020\u0007H\u0010\u00a2\u0006\u0002\b\nJ\r\u0010\u000b\u001a\u00020\fH\u0010\u00a2\u0006\u0002\b\rJ\r\u0010\u000e\u001a\u00020\u0007H\u0010\u00a2\u0006\u0002\b\u000fJ\r\u0010\u0010\u001a\u00020\u0001H\u0010\u00a2\u0006\u0002\b\u0011J\u0015\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0010\u00a2\u0006\u0002\b\u0015R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0016"}, d2={"Lorg/availlang/json/JSONWriter$JSONState$EXPECTING_OBJECT_KEY_OR_OBJECT_END;", "Lorg/availlang/json/JSONWriter$JSONState;", "newlineBeforeWrite", "", "getNewlineBeforeWrite", "()Z", "checkCanWriteAnyValue", "", "checkCanWriteAnyValue$avail_json", "checkCanWriteArrayStart", "checkCanWriteArrayStart$avail_json", "checkCanWriteObjectEnd", "", "checkCanWriteObjectEnd$avail_json", "checkCanWriteObjectStart", "checkCanWriteObjectStart$avail_json", "nextStateAfterValue", "nextStateAfterValue$avail_json", "writePrologueTo", "writer", "Lorg/availlang/json/JSONWriter;", "writePrologueTo$avail_json", "avail-json"})
        static final class EXPECTING_OBJECT_KEY_OR_OBJECT_END
        extends JSONState {
            private final boolean newlineBeforeWrite;

            /*
             * WARNING - void declaration
             */
            EXPECTING_OBJECT_KEY_OR_OBJECT_END() {
                void var1_1;
                this.newlineBeforeWrite = true;
            }

            @Override
            @NotNull
            public JSONState nextStateAfterValue$avail_json() {
                return EXPECTING_OBJECT_VALUE;
            }

            @NotNull
            public Void checkCanWriteAnyValue$avail_json() throws IllegalStateException {
                throw new IllegalStateException();
            }

            @NotNull
            public Void checkCanWriteObjectStart$avail_json() throws IllegalStateException {
                throw new IllegalStateException();
            }

            @Override
            public void checkCanWriteObjectEnd$avail_json() {
            }

            @NotNull
            public Void checkCanWriteArrayStart$avail_json() throws IllegalStateException {
                throw new IllegalStateException();
            }

            @Override
            public void writePrologueTo$avail_json(@NotNull JSONWriter writer) throws JSONIOException {
                Intrinsics.checkNotNullParameter(writer, "writer");
                if (writer.prettyPrint) {
                    writer.privateWrite$avail_json(", ");
                } else {
                    writer.privateWrite$avail_json(',');
                }
            }

            @Override
            public boolean getNewlineBeforeWrite() {
                return this.newlineBeforeWrite;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\r\u0010\u0002\u001a\u00020\u0001H\u0010\u00a2\u0006\u0002\b\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0010\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/availlang/json/JSONWriter$JSONState$EXPECTING_OBJECT_VALUE;", "Lorg/availlang/json/JSONWriter$JSONState;", "nextStateAfterValue", "nextStateAfterValue$avail_json", "writePrologueTo", "", "writer", "Lorg/availlang/json/JSONWriter;", "writePrologueTo$avail_json", "avail-json"})
        static final class EXPECTING_OBJECT_VALUE
        extends JSONState {
            /*
             * WARNING - void declaration
             */
            EXPECTING_OBJECT_VALUE() {
                void var1_1;
            }

            @Override
            @NotNull
            public JSONState nextStateAfterValue$avail_json() {
                return EXPECTING_OBJECT_KEY_OR_OBJECT_END;
            }

            @Override
            public void writePrologueTo$avail_json(@NotNull JSONWriter writer) throws JSONIOException {
                Intrinsics.checkNotNullParameter(writer, "writer");
                if (writer.prettyPrint) {
                    writer.privateWrite$avail_json(": ");
                } else {
                    writer.privateWrite$avail_json(':');
                }
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0001\u0018\u00002\u00020\u0001J\r\u0010\u0002\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b\u0004J\r\u0010\u0005\u001a\u00020\u0001H\u0010\u00a2\u0006\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/availlang/json/JSONWriter$JSONState$EXPECTING_FIRST_VALUE_OR_ARRAY_END;", "Lorg/availlang/json/JSONWriter$JSONState;", "checkCanWriteArrayEnd", "", "checkCanWriteArrayEnd$avail_json", "nextStateAfterValue", "nextStateAfterValue$avail_json", "avail-json"})
        static final class EXPECTING_FIRST_VALUE_OR_ARRAY_END
        extends JSONState {
            /*
             * WARNING - void declaration
             */
            EXPECTING_FIRST_VALUE_OR_ARRAY_END() {
                void var1_1;
            }

            @Override
            @NotNull
            public JSONState nextStateAfterValue$avail_json() {
                return EXPECTING_VALUE_OR_ARRAY_END;
            }

            @Override
            public void checkCanWriteArrayEnd$avail_json() {
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\r\u0010\u0002\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b\u0004J\r\u0010\u0005\u001a\u00020\u0001H\u0010\u00a2\u0006\u0002\b\u0006J\u0015\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0010\u00a2\u0006\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/availlang/json/JSONWriter$JSONState$EXPECTING_VALUE_OR_ARRAY_END;", "Lorg/availlang/json/JSONWriter$JSONState;", "checkCanWriteArrayEnd", "", "checkCanWriteArrayEnd$avail_json", "nextStateAfterValue", "nextStateAfterValue$avail_json", "writePrologueTo", "writer", "Lorg/availlang/json/JSONWriter;", "writePrologueTo$avail_json", "avail-json"})
        static final class EXPECTING_VALUE_OR_ARRAY_END
        extends JSONState {
            /*
             * WARNING - void declaration
             */
            EXPECTING_VALUE_OR_ARRAY_END() {
                void var1_1;
            }

            @Override
            @NotNull
            public JSONState nextStateAfterValue$avail_json() {
                return this;
            }

            @Override
            public void checkCanWriteArrayEnd$avail_json() {
            }

            @Override
            public void writePrologueTo$avail_json(@NotNull JSONWriter writer) throws JSONIOException {
                Intrinsics.checkNotNullParameter(writer, "writer");
                writer.privateWrite$avail_json(',');
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"Lorg/availlang/json/JSONWriter$Companion;", "", "()V", "newPrettyPrinterWriter", "Lorg/availlang/json/JSONWriter;", "newWriter", "avail-json"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JSONWriter newWriter() {
            return new JSONWriter(new StringWriter(), false, 2, null);
        }

        @NotNull
        public final JSONWriter newPrettyPrinterWriter() {
            return new JSONWriter(null, true, 1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

