/*
 * Decompiled with CFR 0.152.
 */
package avail.anvil.debugger;

import avail.AvailDebuggerModel;
import avail.AvailRuntime;
import avail.AvailRuntimeSupport;
import avail.anvil.AdaptiveColor;
import avail.anvil.AvailWorkbench;
import avail.anvil.MenuBarBuilder;
import avail.anvil.MenuBuilder;
import avail.anvil.StyleApplicator;
import avail.anvil.SwingHelperKt;
import avail.anvil.actions.FindAction;
import avail.anvil.debugger.AbstractDebuggerAction;
import avail.anvil.debugger.AvailDebugger;
import avail.anvil.debugger.AvailDebuggerKt;
import avail.anvil.text.CodePane;
import avail.builder.ModuleName;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.bundles.A_Bundle;
import avail.descriptor.character.A_Character;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.fiber.FiberDescriptor;
import avail.descriptor.functions.A_Continuation;
import avail.descriptor.functions.A_Function;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.module.A_Module;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.VariableTypeDescriptor;
import avail.error.ErrorCode;
import avail.interpreter.levelOne.L1Disassembler;
import avail.persistence.cache.Repository;
import avail.resolver.ResolverReference;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00f6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\b\u0004\n\u0002\b\u0004\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b*\n\u0006&),/4BFJN\u0018\u00002\u00020\u0001:\u0005nopqrB\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020\r2$\u0010Z\u001a \u0012\u0004\u0012\u00020\u0012\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001f0\u001e\u0012\u0004\u0012\u00020X0[H\u0002J\u001a\u0010\\\u001a\u00020X2\u0012\u0010]\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0_0^J\u0018\u0010`\u001a\u00020X2\u0006\u0010a\u001a\u00020\u00142\u0006\u0010b\u001a\u00020cH\u0002J\u0006\u0010d\u001a\u00020XJ\b\u0010e\u001a\u00020XH\u0002J6\u0010f\u001a\u00020X2\u0006\u0010g\u001a\u00020\u000f2$\u0010Z\u001a \u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020X0hH\u0002J\b\u0010i\u001a\u00020XH\u0002J\b\u0010j\u001a\u00020XH\u0002J\b\u0010k\u001a\u00020XH\u0002J\b\u0010l\u001a\u00020XH\u0002J\b\u0010m\u001a\u00020XH\u0002R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\u00150\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u00af\u0001\u0010\u001a\u001a\u00a2\u0001\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\r0\r\u0012<\u0012:\u0012\u0004\u0012\u00020\u0012\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001f0\u001e \u001c*\u001c\u0012\u0004\u0012\u00020\u0012\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001f0\u001e\u0018\u00010\u001d0\u001d \u001c*P\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\r0\r\u0012<\u0012:\u0012\u0004\u0012\u00020\u0012\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001f0\u001e \u001c*\u001c\u0012\u0004\u0012\u00020\u0012\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001f0\u001e\u0018\u00010\u001d0\u001d\u0018\u00010\u001e0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\"\u001a\u0010\u0012\f\u0012\n \u001c*\u0004\u0018\u00010$0$0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010'R\u0010\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010*R\u0010\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010-R\u0010\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00100R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00105R\u000e\u00106\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00107\u001a\u000208\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u000e\u0010;\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R^\u0010<\u001aR\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u000f0\u000f\u0012\u0014\u0012\u0012 \u001c*\b\u0018\u00010=R\u00020\u00000=R\u00020\u0000 \u001c*(\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u000f0\u000f\u0012\u0014\u0012\u0012 \u001c*\b\u0018\u00010=R\u00020\u00000=R\u00020\u0000\u0018\u00010\u001e0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010?\u001a\u0010\u0012\f\u0012\n \u001c*\u0004\u0018\u00010@0@0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010A\u001a\u00020BX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010CR\u000e\u0010D\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010E\u001a\u00020FX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010GR\u000e\u0010H\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010I\u001a\u00020JX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010KR\u000e\u0010L\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010M\u001a\u00020NX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010OR\u000e\u0010P\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010Q\u001a\u00020RX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010S\u001a\u0010\u0012\f\u0012\n \u001c*\u0004\u0018\u00010T0T0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010V\u00a8\u0006s"}, d2={"Lavail/anvil/debugger/AvailDebugger;", "Ljavax/swing/JFrame;", "workbench", "Lavail/anvil/AvailWorkbench;", "(Lavail/anvil/AvailWorkbench;)V", "captureAction", "avail/anvil/debugger/AvailDebugger$captureAction$1", "Lavail/anvil/debugger/AvailDebugger$captureAction$1;", "captureButton", "Ljavax/swing/JCheckBox;", "codeHighlightPainter", "Ljavax/swing/text/DefaultHighlighter$DefaultHighlightPainter;", "currentCode", "Lavail/descriptor/functions/A_RawFunction;", "currentModule", "Lavail/descriptor/module/A_Module;", "currentSourceAndLineEndsAndStyling", "Lkotlin/Triple;", "", "", "", "Lavail/persistence/cache/Repository$StylingRecord;", "debuggerModel", "Lavail/AvailDebuggerModel;", "getDebuggerModel", "()Lavail/AvailDebuggerModel;", "disassemblyCache", "", "kotlin.jvm.PlatformType", "Lkotlin/Pair;", "", "Lkotlin/ranges/IntRange;", "disassemblyPane", "Lavail/anvil/text/CodePane;", "fiberListPane", "Ljavax/swing/JList;", "Lavail/descriptor/fiber/A_Fiber;", "inspectFrame", "avail/anvil/debugger/AvailDebugger$inspectFrame$1", "Lavail/anvil/debugger/AvailDebugger$inspectFrame$1;", "inspectVariable", "avail/anvil/debugger/AvailDebugger$inspectVariable$1", "Lavail/anvil/debugger/AvailDebugger$inspectVariable$1;", "paneVersionTracker", "avail/anvil/debugger/AvailDebugger$paneVersionTracker$1", "Lavail/anvil/debugger/AvailDebugger$paneVersionTracker$1;", "restartAction", "avail/anvil/debugger/AvailDebugger$restartAction$1", "Lavail/anvil/debugger/AvailDebugger$restartAction$1;", "restartButton", "Ljavax/swing/JButton;", "resumeAction", "avail/anvil/debugger/AvailDebugger$resumeAction$1", "Lavail/anvil/debugger/AvailDebugger$resumeAction$1;", "resumeButton", "runtime", "Lavail/AvailRuntime;", "getRuntime", "()Lavail/AvailRuntime;", "secondaryCodeHighlightPainter", "sourceCache", "Lavail/anvil/debugger/AvailDebugger$SourceCodeInfo;", "sourcePane", "stackListPane", "Lavail/descriptor/functions/A_Continuation;", "stepIntoAction", "avail/anvil/debugger/AvailDebugger$stepIntoAction$1", "Lavail/anvil/debugger/AvailDebugger$stepIntoAction$1;", "stepIntoButton", "stepOutAction", "avail/anvil/debugger/AvailDebugger$stepOutAction$1", "Lavail/anvil/debugger/AvailDebugger$stepOutAction$1;", "stepOutButton", "stepOverAction", "avail/anvil/debugger/AvailDebugger$stepOverAction$1", "Lavail/anvil/debugger/AvailDebugger$stepOverAction$1;", "stepOverButton", "stepToLineAction", "avail/anvil/debugger/AvailDebugger$stepToLineAction$1", "Lavail/anvil/debugger/AvailDebugger$stepToLineAction$1;", "stepToLineButton", "variableValuePane", "Ljavax/swing/JTextArea;", "variablesPane", "Lavail/anvil/debugger/AvailDebugger$Variable;", "getWorkbench", "()Lavail/anvil/AvailWorkbench;", "disassembledWithMapThen", "", "code", "then", "Lkotlin/Function2;", "gatherFibers", "fibersProvider", "Lkotlin/Function0;", "", "highlightSourceLine", "lineNumber", "isTopFrame", "", "open", "releaseAllFibers", "sourceWithLineEndsAndStylingThen", "module", "Lkotlin/Function3;", "updateDisassemblyAndSourcePanes", "updateFiberList", "updateStackList", "updateVariableValuePane", "updateVariablesList", "FiberRenderer", "FrameRenderer", "SourceCodeInfo", "Variable", "VariablesRenderer", "avail"})
public final class AvailDebugger
extends JFrame {
    @NotNull
    private final AvailWorkbench workbench;
    @NotNull
    private final AvailDebuggerModel debuggerModel;
    @NotNull
    private final AvailRuntime runtime;
    @NotNull
    private final inspectFrame.1 inspectFrame;
    private final Map<A_RawFunction, Pair<String, Map<Integer, IntRange>>> disassemblyCache;
    private final Map<A_Module, SourceCodeInfo> sourceCache;
    @NotNull
    private DefaultHighlighter.DefaultHighlightPainter codeHighlightPainter;
    @NotNull
    private DefaultHighlighter.DefaultHighlightPainter secondaryCodeHighlightPainter;
    @NotNull
    private final stepIntoAction.1 stepIntoAction;
    @NotNull
    private final stepOverAction.1 stepOverAction;
    @NotNull
    private final stepOutAction.1 stepOutAction;
    @NotNull
    private final stepToLineAction.1 stepToLineAction;
    @NotNull
    private final resumeAction.1 resumeAction;
    @NotNull
    private final restartAction.1 restartAction;
    @NotNull
    private final captureAction.1 captureAction;
    @NotNull
    private final inspectVariable.1 inspectVariable;
    @NotNull
    private final JList<A_Fiber> fiberListPane;
    @NotNull
    private final JList<A_Continuation> stackListPane;
    @NotNull
    private final JButton stepIntoButton;
    @NotNull
    private final JButton stepOverButton;
    @NotNull
    private final JButton stepOutButton;
    @NotNull
    private final JButton stepToLineButton;
    @NotNull
    private final JButton resumeButton;
    @NotNull
    private final JButton restartButton;
    @NotNull
    private final JCheckBox captureButton;
    @NotNull
    private final CodePane disassemblyPane;
    @NotNull
    private final CodePane sourcePane;
    @NotNull
    private final JList<Variable> variablesPane;
    @NotNull
    private final JTextArea variableValuePane;
    @NotNull
    private A_RawFunction currentCode;
    @NotNull
    private A_Module currentModule;
    @NotNull
    private Triple<String, ? extends List<Integer>, Repository.StylingRecord> currentSourceAndLineEndsAndStyling;
    @NotNull
    private final paneVersionTracker.1 paneVersionTracker;

    /*
     * WARNING - void declaration
     */
    public AvailDebugger(@NotNull AvailWorkbench workbench) {
        void $this$_init__u24lambda_u2d23;
        JMenuBar jMenuBar;
        void $this$variableValuePane_u24lambda_u2d10;
        Serializable $this$variablesPane_u24lambda_u2d9;
        Serializable $this$sourcePane_u24lambda_u2d7;
        Serializable $this$disassemblyPane_u24lambda_u2d6;
        Serializable $this$stackListPane_u24lambda_u2d4;
        Serializable $this$fiberListPane_u24lambda_u2d2;
        Intrinsics.checkNotNullParameter((Object)workbench, (String)"workbench");
        super("Avail Debugger");
        this.workbench = workbench;
        this.debuggerModel = new AvailDebuggerModel(this.workbench.getRuntime());
        this.runtime = this.debuggerModel.getRuntime();
        this.inspectFrame = new AbstractDebuggerAction(this){
            final /* synthetic */ AvailDebugger this$0;
            {
                this.this$0 = $receiver;
                super($receiver, "Inspect", null, 4, null);
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    A_Continuation a_Continuation = (A_Continuation)AvailDebugger.access$getStackListPane$p(this.this$0).getSelectedValue();
                    if (a_Continuation == null) break block0;
                    A_Continuation it = a_Continuation;
                    boolean bl = false;
                    AvailDebuggerKt.inspect(A_Continuation.Companion.function(it).code().toString(), (AvailObject)it);
                }
            }
        };
        this.disassemblyCache = Collections.synchronizedMap(new LinkedHashMap());
        this.sourceCache = Collections.synchronizedMap(new LinkedHashMap());
        this.codeHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.BLACK);
        this.secondaryCodeHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.BLACK);
        Serializable serializable = KeyStroke.getKeyStroke(118, 0);
        this.stepIntoAction = new AbstractDebuggerAction(this, (KeyStroke)serializable){
            final /* synthetic */ AvailDebugger this$0;
            {
                this.this$0 = $receiver;
                super($receiver, "Into (F7)", $super_call_param$1);
                this.putValue("ShortDescription", "Step one instruction, or into a call.");
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.getRuntime().whenSafePointDo(80, (Function0<Unit>)((Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ AvailDebugger this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        void $this$safeWrite$iv;
                        ReentrantReadWriteLock reentrantReadWriteLock = this.this$0.getRuntime().getRuntimeLock();
                        AvailDebugger availDebugger = this.this$0;
                        boolean $i$f$safeWrite = false;
                        ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
                        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"this.writeLock()");
                        Lock lock = writeLock;
                        lock.lock();
                        try {
                            A_Fiber a_Fiber;
                            boolean bl = false;
                            A_Fiber a_Fiber2 = a_Fiber = (A_Fiber)AvailDebugger.access$getFiberListPane$p(availDebugger).getSelectedValue();
                            if (a_Fiber2 != null) {
                                Intrinsics.checkNotNullExpressionValue((Object)a_Fiber2, (String)"selectedValue");
                                A_Fiber fiber2 = a_Fiber;
                                boolean bl2 = false;
                                if (A_Fiber.Companion.getExecutionState(fiber2) == FiberDescriptor.ExecutionState.PAUSED) {
                                    availDebugger.getDebuggerModel().singleStep(fiber2);
                                }
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                }));
            }
        };
        serializable = KeyStroke.getKeyStroke(119, 0);
        this.stepOverAction = new AbstractDebuggerAction(this, (KeyStroke)serializable){
            final /* synthetic */ AvailDebugger this$0;
            {
                this.this$0 = $receiver;
                super($receiver, "Over (F8)", $super_call_param$1);
                this.setEnabled(false);
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                JOptionPane.showMessageDialog(this.this$0, "\"Over\" is not implemented");
            }
        };
        serializable = KeyStroke.getKeyStroke(119, 64);
        this.stepOutAction = new AbstractDebuggerAction(this, (KeyStroke)serializable){
            final /* synthetic */ AvailDebugger this$0;
            {
                this.this$0 = $receiver;
                super($receiver, "Out (\u21e7F8)", $super_call_param$1);
                this.setEnabled(false);
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                JOptionPane.showMessageDialog(this.this$0, "\"Out\" is not implemented");
            }
        };
        this.stepToLineAction = new AbstractDebuggerAction(this){
            final /* synthetic */ AvailDebugger this$0;
            {
                this.this$0 = $receiver;
                super($receiver, "To Line", null, 4, null);
                this.setEnabled(false);
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                JOptionPane.showMessageDialog(this.this$0, "\"To Line\" is not implemented");
            }
        };
        serializable = KeyStroke.getKeyStroke(82, AvailWorkbench.Companion.getMenuShortcutMask());
        this.resumeAction = new AbstractDebuggerAction(this, (KeyStroke)serializable){
            final /* synthetic */ AvailDebugger this$0;
            {
                this.this$0 = $receiver;
                super($receiver, "Resume (\u2318R)", $super_call_param$1);
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.getRuntime().whenSafePointDo(80, (Function0<Unit>)((Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ AvailDebugger this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        void $this$safeWrite$iv;
                        ReentrantReadWriteLock reentrantReadWriteLock = this.this$0.getRuntime().getRuntimeLock();
                        AvailDebugger availDebugger = this.this$0;
                        boolean $i$f$safeWrite = false;
                        ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
                        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"this.writeLock()");
                        Lock lock = writeLock;
                        lock.lock();
                        try {
                            A_Fiber a_Fiber;
                            boolean bl = false;
                            A_Fiber a_Fiber2 = a_Fiber = (A_Fiber)AvailDebugger.access$getFiberListPane$p(availDebugger).getSelectedValue();
                            if (a_Fiber2 != null) {
                                Intrinsics.checkNotNullExpressionValue((Object)a_Fiber2, (String)"selectedValue");
                                A_Fiber fiber2 = a_Fiber;
                                boolean bl2 = false;
                                availDebugger.getDebuggerModel().resume(fiber2);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                }));
            }
        };
        this.restartAction = new AbstractDebuggerAction(this){
            final /* synthetic */ AvailDebugger this$0;
            {
                this.this$0 = $receiver;
                super($receiver, "Restart", null, 4, null);
                this.setEnabled(false);
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                JOptionPane.showMessageDialog(this.this$0, "\"Restart\" is not implemented");
            }
        };
        this.captureAction = new AbstractDebuggerAction(this){
            final /* synthetic */ AvailDebugger this$0;
            {
                this.this$0 = $receiver;
                super($receiver, "Capture", null, 4, null);
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Object object = e.getSource();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.JCheckBox");
                JCheckBox checkBox = (JCheckBox)object;
                boolean install = checkBox.isSelected();
                boolean installed = this.this$0.getDebuggerModel().installFiberCapture(install);
                if (!installed) {
                    JOptionPane.showMessageDialog(this.this$0, "Could not " + (install ? "" : "un") + "install capture mode for this debugger", "Warning", 2);
                }
                checkBox.setSelected(this.this$0.getDebuggerModel().isCapturingNewFibers());
            }
        };
        this.inspectVariable = new AbstractDebuggerAction(this){
            final /* synthetic */ AvailDebugger this$0;
            {
                this.this$0 = $receiver;
                super($receiver, "Inspect", null, 4, null);
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Variable variable = (Variable)AvailDebugger.access$getVariablesPane$p(this.this$0).getSelectedValue();
                    if (variable == null) break block0;
                    Variable $this$actionPerformed_u24lambda_u2d0 = variable;
                    boolean bl = false;
                    AvailDebuggerKt.inspect($this$actionPerformed_u24lambda_u2d0.getName(), $this$actionPerformed_u24lambda_u2d0.getValue());
                }
            }
        };
        Serializable serializable2 = serializable = new JList<A_Fiber>(new A_Fiber[0]);
        AvailDebugger availDebugger = this;
        boolean bl = false;
        ((JList)$this$fiberListPane_u24lambda_u2d2).setCellRenderer(new FiberRenderer());
        ((JList)$this$fiberListPane_u24lambda_u2d2).setSelectionMode(0);
        ((JList)$this$fiberListPane_u24lambda_u2d2).getSelectionModel().addListSelectionListener(arg_0 -> AvailDebugger.fiberListPane$lambda-2$lambda-1(this, arg_0));
        availDebugger.fiberListPane = serializable;
        $this$fiberListPane_u24lambda_u2d2 = serializable = new JList<A_Continuation>(new A_Continuation[0]);
        availDebugger = this;
        boolean bl2 = false;
        ((JList)$this$stackListPane_u24lambda_u2d4).setCellRenderer(new FrameRenderer());
        ((JList)$this$stackListPane_u24lambda_u2d4).setSelectionMode(0);
        ((JList)$this$stackListPane_u24lambda_u2d4).getSelectionModel().addListSelectionListener(arg_0 -> AvailDebugger.stackListPane$lambda-4$lambda-3(this, arg_0));
        availDebugger.stackListPane = serializable;
        this.stepIntoButton = new JButton(this.stepIntoAction);
        this.stepOverButton = new JButton(this.stepOverAction);
        this.stepOutButton = new JButton(this.stepOutAction);
        this.stepToLineButton = new JButton(this.stepToLineAction);
        this.resumeButton = new JButton(this.resumeAction);
        this.restartButton = new JButton(this.restartAction);
        $this$stackListPane_u24lambda_u2d4 = serializable = new JCheckBox(this.captureAction);
        availDebugger = this;
        boolean bl3 = false;
        this.debuggerModel.isCapturingNewFibers();
        availDebugger.captureButton = serializable;
        Serializable it = serializable = new CodePane(this.workbench, null, 2, null);
        availDebugger = this;
        boolean bl4 = false;
        ((JTextComponent)$this$disassemblyPane_u24lambda_u2d6).setEditable(false);
        availDebugger.disassemblyPane = serializable;
        $this$disassemblyPane_u24lambda_u2d6 = serializable = new CodePane(this.workbench, null, 2, null);
        availDebugger = this;
        boolean bl5 = false;
        ((JTextComponent)$this$sourcePane_u24lambda_u2d7).setEditable(false);
        availDebugger.sourcePane = serializable;
        $this$sourcePane_u24lambda_u2d7 = serializable = new JList<Variable>(new Variable[0]);
        availDebugger = this;
        boolean bl6 = false;
        ((JList)$this$variablesPane_u24lambda_u2d9).setCellRenderer(new VariablesRenderer());
        ((JList)$this$variablesPane_u24lambda_u2d9).setSelectionMode(0);
        ((JList)$this$variablesPane_u24lambda_u2d9).getSelectionModel().addListSelectionListener(arg_0 -> AvailDebugger.variablesPane$lambda-9$lambda-8(this, arg_0));
        availDebugger.variablesPane = serializable;
        $this$variablesPane_u24lambda_u2d9 = serializable = new JTextArea();
        availDebugger = this;
        boolean bl7 = false;
        $this$variableValuePane_u24lambda_u2d10.setTabSize(2);
        availDebugger.variableValuePane = serializable;
        this.currentCode = NilDescriptor.Companion.getNil();
        this.currentModule = NilDescriptor.Companion.getNil();
        this.currentSourceAndLineEndsAndStyling = new Triple((Object)"", (Object)CollectionsKt.emptyList(), (Object)new Repository.StylingRecord(CollectionsKt.emptyList(), CollectionsKt.emptyList()));
        this.paneVersionTracker = new Object(){
            @NotNull
            private final AtomicLong allocator;
            private long renderedVersion;
            {
                this.allocator = new AtomicLong(0L);
                this.renderedVersion = -1L;
            }

            @NotNull
            public final AtomicLong getAllocator() {
                return this.allocator;
            }

            public final long getRenderedVersion() {
                return this.renderedVersion;
            }

            public final void setRenderedVersion(long l) {
                this.renderedVersion = l;
            }
        };
        MenuBarBuilder.Companion this_$iv = MenuBarBuilder.Companion;
        boolean $i$f$createMenuBar = false;
        JMenuBar it$iv = jMenuBar = new JMenuBar();
        boolean bl8 = false;
        MenuBarBuilder menuBarBuilder = new MenuBarBuilder(it$iv);
        availDebugger = this;
        boolean bl9 = false;
        $this$_init__u24lambda_u2d23.menu("Edit", (Function1<? super MenuBuilder, Unit>)((Function1)new Function1<MenuBuilder, Unit>(this){
            final /* synthetic */ AvailDebugger this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull MenuBuilder $this$menu) {
                Intrinsics.checkNotNullParameter((Object)$this$menu, (String)"$this$menu");
                $this$menu.item(new FindAction(this.this$0.getWorkbench(), this.this$0));
            }
        }));
        SwingHelperKt.addWindowMenu((MenuBarBuilder)$this$_init__u24lambda_u2d23, this);
        availDebugger.setJMenuBar(jMenuBar);
    }

    @NotNull
    public final AvailWorkbench getWorkbench() {
        return this.workbench;
    }

    @NotNull
    public final AvailDebuggerModel getDebuggerModel() {
        return this.debuggerModel;
    }

    @NotNull
    public final AvailRuntime getRuntime() {
        return this.runtime;
    }

    private final void disassembledWithMapThen(A_RawFunction code, Function2<? super String, ? super Map<Integer, IntRange>, Unit> then) {
        Pair<String, Map<Integer, IntRange>> pair = this.disassemblyCache.get(code);
        if (pair != null) {
            Pair<String, Map<Integer, IntRange>> it = pair;
            boolean bl = false;
            then.invoke(it.getFirst(), it.getSecond());
            return;
        }
        this.runtime.whenRunningInterpretersDo(80, (Function0<Unit>)((Function0)new Function0<Unit>(this, code, then){
            final /* synthetic */ AvailDebugger this$0;
            final /* synthetic */ A_RawFunction $code;
            final /* synthetic */ Function2<String, Map<Integer, IntRange>, Unit> $then;
            {
                this.this$0 = $receiver;
                this.$code = $code;
                this.$then = $then;
                super(0);
            }

            public final void invoke() {
                Map map = new LinkedHashMap<K, V>();
                Object object = this.$code;
                Object object2 = new StringBuilder();
                StringBuilder $this$invoke_u24lambda_u2d0 = object2;
                boolean bl = false;
                new L1Disassembler((A_RawFunction)object).printInstructions(new IdentityHashMap<A_BasicObject, Void>(10), 0, (Function3<? super Integer, ? super Integer, ? super String, Unit>)((Function3)new Function3<Integer, Integer, String, Unit>($this$invoke_u24lambda_u2d0, (Map<Integer, IntRange>)map){
                    final /* synthetic */ StringBuilder $this_buildString;
                    final /* synthetic */ Map<Integer, IntRange> $map;
                    {
                        this.$this_buildString = $receiver;
                        this.$map = $map;
                        super(3);
                    }

                    public final void invoke(int pc, int line, @NotNull String string2) {
                        Intrinsics.checkNotNullParameter((Object)string2, (String)"string");
                        int before = this.$this_buildString.length();
                        this.$this_buildString.append(pc + ". [:" + line + "] " + string2);
                        Integer n = pc;
                        this.$map.put(n, new IntRange(before, this.$this_buildString.length()));
                        this.$this_buildString.append("\n");
                    }
                }));
                int pcPastEnd = A_RawFunction.Companion.getNumNybbles((A_RawFunction)object) + 1;
                int returnStart = $this$invoke_u24lambda_u2d0.length();
                $this$invoke_u24lambda_u2d0.append("(" + pcPastEnd + ". return)");
                Integer n = pcPastEnd;
                map.put(n, new IntRange(returnStart, $this$invoke_u24lambda_u2d0.length()));
                $this$invoke_u24lambda_u2d0.append("\n");
                String string2 = ((StringBuilder)object2).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
                String string3 = string2;
                Map map2 = AvailDebugger.access$getDisassemblyCache$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"disassemblyCache");
                object = map2;
                object2 = this.$code;
                Pair pair = TuplesKt.to((Object)string3, (Object)map);
                object.put(object2, pair);
                this.$then.invoke((Object)string3, (Object)map);
            }
        }));
    }

    private final void sourceWithLineEndsAndStylingThen(A_Module module, Function3<? super String, ? super List<Integer>, ? super Repository.StylingRecord, Unit> then) {
        SourceCodeInfo info = this.sourceCache.computeIfAbsent(module, arg_0 -> SourceCodeInfo.new(this, arg_0));
        info.getSource().withValue((Function1<String, Unit>)((Function1)new Function1<String, Unit>(info, then){
            final /* synthetic */ SourceCodeInfo $info;
            final /* synthetic */ Function3<String, List<Integer>, Repository.StylingRecord, Unit> $then;
            {
                this.$info = $info;
                this.$then = $then;
                super(1);
            }

            public final void invoke(@NotNull String source2) {
                Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
                this.$info.getLineEnds().withValue((Function1<List<Integer>, Unit>)((Function1)new Function1<List<? extends Integer>, Unit>(this.$then, source2, this.$info){
                    final /* synthetic */ Function3<String, List<Integer>, Repository.StylingRecord, Unit> $then;
                    final /* synthetic */ String $source;
                    final /* synthetic */ SourceCodeInfo $info;
                    {
                        this.$then = $then;
                        this.$source = $source;
                        this.$info = $info;
                        super(1);
                    }

                    public final void invoke(@NotNull List<Integer> lineEnds2) {
                        Intrinsics.checkNotNullParameter(lineEnds2, (String)"lineEnds");
                        this.$then.invoke((Object)this.$source, lineEnds2, (Object)this.$info.getStylingRecord());
                    }
                }));
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateFiberList() {
        JList<A_Fiber> $this$updateFiberList_u24lambda_u2d11 = this.fiberListPane;
        boolean bl = false;
        A_Fiber oldFiber = $this$updateFiberList_u24lambda_u2d11.getSelectedValue();
        boolean changedFiber = false;
        boolean wasAdjusting = $this$updateFiberList_u24lambda_u2d11.getValueIsAdjusting();
        Collection $this$toTypedArray$iv = this.debuggerModel.getDebuggedFibers();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new A_Fiber[0]);
        Intrinsics.checkNotNull((Object)objectArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        Object[] newArray = objectArray;
        $this$updateFiberList_u24lambda_u2d11.setValueIsAdjusting(true);
        try {
            $this$updateFiberList_u24lambda_u2d11.setListData((A_Fiber[])newArray);
            int newIndex = ArraysKt.indexOf((Object[])newArray, (Object)oldFiber);
            if (newIndex == -1 && !(newArray.length == 0)) {
                newIndex = newArray.length - 1;
                changedFiber = true;
            }
            $this$updateFiberList_u24lambda_u2d11.setSelectedIndex(newIndex);
        }
        finally {
            $this$updateFiberList_u24lambda_u2d11.setValueIsAdjusting(wasAdjusting);
        }
        if (changedFiber) {
            this.updateStackList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateStackList() {
        A_Fiber fiber2 = this.fiberListPane.getSelectedValue();
        if (fiber2 == null) {
            boolean $i$f$emptyArray = false;
            this.stackListPane.setListData((A_Continuation[])((Object[])new A_Continuation[0]));
        } else {
            AvailObject frame = A_Fiber.Companion.getContinuation(fiber2).makeShared();
            List frames = new ArrayList();
            while (frame.getNotNil()) {
                frames.add(frame);
                A_Continuation a_Continuation = A_Continuation.Companion.caller(frame);
                Intrinsics.checkNotNull((Object)a_Continuation, (String)"null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
                frame = (AvailObject)a_Continuation;
            }
            this.stackListPane.setValueIsAdjusting(true);
            try {
                Collection $this$toTypedArray$iv = frames;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                A_Continuation[] a_ContinuationArray = thisCollection$iv.toArray(new A_Continuation[0]);
                Intrinsics.checkNotNull((Object)a_ContinuationArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                this.stackListPane.setListData((A_Continuation[])a_ContinuationArray);
                int[] nArray = new int[]{0};
                this.stackListPane.setSelectedIndices(nArray);
            }
            finally {
                this.stackListPane.setValueIsAdjusting(false);
            }
        }
    }

    private final void updateDisassemblyAndSourcePanes() {
        boolean isTopFrame = this.stackListPane.getSelectedIndex() == 0;
        A_Continuation frame = this.stackListPane.getSelectedValue();
        if (frame == null) {
            this.currentCode = NilDescriptor.Companion.getNil();
            this.disassemblyPane.getHighlighter().removeAllHighlights();
            this.disassemblyPane.setText("");
            this.sourcePane.getHighlighter().removeAllHighlights();
            this.sourcePane.setText("");
        } else {
            A_RawFunction code = A_Continuation.Companion.function(frame).code();
            this.disassembledWithMapThen(code, (Function2<? super String, ? super Map<Integer, IntRange>, Unit>)((Function2)new Function2<String, Map<Integer, ? extends IntRange>, Unit>(this, code, frame, isTopFrame){
                final /* synthetic */ AvailDebugger this$0;
                final /* synthetic */ A_RawFunction $code;
                final /* synthetic */ A_Continuation $frame;
                final /* synthetic */ boolean $isTopFrame;
                {
                    this.this$0 = $receiver;
                    this.$code = $code;
                    this.$frame = $frame;
                    this.$isTopFrame = $isTopFrame;
                    super(2);
                }

                public final void invoke(@NotNull String text, @NotNull Map<Integer, IntRange> map) {
                    Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                    Intrinsics.checkNotNullParameter(map, (String)"map");
                    SwingUtilities.invokeLater(() -> updateDisassemblyAndSourcePanes.1.invoke$lambda-2(this.this$0, this.$code, text, this.$frame, this.$isTopFrame, map));
                }

                private static final void invoke$lambda-2(AvailDebugger this$0, A_RawFunction $code, String $text, A_Continuation $frame, boolean $isTopFrame, Map $map) {
                    block8: {
                        int n;
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        Intrinsics.checkNotNullParameter((Object)$code, (String)"$code");
                        Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
                        Intrinsics.checkNotNullParameter((Object)$map, (String)"$map");
                        AvailDebugger.access$getDisassemblyPane$p(this$0).getHighlighter().removeAllHighlights();
                        if (!$code.equals(AvailDebugger.access$getCurrentCode$p(this$0))) {
                            AvailDebugger.access$setCurrentCode$p(this$0, $code);
                            AvailDebugger.access$getDisassemblyPane$p(this$0).setText($text);
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)$frame, (String)"frame");
                        int pc = A_Continuation.Companion.pc($frame);
                        if ($isTopFrame) {
                            n = A_Continuation.Companion.pc($frame);
                        } else {
                            Iterator<T> iterator2 = ((Iterable)$map.keySet()).iterator();
                            if (!iterator2.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            int it = ((Number)iterator2.next()).intValue();
                            boolean bl = false;
                            int n2 = it = it < pc ? it : Integer.MIN_VALUE;
                            while (iterator2.hasNext()) {
                                int it2 = ((Number)iterator2.next()).intValue();
                                $i$a$-maxOf-AvailDebugger$updateDisassemblyAndSourcePanes$1$1$highlightPc$1 = false;
                                int n3 = it2 < pc ? it2 : Integer.MIN_VALUE;
                                if (it >= n3) continue;
                                it = n3;
                            }
                            n = it;
                        }
                        int highlightPc = n;
                        IntRange intRange = (IntRange)$map.get(highlightPc);
                        if (intRange == null) break block8;
                        IntRange range = intRange;
                        boolean bl = false;
                        AvailDebugger.access$getDisassemblyPane$p(this$0).getHighlighter().addHighlight(range.getFirst(), range.getLast() + 1, $isTopFrame ? AvailDebugger.access$getCodeHighlightPainter$p(this$0) : AvailDebugger.access$getSecondaryCodeHighlightPainter$p(this$0));
                        try {
                            AvailDebugger.access$getDisassemblyPane$p(this$0).select(range.getFirst(), range.getLast() + 1);
                            SwingHelperKt.showTextRange(AvailDebugger.access$getDisassemblyPane$p(this$0), range.getFirst(), range.getLast() + 1);
                        }
                        catch (BadLocationException badLocationException) {
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                    }
                }
            }));
            A_Module module = A_RawFunction.Companion.getModule(code);
            if (!module.equals(this.currentModule)) {
                SwingUtilities.invokeLater(() -> AvailDebugger.updateDisassemblyAndSourcePanes$lambda-12(this));
                if (module.getNotNil()) {
                    this.sourceWithLineEndsAndStylingThen(module, (Function3<? super String, ? super List<Integer>, ? super Repository.StylingRecord, Unit>)((Function3)new Function3<String, List<? extends Integer>, Repository.StylingRecord, Unit>(this, frame, isTopFrame){
                        final /* synthetic */ AvailDebugger this$0;
                        final /* synthetic */ A_Continuation $frame;
                        final /* synthetic */ boolean $isTopFrame;
                        {
                            this.this$0 = $receiver;
                            this.$frame = $frame;
                            this.$isTopFrame = $isTopFrame;
                            super(3);
                        }

                        public final void invoke(@NotNull String source2, @NotNull List<Integer> lineEnds2, @NotNull Repository.StylingRecord stylingRecord) {
                            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
                            Intrinsics.checkNotNullParameter(lineEnds2, (String)"lineEnds");
                            Intrinsics.checkNotNullParameter((Object)stylingRecord, (String)"stylingRecord");
                            AvailDebugger.access$setCurrentSourceAndLineEndsAndStyling$p(this.this$0, new Triple((Object)source2, lineEnds2, (Object)stylingRecord));
                            SwingUtilities.invokeLater(() -> updateDisassemblyAndSourcePanes.3.invoke$lambda-1(this.this$0, source2, stylingRecord, this.$frame, this.$isTopFrame));
                        }

                        private static final void invoke$lambda-1$lambda-0(AvailDebugger this$0, A_Continuation $frame, boolean $isTopFrame) {
                            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                            Intrinsics.checkNotNullExpressionValue((Object)$frame, (String)"frame");
                            AvailDebugger.access$highlightSourceLine(this$0, A_Continuation.Companion.currentLineNumber($frame, $isTopFrame), $isTopFrame);
                        }

                        private static final void invoke$lambda-1(AvailDebugger this$0, String $source, Repository.StylingRecord $stylingRecord, A_Continuation $frame, boolean $isTopFrame) {
                            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                            Intrinsics.checkNotNullParameter((Object)$source, (String)"$source");
                            Intrinsics.checkNotNullParameter((Object)$stylingRecord, (String)"$stylingRecord");
                            StyledDocument doc = AvailDebugger.access$getSourcePane$p(this$0).getStyledDocument();
                            doc.remove(0, doc.getLength());
                            doc.insertString(0, $source, null);
                            Intrinsics.checkNotNullExpressionValue((Object)doc, (String)"doc");
                            StyleApplicator.applyStyleRuns$default(StyleApplicator.INSTANCE, doc, $stylingRecord.getStyleRuns(), false, 2, null);
                            SwingUtilities.invokeLater(() -> updateDisassemblyAndSourcePanes.3.invoke$lambda-1$lambda-0(this$0, $frame, $isTopFrame));
                        }
                    }));
                }
            } else {
                this.highlightSourceLine(A_Continuation.Companion.currentLineNumber(frame, isTopFrame), isTopFrame);
            }
        }
    }

    private final void highlightSourceLine(int lineNumber, boolean isTopFrame) {
        Triple<String, ? extends List<Integer>, Repository.StylingRecord> triple = this.currentSourceAndLineEndsAndStyling;
        String source2 = (String)triple.component1();
        List lineEnds2 = (List)triple.component2();
        if (lineNumber == 0) {
            return;
        }
        int rangeStart = lineNumber <= 1 ? 0 : (lineNumber <= lineEnds2.size() + 1 ? ((Number)lineEnds2.get(lineNumber - 2)).intValue() + 1 : source2.length() - 1);
        int rangeEnd = lineEnds2.isEmpty() ? source2.length() : (lineNumber <= 1 ? ((Number)lineEnds2.get(0)).intValue() : (lineNumber <= lineEnds2.size() ? ((Number)lineEnds2.get(lineNumber - 1)).intValue() : source2.length()));
        this.sourcePane.getHighlighter().addHighlight(rangeStart, rangeEnd + 1, isTopFrame ? this.codeHighlightPainter : this.secondaryCodeHighlightPainter);
        this.sourcePane.select(rangeStart, rangeEnd);
        SwingHelperKt.showTextRange(this.sourcePane, rangeStart, rangeEnd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void updateVariablesList() {
        Variable variable = this.variablesPane.getSelectedValue();
        String oldName = variable != null ? variable.getName() : null;
        List entries2 = new ArrayList();
        A_Continuation a_Continuation = this.stackListPane.getSelectedValue();
        if (a_Continuation != null) {
            int n;
            void $this$mapTo$iv$iv;
            A_Continuation frame = a_Continuation;
            boolean bl = false;
            A_Function function = A_Continuation.Companion.function(frame);
            A_RawFunction code = function.code();
            int numArgs = A_RawFunction.Companion.numArgs(code);
            int numLocals = A_RawFunction.Companion.getNumLocals(code);
            int numConstants = A_RawFunction.Companion.getNumConstants(code);
            int numOuters = A_RawFunction.Companion.getNumOuters(code);
            Iterable $this$map$iv = A_RawFunction.Companion.getDeclarationNames(code);
            int $i$f$map = 0;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                AvailObject availObject = (AvailObject)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(p0.asNativeString());
            }
            Iterator names = ((List)destination$iv$iv).iterator();
            int frameIndex = 0;
            frameIndex = 1;
            $i$f$map = 0;
            while ($i$f$map < numArgs) {
                int it = $i$f$map++;
                boolean bl3 = false;
                n = frameIndex;
                frameIndex = n + 1;
                entries2.add(new Variable("[arg] " + names.next(), A_Continuation.Companion.frameAt(frame, n)));
            }
            $i$f$map = 0;
            while ($i$f$map < numLocals) {
                int it = $i$f$map++;
                boolean bl4 = false;
                n = frameIndex;
                frameIndex = n + 1;
                entries2.add(new Variable("[local] " + names.next(), A_Continuation.Companion.frameAt(frame, n)));
            }
            $i$f$map = 0;
            while ($i$f$map < numConstants) {
                int it = $i$f$map++;
                boolean bl5 = false;
                n = frameIndex;
                frameIndex = n + 1;
                entries2.add(new Variable("[const] " + names.next(), A_Continuation.Companion.frameAt(frame, n)));
            }
            int i = 1;
            if (i <= numOuters) {
                while (true) {
                    entries2.add(new Variable("[outer] " + names.next(), function.outerVarAt(i)));
                    if (i == numOuters) break;
                    ++i;
                }
            }
            i = A_Continuation.Companion.numSlots(frame);
            int n2 = A_Continuation.Companion.stackp(frame);
            if (n2 <= i) {
                while (true) {
                    Object name2 = i == A_Continuation.Companion.stackp(frame) ? "stack top" : "stack [" + i + "]";
                    entries2.add(new Variable((String)name2, A_Continuation.Companion.frameAt(frame, i)));
                    if (i == n2) break;
                    --i;
                }
            }
        }
        this.variablesPane.setValueIsAdjusting(true);
        try {
            int[] nArray;
            int n;
            block16: {
                List $this$indexOfFirst$iv = entries2;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    Variable it = (Variable)item$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getName(), (Object)oldName)) {
                        n = index$iv;
                        break block16;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int index2 = n;
            Collection $this$toTypedArray$iv = entries2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Variable[] variableArray = thisCollection$iv.toArray(new Variable[0]);
            Intrinsics.checkNotNull((Object)variableArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            this.variablesPane.setListData((Variable[])variableArray);
            if (index2 == -1) {
                nArray = new int[]{};
            } else {
                int[] nArray2 = new int[]{index2};
                nArray = nArray2;
            }
            this.variablesPane.setSelectedIndices(nArray);
        }
        finally {
            this.variablesPane.setValueIsAdjusting(false);
        }
    }

    private final void updateVariableValuePane() {
        long id = this.paneVersionTracker.getAllocator().getAndIncrement();
        Variable variable = this.variablesPane.getSelectedValue();
        A_Atom valueToStringify = variable == null ? AtomDescriptor.Companion.getTrueObject() : (variable.getValue().isNil() ? AtomDescriptor.Companion.getTrueObject() : (A_Atom)variable.getValue());
        AvailRuntime.stringifyThen$default(this.runtime, valueToStringify, null, updateVariableValuePane.1.INSTANCE, (Function1)new Function1<String, Unit>(variable, id, this){
            final /* synthetic */ Variable $variable;
            final /* synthetic */ long $id;
            final /* synthetic */ AvailDebugger this$0;
            {
                this.$variable = $variable;
                this.$id = $id;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string2 = this.$variable == null ? "" : (this.$variable.getValue().isNil() ? "nil\n" : this.$variable.getValue().getTypeTag() + "\n\n" + it + "\n");
                SwingUtilities.invokeLater(() -> updateVariableValuePane.2.invoke$lambda-0(this.$id, this.this$0, string2));
            }

            private static final void invoke$lambda-0(long $id, AvailDebugger this$0, String $string) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$string, (String)"$string");
                if ($id > AvailDebugger.access$getPaneVersionTracker$p(this$0).getRenderedVersion()) {
                    AvailDebugger.access$getVariableValuePane$p(this$0).setText($string);
                    AvailDebugger.access$getPaneVersionTracker$p(this$0).setRenderedVersion($id);
                }
            }
        }, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void open() {
        void $this$open_u24lambda_u2d22;
        Object $this$open_u24lambda_u2d21;
        Object $this$open_u24lambda_u2d20;
        AvailDebugger $this$open_u24lambda_u2d19;
        AvailDebugger $this$open_u24lambda_u2d18;
        this.debuggerModel.getWhenPausedActions().add(new Function1<A_Fiber, Unit>(this){
            final /* synthetic */ AvailDebugger this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull A_Fiber it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it == AvailDebugger.access$getFiberListPane$p(this.this$0).getSelectedValue()) {
                    if (A_Fiber.Companion.getExecutionState(it).getIndicatesTermination()) {
                        AvailDebugger.access$updateFiberList(this.this$0);
                    } else {
                        AvailDebugger.access$updateStackList(this.this$0);
                    }
                }
                this.this$0.repaint();
            }
        });
        this.debuggerModel.getWhenAddedFiberActions().add(new Function1<A_Fiber, Unit>(this){
            final /* synthetic */ AvailDebugger this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull A_Fiber it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AvailDebugger.access$updateFiberList(this.this$0);
            }
        });
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ AvailDebugger this$0;
            {
                this.this$0 = $receiver;
            }

            public void windowClosing(@NotNull WindowEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                AvailDebugger.access$releaseAllFibers(this.this$0);
                if (this.this$0.getDebuggerModel().isCapturingNewFibers()) {
                    this.this$0.getDebuggerModel().installFiberCapture(false);
                }
            }
        });
        JPanel panel = new JPanel(new BorderLayout(20, 20));
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setBackground(panel.getBackground());
        Object object = new GroupLayout(panel);
        GroupLayout groupLayout = object;
        Container container = panel;
        boolean bl = false;
        int pref = -2;
        int max = Integer.MAX_VALUE;
        ((GroupLayout)((Object)$this$open_u24lambda_u2d18)).setAutoCreateGaps(true);
        ((GroupLayout)((Object)$this$open_u24lambda_u2d18)).setHorizontalGroup(((GroupLayout)((Object)$this$open_u24lambda_u2d18)).createParallelGroup().addGroup(((GroupLayout)((Object)$this$open_u24lambda_u2d18)).createSequentialGroup().addComponent(SwingHelperKt.scroll(this.fiberListPane), 100, 100, max).addComponent(SwingHelperKt.scroll(this.stackListPane), 200, 200, max)).addGroup(((GroupLayout)((Object)$this$open_u24lambda_u2d18)).createSequentialGroup().addComponent(this.stepIntoButton).addComponent(this.stepOverButton).addComponent(this.stepOutButton).addComponent(this.stepToLineButton).addComponent(this.resumeButton).addComponent(this.restartButton).addComponent(this.captureButton)).addGroup(((GroupLayout)((Object)$this$open_u24lambda_u2d18)).createSequentialGroup().addComponent(SwingHelperKt.scroll(this.disassemblyPane), 100, 100, max).addComponent(SwingHelperKt.scrollTextWithLineNumbers(this.sourcePane), 100, 100, max)).addGroup(((GroupLayout)((Object)$this$open_u24lambda_u2d18)).createSequentialGroup().addComponent(SwingHelperKt.scroll(this.variablesPane), 60, 60, max).addComponent(SwingHelperKt.scroll(this.variableValuePane), 100, 100, max)));
        ((GroupLayout)((Object)$this$open_u24lambda_u2d18)).setVerticalGroup(((GroupLayout)((Object)$this$open_u24lambda_u2d18)).createSequentialGroup().addGroup(((GroupLayout)((Object)$this$open_u24lambda_u2d18)).createParallelGroup().addComponent(SwingHelperKt.scroll(this.fiberListPane), 60, 60, max).addComponent(SwingHelperKt.scroll(this.stackListPane), 60, 60, max)).addGroup(((GroupLayout)((Object)$this$open_u24lambda_u2d18)).createParallelGroup().addComponent(this.stepIntoButton, pref, pref, pref).addComponent(this.stepOverButton, pref, pref, pref).addComponent(this.stepOutButton, pref, pref, pref).addComponent(this.stepToLineButton, pref, pref, pref).addComponent(this.resumeButton, pref, pref, pref).addComponent(this.restartButton, pref, pref, pref).addComponent(this.captureButton, pref, pref, pref)).addGroup(((GroupLayout)((Object)$this$open_u24lambda_u2d18)).createParallelGroup().addComponent(SwingHelperKt.scroll(this.disassemblyPane), 150, 150, max).addComponent(SwingHelperKt.scrollTextWithLineNumbers(this.sourcePane), 150, 150, max)).addGroup(((GroupLayout)((Object)$this$open_u24lambda_u2d18)).createParallelGroup().addComponent(SwingHelperKt.scroll(this.variablesPane), 80, 80, max).addComponent(SwingHelperKt.scroll(this.variableValuePane), 80, 80, max)));
        Component[] componentArray = new Component[]{this.stepIntoButton, this.stepOverButton, this.stepOutButton, this.stepToLineButton, this.resumeButton, this.restartButton};
        ((GroupLayout)((Object)$this$open_u24lambda_u2d18)).linkSize(0, componentArray);
        container.setLayout((LayoutManager)object);
        this.setMinimumSize(new Dimension(550, 350));
        this.setPreferredSize(new Dimension(1000, 1000));
        this.add(panel);
        this.pack();
        $this$open_u24lambda_u2d18 = this;
        container = this;
        boolean bl2 = false;
        Color selectionColor = $this$open_u24lambda_u2d19.disassemblyPane.getSelectionColor();
        Color color = selectionColor.darker();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"selectionColor.darker()");
        Color color2 = selectionColor.brighter();
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"selectionColor.brighter()");
        AdaptiveColor adaptiveColor = new AdaptiveColor(color, color2);
        Color color3 = $this$open_u24lambda_u2d19.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"background");
        AdaptiveColor currentLineColor = adaptiveColor.blend(color3, 0.2f);
        ((AvailDebugger)container).codeHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(currentLineColor.getColor());
        $this$open_u24lambda_u2d19 = this;
        container = this;
        boolean bl3 = false;
        Color color4 = ((AvailDebugger)$this$open_u24lambda_u2d20).codeHighlightPainter.getColor();
        Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"codeHighlightPainter.color");
        Color color5 = ((Window)$this$open_u24lambda_u2d20).getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color5, (String)"background");
        Color washedOut = AdaptiveColor.Companion.blend(color4, color5, 0.5f);
        ((AvailDebugger)container).secondaryCodeHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(washedOut);
        $this$open_u24lambda_u2d20 = object = new JPopupMenu("Stack");
        container = this.stackListPane;
        boolean bl4 = false;
        ((JPopupMenu)$this$open_u24lambda_u2d21).add(this.inspectFrame);
        ((JComponent)container).setComponentPopupMenu((JPopupMenu)object);
        $this$open_u24lambda_u2d21 = object = new JPopupMenu("Variable");
        container = this.variablesPane;
        boolean bl5 = false;
        $this$open_u24lambda_u2d22.add(this.inspectVariable);
        ((JComponent)container).setComponentPopupMenu((JPopupMenu)object);
        this.setVisible(true);
        this.updateFiberList();
    }

    public final void gatherFibers(@NotNull Function0<? extends Collection<? extends A_Fiber>> fibersProvider) {
        Intrinsics.checkNotNullParameter(fibersProvider, (String)"fibersProvider");
        Semaphore semaphore = new Semaphore(0);
        this.debuggerModel.gatherFibersThen(fibersProvider, (Function0<Unit>)((Function0)new Function0<Unit>(this, semaphore){
            final /* synthetic */ AvailDebugger this$0;
            final /* synthetic */ Semaphore $semaphore;
            {
                this.this$0 = $receiver;
                this.$semaphore = $semaphore;
                super(0);
            }

            public final void invoke() {
                AvailDebugger.access$getCaptureButton$p(this.this$0).setSelected(this.this$0.getDebuggerModel().isCapturingNewFibers());
                this.$semaphore.release();
            }
        }));
        semaphore.acquire();
    }

    private final void releaseAllFibers() {
        Semaphore semaphore = new Semaphore(0);
        this.debuggerModel.getWhenPausedActions().clear();
        this.debuggerModel.releaseFibersThen((Function0<Unit>)((Function0)new Function0<Unit>(semaphore){
            final /* synthetic */ Semaphore $semaphore;
            {
                this.$semaphore = $semaphore;
                super(0);
            }

            public final void invoke() {
                this.$semaphore.release();
            }
        }));
        semaphore.acquire();
    }

    private static final void fiberListPane$lambda-2$lambda-1(AvailDebugger this$0, ListSelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.updateStackList();
    }

    private static final void stackListPane$lambda-4$lambda-3(AvailDebugger this$0, ListSelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (!it.getValueIsAdjusting()) {
            this$0.updateDisassemblyAndSourcePanes();
            this$0.updateVariablesList();
        }
    }

    private static final void variablesPane$lambda-9$lambda-8(AvailDebugger this$0, ListSelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (!it.getValueIsAdjusting()) {
            this$0.updateVariableValuePane();
        }
    }

    private static final void updateDisassemblyAndSourcePanes$lambda-12(AvailDebugger this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.sourcePane.setText("Fetching source...");
    }

    public static final /* synthetic */ Map access$getDisassemblyCache$p(AvailDebugger $this) {
        return $this.disassemblyCache;
    }

    public static final /* synthetic */ CodePane access$getDisassemblyPane$p(AvailDebugger $this) {
        return $this.disassemblyPane;
    }

    public static final /* synthetic */ DefaultHighlighter.DefaultHighlightPainter access$getCodeHighlightPainter$p(AvailDebugger $this) {
        return $this.codeHighlightPainter;
    }

    public static final /* synthetic */ DefaultHighlighter.DefaultHighlightPainter access$getSecondaryCodeHighlightPainter$p(AvailDebugger $this) {
        return $this.secondaryCodeHighlightPainter;
    }

    public static final /* synthetic */ A_RawFunction access$getCurrentCode$p(AvailDebugger $this) {
        return $this.currentCode;
    }

    public static final /* synthetic */ void access$setCurrentCode$p(AvailDebugger $this, A_RawFunction a_RawFunction) {
        $this.currentCode = a_RawFunction;
    }

    public static final /* synthetic */ void access$setCurrentSourceAndLineEndsAndStyling$p(AvailDebugger $this, Triple triple) {
        $this.currentSourceAndLineEndsAndStyling = triple;
    }

    public static final /* synthetic */ void access$highlightSourceLine(AvailDebugger $this, int lineNumber, boolean isTopFrame) {
        $this.highlightSourceLine(lineNumber, isTopFrame);
    }

    public static final /* synthetic */ CodePane access$getSourcePane$p(AvailDebugger $this) {
        return $this.sourcePane;
    }

    public static final /* synthetic */ paneVersionTracker.1 access$getPaneVersionTracker$p(AvailDebugger $this) {
        return $this.paneVersionTracker;
    }

    public static final /* synthetic */ JTextArea access$getVariableValuePane$p(AvailDebugger $this) {
        return $this.variableValuePane;
    }

    public static final /* synthetic */ JList access$getFiberListPane$p(AvailDebugger $this) {
        return $this.fiberListPane;
    }

    public static final /* synthetic */ void access$updateFiberList(AvailDebugger $this) {
        $this.updateFiberList();
    }

    public static final /* synthetic */ void access$updateStackList(AvailDebugger $this) {
        $this.updateStackList();
    }

    public static final /* synthetic */ void access$releaseAllFibers(AvailDebugger $this) {
        $this.releaseAllFibers();
    }

    public static final /* synthetic */ JCheckBox access$getCaptureButton$p(AvailDebugger $this) {
        return $this.captureButton;
    }

    public static final /* synthetic */ JList access$getStackListPane$p(AvailDebugger $this) {
        return $this.stackListPane;
    }

    public static final /* synthetic */ JList access$getVariablesPane$p(AvailDebugger $this) {
        return $this.variablesPane;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lavail/anvil/debugger/AvailDebugger$FiberRenderer;", "Ljavax/swing/DefaultListCellRenderer;", "()V", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "fiber", "", "index", "", "isSelected", "", "cellHasFocus", "avail"})
    public static final class FiberRenderer
    extends DefaultListCellRenderer {
        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Component getListCellRendererComponent(@Nullable JList<?> list2, @Nullable Object fiber2, int index2, boolean isSelected, boolean cellHasFocus) {
            void $this$getListCellRendererComponent_u24lambda_u2d0;
            Intrinsics.checkNotNull((Object)fiber2, (String)"null cannot be cast to non-null type avail.descriptor.fiber.A_Fiber");
            A_Fiber a_Fiber = (A_Fiber)fiber2;
            JList<?> jList = list2;
            FiberRenderer fiberRenderer = this;
            boolean bl = false;
            String string2 = "[" + A_Fiber.Companion.getExecutionState((A_Fiber)$this$getListCellRendererComponent_u24lambda_u2d0) + "] " + A_Fiber.Companion.getFiberName((A_Fiber)$this$getListCellRendererComponent_u24lambda_u2d0).asNativeString();
            Component component = super.getListCellRendererComponent(jList, string2, index2, isSelected, cellHasFocus);
            Intrinsics.checkNotNullExpressionValue((Object)component, (String)"super.getListCellRendere\u2026elected,\n\t\t\tcellHasFocus)");
            return component;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lavail/anvil/debugger/AvailDebugger$FrameRenderer;", "Ljavax/swing/DefaultListCellRenderer;", "()V", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "frame", "", "index", "", "isSelected", "", "cellHasFocus", "avail"})
    public static final class FrameRenderer
    extends DefaultListCellRenderer {
        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Component getListCellRendererComponent(@Nullable JList<?> list2, @Nullable Object frame, int index2, boolean isSelected, boolean cellHasFocus) {
            void $this$getListCellRendererComponent_u24lambda_u2d0;
            Intrinsics.checkNotNull((Object)frame, (String)"null cannot be cast to non-null type avail.descriptor.functions.A_Continuation");
            A_Continuation a_Continuation = (A_Continuation)frame;
            JList<?> jList = list2;
            FrameRenderer frameRenderer = this;
            boolean bl = false;
            A_RawFunction code = A_Continuation.Companion.function((A_Continuation)$this$getListCellRendererComponent_u24lambda_u2d0).code();
            A_Module module = A_RawFunction.Companion.getModule(code);
            String string2 = "%s (%s:%d) pc=%d";
            Object[] objectArray = new Object[]{A_RawFunction.Companion.getMethodName(code).asNativeString(), module.isNil() ? "?" : A_Module.Companion.getModuleNameNative(module), A_Continuation.Companion.currentLineNumber((A_Continuation)frame, index2 == 0), A_Continuation.Companion.pc((A_Continuation)frame)};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            String string4 = string3;
            Component component = super.getListCellRendererComponent(jList, string4, index2, isSelected, cellHasFocus);
            Intrinsics.checkNotNullExpressionValue((Object)component, (String)"super.getListCellRendere\u2026elected,\n\t\t\tcellHasFocus)");
            return component;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\u001a\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0016\u001a\u00020\u0014H\u0002J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lavail/anvil/debugger/AvailDebugger$Variable;", "", "name", "", "value", "Lavail/descriptor/representation/AvailObject;", "(Ljava/lang/String;Lavail/descriptor/representation/AvailObject;)V", "getName", "()Ljava/lang/String;", "presentationString", "getPresentationString", "getValue", "()Lavail/descriptor/representation/AvailObject;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "stringIfSimple", "depth", "toString", "avail"})
    public static final class Variable {
        @NotNull
        private final String name;
        @NotNull
        private final AvailObject value;
        @NotNull
        private final String presentationString;

        public Variable(@NotNull String name2, @NotNull AvailObject value) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.name = name2;
            this.value = value;
            this.presentationString = this.name + " = " + Variable.stringIfSimple$default(this, this.value, 0, 2, null);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final AvailObject getValue() {
            return this.value;
        }

        @NotNull
        public final String getPresentationString() {
            return this.presentationString;
        }

        private final String stringIfSimple(AvailObject value, int depth) {
            return depth > 3 ? "***depth***" : (value.isNil() ? "nil" : (value.isString() ? value.toString() : (value.isInstanceOf(PrimitiveTypeDescriptor.Types.NUMBER.getO()) ? value.toString() : (value.isInstanceOf(PrimitiveTypeDescriptor.Types.MESSAGE_BUNDLE.getO()) ? A_Atom.Companion.getAtomName(A_Bundle.Companion.getMessage(value)).asNativeString() : (value.isInstanceOf(PrimitiveTypeDescriptor.Types.METHOD.getO()) ? value.toString() : (value.isAtom() ? value.toString() : (A_Character.Companion.isCharacter(value) ? value.toString() : (value.isInstanceOf(VariableTypeDescriptor.Companion.getMostGeneralVariableType()) ? "var(" + this.stringIfSimple(value.getValueForDebugger(), depth + 1) + ")" : (!value.isType() ? "(" + value.getTypeTag() + ")" : (value.isTop() ? value.toString() : (value.isBottom() ? value.toString() : (value.traversed().descriptor() instanceof PrimitiveTypeDescriptor ? value.toString() : (A_Number.Companion.equalsInt(A_Type.Companion.getInstanceCount(value), 1) ? this.stringIfSimple(A_Type.Companion.getInstance(value), depth + 1) + "'s type" : "(" + value.getTypeTag() + ")")))))))))))));
        }

        static /* synthetic */ String stringIfSimple$default(Variable variable, AvailObject availObject, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            return variable.stringIfSimple(availObject, n);
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final AvailObject component2() {
            return this.value;
        }

        @NotNull
        public final Variable copy(@NotNull String name2, @NotNull AvailObject value) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Variable(name2, value);
        }

        public static /* synthetic */ Variable copy$default(Variable variable, String string2, AvailObject availObject, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = variable.name;
            }
            if ((n & 2) != 0) {
                availObject = variable.value;
            }
            return variable.copy(string2, availObject);
        }

        @NotNull
        public String toString() {
            return "Variable(name=" + this.name + ", value=" + this.value + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + this.value.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Variable)) {
                return false;
            }
            Variable variable = (Variable)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)variable.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.value, (Object)variable.value);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lavail/anvil/debugger/AvailDebugger$VariablesRenderer;", "Ljavax/swing/DefaultListCellRenderer;", "()V", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "variable", "", "index", "", "isSelected", "", "cellHasFocus", "avail"})
    public static final class VariablesRenderer
    extends DefaultListCellRenderer {
        @Override
        @NotNull
        public Component getListCellRendererComponent(@Nullable JList<?> list2, @Nullable Object variable, int index2, boolean isSelected, boolean cellHasFocus) {
            Intrinsics.checkNotNull((Object)variable, (String)"null cannot be cast to non-null type avail.anvil.debugger.AvailDebugger.Variable");
            Component component = super.getListCellRendererComponent(list2, ((Variable)variable).getPresentationString(), index2, isSelected, cellHasFocus);
            Intrinsics.checkNotNullExpressionValue((Object)component, (String)"super.getListCellRendere\u2026elected,\n\t\t\tcellHasFocus)");
            return component;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001d\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\nR\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lavail/anvil/debugger/AvailDebugger$SourceCodeInfo;", "", "module", "Lavail/descriptor/module/A_Module;", "(Lavail/anvil/debugger/AvailDebugger;Lavail/descriptor/module/A_Module;)V", "lineEnds", "Lavail/AvailRuntimeSupport$AvailLazyFuture;", "", "", "getLineEnds", "()Lavail/AvailRuntimeSupport$AvailLazyFuture;", "getModule", "()Lavail/descriptor/module/A_Module;", "resolverReference", "Lavail/resolver/ResolverReference;", "getResolverReference", "()Lavail/resolver/ResolverReference;", "source", "", "getSource", "stylingRecord", "Lavail/persistence/cache/Repository$StylingRecord;", "getStylingRecord", "()Lavail/persistence/cache/Repository$StylingRecord;", "avail"})
    public final class SourceCodeInfo {
        @NotNull
        private final A_Module module;
        @NotNull
        private final ResolverReference resolverReference;
        @NotNull
        private final AvailRuntimeSupport.AvailLazyFuture<String> source;
        @NotNull
        private final AvailRuntimeSupport.AvailLazyFuture<List<Integer>> lineEnds;

        public SourceCodeInfo(A_Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            this.module = module;
            this.resolverReference = AvailDebugger.this.getRuntime().getModuleNameResolver().resolve(new ModuleName(A_Module.Companion.getModuleNameNative(this.module), false, 2, null), null).getResolverReference();
            this.source = new AvailRuntimeSupport.AvailLazyFuture(AvailDebugger.this.getRuntime(), 0, (Function1)new Function1<Function1<? super String, ? extends Unit>, Unit>(this){
                final /* synthetic */ SourceCodeInfo this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Function1<? super String, Unit> withSource) {
                    Intrinsics.checkNotNullParameter(withSource, (String)"withSource");
                    this.this$0.getResolverReference().readFileString(false, (Function2<? super String, ? super UUID, Unit>)((Function2)new Function2<String, UUID, Unit>(withSource){
                        final /* synthetic */ Function1<String, Unit> $withSource;
                        {
                            this.$withSource = $withSource;
                            super(2);
                        }

                        public final void invoke(@NotNull String string2, @Nullable UUID uUID) {
                            Intrinsics.checkNotNullParameter((Object)string2, (String)"string");
                            this.$withSource.invoke((Object)string2);
                        }
                    }), (Function2<? super ErrorCode, ? super Throwable, Unit>)((Function2)new Function2<ErrorCode, Throwable, Unit>(withSource){
                        final /* synthetic */ Function1<String, Unit> $withSource;
                        {
                            this.$withSource = $withSource;
                            super(2);
                        }

                        public final void invoke(@NotNull ErrorCode errorCode, @Nullable Throwable throwable) {
                            Intrinsics.checkNotNullParameter((Object)errorCode, (String)"errorCode");
                            this.$withSource.invoke((Object)("Cannot retrieve source: " + errorCode));
                        }
                    }));
                }
            }, 2, null);
            this.lineEnds = new AvailRuntimeSupport.AvailLazyFuture(AvailDebugger.this.getRuntime(), 0, (Function1)new Function1<Function1<? super List<? extends Integer>, ? extends Unit>, Unit>(this){
                final /* synthetic */ SourceCodeInfo this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Function1<? super List<Integer>, Unit> withLineEnds) {
                    Intrinsics.checkNotNullParameter(withLineEnds, (String)"withLineEnds");
                    this.this$0.getSource().withValue((Function1<String, Unit>)((Function1)new Function1<String, Unit>(withLineEnds){
                        final /* synthetic */ Function1<List<Integer>, Unit> $withLineEnds;
                        {
                            this.$withLineEnds = $withLineEnds;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull String string2) {
                            void $this$mapTo$iv$iv;
                            IndexedValue it;
                            Iterable $this$filterTo$iv$iv;
                            Intrinsics.checkNotNullParameter((Object)string2, (String)"string");
                            Iterable $this$filter$iv = StringsKt.withIndex((CharSequence)string2);
                            boolean $i$f$filter = false;
                            Iterable iterable = $this$filter$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$filterTo = false;
                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                it = (IndexedValue)element$iv$iv;
                                boolean bl = false;
                                if (!(((Character)it.getValue()).charValue() == '\n')) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            Iterable $this$map$iv = (List)destination$iv$iv;
                            boolean $i$f$map = false;
                            $this$filterTo$iv$iv = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                void p0;
                                it = (IndexedValue)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                collection.add(p0.getIndex());
                            }
                            List ends = (List)destination$iv$iv;
                            this.$withLineEnds.invoke((Object)ends);
                        }
                    }));
                }
            }, 2, null);
        }

        @NotNull
        public final A_Module getModule() {
            return this.module;
        }

        @NotNull
        public final ResolverReference getResolverReference() {
            return this.resolverReference;
        }

        @NotNull
        public final AvailRuntimeSupport.AvailLazyFuture<String> getSource() {
            return this.source;
        }

        @NotNull
        public final AvailRuntimeSupport.AvailLazyFuture<List<Integer>> getLineEnds() {
            return this.lineEnds;
        }

        @NotNull
        public final Repository.StylingRecord getStylingRecord() {
            return A_Module.Companion.stylingRecord(this.module);
        }
    }
}

