/*
 * Decompiled with CFR 0.152.
 */
package avail.anvil.text;

import avail.anvil.text.DotPosition;
import avail.anvil.text.MarkPosition;
import avail.anvil.text.MarkToDotRange;
import java.awt.Container;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0002\u001a\u0012\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\b\u001a\u0019\u0010\u000b\u001a\u0004\u0018\u00010\b*\u00020\t2\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\f\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u0002\u001a\u001c\u0010\u000f\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\b2\b\b\u0002\u0010\u0011\u001a\u00020\b\u001a\u0012\u0010\u0012\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\b\u001a\u0012\u0010\u0013\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\b\u001a\u0012\u0010\u0014\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\b\u001a\u0010\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0016*\u00020\u0002\u001a\n\u0010\u0017\u001a\u00020\u0018*\u00020\u0002\u001a\n\u0010\u0019\u001a\u00020\u001a*\u00020\u0002\u001a\u0012\u0010\u001b\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001a\u001a)\u0010\u001d\u001a\u00020\u0006*\u00020\u001e2\u0017\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00060 \u00a2\u0006\u0002\b!H\u0080\b\u00f8\u0001\u0000\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\""}, d2={"canEdit", "", "Ljavax/swing/text/JTextComponent;", "getCanEdit", "(Ljavax/swing/text/JTextComponent;)Z", "centerCurrentLine", "", "codePointAt", "", "Ljavax/swing/text/Document;", "position", "codePointOrNullAt", "(Ljavax/swing/text/Document;I)Ljava/lang/Integer;", "dotPosition", "Lavail/anvil/text/DotPosition;", "goTo", "line", "characterInLine", "indentationAt", "indentationBefore", "lineStartBefore", "lineStartsInSelection", "", "markPosition", "Lavail/anvil/text/MarkPosition;", "markToDotRange", "Lavail/anvil/text/MarkToDotRange;", "setCaretFrom", "range", "transaction", "Ljavax/swing/JTextPane;", "edit", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "avail"})
public final class TextKitsKt {
    public static final int codePointAt(@NotNull Document $this$codePointAt, int position) {
        Intrinsics.checkNotNullParameter((Object)$this$codePointAt, (String)"<this>");
        String string2 = $this$codePointAt.getText(position, 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(position, 1)");
        String string3 = string2;
        int n = 0;
        return string3.codePointAt(n);
    }

    @NotNull
    public static final DotPosition dotPosition(@NotNull JTextComponent $this$dotPosition) {
        Intrinsics.checkNotNullParameter((Object)$this$dotPosition, (String)"<this>");
        int offset = $this$dotPosition.getCaret().getDot();
        Element root = $this$dotPosition.getDocument().getDefaultRootElement();
        int line = root.getElementIndex(offset);
        Element element = root.getElement(line);
        return new DotPosition(line, offset - element.getStartOffset(), offset);
    }

    @NotNull
    public static final MarkPosition markPosition(@NotNull JTextComponent $this$markPosition) {
        Intrinsics.checkNotNullParameter((Object)$this$markPosition, (String)"<this>");
        int offset = $this$markPosition.getCaret().getMark();
        Element root = $this$markPosition.getDocument().getDefaultRootElement();
        int line = root.getElementIndex(offset);
        Element element = root.getElement(line);
        return new MarkPosition(line, offset - element.getStartOffset(), offset);
    }

    @NotNull
    public static final MarkToDotRange markToDotRange(@NotNull JTextComponent $this$markToDotRange) {
        Intrinsics.checkNotNullParameter((Object)$this$markToDotRange, (String)"<this>");
        return new MarkToDotRange(TextKitsKt.markPosition($this$markToDotRange), TextKitsKt.dotPosition($this$markToDotRange));
    }

    public static final void setCaretFrom(@NotNull JTextComponent $this$setCaretFrom, @NotNull MarkToDotRange range) {
        Caret caret;
        Intrinsics.checkNotNullParameter((Object)$this$setCaretFrom, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Caret $this$setCaretFrom_u24lambda_u2d0 = caret = $this$setCaretFrom.getCaret();
        boolean bl = false;
        $this$setCaretFrom_u24lambda_u2d0.setDot(range.getMarkPosition().getOffset());
        $this$setCaretFrom_u24lambda_u2d0.moveDot(range.getDotPosition().getOffset());
    }

    @Nullable
    public static final Integer codePointOrNullAt(@NotNull Document $this$codePointOrNullAt, int position) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$codePointOrNullAt, (String)"<this>");
        try {
            String string2 = $this$codePointOrNullAt.getText(position, 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(position, 1)");
            object = string2;
            int n = 0;
            object = ((String)object).codePointAt(n);
        }
        catch (BadLocationException e) {
            object = null;
        }
        return object;
    }

    public static final int lineStartBefore(@NotNull Document $this$lineStartBefore, int position) {
        int i;
        Intrinsics.checkNotNullParameter((Object)$this$lineStartBefore, (String)"<this>");
        for (i = position; i > 0; --i) {
            int c = TextKitsKt.codePointAt($this$lineStartBefore, i);
            if (c != 10) continue;
            ++i;
            break;
        }
        return i;
    }

    public static final int indentationAt(@NotNull Document $this$indentationAt, int position) {
        int c;
        int i;
        Intrinsics.checkNotNullParameter((Object)$this$indentationAt, (String)"<this>");
        for (i = position; i < $this$indentationAt.getLength() && (c = TextKitsKt.codePointAt($this$indentationAt, i)) == 9; ++i) {
        }
        return i - position;
    }

    public static final int indentationBefore(@NotNull Document $this$indentationBefore, int position) {
        Intrinsics.checkNotNullParameter((Object)$this$indentationBefore, (String)"<this>");
        return TextKitsKt.indentationAt($this$indentationBefore, TextKitsKt.lineStartBefore($this$indentationBefore, position));
    }

    public static final boolean getCanEdit(@NotNull JTextComponent $this$canEdit) {
        Intrinsics.checkNotNullParameter((Object)$this$canEdit, (String)"<this>");
        return $this$canEdit.isEnabled() && $this$canEdit.isEditable();
    }

    public static final void centerCurrentLine(@NotNull JTextComponent $this$centerCurrentLine) {
        JViewport viewport;
        Intrinsics.checkNotNullParameter((Object)$this$centerCurrentLine, (String)"<this>");
        Container container = SwingUtilities.getAncestorOfClass(JViewport.class, $this$centerCurrentLine);
        JViewport jViewport = viewport = container instanceof JViewport ? (JViewport)container : null;
        if (viewport == null) {
            return;
        }
        try {
            Rectangle2D bounds = $this$centerCurrentLine.modelToView2D($this$centerCurrentLine.getCaretPosition());
            double extentHeight = viewport.getExtentSize().height;
            double viewHeight = viewport.getViewSize().height;
            int y = (int)Math.min(Math.max(0.0, bounds.getY() - (extentHeight - bounds.getHeight()) / (double)2), viewHeight - extentHeight);
            viewport.setViewPosition(new Point(0, y));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public static final void goTo(@NotNull JTextComponent $this$goTo, int line, int characterInLine) {
        Intrinsics.checkNotNullParameter((Object)$this$goTo, (String)"<this>");
        Element root = $this$goTo.getDocument().getDefaultRootElement();
        int normalizedLine = Math.max(0, Math.min(line, root.getElementCount() - 1));
        Element element = root.getElement(normalizedLine);
        int lineStart = element.getStartOffset();
        int position = Math.max(Math.min(lineStart + characterInLine, element.getEndOffset() - 1), lineStart);
        $this$goTo.setCaretPosition(position);
        TextKitsKt.centerCurrentLine($this$goTo);
        $this$goTo.requestFocus();
    }

    public static /* synthetic */ void goTo$default(JTextComponent jTextComponent, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        TextKitsKt.goTo(jTextComponent, n, n2);
    }

    @NotNull
    public static final List<Integer> lineStartsInSelection(@NotNull JTextComponent $this$lineStartsInSelection) {
        Intrinsics.checkNotNullParameter((Object)$this$lineStartsInSelection, (String)"<this>");
        if ($this$lineStartsInSelection.getSelectionStart() == $this$lineStartsInSelection.getSelectionEnd()) {
            Document document2 = $this$lineStartsInSelection.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"document");
            return CollectionsKt.listOf((Object)TextKitsKt.lineStartBefore(document2, $this$lineStartsInSelection.getSelectionStart()));
        }
        Document document3 = $this$lineStartsInSelection.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document3, (String)"document");
        int firstLineStart = TextKitsKt.lineStartBefore(document3, $this$lineStartsInSelection.getSelectionStart());
        int lastLineStart = TextKitsKt.lineStartBefore(document3, $this$lineStartsInSelection.getSelectionEnd() - 1);
        Object[] objectArray = new Integer[]{firstLineStart};
        List insertionPoints = CollectionsKt.mutableListOf((Object[])objectArray);
        if (firstLineStart == lastLineStart) {
            return insertionPoints;
        }
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)(firstLineStart + 1), (int)(lastLineStart - 2));
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int position = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            int c = TextKitsKt.codePointAt(document3, position);
            if (c != 10) continue;
            insertionPoints.add(position + 1);
        }
        insertionPoints.add(lastLineStart);
        return insertionPoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void transaction(@NotNull JTextPane $this$transaction, @NotNull Function1<? super JTextPane, Unit> edit) {
        UndoManager undoManager;
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"<this>");
        Intrinsics.checkNotNullParameter(edit, (String)"edit");
        boolean $i$f$transaction = false;
        Object object = $this$transaction.getClientProperty("undoManager");
        UndoManager undoManager2 = undoManager = object instanceof UndoManager ? (UndoManager)object : null;
        if (undoManager == null) {
            edit.invoke((Object)$this$transaction);
        } else {
            CompoundEdit currentEdit;
            Object object2 = $this$transaction.getClientProperty("currentEdit");
            CompoundEdit compoundEdit = currentEdit = object2 instanceof CompoundEdit ? (CompoundEdit)object2 : null;
            if (compoundEdit != null) {
                compoundEdit.end();
            }
            CompoundEdit compoundEdit2 = new CompoundEdit();
            undoManager.addEdit(compoundEdit2);
            try {
                edit.invoke((Object)$this$transaction);
            }
            finally {
                InlineMarker.finallyStart((int)1);
                compoundEdit2.end();
                InlineMarker.finallyEnd((int)1);
            }
        }
    }
}

