/*
 * Decompiled with CFR 0.152.
 */
package avail.builder;

import avail.annotations.ThreadSafe;
import avail.builder.ModuleRoot;
import avail.builder.ModuleRoots;
import avail.error.ErrorCode;
import avail.files.FileManager;
import avail.persistence.cache.Repositories;
import avail.resolver.ModuleRootResolver;
import avail.resolver.ModuleRootResolverRegistry;
import avail.resolver.ResolverReference;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.StringsKt;
import org.availlang.json.JSONWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0018\u0010\u0007\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\u0010\u000bJ0\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t\u0012\u0004\u0012\u00020\n0\bJ\u0006\u0010\u001c\u001a\u00020\nJ\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u001eH\u0096\u0002J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001a\u001a\u00020\u0006J@\u0010 \u001a\u00020\n28\u0010!\u001a4\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\t\u0012\u001e\u0012\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020%\u0012\u0006\u0012\u0004\u0018\u00010&0$0\t\u0012\u0004\u0012\u00020\n0\"J*\u0010'\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t\u0012\u0004\u0012\u00020\n0\bH\u0002J\u000e\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\u0006J\u000e\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020\n2\u0006\u0010+\u001a\u00020,R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R,\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020\u0013j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0002`\u00148\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006."}, d2={"Lavail/builder/ModuleRoots;", "", "Lavail/builder/ModuleRoot;", "fileManager", "Lavail/files/FileManager;", "modulePath", "", "withFailures", "Lkotlin/Function1;", "", "", "(Lavail/files/FileManager;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getFileManager", "()Lavail/files/FileManager;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getModulePath", "()Ljava/lang/String;", "rootMap", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "roots", "", "getRoots", "()Ljava/util/Set;", "addRoot", "rootName", "location", "clearRoots", "iterator", "", "moduleRootFor", "moduleRootTreesThen", "withResults", "Lkotlin/Function2;", "Lavail/resolver/ResolverReference;", "Lkotlin/Triple;", "Lavail/error/ErrorCode;", "", "parseAvailModulePathThen", "removeRoot", "name", "writeOn", "writer", "Lorg/availlang/json/JSONWriter;", "writePathsOn", "avail"})
@ThreadSafe
public final class ModuleRoots
implements Iterable<ModuleRoot>,
KMappedMarker {
    @NotNull
    private final FileManager fileManager;
    @NotNull
    private final ReentrantLock lock;
    @GuardedBy(value="lock")
    @NotNull
    private final LinkedHashMap<String, ModuleRoot> rootMap;

    public ModuleRoots(@NotNull FileManager fileManager, @NotNull String modulePath2, @NotNull Function1<? super List<String>, Unit> withFailures) {
        Intrinsics.checkNotNullParameter((Object)fileManager, (String)"fileManager");
        Intrinsics.checkNotNullParameter((Object)modulePath2, (String)"modulePath");
        Intrinsics.checkNotNullParameter(withFailures, (String)"withFailures");
        this.fileManager = fileManager;
        this.lock = new ReentrantLock();
        this.rootMap = new LinkedHashMap();
        this.parseAvailModulePathThen(modulePath2, withFailures);
    }

    @NotNull
    public final FileManager getFileManager() {
        return this.fileManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String getModulePath() {
        String string2;
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            Collection<ModuleRoot> collection = this.rootMap.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"rootMap.values");
            string2 = CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)";", null, null, (int)0, null, (Function1)modulePath.1.1.INSTANCE, (int)30, null);
        }
        finally {
            lock.unlock();
        }
        return string2;
    }

    private final void parseAvailModulePathThen(String modulePath2, Function1<? super List<String>, Unit> withFailures) {
        List list2;
        this.clearRoots();
        if (((CharSequence)modulePath2).length() == 0) {
            list2 = CollectionsKt.emptyList();
        } else {
            String[] stringArray = new String[]{";"};
            list2 = StringsKt.split$default((CharSequence)modulePath2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        }
        List components = list2;
        AtomicInteger workCount = new AtomicInteger(components.size());
        List failures = new ArrayList();
        if (components.isEmpty()) {
            withFailures.invoke((Object)CollectionsKt.emptyList());
        } else {
            for (String component : components) {
                String[] stringArray;
                List binding = StringsKt.split$default((CharSequence)component, (String[])(stringArray = new String[]{"="}), (boolean)false, (int)0, (int)6, null);
                if (!(binding.size() == 2)) {
                    boolean $i$a$-require-ModuleRoots$parseAvailModulePathThen$22 = false;
                    String $i$a$-require-ModuleRoots$parseAvailModulePathThen$22 = "Bad module root location setting: " + component;
                    throw new IllegalArgumentException($i$a$-require-ModuleRoots$parseAvailModulePathThen$22.toString());
                }
                String rootName = (String)binding.get(0);
                String location = (String)binding.get(1);
                this.addRoot(rootName, location, (Function1<? super List<String>, Unit>)((Function1)new Function1<List<? extends String>, Unit>((List<String>)failures, workCount, withFailures){
                    final /* synthetic */ List<String> $failures;
                    final /* synthetic */ AtomicInteger $workCount;
                    final /* synthetic */ Function1<List<String>, Unit> $withFailures;
                    {
                        this.$failures = $failures;
                        this.$workCount = $workCount;
                        this.$withFailures = $withFailures;
                        super(1);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void invoke(@NotNull List<String> newFailures) {
                        Intrinsics.checkNotNullParameter(newFailures, (String)"newFailures");
                        if (!((Collection)newFailures).isEmpty()) {
                            List<String> list2 = this.$failures;
                            List<String> list3 = this.$failures;
                            List<String> list4 = list2;
                            synchronized (list4) {
                                boolean bl = false;
                                boolean bl2 = list3.addAll((Collection<String>)newFailures);
                            }
                        }
                        if (this.$workCount.decrementAndGet() == 0) {
                            this.$withFailures.invoke(this.$failures);
                        }
                    }
                }));
            }
        }
    }

    public final void addRoot(@NotNull String rootName, @NotNull String location, @NotNull Function1<? super List<String>, Unit> withFailures) {
        Intrinsics.checkNotNullParameter((Object)rootName, (String)"rootName");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter(withFailures, (String)"withFailures");
        if (((CharSequence)location).length() == 0) {
            List<CallSite> list2 = Collections.singletonList("Module root \"" + rootName + "\" is missing a source URI");
            Intrinsics.checkNotNullExpressionValue(list2, (String)"singletonList(\n\t\t\t\t\"Modu\u2026is missing a source URI\")");
            withFailures.invoke(list2);
            return;
        }
        URI rootUri = new URI(location);
        ModuleRootResolver resolver = ModuleRootResolverRegistry.INSTANCE.createResolver(rootName, rootUri, this.fileManager);
        resolver.resolve((Function1<? super ResolverReference, Unit>)((Function1)new Function1<ResolverReference, Unit>(this, withFailures, rootName, resolver){
            final /* synthetic */ ModuleRoots this$0;
            final /* synthetic */ Function1<List<String>, Unit> $withFailures;
            final /* synthetic */ String $rootName;
            final /* synthetic */ ModuleRootResolver $resolver;
            {
                this.this$0 = $receiver;
                this.$withFailures = $withFailures;
                this.$rootName = $rootName;
                this.$resolver = $resolver;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull ResolverReference it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Lock lock = ModuleRoots.access$getLock$p(this.this$0);
                ModuleRoots moduleRoots = this.this$0;
                String string2 = this.$rootName;
                ModuleRootResolver moduleRootResolver = this.$resolver;
                lock.lock();
                try {
                    boolean bl = false;
                    ((Map)ModuleRoots.access$getRootMap$p(moduleRoots)).put(string2, moduleRootResolver.getModuleRoot());
                    Repositories.INSTANCE.addRepository(moduleRootResolver.getModuleRoot());
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
                this.$withFailures.invoke((Object)CollectionsKt.emptyList());
            }
        }), (Function2<? super ErrorCode, ? super Throwable, Unit>)((Function2)new Function2<ErrorCode, Throwable, Unit>(rootName, rootUri, withFailures){
            final /* synthetic */ String $rootName;
            final /* synthetic */ URI $rootUri;
            final /* synthetic */ Function1<List<String>, Unit> $withFailures;
            {
                this.$rootName = $rootName;
                this.$rootUri = $rootUri;
                this.$withFailures = $withFailures;
                super(2);
            }

            public final void invoke(@NotNull ErrorCode code, @Nullable Throwable ex) {
                Intrinsics.checkNotNullParameter((Object)code, (String)"code");
                String message = code + ": Could not resolve module root " + this.$rootName + " (" + this.$rootUri + ")";
                System.err.println(message);
                Throwable throwable = ex;
                if (throwable != null) {
                    throwable.printStackTrace();
                }
                List<CallSite> list2 = Collections.singletonList(message);
                Intrinsics.checkNotNullExpressionValue(list2, (String)"singletonList(message)");
                this.$withFailures.invoke(list2);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeRoot(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Lock lock = this.lock;
        lock.lock();
        try {
            Unit unit;
            boolean bl = false;
            ModuleRoot moduleRoot = (ModuleRoot)this.rootMap.remove(name2);
            if (moduleRoot != null) {
                ModuleRoot it = moduleRoot;
                boolean bl2 = false;
                Repositories.INSTANCE.deleteRepository(name2);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearRoots() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            this.rootMap.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Set<ModuleRoot> getRoots() {
        Set set2;
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            Collection<ModuleRoot> collection = this.rootMap.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"rootMap.values");
            set2 = CollectionsKt.toSet((Iterable)collection);
        }
        finally {
            lock.unlock();
        }
        return set2;
    }

    @Override
    @NotNull
    public Iterator<ModuleRoot> iterator() {
        return this.getRoots().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final ModuleRoot moduleRootFor(@NotNull String rootName) {
        ModuleRoot moduleRoot;
        Intrinsics.checkNotNullParameter((Object)rootName, (String)"rootName");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            moduleRoot = this.rootMap.get(rootName);
        }
        finally {
            lock.unlock();
        }
        return moduleRoot;
    }

    public final void moduleRootTreesThen(@NotNull Function2<? super List<ResolverReference>, ? super List<? extends Triple<String, ? extends ErrorCode, ? extends Throwable>>, Unit> withResults) {
        Intrinsics.checkNotNullParameter(withResults, (String)"withResults");
        Set<ModuleRoot> rootsToAcquire = this.getRoots();
        AtomicInteger countdown = new AtomicInteger(rootsToAcquire.size());
        List<ResolverReference> references = Collections.synchronizedList(new ArrayList());
        List<Triple<String, ErrorCode, Throwable>> failures = Collections.synchronizedList(new ArrayList());
        Iterable $this$forEach$iv = rootsToAcquire;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModuleRoot mr = (ModuleRoot)element$iv;
            boolean bl = false;
            mr.getResolver().provideModuleRootTree((Function1<? super ResolverReference, Unit>)((Function1)new Function1<ResolverReference, Unit>(references, countdown, withResults, failures){
                final /* synthetic */ List<ResolverReference> $references;
                final /* synthetic */ AtomicInteger $countdown;
                final /* synthetic */ Function2<List<ResolverReference>, List<? extends Triple<String, ? extends ErrorCode, ? extends Throwable>>, Unit> $withResults;
                final /* synthetic */ List<Triple<String, ErrorCode, Throwable>> $failures;
                {
                    this.$references = $references;
                    this.$countdown = $countdown;
                    this.$withResults = $withResults;
                    this.$failures = $failures;
                    super(1);
                }

                public final void invoke(@NotNull ResolverReference it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$references.add(it);
                    if (this.$countdown.decrementAndGet() == 0) {
                        List<ResolverReference> list2 = this.$references;
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"references");
                        List<Triple<String, ErrorCode, Throwable>> list3 = this.$failures;
                        Intrinsics.checkNotNullExpressionValue(list3, (String)"failures");
                        this.$withResults.invoke(list2, list3);
                    }
                }
            }), (Function2<? super ErrorCode, ? super Throwable, Unit>)((Function2)new Function2<ErrorCode, Throwable, Unit>(failures, mr, countdown, withResults, references){
                final /* synthetic */ List<Triple<String, ErrorCode, Throwable>> $failures;
                final /* synthetic */ ModuleRoot $mr;
                final /* synthetic */ AtomicInteger $countdown;
                final /* synthetic */ Function2<List<ResolverReference>, List<? extends Triple<String, ? extends ErrorCode, ? extends Throwable>>, Unit> $withResults;
                final /* synthetic */ List<ResolverReference> $references;
                {
                    this.$failures = $failures;
                    this.$mr = $mr;
                    this.$countdown = $countdown;
                    this.$withResults = $withResults;
                    this.$references = $references;
                    super(2);
                }

                public final void invoke(@NotNull ErrorCode code, @Nullable Throwable ex) {
                    Intrinsics.checkNotNullParameter((Object)code, (String)"code");
                    this.$failures.add((Triple<String, ErrorCode, Throwable>)new Triple((Object)this.$mr.getName(), (Object)code, (Object)ex));
                    if (this.$countdown.decrementAndGet() == 0) {
                        List<ResolverReference> list2 = this.$references;
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"references");
                        List<Triple<String, ErrorCode, Throwable>> list3 = this.$failures;
                        Intrinsics.checkNotNullExpressionValue(list3, (String)"failures");
                        this.$withResults.invoke(list2, list3);
                    }
                }
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeOn(@NotNull JSONWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        JSONWriter this_$iv = writer;
        boolean $i$f$writeArray = false;
        this_$iv.startArray();
        try {
            JSONWriter $this$writeOn_u24lambda_u2d9 = this_$iv;
            boolean bl = false;
            Iterable $this$forEach$iv = this.getRoots();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ModuleRoot root = (ModuleRoot)element$iv;
                boolean bl2 = false;
                $this$writeOn_u24lambda_u2d9.write(root.getName());
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.endArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void writePathsOn(@NotNull JSONWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        JSONWriter this_$iv = writer;
        boolean $i$f$writeArray = false;
        this_$iv.startArray();
        try {
            JSONWriter $this$writePathsOn_u24lambda_u2d12 = this_$iv;
            boolean bl = false;
            Iterable $this$forEach$iv = this.getRoots();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void this_$iv2;
                ModuleRoot root = (ModuleRoot)element$iv;
                boolean bl2 = false;
                JSONWriter jSONWriter = $this$writePathsOn_u24lambda_u2d12;
                String key$iv = root.getName();
                boolean $i$f$at = false;
                this_$iv2.write(key$iv);
                void $this$writePathsOn_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d10 = this_$iv2;
                boolean bl3 = false;
                root.writePathsOn(writer);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.endArray();
        }
    }

    public static final /* synthetic */ ReentrantLock access$getLock$p(ModuleRoots $this) {
        return $this.lock;
    }

    public static final /* synthetic */ LinkedHashMap access$getRootMap$p(ModuleRoots $this) {
        return $this.rootMap;
    }
}

