/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo.operation;

import avail.descriptor.atoms.A_Atom;
import avail.descriptor.bundles.A_Bundle;
import avail.descriptor.functions.A_Function;
import avail.descriptor.methods.A_Definition;
import avail.descriptor.methods.A_Method;
import avail.descriptor.methods.A_Sendable;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.BottomTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.AvailException;
import avail.exceptions.MethodDefinitionException;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2NamedOperandType;
import avail.interpreter.levelTwo.L2OperandType;
import avail.interpreter.levelTwo.operand.L2PcOperand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedVectorOperand;
import avail.interpreter.levelTwo.operand.L2SelectorOperand;
import avail.interpreter.levelTwo.operand.L2WriteBoxedOperand;
import avail.interpreter.levelTwo.operation.L2ControlFlowOperation;
import avail.interpreter.levelTwo.register.L2Register;
import avail.optimizer.L2ValueManifest;
import avail.optimizer.jvm.CheckedMethod;
import avail.optimizer.jvm.JVMTranslator;
import avail.optimizer.jvm.ReferencedInGeneratedCode;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J+\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0007\u00a2\u0006\u0002\u0010\u001aJ \u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lavail/interpreter/levelTwo/operation/L2_LOOKUP_BY_TYPES;", "Lavail/interpreter/levelTwo/operation/L2ControlFlowOperation;", "()V", "failureCodesType", "Lavail/descriptor/types/A_Type;", "hasSideEffect", "", "getHasSideEffect", "()Z", "lookupMethod", "Lavail/optimizer/jvm/CheckedMethod;", "instructionWasAdded", "", "instruction", "Lavail/interpreter/levelTwo/L2Instruction;", "manifest", "Lavail/optimizer/L2ValueManifest;", "lookup", "Lavail/descriptor/functions/A_Function;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "bundle", "Lavail/descriptor/bundles/A_Bundle;", "types", "", "Lavail/descriptor/representation/AvailObject;", "(Lavail/interpreter/execution/Interpreter;Lavail/descriptor/bundles/A_Bundle;[Lavail/descriptor/representation/AvailObject;)Lavail/descriptor/functions/A_Function;", "translateToJVM", "translator", "Lavail/optimizer/jvm/JVMTranslator;", "method", "Lorg/objectweb/asm/MethodVisitor;", "avail"})
public final class L2_LOOKUP_BY_TYPES
extends L2ControlFlowOperation {
    @NotNull
    public static final L2_LOOKUP_BY_TYPES INSTANCE = new L2_LOOKUP_BY_TYPES();
    @NotNull
    private static final A_Type failureCodesType;
    @NotNull
    private static final CheckedMethod lookupMethod;

    private L2_LOOKUP_BY_TYPES() {
        L2NamedOperandType[] l2NamedOperandTypeArray = new L2NamedOperandType[]{L2OperandType.SELECTOR.named("message bundle"), L2OperandType.READ_BOXED_VECTOR.named("argument types"), L2OperandType.WRITE_BOXED.named("looked up function", L2NamedOperandType.Purpose.SUCCESS), L2OperandType.WRITE_BOXED.named("error code", L2NamedOperandType.Purpose.FAILURE), L2OperandType.PC.named("lookup succeeded", L2NamedOperandType.Purpose.SUCCESS), L2OperandType.PC.named("lookup failed", L2NamedOperandType.Purpose.FAILURE)};
        super(l2NamedOperandTypeArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void instructionWasAdded(@NotNull L2Instruction instruction2, @NotNull L2ValueManifest manifest2) {
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        Intrinsics.checkNotNullParameter((Object)manifest2, (String)"manifest");
        boolean bl = Intrinsics.areEqual((Object)this, (Object)instruction2.getOperation());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2ReadBoxedVectorOperand argTypeRegs = (L2ReadBoxedVectorOperand)instruction2.operand(1);
        L2WriteBoxedOperand functionReg = (L2WriteBoxedOperand)instruction2.operand(2);
        L2WriteBoxedOperand errorCodeReg = (L2WriteBoxedOperand)instruction2.operand(3);
        L2PcOperand lookupSucceeded = (L2PcOperand)instruction2.operand(4);
        L2PcOperand lookupFailed = (L2PcOperand)instruction2.operand(5);
        super.instructionWasAdded(instruction2, manifest2);
        lookupFailed.manifest().setRestriction(errorCodeReg.pickSemanticValue(), errorCodeReg.restriction());
        lookupSucceeded.manifest().setRestriction(functionReg.pickSemanticValue(), functionReg.restriction());
        List argumentTypeRegs = argTypeRegs.elements();
        A_Type functionType = functionReg.restriction().getType();
        if (functionType.isEnumeration()) {
            void $this$fold$iv;
            int numArgs = argumentTypeRegs.size();
            Set<AvailObject> functions = SetDescriptor.Companion.toSet(A_Type.Companion.getInstances(functionType));
            Iterable iterable = functions;
            A_Type initial$iv = BottomTypeDescriptor.Companion.getBottom();
            boolean $i$f$fold = false;
            A_Type accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void function;
                A_Function a_Function = (A_Function)element$iv;
                A_Type union = accumulator$iv;
                boolean bl2 = false;
                accumulator$iv = A_Type.Companion.typeUnion(union, A_Type.Companion.getArgsTupleType(function.code().functionType()));
            }
            A_Type argumentTupleUnionType = accumulator$iv;
            int i = 1;
            if (i <= numArgs) {
                while (true) {
                    A_Type argumentUnion = A_Type.Companion.typeAtIndex(argumentTupleUnionType, i);
                    lookupSucceeded.manifest().intersectType(((L2ReadBoxedOperand)argumentTypeRegs.get(i - 1)).semanticValue(), AbstractEnumerationTypeDescriptor.Companion.instanceTypeOrMetaOn(argumentUnion));
                    if (i == numArgs) break;
                    ++i;
                }
            }
        }
    }

    @Override
    public boolean getHasSideEffect() {
        return true;
    }

    @Override
    public void translateToJVM(@NotNull JVMTranslator translator, @NotNull MethodVisitor method, @NotNull L2Instruction instruction2) {
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        L2SelectorOperand bundleOperand = (L2SelectorOperand)instruction2.operand(0);
        L2ReadBoxedVectorOperand argTypeRegs = (L2ReadBoxedVectorOperand)instruction2.operand(1);
        L2WriteBoxedOperand functionReg = (L2WriteBoxedOperand)instruction2.operand(2);
        L2WriteBoxedOperand errorCodeReg = (L2WriteBoxedOperand)instruction2.operand(3);
        L2PcOperand lookupSucceeded = (L2PcOperand)instruction2.operand(4);
        L2PcOperand lookupFailed = (L2PcOperand)instruction2.operand(5);
        Label tryStart = new Label();
        Label catchStart = new Label();
        method.visitTryCatchBlock(tryStart, catchStart, catchStart, Type.getInternalName(MethodDefinitionException.class));
        method.visitLabel(tryStart);
        translator.loadInterpreter(method);
        translator.literal(method, bundleOperand.getBundle());
        translator.objectArray(method, argTypeRegs.elements(), AvailObject.class);
        lookupMethod.generateCall(method);
        translator.store(method, (L2Register)functionReg.register());
        translator.jump(method, lookupSucceeded);
        method.visitLabel(catchStart);
        AvailException.Companion.getNumericCodeMethod().generateCall(method);
        method.visitTypeInsn(192, Type.getInternalName(AvailObject.class));
        translator.store(method, (L2Register)errorCodeReg.register());
        translator.jump(method, instruction2, lookupFailed);
    }

    @ReferencedInGeneratedCode
    @JvmStatic
    @NotNull
    public static final A_Function lookup(@NotNull Interpreter interpreter, @NotNull A_Bundle bundle, @NotNull AvailObject[] types) throws MethodDefinitionException {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        if (Interpreter.Companion.getDebugL2()) {
            Logger logger = Interpreter.Companion.getLoggerDebugL2();
            Level level = Level.FINER;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"FINER");
            Object[] objectArray = new Object[]{interpreter.getDebugModeString(), A_Atom.Companion.getAtomName(A_Bundle.Companion.getMessage(bundle))};
            Interpreter.Companion.log(logger, level, "{0}Lookup-by-types {1}", objectArray);
        }
        A_Definition definitionToCall = A_Method.Companion.lookupByTypesFromTuple(A_Bundle.Companion.getBundleMethod(bundle), ObjectTupleDescriptor.Companion.tupleFromArray(Arrays.copyOf(types, types.length)));
        if (A_Sendable.Companion.isAbstractDefinition(definitionToCall)) {
            throw MethodDefinitionException.Companion.abstractMethod();
        }
        if (A_Sendable.Companion.isForwardDefinition(definitionToCall)) {
            throw MethodDefinitionException.Companion.forwardMethod();
        }
        return A_Sendable.Companion.bodyBlock(definitionToCall);
    }

    static {
        Object[] objectArray = new AvailErrorCode[]{AvailErrorCode.E_NO_METHOD, AvailErrorCode.E_NO_METHOD_DEFINITION, AvailErrorCode.E_AMBIGUOUS_METHOD_DEFINITION, AvailErrorCode.E_FORWARD_METHOD_DEFINITION, AvailErrorCode.E_ABSTRACT_METHOD_DEFINITION};
        failureCodesType = AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set((AvailErrorCode[])objectArray));
        objectArray = new Class[]{Interpreter.class, A_Bundle.class, AvailObject[].class};
        lookupMethod = CheckedMethod.Companion.staticMethod(L2_LOOKUP_BY_TYPES.class, "lookup", A_Function.class, (Class<?>[])objectArray);
    }
}

