/*
 * Decompiled with CFR 0.152.
 */
package avail.compiler.splitter;

import avail.compiler.ParsingOperation;
import avail.compiler.splitter.Expression;
import avail.compiler.splitter.InstructionGenerator;
import avail.compiler.splitter.MessageSplitter;
import avail.compiler.splitter.WrapState;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.types.A_Type;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.SignatureException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\r\u0010\u0012\u001a\u00020\u0000H\u0010\u00a2\u0006\u0002\b\u0013J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001d\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b\u001cJ%\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001eH\u0010\u00a2\u0006\u0002\b#J1\u0010$\u001a\u00020\u00182\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010&2\n\u0010'\u001a\u00060(j\u0002`)2\u0006\u0010*\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b+R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u00038PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0007R\u0014\u0010\u0010\u001a\u00020\t8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000b\u00a8\u0006,"}, d2={"Lavail/compiler/splitter/Argument;", "Lavail/compiler/splitter/Expression;", "positionInName", "", "absoluteUnderscoreIndex", "(II)V", "getAbsoluteUnderscoreIndex", "()I", "shouldBeSeparatedOnLeft", "", "getShouldBeSeparatedOnLeft$avail", "()Z", "shouldBeSeparatedOnRight", "getShouldBeSeparatedOnRight$avail", "underscoreCount", "getUnderscoreCount$avail", "yieldsValue", "getYieldsValue$avail", "applyCaseInsensitive", "applyCaseInsensitive$avail", "checkListStructure", "phrase", "Lavail/descriptor/phrases/A_Phrase;", "checkType", "", "argumentType", "Lavail/descriptor/types/A_Type;", "sectionNumber", "checkType$avail", "emitOn", "Lavail/compiler/splitter/WrapState;", "phraseType", "generator", "Lavail/compiler/splitter/InstructionGenerator;", "wrapState", "emitOn$avail", "printWithArguments", "arguments", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "indent", "printWithArguments$avail", "avail"})
public class Argument
extends Expression {
    private final int absoluteUnderscoreIndex;

    public Argument(int positionInName, int absoluteUnderscoreIndex) {
        super(positionInName);
        this.absoluteUnderscoreIndex = absoluteUnderscoreIndex;
    }

    public final int getAbsoluteUnderscoreIndex() {
        return this.absoluteUnderscoreIndex;
    }

    @Override
    public boolean getYieldsValue$avail() {
        return true;
    }

    @Override
    @NotNull
    public Argument applyCaseInsensitive$avail() {
        return this;
    }

    @Override
    public int getUnderscoreCount$avail() {
        return 1;
    }

    @Override
    public void checkType$avail(@NotNull A_Type argumentType, int sectionNumber) throws SignatureException {
        Intrinsics.checkNotNullParameter(argumentType, "argumentType");
        if (argumentType.isBottom()) {
            MessageSplitter.Companion.throwSignatureException(AvailErrorCode.E_INCORRECT_ARGUMENT_TYPE);
            throw new KotlinNothingValueException();
        }
    }

    @Override
    @NotNull
    public WrapState emitOn$avail(@NotNull A_Type phraseType, @NotNull InstructionGenerator generator, @NotNull WrapState wrapState) {
        Intrinsics.checkNotNullParameter(phraseType, "phraseType");
        Intrinsics.checkNotNullParameter(generator, "generator");
        Intrinsics.checkNotNullParameter((Object)wrapState, "wrapState");
        generator.flushDelayed();
        generator.emit(this, ParsingOperation.PARSE_ARGUMENT);
        generator.emitDelayed(this, ParsingOperation.CHECK_ARGUMENT, this.absoluteUnderscoreIndex);
        generator.emitDelayed(this, ParsingOperation.TYPE_CHECK_ARGUMENT, MessageSplitter.Companion.indexForConstant(phraseType));
        return wrapState.processAfterPushedArgument$avail(this, generator);
    }

    @Override
    public void printWithArguments$avail(@Nullable Iterator<? extends A_Phrase> arguments2, @NotNull StringBuilder builder2, int indent) {
        Intrinsics.checkNotNullParameter(builder2, "builder");
        Iterator<? extends A_Phrase> iterator2 = arguments2;
        Intrinsics.checkNotNull(iterator2);
        iterator2.next().printOnAvoidingIndent(builder2, new IdentityHashMap<A_BasicObject, Void>(), indent + 1);
    }

    @Override
    public boolean getShouldBeSeparatedOnLeft$avail() {
        return true;
    }

    @Override
    public boolean getShouldBeSeparatedOnRight$avail() {
        return true;
    }

    @Override
    public boolean checkListStructure(@NotNull A_Phrase phrase) {
        Intrinsics.checkNotNullParameter(phrase, "phrase");
        return true;
    }
}

