/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.compiler;

import avail.descriptor.functions.A_Function;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.functions.FunctionDescriptor;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.phrases.BlockPhraseDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.AvailRuntimeException;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/compiler/P_GenerateFunctionForBlock;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_GenerateFunctionForBlock
extends Primitive {
    @NotNull
    public static final P_GenerateFunctionForBlock INSTANCE = new P_GenerateFunctionForBlock();

    private P_GenerateFunctionForBlock() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(1, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(1);
        AvailObject block = interpreter.argument(0);
        try {
            BlockPhraseDescriptor.Companion.recursivelyValidate(block);
        }
        catch (AvailRuntimeException e) {
            return interpreter.primitiveFailure(e);
        }
        catch (Exception e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_BLOCK_IS_INVALID);
        }
        A_RawFunction compiledCode2 = null;
        try {
            compiledCode2 = A_Phrase.Companion.generateInModule(block, interpreter.module());
        }
        catch (Exception e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_BLOCK_COMPILATION_FAILED);
        }
        A_Function function = FunctionDescriptor.Companion.createFunction(compiledCode2, TupleDescriptor.Companion.getEmptyTuple());
        return interpreter.primitiveSuccess(function.makeImmutable());
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PhraseTypeDescriptor.PhraseKind.BLOCK_PHRASE.getMostGeneralType()), FunctionTypeDescriptor.Companion.mostGeneralFunctionType(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_BLOCK_IS_INVALID, AvailErrorCode.E_BLOCK_MUST_NOT_CONTAIN_OUTERS, AvailErrorCode.E_BLOCK_COMPILATION_FAILED};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

