/*
 * Decompiled with CFR 0.152.
 */
package avail.utility;

import avail.utility.Strings;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tJ\u0016\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u000fJ\u0016\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u000fJ\u000e\u0010\u0007\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u000fJ\u000e\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bJ8\u0010\u001c\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u001e0\u001d*\u00020\t2\u0006\u0010\u001f\u001a\u00020\t2\b\b\u0002\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020!J\u0016\u0010#\u001a\u00020$*\u00060%j\u0002`&2\u0006\u0010\u0018\u001a\u00020\u000fJ\u0016\u0010'\u001a\u00020$*\u00060%j\u0002`&2\u0006\u0010\u0018\u001a\u00020\u000fJd\u0010(\u001a\u00020$*\u00060%j\u0002`&2\u0006\u0010(\u001a\u00020\t2*\u0010)\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u001e0\b\"\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u001e2\u001b\u0010*\u001a\u0017\u0012\b\u0012\u00060%j\u0002`&\u0012\u0004\u0012\u00020$0+\u00a2\u0006\u0002\b,\u00a2\u0006\u0002\u0010-J;\u0010.\u001a\u00020$*\u00060%j\u0002`&2\u0006\u0010/\u001a\u00020\t2\u0006\u00100\u001a\u00020\t2\u001b\u0010*\u001a\u0017\u0012\b\u0012\u00060%j\u0002`&\u0012\u0004\u0012\u00020$0+\u00a2\u0006\u0002\b,R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u00061"}, d2={"Lavail/utility/Strings;", "", "()V", "lineBreakPattern", "Ljava/util/regex/Pattern;", "getLineBreakPattern", "()Ljava/util/regex/Pattern;", "tabs", "", "", "[Ljava/lang/String;", "addLineNumbers", "source", "pattern", "startingLineNumber", "", "escape", "s", "increaseIndentation", "originalString", "increasedIndentation", "repeated", "string", "count", "indent", "traceFor", "e", "", "matchesAbbreviation", "", "Lkotlin/Pair;", "abbreviation", "allowPartials", "", "ignoreCase", "newlineTab", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "tab", "tag", "attributes", "body", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/StringBuilder;Ljava/lang/String;[Lkotlin/Pair;Lkotlin/jvm/functions/Function1;)V", "wrap", "prefix", "suffix", "avail"})
public final class Strings {
    @NotNull
    public static final Strings INSTANCE = new Strings();
    @NotNull
    private static final String[] tabs;
    @NotNull
    private static final Pattern lineBreakPattern;

    private Strings() {
    }

    @NotNull
    public final String escape(@NotNull String s) {
        int codePoint;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(s, "s");
        StringBuilder $this$escape_u24lambda_u2d0 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$escape_u24lambda_u2d0.append('\"');
        for (int i = 0; i < s.length(); i += Character.charCount(codePoint)) {
            codePoint = s.codePointAt(i);
            int n = codePoint;
            if (n == 92) {
                $this$escape_u24lambda_u2d0.append("\\\\");
                continue;
            }
            if (n == 34) {
                $this$escape_u24lambda_u2d0.append("\\\"");
                continue;
            }
            if (n == 8) {
                $this$escape_u24lambda_u2d0.append("\\b");
                continue;
            }
            if (n == 10) {
                $this$escape_u24lambda_u2d0.append("\\n");
                continue;
            }
            if (n == 13) {
                $this$escape_u24lambda_u2d0.append("\\r");
                continue;
            }
            if (n == 9) {
                $this$escape_u24lambda_u2d0.append("\\t");
                continue;
            }
            $this$escape_u24lambda_u2d0.appendCodePoint(codePoint);
        }
        $this$escape_u24lambda_u2d0.append('\"');
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String addLineNumbers(@NotNull String source2, @NotNull String pattern, int startingLineNumber) {
        Intrinsics.checkNotNullParameter(source2, "source");
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        Closeable closeable = new Formatter();
        Throwable throwable = null;
        try {
            Formatter formatter = (Formatter)closeable;
            boolean bl = false;
            int line = startingLineNumber;
            int position = 0;
            while (position < source2.length()) {
                int nextStart = StringsKt.indexOf$default((CharSequence)source2, '\n', position, false, 4, null);
                nextStart = nextStart == -1 ? source2.length() : nextStart + 1;
                Object[] objectArray = new Object[2];
                objectArray[0] = line;
                Intrinsics.checkNotNullExpressionValue(source2.substring(position, nextStart), "this as java.lang.String\u2026ing(startIndex, endIndex)");
                formatter.format(pattern, objectArray);
                position = nextStart;
                ++line;
            }
            String string2 = formatter.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "formatter.toString()");
            String string3 = string2;
            return string3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    @NotNull
    public final String tabs(int indent) {
        if (indent < tabs.length) {
            return tabs[indent];
        }
        StringBuilder builder2 = new StringBuilder(indent);
        int i = 1;
        if (i <= indent) {
            while (true) {
                builder2.append('\t');
                if (i == indent) break;
                ++i;
            }
        }
        String string2 = builder2.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "builder.toString()");
        return string2;
    }

    public final void tab(@NotNull StringBuilder $this$tab, int indent) {
        Intrinsics.checkNotNullParameter($this$tab, "<this>");
        int i = 1;
        if (i <= indent) {
            while (true) {
                $this$tab.append('\t');
                if (i == indent) break;
                ++i;
            }
        }
    }

    public final void newlineTab(@NotNull StringBuilder $this$newlineTab, int indent) {
        Intrinsics.checkNotNullParameter($this$newlineTab, "<this>");
        StringBuilder stringBuilder = $this$newlineTab.append('\n');
        Intrinsics.checkNotNullExpressionValue(stringBuilder, "append('\\n')");
        this.tab(stringBuilder, indent);
    }

    @NotNull
    public final String repeated(@NotNull String string2, int count) {
        StringBuilder stringBuilder;
        int n;
        Intrinsics.checkNotNullParameter(string2, "string");
        int n2 = n = count >= 0 ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        n = string2.length() * count;
        StringBuilder $this$repeated_u24lambda_u2d5 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        int n3 = 0;
        while (n3 < count) {
            int it = n3++;
            boolean bl2 = false;
            $this$repeated_u24lambda_u2d5.append(string2);
        }
        String string4 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string4, "StringBuilder(capacity).\u2026builderAction).toString()");
        return string4;
    }

    @NotNull
    public final Pattern getLineBreakPattern() {
        return lineBreakPattern;
    }

    @NotNull
    public final String increaseIndentation(@NotNull String originalString, int increasedIndentation) {
        String string2;
        boolean bl;
        Intrinsics.checkNotNullParameter(originalString, "originalString");
        boolean bl2 = bl = increasedIndentation >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        if (increasedIndentation == 0) {
            string2 = originalString;
        } else {
            String string4 = lineBreakPattern.matcher(originalString).replaceAll(Matcher.quoteReplacement("\n" + this.tabs(increasedIndentation)));
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue(string4, "{\n\t\t\tlineBreakPattern\n\t\t\u2026creasedIndentation)))\n\t\t}");
        }
        return string2;
    }

    @NotNull
    public final String traceFor(@NotNull Throwable e) {
        String string2;
        Intrinsics.checkNotNullParameter(e, "e");
        try {
            ByteArrayOutputStream traceBytes = new ByteArrayOutputStream();
            PrintStream trace2 = new PrintStream((OutputStream)traceBytes, true, StandardCharsets.UTF_8.name());
            e.printStackTrace(trace2);
            byte[] byArray = traceBytes.toByteArray();
            Intrinsics.checkNotNullExpressionValue(byArray, "traceBytes.toByteArray()");
            byte[] byArray2 = byArray;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue(charset, "UTF_8");
            Charset charset2 = charset;
            string2 = new String(byArray2, charset2);
        }
        catch (UnsupportedEncodingException x) {
            if (_Assertions.ENABLED) {
                boolean bl = false;
                String string3 = "This never happens!";
                throw new AssertionError((Object)string3);
            }
            throw new RuntimeException(x);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void wrap(@NotNull StringBuilder $this$wrap, @NotNull String prefix, @NotNull String suffix, @NotNull Function1<? super StringBuilder, Unit> body2) {
        Intrinsics.checkNotNullParameter($this$wrap, "<this>");
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        Intrinsics.checkNotNullParameter(suffix, "suffix");
        Intrinsics.checkNotNullParameter(body2, "body");
        $this$wrap.append(prefix);
        try {
            body2.invoke($this$wrap);
        }
        finally {
            $this$wrap.append(suffix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void tag(@NotNull StringBuilder $this$tag, @NotNull String tag, @NotNull Pair<String, String>[] attributes, @NotNull Function1<? super StringBuilder, Unit> body2) {
        Intrinsics.checkNotNullParameter($this$tag, "<this>");
        Intrinsics.checkNotNullParameter(tag, "tag");
        Intrinsics.checkNotNullParameter(attributes, "attributes");
        Intrinsics.checkNotNullParameter(body2, "body");
        $this$tag.append("<");
        $this$tag.append(tag);
        Pair<String, String>[] $this$forEach$iv = attributes;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Pair<String, String> element$iv;
            Pair<String, String> pair = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            String key = pair.component1();
            String value = pair.component2();
            $this$tag.append(" " + key + "=" + INSTANCE.escape(value));
        }
        $this$tag.append(">");
        try {
            body2.invoke($this$tag);
        }
        finally {
            $this$tag.append("</" + tag + ">");
        }
    }

    @NotNull
    public final List<Pair<Integer, Integer>> matchesAbbreviation(@NotNull String $this$matchesAbbreviation, @NotNull String abbreviation, boolean allowPartials, boolean ignoreCase) {
        int c;
        Intrinsics.checkNotNullParameter($this$matchesAbbreviation, "<this>");
        Intrinsics.checkNotNullParameter(abbreviation, "abbreviation");
        if (!allowPartials && abbreviation.length() > $this$matchesAbbreviation.length()) {
            return CollectionsKt.emptyList();
        }
        Function1 normalize2 = ignoreCase ? (Function1)matchesAbbreviation.normalize.1.INSTANCE : (Function1)matchesAbbreviation.normalize.2.INSTANCE;
        String search = (String)normalize2.invoke(abbreviation);
        int searchLength = search.length();
        String target = (String)normalize2.invoke($this$matchesAbbreviation);
        int targetLength = target.length();
        List matches = new ArrayList();
        Integer start = null;
        int scan = 0;
        int next = search.codePointAt(0);
        int i = 0;
        int matchLength = 0;
        do {
            if (next == (c = target.codePointAt(i))) {
                if (start == null) {
                    start = i;
                }
                if (++scan >= searchLength) {
                    matches.add(TuplesKt.to(start, i + 1));
                    matchLength += i - start + 1;
                    break;
                }
                next = search.codePointAt(scan);
                continue;
            }
            if (start == null) continue;
            matches.add(TuplesKt.to(start, i));
            matchLength += i - start;
            start = null;
        } while ((i += Character.charCount(c)) < targetLength);
        return allowPartials || matchLength == searchLength ? matches : CollectionsKt.emptyList();
    }

    public static /* synthetic */ List matchesAbbreviation$default(Strings strings2, String string2, String string3, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return strings2.matchesAbbreviation(string2, string3, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    static {
        String[] stringArray = new String[10];
        for (int i = 0; i < 10; ++i) {
            StringBuilder stringBuilder;
            int n = i;
            StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
            int n2 = n;
            String[] stringArray2 = stringArray;
            boolean bl = false;
            int n3 = 0;
            while (n3 < n) {
                void $this$tabs_u24lambda_u2d3;
                int it = n3++;
                boolean bl2 = false;
                $this$tabs_u24lambda_u2d3.append('\t');
            }
            Unit unit = Unit.INSTANCE;
            Intrinsics.checkNotNullExpressionValue(stringBuilder.toString(), "StringBuilder().apply(builderAction).toString()");
        }
        tabs = stringArray;
        Pattern pattern = Pattern.compile("\n", 16);
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(\"\\n\", Pattern.LITERAL)");
        lineBreakPattern = pattern;
    }
}

