/*
 * Decompiled with CFR 0.152.
 */
package avail.compiler.problems;

import avail.AvailRuntime;
import avail.builder.ModuleName;
import avail.compiler.problems.CompilerDiagnostics;
import avail.compiler.problems.Problem;
import avail.compiler.problems.ProblemHandler;
import avail.compiler.problems.ProblemType;
import avail.compiler.problems.ProblemsAtPosition;
import avail.compiler.scanning.LexingState;
import avail.descriptor.character.CharacterDescriptor;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.tokens.A_Token;
import avail.descriptor.tokens.TokenDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.utility.Mutable;
import avail.utility.Strings;
import avail.utility.evaluation.Combinator;
import avail.utility.evaluation.SimpleDescriber;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import javax.annotation.concurrent.GuardedBy;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u0000 K2\u00020\u0001:\u0005KLMNOB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ:\u00106\u001a\u00020\u00142\u0006\u00107\u001a\u0002082\"\u00109\u001a\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020\u00140:\u0012\u0004\u0012\u00020\u00140:j\u0002`<2\u0006\u0010=\u001a\u00020+J\u000e\u0010>\u001a\u00020\u00142\u0006\u0010?\u001a\u00020@J\u000e\u0010A\u001a\u00020\u00142\u0006\u0010B\u001a\u00020\u0017J\u0006\u0010C\u001a\u00020\u0014J\u001e\u0010C\u001a\u00020\u00142\u0006\u0010=\u001a\u00020+2\u0006\u0010D\u001a\u00020;2\u0006\u0010E\u001a\u00020;J\"\u0010F\u001a\u00020\u00142\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00140\u00072\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00140\u0007J\u000e\u0010I\u001a\u00020\u00142\u0006\u0010J\u001a\u00020+R\u001a\u0010\f\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00060\u0012R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR+\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$*\u0004\b\u001f\u0010 R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010%\u001a\u00060\u0012R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010&\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b(\u0010\"\"\u0004\b)\u0010$*\u0004\b'\u0010 R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010,\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u001b\"\u0004\b.\u0010/R\u001b\u00100\u001a\u0002018FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u00105\u001a\u0004\b2\u00103\u00a8\u0006P"}, d2={"Lavail/compiler/problems/CompilerDiagnostics;", "", "source", "Lavail/descriptor/tuples/A_String;", "moduleName", "Lavail/builder/ModuleName;", "pollForAbort", "Lkotlin/Function0;", "", "problemHandler", "Lavail/compiler/problems/ProblemHandler;", "(Lavail/descriptor/tuples/A_String;Lavail/builder/ModuleName;Lkotlin/jvm/functions/Function0;Lavail/compiler/problems/ProblemHandler;)V", "compilationIsInvalid", "getCompilationIsInvalid", "()Z", "setCompilationIsInvalid", "(Z)V", "expectationsList", "Lavail/compiler/problems/CompilerDiagnostics$ExpectationsList;", "failureReporter", "", "liveTokens", "", "Lavail/descriptor/tokens/A_Token;", "liveTokensLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getPollForAbort", "()Lkotlin/jvm/functions/Function0;", "<set-?>", "", "positionsToTrack", "getPositionsToTrack$delegate", "(Lavail/compiler/problems/CompilerDiagnostics;)Ljava/lang/Object;", "getPositionsToTrack", "()I", "setPositionsToTrack", "(I)V", "silentExpectationsList", "silentPositionsToTrack", "getSilentPositionsToTrack$delegate", "getSilentPositionsToTrack", "setSilentPositionsToTrack", "startOfStatement", "Lavail/compiler/scanning/LexingState;", "successReporter", "getSuccessReporter", "setSuccessReporter", "(Lkotlin/jvm/functions/Function0;)V", "surrogateIndexConverter", "Lavail/descriptor/tuples/A_String$SurrogateIndexConverter;", "getSurrogateIndexConverter", "()Lavail/descriptor/tuples/A_String$SurrogateIndexConverter;", "surrogateIndexConverter$delegate", "Lkotlin/Lazy;", "expectedAt", "level", "Lavail/compiler/problems/CompilerDiagnostics$ParseNotificationLevel;", "describer", "Lkotlin/Function1;", "", "Lavail/utility/evaluation/Describer;", "lexingState", "handleProblem", "problem", "Lavail/compiler/problems/Problem;", "recordToken", "token", "reportError", "headerMessagePattern", "message", "setSuccessAndFailureReporters", "theSuccessReporter", "theFailureReporter", "startParsingAt", "initialPositionInSource", "Companion", "ExpectationsAtPosition", "ExpectationsList", "IndicatorGenerator", "ParseNotificationLevel", "avail"})
public final class CompilerDiagnostics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final A_String source;
    @NotNull
    private final ModuleName moduleName;
    @NotNull
    private final Function0<Boolean> pollForAbort;
    @NotNull
    private final ProblemHandler problemHandler;
    @Nullable
    private LexingState startOfStatement;
    @NotNull
    private final ExpectationsList expectationsList;
    @NotNull
    private final ExpectationsList silentExpectationsList;
    @NotNull
    private List<A_Token> liveTokens;
    @NotNull
    private final ReentrantReadWriteLock liveTokensLock;
    private volatile boolean compilationIsInvalid;
    @Nullable
    private volatile Function0<Unit> successReporter;
    @Nullable
    private volatile Function0<Unit> failureReporter;
    @NotNull
    private final Lazy surrogateIndexConverter$delegate;
    @NotNull
    private static final String rowOfDashes = "---------------------------------------------------------------------";
    @NotNull
    private static final String circledLetters = "\u24b6\u24b7\u24b8\u24b9\u24ba\u24bb\u24bc\u24bd\u24be\u24bf\u24c0\u24c1\u24c2\u24c3\u24c4\u24c5\u24c6\u24c7\u24c8\u24c9\u24ca\u24cb\u24cc\u24cd\u24ce\u24cf";
    @NotNull
    private static final String errorIndicatorSymbol;
    @NotNull
    private static final String expectationHeaderMessagePattern = "Expected at %s, line %d...";

    public CompilerDiagnostics(@NotNull A_String source2, @NotNull ModuleName moduleName2, @NotNull Function0<Boolean> pollForAbort2, @NotNull ProblemHandler problemHandler) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)moduleName2, (String)"moduleName");
        Intrinsics.checkNotNullParameter(pollForAbort2, (String)"pollForAbort");
        Intrinsics.checkNotNullParameter((Object)problemHandler, (String)"problemHandler");
        this.source = source2;
        this.moduleName = moduleName2;
        this.pollForAbort = pollForAbort2;
        this.problemHandler = problemHandler;
        this.expectationsList = new ExpectationsList(1);
        this.silentExpectationsList = new ExpectationsList(2);
        this.liveTokens = new ArrayList();
        this.liveTokensLock = new ReentrantReadWriteLock();
        this.surrogateIndexConverter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<A_String.SurrogateIndexConverter>(this){
            final /* synthetic */ CompilerDiagnostics this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final A_String.SurrogateIndexConverter invoke() {
                return new A_String.SurrogateIndexConverter(CompilerDiagnostics.access$getSource$p(this.this$0).asNativeString());
            }
        }));
    }

    @NotNull
    public final Function0<Boolean> getPollForAbort() {
        return this.pollForAbort;
    }

    public final int getPositionsToTrack() {
        return this.expectationsList.getPositionsToTrack();
    }

    public final void setPositionsToTrack(int n) {
        this.expectationsList.setPositionsToTrack(n);
    }

    public static Object getPositionsToTrack$delegate(CompilerDiagnostics compilerDiagnostics) {
        Intrinsics.checkNotNullParameter((Object)compilerDiagnostics, (String)"<this>");
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)compilerDiagnostics.expectationsList, ExpectationsList.class, "positionsToTrack", "getPositionsToTrack()I", 0)));
    }

    public final int getSilentPositionsToTrack() {
        return this.silentExpectationsList.getPositionsToTrack();
    }

    public final void setSilentPositionsToTrack(int n) {
        this.silentExpectationsList.setPositionsToTrack(n);
    }

    public static Object getSilentPositionsToTrack$delegate(CompilerDiagnostics compilerDiagnostics) {
        Intrinsics.checkNotNullParameter((Object)compilerDiagnostics, (String)"<this>");
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)compilerDiagnostics.silentExpectationsList, ExpectationsList.class, "positionsToTrack", "getPositionsToTrack()I", 0)));
    }

    public final boolean getCompilationIsInvalid() {
        return this.compilationIsInvalid;
    }

    public final void setCompilationIsInvalid(boolean bl) {
        this.compilationIsInvalid = bl;
    }

    @Nullable
    public final Function0<Unit> getSuccessReporter() {
        return this.successReporter;
    }

    public final void setSuccessReporter(@Nullable Function0<Unit> function0) {
        this.successReporter = function0;
    }

    @NotNull
    public final A_String.SurrogateIndexConverter getSurrogateIndexConverter() {
        Lazy lazy = this.surrogateIndexConverter$delegate;
        return (A_String.SurrogateIndexConverter)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startParsingAt(@NotNull LexingState initialPositionInSource) {
        List<A_Token> list2;
        Intrinsics.checkNotNullParameter((Object)initialPositionInSource, (String)"initialPositionInSource");
        this.startOfStatement = initialPositionInSource;
        this.expectationsList.clear();
        this.silentExpectationsList.clear();
        ReentrantReadWriteLock $this$safeWrite$iv = this.liveTokensLock;
        boolean $i$f$safeWrite = false;
        ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"this.writeLock()");
        Lock lock = writeLock;
        lock.lock();
        try {
            boolean bl = false;
            List<A_Token> old = this.liveTokens;
            this.liveTokens = new ArrayList();
            list2 = old;
        }
        finally {
            lock.unlock();
        }
        List<A_Token> priorTokens = list2;
        for (A_Token token : priorTokens) {
            token.clearLexingState();
        }
    }

    public final void handleProblem(@NotNull Problem problem2) {
        Intrinsics.checkNotNullParameter((Object)problem2, (String)"problem");
        this.problemHandler.handle(problem2);
    }

    public final void setSuccessAndFailureReporters(@NotNull Function0<Unit> theSuccessReporter, @NotNull Function0<Unit> theFailureReporter) {
        Intrinsics.checkNotNullParameter(theSuccessReporter, (String)"theSuccessReporter");
        Intrinsics.checkNotNullParameter(theFailureReporter, (String)"theFailureReporter");
        AtomicBoolean hasRun = new AtomicBoolean(false);
        this.successReporter = (Function0)new Function0<Unit>(hasRun, theSuccessReporter){
            final /* synthetic */ AtomicBoolean $hasRun;
            final /* synthetic */ Function0<Unit> $theSuccessReporter;
            {
                this.$hasRun = $hasRun;
                this.$theSuccessReporter = $theSuccessReporter;
                super(0);
            }

            public final void invoke() {
                boolean bl;
                boolean ran = this.$hasRun.getAndSet(true);
                boolean bl2 = bl = !ran;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string2 = "Success/failure reporter ran twice";
                    throw new AssertionError((Object)string2);
                }
                this.$theSuccessReporter.invoke();
            }
        };
        this.failureReporter = (Function0)new Function0<Unit>(hasRun, theFailureReporter){
            final /* synthetic */ AtomicBoolean $hasRun;
            final /* synthetic */ Function0<Unit> $theFailureReporter;
            {
                this.$hasRun = $hasRun;
                this.$theFailureReporter = $theFailureReporter;
                super(0);
            }

            public final void invoke() {
                boolean bl;
                boolean ran = this.$hasRun.getAndSet(true);
                boolean bl2 = bl = !ran;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string2 = "Success/failure reporter ran twice";
                    throw new AssertionError((Object)string2);
                }
                this.$theFailureReporter.invoke();
            }
        };
    }

    public final void expectedAt(@NotNull ParseNotificationLevel level, @NotNull Function1<? super Function1<? super String, Unit>, Unit> describer, @NotNull LexingState lexingState) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter(describer, (String)"describer");
        Intrinsics.checkNotNullParameter((Object)lexingState, (String)"lexingState");
        ExpectationsList list2 = level == ParseNotificationLevel.SILENT ? this.silentExpectationsList : this.expectationsList;
        list2.expectedAt(level, describer, lexingState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void recordToken(@NotNull A_Token token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        ReentrantReadWriteLock $this$safeWrite$iv = this.liveTokensLock;
        boolean $i$f$safeWrite = false;
        ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"this.writeLock()");
        Lock lock = writeLock;
        lock.lock();
        try {
            boolean bl = false;
            this.liveTokens.add(token);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public final void reportError() {
        boolean bl;
        ExpectationsList list2 = this.expectationsList;
        if (list2.isEmpty() && (list2 = this.silentExpectationsList).isEmpty()) {
            list2 = new ExpectationsList(1);
            Function1 function1 = reportError.1.INSTANCE;
            LexingState lexingState = this.startOfStatement;
            Intrinsics.checkNotNull((Object)lexingState);
            list2.expectedAt(ParseNotificationLevel.STRONG, (Function1<? super Function1<? super String, Unit>, Unit>)function1, lexingState);
        }
        boolean bl2 = bl = !list2.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        list2.reportError(expectationHeaderMessagePattern);
    }

    public final void reportError(@NotNull LexingState lexingState, @NotNull String headerMessagePattern, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)lexingState, (String)"lexingState");
        Intrinsics.checkNotNullParameter((Object)headerMessagePattern, (String)"headerMessagePattern");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.expectationsList.reportError(lexingState, headerMessagePattern, message);
    }

    public static final /* synthetic */ ModuleName access$getModuleName$p(CompilerDiagnostics $this) {
        return $this.moduleName;
    }

    static {
        String string2 = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(\"os.name\")");
        errorIndicatorSymbol = StringsKt.startsWith$default((String)string2, (String)"Windows", (boolean)false, (int)2, null) ? "\u21aa" : "\u2937";
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\b"}, d2={"Lavail/compiler/problems/CompilerDiagnostics$ParseNotificationLevel;", "", "(Ljava/lang/String;I)V", "SILENT", "WEAK", "MEDIUM", "STRONG", "Companion", "avail"})
    public static final class ParseNotificationLevel
    extends Enum<ParseNotificationLevel> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private static final ParseNotificationLevel[] all;
        public static final /* enum */ ParseNotificationLevel SILENT;
        public static final /* enum */ ParseNotificationLevel WEAK;
        public static final /* enum */ ParseNotificationLevel MEDIUM;
        public static final /* enum */ ParseNotificationLevel STRONG;
        private static final /* synthetic */ ParseNotificationLevel[] $VALUES;

        public static ParseNotificationLevel[] values() {
            return (ParseNotificationLevel[])$VALUES.clone();
        }

        public static ParseNotificationLevel valueOf(String value) {
            return Enum.valueOf(ParseNotificationLevel.class, value);
        }

        static {
            SILENT = new ParseNotificationLevel();
            WEAK = new ParseNotificationLevel();
            MEDIUM = new ParseNotificationLevel();
            STRONG = new ParseNotificationLevel();
            $VALUES = parseNotificationLevelArray = new ParseNotificationLevel[]{ParseNotificationLevel.SILENT, ParseNotificationLevel.WEAK, ParseNotificationLevel.MEDIUM, ParseNotificationLevel.STRONG};
            Companion = new Companion(null);
            all = ParseNotificationLevel.values();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tR\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\n"}, d2={"Lavail/compiler/problems/CompilerDiagnostics$ParseNotificationLevel$Companion;", "", "()V", "all", "", "Lavail/compiler/problems/CompilerDiagnostics$ParseNotificationLevel;", "[Lavail/compiler/problems/CompilerDiagnostics$ParseNotificationLevel;", "levelFromInt", "level", "", "avail"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ParseNotificationLevel levelFromInt(int level) {
                return all[level];
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00042\"\u0010\u0015\u001a\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR3\u0010\n\u001a$\u0012 \u0012\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u000f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lavail/compiler/problems/CompilerDiagnostics$ExpectationsAtPosition;", "", "()V", "level", "Lavail/compiler/problems/CompilerDiagnostics$ParseNotificationLevel;", "lexingStates", "", "Lavail/compiler/scanning/LexingState;", "getLexingStates", "()Ljava/util/Set;", "problems", "", "Lkotlin/Function1;", "", "", "Lavail/utility/evaluation/Describer;", "getProblems", "()Ljava/util/List;", "recordProblem", "lexingState", "newLevel", "describer", "avail"})
    public static final class ExpectationsAtPosition {
        @NotNull
        private ParseNotificationLevel level = ParseNotificationLevel.SILENT;
        @NotNull
        private final List<Function1<Function1<? super String, Unit>, Unit>> problems = new ArrayList();
        @NotNull
        private final Set<LexingState> lexingStates = new LinkedHashSet();

        @NotNull
        public final List<Function1<Function1<? super String, Unit>, Unit>> getProblems() {
            return this.problems;
        }

        @NotNull
        public final Set<LexingState> getLexingStates() {
            return this.lexingStates;
        }

        public final void recordProblem(@NotNull LexingState lexingState, @NotNull ParseNotificationLevel newLevel, @NotNull Function1<? super Function1<? super String, Unit>, Unit> describer) {
            Intrinsics.checkNotNullParameter((Object)lexingState, (String)"lexingState");
            Intrinsics.checkNotNullParameter((Object)((Object)newLevel), (String)"newLevel");
            Intrinsics.checkNotNullParameter(describer, (String)"describer");
            if (newLevel.ordinal() < this.level.ordinal()) {
                return;
            }
            if (newLevel.ordinal() > this.level.ordinal()) {
                this.level = newLevel;
                this.problems.clear();
                this.lexingStates.clear();
            }
            this.problems.add(describer);
            this.lexingStates.add(lexingState);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JJ\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u00182\n\u0010\u0019\u001a\u00060\u001aR\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0018\u0010\u001f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0!\u0012\u0004\u0012\u00020\u00160 H\u0002J\u0006\u0010\"\u001a\u00020\u0016J:\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020%2\"\u0010&\u001a\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u00160 \u0012\u0004\u0012\u00020\u00160 j\u0002`(2\u0006\u0010)\u001a\u00020*J\u001e\u0010+\u001a\u00020\u00162\u0006\u0010)\u001a\u00020*2\u0006\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020'J\u000e\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020'J\u001e\u0010.\u001a\u00020\u00162\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0!2\u0006\u0010,\u001a\u00020'H\u0002R\u001c\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006/"}, d2={"Lavail/compiler/problems/CompilerDiagnostics$ExpectationsList;", "", "positionsToTrack", "", "(Lavail/compiler/problems/CompilerDiagnostics;I)V", "expectations", "", "Lavail/compiler/problems/CompilerDiagnostics$ExpectationsAtPosition;", "expectationsIndexHeap", "Ljava/util/PriorityQueue;", "expectationsLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getExpectationsLock", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "isEmpty", "", "()Z", "getPositionsToTrack", "()I", "setPositionsToTrack", "(I)V", "accumulateErrorsThen", "", "descendingIterator", "", "indicatorGenerator", "Lavail/compiler/problems/CompilerDiagnostics$IndicatorGenerator;", "Lavail/compiler/problems/CompilerDiagnostics;", "groupedProblems", "", "Lavail/compiler/problems/ProblemsAtPosition;", "afterGrouping", "Lkotlin/Function1;", "", "clear", "expectedAt", "level", "Lavail/compiler/problems/CompilerDiagnostics$ParseNotificationLevel;", "describer", "", "Lavail/utility/evaluation/Describer;", "lexingState", "Lavail/compiler/scanning/LexingState;", "reportError", "headerMessagePattern", "message", "reportGroupedErrors", "avail"})
    private final class ExpectationsList {
        private int positionsToTrack;
        @NotNull
        private final ReentrantReadWriteLock expectationsLock;
        @GuardedBy(value="expectationsLock")
        @NotNull
        private final Map<Integer, ExpectationsAtPosition> expectations;
        @GuardedBy(value="expectationsLock")
        @NotNull
        private final PriorityQueue<Integer> expectationsIndexHeap;

        public ExpectationsList(int positionsToTrack) {
            this.positionsToTrack = positionsToTrack;
            this.expectationsLock = new ReentrantReadWriteLock();
            this.expectations = new LinkedHashMap();
            this.expectationsIndexHeap = new PriorityQueue();
        }

        public final int getPositionsToTrack() {
            return this.positionsToTrack;
        }

        public final void setPositionsToTrack(int n) {
            this.positionsToTrack = n;
        }

        @NotNull
        public final ReentrantReadWriteLock getExpectationsLock() {
            return this.expectationsLock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean isEmpty() {
            boolean bl;
            ReentrantReadWriteLock.ReadLock readLock = this.expectationsLock.readLock();
            readLock.lock();
            try {
                boolean bl2 = false;
                bl = this.expectations.isEmpty();
            }
            finally {
                readLock.unlock();
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void clear() {
            ReentrantReadWriteLock $this$safeWrite$iv = this.expectationsLock;
            boolean $i$f$safeWrite = false;
            ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
            Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"this.writeLock()");
            Lock lock = writeLock;
            lock.lock();
            try {
                boolean bl = false;
                this.expectations.clear();
                this.expectationsIndexHeap.clear();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void expectedAt(@NotNull ParseNotificationLevel level, @NotNull Function1<? super Function1<? super String, Unit>, Unit> describer, @NotNull LexingState lexingState) {
            Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
            Intrinsics.checkNotNullParameter(describer, (String)"describer");
            Intrinsics.checkNotNullParameter((Object)lexingState, (String)"lexingState");
            ReentrantReadWriteLock $this$safeWrite$iv = this.expectationsLock;
            boolean $i$f$safeWrite = false;
            ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
            Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"this.writeLock()");
            Lock lock = writeLock;
            lock.lock();
            try {
                boolean bl = false;
                int position = lexingState.getPosition();
                ExpectationsAtPosition localExpectations = this.expectations.get(position);
                if (localExpectations == null) {
                    if (this.expectationsIndexHeap.size() == this.positionsToTrack) {
                        Integer n = this.expectationsIndexHeap.peek();
                        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"expectationsIndexHeap.peek()");
                        if (position < ((Number)n).intValue()) {
                            return;
                        }
                    }
                    localExpectations = new ExpectationsAtPosition();
                    Integer n = position;
                    this.expectations.put(n, localExpectations);
                    this.expectationsIndexHeap.add(position);
                    if (this.expectationsIndexHeap.size() > this.positionsToTrack) {
                        Integer removed = (Integer)this.expectationsIndexHeap.remove();
                        Intrinsics.checkNotNull((Object)this.expectations.remove(removed));
                    }
                }
                localExpectations.recordProblem(lexingState, level, describer);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }

        private final void reportGroupedErrors(List<ProblemsAtPosition> groupedProblems, String headerMessagePattern) {
            if (((Boolean)CompilerDiagnostics.this.getPollForAbort().invoke()).booleanValue()) {
                Function0 function0 = CompilerDiagnostics.this.failureReporter;
                Intrinsics.checkNotNull((Object)function0);
                function0.invoke();
                return;
            }
            List ascending = CollectionsKt.sorted((Iterable)groupedProblems);
            A_String a_String = CompilerDiagnostics.this.source;
            LexingState lexingState = CompilerDiagnostics.this.startOfStatement;
            Intrinsics.checkNotNull((Object)lexingState);
            int startOfFirstLine = 1 + Companion.lastIndexOf(a_String, 10, lexingState.getPosition() - 1, 1);
            int initialLineNumber = 1 + Companion.occurrencesInRange(CompilerDiagnostics.this.source, 10, 1, Math.min(A_Tuple.Companion.getTupleSize(CompilerDiagnostics.this.source), startOfFirstLine));
            ProblemsAtPosition lastProblem = (ProblemsAtPosition)ascending.get(ascending.size() - 1);
            int finalLineNumber = lastProblem.getLineNumber();
            int startOfNextLine = 1 + Companion.firstIndexOf(CompilerDiagnostics.this.source, 10, lastProblem.getLexingStateAfterToken$avail().getPosition(), A_Tuple.Companion.getTupleSize(CompilerDiagnostics.this.source));
            startOfNextLine = startOfNextLine != 1 ? startOfNextLine : A_Tuple.Companion.getTupleSize(CompilerDiagnostics.this.source) + 1;
            int startOfSecondNextLine = 1 + Companion.firstIndexOf(CompilerDiagnostics.this.source, 10, startOfNextLine, A_Tuple.Companion.getTupleSize(CompilerDiagnostics.this.source));
            startOfSecondNextLine = startOfSecondNextLine != 1 ? startOfSecondNextLine : A_Tuple.Companion.getTupleSize(CompilerDiagnostics.this.source) + 1;
            int sourcePosition = startOfFirstLine;
            List parts = new ArrayList();
            for (ProblemsAtPosition eachProblem : ascending) {
                int newPosition = eachProblem.getPosition();
                parts.add(CompilerDiagnostics.this.source.copyStringFromToCanDestroy(sourcePosition, newPosition - 1, false));
                parts.add(StringDescriptor.Companion.stringFrom(eachProblem.getIndicator$avail()));
                sourcePosition = newPosition;
            }
            parts.add(CompilerDiagnostics.this.source.copyStringFromToCanDestroy(sourcePosition, startOfSecondNextLine - 1, false));
            A_Tuple unnumbered = null;
            unnumbered = A_Tuple.Companion.concatenateTuplesCanDestroy(ObjectTupleDescriptor.Companion.tupleFromList(parts), true);
            if (A_Tuple.Companion.getTupleSize(unnumbered) == 0 || A_Tuple.Companion.tupleCodePointAt(unnumbered, A_Tuple.Companion.getTupleSize(unnumbered)) != 10) {
                unnumbered = A_Tuple.Companion.appendCanDestroy(unnumbered, CharacterDescriptor.Companion.fromCodePoint(10), true);
            }
            int maxDigits = String.valueOf(finalLineNumber + 1).length();
            StringBuilder stringBuilder = new StringBuilder(500);
            CompilerDiagnostics compilerDiagnostics = CompilerDiagnostics.this;
            StringBuilder $this$reportGroupedErrors_u24lambda_u2d3 = stringBuilder;
            boolean bl = false;
            A_Tuple a_Tuple = unnumbered;
            Intrinsics.checkNotNull((Object)a_Tuple, (String)"null cannot be cast to non-null type avail.descriptor.tuples.A_String");
            $this$reportGroupedErrors_u24lambda_u2d3.append(Strings.INSTANCE.addLineNumbers(((A_String)a_Tuple).asNativeString(), ">>> %" + maxDigits + "d: %s", initialLineNumber));
            $this$reportGroupedErrors_u24lambda_u2d3.append(">>>---------------------------------------------------------------------");
            Iterator<ProblemsAtPosition> groupIterator = groupedProblems.iterator();
            Mutable<Iterator<Function1<Function1<? super String, Unit>, Unit>>> problemIterator = new Mutable<Iterator<Function1<Function1<? super String, Unit>, Unit>>>(Collections.emptyIterator());
            Set alreadySeen = new LinkedHashSet();
            Combinator.INSTANCE.recurse((Function1<? super Function0<Unit>, Unit>)((Function1)new Function1<Function0<? extends Unit>, Unit>(problemIterator, groupIterator, compilerDiagnostics, $this$reportGroupedErrors_u24lambda_u2d3, lastProblem, headerMessagePattern, (Set<String>)alreadySeen){
                final /* synthetic */ Mutable<Iterator<Function1<Function1<? super String, Unit>, Unit>>> $problemIterator;
                final /* synthetic */ Iterator<ProblemsAtPosition> $groupIterator;
                final /* synthetic */ CompilerDiagnostics this$0;
                final /* synthetic */ StringBuilder $this_run;
                final /* synthetic */ ProblemsAtPosition $lastProblem;
                final /* synthetic */ String $headerMessagePattern;
                final /* synthetic */ Set<String> $alreadySeen;
                {
                    this.$problemIterator = $problemIterator;
                    this.$groupIterator = $groupIterator;
                    this.this$0 = $receiver;
                    this.$this_run = $receiver2;
                    this.$lastProblem = $lastProblem;
                    this.$headerMessagePattern = $headerMessagePattern;
                    this.$alreadySeen = $alreadySeen;
                    super(1);
                }

                public final void invoke(@NotNull Function0<Unit> continueReport) {
                    Intrinsics.checkNotNullParameter(continueReport, (String)"continueReport");
                    if (!this.$problemIterator.getValue().hasNext()) {
                        if (!this.$groupIterator.hasNext()) {
                            this.this$0.setCompilationIsInvalid(true);
                            Object object = new Object[]{CompilerDiagnostics.access$getModuleName$p(this.this$0).getQualifiedName(), this.$lastProblem.getLineNumber(), "---------------------------------------------------------------------"};
                            this.$this_run.append(String.format("%n(file=\"%s\", line=%d)%n>>>%s", object));
                            object = CompilerDiagnostics.access$getModuleName$p(this.this$0);
                            int n = this.$lastProblem.getLineNumber();
                            long l = this.$lastProblem.getPosition();
                            ProblemType problemType = ProblemType.PARSE;
                            Object[] objectArray = new Object[1];
                            String string2 = this.$this_run.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this@run.toString()");
                            objectArray[0] = StringsKt.replace$default((String)string2, (String)"\t", (String)"    ", (boolean)false, (int)4, null);
                            Object[] objectArray2 = objectArray;
                            this.this$0.handleProblem(new Problem(this.this$0, (ModuleName)object, n, l, problemType, objectArray2){
                                final /* synthetic */ CompilerDiagnostics this$0;
                                {
                                    this.this$0 = $receiver;
                                    super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4, "{0}", $super_call_param$5);
                                }

                                public void abortCompilation() {
                                    block0: {
                                        Function0 function0 = CompilerDiagnostics.access$getFailureReporter$p(this.this$0);
                                        if (function0 == null) break block0;
                                        function0.invoke();
                                    }
                                }
                            });
                            return;
                        }
                        ProblemsAtPosition newGroup = this.$groupIterator.next();
                        this.$this_run.append("\n>>> ");
                        Object[] objectArray = new Object[]{newGroup.getIndicator$avail(), newGroup.getLineNumber()};
                        this.$this_run.append(String.format(this.$headerMessagePattern, objectArray));
                        this.$problemIterator.setValue(newGroup.getDescribers$avail().iterator());
                        this.$alreadySeen.clear();
                        boolean bl = this.$problemIterator.getValue().hasNext();
                        if (_Assertions.ENABLED && !bl) {
                            String string3 = "Assertion failed";
                            throw new AssertionError((Object)string3);
                        }
                    }
                    this.$problemIterator.getValue().next().invoke((Object)new Function1<String, Unit>(this.$alreadySeen, this.$this_run, continueReport){
                        final /* synthetic */ Set<String> $alreadySeen;
                        final /* synthetic */ StringBuilder $this_run;
                        final /* synthetic */ Function0<Unit> $continueReport;
                        {
                            this.$alreadySeen = $alreadySeen;
                            this.$this_run = $receiver;
                            this.$continueReport = $continueReport;
                            super(1);
                        }

                        public final void invoke(@NotNull String message) {
                            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                            if (!this.$alreadySeen.contains(message)) {
                                this.$alreadySeen.add(message);
                                this.$this_run.append("\n>>>\t\t");
                                this.$this_run.append(Strings.INSTANCE.getLineBreakPattern().matcher(message).replaceAll(Matcher.quoteReplacement("\n>>>\t\t")));
                            }
                            AvailRuntime.Companion.currentRuntime().execute(50, this.$continueReport);
                        }
                    });
                }
            }));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void reportError(@NotNull String headerMessagePattern) {
            List list2;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)headerMessagePattern, (String)"headerMessagePattern");
            boolean bl2 = bl = !this.isEmpty();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            ReentrantReadWriteLock.ReadLock readLock = this.expectationsLock.readLock();
            readLock.lock();
            try {
                boolean bl3 = false;
                list2 = CollectionsKt.toList((Iterable)this.expectationsIndexHeap);
            }
            finally {
                readLock.unlock();
            }
            Iterable iterable = list2;
            Comparator comparator = Collections.reverseOrder();
            Intrinsics.checkNotNullExpressionValue(comparator, (String)"reverseOrder()");
            List descendingIndices = CollectionsKt.sortedWith((Iterable)iterable, comparator);
            this.accumulateErrorsThen(descendingIndices.iterator(), new IndicatorGenerator(), new ArrayList(), (Function1<? super List<ProblemsAtPosition>, Unit>)((Function1)new Function1<List<? extends ProblemsAtPosition>, Unit>(this, headerMessagePattern){
                final /* synthetic */ ExpectationsList this$0;
                final /* synthetic */ String $headerMessagePattern;
                {
                    this.this$0 = $receiver;
                    this.$headerMessagePattern = $headerMessagePattern;
                    super(1);
                }

                public final void invoke(@NotNull List<ProblemsAtPosition> groups) {
                    Intrinsics.checkNotNullParameter(groups, (String)"groups");
                    ExpectationsList.access$reportGroupedErrors(this.this$0, groups, this.$headerMessagePattern);
                }
            }));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void reportError(@NotNull LexingState lexingState, @NotNull String headerMessagePattern, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)lexingState, (String)"lexingState");
            Intrinsics.checkNotNullParameter((Object)headerMessagePattern, (String)"headerMessagePattern");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            ReentrantReadWriteLock $this$safeWrite$iv = this.expectationsLock;
            boolean $i$f$safeWrite = false;
            ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
            Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"this.writeLock()");
            Lock lock = writeLock;
            lock.lock();
            try {
                boolean bl = false;
                this.expectations.clear();
                this.expectationsIndexHeap.clear();
                ExpectationsAtPosition localExpectations = new ExpectationsAtPosition();
                localExpectations.recordProblem(lexingState, ParseNotificationLevel.STRONG, (Function1<? super Function1<? super String, Unit>, Unit>)((Function1)new SimpleDescriber(message)));
                this.expectations.put(lexingState.getPosition(), localExpectations);
                boolean bl2 = this.expectationsIndexHeap.add(lexingState.getPosition());
            }
            finally {
                lock.unlock();
            }
            this.reportError(headerMessagePattern);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void accumulateErrorsThen(Iterator<Integer> descendingIterator, IndicatorGenerator indicatorGenerator, List<ProblemsAtPosition> groupedProblems, Function1<? super List<ProblemsAtPosition>, Unit> afterGrouping) {
            Set set2;
            boolean bl;
            List list2;
            if (!descendingIterator.hasNext()) {
                boolean bl2;
                boolean bl3 = bl2 = !((Collection)groupedProblems).isEmpty();
                if (_Assertions.ENABLED && !bl2) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                afterGrouping.invoke(groupedProblems);
                return;
            }
            int sourcePosition = ((Number)descendingIterator.next()).intValue();
            Ref.ObjectRef describers = new Ref.ObjectRef();
            Ref.ObjectRef lexingStates = new Ref.ObjectRef();
            Object object = this.expectationsLock.readLock();
            ((ReentrantReadWriteLock.ReadLock)object).lock();
            try {
                boolean bl4 = false;
                ExpectationsAtPosition expectationsAtPosition = this.expectations.get(sourcePosition);
                Intrinsics.checkNotNull((Object)expectationsAtPosition);
                ExpectationsAtPosition localExpectations = expectationsAtPosition;
                describers.element = CollectionsKt.toList((Iterable)localExpectations.getProblems());
                lexingStates.element = CollectionsKt.toSet((Iterable)localExpectations.getLexingStates());
                Unit unit = Unit.INSTANCE;
            }
            finally {
                ((ReentrantReadWriteLock.ReadLock)object).unlock();
            }
            if (describers.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"describers");
                list2 = null;
            } else {
                list2 = (List)describers.element;
            }
            boolean bl5 = bl = !((Collection)list2).isEmpty();
            if (_Assertions.ENABLED && !bl) {
                object = "Assertion failed";
                throw new AssertionError(object);
            }
            if (lexingStates.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"lexingStates");
                set2 = null;
            } else {
                set2 = (Set)lexingStates.element;
            }
            Companion.findLongestTokenThen(set2, (Function1<? super A_Token, Unit>)((Function1)new Function1<A_Token, Unit>((Ref.ObjectRef<Set<LexingState>>)lexingStates, groupedProblems, indicatorGenerator, (Ref.ObjectRef<List<Function1<Function1<? super String, Unit>, Unit>>>)describers, this, descendingIterator, afterGrouping){
                final /* synthetic */ Ref.ObjectRef<Set<LexingState>> $lexingStates;
                final /* synthetic */ List<ProblemsAtPosition> $groupedProblems;
                final /* synthetic */ IndicatorGenerator $indicatorGenerator;
                final /* synthetic */ Ref.ObjectRef<List<Function1<Function1<? super String, Unit>, Unit>>> $describers;
                final /* synthetic */ ExpectationsList this$0;
                final /* synthetic */ Iterator<Integer> $descendingIterator;
                final /* synthetic */ Function1<List<ProblemsAtPosition>, Unit> $afterGrouping;
                {
                    this.$lexingStates = $lexingStates;
                    this.$groupedProblems = $groupedProblems;
                    this.$indicatorGenerator = $indicatorGenerator;
                    this.$describers = $describers;
                    this.this$0 = $receiver;
                    this.$descendingIterator = $descendingIterator;
                    this.$afterGrouping = $afterGrouping;
                    super(1);
                }

                public final void invoke(@NotNull A_Token longestToken) {
                    List list2;
                    Set set2;
                    Intrinsics.checkNotNullParameter((Object)longestToken, (String)"longestToken");
                    if (this.$lexingStates.element == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"lexingStates");
                        set2 = null;
                    } else {
                        set2 = (Set)this.$lexingStates.element;
                    }
                    LexingState before = (LexingState)CollectionsKt.first((Iterable)set2);
                    LexingState lexingState = longestToken.tokenType() == TokenDescriptor.TokenType.END_OF_FILE ? before : longestToken.nextLexingState();
                    String string2 = this.$indicatorGenerator.next();
                    if (this.$describers.element == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"describers");
                        list2 = null;
                    } else {
                        list2 = (List)this.$describers.element;
                    }
                    this.$groupedProblems.add(new ProblemsAtPosition(before, lexingState, string2, list2));
                    ExpectationsList.access$accumulateErrorsThen(this.this$0, this.$descendingIterator, this.$indicatorGenerator, this.$groupedProblems, this.$afterGrouping);
                }
            }));
        }

        public static final /* synthetic */ void access$reportGroupedErrors(ExpectationsList $this, List groupedProblems, String headerMessagePattern) {
            $this.reportGroupedErrors(groupedProblems, headerMessagePattern);
        }

        public static final /* synthetic */ void access$accumulateErrorsThen(ExpectationsList $this, Iterator descendingIterator, IndicatorGenerator indicatorGenerator, List groupedProblems, Function1 afterGrouping) {
            $this.accumulateErrorsThen(descendingIterator, indicatorGenerator, groupedProblems, (Function1<? super List<ProblemsAtPosition>, Unit>)afterGrouping);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0006\u001a\u00020\u0007H\u0086\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lavail/compiler/problems/CompilerDiagnostics$IndicatorGenerator;", "", "(Lavail/compiler/problems/CompilerDiagnostics;)V", "letterOffset", "", "supplementaryCounter", "next", "", "avail"})
    public final class IndicatorGenerator {
        private int letterOffset;
        private int supplementaryCounter;

        @NotNull
        public final String next() {
            int nextLetterOffset = CompilerDiagnostics.circledLetters.offsetByCodePoints(this.letterOffset, 1);
            String string2 = CompilerDiagnostics.circledLetters.substring(this.letterOffset, nextLetterOffset);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Object indicator = string2;
            if (this.supplementaryCounter > 0) {
                indicator = (String)indicator + this.supplementaryCounter + " ";
            }
            if (nextLetterOffset < CompilerDiagnostics.circledLetters.length()) {
                this.letterOffset = nextLetterOffset;
            } else {
                int n = this.supplementaryCounter;
                this.supplementaryCounter = n + 1;
            }
            return indicator;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000b0\u0010H\u0002J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J(\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J(\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lavail/compiler/problems/CompilerDiagnostics$Companion;", "", "()V", "circledLetters", "", "errorIndicatorSymbol", "getErrorIndicatorSymbol", "()Ljava/lang/String;", "expectationHeaderMessagePattern", "rowOfDashes", "findLongestTokenThen", "", "startLexingStates", "", "Lavail/compiler/scanning/LexingState;", "continuation", "Lkotlin/Function1;", "Lavail/descriptor/tokens/A_Token;", "firstIndexOf", "", "string", "Lavail/descriptor/tuples/A_String;", "codePoint", "startIndex", "endIndex", "lastIndexOf", "occurrencesInRange", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getErrorIndicatorSymbol() {
            return errorIndicatorSymbol;
        }

        /*
         * WARNING - void declaration
         */
        private final void findLongestTokenThen(Collection<LexingState> startLexingStates, Function1<? super A_Token, Unit> continuation) {
            Object v0;
            void $this$maxByOrNull$iv;
            Object state;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = startLexingStates;
            boolean $i$f$mapNotNull = false;
            void var6_6 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                List<A_Token> it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                LexingState it = (LexingState)element$iv$iv;
                boolean bl2 = false;
                if (it.getKnownToBeComputedTokensOrNull() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List candidates = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
            if (candidates.isEmpty()) {
                state = (LexingState)CollectionsKt.first((Iterable)startLexingStates);
                A_Token emptyToken = TokenDescriptor.Companion.newToken(TupleDescriptor.Companion.getEmptyTuple(), ((LexingState)state).getPosition(), ((LexingState)state).getLineNumber(), TokenDescriptor.TokenType.WHITESPACE, NilDescriptor.Companion.getNil());
                emptyToken.setNextLexingStateFromPrior((LexingState)state);
                continuation.invoke((Object)emptyToken.makeShared());
                return;
            }
            state = candidates;
            Function1<? super A_Token, Unit> function1 = continuation;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = maxElem$iv;
                } else {
                    A_Token it = (A_Token)maxElem$iv;
                    boolean bl = false;
                    int maxValue$iv = A_Tuple.Companion.getTupleSize(it.string());
                    do {
                        Object e$iv = iterator$iv.next();
                        A_Token it2 = (A_Token)e$iv;
                        $i$a$-maxByOrNull-CompilerDiagnostics$Companion$findLongestTokenThen$1 = false;
                        int v$iv = A_Tuple.Companion.getTupleSize(it2.string());
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = maxElem$iv;
                }
            }
            Intrinsics.checkNotNull(v0);
            function1.invoke(v0);
        }

        private final int firstIndexOf(A_String string2, int codePoint, int startIndex, int endIndex) {
            int i = startIndex;
            if (i <= endIndex) {
                while (true) {
                    if (A_Tuple.Companion.tupleCodePointAt(string2, i) == codePoint) {
                        return i;
                    }
                    if (i == endIndex) break;
                    ++i;
                }
            }
            return 0;
        }

        private final int lastIndexOf(A_String string2, int codePoint, int startIndex, int endIndex) {
            int i = startIndex;
            if (endIndex <= i) {
                while (true) {
                    if (A_Tuple.Companion.tupleCodePointAt(string2, i) == codePoint) {
                        return i;
                    }
                    if (i == endIndex) break;
                    --i;
                }
            }
            return 0;
        }

        private final int occurrencesInRange(A_String string2, int codePoint, int startIndex, int endIndex) {
            int count = 0;
            int i = startIndex;
            if (i <= endIndex) {
                while (true) {
                    if (A_Tuple.Companion.tupleCodePointAt(string2, i) == codePoint) {
                        ++count;
                    }
                    if (i == endIndex) break;
                    ++i;
                }
            }
            return count;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

