/*
 * Decompiled with CFR 0.152.
 */
package avail.descriptor.types;

import avail.annotations.ThreadSafe;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AbstractDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.Mutability;
import avail.descriptor.representation.ObjectSlotsEnum;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.BottomTypeDescriptor;
import avail.descriptor.types.InstanceMetaDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TypeDescriptor;
import avail.descriptor.types.TypeTag;
import avail.optimizer.jvm.CheckedMethod;
import avail.optimizer.jvm.ReferencedInGeneratedCode;
import avail.serialization.SerializerOperation;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.availlang.json.JSONWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 >2\u00020\u0001:\u0002>?B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0000H\u0016J\b\u0010\u0006\u001a\u00020\u0000H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\bH\u0016J\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u001c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010!\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\"\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010#\u001a\u00020\bH\u0016J \u0010$\u001a\u00020%2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u0012H\u0016J\u0018\u0010(\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010)\u001a\u00020\u0012H\u0016J\u0018\u0010*\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0018\u0010+\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0010\u0010,\u001a\u00020%2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010-\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0018\u0010.\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\bH\u0016J \u0010/\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u0012H\u0016J\u0018\u00100\u001a\u0002012\u0006\u0010\t\u001a\u00020\n2\u0006\u00102\u001a\u000203H\u0016J\u0018\u00104\u001a\u0002012\u0006\u0010\t\u001a\u00020\n2\u0006\u00102\u001a\u000203H\u0016J8\u00105\u001a\u0002012\u0006\u0010\t\u001a\u00020\n2\n\u00106\u001a\u000607j\u0002`82\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020;0:2\u0006\u0010<\u001a\u00020\u0012H\u0016J\b\u0010=\u001a\u00020\u0000H\u0016\u00a8\u0006@"}, d2={"Lavail/descriptor/types/TupleTypeDescriptor;", "Lavail/descriptor/types/TypeDescriptor;", "mutability", "Lavail/descriptor/representation/Mutability;", "(Lavail/descriptor/representation/Mutability;)V", "immutable", "mutable", "o_DefaultType", "Lavail/descriptor/types/A_Type;", "self", "Lavail/descriptor/representation/AvailObject;", "o_Equals", "", "another", "Lavail/descriptor/representation/A_BasicObject;", "o_EqualsTupleType", "aTupleType", "o_Hash", "", "o_IsBetterRepresentationThan", "anotherObject", "o_IsSubtypeOf", "aType", "o_IsSupertypeOfTupleType", "o_IsTupleType", "o_IsVacuousType", "o_MarshalToJava", "", "classHint", "Ljava/lang/Class;", "o_RepresentationCostOfTupleType", "o_SerializerOperation", "Lavail/serialization/SerializerOperation;", "o_SizeRange", "o_TrimType", "typeToRemove", "o_TupleOfTypesFromTo", "Lavail/descriptor/tuples/A_Tuple;", "startIndex", "endIndex", "o_TypeAtIndex", "index", "o_TypeIntersection", "o_TypeIntersectionOfTupleType", "o_TypeTuple", "o_TypeUnion", "o_TypeUnionOfTupleType", "o_UnionOfTypesAtThrough", "o_WriteSummaryTo", "", "writer", "Lorg/availlang/json/JSONWriter;", "o_WriteTo", "printObjectOnAvoidingIndent", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "recursionMap", "Ljava/util/IdentityHashMap;", "Ljava/lang/Void;", "indent", "shared", "Companion", "ObjectSlots", "avail"})
public final class TupleTypeDescriptor
extends TypeDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static CheckedMethod tupleTypesForTypesArrayMethod;
    @NotNull
    private static final CheckedMethod tupleTypesForTypesListMethod;
    @NotNull
    private static final TupleTypeDescriptor mutable;
    @NotNull
    private static final TupleTypeDescriptor immutable;
    @NotNull
    private static final TupleTypeDescriptor shared;
    @NotNull
    private static final A_Type mostGeneralTupleType;
    @NotNull
    private static final A_Type stringType;
    @NotNull
    private static final A_Type nonemptyStringType;
    @NotNull
    private static final A_Type tupleMeta;

    private TupleTypeDescriptor(Mutability mutability) {
        super(mutability, TypeTag.TUPLE_TYPE_TAG, TypeTag.TUPLE_TAG, ObjectSlots.class, null);
    }

    @Override
    public void printObjectOnAvoidingIndent(@NotNull AvailObject self, @NotNull StringBuilder builder2, @NotNull IdentityHashMap<A_BasicObject, Void> recursionMap, int indent) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter(recursionMap, (String)"recursionMap");
        if (A_Tuple.Companion.getTupleSize(self.slot(ObjectSlots.TYPE_TUPLE)) == 0 && self.slot(ObjectSlots.SIZE_RANGE).equals(IntegerRangeTypeDescriptor.Companion.getWholeNumbers())) {
            if (self.slot(ObjectSlots.DEFAULT_TYPE).equals(PrimitiveTypeDescriptor.Types.ANY.getO())) {
                builder2.append("tuple");
                return;
            }
            if (self.slot(ObjectSlots.DEFAULT_TYPE).equals(PrimitiveTypeDescriptor.Types.CHARACTER.getO())) {
                builder2.append("string");
                return;
            }
            builder2.append('<');
            A_Type.Companion.getDefaultType(self).printOnAvoidingIndent(builder2, recursionMap, indent + 1);
            builder2.append("\u2026|>");
            return;
        }
        builder2.append('<');
        int end = A_Tuple.Companion.getTupleSize(self.slot(ObjectSlots.TYPE_TUPLE));
        int i = 1;
        if (i <= end) {
            while (true) {
                A_Type.Companion.typeAtIndex(self, i).printOnAvoidingIndent(builder2, recursionMap, indent + 1);
                builder2.append(", ");
                if (i == end) break;
                ++i;
            }
        }
        self.slot(ObjectSlots.DEFAULT_TYPE).printOnAvoidingIndent(builder2, recursionMap, indent + 1);
        builder2.append("\u2026|");
        A_Type sizeRange = self.slot(ObjectSlots.SIZE_RANGE);
        A_Type.Companion.getLowerBound(sizeRange).printOnAvoidingIndent(builder2, recursionMap, indent + 1);
        if (!A_Type.Companion.getLowerBound(sizeRange).equals(A_Type.Companion.getUpperBound(sizeRange))) {
            builder2.append("..");
            A_Type.Companion.getUpperBound(sizeRange).printOnAvoidingIndent(builder2, recursionMap, indent + 1);
        }
        builder2.append('>');
    }

    @Override
    @NotNull
    public A_Type o_DefaultType(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return self.slot(ObjectSlots.DEFAULT_TYPE);
    }

    @Override
    public boolean o_Equals(@NotNull AvailObject self, @NotNull A_BasicObject another) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        return another.equalsTupleType(self);
    }

    @Override
    public boolean o_EqualsTupleType(@NotNull AvailObject self, @NotNull A_Type aTupleType) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)aTupleType, (String)"aTupleType");
        return self.sameAddressAs(aTupleType) || self.slot(ObjectSlots.SIZE_RANGE).equals(A_Type.Companion.getSizeRange(aTupleType)) && self.slot(ObjectSlots.DEFAULT_TYPE).equals(A_Type.Companion.getDefaultType(aTupleType)) && self.slot(ObjectSlots.TYPE_TUPLE).equals(A_Type.Companion.getTypeTuple(aTupleType));
    }

    @Override
    public boolean o_IsBetterRepresentationThan(@NotNull AvailObject self, @NotNull A_BasicObject anotherObject) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)anotherObject, (String)"anotherObject");
        return self.representationCostOfTupleType() < anotherObject.representationCostOfTupleType();
    }

    @Override
    public int o_RepresentationCostOfTupleType(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return 1;
    }

    @Override
    public int o_Hash(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return AvailObject.Companion.combine4(self.slot(ObjectSlots.SIZE_RANGE).hash(), self.slot(ObjectSlots.TYPE_TUPLE).hash(), self.slot(ObjectSlots.DEFAULT_TYPE).hash(), -1956603942);
    }

    @Override
    @NotNull
    public A_Type o_UnionOfTypesAtThrough(@NotNull AvailObject self, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        if (startIndex > endIndex) {
            return BottomTypeDescriptor.Companion.getBottom();
        }
        if (startIndex == endIndex) {
            return A_Type.Companion.typeAtIndex(self, startIndex);
        }
        A_Number upper = A_Type.Companion.getUpperBound(A_Type.Companion.getSizeRange(self));
        if (A_Number.Companion.greaterThan(IntegerDescriptor.Companion.fromInt(startIndex), upper)) {
            return BottomTypeDescriptor.Companion.getBottom();
        }
        A_Tuple leading = A_Type.Companion.getTypeTuple(self);
        int interestingLimit = A_Tuple.Companion.getTupleSize(leading) + 1;
        int clipStart = Math.max(Math.min(startIndex, interestingLimit), 1);
        int clipEnd = Math.max(Math.min(endIndex, interestingLimit), 1);
        A_Type typeUnion = A_Type.Companion.typeAtIndex(self, clipStart);
        int i = clipStart + 1;
        if (i <= clipEnd) {
            while (true) {
                typeUnion = A_Type.Companion.typeUnion(typeUnion, A_Type.Companion.typeAtIndex(self, i));
                if (i == clipEnd) break;
                ++i;
            }
        }
        return typeUnion;
    }

    @Override
    public boolean o_IsSubtypeOf(@NotNull AvailObject self, @NotNull A_Type aType) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)aType, (String)"aType");
        return A_Type.Companion.isSupertypeOfTupleType(aType, self);
    }

    @Override
    public boolean o_IsSupertypeOfTupleType(@NotNull AvailObject self, @NotNull A_Type aTupleType) {
        int n;
        int i;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)aTupleType, (String)"aTupleType");
        if (self.equals(aTupleType)) {
            return true;
        }
        if (!A_Type.Companion.isSubtypeOf(A_Type.Companion.getSizeRange(aTupleType), self.slot(ObjectSlots.SIZE_RANGE))) {
            return false;
        }
        A_Tuple subTuple = A_Type.Companion.getTypeTuple(aTupleType);
        A_Tuple superTuple = self.slot(ObjectSlots.TYPE_TUPLE);
        int end = Math.max(A_Tuple.Companion.getTupleSize(subTuple), A_Tuple.Companion.getTupleSize(superTuple)) + 1;
        A_Number smallUpper = A_Type.Companion.getUpperBound(A_Type.Companion.getSizeRange(aTupleType));
        if (A_Number.Companion.isInt(smallUpper)) {
            end = Math.min(end, A_Number.Companion.getExtractInt(smallUpper));
        }
        if ((i = 1) <= (n = end)) {
            while (true) {
                A_Type superType;
                A_Type subType = i <= A_Tuple.Companion.getTupleSize(subTuple) ? (A_Type)A_Tuple.Companion.tupleAt(subTuple, i) : A_Type.Companion.getDefaultType(aTupleType);
                A_Type a_Type = superType = i <= A_Tuple.Companion.getTupleSize(superTuple) ? (A_Type)A_Tuple.Companion.tupleAt(superTuple, i) : (A_Type)self.slot(ObjectSlots.DEFAULT_TYPE);
                if (!A_Type.Companion.isSubtypeOf(subType, superType)) {
                    return false;
                }
                if (i == n) break;
                ++i;
            }
        }
        return true;
    }

    @Override
    public boolean o_IsTupleType(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return true;
    }

    @Override
    public boolean o_IsVacuousType(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        A_Number minSizeObject = A_Type.Companion.getLowerBound(A_Type.Companion.getSizeRange(self));
        if (!A_Number.Companion.isInt(minSizeObject)) {
            return false;
        }
        int i = 1;
        int minSize = Math.min(A_Number.Companion.getExtractInt(minSizeObject), A_Tuple.Companion.getTupleSize(self.slot(ObjectSlots.TYPE_TUPLE)) + 1);
        if (i <= minSize) {
            while (true) {
                if (A_Type.Companion.typeAtIndex(self, i).isVacuousType()) {
                    return true;
                }
                if (i == minSize) break;
                ++i;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public Object o_MarshalToJava(@NotNull AvailObject self, @Nullable Class<?> classHint) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return A_Type.Companion.isSubtypeOf(self, stringType) ? String.class : super.o_MarshalToJava(self, classHint);
    }

    @Override
    @ThreadSafe
    @NotNull
    public SerializerOperation o_SerializerOperation(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return SerializerOperation.TUPLE_TYPE;
    }

    @Override
    @NotNull
    public A_Type o_SizeRange(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return self.slot(ObjectSlots.SIZE_RANGE);
    }

    @Override
    @NotNull
    public A_Type o_TrimType(@NotNull AvailObject self, @NotNull A_Type typeToRemove) {
        int n;
        Object object;
        A_Type defaultType;
        A_Tuple leadingTypes;
        A_Type sizeRange;
        block12: {
            Intrinsics.checkNotNullParameter((Object)self, (String)"self");
            Intrinsics.checkNotNullParameter((Object)typeToRemove, (String)"typeToRemove");
            if (!A_Type.Companion.isSubtypeOf(A_Type.Companion.getSizeRange(self), IntegerRangeTypeDescriptor.Companion.getInt32())) {
                self.makeImmutable();
                return A_Type.Companion.trimType(Companion.tupleTypeForSizesTypesDefaultType(A_Type.Companion.typeIntersection(A_Type.Companion.getSizeRange(self), IntegerRangeTypeDescriptor.Companion.getInt32()), A_Type.Companion.getTypeTuple(self), A_Type.Companion.getDefaultType(self)), typeToRemove);
            }
            if (A_Type.Companion.isSubtypeOf(self, typeToRemove)) {
                return BottomTypeDescriptor.Companion.getBottom();
            }
            if (!typeToRemove.isTupleType()) {
                return self;
            }
            if (typeToRemove.isEnumeration()) {
                return self;
            }
            self.makeImmutable();
            typeToRemove.makeImmutable();
            if (!A_Type.Companion.isSubtypeOf(A_Type.Companion.getSizeRange(typeToRemove), IntegerRangeTypeDescriptor.Companion.getInt32())) {
                return A_Type.Companion.trimType(self, Companion.tupleTypeForSizesTypesDefaultType(A_Type.Companion.typeIntersection(A_Type.Companion.getSizeRange(typeToRemove), IntegerRangeTypeDescriptor.Companion.getInt32()), A_Type.Companion.getTypeTuple(typeToRemove), A_Type.Companion.getDefaultType(typeToRemove)));
            }
            sizeRange = A_Type.Companion.getSizeRange(self);
            leadingTypes = A_Type.Companion.getTypeTuple(self);
            defaultType = A_Type.Companion.getDefaultType(self);
            A_Tuple removedLeadingTypes = A_Type.Companion.getTypeTuple(typeToRemove);
            int variationLimit = Math.max(A_Tuple.Companion.getTupleSize(leadingTypes), A_Tuple.Companion.getTupleSize(removedLeadingTypes)) + 1;
            Iterable $this$indexOfFirst$iv = (Iterable)new IntRange(1, variationLimit);
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            object = $this$indexOfFirst$iv.iterator();
            while (object.hasNext()) {
                int item$iv = ((IntIterator)object).nextInt();
                if (index$iv < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int i = item$iv;
                boolean bl = false;
                if (!A_Type.Companion.isSubtypeOf(A_Type.Companion.typeAtIndex(self, i), A_Type.Companion.typeAtIndex(typeToRemove, i))) {
                    n = index$iv;
                    break block12;
                }
                ++index$iv;
            }
            n = -1;
        }
        int firstVariation = n + 1;
        A_Type removedSizeRange = A_Type.Companion.getSizeRange(typeToRemove);
        if (firstVariation == 0) {
            return Companion.tupleTypeForSizesTypesDefaultType(A_Type.Companion.trimType(sizeRange, removedSizeRange), leadingTypes, defaultType);
        }
        A_Type permittedSizes = A_Type.Companion.trimType(sizeRange, IntegerRangeTypeDescriptor.Companion.inclusive(A_Number.Companion.getExtractLong(A_Type.Companion.getLowerBound(removedSizeRange)), firstVariation - 1));
        if (!permittedSizes.equals(sizeRange)) {
            return Companion.tupleTypeForSizesTypesDefaultType(permittedSizes, leadingTypes, defaultType);
        }
        if (A_Number.Companion.equalsInt(A_Type.Companion.getUpperBound(sizeRange), 1)) {
            boolean bl;
            boolean bl2 = bl = A_Tuple.Companion.getTupleSize(leadingTypes) == 0;
            if (_Assertions.ENABLED && !bl) {
                object = "Assertion failed";
                throw new AssertionError(object);
            }
            return Companion.tupleTypeForSizesTypesDefaultType(A_Number.Companion.equalsInt(A_Type.Companion.getLowerBound(removedSizeRange), 0) ? IntegerRangeTypeDescriptor.Companion.singleInt(1) : sizeRange, TupleDescriptor.Companion.getEmptyTuple(), A_Type.Companion.trimType(defaultType, A_Type.Companion.typeAtIndex(typeToRemove, 1)));
        }
        return self;
    }

    @Override
    @NotNull
    public A_Tuple o_TupleOfTypesFromTo(@NotNull AvailObject self, int startIndex, int endIndex) {
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        boolean bl3 = bl2 = startIndex >= 1;
        if (_Assertions.ENABLED && !bl2) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int size = endIndex - startIndex + 1;
        boolean bl4 = bl = size >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        return ObjectTupleDescriptor.Companion.generateObjectTupleFrom(size, (Function1<? super Integer, ? extends A_BasicObject>)((Function1)new Function1<Integer, A_BasicObject>(size, self, startIndex){
            final /* synthetic */ int $size;
            final /* synthetic */ AvailObject $self;
            final /* synthetic */ int $startIndex;
            {
                this.$size = $size;
                this.$self = $self;
                this.$startIndex = $startIndex;
                super(1);
            }

            @NotNull
            public final A_BasicObject invoke(int it) {
                return it > this.$size ? (A_BasicObject)BottomTypeDescriptor.Companion.getBottom() : (A_BasicObject)A_Type.Companion.typeAtIndex(this.$self, it + this.$startIndex - 1).makeImmutable();
            }
        }));
    }

    @Override
    @NotNull
    public A_Type o_TypeAtIndex(@NotNull AvailObject self, int index2) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        if (index2 <= 0) {
            return BottomTypeDescriptor.Companion.getBottom();
        }
        A_Number upper = A_Type.Companion.getUpperBound(self.slot(ObjectSlots.SIZE_RANGE));
        if (A_Number.Companion.isInt(upper) ? A_Number.Companion.getExtractInt(upper) < index2 : A_Number.Companion.lessThan(upper, IntegerDescriptor.Companion.fromInt(index2))) {
            return BottomTypeDescriptor.Companion.getBottom();
        }
        A_Tuple leading = self.slot(ObjectSlots.TYPE_TUPLE);
        return index2 <= A_Tuple.Companion.getTupleSize(leading) ? (A_Type)A_Tuple.Companion.tupleAt(leading, index2) : (A_Type)self.slot(ObjectSlots.DEFAULT_TYPE);
    }

    @Override
    @NotNull
    public A_Type o_TypeIntersection(@NotNull AvailObject self, @NotNull A_Type another) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        return A_Type.Companion.isSubtypeOf(self, another) ? (A_Type)self : (A_Type.Companion.isSubtypeOf(another, self) ? another : A_Type.Companion.typeIntersectionOfTupleType(another, self));
    }

    @Override
    @NotNull
    public A_Type o_TypeIntersectionOfTupleType(@NotNull AvailObject self, @NotNull A_Type aTupleType) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)aTupleType, (String)"aTupleType");
        A_Type newSizesObject = A_Type.Companion.typeIntersection(self.slot(ObjectSlots.SIZE_RANGE), A_Type.Companion.getSizeRange(aTupleType));
        A_Tuple lead1 = self.slot(ObjectSlots.TYPE_TUPLE);
        A_Tuple lead2 = A_Type.Companion.getTypeTuple(aTupleType);
        A_Tuple newLeading = null;
        newLeading = A_Tuple.Companion.getTupleSize(lead1) > A_Tuple.Companion.getTupleSize(lead2) ? lead1 : lead2;
        newLeading.makeImmutable();
        int newLeadingSize = A_Tuple.Companion.getTupleSize(newLeading);
        int i = 1;
        if (i <= newLeadingSize) {
            while (true) {
                A_Type intersectionObject;
                if ((intersectionObject = A_Type.Companion.typeIntersection(A_Type.Companion.typeAtIndex(self, i), A_Type.Companion.typeAtIndex(aTupleType, i))).isBottom()) {
                    return BottomTypeDescriptor.Companion.getBottom();
                }
                newLeading = A_Tuple.Companion.tupleAtPuttingCanDestroy(newLeading, i, intersectionObject, true);
                if (i == newLeadingSize) break;
                ++i;
            }
        }
        newLeading.makeSubobjectsImmutable();
        A_Type newDefault = A_Type.Companion.typeIntersection(A_Type.Companion.typeAtIndex(self, newLeadingSize + 1), A_Type.Companion.typeAtIndex(aTupleType, newLeadingSize + 1));
        if (newDefault.isBottom()) {
            A_Number newLeadingSizeObject = IntegerDescriptor.Companion.fromInt(newLeadingSize);
            if (A_Number.Companion.lessThan(newLeadingSizeObject, A_Type.Companion.getLowerBound(newSizesObject))) {
                return BottomTypeDescriptor.Companion.getBottom();
            }
            if (A_Number.Companion.lessThan(newLeadingSizeObject, A_Type.Companion.getUpperBound(newSizesObject))) {
                newSizesObject = IntegerRangeTypeDescriptor.Companion.integerRangeType(A_Type.Companion.getLowerBound(newSizesObject), A_Type.Companion.getLowerInclusive(newSizesObject), newLeadingSizeObject, true);
            }
        }
        return Companion.tupleTypeForSizesTypesDefaultType(newSizesObject, newLeading, newDefault.makeImmutable());
    }

    @Override
    @NotNull
    public A_Tuple o_TypeTuple(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return self.slot(ObjectSlots.TYPE_TUPLE);
    }

    @Override
    @NotNull
    public A_Type o_TypeUnion(@NotNull AvailObject self, @NotNull A_Type another) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        return A_Type.Companion.isSubtypeOf(self, another) ? another : (A_Type.Companion.isSubtypeOf(another, self) ? (A_Type)self : A_Type.Companion.typeUnionOfTupleType(another, self));
    }

    @Override
    @NotNull
    public A_Type o_TypeUnionOfTupleType(@NotNull AvailObject self, @NotNull A_Type aTupleType) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)aTupleType, (String)"aTupleType");
        A_Type newSizesObject = A_Type.Companion.typeUnion(self.slot(ObjectSlots.SIZE_RANGE), A_Type.Companion.getSizeRange(aTupleType));
        A_Tuple lead1 = self.slot(ObjectSlots.TYPE_TUPLE);
        A_Tuple lead2 = A_Type.Companion.getTypeTuple(aTupleType);
        A_Tuple newLeading = null;
        newLeading = A_Tuple.Companion.getTupleSize(lead1) > A_Tuple.Companion.getTupleSize(lead2) ? lead1 : lead2;
        newLeading.makeImmutable();
        int newLeadingSize = A_Tuple.Companion.getTupleSize(newLeading);
        int i = 1;
        if (i <= newLeadingSize) {
            while (true) {
                A_Type unionObject = A_Type.Companion.typeUnion(A_Type.Companion.typeAtIndex(self, i), A_Type.Companion.typeAtIndex(aTupleType, i));
                newLeading = A_Tuple.Companion.tupleAtPuttingCanDestroy(newLeading, i, unionObject, true);
                if (i == newLeadingSize) break;
                ++i;
            }
        }
        newLeading.makeSubobjectsImmutable();
        A_Type newDefault = A_Type.Companion.typeUnion(A_Type.Companion.typeAtIndex(self, newLeadingSize + 1), A_Type.Companion.typeAtIndex(aTupleType, newLeadingSize + 1));
        newDefault.makeImmutable();
        return Companion.tupleTypeForSizesTypesDefaultType(newSizesObject, newLeading, newDefault);
    }

    @Override
    public void o_WriteTo(@NotNull AvailObject self, @NotNull JSONWriter writer) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.startObject();
        writer.write("kind");
        writer.write("tuple type");
        writer.write("leading types");
        self.slot(ObjectSlots.TYPE_TUPLE).writeTo(writer);
        writer.write("default type");
        self.slot(ObjectSlots.DEFAULT_TYPE).writeTo(writer);
        writer.write("cardinality");
        self.slot(ObjectSlots.SIZE_RANGE).writeTo(writer);
        writer.endObject();
    }

    @Override
    public void o_WriteSummaryTo(@NotNull AvailObject self, @NotNull JSONWriter writer) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.startObject();
        writer.write("kind");
        writer.write("tuple type");
        writer.write("leading types");
        self.slot(ObjectSlots.TYPE_TUPLE).writeSummaryTo(writer);
        writer.write("default type");
        self.slot(ObjectSlots.DEFAULT_TYPE).writeSummaryTo(writer);
        writer.write("cardinality");
        self.slot(ObjectSlots.SIZE_RANGE).writeSummaryTo(writer);
        writer.endObject();
    }

    @Override
    @NotNull
    public TupleTypeDescriptor mutable() {
        return mutable;
    }

    @Override
    @NotNull
    public TupleTypeDescriptor immutable() {
        return immutable;
    }

    @Override
    @NotNull
    public TupleTypeDescriptor shared() {
        return shared;
    }

    @ReferencedInGeneratedCode
    @JvmStatic
    @NotNull
    public static final A_Type tupleTypeForTypes(A_Type ... types) {
        return Companion.tupleTypeForTypes(types);
    }

    @ReferencedInGeneratedCode
    @JvmStatic
    @NotNull
    public static final A_Type tupleTypeForTypesList(@NotNull List<? extends A_Type> types) {
        return Companion.tupleTypeForTypesList(types);
    }

    static {
        Class[] classArray = new Class[]{A_Type[].class};
        tupleTypesForTypesArrayMethod = CheckedMethod.Companion.staticMethod(TupleTypeDescriptor.class, "tupleTypeForTypes", A_Type.class, classArray);
        classArray = new Class[]{List.class};
        tupleTypesForTypesListMethod = CheckedMethod.Companion.staticMethod(TupleTypeDescriptor.class, "tupleTypeForTypesList", A_Type.class, classArray);
        mutable = new TupleTypeDescriptor(Mutability.MUTABLE);
        immutable = new TupleTypeDescriptor(Mutability.IMMUTABLE);
        shared = new TupleTypeDescriptor(Mutability.SHARED);
        mostGeneralTupleType = Companion.zeroOrMoreOf(PrimitiveTypeDescriptor.Types.ANY.getO()).makeShared();
        stringType = Companion.zeroOrMoreOf(PrimitiveTypeDescriptor.Types.CHARACTER.getO()).makeShared();
        nonemptyStringType = Companion.oneOrMoreOf(PrimitiveTypeDescriptor.Types.CHARACTER.getO()).makeShared();
        tupleMeta = InstanceMetaDescriptor.Companion.instanceMeta(mostGeneralTupleType).makeShared();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lavail/descriptor/types/TupleTypeDescriptor$ObjectSlots;", "", "Lavail/descriptor/representation/ObjectSlotsEnum;", "(Ljava/lang/String;I)V", "SIZE_RANGE", "TYPE_TUPLE", "DEFAULT_TYPE", "avail"})
    public static final class ObjectSlots
    extends Enum<ObjectSlots>
    implements ObjectSlotsEnum {
        public static final /* enum */ ObjectSlots SIZE_RANGE = new ObjectSlots();
        public static final /* enum */ ObjectSlots TYPE_TUPLE = new ObjectSlots();
        public static final /* enum */ ObjectSlots DEFAULT_TYPE = new ObjectSlots();
        private static final /* synthetic */ ObjectSlots[] $VALUES;

        public static ObjectSlots[] values() {
            return (ObjectSlots[])$VALUES.clone();
        }

        public static ObjectSlots valueOf(String value) {
            return Enum.valueOf(ObjectSlots.class, value);
        }

        static {
            $VALUES = objectSlotsArray = new ObjectSlots[]{ObjectSlots.SIZE_RANGE, ObjectSlots.TYPE_TUPLE, ObjectSlots.DEFAULT_TYPE};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u001dJ\u000e\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0006J \u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0006H\u0002J\u001e\u0010%\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0006J!\u0010&\u001a\u00020\u00062\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060(\"\u00020\u0006H\u0007\u00a2\u0006\u0002\u0010)J\u0016\u0010*\u001a\u00020\u00062\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00060+H\u0007J\u000e\u0010,\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0006J\u000e\u0010-\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0011\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\u00020\u0012\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0018\u0010\u0002\u001a\u0004\b\u0019\u0010\u0014\u00a8\u0006."}, d2={"Lavail/descriptor/types/TupleTypeDescriptor$Companion;", "", "()V", "immutable", "Lavail/descriptor/types/TupleTypeDescriptor;", "mostGeneralTupleType", "Lavail/descriptor/types/A_Type;", "getMostGeneralTupleType", "()Lavail/descriptor/types/A_Type;", "mutable", "nonemptyStringType", "getNonemptyStringType", "shared", "stringType", "getStringType", "tupleMeta", "getTupleMeta", "tupleTypesForTypesArrayMethod", "Lavail/optimizer/jvm/CheckedMethod;", "getTupleTypesForTypesArrayMethod", "()Lavail/optimizer/jvm/CheckedMethod;", "setTupleTypesForTypesArrayMethod", "(Lavail/optimizer/jvm/CheckedMethod;)V", "tupleTypesForTypesListMethod", "getTupleTypesForTypesListMethod$annotations", "getTupleTypesForTypesListMethod", "mappingElementTypes", "aTupleType", "elementTransformer", "Lkotlin/Function1;", "oneOrMoreOf", "aType", "privateTupleTypeForSizesTypesDefaultType", "sizeRange", "typeTuple", "Lavail/descriptor/tuples/A_Tuple;", "defaultType", "tupleTypeForSizesTypesDefaultType", "tupleTypeForTypes", "types", "", "([Lavail/descriptor/types/A_Type;)Lavail/descriptor/types/A_Type;", "tupleTypeForTypesList", "", "zeroOrMoreOf", "zeroOrOneOf", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final A_Type tupleTypeForSizesTypesDefaultType(@NotNull A_Type sizeRange, @NotNull A_Tuple typeTuple2, @NotNull A_Type defaultType) {
            Intrinsics.checkNotNullParameter((Object)sizeRange, (String)"sizeRange");
            Intrinsics.checkNotNullParameter((Object)typeTuple2, (String)"typeTuple");
            Intrinsics.checkNotNullParameter((Object)defaultType, (String)"defaultType");
            if (sizeRange.isBottom()) {
                return BottomTypeDescriptor.Companion.getBottom();
            }
            boolean bl = A_Type.Companion.getLowerBound(sizeRange).isFinite();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            boolean bl2 = bl = A_Type.Companion.getUpperBound(sizeRange).isFinite() || !A_Type.Companion.getUpperInclusive(sizeRange);
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            if (A_Number.Companion.equalsInt(A_Type.Companion.getUpperBound(sizeRange), 0) && A_Number.Companion.equalsInt(A_Type.Companion.getLowerBound(sizeRange), 0)) {
                return this.privateTupleTypeForSizesTypesDefaultType(sizeRange, TupleDescriptor.Companion.getEmptyTuple(), BottomTypeDescriptor.Companion.getBottom());
            }
            int typeTupleSize = A_Tuple.Companion.getTupleSize(typeTuple2);
            if (A_Number.Companion.greaterOrEqual(IntegerDescriptor.Companion.fromInt(typeTupleSize), A_Type.Companion.getUpperBound(sizeRange))) {
                int upper = A_Number.Companion.getExtractInt(A_Type.Companion.getUpperBound(sizeRange));
                return this.tupleTypeForSizesTypesDefaultType(sizeRange, A_Tuple.Companion.copyTupleFromToCanDestroy(typeTuple2, 1, upper - 1, false), A_Tuple.Companion.tupleAt(typeTuple2, upper).makeImmutable());
            }
            if (typeTupleSize > 0 && A_Tuple.Companion.tupleAt(typeTuple2, typeTupleSize).equals(defaultType)) {
                int index2;
                for (index2 = typeTupleSize - 1; index2 > 0 && A_Tuple.Companion.tupleAt(typeTuple2, index2).equals(defaultType); --index2) {
                }
                return this.tupleTypeForSizesTypesDefaultType(sizeRange, A_Tuple.Companion.copyTupleFromToCanDestroy(typeTuple2, 1, index2, false), defaultType);
            }
            return this.privateTupleTypeForSizesTypesDefaultType(sizeRange, typeTuple2, defaultType);
        }

        @NotNull
        public final A_Type zeroOrOneOf(@NotNull A_Type aType) {
            Intrinsics.checkNotNullParameter((Object)aType, (String)"aType");
            return this.tupleTypeForSizesTypesDefaultType(IntegerRangeTypeDescriptor.Companion.getZeroOrOne(), TupleDescriptor.Companion.getEmptyTuple(), aType);
        }

        @NotNull
        public final A_Type zeroOrMoreOf(@NotNull A_Type aType) {
            Intrinsics.checkNotNullParameter((Object)aType, (String)"aType");
            return this.tupleTypeForSizesTypesDefaultType(IntegerRangeTypeDescriptor.Companion.getWholeNumbers(), TupleDescriptor.Companion.getEmptyTuple(), aType);
        }

        @NotNull
        public final A_Type oneOrMoreOf(@NotNull A_Type aType) {
            Intrinsics.checkNotNullParameter((Object)aType, (String)"aType");
            return this.tupleTypeForSizesTypesDefaultType(IntegerRangeTypeDescriptor.Companion.getNaturalNumbers(), TupleDescriptor.Companion.getEmptyTuple(), aType);
        }

        @ReferencedInGeneratedCode
        @JvmStatic
        @NotNull
        public final A_Type tupleTypeForTypes(A_Type ... types) {
            Intrinsics.checkNotNullParameter((Object)types, (String)"types");
            return this.tupleTypeForSizesTypesDefaultType(IntegerRangeTypeDescriptor.Companion.singleInt(types.length), ObjectTupleDescriptor.Companion.tupleFromArray(Arrays.copyOf(types, types.length)), BottomTypeDescriptor.Companion.getBottom());
        }

        @NotNull
        public final CheckedMethod getTupleTypesForTypesArrayMethod() {
            return tupleTypesForTypesArrayMethod;
        }

        public final void setTupleTypesForTypesArrayMethod(@NotNull CheckedMethod checkedMethod) {
            Intrinsics.checkNotNullParameter((Object)checkedMethod, (String)"<set-?>");
            tupleTypesForTypesArrayMethod = checkedMethod;
        }

        @ReferencedInGeneratedCode
        @JvmStatic
        @NotNull
        public final A_Type tupleTypeForTypesList(@NotNull List<? extends A_Type> types) {
            Intrinsics.checkNotNullParameter(types, (String)"types");
            return this.tupleTypeForSizesTypesDefaultType(IntegerRangeTypeDescriptor.Companion.singleInt(types.size()), ObjectTupleDescriptor.Companion.tupleFromList(types), BottomTypeDescriptor.Companion.getBottom());
        }

        @NotNull
        public final CheckedMethod getTupleTypesForTypesListMethod() {
            return tupleTypesForTypesListMethod;
        }

        public static /* synthetic */ void getTupleTypesForTypesListMethod$annotations() {
        }

        @NotNull
        public final A_Type mappingElementTypes(@NotNull A_Type aTupleType, @NotNull Function1<? super A_Type, ? extends A_Type> elementTransformer) {
            Intrinsics.checkNotNullParameter((Object)aTupleType, (String)"aTupleType");
            Intrinsics.checkNotNullParameter(elementTransformer, (String)"elementTransformer");
            A_Type sizeRange = A_Type.Companion.getSizeRange(aTupleType);
            A_Tuple typeTuple2 = A_Type.Companion.getTypeTuple(aTupleType);
            A_Type defaultType = A_Type.Companion.getDefaultType(aTupleType);
            int limit = A_Tuple.Companion.getTupleSize(typeTuple2);
            A_Tuple transformedTypeTuple2 = ObjectTupleDescriptor.Companion.generateObjectTupleFrom(limit, (Function1<? super Integer, ? extends A_BasicObject>)((Function1)new Function1<Integer, A_BasicObject>(elementTransformer, typeTuple2){
                final /* synthetic */ Function1<A_Type, A_Type> $elementTransformer;
                final /* synthetic */ A_Tuple $typeTuple;
                {
                    this.$elementTransformer = $elementTransformer;
                    this.$typeTuple = $typeTuple;
                    super(1);
                }

                @NotNull
                public final A_BasicObject invoke(int it) {
                    return (A_BasicObject)this.$elementTransformer.invoke((Object)A_Tuple.Companion.tupleAt(this.$typeTuple, it));
                }
            }));
            A_Type transformedDefaultType = (A_Type)elementTransformer.invoke((Object)defaultType);
            return this.tupleTypeForSizesTypesDefaultType(sizeRange, transformedTypeTuple2, transformedDefaultType);
        }

        private final A_Type privateTupleTypeForSizesTypesDefaultType(A_Type sizeRange, A_Tuple typeTuple2, A_Type defaultType) {
            AvailObject availObject;
            boolean bl = A_Type.Companion.getLowerBound(sizeRange).isFinite();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            boolean bl2 = bl = A_Type.Companion.getUpperBound(sizeRange).isFinite() || !A_Type.Companion.getUpperInclusive(sizeRange);
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            boolean bl3 = bl = A_Number.Companion.getExtractInt(A_Type.Companion.getLowerBound(sizeRange)) >= 0;
            if (_Assertions.ENABLED && !bl) {
                String string4 = "Assertion failed";
                throw new AssertionError((Object)string4);
            }
            A_Type sizeRangeKind = sizeRange.isEnumeration() ? A_Type.Companion.computeSuperkind(sizeRange) : sizeRange;
            int i = 1;
            int limit = Math.min(A_Number.Companion.getExtractInt(A_Type.Companion.getLowerBound(sizeRangeKind)), A_Tuple.Companion.getTupleSize(typeTuple2));
            if (i <= limit) {
                while (true) {
                    boolean bl4 = A_Tuple.Companion.tupleAt(typeTuple2, i).isType();
                    if (_Assertions.ENABLED && !bl4) {
                        String string5 = "Assertion failed";
                        throw new AssertionError((Object)string5);
                    }
                    if (i == limit) break;
                    ++i;
                }
            }
            AbstractDescriptor $this$iv = mutable;
            int indexedSlotCount$iv = 0;
            boolean $i$f$create = false;
            AvailObject $this$privateTupleTypeForSizesTypesDefaultType_u24lambda_u2d0 = availObject = AvailObject.Companion.newIndexedDescriptor(indexedSlotCount$iv, $this$iv);
            boolean bl5 = false;
            $this$privateTupleTypeForSizesTypesDefaultType_u24lambda_u2d0.setSlot(ObjectSlots.SIZE_RANGE, sizeRangeKind);
            $this$privateTupleTypeForSizesTypesDefaultType_u24lambda_u2d0.setSlot(ObjectSlots.TYPE_TUPLE, typeTuple2);
            $this$privateTupleTypeForSizesTypesDefaultType_u24lambda_u2d0.setSlot(ObjectSlots.DEFAULT_TYPE, defaultType);
            return availObject;
        }

        @NotNull
        public final A_Type getMostGeneralTupleType() {
            return mostGeneralTupleType;
        }

        @NotNull
        public final A_Type getStringType() {
            return stringType;
        }

        @NotNull
        public final A_Type getNonemptyStringType() {
            return nonemptyStringType;
        }

        @NotNull
        public final A_Type getTupleMeta() {
            return tupleMeta;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

