/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo.operand;

import avail.descriptor.representation.AvailObject;
import avail.descriptor.types.A_Type;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2Operation;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2PcOperand;
import avail.interpreter.levelTwo.operand.L2WriteBoxedOperand;
import avail.interpreter.levelTwo.operand.L2WriteOperand;
import avail.interpreter.levelTwo.operand.TypeRestriction;
import avail.interpreter.levelTwo.operation.L2_MAKE_IMMUTABLE;
import avail.interpreter.levelTwo.operation.L2_MOVE;
import avail.interpreter.levelTwo.register.L2Register;
import avail.optimizer.L2BasicBlock;
import avail.optimizer.L2Synonym;
import avail.optimizer.L2ValueManifest;
import avail.optimizer.values.L2SemanticValue;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u001f\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\u000f\u001a\u00020\u00102\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00000\u0012H\u0016J\u0016\u0010\u0013\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016J\u0014\u0010\u0015\u001a\u00020\u00102\n\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018H\u0016J\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u001c\u001a\u00020\u0002H&J\r\u0010\u001d\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u001eJ\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000 J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020&J\u0018\u0010'\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050)\u0012\u0004\u0012\u00020\u00070(J\u0010\u0010*\u001a\u00020\u00102\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u00102\u0006\u0010.\u001a\u00020\"H\u0016J\b\u0010/\u001a\u00020\u0010H\u0016J\u000e\u00100\u001a\u0002012\u0006\u0010#\u001a\u00020$J\b\u00102\u001a\u00020\u0010H\u0016J\u000b\u0010\b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001eJ\u0006\u00103\u001a\u000204J$\u00105\u001a\u00020\u00102\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002072\u0006\u00108\u001a\u00020\"H\u0016J\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010\u0004\u001a\u00020\u0005H\u0016J(\u00109\u001a\u0006\u0012\u0002\b\u00030\u00002\u001a\u0010:\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0000\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00000;H\u0016J\u0006\u0010<\u001a\u00020=R\u0010\u0010\b\u001a\u00028\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lavail/interpreter/levelTwo/operand/L2ReadOperand;", "R", "Lavail/interpreter/levelTwo/register/L2Register;", "Lavail/interpreter/levelTwo/operand/L2Operand;", "semanticValue", "Lavail/optimizer/values/L2SemanticValue;", "restriction", "Lavail/interpreter/levelTwo/operand/TypeRestriction;", "register", "(Lavail/optimizer/values/L2SemanticValue;Lavail/interpreter/levelTwo/operand/TypeRestriction;Lavail/interpreter/levelTwo/register/L2Register;)V", "Lavail/interpreter/levelTwo/register/L2Register;", "registerKind", "Lavail/interpreter/levelTwo/register/L2Register$RegisterKind;", "getRegisterKind", "()Lavail/interpreter/levelTwo/register/L2Register$RegisterKind;", "addReadsTo", "", "readOperands", "", "addSourceRegistersTo", "sourceRegisters", "appendTo", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "constantOrNull", "Lavail/descriptor/representation/AvailObject;", "copyForRegister", "newRegister", "createNewRegister", "()Lavail/interpreter/levelTwo/register/L2Register;", "definition", "Lavail/interpreter/levelTwo/operand/L2WriteOperand;", "definitionSkippingMoves", "Lavail/interpreter/levelTwo/L2Instruction;", "bypassImmutables", "", "finalIndex", "", "findSourceInformation", "Lkotlin/Pair;", "", "instructionWasAdded", "manifest", "Lavail/optimizer/L2ValueManifest;", "instructionWasInserted", "newInstruction", "instructionWasRemoved", "originalBoxedWriteSkippingMoves", "Lavail/interpreter/levelTwo/operand/L2WriteBoxedOperand;", "postOptimizationCleanup", "registerString", "", "replaceRegisters", "registerRemap", "", "theInstruction", "transformEachRead", "transformer", "Lkotlin/Function1;", "type", "Lavail/descriptor/types/A_Type;", "avail"})
public abstract class L2ReadOperand<R extends L2Register>
extends L2Operand {
    @NotNull
    private L2SemanticValue semanticValue;
    @NotNull
    private TypeRestriction restriction;
    @NotNull
    private R register;

    protected L2ReadOperand(@NotNull L2SemanticValue semanticValue, @NotNull TypeRestriction restriction, @NotNull R register) {
        Intrinsics.checkNotNullParameter((Object)semanticValue, (String)"semanticValue");
        Intrinsics.checkNotNullParameter((Object)restriction, (String)"restriction");
        Intrinsics.checkNotNullParameter(register, (String)"register");
        this.semanticValue = semanticValue;
        this.restriction = restriction;
        this.register = register;
    }

    @NotNull
    public L2SemanticValue semanticValue() {
        return this.semanticValue;
    }

    @NotNull
    public final R register() {
        return this.register;
    }

    @NotNull
    public final String registerString() {
        return this.register + "[" + this.semanticValue + "]";
    }

    public final int finalIndex() {
        return ((L2Register)this.register()).finalIndex();
    }

    @NotNull
    public final TypeRestriction restriction() {
        return this.restriction;
    }

    @NotNull
    public final A_Type type() {
        return this.restriction.getType();
    }

    @Nullable
    public final AvailObject constantOrNull() {
        return this.restriction.getConstantOrNull();
    }

    @NotNull
    public abstract L2Register.RegisterKind getRegisterKind();

    @NotNull
    public final L2WriteOperand<R> definition() {
        L2WriteOperand<?> $this$cast$iv = ((L2Register)this.register).definition();
        boolean $i$f$cast = false;
        return (L2WriteOperand)((Object)$this$cast$iv);
    }

    @Override
    public void instructionWasAdded(@NotNull L2ValueManifest manifest2) {
        Intrinsics.checkNotNullParameter((Object)manifest2, (String)"manifest");
        super.instructionWasAdded(manifest2);
        TypeRestriction manifestRestriction = manifest2.restrictionFor(this.semanticValue);
        TypeRestriction intersection = null;
        intersection = this.restriction.intersection(manifestRestriction);
        if (intersection.getFlags() != manifestRestriction.getFlags()) {
            TypeRestriction.RestrictionFlagEncoding[] $this$forEach$iv = TypeRestriction.RestrictionFlagEncoding.values();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                TypeRestriction.RestrictionFlagEncoding element$iv;
                TypeRestriction.RestrictionFlagEncoding it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                intersection = manifestRestriction.hasFlag(it) ? intersection.withFlag(it) : intersection.withoutFlag(it);
            }
        }
        this.restriction = intersection;
        manifest2.setRestriction(this.semanticValue, this.restriction);
        ((L2Register)this.register()).addUse(this);
    }

    @NotNull
    public abstract L2ReadOperand<R> copyForRegister(@NotNull L2Register var1);

    @Override
    public void instructionWasInserted(@NotNull L2Instruction newInstruction) {
        Intrinsics.checkNotNullParameter((Object)newInstruction, (String)"newInstruction");
        super.instructionWasInserted(newInstruction);
        ((L2Register)this.register()).addUse(this);
    }

    @Override
    public void instructionWasRemoved() {
        super.instructionWasRemoved();
        ((L2Register)this.register()).removeUse(this);
    }

    @Override
    public void replaceRegisters(@NotNull Map<L2Register, ? extends L2Register> registerRemap, @NotNull L2Instruction theInstruction) {
        Intrinsics.checkNotNullParameter(registerRemap, (String)"registerRemap");
        Intrinsics.checkNotNullParameter((Object)theInstruction, (String)"theInstruction");
        L2Register $this$cast$iv = registerRemap.get(this.register);
        boolean $i$f$cast = false;
        L2Register replacement2 = $this$cast$iv;
        if (replacement2 == null || replacement2 == this.register) {
            return;
        }
        ((L2Register)this.register()).removeUse(this);
        replacement2.addUse(this);
        this.register = replacement2;
    }

    @Override
    @NotNull
    public L2ReadOperand<?> transformEachRead(@NotNull Function1<? super L2ReadOperand<?>, ? extends L2ReadOperand<?>> transformer) {
        Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
        return (L2ReadOperand)transformer.invoke((Object)this);
    }

    @Override
    public void addReadsTo(@NotNull List<L2ReadOperand<?>> readOperands) {
        Intrinsics.checkNotNullParameter(readOperands, (String)"readOperands");
        readOperands.add(this);
    }

    @Override
    public void addSourceRegistersTo(@NotNull List<L2Register> sourceRegisters) {
        Intrinsics.checkNotNullParameter(sourceRegisters, (String)"sourceRegisters");
        sourceRegisters.add((L2Register)this.register);
    }

    @Override
    public void appendTo(@NotNull StringBuilder builder2) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        builder2.append('@').append(this.registerString());
        if (this.restriction.getConstantOrNull() == null) {
            builder2.append(this.restriction.suffixString());
        }
    }

    @NotNull
    public final L2Instruction definitionSkippingMoves(boolean bypassImmutables) {
        L2Instruction other = this.definition().getInstruction();
        while (true) {
            L2Instruction l2Instruction;
            L2Operation op = other.getOperation();
            if (op instanceof L2_MOVE) {
                l2Instruction = ((L2ReadOperand)((L2_MOVE)op).sourceOf(other)).definition().getInstruction();
            } else if (bypassImmutables && op instanceof L2_MAKE_IMMUTABLE) {
                l2Instruction = L2_MAKE_IMMUTABLE.INSTANCE.sourceOfImmutable(other).definition().getInstruction();
            } else {
                return other;
            }
            other = l2Instruction;
        }
    }

    @NotNull
    public final Pair<Set<L2SemanticValue>, TypeRestriction> findSourceInformation() {
        L2BasicBlock thisBlock = this.getInstruction().basicBlock();
        for (L2WriteOperand<?> def : ((L2Register)this.register).definitions()) {
            if (!Intrinsics.areEqual((Object)def.getInstruction().basicBlock(), (Object)thisBlock) || !thisBlock.instructions().contains(def.getInstruction())) continue;
            return TuplesKt.to(def.semanticValues(), (Object)def.restriction());
        }
        Iterator<L2PcOperand> incoming = thisBlock.predecessorEdges().iterator();
        boolean def = incoming.hasNext();
        if (_Assertions.ENABLED && !def) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2ValueManifest firstManifest = incoming.next().manifest();
        Set semanticValues = new LinkedHashSet();
        Ref.ObjectRef typeRestriction = new Ref.ObjectRef();
        for (L2Synonym syn : firstManifest.synonymsForRegister((L2Register)this.register)) {
            semanticValues.addAll((Collection)syn.semanticValues());
            TypeRestriction nextRestriction = firstManifest.restrictionFor(syn.pickSemanticValue());
            typeRestriction.element = (TypeRestriction)typeRestriction.element == null ? nextRestriction : ((TypeRestriction)typeRestriction.element).union(nextRestriction);
        }
        incoming.forEachRemaining(arg_0 -> L2ReadOperand.findSourceInformation$lambda-1(this, typeRestriction, semanticValues, arg_0));
        Object object = typeRestriction.element;
        Intrinsics.checkNotNull((Object)object);
        return TuplesKt.to((Object)semanticValues, (Object)object);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final L2WriteBoxedOperand originalBoxedWriteSkippingMoves(boolean bypassImmutables) {
        L2WriteOperand<R> def = this.definition();
        L2WriteBoxedOperand earliestBoxed = null;
        while (true) {
            L2Instruction instruction2;
            if (def instanceof L2WriteBoxedOperand) {
                earliestBoxed = (L2WriteBoxedOperand)def;
            }
            if ((instruction2 = def.getInstruction()).getOperation().isMove()) {
                void $this$cast$iv;
                L2Operation l2Operation = instruction2.getOperation();
                boolean $i$f$cast = false;
                L2_MOVE operation = (L2_MOVE)$this$cast$iv;
                def = ((L2ReadOperand)operation.sourceOf(instruction2)).definition();
                continue;
            }
            if (!bypassImmutables || instruction2.getOperation() != L2_MAKE_IMMUTABLE.INSTANCE) break;
            def = L2_MAKE_IMMUTABLE.INSTANCE.sourceOfImmutable(instruction2).definition();
        }
        L2WriteBoxedOperand l2WriteBoxedOperand = earliestBoxed;
        Intrinsics.checkNotNull((Object)l2WriteBoxedOperand);
        return l2WriteBoxedOperand;
    }

    @NotNull
    public abstract R createNewRegister();

    @Override
    public void postOptimizationCleanup() {
        this.restriction.makeShared();
    }

    private static final void findSourceInformation$lambda-1(L2ReadOperand this$0, Ref.ObjectRef $typeRestriction, Set $semanticValues, L2PcOperand it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$typeRestriction, (String)"$typeRestriction");
        Intrinsics.checkNotNullParameter((Object)$semanticValues, (String)"$semanticValues");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        L2ValueManifest nextManifest = it.manifest();
        Set newSemanticValues = new LinkedHashSet();
        for (L2Synonym syn : nextManifest.synonymsForRegister((L2Register)this$0.register)) {
            newSemanticValues.addAll((Collection)syn.semanticValues());
            Object object = $typeRestriction.element;
            Intrinsics.checkNotNull((Object)object);
            $typeRestriction.element = ((TypeRestriction)object).union(nextManifest.restrictionFor(syn.pickSemanticValue()));
        }
        $semanticValues.retainAll(newSemanticValues);
    }
}

