/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.maps;

import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.maps.A_Map;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.MapTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0016\u00a8\u0006\u000e"}, d2={"Lavail/interpreter/primitive/maps/P_MapReplacingKey;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "argumentTypes", "", "avail"})
public final class P_MapReplacingKey
extends Primitive {
    @NotNull
    public static final P_MapReplacingKey INSTANCE = new P_MapReplacingKey();

    private P_MapReplacingKey() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CannotFail, Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(3, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(3);
        List<AvailObject> list2 = interpreter.argsBuffer;
        AvailObject map = list2.get(0);
        AvailObject key = list2.get(1);
        AvailObject value = list2.get(2);
        return interpreter.primitiveSuccess(A_Map.Companion.mapAtPuttingCanDestroy(map, key, value, true));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(MapTypeDescriptor.Companion.mostGeneralMapType(), PrimitiveTypeDescriptor.Types.ANY.getO(), PrimitiveTypeDescriptor.Types.ANY.getO()), MapTypeDescriptor.Companion.mapTypeForSizesKeyTypeValueType(IntegerRangeTypeDescriptor.Companion.getNaturalNumbers(), PrimitiveTypeDescriptor.Types.ANY.getO(), PrimitiveTypeDescriptor.Types.ANY.getO()), null, 4, null);
    }

    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction, @NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter((Object)rawFunction, (String)"rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        A_Type mapType = argumentTypes.get(0);
        A_Type addedKeyType = argumentTypes.get(1);
        A_Type addedValueType = argumentTypes.get(2);
        A_Type oldMapKeyType = A_Type.Companion.getKeyType(mapType);
        A_Type newKeyType = A_Type.Companion.typeUnion(oldMapKeyType, addedKeyType);
        A_Type newValueType = A_Type.Companion.typeUnion(A_Type.Companion.getValueType(mapType), addedValueType);
        A_Type oldSizes = A_Type.Companion.getSizeRange(mapType);
        A_Number newMin = A_Type.Companion.getLowerBound(oldSizes);
        if (A_Type.Companion.typeIntersection(oldMapKeyType, newKeyType).isBottom() || A_Number.Companion.equalsInt(newMin, 0)) {
            newMin = A_Number.Companion.plusCanDestroy(newMin, IntegerDescriptor.Companion.getOne(), false);
        }
        A_Number newMaxPlusOne = A_Number.Companion.plusCanDestroy(A_Type.Companion.getUpperBound(oldSizes), IntegerDescriptor.Companion.getTwo(), false);
        A_Type newSizes = IntegerRangeTypeDescriptor.Companion.integerRangeType(newMin, true, newMaxPlusOne, false);
        return MapTypeDescriptor.Companion.mapTypeForSizesKeyTypeValueType(newSizes, newKeyType, newValueType);
    }
}

