/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.tuples;

import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2WriteIntOperand;
import avail.interpreter.levelTwo.operand.TypeRestriction;
import avail.interpreter.levelTwo.operation.L2_TUPLE_SIZE;
import avail.optimizer.L1Translator;
import avail.optimizer.L2Generator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0016JH\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016R\u00020\u0014H\u0016\u00a8\u0006\u0017"}, d2={"Lavail/interpreter/primitive/tuples/P_TupleSize;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "argumentTypes", "", "tryToGenerateSpecialPrimitiveInvocation", "", "functionToCallReg", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "arguments", "translator", "Lavail/optimizer/L1Translator;", "callSiteHelper", "Lavail/optimizer/L1Translator$CallSiteHelper;", "avail"})
public final class P_TupleSize
extends Primitive {
    @NotNull
    public static final P_TupleSize INSTANCE = new P_TupleSize();

    private P_TupleSize() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CannotFail, Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(1, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(1);
        AvailObject tuple2 = interpreter.argument(0);
        return interpreter.primitiveSuccess(IntegerDescriptor.Companion.fromInt(A_Tuple.Companion.getTupleSize(tuple2)));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(TupleTypeDescriptor.Companion.getMostGeneralTupleType()), IntegerRangeTypeDescriptor.Companion.getWholeNumbers(), null, 4, null);
    }

    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction, @NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter((Object)rawFunction, (String)"rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        return A_Type.Companion.typeIntersection(A_Type.Companion.getSizeRange(argumentTypes.get(0)), IntegerRangeTypeDescriptor.Companion.getNonnegativeInt32());
    }

    @Override
    public boolean tryToGenerateSpecialPrimitiveInvocation(@NotNull L2ReadBoxedOperand functionToCallReg, @NotNull A_RawFunction rawFunction, @NotNull List<L2ReadBoxedOperand> arguments, @NotNull List<? extends A_Type> argumentTypes, @NotNull L1Translator translator, @NotNull L1Translator.CallSiteHelper callSiteHelper) {
        Intrinsics.checkNotNullParameter((Object)functionToCallReg, (String)"functionToCallReg");
        Intrinsics.checkNotNullParameter((Object)rawFunction, (String)"rawFunction");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        Intrinsics.checkNotNullParameter((Object)callSiteHelper, (String)"callSiteHelper");
        L2ReadBoxedOperand tupleReg = arguments.get(0);
        L2Generator generator = translator.getGenerator();
        A_Type returnType = this.returnTypeGuaranteedByVM(rawFunction, argumentTypes);
        A_Number lower = A_Type.Companion.getLowerBound(returnType);
        A_Number upper = A_Type.Companion.getUpperBound(returnType);
        if (lower.equals(upper)) {
            callSiteHelper.useAnswer(generator.boxedConstant(lower));
        } else {
            TypeRestriction restriction = TypeRestriction.Companion.restrictionForType(returnType, TypeRestriction.RestrictionFlagEncoding.UNBOXED_INT_FLAG);
            L2WriteIntOperand writer = generator.intWriteTemp(restriction);
            L2Operand[] l2OperandArray = new L2Operand[]{tupleReg, writer};
            generator.addInstruction(L2_TUPLE_SIZE.INSTANCE, l2OperandArray);
            callSiteHelper.useAnswer(generator.readBoxed(writer.onlySemanticValue().getBase()));
        }
        return true;
    }
}

