/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo.operand;

import avail.descriptor.representation.AvailObject;
import avail.interpreter.JavaLibrary;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2OperandDispatcher;
import avail.interpreter.levelTwo.L2OperandType;
import avail.interpreter.levelTwo.L2Operation;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2PcOperand;
import avail.interpreter.levelTwo.operation.L2_ENTER_L2_CHUNK;
import avail.interpreter.levelTwo.operation.L2_JUMP;
import avail.interpreter.levelTwo.register.L2Register;
import avail.optimizer.L2BasicBlock;
import avail.optimizer.L2ControlFlowGraph;
import avail.optimizer.L2Entity;
import avail.optimizer.L2EntityAndKind;
import avail.optimizer.L2ValueManifest;
import avail.optimizer.jvm.JVMChunk;
import avail.optimizer.jvm.JVMTranslator;
import avail.utility.structures.EnumMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u0014\u0010*\u001a\u00020'2\n\u0010+\u001a\u00060,j\u0002`-H\u0016J\u0016\u0010.\u001a\u00020'2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202J\u0010\u00103\u001a\u00020'2\u0006\u00104\u001a\u000205H\u0016J\u0006\u00106\u001a\u00020'J\u0010\u00107\u001a\u00020'2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u00108\u001a\u00020'2\u0006\u00109\u001a\u00020)H\u0016J\b\u0010:\u001a\u00020'H\u0016J\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010;\u001a\u0004\u0018\u00010\u0007J\u0006\u0010<\u001a\u00020=J\b\u0010>\u001a\u00020'H\u0016J$\u0010?\u001a\u00020'2\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0A2\u0006\u0010(\u001a\u00020)H\u0016J\u0006\u0010B\u001a\u00020\u0003J\u000e\u0010C\u001a\u00020\u00032\u0006\u0010D\u001a\u00020EJ\u0016\u0010F\u001a\u00020'2\u0006\u0010G\u001a\u00020\u00032\u0006\u0010H\u001a\u00020\u0005J\u0006\u0010\u0002\u001a\u00020\u0003R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\"\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000f\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lavail/interpreter/levelTwo/operand/L2PcOperand;", "Lavail/interpreter/levelTwo/operand/L2Operand;", "targetBlock", "Lavail/optimizer/L2BasicBlock;", "isBackward", "", "manifest", "Lavail/optimizer/L2ValueManifest;", "optionalName", "", "(Lavail/optimizer/L2BasicBlock;ZLavail/optimizer/L2ValueManifest;Ljava/lang/String;)V", "alwaysLiveInRegisters", "", "Lavail/interpreter/levelTwo/register/L2Register;", "getAlwaysLiveInRegisters", "()Ljava/util/Set;", "counter", "Ljava/util/concurrent/atomic/LongAdder;", "getCounter", "()Ljava/util/concurrent/atomic/LongAdder;", "setCounter", "(Ljava/util/concurrent/atomic/LongAdder;)V", "forcedClampedEntities", "Lavail/optimizer/L2EntityAndKind;", "getForcedClampedEntities", "setForcedClampedEntities", "(Ljava/util/Set;)V", "()Z", "setBackward", "(Z)V", "operandType", "Lavail/interpreter/levelTwo/L2OperandType;", "getOperandType", "()Lavail/interpreter/levelTwo/L2OperandType;", "getOptionalName", "()Ljava/lang/String;", "sometimesLiveInRegisters", "getSometimesLiveInRegisters", "adjustCloneForInstruction", "", "theInstruction", "Lavail/interpreter/levelTwo/L2Instruction;", "appendTo", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "createAndPushRegisterDumpArrays", "translator", "Lavail/optimizer/jvm/JVMTranslator;", "method", "Lorg/objectweb/asm/MethodVisitor;", "dispatchOperand", "dispatcher", "Lavail/interpreter/levelTwo/L2OperandDispatcher;", "installCounter", "instructionWasAdded", "instructionWasInserted", "newInstruction", "instructionWasRemoved", "manifestOrNull", "offset", "", "postOptimizationCleanup", "replaceRegisters", "registerRemap", "", "sourceBlock", "splitEdgeWith", "controlFlowGraph", "Lavail/optimizer/L2ControlFlowGraph;", "switchTargetBlockNonSSA", "newTarget", "isBackwardFlag", "avail"})
public final class L2PcOperand
extends L2Operand {
    @NotNull
    private L2BasicBlock targetBlock;
    private boolean isBackward;
    @Nullable
    private L2ValueManifest manifest;
    @Nullable
    private final String optionalName;
    @NotNull
    private final Set<L2Register> alwaysLiveInRegisters;
    @NotNull
    private final Set<L2Register> sometimesLiveInRegisters;
    @Nullable
    private Set<L2EntityAndKind> forcedClampedEntities;
    @Nullable
    private LongAdder counter;

    public L2PcOperand(@NotNull L2BasicBlock targetBlock, boolean isBackward, @Nullable L2ValueManifest manifest2, @Nullable String optionalName) {
        Intrinsics.checkNotNullParameter(targetBlock, "targetBlock");
        this.targetBlock = targetBlock;
        this.isBackward = isBackward;
        this.manifest = manifest2;
        this.optionalName = optionalName;
        this.alwaysLiveInRegisters = new LinkedHashSet();
        this.sometimesLiveInRegisters = new LinkedHashSet();
    }

    public /* synthetic */ L2PcOperand(L2BasicBlock l2BasicBlock, boolean bl, L2ValueManifest l2ValueManifest, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            l2ValueManifest = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        this(l2BasicBlock, bl, l2ValueManifest, string2);
    }

    public final boolean isBackward() {
        return this.isBackward;
    }

    public final void setBackward(boolean bl) {
        this.isBackward = bl;
    }

    @Nullable
    public final String getOptionalName() {
        return this.optionalName;
    }

    @NotNull
    public final Set<L2Register> getAlwaysLiveInRegisters() {
        return this.alwaysLiveInRegisters;
    }

    @NotNull
    public final Set<L2Register> getSometimesLiveInRegisters() {
        return this.sometimesLiveInRegisters;
    }

    @Nullable
    public final Set<L2EntityAndKind> getForcedClampedEntities() {
        return this.forcedClampedEntities;
    }

    public final void setForcedClampedEntities(@Nullable Set<L2EntityAndKind> set2) {
        this.forcedClampedEntities = set2;
    }

    @Nullable
    public final LongAdder getCounter() {
        return this.counter;
    }

    public final void setCounter(@Nullable LongAdder longAdder) {
        this.counter = longAdder;
    }

    @Override
    public void adjustCloneForInstruction(@NotNull L2Instruction theInstruction) {
        Intrinsics.checkNotNullParameter(theInstruction, "theInstruction");
        super.adjustCloneForInstruction(theInstruction);
        this.counter = null;
    }

    @Override
    @NotNull
    public L2OperandType getOperandType() {
        return L2OperandType.PC;
    }

    @NotNull
    public final L2ValueManifest manifest() {
        L2ValueManifest l2ValueManifest = this.manifest;
        Intrinsics.checkNotNull(l2ValueManifest);
        return l2ValueManifest;
    }

    @Nullable
    public final L2ValueManifest manifestOrNull() {
        return this.manifest;
    }

    @Override
    public void dispatchOperand(@NotNull L2OperandDispatcher dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, "dispatcher");
        dispatcher.doOperand(this);
    }

    @Override
    public void instructionWasAdded(@NotNull L2ValueManifest manifest2) {
        Intrinsics.checkNotNullParameter(manifest2, "manifest");
        super.instructionWasAdded(manifest2);
        this.getInstruction().basicBlock().addSuccessorEdge(this);
        this.manifest = new L2ValueManifest(manifest2);
        this.targetBlock.addPredecessorEdge(this);
    }

    @Override
    public void instructionWasInserted(@NotNull L2Instruction newInstruction) {
        Intrinsics.checkNotNullParameter(newInstruction, "newInstruction");
        super.instructionWasInserted(newInstruction);
        newInstruction.basicBlock().addSuccessorEdge(this);
        this.manifest = new L2ValueManifest(this.manifest());
        this.targetBlock.addPredecessorEdge(this);
    }

    @Override
    public void instructionWasRemoved() {
        L2BasicBlock sourceBlock = this.getInstruction().basicBlock();
        sourceBlock.removeSuccessorEdge(this);
        this.targetBlock.removePredecessorEdge(this);
        if (this.getInstruction().getOperation().getAltersControlFlow()) {
            sourceBlock.removedControlFlowInstruction();
        }
        super.instructionWasRemoved();
    }

    @Override
    public void replaceRegisters(@NotNull Map<L2Register, ? extends L2Register> registerRemap, @NotNull L2Instruction theInstruction) {
        block1: {
            Intrinsics.checkNotNullParameter(registerRemap, "registerRemap");
            Intrinsics.checkNotNullParameter(theInstruction, "theInstruction");
            Set<L2EntityAndKind> set2 = this.forcedClampedEntities;
            if (set2 == null) break block1;
            Set<L2EntityAndKind> $this$replaceRegisters_u24lambda_u2d1 = set2;
            boolean bl = false;
            Iterable $this$forEach$iv = CollectionsKt.toMutableList((Collection)$this$replaceRegisters_u24lambda_u2d1);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                L2EntityAndKind pair = (L2EntityAndKind)element$iv;
                boolean bl2 = false;
                L2Entity entity = pair.component1();
                L2Register.RegisterKind kind2 = pair.component2();
                if (!registerRemap.containsKey(entity)) continue;
                $this$replaceRegisters_u24lambda_u2d1.remove(pair);
                L2Register l2Register = registerRemap.get(entity);
                Intrinsics.checkNotNull(l2Register);
                $this$replaceRegisters_u24lambda_u2d1.add(new L2EntityAndKind(l2Register, kind2));
            }
            super.replaceRegisters(registerRemap, theInstruction);
        }
    }

    @NotNull
    public final L2BasicBlock targetBlock() {
        return this.targetBlock;
    }

    public final int offset() {
        return this.targetBlock.offset();
    }

    @NotNull
    public final L2BasicBlock sourceBlock() {
        return this.getInstruction().basicBlock();
    }

    @Override
    public void appendTo(@NotNull StringBuilder builder2) {
        Intrinsics.checkNotNullParameter(builder2, "builder");
        if (this.offset() != -1) {
            builder2.append("pc ").append(this.offset()).append(": ");
        }
        builder2.append(this.targetBlock.name());
    }

    @NotNull
    public final L2BasicBlock splitEdgeWith(@NotNull L2ControlFlowGraph controlFlowGraph) {
        Intrinsics.checkNotNullParameter(controlFlowGraph, "controlFlowGraph");
        boolean bl = this.getInstructionHasBeenEmitted();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2Instruction source2 = this.getInstruction();
        L2BasicBlock newBlock = new L2BasicBlock("edge-split [" + source2.basicBlock().name() + " / " + this.targetBlock.name() + "]", false, source2.basicBlock().getZone());
        controlFlowGraph.startBlock(newBlock);
        L2ValueManifest manifestCopy = new L2ValueManifest(this.manifest());
        L2Operand[] l2OperandArray = new L2Operand[]{new L2PcOperand(newBlock, this.isBackward, manifestCopy, null, 8, null)};
        newBlock.insertInstruction(0, new L2Instruction(newBlock, (L2Operation)L2_JUMP.INSTANCE, l2OperandArray));
        L2Instruction newJump = newBlock.instructions().get(0);
        L2PcOperand jumpEdge = L2_JUMP.jumpTarget(newJump);
        L2BasicBlock finalTarget = this.targetBlock;
        this.targetBlock = jumpEdge.targetBlock;
        jumpEdge.targetBlock = finalTarget;
        this.isBackward = false;
        newBlock.replacePredecessorEdge(jumpEdge, this);
        finalTarget.replacePredecessorEdge(this, jumpEdge);
        return newBlock;
    }

    public final void switchTargetBlockNonSSA(@NotNull L2BasicBlock newTarget, boolean isBackwardFlag) {
        Intrinsics.checkNotNullParameter(newTarget, "newTarget");
        L2BasicBlock oldTarget = this.targetBlock;
        this.targetBlock = newTarget;
        oldTarget.removePredecessorEdge(this);
        newTarget.addPredecessorEdge(this);
        this.isBackward = isBackwardFlag;
    }

    /*
     * WARNING - void declaration
     */
    public final void createAndPushRegisterDumpArrays(@NotNull JVMTranslator translator, @NotNull MethodVisitor method) {
        void $this$sortedBy$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter(translator, "translator");
        Intrinsics.checkNotNullParameter(method, "method");
        L2Instruction targetInstruction = this.targetBlock.instructions().get(0);
        boolean bl2 = bl = targetInstruction.getOperation() == L2_ENTER_L2_CHUNK.INSTANCE;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        EnumMap.Companion this_$iv = EnumMap.Companion;
        boolean $i$f$enumMap22 = false;
        Enum[] keys$iv = (Enum[])L2Register.RegisterKind.class.getEnumConstants();
        Intrinsics.checkNotNullExpressionValue(keys$iv, "keys");
        EnumMap map$iv2 = new EnumMap(keys$iv);
        Enum[] $this$forEach$iv$iv = keys$iv;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv$iv.length;
        for (int i = 0; i < n; ++i) {
            Enum element$iv$iv;
            Enum key$iv = element$iv$iv = $this$forEach$iv$iv[i];
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue(key$iv, "key");
            L2Register.RegisterKind cfr_ignored_0 = (L2Register.RegisterKind)key$iv;
            boolean bl4 = false;
            List value$iv = new ArrayList();
            boolean bl5 = false;
            map$iv2.set(key$iv, value$iv);
        }
        EnumMap liveMap = map$iv2;
        Iterable $i$f$enumMap22 = SetsKt.plus(this.alwaysLiveInRegisters, (Iterable)this.sometimesLiveInRegisters);
        boolean $i$f$sortedBy = false;
        List liveRegistersList = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                L2Register p0 = (L2Register)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(p0.finalIndex());
                p0 = (L2Register)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, p0.finalIndex());
            }
        });
        Iterable $this$forEach$iv = liveRegistersList;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            L2Register it = (L2Register)element$iv;
            boolean bl6 = false;
            Object v = liveMap.get((Object)it.getRegisterKind());
            Intrinsics.checkNotNull(v);
            ((List)v).add(translator.localNumberFromRegister(it));
        }
        translator.getLiveLocalNumbersByKindPerEntryPoint().put(targetInstruction, liveMap);
        Object v = liveMap.get((Object)L2Register.RegisterKind.BOXED_KIND);
        Intrinsics.checkNotNull(v);
        List boxedLocalNumbers = (List)v;
        if (boxedLocalNumbers.isEmpty()) {
            JVMChunk.Companion.getNoObjectsField().generateRead(method);
        } else {
            translator.intConstant(method, boxedLocalNumbers.size());
            method.visitTypeInsn(189, Type.getInternalName(AvailObject.class));
            int map$iv2 = boxedLocalNumbers.size();
            for (int i = 0; i < map$iv2; ++i) {
                method.visitInsn(89);
                translator.intConstant(method, i);
                method.visitVarInsn(L2Register.RegisterKind.BOXED_KIND.getLoadInstruction(), ((Number)boxedLocalNumbers.get(i)).intValue());
                method.visitInsn(83);
            }
        }
        Object v2 = liveMap.get((Object)L2Register.RegisterKind.INTEGER_KIND);
        Intrinsics.checkNotNull(v2);
        List intLocalNumbers = (List)v2;
        Object v3 = liveMap.get((Object)L2Register.RegisterKind.FLOAT_KIND);
        Intrinsics.checkNotNull(v3);
        List floatLocalNumbers = (List)v3;
        int count = intLocalNumbers.size() + floatLocalNumbers.size();
        if (count == 0) {
            JVMChunk.Companion.getNoLongsField().generateRead(method);
        } else {
            int i;
            translator.intConstant(method, count);
            method.visitIntInsn(188, 11);
            for (i = 0; i < intLocalNumbers.size(); ++i) {
                method.visitInsn(89);
                translator.intConstant(method, i);
                method.visitVarInsn(L2Register.RegisterKind.INTEGER_KIND.getLoadInstruction(), ((Number)intLocalNumbers.get(i)).intValue());
                method.visitInsn(133);
                method.visitInsn(80);
            }
            n = floatLocalNumbers.size();
            for (int j = 0; j < n; ++j) {
                method.visitInsn(89);
                translator.intConstant(method, i);
                method.visitVarInsn(L2Register.RegisterKind.FLOAT_KIND.getLoadInstruction(), ((Number)floatLocalNumbers.get(i)).intValue());
                JavaLibrary.INSTANCE.getBitCastDoubleToLongMethod().generateCall(method);
                method.visitInsn(80);
                ++i;
            }
        }
    }

    public final void installCounter() {
        boolean bl;
        boolean bl2 = bl = this.counter == null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.counter = new LongAdder();
    }

    @Override
    public void postOptimizationCleanup() {
        block0: {
            this.manifest = null;
            this.alwaysLiveInRegisters.clear();
            this.sometimesLiveInRegisters.clear();
            Set<L2EntityAndKind> set2 = this.forcedClampedEntities;
            if (set2 == null) break block0;
            CollectionsKt.retainAll((Iterable)set2, (Function1)postOptimizationCleanup.1.INSTANCE);
        }
    }
}

