/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo.operation;

import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.functions.FunctionDescriptor;
import avail.descriptor.types.A_Type;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2NamedOperandType;
import avail.interpreter.levelTwo.L2OperandType;
import avail.interpreter.levelTwo.L2Operation;
import avail.interpreter.levelTwo.operand.L2ConstantOperand;
import avail.interpreter.levelTwo.operand.L2IntImmediateOperand;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedVectorOperand;
import avail.interpreter.levelTwo.operand.L2WriteBoxedOperand;
import avail.interpreter.levelTwo.operand.TypeRestriction;
import avail.interpreter.levelTwo.operation.L2_MOVE_OUTER_VARIABLE;
import avail.interpreter.levelTwo.register.L2BoxedRegister;
import avail.interpreter.levelTwo.register.L2Register;
import avail.optimizer.L2Generator;
import avail.optimizer.L2ValueManifest;
import avail.optimizer.jvm.JVMTranslator;
import avail.optimizer.values.L2SemanticValue;
import avail.utility.Strings;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\n\u0010\n\u001a\u00060\u000bj\u0002`\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00040\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J0\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006!"}, d2={"Lavail/interpreter/levelTwo/operation/L2_CREATE_FUNCTION;", "Lavail/interpreter/levelTwo/L2Operation;", "()V", "appendToWithWarnings", "", "instruction", "Lavail/interpreter/levelTwo/L2Instruction;", "desiredTypes", "", "Lavail/interpreter/levelTwo/L2OperandType;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "warningStyleChange", "Lkotlin/Function1;", "", "constantRawFunctionOf", "Lavail/descriptor/functions/A_RawFunction;", "extractFunctionOuter", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "functionRegister", "outerIndex", "", "outerType", "Lavail/descriptor/types/A_Type;", "generator", "Lavail/optimizer/L2Generator;", "getConstantCodeFrom", "translateToJVM", "translator", "Lavail/optimizer/jvm/JVMTranslator;", "method", "Lorg/objectweb/asm/MethodVisitor;", "avail"})
public final class L2_CREATE_FUNCTION
extends L2Operation {
    @NotNull
    public static final L2_CREATE_FUNCTION INSTANCE = new L2_CREATE_FUNCTION();

    private L2_CREATE_FUNCTION() {
        L2NamedOperandType[] l2NamedOperandTypeArray = new L2NamedOperandType[]{L2OperandType.CONSTANT.named("compiled code"), L2OperandType.READ_BOXED_VECTOR.named("captured variables"), L2OperandType.WRITE_BOXED.named("new function")};
        super(l2NamedOperandTypeArray);
    }

    @Override
    @NotNull
    public L2ReadBoxedOperand extractFunctionOuter(@NotNull L2Instruction instruction2, @NotNull L2ReadBoxedOperand functionRegister, int outerIndex, @NotNull A_Type outerType, @NotNull L2Generator generator) {
        TypeRestriction restriction;
        L2SemanticValue semanticValue;
        boolean bl;
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        Intrinsics.checkNotNullParameter(functionRegister, "functionRegister");
        Intrinsics.checkNotNullParameter(outerType, "outerType");
        Intrinsics.checkNotNullParameter(generator, "generator");
        boolean bl2 = Intrinsics.areEqual(this, instruction2.getOperation());
        if (_Assertions.ENABLED && !bl2) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2ConstantOperand code = (L2ConstantOperand)instruction2.operand(0);
        L2ReadBoxedVectorOperand outers2 = (L2ReadBoxedVectorOperand)instruction2.operand(1);
        L2ReadBoxedOperand originalRead = (L2ReadBoxedOperand)outers2.elements().get(outerIndex - 1);
        TypeRestriction intersection = originalRead.restriction().intersectionWithType(A_Type.Companion.typeIntersection(outerType, A_RawFunction.Companion.outerTypeAt(code.getConstant(), outerIndex)));
        boolean bl3 = bl = !intersection.getType().isBottom();
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        L2ValueManifest manifest2 = generator.getCurrentManifest();
        if (manifest2.hasSemanticValue(semanticValue = originalRead.semanticValue()) && (restriction = manifest2.restrictionFor(semanticValue)).isBoxed()) {
            return generator.makeImmutable(manifest2.readBoxed(semanticValue));
        }
        if (functionRegister.restriction().isImmutable()) {
            intersection = intersection.withFlag(TypeRestriction.RestrictionFlagEncoding.IMMUTABLE_FLAG);
        }
        L2WriteBoxedOperand tempWrite = generator.boxedWriteTemp(intersection);
        L2Operand[] l2OperandArray = new L2Operand[]{new L2IntImmediateOperand(outerIndex), functionRegister, tempWrite};
        generator.addInstruction(L2_MOVE_OUTER_VARIABLE.INSTANCE, l2OperandArray);
        return generator.readBoxed(tempWrite);
    }

    @Override
    @NotNull
    public A_RawFunction getConstantCodeFrom(@NotNull L2Instruction instruction2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        boolean bl2 = bl = instruction2.getOperation() == this;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2ConstantOperand constant = (L2ConstantOperand)instruction2.operand(0);
        return constant.getConstant();
    }

    @Override
    public void appendToWithWarnings(@NotNull L2Instruction instruction2, @NotNull Set<? extends L2OperandType> desiredTypes, @NotNull StringBuilder builder2, @NotNull Function1<? super Boolean, Unit> warningStyleChange) {
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        Intrinsics.checkNotNullParameter(desiredTypes, "desiredTypes");
        Intrinsics.checkNotNullParameter(builder2, "builder");
        Intrinsics.checkNotNullParameter(warningStyleChange, "warningStyleChange");
        boolean bl = Intrinsics.areEqual(this, instruction2.getOperation());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2ConstantOperand code = (L2ConstantOperand)instruction2.operand(0);
        L2ReadBoxedVectorOperand outers2 = (L2ReadBoxedVectorOperand)instruction2.operand(1);
        L2WriteBoxedOperand function = (L2WriteBoxedOperand)instruction2.operand(2);
        this.renderPreamble(instruction2, builder2);
        builder2.append(' ');
        builder2.append(function.registerString());
        builder2.append(" \u2190 ");
        String decompiled = code.toString();
        int limit = outers2.elements().size();
        for (int i = 0; i < limit; ++i) {
            decompiled = StringsKt.replace$default(decompiled, "Outer#" + (i + 1), ((L2ReadBoxedOperand)outers2.elements().get(i)).toString(), false, 4, null);
        }
        builder2.append(Strings.INSTANCE.increaseIndentation(decompiled, 1));
    }

    @Override
    public void translateToJVM(@NotNull JVMTranslator translator, @NotNull MethodVisitor method, @NotNull L2Instruction instruction2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(translator, "translator");
        Intrinsics.checkNotNullParameter(method, "method");
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        L2ConstantOperand code = (L2ConstantOperand)instruction2.operand(0);
        L2ReadBoxedVectorOperand outerRegs = (L2ReadBoxedVectorOperand)instruction2.operand(1);
        L2WriteBoxedOperand newFunctionReg = (L2WriteBoxedOperand)instruction2.operand(2);
        int numOuters = outerRegs.elements().size();
        boolean bl2 = bl = numOuters == A_RawFunction.Companion.getNumOuters(code.getConstant());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        translator.literal(method, code.getConstant());
        boolean bl3 = bl = numOuters != 0;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        if (numOuters <= 5) {
            Iterable $this$forEach$iv = outerRegs.registers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                L2BoxedRegister it = (L2BoxedRegister)element$iv;
                boolean bl4 = false;
                translator.load(method, it);
            }
        }
        switch (numOuters) {
            case 1: {
                FunctionDescriptor.Companion.getCreateWithOuters1Method().generateCall(method);
                break;
            }
            case 2: {
                FunctionDescriptor.Companion.getCreateWithOuters2Method().generateCall(method);
                break;
            }
            case 3: {
                FunctionDescriptor.Companion.getCreateWithOuters3Method().generateCall(method);
                break;
            }
            case 4: {
                FunctionDescriptor.Companion.getCreateWithOuters4Method().generateCall(method);
                break;
            }
            case 5: {
                FunctionDescriptor.Companion.getCreateWithOuters5Method().generateCall(method);
                break;
            }
            default: {
                translator.intConstant(method, numOuters);
                FunctionDescriptor.Companion.getCreateExceptOutersMethod().generateCall(method);
                for (int i = 0; i < numOuters; ++i) {
                    method.visitInsn(89);
                    translator.intConstant(method, i + 1);
                    translator.load(method, (L2Register)((L2ReadBoxedOperand)outerRegs.elements().get(i)).register());
                    FunctionDescriptor.Companion.getOuterVarAtPutMethod().generateCall(method);
                }
            }
        }
        translator.store(method, (L2Register)newFunctionReg.register());
    }

    @JvmStatic
    @NotNull
    public static final A_RawFunction constantRawFunctionOf(@NotNull L2Instruction instruction2) {
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        boolean bl = instruction2.getOperation() instanceof L2_CREATE_FUNCTION;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2ConstantOperand constant = (L2ConstantOperand)instruction2.operand(0);
        return constant.getConstant();
    }
}

