/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwoSimple;

import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.functions.FunctionDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwoSimple.L2SimpleInstruction;
import avail.optimizer.StackReifier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J%\u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lavail/interpreter/levelTwoSimple/L2Simple_CloseFunctionN;", "Lavail/interpreter/levelTwoSimple/L2SimpleInstruction;", "code", "Lavail/descriptor/functions/A_RawFunction;", "to", "", "(Lavail/descriptor/functions/A_RawFunction;I)V", "getCode", "()Lavail/descriptor/functions/A_RawFunction;", "outerCount", "getOuterCount", "()I", "getTo", "step", "Lavail/optimizer/StackReifier;", "registers", "", "Lavail/descriptor/representation/AvailObject;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "([Lavail/descriptor/representation/AvailObject;Lavail/interpreter/execution/Interpreter;)Lavail/optimizer/StackReifier;", "avail"})
public final class L2Simple_CloseFunctionN
extends L2SimpleInstruction {
    @NotNull
    private final A_RawFunction code;
    private final int to;
    private final int outerCount;

    public L2Simple_CloseFunctionN(@NotNull A_RawFunction code, int to) {
        Intrinsics.checkNotNullParameter(code, "code");
        super(null);
        this.code = code;
        this.to = to;
        this.outerCount = A_RawFunction.Companion.getNumOuters(this.code);
    }

    @NotNull
    public final A_RawFunction getCode() {
        return this.code;
    }

    public final int getTo() {
        return this.to;
    }

    public final int getOuterCount() {
        return this.outerCount;
    }

    @Override
    @Nullable
    public StackReifier step(@NotNull AvailObject[] registers, @NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(registers, "registers");
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        AvailObject function = FunctionDescriptor.Companion.createExceptOuters(this.code, this.outerCount);
        int outer = this.to;
        int i = 1;
        int n = this.outerCount;
        if (i <= n) {
            while (true) {
                function.outerVarAtPut(i, registers[outer--]);
                if (i == n) break;
                ++i;
            }
        }
        registers[this.to] = function;
        return null;
    }
}

