/*
 * Decompiled with CFR 0.152.
 */
package avail.utility.dot;

import avail.utility.Strings;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 -2\u00020\u0001:\u0006,-./01B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\u0010\b\u001a\u00060\tj\u0002`\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\rJ\u000e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0003J\u001e\u0010)\u001a\u00020'2\u0016\u0010*\u001a\u0012\u0012\b\u0012\u00060\u0019R\u00020\u0000\u0012\u0004\u0012\u00020'0+R\u0018\u0010\b\u001a\u00060\tj\u0002`\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\u00060\u0011R\u00020\u0000X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0018\u001a\u00060\u0019R\u00020\u0000X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0015\"\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010!\"\u0004\b$\u0010%R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lavail/utility/dot/DotWriter;", "", "name", "", "isDirected", "", "charactersPerLine", "", "accumulator", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "darkMode", "copyrightOwner", "(Ljava/lang/String;ZILjava/lang/Appendable;ZLjava/lang/String;)V", "getAccumulator$avail", "()Ljava/lang/Appendable;", "attributeWriter", "Lavail/utility/dot/DotWriter$AttributeWriter;", "getAttributeWriter$avail", "()Lavail/utility/dot/DotWriter$AttributeWriter;", "getCharactersPerLine$avail", "()I", "getCopyrightOwner", "()Ljava/lang/String;", "graphWriter", "Lavail/utility/dot/DotWriter$GraphWriter;", "getGraphWriter$avail", "()Lavail/utility/dot/DotWriter$GraphWriter;", "indentationLevel", "getIndentationLevel$avail", "setIndentationLevel$avail", "(I)V", "isDirected$avail", "()Z", "justEmittedLinefeed", "getJustEmittedLinefeed$avail", "setJustEmittedLinefeed$avail", "(Z)V", "blockComment", "", "comment", "graph", "block", "Lkotlin/Function1;", "AttributeWriter", "Companion", "CompassPoint", "DecoratedNode", "DefaultAttributeBlockType", "GraphWriter", "avail"})
public final class DotWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    private final boolean isDirected;
    private final int charactersPerLine;
    @NotNull
    private final Appendable accumulator;
    private final boolean darkMode;
    @NotNull
    private final String copyrightOwner;
    private int indentationLevel;
    private boolean justEmittedLinefeed;
    @NotNull
    private final AttributeWriter attributeWriter;
    @NotNull
    private final GraphWriter graphWriter;
    private static final Pattern tab = Pattern.compile("\t", 16);
    private static final Pattern lineFeed = Pattern.compile("\n", 16);
    @NotNull
    private static final Set<String> keywords;
    private static final Pattern tokenPattern;
    @NotNull
    private static final Pattern multicolorPattern;
    @NotNull
    private static final Pattern unicolorPattern;

    public DotWriter(@NotNull String name2, boolean isDirected, int charactersPerLine, @NotNull Appendable accumulator, boolean darkMode, @NotNull String copyrightOwner) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(accumulator, "accumulator");
        Intrinsics.checkNotNullParameter(copyrightOwner, "copyrightOwner");
        this.name = name2;
        this.isDirected = isDirected;
        this.charactersPerLine = charactersPerLine;
        this.accumulator = accumulator;
        this.darkMode = darkMode;
        this.copyrightOwner = copyrightOwner;
        this.justEmittedLinefeed = true;
        this.attributeWriter = new AttributeWriter();
        this.graphWriter = new GraphWriter();
    }

    public /* synthetic */ DotWriter(String string2, boolean bl, int n, Appendable appendable, boolean bl2, String string3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            bl2 = true;
        }
        if ((n2 & 0x20) != 0) {
            String string4 = System.getProperty("user.name");
            Intrinsics.checkNotNullExpressionValue(string4, "getProperty(\"user.name\")");
            string3 = string4;
        }
        this(string2, bl, n, appendable, bl2, string3);
    }

    public final boolean isDirected$avail() {
        return this.isDirected;
    }

    public final int getCharactersPerLine$avail() {
        return this.charactersPerLine;
    }

    @NotNull
    public final Appendable getAccumulator$avail() {
        return this.accumulator;
    }

    @NotNull
    public final String getCopyrightOwner() {
        return this.copyrightOwner;
    }

    public final int getIndentationLevel$avail() {
        return this.indentationLevel;
    }

    public final void setIndentationLevel$avail(int n) {
        this.indentationLevel = n;
    }

    public final boolean getJustEmittedLinefeed$avail() {
        return this.justEmittedLinefeed;
    }

    public final void setJustEmittedLinefeed$avail(boolean bl) {
        this.justEmittedLinefeed = bl;
    }

    @NotNull
    public final AttributeWriter getAttributeWriter$avail() {
        return this.attributeWriter;
    }

    @NotNull
    public final GraphWriter getGraphWriter$avail() {
        return this.graphWriter;
    }

    public final void blockComment(@NotNull String comment) throws IOException {
        Intrinsics.checkNotNullParameter(comment, "comment");
        this.graphWriter.blockComment(comment);
    }

    public final void graph(@NotNull Function1<? super GraphWriter, Unit> block) throws IOException {
        Intrinsics.checkNotNullParameter(block, "block");
        GraphWriter writer = this.graphWriter;
        writer.indent();
        writer.emit(this.isDirected ? "digraph " : "graph ");
        writer.identifier$avail(this.name);
        writer.linefeed$avail();
        writer.subgraph(block);
    }

    static {
        String[] stringArray = new String[]{"strict", "graph", "digraph", "subgraph", "node", "edge"};
        keywords = SetsKt.setOf(stringArray);
        tokenPattern = Pattern.compile("[A-Za-z0-9]+");
        Pattern pattern = Pattern.compile("^#([0-9a-fA-F]{6})/#?([0-9a-fA-F]{6})$");
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(\"^#([0-9a-fA-F]{6})/#?([0-9a-fA-F]{6})$\")");
        multicolorPattern = pattern;
        Pattern pattern2 = Pattern.compile("^#([0-9a-fA-F]{6})$");
        Intrinsics.checkNotNullExpressionValue(pattern2, "compile(\"^#([0-9a-fA-F]{6})$\")");
        unicolorPattern = pattern2;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0096\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0004J$\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0015\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0019J9\u0010\u001a\u001a\u00020\u000b\"\f\b\u0000\u0010\u001b*\u00060\u0000R\u00020\u001c2\u0006\u0010\u001d\u001a\u0002H\u001b2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u0002H\u001b\u0012\u0004\u0012\u00020\u000b0\u001fH\u0000\u00a2\u0006\u0004\b \u0010!J\u0006\u0010\"\u001a\u00020\u000bJ\u0010\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0004H\u0002J\r\u0010%\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b&\u00a8\u0006'"}, d2={"Lavail/utility/dot/DotWriter$AttributeWriter;", "", "(Lavail/utility/dot/DotWriter;)V", "adjust", "", "condition", "", "trueString", "falseString", "rhs", "attribute", "", "lhs", "blockComment", "comment", "emit", "text", "endOfLineComment", "extractLine", "Lkotlin/Pair;", "s", "max", "", "identifier", "proposedId", "identifier$avail", "increaseIndent", "T", "Lavail/utility/dot/DotWriter;", "writer", "block", "Lkotlin/Function1;", "increaseIndent$avail", "(Lavail/utility/dot/DotWriter$AttributeWriter;Lkotlin/jvm/functions/Function1;)V", "indent", "isKeyword", "id", "linefeed", "linefeed$avail", "avail"})
    public class AttributeWriter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T extends AttributeWriter> void increaseIndent$avail(@NotNull T writer, @NotNull Function1<? super T, Unit> block) throws IOException {
            Intrinsics.checkNotNullParameter(writer, "writer");
            Intrinsics.checkNotNullParameter(block, "block");
            DotWriter dotWriter = DotWriter.this;
            int n = dotWriter.getIndentationLevel$avail();
            dotWriter.setIndentationLevel$avail(n + 1);
            try {
                block.invoke(writer);
            }
            finally {
                dotWriter = DotWriter.this;
                n = dotWriter.getIndentationLevel$avail();
                dotWriter.setIndentationLevel$avail(n + -1);
            }
        }

        public final void indent() throws IOException {
            boolean bl;
            boolean bl2 = bl = DotWriter.this.getIndentationLevel$avail() >= 0;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-DotWriter$AttributeWriter$indent$32 = false;
                String $i$a$-assert-DotWriter$AttributeWriter$indent$32 = "indentation level must not be negative";
                throw new AssertionError((Object)$i$a$-assert-DotWriter$AttributeWriter$indent$32);
            }
            bl = DotWriter.this.getJustEmittedLinefeed$avail();
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = "indentation must only be emitted after a linefeed";
                throw new AssertionError((Object)string2);
            }
            DotWriter.this.getAccumulator$avail().append(Strings.INSTANCE.tabs(DotWriter.this.getIndentationLevel$avail()));
            DotWriter.this.setJustEmittedLinefeed$avail(false);
        }

        public final void emit(@NotNull String text) throws IOException {
            Intrinsics.checkNotNullParameter(text, "text");
            DotWriter.this.getAccumulator$avail().append(text);
            DotWriter.this.setJustEmittedLinefeed$avail(StringsKt.endsWith$default(text, "\n", false, 2, null));
        }

        public final void linefeed$avail() throws IOException {
            DotWriter.this.getAccumulator$avail().append('\n');
            DotWriter.this.setJustEmittedLinefeed$avail(true);
        }

        public final void endOfLineComment(@NotNull String comment) throws IOException {
            Intrinsics.checkNotNullParameter(comment, "comment");
            DotWriter.this.getAccumulator$avail().append("//");
            if (((CharSequence)comment).length() > 0) {
                DotWriter.this.getAccumulator$avail().append(' ');
                DotWriter.this.getAccumulator$avail().append(comment);
            }
            this.linefeed$avail();
        }

        private final Pair<String, String> extractLine(String s, int max) {
            int whiteIndex = 0;
            int whiteRun = 0;
            int i = 0;
            int lineLimit = Math.min(s.length(), max);
            while (i < lineLimit) {
                int cp = s.codePointAt(i);
                if (cp == 10) {
                    String string2 = s.substring(0, i);
                    Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                    String string3 = s.substring(i + 1);
                    Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).substring(startIndex)");
                    return TuplesKt.to(string2, string3);
                }
                if (Character.isWhitespace(cp)) {
                    int sz;
                    whiteIndex = i;
                    whiteRun = 0;
                    do {
                        sz = Character.charCount(cp);
                        whiteRun += sz;
                    } while (Character.isWhitespace(cp = (i += sz) < s.length() ? s.codePointAt(i) : 120));
                    continue;
                }
                i += Character.charCount(cp);
            }
            if (whiteIndex > 0) {
                String string4 = s.substring(0, whiteIndex);
                Intrinsics.checkNotNullExpressionValue(string4, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                String string5 = s.substring(whiteIndex + whiteRun);
                Intrinsics.checkNotNullExpressionValue(string5, "this as java.lang.String).substring(startIndex)");
                return new Pair<String, String>(string4, string5);
            }
            int wideLimit = s.length();
            while (i < wideLimit) {
                int cp = s.codePointAt(i);
                if (Character.isWhitespace(cp)) {
                    int sz;
                    whiteIndex = i;
                    whiteRun = 0;
                    do {
                        sz = Character.charCount(cp);
                        whiteRun += sz;
                    } while (Character.isWhitespace(cp = (i += sz) < wideLimit ? s.codePointAt(i) : 120));
                    break;
                }
                i += Character.charCount(cp);
            }
            if (whiteIndex == 0) {
                boolean bl;
                boolean bl2 = bl = whiteRun == 0;
                if (_Assertions.ENABLED && !bl) {
                    String string6 = "Assertion failed";
                    throw new AssertionError((Object)string6);
                }
                return TuplesKt.to(s, "");
            }
            String string7 = s.substring(0, whiteIndex);
            Intrinsics.checkNotNullExpressionValue(string7, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            String string8 = s.substring(whiteIndex + whiteRun);
            Intrinsics.checkNotNullExpressionValue(string8, "this as java.lang.String).substring(startIndex)");
            return new Pair<String, String>(string7, string8);
        }

        public final void blockComment(@NotNull String comment) throws IOException {
            Intrinsics.checkNotNullParameter(comment, "comment");
            int limit = Math.max(1, DotWriter.this.getCharactersPerLine$avail() - 4 * DotWriter.this.getIndentationLevel$avail() - 3);
            String residue = comment;
            while (((CharSequence)residue).length() > 0) {
                Pair<String, String> pair = this.extractLine(residue, limit);
                String line = pair.getFirst();
                this.indent();
                this.endOfLineComment(line);
                residue = pair.getSecond();
            }
        }

        private final boolean isKeyword(String id) {
            return Companion.getKeywords$avail().contains(id);
        }

        public final void identifier$avail(@NotNull String proposedId) throws IOException {
            Intrinsics.checkNotNullParameter(proposedId, "proposedId");
            Object id = null;
            id = this.isKeyword(proposedId) ? "\"" + proposedId + "\"" : (Companion.getTokenPattern$avail().matcher(proposedId).matches() ? proposedId : (StringsKt.startsWith$default(proposedId, "<", false, 2, null) ? "<" + proposedId + ">" : "\"" + proposedId.codePoints().mapToObj(AttributeWriter::identifier$lambda-2).collect(Collectors.joining()) + "\""));
            this.emit((String)id);
        }

        public final void attribute(@NotNull String lhs, @NotNull String rhs2) throws IOException {
            Intrinsics.checkNotNullParameter(lhs, "lhs");
            Intrinsics.checkNotNullParameter(rhs2, "rhs");
            boolean isColor = StringsKt.contains$default((CharSequence)lhs, "color", false, 2, null);
            this.indent();
            this.identifier$avail(lhs);
            this.emit(" = ");
            this.identifier$avail(isColor ? this.adjust(rhs2) : rhs2);
            this.linefeed$avail();
        }

        @NotNull
        public final String adjust(@NotNull String rhs2) {
            Intrinsics.checkNotNullParameter(rhs2, "rhs");
            Matcher multiMatcher = Companion.getMulticolorPattern().matcher(rhs2);
            if (multiMatcher.find()) {
                return "#" + multiMatcher.group(DotWriter.this.darkMode ? 2 : 1);
            }
            if (!DotWriter.this.darkMode) {
                return rhs2;
            }
            Matcher uniMatcher = Companion.getUnicolorPattern().matcher(rhs2);
            if (uniMatcher.find()) {
                int original = Integer.parseInt(uniMatcher.group(1), 16);
                int r = original >> 16;
                int g = original >> 16 & 0xFF;
                int b = original & 0xFF;
                r = 255 - (255 - r >> 1);
                g = 255 - (255 - g >> 1);
                b = 255 - (255 - b >> 1);
                String string2 = "#%02x%02x%02x";
                Object[] objectArray = new Object[]{r, g, b};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
                return string3;
            }
            return rhs2;
        }

        @NotNull
        public final String adjust(boolean condition, @NotNull String trueString, @NotNull String falseString) {
            Intrinsics.checkNotNullParameter(trueString, "trueString");
            Intrinsics.checkNotNullParameter(falseString, "falseString");
            return this.adjust(condition ? trueString : falseString);
        }

        private static final String identifier$lambda-2(int cp) {
            String string2;
            int n = cp;
            if (n == 34) {
                string2 = "\\\"";
            } else if (n == 10) {
                string2 = "\\n";
            } else {
                char[] cArray = Character.toChars(cp);
                Intrinsics.checkNotNullExpressionValue(cArray, "toChars(cp)");
                char[] cArray2 = cArray;
                string2 = new String(cArray2);
            }
            String s = string2;
            return s;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lavail/utility/dot/DotWriter$DefaultAttributeBlockType;", "", "(Ljava/lang/String;I)V", "GRAPH", "NODE", "EDGE", "avail"})
    public static final class DefaultAttributeBlockType
    extends Enum<DefaultAttributeBlockType> {
        public static final /* enum */ DefaultAttributeBlockType GRAPH = new DefaultAttributeBlockType();
        public static final /* enum */ DefaultAttributeBlockType NODE = new DefaultAttributeBlockType();
        public static final /* enum */ DefaultAttributeBlockType EDGE = new DefaultAttributeBlockType();
        private static final /* synthetic */ DefaultAttributeBlockType[] $VALUES;

        public static DefaultAttributeBlockType[] values() {
            return (DefaultAttributeBlockType[])$VALUES.clone();
        }

        public static DefaultAttributeBlockType valueOf(String value) {
            return Enum.valueOf(DefaultAttributeBlockType.class, value);
        }

        static {
            $VALUES = defaultAttributeBlockTypeArray = new DefaultAttributeBlockType[]{DefaultAttributeBlockType.GRAPH, DefaultAttributeBlockType.NODE, DefaultAttributeBlockType.EDGE};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lavail/utility/dot/DotWriter$CompassPoint;", "", "(Ljava/lang/String;I)V", "NW", "N", "NE", "W", "C", "E", "SW", "S", "SE", "avail"})
    public static final class CompassPoint
    extends Enum<CompassPoint> {
        public static final /* enum */ CompassPoint NW = new CompassPoint();
        public static final /* enum */ CompassPoint N = new CompassPoint();
        public static final /* enum */ CompassPoint NE = new CompassPoint();
        public static final /* enum */ CompassPoint W = new CompassPoint();
        public static final /* enum */ CompassPoint C = new CompassPoint();
        public static final /* enum */ CompassPoint E = new CompassPoint();
        public static final /* enum */ CompassPoint SW = new CompassPoint();
        public static final /* enum */ CompassPoint S = new CompassPoint();
        public static final /* enum */ CompassPoint SE = new CompassPoint();
        private static final /* synthetic */ CompassPoint[] $VALUES;

        public static CompassPoint[] values() {
            return (CompassPoint[])$VALUES.clone();
        }

        public static CompassPoint valueOf(String value) {
            return Enum.valueOf(CompassPoint.class, value);
        }

        static {
            $VALUES = compassPointArray = new CompassPoint[]{CompassPoint.NW, CompassPoint.N, CompassPoint.NE, CompassPoint.W, CompassPoint.C, CompassPoint.E, CompassPoint.SW, CompassPoint.S, CompassPoint.SE};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B#\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\r"}, d2={"Lavail/utility/dot/DotWriter$DecoratedNode;", "", "name", "", "port", "compassPoint", "Lavail/utility/dot/DotWriter$CompassPoint;", "(Ljava/lang/String;Ljava/lang/String;Lavail/utility/dot/DotWriter$CompassPoint;)V", "getCompassPoint$avail", "()Lavail/utility/dot/DotWriter$CompassPoint;", "getName$avail", "()Ljava/lang/String;", "getPort$avail", "avail"})
    public static final class DecoratedNode {
        @NotNull
        private final String name;
        @Nullable
        private final String port;
        @Nullable
        private final CompassPoint compassPoint;

        public DecoratedNode(@NotNull String name2, @Nullable String port, @Nullable CompassPoint compassPoint) {
            Intrinsics.checkNotNullParameter(name2, "name");
            this.name = name2;
            this.port = port;
            this.compassPoint = compassPoint;
        }

        @NotNull
        public final String getName$avail() {
            return this.name;
        }

        @Nullable
        public final String getPort$avail() {
            return this.port;
        }

        @Nullable
        public final CompassPoint getCompassPoint$avail() {
            return this.compassPoint;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0016\u0010\u0006\u001a\u0012\u0012\b\u0012\u00060\u0001R\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0007H\u0002J&\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0016\u0010\u0006\u001a\u0012\u0012\b\u0012\u00060\u0001R\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0007JP\u0010\u000b\u001a\u00020\u00052\u0016\u0010\f\u001a\u0012\u0012\b\u0012\u00060\u0000R\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u00072\u0016\u0010\r\u001a\u0012\u0012\b\u0012\u00060\u0000R\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u00072\u0018\u0010\u0006\u001a\u0014\u0012\b\u0012\u00060\u0001R\u00020\u0002\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0007J@\u0010\u000b\u001a\u00020\u00052\u0016\u0010\f\u001a\u0012\u0012\b\u0012\u00060\u0000R\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0018\u0010\u0006\u001a\u0014\u0012\b\u0012\u00060\u0001R\u00020\u0002\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0007J@\u0010\u000b\u001a\u00020\u00052\u0016\u0010\f\u001a\u0012\u0012\b\u0012\u00060\u0000R\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\r\u001a\u00020\u000f2\u0018\u0010\u0006\u001a\u0014\u0012\b\u0012\u00060\u0001R\u00020\u0002\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0007J@\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u000e2\u0016\u0010\r\u001a\u0012\u0012\b\u0012\u00060\u0000R\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u00072\u0018\u0010\u0006\u001a\u0014\u0012\b\u0012\u00060\u0001R\u00020\u0002\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0007J0\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0018\u0010\u0006\u001a\u0014\u0012\b\u0012\u00060\u0001R\u00020\u0002\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0007J@\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u000f2\u0016\u0010\r\u001a\u0012\u0012\b\u0012\u00060\u0000R\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u00072\u0018\u0010\u0006\u001a\u0014\u0012\b\u0012\u00060\u0001R\u00020\u0002\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0007J0\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u000f2\u0018\u0010\u0006\u001a\u0014\u0012\b\u0012\u00060\u0001R\u00020\u0002\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0007J\b\u0010\u0010\u001a\u00020\u0005H\u0002J.\u0010\u0011\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0018\u0010\u0006\u001a\u0014\u0012\b\u0012\u00060\u0001R\u00020\u0002\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0007J(\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u000f2\u0018\u0010\u0006\u001a\u0014\u0012\b\u0012\u00060\u0001R\u00020\u0002\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0007J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u001e\u0010\u0018\u001a\u00020\u00052\u0016\u0010\u0006\u001a\u0012\u0012\b\u0012\u00060\u0000R\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0007J&\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u000f2\u0016\u0010\u0006\u001a\u0012\u0012\b\u0012\u00060\u0000R\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0007\u00a8\u0006\u001a"}, d2={"Lavail/utility/dot/DotWriter$GraphWriter;", "Lavail/utility/dot/DotWriter$AttributeWriter;", "Lavail/utility/dot/DotWriter;", "(Lavail/utility/dot/DotWriter;)V", "attributeBlock", "", "block", "Lkotlin/Function1;", "defaultAttributeBlock", "type", "Lavail/utility/dot/DotWriter$DefaultAttributeBlockType;", "edge", "source", "target", "Lavail/utility/dot/DotWriter$DecoratedNode;", "", "edgeOperator", "interleaved", "nodes", "", "", "node", "nodeName", "nodeReference", "subgraph", "subgraphName", "avail"})
    public final class GraphWriter
    extends AttributeWriter {
        private final void attributeBlock(Function1<? super AttributeWriter, Unit> block) throws IOException {
            this.indent();
            this.emit("[\n");
            this.increaseIndent$avail(DotWriter.this.getAttributeWriter$avail(), block);
            this.indent();
            this.emit("]\n");
        }

        public final void defaultAttributeBlock(@NotNull DefaultAttributeBlockType type2, @NotNull Function1<? super AttributeWriter, Unit> block) throws IOException {
            Intrinsics.checkNotNullParameter((Object)type2, "type");
            Intrinsics.checkNotNullParameter(block, "block");
            this.indent();
            String string2 = type2.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
            this.emit(string2);
            this.linefeed$avail();
            this.attributeBlock(block);
        }

        public final void subgraph(@NotNull Function1<? super GraphWriter, Unit> block) throws IOException {
            Intrinsics.checkNotNullParameter(block, "block");
            this.indent();
            this.emit("{\n");
            this.increaseIndent$avail((AttributeWriter)DotWriter.this.getGraphWriter$avail(), block);
            this.indent();
            this.emit("}\n");
        }

        public final void subgraph(@NotNull String subgraphName, @NotNull Function1<? super GraphWriter, Unit> block) throws IOException {
            Intrinsics.checkNotNullParameter(subgraphName, "subgraphName");
            Intrinsics.checkNotNullParameter(block, "block");
            this.indent();
            this.emit("subgraph ");
            this.identifier$avail(subgraphName);
            this.linefeed$avail();
            this.subgraph(block);
        }

        public final void node(@NotNull String nodeName, @Nullable Function1<? super AttributeWriter, Unit> block) throws IOException {
            Intrinsics.checkNotNullParameter(nodeName, "nodeName");
            this.indent();
            this.identifier$avail(nodeName);
            this.linefeed$avail();
            if (block != null) {
                this.attributeBlock(block);
            }
        }

        private final void edgeOperator() throws IOException {
            this.emit(DotWriter.this.isDirected$avail() ? " -> " : " -- ");
        }

        public final void edge(@NotNull String source2, @NotNull String target, @Nullable Function1<? super AttributeWriter, Unit> block) throws IOException {
            Intrinsics.checkNotNullParameter(source2, "source");
            Intrinsics.checkNotNullParameter(target, "target");
            this.indent();
            this.identifier$avail(source2);
            this.edgeOperator();
            this.identifier$avail(target);
            this.linefeed$avail();
            if (block != null) {
                this.attributeBlock(block);
            }
        }

        private final void nodeReference(DecoratedNode node) {
            this.identifier$avail(node.getName$avail());
            if (node.getPort$avail() != null) {
                this.emit(":");
                this.identifier$avail(node.getPort$avail());
            }
            if (node.getCompassPoint$avail() != null) {
                this.emit(":");
                String string2 = node.getCompassPoint$avail().name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                this.emit(string2);
            }
        }

        public final void edge(@NotNull DecoratedNode source2, @NotNull DecoratedNode target, @Nullable Function1<? super AttributeWriter, Unit> block) throws IOException {
            Intrinsics.checkNotNullParameter(source2, "source");
            Intrinsics.checkNotNullParameter(target, "target");
            this.indent();
            this.nodeReference(source2);
            this.edgeOperator();
            this.nodeReference(target);
            this.linefeed$avail();
            if (block != null) {
                this.attributeBlock(block);
            }
        }

        public final void edge(@NotNull Function1<? super GraphWriter, Unit> source2, @NotNull String target, @Nullable Function1<? super AttributeWriter, Unit> block) throws IOException {
            Intrinsics.checkNotNullParameter(source2, "source");
            Intrinsics.checkNotNullParameter(target, "target");
            this.subgraph(source2);
            this.edgeOperator();
            this.identifier$avail(target);
            this.linefeed$avail();
            if (block != null) {
                this.attributeBlock(block);
            }
        }

        public final void edge(@NotNull Function1<? super GraphWriter, Unit> source2, @NotNull DecoratedNode target, @Nullable Function1<? super AttributeWriter, Unit> block) throws IOException {
            Intrinsics.checkNotNullParameter(source2, "source");
            Intrinsics.checkNotNullParameter(target, "target");
            this.subgraph(source2);
            this.edgeOperator();
            this.nodeReference(target);
            this.linefeed$avail();
            if (block != null) {
                this.attributeBlock(block);
            }
        }

        public final void edge(@NotNull String source2, @NotNull Function1<? super GraphWriter, Unit> target, @Nullable Function1<? super AttributeWriter, Unit> block) throws IOException {
            Intrinsics.checkNotNullParameter(source2, "source");
            Intrinsics.checkNotNullParameter(target, "target");
            this.identifier$avail(source2);
            this.edgeOperator();
            this.linefeed$avail();
            this.subgraph(target);
            this.linefeed$avail();
            if (block != null) {
                this.attributeBlock(block);
            }
        }

        public final void edge(@NotNull DecoratedNode source2, @NotNull Function1<? super GraphWriter, Unit> target, @Nullable Function1<? super AttributeWriter, Unit> block) throws IOException {
            Intrinsics.checkNotNullParameter(source2, "source");
            Intrinsics.checkNotNullParameter(target, "target");
            this.nodeReference(source2);
            this.edgeOperator();
            this.linefeed$avail();
            this.subgraph(target);
            this.linefeed$avail();
            if (block != null) {
                this.attributeBlock(block);
            }
        }

        public final void edge(@NotNull Function1<? super GraphWriter, Unit> source2, @NotNull Function1<? super GraphWriter, Unit> target, @Nullable Function1<? super AttributeWriter, Unit> block) throws IOException {
            Intrinsics.checkNotNullParameter(source2, "source");
            Intrinsics.checkNotNullParameter(target, "target");
            this.subgraph(source2);
            this.edgeOperator();
            this.linefeed$avail();
            this.subgraph(target);
            this.linefeed$avail();
            if (block != null) {
                this.attributeBlock(block);
            }
        }

        public final void interleaved(@NotNull List<? extends Object> nodes, @Nullable Function1<? super AttributeWriter, Unit> block) throws IOException {
            Intrinsics.checkNotNullParameter(nodes, "nodes");
            if (!((Collection)nodes).isEmpty()) {
                int limit = nodes.size();
                for (int i = 0; i < limit; ++i) {
                    Object o = nodes.get(i);
                    if (o instanceof String) {
                        this.identifier$avail((String)o);
                    } else if (o instanceof DecoratedNode) {
                        this.identifier$avail(((DecoratedNode)o).getName$avail());
                        if (((DecoratedNode)o).getPort$avail() != null) {
                            this.emit(":");
                            this.identifier$avail(((DecoratedNode)o).getPort$avail());
                        }
                        if (((DecoratedNode)o).getCompassPoint$avail() != null) {
                            this.emit(":");
                            String string2 = ((DecoratedNode)o).getCompassPoint$avail().name().toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                            this.identifier$avail(string2);
                        }
                    } else if (TypeIntrinsics.isFunctionOfArity(o, 1)) {
                        if (i != 0) {
                            this.linefeed$avail();
                        }
                        Object $this$cast$iv = o;
                        boolean $i$f$cast = false;
                        this.subgraph((Function1)$this$cast$iv);
                    } else {
                        if (_Assertions.ENABLED) {
                            boolean bl = false;
                            String string3 = ((Object)StringsKt.trim((CharSequence)("allowed node types are String, DecoratedNode\n\t\t\t\t\t\t\tand CheckedConsumer<GraphWriter>, but\n\t\t\t\t\t\t\t" + o.getClass().getName() + " is none of these"))).toString();
                            throw new AssertionError((Object)string3);
                        }
                        throw new RuntimeException();
                    }
                    if (i >= limit - 1) continue;
                    this.edgeOperator();
                }
                this.linefeed$avail();
                if (block != null) {
                    this.attributeBlock(block);
                }
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0011\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\r\u00a8\u0006\u001d"}, d2={"Lavail/utility/dot/DotWriter$Companion;", "", "()V", "keywords", "", "", "getKeywords$avail", "()Ljava/util/Set;", "lineFeed", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "multicolorPattern", "getMulticolorPattern", "()Ljava/util/regex/Pattern;", "tab", "tokenPattern", "getTokenPattern$avail", "unicolorPattern", "getUnicolorPattern", "label", "text", "leftJustified", "node", "Lavail/utility/dot/DotWriter$DecoratedNode;", "name", "port", "compassPoint", "Lavail/utility/dot/DotWriter$CompassPoint;", "rightJustified", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String label(@NotNull String text) {
            Intrinsics.checkNotNullParameter(text, "text");
            String string2 = tab.matcher(text).replaceAll(Matcher.quoteReplacement("    "));
            Intrinsics.checkNotNullExpressionValue(string2, "tab.matcher(text).replac\u2026quoteReplacement(\"    \"))");
            return string2;
        }

        @NotNull
        public final String leftJustified(@NotNull String text) {
            Intrinsics.checkNotNullParameter(text, "text");
            String string2 = lineFeed.matcher(this.label(text)).replaceAll(Matcher.quoteReplacement("\\l"));
            Intrinsics.checkNotNullExpressionValue(string2, "lineFeed.matcher(label(t\u2026.quoteReplacement(\"\\\\l\"))");
            return string2;
        }

        @NotNull
        public final String rightJustified(@NotNull String text) {
            Intrinsics.checkNotNullParameter(text, "text");
            String string2 = lineFeed.matcher(this.label(text)).replaceAll(Matcher.quoteReplacement("\\r"));
            Intrinsics.checkNotNullExpressionValue(string2, "lineFeed.matcher(label(t\u2026.quoteReplacement(\"\\\\r\"))");
            return string2;
        }

        @NotNull
        public final Set<String> getKeywords$avail() {
            return keywords;
        }

        public final Pattern getTokenPattern$avail() {
            return tokenPattern;
        }

        @NotNull
        public final DecoratedNode node(@NotNull String name2) {
            Intrinsics.checkNotNullParameter(name2, "name");
            return new DecoratedNode(name2, null, null);
        }

        @NotNull
        public final DecoratedNode node(@NotNull String name2, @NotNull String port) {
            Intrinsics.checkNotNullParameter(name2, "name");
            Intrinsics.checkNotNullParameter(port, "port");
            return new DecoratedNode(name2, port, null);
        }

        @NotNull
        public final DecoratedNode node(@NotNull String name2, @NotNull String port, @NotNull CompassPoint compassPoint) {
            Intrinsics.checkNotNullParameter(name2, "name");
            Intrinsics.checkNotNullParameter(port, "port");
            Intrinsics.checkNotNullParameter((Object)compassPoint, "compassPoint");
            return new DecoratedNode(name2, port, compassPoint);
        }

        @NotNull
        public final Pattern getMulticolorPattern() {
            return multicolorPattern;
        }

        @NotNull
        public final Pattern getUnicolorPattern() {
            return unicolorPattern;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

