/*
 * Decompiled with CFR 0.152.
 */
package org.availlang.artifact.environment.project;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.availlang.artifact.AvailArtifactException;
import org.availlang.artifact.environment.location.AvailLocation;
import org.availlang.artifact.environment.project.AvailProjectRoot;
import org.availlang.artifact.environment.project.AvailProjectV1;
import org.availlang.json.JSONFriendly;
import org.availlang.json.JSONObject;
import org.availlang.json.JSONWriter;
import org.availlang.json.UtilityKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\bf\u0018\u0000 -2\u00020\u0001:\u0001-J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0004H\u0016J\u0012\u0010+\u001a\u0004\u0018\u00010\u00042\u0006\u0010,\u001a\u00020\fH\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\f\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0012\u0010\u0013\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u0018\u0010\u0015\u001a\u00020\fX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0010\"\u0004\b\u0017\u0010\u0018R\u0012\u0010\u0019\u001a\u00020\u001aX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\u001eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0012\u0010!\u001a\u00020\"X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u001e\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010 \u00a8\u0006.\u00c0\u0006\u0003"}, d2={"Lorg/availlang/artifact/environment/project/AvailProject;", "Lorg/availlang/json/JSONFriendly;", "availProjectRoots", "", "Lorg/availlang/artifact/environment/project/AvailProjectRoot;", "getAvailProjectRoots", "()Ljava/util/List;", "darkMode", "", "getDarkMode", "()Z", "fileContent", "", "getFileContent$annotations", "()V", "getFileContent", "()Ljava/lang/String;", "id", "getId", "name", "getName", "projectCopyright", "getProjectCopyright", "setProjectCopyright", "(Ljava/lang/String;)V", "repositoryLocation", "Lorg/availlang/artifact/environment/location/AvailLocation;", "getRepositoryLocation", "()Lorg/availlang/artifact/environment/location/AvailLocation;", "roots", "", "getRoots", "()Ljava/util/Map;", "serializationVersion", "", "getSerializationVersion", "()I", "templates", "", "getTemplates", "addRoot", "", "availProjectRoot", "removeRoot", "projectRoot", "Companion", "avail-artifact"})
public interface AvailProject
extends JSONFriendly {
    @NotNull
    public static final Companion Companion = org.availlang.artifact.environment.project.AvailProject$Companion.$$INSTANCE;
    @NotNull
    public static final String CONFIG_FILE_NAME = "avail-config.json";
    @NotNull
    public static final String ROOTS_DIR = "roots";

    @NotNull
    public String getName();

    public int getSerializationVersion();

    @NotNull
    public AvailLocation getRepositoryLocation();

    @NotNull
    public String getId();

    public boolean getDarkMode();

    @NotNull
    public Map<String, AvailProjectRoot> getRoots();

    @NotNull
    public Map<String, String> getTemplates();

    @NotNull
    public String getProjectCopyright();

    public void setProjectCopyright(@NotNull String var1);

    @NotNull
    default public List<AvailProjectRoot> getAvailProjectRoots() {
        Iterable $this$sortedBy$iv = CollectionsKt.toList((Iterable)this.getRoots().values());
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                AvailProjectRoot it = (AvailProjectRoot)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (AvailProjectRoot)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getName()));
            }
        });
    }

    default public void addRoot(@NotNull AvailProjectRoot availProjectRoot) {
        Intrinsics.checkNotNullParameter(availProjectRoot, "availProjectRoot");
        this.getRoots().put(availProjectRoot.getId(), availProjectRoot);
    }

    @Nullable
    default public AvailProjectRoot removeRoot(@NotNull String projectRoot) {
        Intrinsics.checkNotNullParameter(projectRoot, "projectRoot");
        return this.getRoots().remove(projectRoot);
    }

    @NotNull
    default public String getFileContent() {
        return UtilityKt.jsonPrettyPrintWriter((Function1<? super JSONWriter, Unit>)new Function1<JSONWriter, Unit>(this){
            final /* synthetic */ AvailProject this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull JSONWriter $this$jsonPrettyPrintWriter) {
                Intrinsics.checkNotNullParameter($this$jsonPrettyPrintWriter, "$this$jsonPrettyPrintWriter");
                this.this$0.writeTo($this$jsonPrettyPrintWriter);
            }
        }).toString();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0002\u00a8\u0006\u000e"}, d2={"Lorg/availlang/artifact/environment/project/AvailProject$Companion;", "", "()V", "CONFIG_FILE_NAME", "", "CURRENT_PROJECT_VERSION", "", "ROOTS_DIR", "getROOTS_DIR$annotations", "from", "Lorg/availlang/artifact/environment/project/AvailProject;", "projectDirectory", "obj", "Lorg/availlang/json/JSONObject;", "avail-artifact"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        private static final int CURRENT_PROJECT_VERSION = 1;
        @NotNull
        public static final String CONFIG_FILE_NAME = "avail-config.json";
        @NotNull
        public static final String ROOTS_DIR = "roots";

        private Companion() {
        }

        public static /* synthetic */ void getROOTS_DIR$annotations() {
        }

        @NotNull
        public final AvailProject from(@NotNull String projectDirectory, @NotNull JSONObject obj) {
            Intrinsics.checkNotNullParameter(projectDirectory, "projectDirectory");
            Intrinsics.checkNotNullParameter(obj, "obj");
            int version = obj.getNumber("serializationVersion").getInt();
            if (version != 1) {
                throw new AvailArtifactException("Invalid Avail Project: Version " + version + " is not in the valid range of known project versions, [1, 1].");
            }
            return AvailProjectV1.Companion.from(projectDirectory, obj);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        @NotNull
        public static List<AvailProjectRoot> getAvailProjectRoots(@NotNull AvailProject $this) {
            return $this.getAvailProjectRoots();
        }

        @Deprecated
        public static void addRoot(@NotNull AvailProject $this, @NotNull AvailProjectRoot availProjectRoot) {
            Intrinsics.checkNotNullParameter(availProjectRoot, "availProjectRoot");
            $this.addRoot(availProjectRoot);
        }

        @Deprecated
        @Nullable
        public static AvailProjectRoot removeRoot(@NotNull AvailProject $this, @NotNull String projectRoot) {
            Intrinsics.checkNotNullParameter(projectRoot, "projectRoot");
            return $this.removeRoot(projectRoot);
        }

        @Deprecated
        @NotNull
        public static String getFileContent(@NotNull AvailProject $this) {
            return $this.getFileContent();
        }

        public static /* synthetic */ void getFileContent$annotations() {
        }
    }
}

