/*
 * Decompiled with CFR 0.152.
 */
package avail.compiler.splitter;

import avail.compiler.ParsingOperation;
import avail.compiler.splitter.Expression;
import avail.compiler.splitter.InstructionGenerator;
import avail.compiler.splitter.MessageSplitter;
import avail.compiler.splitter.SectionCheckpoint;
import avail.compiler.splitter.Sequence;
import avail.compiler.splitter.WrapState;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.EnumerationTypeDescriptor;
import avail.descriptor.types.ListPhraseTypeDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.SignatureException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u0016\u001a\u00020\u0000H\u0010\u00a2\u0006\u0002\b\u0017J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001d\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b J\u001c\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001c0%J%\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010)\u001a\u00020'H\u0010\u00a2\u0006\u0002\b*J\u001b\u0010+\u001a\u00020\u001c2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0010\u00a2\u0006\u0002\b/J\u0015\u00100\u001a\u00020\b2\u0006\u0010(\u001a\u00020\u001eH\u0010\u00a2\u0006\u0002\b1J1\u00102\u001a\u00020\u001c2\u000e\u00103\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u0001042\n\u00105\u001a\u000606j\u0002`72\u0006\u00108\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b9J\b\u0010:\u001a\u00020;H\u0016R\u0014\u0010\u0007\u001a\u00020\b8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\b8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u0014\u0010\u000f\u001a\u00020\b8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\nR\u0014\u0010\u0011\u001a\u00020\u00038PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\b8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\n\u00a8\u0006<"}, d2={"Lavail/compiler/splitter/Optional;", "Lavail/compiler/splitter/Expression;", "positionInName", "", "sequence", "Lavail/compiler/splitter/Sequence;", "(ILavail/compiler/splitter/Sequence;)V", "isLowerCase", "", "isLowerCase$avail", "()Z", "recursivelyContainsReorders", "getRecursivelyContainsReorders", "shouldBeSeparatedOnLeft", "getShouldBeSeparatedOnLeft$avail", "shouldBeSeparatedOnRight", "getShouldBeSeparatedOnRight$avail", "underscoreCount", "getUnderscoreCount$avail", "()I", "yieldsValue", "getYieldsValue$avail", "applyCaseInsensitive", "applyCaseInsensitive$avail", "checkListStructure", "phrase", "Lavail/descriptor/phrases/A_Phrase;", "checkType", "", "argumentType", "Lavail/descriptor/types/A_Type;", "sectionNumber", "checkType$avail", "emitInRunThen", "generator", "Lavail/compiler/splitter/InstructionGenerator;", "function", "Lkotlin/Function0;", "emitOn", "Lavail/compiler/splitter/WrapState;", "phraseType", "wrapState", "emitOn$avail", "extractSectionCheckpointsInto", "sectionCheckpoints", "", "Lavail/compiler/splitter/SectionCheckpoint;", "extractSectionCheckpointsInto$avail", "mightBeEmpty", "mightBeEmpty$avail", "printWithArguments", "arguments", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "indent", "printWithArguments$avail", "toString", "", "avail"})
public final class Optional
extends Expression {
    @NotNull
    private final Sequence sequence;

    public Optional(int positionInName, @NotNull Sequence sequence) {
        Intrinsics.checkNotNullParameter((Object)sequence, (String)"sequence");
        super(positionInName);
        this.sequence = sequence;
    }

    @Override
    public boolean getRecursivelyContainsReorders() {
        return this.sequence.getRecursivelyContainsReorders();
    }

    @Override
    public boolean getYieldsValue$avail() {
        return true;
    }

    @Override
    public boolean isLowerCase$avail() {
        return this.sequence.isLowerCase$avail();
    }

    @Override
    @NotNull
    public Optional applyCaseInsensitive$avail() {
        return new Optional(this.getPositionInName(), this.sequence.applyCaseInsensitive$avail());
    }

    @Override
    public int getUnderscoreCount$avail() {
        boolean bl;
        boolean bl2 = bl = this.sequence.getUnderscoreCount$avail() == 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return 0;
    }

    @Override
    public void extractSectionCheckpointsInto$avail(@NotNull List<SectionCheckpoint> sectionCheckpoints) {
        Intrinsics.checkNotNullParameter(sectionCheckpoints, (String)"sectionCheckpoints");
        this.sequence.extractSectionCheckpointsInto$avail(sectionCheckpoints);
    }

    @Override
    public void checkType$avail(@NotNull A_Type argumentType, int sectionNumber) throws SignatureException {
        Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
        if (!A_Type.Companion.isSubtypeOf(argumentType, EnumerationTypeDescriptor.Companion.getBooleanType())) {
            MessageSplitter.Companion.throwSignatureException(AvailErrorCode.E_INCORRECT_TYPE_FOR_BOOLEAN_GROUP);
            throw new KotlinNothingValueException();
        }
    }

    @Override
    @NotNull
    public WrapState emitOn$avail(@NotNull A_Type phraseType, @NotNull InstructionGenerator generator, @NotNull WrapState wrapState) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)phraseType, (String)"phraseType");
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        Intrinsics.checkNotNullParameter((Object)((Object)wrapState), (String)"wrapState");
        generator.flushDelayed();
        boolean needsProgressCheck = this.sequence.mightBeEmpty$avail(ListPhraseTypeDescriptor.Companion.emptyListPhraseType());
        InstructionGenerator.Label $absent = new InstructionGenerator.Label();
        generator.emitBranchForward(this, $absent);
        generator.emitIf(needsProgressCheck, this, ParsingOperation.SAVE_PARSE_POSITION);
        boolean bl2 = bl = !this.sequence.isReordered();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.sequence.emitOn$avail(ListPhraseTypeDescriptor.Companion.emptyListPhraseType(), generator, WrapState.SHOULD_NOT_HAVE_ARGUMENTS);
        generator.flushDelayed();
        generator.emitIf(needsProgressCheck, this, ParsingOperation.ENSURE_PARSE_PROGRESS);
        generator.emitIf(needsProgressCheck, this, ParsingOperation.DISCARD_SAVED_PARSE_POSITION);
        generator.emit((Expression)this, ParsingOperation.PUSH_LITERAL, MessageSplitter.Companion.getIndexForTrue());
        InstructionGenerator.Label $after = new InstructionGenerator.Label();
        generator.emitJumpForward(this, $after);
        generator.emit($absent);
        generator.emit((Expression)this, ParsingOperation.PUSH_LITERAL, MessageSplitter.Companion.getIndexForFalse());
        generator.emit($after);
        return wrapState.processAfterPushedArgument$avail(this, generator);
    }

    public final void emitInRunThen(@NotNull InstructionGenerator generator, @NotNull Function0<Unit> function) {
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        Intrinsics.checkNotNullParameter(function, (String)"function");
        boolean bl3 = bl2 = !this.getHasSectionCheckpoints$avail();
        if (_Assertions.ENABLED && !bl2) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean needsProgressCheck = this.sequence.mightBeEmpty$avail(ListPhraseTypeDescriptor.Companion.emptyListPhraseType());
        generator.flushDelayed();
        InstructionGenerator.Label $absent = new InstructionGenerator.Label();
        generator.emitBranchForward(this, $absent);
        generator.emitIf(needsProgressCheck, this, ParsingOperation.SAVE_PARSE_POSITION);
        boolean bl4 = bl = !this.sequence.isReordered();
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        this.sequence.emitOn$avail(ListPhraseTypeDescriptor.Companion.emptyListPhraseType(), generator, WrapState.SHOULD_NOT_HAVE_ARGUMENTS);
        generator.flushDelayed();
        generator.emitIf(needsProgressCheck, this, ParsingOperation.ENSURE_PARSE_PROGRESS);
        generator.emitIf(needsProgressCheck, this, ParsingOperation.DISCARD_SAVED_PARSE_POSITION);
        function.invoke();
        generator.flushDelayed();
        generator.emit((Expression)this, ParsingOperation.PUSH_LITERAL, MessageSplitter.Companion.getIndexForTrue());
        InstructionGenerator.Label $merge = new InstructionGenerator.Label();
        generator.emitJumpForward(this, $merge);
        generator.emit($absent);
        function.invoke();
        generator.flushDelayed();
        generator.emit((Expression)this, ParsingOperation.PUSH_LITERAL, MessageSplitter.Companion.getIndexForFalse());
        generator.emit($merge);
    }

    @Override
    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.sequence + ")";
    }

    @Override
    public void printWithArguments$avail(@Nullable Iterator<? extends A_Phrase> arguments, @NotNull StringBuilder builder2, int indent) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Iterator<? extends A_Phrase> iterator2 = arguments;
        Intrinsics.checkNotNull(iterator2);
        A_Phrase literal = iterator2.next();
        boolean bl = literal.isInstanceOf(PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE.getMostGeneralType());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean flag = A_Atom.Companion.getExtractBoolean(A_Phrase.Companion.getToken(literal).literal());
        if (flag) {
            builder2.append('\u00ab');
            this.sequence.printWithArguments$avail(Collections.emptyIterator(), builder2, indent);
            builder2.append("\u00bb");
        }
    }

    @Override
    public boolean getShouldBeSeparatedOnLeft$avail() {
        return true;
    }

    @Override
    public boolean getShouldBeSeparatedOnRight$avail() {
        return true;
    }

    @Override
    public boolean mightBeEmpty$avail(@NotNull A_Type phraseType) {
        Intrinsics.checkNotNullParameter((Object)phraseType, (String)"phraseType");
        return true;
    }

    @Override
    public boolean checkListStructure(@NotNull A_Phrase phrase) {
        Intrinsics.checkNotNullParameter((Object)phrase, (String)"phrase");
        return true;
    }
}

