/*
 * Decompiled with CFR 0.152.
 */
package avail.files;

import avail.AvailRuntime;
import avail.error.ErrorCode;
import avail.files.AbstractFileWrapper;
import avail.files.AvailFile;
import avail.files.ErrorFileWrapper;
import avail.files.FileAction;
import avail.files.FileErrorCode;
import avail.files.FileManager;
import avail.io.IOSystem;
import avail.resolver.ModuleRootResolver;
import avail.resolver.ResolverReference;
import avail.utility.Mutable;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardOpenOption;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.availlang.cache.LRUCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 J2\u00020\u0001:\u0001JB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0005J\b\u0010\"\u001a\u00020\u001fH\u0016JH\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001f0*2\u001a\u0010+\u001a\u0016\u0012\u0004\u0012\u00020-\u0012\u0006\u0012\u0004\u0018\u00010.\u0012\u0004\u0012\u00020\u001f0,J@\u0010/\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\u00162\u0014\u00101\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u001f022\u001a\u00103\u001a\u0016\u0012\u0004\u0012\u00020-\u0012\u0006\u0012\u0004\u0018\u00010.\u0012\u0004\u0012\u00020\u001f0,J\u001a\u00104\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u00052\n\b\u0002\u00105\u001a\u0004\u0018\u00010\u0005JH\u00106\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u00052\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u00052\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001f0*2\u001a\u0010+\u001a\u0016\u0012\u0004\u0012\u00020-\u0012\u0006\u0012\u0004\u0018\u00010.\u0012\u0004\u0012\u00020\u001f0,J\u0014\u0010;\u001a\u00020\u001f2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u001f0*J\u0010\u0010=\u001a\u0004\u0018\u00010\u00052\u0006\u0010>\u001a\u00020\u0016J\u0018\u0010?\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u0016H\u0004JD\u0010@\u001a\u00020A2\u0006\u0010>\u001a\u00020\u00162\u0018\u0010B\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020C\u0012\u0004\u0012\u00020\u001f0,2\u001a\u0010+\u001a\u0016\u0012\u0004\u0012\u00020-\u0012\u0006\u0012\u0004\u0018\u00010.\u0012\u0004\u0012\u00020\u001f0,JT\u0010D\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%2\u0006\u0010'\u001a\u00020(2\u001e\u0010E\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020C\u0012\u0004\u0012\u00020\u001f0F2\u001a\u0010+\u001a\u0016\u0012\u0004\u0012\u00020-\u0012\u0006\u0012\u0004\u0018\u00010.\u0012\u0004\u0012\u00020\u001f0,H\u0016J\u000e\u0010G\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0005J\u0006\u0010\u001c\u001a\u00020\u001dJ*\u0010H\u001a\u00020\u001f2\u0006\u0010I\u001a\u00020C2\u001a\u0010+\u001a\u0016\u0012\u0004\u0012\u00020-\u0012\u0006\u0012\u0004\u0018\u00010.\u0012\u0004\u0012\u00020\u001f0,R(\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00060\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0084\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0002\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00050\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lavail/files/FileManager;", "", "()V", "fileCache", "Lorg/availlang/cache/LRUCache;", "Ljava/util/UUID;", "Lavail/utility/Mutable;", "Lavail/files/AbstractFileWrapper;", "getFileCache", "()Lorg/availlang/cache/LRUCache;", "fileCreateOptions", "Ljava/util/EnumSet;", "Ljava/nio/file/StandardOpenOption;", "getFileCreateOptions$annotations", "getFileCreateOptions", "()Ljava/util/EnumSet;", "fileExecutor", "Ljava/util/concurrent/ThreadPoolExecutor;", "getFileExecutor", "()Ljava/util/concurrent/ThreadPoolExecutor;", "idToResolverRef", "", "Lavail/resolver/ResolverReference;", "ioSystem", "Lavail/io/IOSystem;", "getIoSystem", "()Lavail/io/IOSystem;", "resolverRefToId", "runtime", "Lavail/AvailRuntime;", "associateRuntime", "", "checkInterest", "id", "close", "createFile", "qualifiedName", "", "mimeType", "resolver", "Lavail/resolver/ModuleRootResolver;", "completion", "Lkotlin/Function0;", "failureHandler", "Lkotlin/Function2;", "Lavail/error/ErrorCode;", "", "delete", "reference", "success", "Lkotlin/Function1;", "failure", "deregisterInterest", "interestedPartId", "executeAction", "fileAction", "Lavail/files/FileAction;", "originator", "continuation", "executeFileTask", "task", "fileId", "resolverReference", "fileWrapper", "optionallyProvideExistingFile", "", "successHandler", "Lavail/files/AvailFile;", "readFile", "withFile", "Lkotlin/Function3;", "remove", "saveFile", "availFile", "Companion", "avail"})
public class FileManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IOSystem ioSystem = new IOSystem();
    @NotNull
    private final EnumSet<StandardOpenOption> fileCreateOptions;
    @Nullable
    private AvailRuntime runtime;
    @NotNull
    private final LRUCache<UUID, Mutable<AbstractFileWrapper>> fileCache;
    @NotNull
    private final Map<ResolverReference, UUID> resolverRefToId;
    @NotNull
    private final Map<UUID, ResolverReference> idToResolverRef;
    public static final int SOFT_CAPACITY = 10000;
    public static final int STRONG_CAPACITY = 10;

    public FileManager() {
        EnumSet<Enum> enumSet = EnumSet.of((Enum)StandardOpenOption.READ, (Enum)StandardOpenOption.WRITE, (Enum)StandardOpenOption.CREATE_NEW);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(\n\t\t\tStandardOpenOptio\u2026ardOpenOption.CREATE_NEW)");
        this.fileCreateOptions = enumSet;
        this.fileCache = new LRUCache(10000, 10, (Function1)new Function1<UUID, Mutable<AbstractFileWrapper>>(this){
            final /* synthetic */ FileManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Mutable<AbstractFileWrapper> invoke(@NotNull UUID it) {
                AbstractFileWrapper abstractFileWrapper;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ResolverReference reference = null;
                Map $this$forEach$iv = FileManager.access$getResolverRefToId$p(this.this$0);
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<K, V>> iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<K, V> element$iv;
                    Map.Entry<K, V> entry = element$iv = iterator2.next();
                    boolean bl = false;
                    ResolverReference k = (ResolverReference)entry.getKey();
                    UUID v = (UUID)entry.getValue();
                    if (!Intrinsics.areEqual((Object)v, (Object)it)) continue;
                    reference = k;
                }
                try {
                    abstractFileWrapper = reference == null ? (AbstractFileWrapper)null : this.this$0.fileWrapper(it, reference);
                }
                catch (NoSuchFileException e) {
                    ResolverReference resolverReference = reference;
                    Intrinsics.checkNotNull(resolverReference);
                    new ErrorFileWrapper(it, resolverReference, this.this$0, e, FileErrorCode.FILE_NOT_FOUND);
                    abstractFileWrapper = null;
                }
                catch (Throwable e) {
                    ResolverReference resolverReference = reference;
                    Intrinsics.checkNotNull(resolverReference);
                    new ErrorFileWrapper(it, resolverReference, this.this$0, e, FileErrorCode.UNSPECIFIED);
                    abstractFileWrapper = null;
                }
                AbstractFileWrapper wrapper = abstractFileWrapper;
                return new Mutable<AbstractFileWrapper>(wrapper);
            }
        }, (Function2)fileCache.2.INSTANCE);
        this.resolverRefToId = new LinkedHashMap();
        this.idToResolverRef = new LinkedHashMap();
    }

    @NotNull
    public final IOSystem getIoSystem() {
        return this.ioSystem;
    }

    public void close() {
    }

    @NotNull
    protected final EnumSet<StandardOpenOption> getFileCreateOptions() {
        return this.fileCreateOptions;
    }

    protected static /* synthetic */ void getFileCreateOptions$annotations() {
    }

    private final ThreadPoolExecutor getFileExecutor() {
        return this.ioSystem.getFileExecutor();
    }

    public final void associateRuntime(@NotNull AvailRuntime runtime) {
        Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
        this.runtime = runtime;
    }

    @NotNull
    public final AvailRuntime runtime() {
        AvailRuntime availRuntime = this.runtime;
        Intrinsics.checkNotNull((Object)availRuntime);
        return availRuntime;
    }

    @NotNull
    protected final LRUCache<UUID, Mutable<AbstractFileWrapper>> getFileCache() {
        return this.fileCache;
    }

    @NotNull
    protected final AbstractFileWrapper fileWrapper(@NotNull UUID id, @NotNull ResolverReference reference) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        return reference.getResolver().fileWrapper(id, reference);
    }

    public final void remove(@NotNull UUID id) {
        block6: {
            Object object;
            block5: {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                object = (AbstractFileWrapper)((Mutable)this.fileCache.get((Object)id)).getValue();
                if (object == null) break block5;
                AbstractFileWrapper it = object;
                boolean bl = false;
                this.fileCache.remove((Object)id);
                this.resolverRefToId.remove(it.getReference());
                ResolverReference resolverReference = this.idToResolverRef.remove(id);
                object = resolverReference;
                if (resolverReference != null) break block6;
            }
            ResolverReference resolverReference = this.idToResolverRef.remove(id);
            if (resolverReference != null) {
                ResolverReference resolverReference2 = resolverReference;
                Map<ResolverReference, UUID> map = this.resolverRefToId;
                ResolverReference p0 = resolverReference2;
                boolean bl = false;
                object = map.remove(p0);
            } else {
                object = null;
            }
        }
    }

    public final void deregisterInterest(@NotNull UUID id, @Nullable UUID interestedPartId) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        AbstractFileWrapper it = (AbstractFileWrapper)((Mutable)this.fileCache.get((Object)id)).getValue();
        boolean bl = false;
        Object object = it;
        boolean bl2 = object != null && (object = ((AbstractFileWrapper)object).getInterestCount()) != null ? ((AtomicInteger)object).decrementAndGet() == 0 : false;
        if (bl2) {
            this.remove(id);
            it.close();
        }
    }

    public static /* synthetic */ void deregisterInterest$default(FileManager fileManager, UUID uUID, UUID uUID2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: deregisterInterest");
        }
        if ((n & 2) != 0) {
            uUID2 = null;
        }
        fileManager.deregisterInterest(uUID, uUID2);
    }

    public final void checkInterest(@NotNull UUID id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        AbstractFileWrapper it = (AbstractFileWrapper)((Mutable)this.fileCache.get((Object)id)).getValue();
        boolean bl = false;
        Object object = it;
        boolean bl2 = object != null && (object = ((AbstractFileWrapper)object).getInterestCount()) != null ? ((AtomicInteger)object).get() == 0 : false;
        if (bl2) {
            this.remove(id);
            it.close();
        }
    }

    @Nullable
    public final UUID fileId(@NotNull ResolverReference resolverReference) {
        Intrinsics.checkNotNullParameter((Object)resolverReference, (String)"resolverReference");
        return this.resolverRefToId.get(resolverReference);
    }

    public final boolean optionallyProvideExistingFile(@NotNull ResolverReference resolverReference, @NotNull Function2<? super UUID, ? super AvailFile, Unit> successHandler, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter((Object)resolverReference, (String)"resolverReference");
        Intrinsics.checkNotNullParameter(successHandler, (String)"successHandler");
        Intrinsics.checkNotNullParameter(failureHandler, (String)"failureHandler");
        UUID fileId = this.resolverRefToId.get(resolverReference);
        if (fileId == null) {
            return false;
        }
        AbstractFileWrapper abstractFileWrapper = (AbstractFileWrapper)((Mutable)this.fileCache.get((Object)fileId)).getValue();
        if (abstractFileWrapper == null) {
            return false;
        }
        AbstractFileWrapper wrapper = abstractFileWrapper;
        if (wrapper.isError() || wrapper.isClosed()) {
            return false;
        }
        Function3 success2 = (Function3)new Function3<UUID, String, AvailFile, Unit>(successHandler){
            final /* synthetic */ Function2<UUID, AvailFile, Unit> $successHandler;
            {
                this.$successHandler = $successHandler;
                super(3);
            }

            public final void invoke(@NotNull UUID uuid, @NotNull String string2, @NotNull AvailFile file2) {
                Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
                Intrinsics.checkNotNullParameter((Object)string2, (String)"<anonymous parameter 1>");
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                this.$successHandler.invoke((Object)uuid, (Object)file2);
            }
        };
        wrapper.provide(false, (Function3<? super UUID, ? super String, ? super AvailFile, Unit>)success2, failureHandler);
        return true;
    }

    public final void executeFileTask(@NotNull Function0<Unit> task2) {
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        this.getFileExecutor().execute(() -> FileManager.executeFileTask$lambda-3(task2));
    }

    public final void executeAction(@NotNull UUID id, @NotNull FileAction fileAction, @NotNull UUID originator, @NotNull Function0<Unit> continuation, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        block2: {
            Unit unit;
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)fileAction, (String)"fileAction");
            Intrinsics.checkNotNullParameter((Object)originator, (String)"originator");
            Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
            Intrinsics.checkNotNullParameter(failureHandler, (String)"failureHandler");
            AbstractFileWrapper abstractFileWrapper = (AbstractFileWrapper)((Mutable)this.fileCache.get((Object)id)).getValue();
            if (abstractFileWrapper != null) {
                abstractFileWrapper.execute(fileAction, originator, continuation);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block2;
            failureHandler.invoke((Object)FileErrorCode.BAD_FILE_ID, null);
        }
    }

    public final void saveFile(@NotNull AvailFile availFile, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter((Object)availFile, (String)"availFile");
        Intrinsics.checkNotNullParameter(failureHandler, (String)"failureHandler");
        ResolverReference reference = availFile.getFileWrapper().getReference();
        reference.getResolver().saveFile(reference, availFile.getSavableContent(), (Function0<Unit>)((Function0)new Function0<Unit>(availFile){
            final /* synthetic */ AvailFile $availFile;
            {
                this.$availFile = $availFile;
                super(0);
            }

            public final void invoke() {
                long saveTime = System.currentTimeMillis();
                this.$availFile.conditionallyClearDirty(saveTime);
                this.$availFile.setLastModified(saveTime);
            }
        }), failureHandler);
    }

    public final void delete(@NotNull ResolverReference reference, @NotNull Function1<? super UUID, Unit> success2, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failure) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            Intrinsics.checkNotNullParameter(success2, (String)"success");
            Intrinsics.checkNotNullParameter(failure, (String)"failure");
            UUID uUID = this.resolverRefToId.remove(reference);
            if (uUID == null) break block1;
            UUID id = uUID;
            boolean bl = false;
            this.idToResolverRef.remove(id);
            Object object = (Mutable)this.fileCache.remove((Object)id);
            if (object != null && (object = (AbstractFileWrapper)((Mutable)object).getValue()) != null) {
                ((AbstractFileWrapper)object).delete(success2, failure);
            }
        }
    }

    public void readFile(@NotNull String qualifiedName, @NotNull ModuleRootResolver resolver, @NotNull Function3<? super UUID, ? super String, ? super AvailFile, Unit> withFile, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Intrinsics.checkNotNullParameter(withFile, (String)"withFile");
        Intrinsics.checkNotNullParameter(failureHandler, (String)"failureHandler");
        resolver.provideResolverReference(qualifiedName, (Function1<? super ResolverReference, Unit>)((Function1)new Function1<ResolverReference, Unit>(this, withFile, failureHandler){
            final /* synthetic */ FileManager this$0;
            final /* synthetic */ Function3<UUID, String, AvailFile, Unit> $withFile;
            final /* synthetic */ Function2<ErrorCode, Throwable, Unit> $failureHandler;
            {
                this.this$0 = $receiver;
                this.$withFile = $withFile;
                this.$failureHandler = $failureHandler;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull ResolverReference reference) {
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                Ref.ObjectRef uuid = new Ref.ObjectRef();
                Map map = FileManager.access$getResolverRefToId$p(this.this$0);
                FileManager fileManager = this.this$0;
                Map map2 = map;
                synchronized (map2) {
                    Object object;
                    boolean bl = false;
                    Ref.ObjectRef objectRef = uuid;
                    Map $this$getOrPut$iv = FileManager.access$getResolverRefToId$p(fileManager);
                    boolean $i$f$getOrPut = false;
                    V value$iv = $this$getOrPut$iv.get(reference);
                    if (value$iv == null) {
                        Ref.ObjectRef objectRef2 = objectRef;
                        boolean bl2 = false;
                        UUID uUID = UUID.randomUUID();
                        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID()");
                        objectRef = objectRef2;
                        UUID answer$iv = uUID;
                        $this$getOrPut$iv.put(reference, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    objectRef.element = object;
                    FileManager.access$getIdToResolverRef$p(fileManager).put(uuid.element, reference);
                    Unit unit = Unit.INSTANCE;
                }
                Mutable value = (Mutable)this.this$0.getFileCache().get(uuid.element);
                this.this$0.executeFileTask((Function0<Unit>)((Function0)new Function0<Unit>((Mutable<AbstractFileWrapper>)value, this.$withFile, this.$failureHandler){
                    final /* synthetic */ Mutable<AbstractFileWrapper> $value;
                    final /* synthetic */ Function3<UUID, String, AvailFile, Unit> $withFile;
                    final /* synthetic */ Function2<ErrorCode, Throwable, Unit> $failureHandler;
                    {
                        this.$value = $value;
                        this.$withFile = $withFile;
                        this.$failureHandler = $failureHandler;
                        super(0);
                    }

                    public final void invoke() {
                        block2: {
                            Unit unit;
                            AbstractFileWrapper abstractFileWrapper = this.$value.getValue();
                            if (abstractFileWrapper != null) {
                                abstractFileWrapper.provide(true, this.$withFile, this.$failureHandler);
                                unit = Unit.INSTANCE;
                            } else {
                                unit = null;
                            }
                            if (unit != null) break block2;
                            this.$failureHandler.invoke((Object)FileErrorCode.FILE_NOT_FOUND, null);
                        }
                    }
                }));
            }
        }), failureHandler);
    }

    public final void createFile(@NotNull String qualifiedName, @NotNull String mimeType, @NotNull ModuleRootResolver resolver, @NotNull Function0<Unit> completion, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        Intrinsics.checkNotNullParameter(failureHandler, (String)"failureHandler");
        resolver.createFile(qualifiedName, mimeType, completion, failureHandler);
    }

    private static final void executeFileTask$lambda-3(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    public static final /* synthetic */ Map access$getResolverRefToId$p(FileManager $this) {
        return $this.resolverRefToId;
    }

    public static final /* synthetic */ Map access$getIdToResolverRef$p(FileManager $this) {
        return $this.idToResolverRef;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lavail/files/FileManager$Companion;", "", "()V", "SOFT_CAPACITY", "", "STRONG_CAPACITY", "avail"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

