/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.execution;

import avail.AvailDebuggerModel;
import avail.AvailRuntime;
import avail.AvailRuntimeConfiguration;
import avail.AvailRuntimeSupport;
import avail.AvailTask;
import avail.AvailThread;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.fiber.FiberDescriptor;
import avail.descriptor.functions.A_Continuation;
import avail.descriptor.functions.A_Function;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.functions.ContinuationDescriptor;
import avail.descriptor.functions.ContinuationRegisterDumpDescriptor;
import avail.descriptor.module.A_Module;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AbstractDescriptor;
import avail.descriptor.representation.AbstractSlotsEnum;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.AvailObjectFieldHelper;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.A_Set;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TypeTag;
import avail.descriptor.variables.A_Variable;
import avail.descriptor.variables.VariableDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.AvailException;
import avail.exceptions.AvailRuntimeException;
import avail.interpreter.Primitive;
import avail.interpreter.execution.AvailLoader;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.L1InstructionStepper;
import avail.interpreter.levelTwo.L2AbstractInstruction;
import avail.interpreter.levelTwo.L2Chunk;
import avail.interpreter.levelTwo.L2JVMChunk;
import avail.interpreter.levelTwo.operation.L2_REIFY;
import avail.interpreter.primitive.controlflow.P_CatchException;
import avail.interpreter.primitive.fibers.P_AttemptJoinFiber;
import avail.interpreter.primitive.fibers.P_ParkCurrentFiber;
import avail.optimizer.ExecutableChunk;
import avail.optimizer.StackReifier;
import avail.optimizer.jvm.CheckedField;
import avail.optimizer.jvm.CheckedMethod;
import avail.optimizer.jvm.JVMChunk;
import avail.optimizer.jvm.ReferencedInGeneratedCode;
import avail.performance.Statistic;
import avail.performance.StatisticReport;
import avail.utility.Strings;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckReturnValue;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0088\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 \u00c5\u00012\u00020\u0001:\u0004\u00c5\u0001\u00c6\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010G\u001a\u00020;J\u000e\u0010H\u001a\u00020;2\u0006\u0010I\u001a\u00020\u000bJ \u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u0002072\u0006\u0010O\u001a\u00020KH\u0007J\u000e\u0010P\u001a\u00020\u00072\u0006\u0010Q\u001a\u00020\u000bJ\u001a\u0010R\u001a\u0004\u0018\u00010S2\u0006\u0010T\u001a\u00020,2\u0006\u0010L\u001a\u00020MH\u0007J\u001a\u0010U\u001a\u00020S2\b\u0010T\u001a\u0004\u0018\u00010,2\u0006\u0010L\u001a\u00020MH\u0007J\u001a\u0010V\u001a\u0004\u0018\u00010S2\u0006\u0010T\u001a\u00020,2\u0006\u0010L\u001a\u00020MH\u0007J\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010W\u001a\u0004\u0018\u00010\u0010J\u0010\u0010X\u001a\u0002072\u0006\u0010L\u001a\u00020MH\u0007J\b\u0010Y\u001a\u00020!H\u0007J\u000e\u0010Z\u001a\u00020;2\u0006\u0010[\u001a\u00020\u000bJ\u0010\u0010\\\u001a\u00020!2\u0006\u0010]\u001a\u00020\u000bH\u0007J\u0013\u0010^\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010_0\f\u00a2\u0006\u0002\u0010`J\u0018\u0010a\u001a\u00020;2\u0006\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020eH\u0002J\u0006\u0010*\u001a\u00020\u0014J\u001a\u0010*\u001a\u00020;2\b\u0010f\u001a\u0004\u0018\u00010\u00142\b\u0010g\u001a\u0004\u0018\u00010\u0016J\b\u0010h\u001a\u0004\u0018\u00010\u0014J\b\u0010i\u001a\u00020\u0007H\u0007J\n\u0010j\u001a\u0004\u0018\u00010\u0007H\u0007J\u0010\u0010k\u001a\u0004\u0018\u00010S2\u0006\u0010l\u001a\u00020,J\b\u0010m\u001a\u0004\u0018\u00010\u0007J'\u0010n\u001a\u0002Ho\"\u0004\b\u0000\u0010o2\u0006\u0010p\u001a\u00020\u00142\f\u0010q\u001a\b\u0012\u0004\u0012\u0002Ho0:\u00a2\u0006\u0002\u0010rJ\u0016\u0010s\u001a\u00020K2\u0006\u0010t\u001a\u00020u2\u0006\u0010v\u001a\u00020wJ\u000e\u0010x\u001a\u00020K2\u0006\u0010v\u001a\u00020wJ\u0006\u0010y\u001a\u00020zJ\u0006\u0010{\u001a\u00020\u0016J\b\u0010|\u001a\u0004\u0018\u00010}J\b\u0010~\u001a\u00020;H\u0007J\u0016\u00109\u001a\u00020;2\u000e\u0010\u007f\u001a\n\u0012\u0004\u0012\u00020;\u0018\u00010:J(\u0010\u0080\u0001\u001a\u0004\u0018\u00010S2\u0007\u0010\u0081\u0001\u001a\u00020\u00122\u0007\u0010\u0082\u0001\u001a\u00020,2\t\u0010\u0083\u0001\u001a\u0004\u0018\u00010SH\u0007J'\u0010\u0084\u0001\u001a\u00020\u00072\u0007\u0010\u0085\u0001\u001a\u00020,2\r\u0010\u0086\u0001\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u0007\u00a2\u0006\u0003\u0010\u0087\u0001J\u0012\u0010\u0088\u0001\u001a\u00020\u00072\u0007\u0010\u0085\u0001\u001a\u00020,H\u0007J\u001b\u0010\u0089\u0001\u001a\u00020\u00072\u0007\u0010\u0085\u0001\u001a\u00020,2\u0007\u0010\u008a\u0001\u001a\u00020\u0007H\u0007J$\u0010\u008b\u0001\u001a\u00020\u00072\u0007\u0010\u0085\u0001\u001a\u00020,2\u0007\u0010\u008a\u0001\u001a\u00020\u00072\u0007\u0010\u008c\u0001\u001a\u00020\u0007H\u0007J-\u0010\u008d\u0001\u001a\u00020\u00072\u0007\u0010\u0085\u0001\u001a\u00020,2\u0007\u0010\u008a\u0001\u001a\u00020\u00072\u0007\u0010\u008c\u0001\u001a\u00020\u00072\u0007\u0010\u008e\u0001\u001a\u00020\u0007H\u0007J\u0012\u0010\u008f\u0001\u001a\u00020K2\u0007\u0010\u0090\u0001\u001a\u00020cH\u0007J\u0013\u0010\u008f\u0001\u001a\u00020K2\b\u0010\u0091\u0001\u001a\u00030\u0092\u0001H\u0007J\u0013\u0010\u008f\u0001\u001a\u00020K2\b\u0010\u0093\u0001\u001a\u00030\u0094\u0001H\u0007J\u0013\u0010\u008f\u0001\u001a\u00020K2\b\u0010\u0093\u0001\u001a\u00030\u0095\u0001H\u0007J\u0012\u0010\u0096\u0001\u001a\u00020K2\u0007\u0010\u0097\u0001\u001a\u00020,H\u0007J\u0012\u0010\u0098\u0001\u001a\u00020K2\u0007\u0010\u0090\u0001\u001a\u00020cH\u0007J\u0011\u0010\u0099\u0001\u001a\u00020K2\u0006\u0010d\u001a\u00020eH\u0003J\u0012\u0010\u0099\u0001\u001a\u00020K2\u0007\u0010\u0097\u0001\u001a\u00020,H\u0007J\u0010\u0010\u009a\u0001\u001a\u00020;2\u0007\u0010\u007f\u001a\u00030\u009b\u0001J\u0019\u0010\u009c\u0001\u001a\u00020;2\b\u0010\u009d\u0001\u001a\u00030\u009e\u00012\u0006\u0010y\u001a\u00020zJ\u0012\u0010\u009f\u0001\u001a\u00020S2\u0007\u0010\u007f\u001a\u00030\u009b\u0001H\u0007J'\u0010\u00a0\u0001\u001a\u00020S2\u0007\u0010\u007f\u001a\u00030\u009b\u00012\r\u0010\u00a1\u0001\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u0007\u00a2\u0006\u0003\u0010\u00a2\u0001J%\u0010\u00a3\u0001\u001a\u00020S2\u0007\u0010\u00a4\u0001\u001a\u00020!2\u0007\u0010\u009a\u0001\u001a\u00020!2\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u0001H\u0007J6\u0010\u00a7\u0001\u001a\u00020S2\u0007\u0010\u00a8\u0001\u001a\u00020\u000b2\u0007\u0010\u00a9\u0001\u001a\u00020\u000b2\u0013\u0010\u00aa\u0001\u001a\n\u0012\u0006\b\u0001\u0012\u00020c0\f\"\u00020cH\u0007\u00a2\u0006\u0003\u0010\u00ab\u0001JI\u0010\u00ac\u0001\u001a\u00020S2\u0007\u0010\u00ad\u0001\u001a\u00020c2\b\u0010\u00ae\u0001\u001a\u00030\u00af\u00012\u0007\u0010\u00a8\u0001\u001a\u00020\u000b2\u0007\u0010\u00a9\u0001\u001a\u00020\u000b2\u0013\u0010\u00aa\u0001\u001a\n\u0012\u0006\b\u0001\u0012\u00020c0\f\"\u00020cH\u0007\u00a2\u0006\u0003\u0010\u00b0\u0001J\u0007\u0010\u00b1\u0001\u001a\u00020;J\u000b\u0010\u00b2\u0001\u001a\u0004\u0018\u00010SH\u0007J\u0010\u0010\u00b3\u0001\u001a\u00020K2\u0007\u0010\u00b4\u0001\u001a\u00020\u0007J\u0014\u0010\u00b5\u0001\u001a\u00020;2\t\u0010\u00b6\u0001\u001a\u0004\u0018\u00010cH\u0007J\u0010\u0010\u00b7\u0001\u001a\u00020;2\u0007\u0010\u00b8\u0001\u001a\u00020\u000bJ\u0014\u0010\u00b9\u0001\u001a\u00020;2\t\u0010\u007f\u001a\u0005\u0018\u00010\u009b\u0001H\u0007J\u000f\u0010\u00ba\u0001\u001a\u00020;2\u0006\u0010D\u001a\u00020!J\u000f\u0010\u00bb\u0001\u001a\u00020;2\u0006\u0010E\u001a\u00020!J)\u0010\u00bc\u0001\u001a\u00020K2 \u0010\u00bd\u0001\u001a\u001b\u0012\u000b\u0012\t\u0012\u0004\u0012\u00020c0\u00be\u0001\u0012\u0004\u0012\u00020;0 \u00a2\u0006\u0003\b\u00bf\u0001J+\u0010\u00c0\u0001\u001a\u00020K2 \u0010\u00c1\u0001\u001a\u001b\u0012\u000b\u0012\t\u0012\u0004\u0012\u00020c0\u00be\u0001\u0012\u0004\u0012\u00020;0 \u00a2\u0006\u0003\b\u00bf\u0001H\u0007J\u0010\u0010\u00c2\u0001\u001a\u00020;2\u0007\u0010\u00c3\u0001\u001a\u00020cJ\t\u0010\u00c4\u0001\u001a\u00020\u0016H\u0016J\u0006\u0010D\u001a\u00020!J\u0006\u0010E\u001a\u00020!J\u0006\u0010F\u001a\u00020\u000bR\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\b\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u00128\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\"\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR:\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020!\u0018\u00010 2\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020!\u0018\u00010 @BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0010\u0010*\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\u0004\u0018\u00010,8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010-\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u00100\u001a\u00020!8G\u00a2\u0006\u0006\u001a\u0004\b0\u0010'R\u001a\u00101\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010'\"\u0004\b2\u0010)R\u0010\u00103\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00104\u001a\u0002058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000207X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00108\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\"\u00109\u001a\n\u0012\u0004\u0012\u00020;\u0018\u00010:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u0012\u0010@\u001a\u00020!8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010A\u001a\u0004\u0018\u00010,8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u000207X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010C\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00c7\u0001"}, d2={"Lavail/interpreter/execution/Interpreter;", "", "runtime", "Lavail/AvailRuntime;", "(Lavail/AvailRuntime;)V", "argsBuffer", "", "Lavail/descriptor/representation/AvailObject;", "arraysForL2Simple", "", "", "", "", "getArraysForL2Simple", "()Ljava/util/Map;", "availLoader", "Lavail/interpreter/execution/AvailLoader;", "chunk", "Lavail/interpreter/levelTwo/L2Chunk;", "currentlyLockedFiber", "Lavail/descriptor/fiber/A_Fiber;", "debugModeString", "", "getDebugModeString", "()Ljava/lang/String;", "setDebugModeString", "(Ljava/lang/String;)V", "<set-?>", "Lavail/AvailDebuggerModel;", "debugger", "getDebugger", "()Lavail/AvailDebuggerModel;", "Lkotlin/Function1;", "", "debuggerRunCondition", "getDebuggerRunCondition", "()Lkotlin/jvm/functions/Function1;", "exitNow", "getExitNow", "()Z", "setExitNow", "(Z)V", "fiber", "function", "Lavail/descriptor/functions/A_Function;", "interpreterIndex", "getInterpreterIndex", "()I", "isInterruptRequested", "isReifying", "setReifying", "latestResult", "levelOneStepper", "Lavail/interpreter/levelTwo/L1InstructionStepper;", "nanosToExclude", "", "offset", "postExitContinuation", "Lkotlin/Function0;", "", "getPostExitContinuation", "()Lkotlin/jvm/functions/Function0;", "setPostExitContinuation", "(Lkotlin/jvm/functions/Function0;)V", "returnNow", "returningFunction", "startTick", "theReifiedContinuation", "traceVariableReadsBeforeWrites", "traceVariableWrites", "unreifiedCallDepth", "abortFiber", "adjustUnreifiedCallDepthBy", "delta", "afterAttemptPrimitive", "Lavail/interpreter/Primitive$Result;", "primitive", "Lavail/interpreter/Primitive;", "timeBefore", "success", "argument", "zeroBasedIndex", "attemptInlinePrimitive", "Lavail/optimizer/StackReifier;", "primitiveFunction", "attemptNonInlinePrimitive", "attemptThePrimitive", "availLoaderOrNull", "beforeAttemptPrimitive", "callerIsReified", "checkArgumentCount", "expectedCount", "checkValidity", "offsetInDefaultChunkIfInvalid", "describeForDebugger", "Lavail/descriptor/representation/AvailObjectFieldHelper;", "()[Lavail/descriptor/representation/AvailObjectFieldHelper;", "exitFiber", "finalObject", "Lavail/descriptor/representation/A_BasicObject;", "state", "Lavail/descriptor/fiber/FiberDescriptor$ExecutionState;", "newFiber", "tempDebug", "fiberOrNull", "getLatestResult", "getReifiedContinuation", "invokeFunction", "aFunction", "latestResultOrNull", "lockFiberWhile", "T", "aFiber", "supplier", "(Lavail/descriptor/fiber/A_Fiber;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "markGuardVariable", "guardVariable", "Lavail/descriptor/variables/A_Variable;", "marker", "Lavail/descriptor/numbers/A_Number;", "markNearestGuard", "module", "Lavail/descriptor/module/A_Module;", "nameForDebugger", "pollActiveRawFunction", "Lavail/descriptor/functions/A_RawFunction;", "popContinuation", "continuation", "postinvoke", "callingChunk", "callingFunction", "reifier", "preinvoke", "calledFunction", "args", "(Lavail/descriptor/functions/A_Function;[Lavail/descriptor/representation/AvailObject;)Lavail/descriptor/representation/AvailObject;", "preinvoke0", "preinvoke1", "arg1", "preinvoke2", "arg2", "preinvoke3", "arg3", "primitiveFailure", "result", "code", "Lavail/exceptions/AvailErrorCode;", "exception", "Lavail/exceptions/AvailException;", "Lavail/exceptions/AvailRuntimeException;", "primitivePark", "suspendingFunction", "primitiveSuccess", "primitiveSuspend", "processInterrupt", "Lavail/descriptor/functions/A_Continuation;", "recordTopStatementEvaluation", "sample", "", "reifierToRestart", "reifierToRestartWithArguments", "arguments", "(Lavail/descriptor/functions/A_Continuation;[Lavail/descriptor/representation/AvailObject;)Lavail/optimizer/StackReifier;", "reify", "actuallyReify", "statistic", "Lavail/performance/Statistic;", "reportUnassignedVariableRead", "pc", "stackp", "slots", "(II[Lavail/descriptor/representation/A_BasicObject;)Lavail/optimizer/StackReifier;", "reportWrongReturnType", "returnedValueOrNil", "expectedReturnType", "Lavail/descriptor/types/A_Type;", "(Lavail/descriptor/representation/A_BasicObject;Lavail/descriptor/types/A_Type;II[Lavail/descriptor/representation/A_BasicObject;)Lavail/optimizer/StackReifier;", "run", "runChunk", "searchForExceptionHandler", "exceptionValue", "setLatestResult", "newResult", "setOffset", "newOffset", "setReifiedContinuation", "setTraceVariableReadsBeforeWrites", "setTraceVariableWrites", "suspendInSafePointThen", "action", "Lavail/interpreter/execution/Interpreter$SuspensionHelper;", "Lkotlin/ExtensionFunctionType;", "suspendThen", "body", "terminateFiber", "value", "toString", "Companion", "SuspensionHelper", "avail"})
@Debug.Renderer(text="toString", childrenArray="nameForDebugger")
public final class Interpreter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @ReferencedInGeneratedCode
    @JvmField
    @NotNull
    public final AvailRuntime runtime;
    @Nullable
    private A_Fiber currentlyLockedFiber;
    private final int interpreterIndex;
    @NotNull
    private String debugModeString;
    @Nullable
    private AvailLoader availLoader;
    @Nullable
    private A_Fiber fiber;
    @Nullable
    private AvailDebuggerModel debugger;
    @Nullable
    private Function1<? super A_Fiber, Boolean> debuggerRunCondition;
    private boolean traceVariableReadsBeforeWrites;
    private boolean traceVariableWrites;
    @Nullable
    private AvailObject latestResult;
    @ReferencedInGeneratedCode
    @JvmField
    @Nullable
    public A_Function returningFunction;
    private long nanosToExclude;
    @ReferencedInGeneratedCode
    @JvmField
    public boolean returnNow;
    private boolean exitNow;
    @Nullable
    private Function0<Unit> postExitContinuation;
    @Nullable
    private AvailObject theReifiedContinuation;
    private int unreifiedCallDepth;
    @ReferencedInGeneratedCode
    @JvmField
    @Nullable
    public volatile A_Function function;
    @ReferencedInGeneratedCode
    @JvmField
    @Nullable
    public L2Chunk chunk;
    @ReferencedInGeneratedCode
    @JvmField
    public int offset;
    @ReferencedInGeneratedCode
    @JvmField
    @NotNull
    public final List<AvailObject> argsBuffer;
    @ReferencedInGeneratedCode
    @JvmField
    @NotNull
    public final L1InstructionStepper levelOneStepper;
    private long startTick;
    private boolean isReifying;
    @NotNull
    private final Map<List<Integer>, Integer[]> arraysForL2Simple;
    private static volatile boolean debugL1;
    private static volatile boolean debugL2;
    private static volatile boolean debugPrimitives;
    private static volatile boolean debugWorkUnits;
    private static final boolean debugIntoFiberDebugLog = true;
    private static volatile boolean debugCustom;
    private static volatile boolean debugCheckAfterUnload;
    private static final Logger mainLogger;
    @NotNull
    private static final Logger loggerDebugL1;
    @NotNull
    private static final Logger loggerDebugL2;
    @NotNull
    private static final Logger loggerDebugJVM;
    private static final Logger loggerDebugPrimitives;
    private static final int maxFiberLogLength = 50000;
    @NotNull
    private static final CheckedMethod traceL2Method;
    @NotNull
    private static final CheckedMethod callerIsReifiedMethod;
    @NotNull
    private static final CheckedField runtimeField;
    @NotNull
    private static CheckedMethod setLatestResultMethod;
    @NotNull
    private static CheckedMethod getLatestResultMethod;
    @NotNull
    private static final CheckedField interpreterReturningFunctionField;
    @NotNull
    private static final CheckedField returnNowField;
    @NotNull
    private static CheckedMethod beforeAttemptPrimitiveMethod;
    @NotNull
    private static CheckedMethod afterAttemptPrimitiveMethod;
    @NotNull
    private static final CheckedMethod getReifiedContinuationMethod;
    @NotNull
    private static final CheckedMethod setReifiedContinuationMethod;
    @NotNull
    private static CheckedMethod popContinuationMethod;
    private static final int maxUnreifiedCallDepth = 50;
    @NotNull
    private static final CheckedField interpreterFunctionField;
    @NotNull
    private static CheckedField chunkField;
    @NotNull
    private static final CheckedField offsetField;
    @NotNull
    private static final CheckedField argsBufferField;
    @NotNull
    private static final CheckedField levelOneStepperField;
    private static final int timeSliceTicks = 20;
    @NotNull
    private static final CheckedMethod isInterruptRequestedMethod;
    @NotNull
    private static final CheckedMethod checkValidityMethod;
    @NotNull
    private static final CheckedMethod reifierToRestartMethod;
    @NotNull
    private static final CheckedMethod reifyMethod;
    @NotNull
    private static final CheckedMethod reifierToRestartWithArgumentsMethod;
    @NotNull
    private static CheckedMethod preinvoke0Method;
    @NotNull
    private static CheckedMethod preinvoke1Method;
    @NotNull
    private static CheckedMethod preinvoke2Method;
    @NotNull
    private static CheckedMethod preinvoke3Method;
    @NotNull
    private static CheckedMethod preinvokeMethod;
    @NotNull
    private static CheckedMethod postinvokeMethod;
    @NotNull
    private static CheckedMethod interpreterRunChunkMethod;
    @NotNull
    private static final CheckedMethod attemptThePrimitiveMethod;
    @NotNull
    private static final CheckedMethod attemptTheInlinePrimitiveMethod;
    @NotNull
    private static final CheckedMethod attemptTheNonInlinePrimitiveMethod;
    @NotNull
    private static CheckedMethod reportWrongReturnTypeMethod;
    @NotNull
    private static CheckedMethod reportUnassignedVariableReadMethod;
    @NotNull
    private static final Map<A_String, Statistic> topStatementEvaluationStats;

    public Interpreter(@NotNull AvailRuntime runtime) {
        Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
        this.runtime = runtime;
        this.interpreterIndex = this.runtime.allocateInterpreterIndex();
        this.debugModeString = "";
        this.exitNow = true;
        this.argsBuffer = new ArrayList();
        this.levelOneStepper = new L1InstructionStepper(this);
        this.startTick = -1L;
        this.arraysForL2Simple = new LinkedHashMap();
    }

    @Nullable
    public final A_RawFunction pollActiveRawFunction() {
        A_Function f = this.function;
        return f == null ? null : (f == NilDescriptor.Companion.getNil() ? null : f.code());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T lockFiberWhile(@NotNull A_Fiber aFiber, @NotNull Function0<? extends T> supplier) {
        Object object;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)aFiber, (String)"aFiber");
        Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
        A_Fiber previousFiber = this.currentlyLockedFiber;
        boolean bl2 = bl = previousFiber == null || previousFiber == aFiber;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.currentlyLockedFiber = aFiber;
        try {
            object = supplier.invoke();
        }
        finally {
            this.currentlyLockedFiber = previousFiber;
        }
        return (T)object;
    }

    public final int unreifiedCallDepth() {
        return this.unreifiedCallDepth;
    }

    @ReferencedInGeneratedCode
    public final boolean callerIsReified() {
        return this.unreifiedCallDepth == 0;
    }

    public final void adjustUnreifiedCallDepthBy(int delta) {
        if (debugL1 || debugL2) {
            boolean bl;
            boolean bl2 = bl = this.unreifiedCallDepth + delta >= 0;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            Level level = Level.FINER;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"FINER");
            Object[] objectArray = new Object[]{this.debugModeString, this.unreifiedCallDepth, this.unreifiedCallDepth + delta};
            Companion.log(loggerDebugL2, level, "{0}Depth: {1} \u2192 {2}", objectArray);
        }
        this.unreifiedCallDepth += delta;
    }

    @NotNull
    public final AvailObjectFieldHelper[] describeForDebugger() {
        List<L2AbstractInstruction> list2;
        List helpers = new ArrayList();
        helpers.add(new AvailObjectFieldHelper(NilDescriptor.Companion.getNil(), AbstractDescriptor.DebuggerObjectSlots.DUMMY_DEBUGGER_SLOT, -1, this.function, "Current function", null, null, 96, null));
        boolean $i$f$emptyArray = false;
        helpers.add(new AvailObjectFieldHelper(NilDescriptor.Companion.getNil(), AbstractDescriptor.DebuggerObjectSlots.DUMMY_DEBUGGER_SLOT, -1, this.offset, "L2 offset", "L2 offset = " + this.offset, new Object[0]));
        A_BasicObject a_BasicObject = NilDescriptor.Companion.getNil();
        AbstractSlotsEnum abstractSlotsEnum = AbstractDescriptor.DebuggerObjectSlots.DUMMY_DEBUGGER_SLOT;
        String string2 = "argsBuffer(" + this.argsBuffer.size() + ")";
        Collection $this$toTypedArray$iv = this.argsBuffer;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new AvailObject[0]);
        Intrinsics.checkNotNull((Object)objectArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        helpers.add(new AvailObjectFieldHelper(a_BasicObject, abstractSlotsEnum, -1, this.argsBuffer, "argsBuffer", string2, objectArray));
        A_BasicObject a_BasicObject2 = NilDescriptor.Companion.getNil();
        AbstractSlotsEnum abstractSlotsEnum2 = AbstractDescriptor.DebuggerObjectSlots.DUMMY_DEBUGGER_SLOT;
        if (this.chunk != null) {
            L2Chunk l2Chunk = this.chunk;
            Intrinsics.checkNotNull((Object)l2Chunk);
            list2 = l2Chunk.getInstructions();
        } else {
            list2 = CollectionsKt.emptyList();
        }
        helpers.add(new AvailObjectFieldHelper(a_BasicObject2, abstractSlotsEnum2, -1, list2, "L2 instructions", null, null, 96, null));
        A_Continuation frame = this.getReifiedContinuation();
        if (frame != null) {
            List frames = new ArrayList();
            while (true) {
                A_Continuation a_Continuation = frame;
                Intrinsics.checkNotNull((Object)a_Continuation);
                if (!a_Continuation.getNotNil()) break;
                frames.add(frame);
                frame = A_Continuation.Companion.caller(frame);
            }
            helpers.add(new AvailObjectFieldHelper(NilDescriptor.Companion.getNil(), AbstractDescriptor.DebuggerObjectSlots.DUMMY_DEBUGGER_SLOT, -1, ObjectTupleDescriptor.Companion.tupleFromList(frames), "Frames", null, null, 96, null));
        }
        helpers.add(new AvailObjectFieldHelper(NilDescriptor.Companion.getNil(), AbstractDescriptor.DebuggerObjectSlots.DUMMY_DEBUGGER_SLOT, -1, this.availLoaderOrNull(), "Loader", null, null, 96, null));
        helpers.add(new AvailObjectFieldHelper(NilDescriptor.Companion.getNil(), AbstractDescriptor.DebuggerObjectSlots.DUMMY_DEBUGGER_SLOT, -1, this.fiber, "Fiber", null, null, 96, null));
        Collection $this$toTypedArray$iv2 = helpers;
        boolean $i$f$toTypedArray2 = false;
        Collection thisCollection$iv2 = $this$toTypedArray$iv2;
        AvailObjectFieldHelper[] availObjectFieldHelperArray = thisCollection$iv2.toArray(new AvailObjectFieldHelper[0]);
        Intrinsics.checkNotNull((Object)availObjectFieldHelperArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        return availObjectFieldHelperArray;
    }

    public final int getInterpreterIndex() {
        return this.interpreterIndex;
    }

    @NotNull
    public final String getDebugModeString() {
        return this.debugModeString;
    }

    public final void setDebugModeString(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.debugModeString = string2;
    }

    @NotNull
    public final AvailLoader availLoader() {
        AvailLoader availLoader = this.availLoader;
        Intrinsics.checkNotNull((Object)availLoader);
        return availLoader;
    }

    @Nullable
    public final AvailLoader availLoaderOrNull() {
        return this.availLoader;
    }

    @Nullable
    public final AvailDebuggerModel getDebugger() {
        return this.debugger;
    }

    @Nullable
    public final Function1<A_Fiber, Boolean> getDebuggerRunCondition() {
        return this.debuggerRunCondition;
    }

    @Nullable
    public final A_Fiber fiberOrNull() {
        return this.fiber;
    }

    @NotNull
    public final A_Fiber fiber() {
        A_Fiber a_Fiber = this.fiber;
        Intrinsics.checkNotNull((Object)a_Fiber);
        return a_Fiber;
    }

    public final void fiber(@Nullable A_Fiber newFiber2, @Nullable String tempDebug) {
        CharSequence charSequence;
        if (debugPrimitives) {
            Object object;
            charSequence = new StringBuilder();
            StringBuilder $this$fiber_u24lambda_u2d0 = charSequence;
            boolean bl = false;
            $this$fiber_u24lambda_u2d0.append("[" + this.interpreterIndex + "] fiber: ");
            if (this.fiber == null) {
                object = "null";
            } else {
                A_Fiber a_Fiber = this.fiber;
                Intrinsics.checkNotNull((Object)a_Fiber);
                long l = A_Fiber.Companion.getUniqueId(a_Fiber);
                A_Fiber a_Fiber2 = this.fiber;
                Intrinsics.checkNotNull((Object)a_Fiber2);
                object = l + "[" + A_Fiber.Companion.getExecutionState(a_Fiber2) + "]";
            }
            $this$fiber_u24lambda_u2d0.append((String)object);
            $this$fiber_u24lambda_u2d0.append(" -> ");
            $this$fiber_u24lambda_u2d0.append((String)(newFiber2 == null ? "null" : A_Fiber.Companion.getUniqueId(newFiber2) + "[" + A_Fiber.Companion.getExecutionState(newFiber2) + "]"));
            $this$fiber_u24lambda_u2d0.append(" (" + tempDebug + ")");
            String string2 = ((StringBuilder)charSequence).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
            String string3 = string2;
            Logger logger = loggerDebugPrimitives;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"loggerDebugPrimitives");
            Level level = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"INFO");
            charSequence = new Object[]{string3};
            Companion.log(logger, level, "{0}", (Object[])charSequence);
        }
        boolean string3 = this.fiber == null ^ newFiber2 == null;
        if (_Assertions.ENABLED && !string3) {
            charSequence = "Assertion failed";
            throw new AssertionError(charSequence);
        }
        boolean bl = string3 = newFiber2 == null || A_Fiber.Companion.getExecutionState(newFiber2) == FiberDescriptor.ExecutionState.RUNNING;
        if (_Assertions.ENABLED && !string3) {
            charSequence = "Assertion failed";
            throw new AssertionError(charSequence);
        }
        this.fiber = newFiber2;
        this.setReifiedContinuation(null);
        if (newFiber2 != null) {
            boolean readsBeforeWrites;
            this.availLoader = A_Fiber.Companion.getAvailLoader(newFiber2);
            this.traceVariableReadsBeforeWrites = readsBeforeWrites = A_Fiber.Companion.traceFlag(newFiber2, FiberDescriptor.TraceFlag.TRACE_VARIABLE_READS_BEFORE_WRITES);
            this.traceVariableWrites = readsBeforeWrites || A_Fiber.Companion.traceFlag(newFiber2, FiberDescriptor.TraceFlag.TRACE_VARIABLE_WRITES);
            this.debugger = A_Fiber.Companion.getFiberHelper(newFiber2).getDebugger().get();
            this.debuggerRunCondition = A_Fiber.Companion.getFiberHelper(newFiber2).getDebuggerRunCondition();
        } else {
            this.availLoader = null;
            this.traceVariableReadsBeforeWrites = false;
            this.traceVariableWrites = false;
            this.debugger = null;
            this.debuggerRunCondition = null;
        }
    }

    public final boolean traceVariableReadsBeforeWrites() {
        return this.traceVariableReadsBeforeWrites;
    }

    public final void setTraceVariableReadsBeforeWrites(boolean traceVariableReadsBeforeWrites) {
        if (traceVariableReadsBeforeWrites) {
            A_Fiber.Companion.setTraceFlag(this.fiber(), FiberDescriptor.TraceFlag.TRACE_VARIABLE_READS_BEFORE_WRITES);
        } else {
            A_Fiber.Companion.clearTraceFlag(this.fiber(), FiberDescriptor.TraceFlag.TRACE_VARIABLE_READS_BEFORE_WRITES);
        }
        this.traceVariableReadsBeforeWrites = traceVariableReadsBeforeWrites;
        this.traceVariableWrites = traceVariableReadsBeforeWrites;
    }

    public final boolean traceVariableWrites() {
        return this.traceVariableWrites;
    }

    public final void setTraceVariableWrites(boolean traceVariableWrites) {
        if (traceVariableWrites) {
            A_Fiber.Companion.setTraceFlag(this.fiber(), FiberDescriptor.TraceFlag.TRACE_VARIABLE_WRITES);
        } else {
            A_Fiber.Companion.clearTraceFlag(this.fiber(), FiberDescriptor.TraceFlag.TRACE_VARIABLE_WRITES);
        }
        this.traceVariableWrites = traceVariableWrites;
    }

    @NotNull
    public final A_Module module() {
        Object object = A_Fiber.Companion.getAvailLoader(this.fiber());
        if (object == null || (object = ((AvailLoader)object).getModule()) == null) {
            object = NilDescriptor.Companion.getNil();
        }
        return object;
    }

    @ReferencedInGeneratedCode
    public final void setLatestResult(@Nullable A_BasicObject newResult) {
        boolean bl;
        boolean bl2 = bl = newResult != null || !this.returnNow;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.latestResult = (AvailObject)newResult;
        if (debugL2) {
            String string3;
            Level level = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"INFO");
            if (this.latestResult == null) {
                string3 = "null";
            } else {
                AvailObject availObject = this.latestResult;
                Intrinsics.checkNotNull((Object)availObject);
                string3 = availObject.getTypeTag().name();
            }
            Companion.log(loggerDebugL2, level, this.debugModeString + "Set latestResult: " + string3, new Object[0]);
        }
    }

    @ReferencedInGeneratedCode
    @NotNull
    public final AvailObject getLatestResult() {
        AvailObject availObject = this.latestResult;
        Intrinsics.checkNotNull((Object)availObject);
        return availObject;
    }

    @Nullable
    public final AvailObject latestResultOrNull() {
        return this.latestResult;
    }

    @NotNull
    public final Primitive.Result suspendInSafePointThen(@NotNull Function1<? super SuspensionHelper<A_BasicObject>, Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        A_Fiber a_Fiber = this.fiber;
        Intrinsics.checkNotNull((Object)a_Fiber);
        A_Fiber theFiber = a_Fiber;
        boolean bl = false;
        return this.suspendThen((Function1<? super SuspensionHelper<A_BasicObject>, Unit>)((Function1)new Function1<SuspensionHelper<A_BasicObject>, Unit>(this, theFiber, action2){
            final /* synthetic */ Interpreter this$0;
            final /* synthetic */ A_Fiber $theFiber;
            final /* synthetic */ Function1<SuspensionHelper<A_BasicObject>, Unit> $action;
            {
                this.this$0 = $receiver;
                this.$theFiber = $theFiber;
                this.$action = $action;
                super(1);
            }

            public final void invoke(@NotNull SuspensionHelper<A_BasicObject> $this$suspendThen) {
                Intrinsics.checkNotNullParameter($this$suspendThen, (String)"$this$suspendThen");
                this.this$0.runtime.whenSafePointDo(A_Fiber.Companion.getPriority(this.$theFiber), AvailTask.Companion.forUnboundFiber(this.$theFiber, (Function0<Unit>)((Function0)new Function0<Unit>(this.$action, $this$suspendThen){
                    final /* synthetic */ Function1<SuspensionHelper<A_BasicObject>, Unit> $action;
                    final /* synthetic */ SuspensionHelper<A_BasicObject> $this_suspendThen;
                    {
                        this.$action = $action;
                        this.$this_suspendThen = $this_suspendThen;
                        super(0);
                    }

                    public final void invoke() {
                        this.$action.invoke(this.$this_suspendThen);
                    }
                })));
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @CheckReturnValue
    @NotNull
    public final Primitive.Result suspendThen(@NotNull Function1<? super SuspensionHelper<A_BasicObject>, Unit> body2) {
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(body2, (String)"body");
        Iterable $this$map$iv = this.argsBuffer;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            AvailObject availObject = (AvailObject)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it);
        }
        List copiedArgs = (List)destination$iv$iv;
        A_Function a_Function = this.function;
        Intrinsics.checkNotNull((Object)a_Function);
        A_Function primitiveFunction = a_Function;
        Primitive primitive2 = primitiveFunction.code().codePrimitive();
        Intrinsics.checkNotNull((Object)primitive2);
        Primitive prim = primitive2;
        boolean $this$mapTo$iv$iv2 = prim.hasFlag(Primitive.Flag.CanSuspend);
        if (_Assertions.ENABLED && !$this$mapTo$iv$iv2) {
            destination$iv$iv = "Assertion failed";
            throw new AssertionError(destination$iv$iv);
        }
        A_Fiber currentFiber = this.fiber();
        AtomicBoolean once = new AtomicBoolean(false);
        this.postExitContinuation((Function0<Unit>)((Function0)new Function0<Unit>(body2, once, this, currentFiber, prim, primitiveFunction, (List<AvailObject>)copiedArgs){
            final /* synthetic */ Function1<SuspensionHelper<A_BasicObject>, Unit> $body;
            final /* synthetic */ AtomicBoolean $once;
            final /* synthetic */ Interpreter this$0;
            final /* synthetic */ A_Fiber $currentFiber;
            final /* synthetic */ Primitive $prim;
            final /* synthetic */ A_Function $primitiveFunction;
            final /* synthetic */ List<AvailObject> $copiedArgs;
            {
                this.$body = $body;
                this.$once = $once;
                this.this$0 = $receiver;
                this.$currentFiber = $currentFiber;
                this.$prim = $prim;
                this.$primitiveFunction = $primitiveFunction;
                this.$copiedArgs = $copiedArgs;
                super(0);
            }

            public final void invoke() {
                this.$body.invoke(new SuspensionHelper<A>((Function1)new Function1<A_BasicObject, Unit>(this.$once, this.this$0, this.$currentFiber, this.$prim){
                    final /* synthetic */ AtomicBoolean $once;
                    final /* synthetic */ Interpreter this$0;
                    final /* synthetic */ A_Fiber $currentFiber;
                    final /* synthetic */ Primitive $prim;
                    {
                        this.$once = $once;
                        this.this$0 = $receiver;
                        this.$currentFiber = $currentFiber;
                        this.$prim = $prim;
                        super(1);
                    }

                    public final void invoke(@NotNull A_BasicObject it) {
                        boolean bl;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        boolean bl2 = bl = !this.$once.getAndSet(true);
                        if (_Assertions.ENABLED && !bl) {
                            String string2 = "Assertion failed";
                            throw new AssertionError((Object)string2);
                        }
                        this.this$0.runtime.resumeFromSuccessfulPrimitive(this.$currentFiber, this.$prim, it);
                    }
                }, (Function1<? super A_BasicObject, Unit>)((Function1)new Function1<A_BasicObject, Unit>(this.$once, this.this$0, this.$currentFiber, this.$primitiveFunction, this.$copiedArgs){
                    final /* synthetic */ AtomicBoolean $once;
                    final /* synthetic */ Interpreter this$0;
                    final /* synthetic */ A_Fiber $currentFiber;
                    final /* synthetic */ A_Function $primitiveFunction;
                    final /* synthetic */ List<AvailObject> $copiedArgs;
                    {
                        this.$once = $once;
                        this.this$0 = $receiver;
                        this.$currentFiber = $currentFiber;
                        this.$primitiveFunction = $primitiveFunction;
                        this.$copiedArgs = $copiedArgs;
                        super(1);
                    }

                    public final void invoke(@NotNull A_BasicObject it) {
                        boolean bl;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        boolean bl2 = bl = !this.$once.getAndSet(true);
                        if (_Assertions.ENABLED && !bl) {
                            String string2 = "Assertion failed";
                            throw new AssertionError((Object)string2);
                        }
                        this.this$0.runtime.resumeFromFailedPrimitive(this.$currentFiber, it, this.$primitiveFunction, this.$copiedArgs);
                    }
                })));
            }
        }));
        return this.primitiveSuspend(primitiveFunction);
    }

    @CheckReturnValue
    @NotNull
    public final Primitive.Result primitiveSuccess(@NotNull A_BasicObject result2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        boolean bl2 = bl = A_Fiber.Companion.getExecutionState(this.fiber()) == FiberDescriptor.ExecutionState.RUNNING;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.setLatestResult(result2);
        return Primitive.Result.SUCCESS;
    }

    @CheckReturnValue
    @NotNull
    public final Primitive.Result primitiveFailure(@NotNull AvailErrorCode code) {
        Intrinsics.checkNotNullParameter((Object)((Object)code), (String)"code");
        return this.primitiveFailure(code.numericCode());
    }

    @CheckReturnValue
    @NotNull
    public final Primitive.Result primitiveFailure(@NotNull AvailException exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        return this.primitiveFailure(exception.numericCode());
    }

    @CheckReturnValue
    @NotNull
    public final Primitive.Result primitiveFailure(@NotNull AvailRuntimeException exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        return this.primitiveFailure(exception.getNumericCode());
    }

    @CheckReturnValue
    @NotNull
    public final Primitive.Result primitiveFailure(@NotNull A_BasicObject result2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        boolean bl2 = bl = A_Fiber.Companion.getExecutionState(this.fiber()) == FiberDescriptor.ExecutionState.RUNNING;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.setLatestResult(result2);
        return Primitive.Result.FAILURE;
    }

    public final boolean getExitNow() {
        return this.exitNow;
    }

    public final void setExitNow(boolean bl) {
        this.exitNow = bl;
    }

    @Nullable
    public final Function0<Unit> getPostExitContinuation() {
        return this.postExitContinuation;
    }

    public final void setPostExitContinuation(@Nullable Function0<Unit> function0) {
        this.postExitContinuation = function0;
    }

    public final void postExitContinuation(@Nullable Function0<Unit> continuation) {
        boolean bl;
        boolean bl2 = bl = this.postExitContinuation == null || continuation == null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.postExitContinuation = continuation;
    }

    @CheckReturnValue
    private final Primitive.Result primitiveSuspend(FiberDescriptor.ExecutionState state) {
        boolean bl;
        boolean bl2 = bl = !this.exitNow;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        bl = state.getIndicatesSuspension();
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        boolean bl3 = bl = this.unreifiedCallDepth() == 0;
        if (_Assertions.ENABLED && !bl) {
            String string4 = "Assertion failed";
            throw new AssertionError((Object)string4);
        }
        A_Fiber aFiber = this.fiber();
        aFiber.lock((Function0)new Function0<Unit>(aFiber, state, this){
            final /* synthetic */ A_Fiber $aFiber;
            final /* synthetic */ FiberDescriptor.ExecutionState $state;
            final /* synthetic */ Interpreter this$0;
            {
                this.$aFiber = $aFiber;
                this.$state = $state;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                boolean bl;
                boolean bl2 = bl = A_Fiber.Companion.getExecutionState(this.$aFiber) == FiberDescriptor.ExecutionState.RUNNING;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                A_Fiber.Companion.setExecutionState(this.$aFiber, this.$state);
                AvailObject availObject = this.this$0.getReifiedContinuation();
                Intrinsics.checkNotNull((Object)availObject);
                A_Fiber.Companion.setContinuation(this.$aFiber, availObject);
                this.this$0.setReifiedContinuation(null);
                boolean bound = A_Fiber.Companion.getAndSetSynchronizationFlag(this.$aFiber, FiberDescriptor.SynchronizationFlag.BOUND, false);
                A_Fiber.Companion.getFiberHelper(this.$aFiber).stopCountingCPU();
                if (_Assertions.ENABLED && !bound) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
                this.this$0.fiber(null, "primitiveSuspend");
            }
        });
        this.startTick = -1L;
        if (debugL2) {
            Level level = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"INFO");
            Object[] objectArray = new Object[]{this.debugModeString};
            Companion.log(loggerDebugL2, level, "{0}Set exitNow (primitiveSuspend), clear latestResult", objectArray);
        }
        this.exitNow = true;
        this.setLatestResult(null);
        this.levelOneStepper.wipeRegisters();
        return Primitive.Result.FIBER_SUSPENDED;
    }

    @CheckReturnValue
    @NotNull
    public final Primitive.Result primitiveSuspend(@NotNull A_Function suspendingFunction) {
        Intrinsics.checkNotNullParameter((Object)suspendingFunction, (String)"suspendingFunction");
        Primitive primitive2 = suspendingFunction.code().codePrimitive();
        Intrinsics.checkNotNull((Object)primitive2);
        Primitive prim = primitive2;
        boolean bl = prim.hasFlag(Primitive.Flag.CanSuspend);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        A_Fiber.Companion.setSuspendingFunction(this.fiber(), suspendingFunction);
        this.function = null;
        return this.primitiveSuspend(FiberDescriptor.ExecutionState.SUSPENDED);
    }

    @CheckReturnValue
    @NotNull
    public final Primitive.Result primitivePark(@NotNull A_Function suspendingFunction) {
        Intrinsics.checkNotNullParameter((Object)suspendingFunction, (String)"suspendingFunction");
        A_Fiber.Companion.setSuspendingFunction(this.fiber(), suspendingFunction);
        return this.primitiveSuspend(FiberDescriptor.ExecutionState.PARKED);
    }

    private final void exitFiber(A_BasicObject finalObject, FiberDescriptor.ExecutionState state) {
        boolean bl;
        boolean bl2 = bl = !this.exitNow;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        bl = state.getIndicatesTermination();
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        A_Fiber aFiber = this.fiber();
        aFiber.lock((Function0)new Function0<Unit>(aFiber, state, finalObject, this){
            final /* synthetic */ A_Fiber $aFiber;
            final /* synthetic */ FiberDescriptor.ExecutionState $state;
            final /* synthetic */ A_BasicObject $finalObject;
            final /* synthetic */ Interpreter this$0;
            {
                this.$aFiber = $aFiber;
                this.$state = $state;
                this.$finalObject = $finalObject;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                boolean bl;
                boolean bl2 = bl = A_Fiber.Companion.getExecutionState(this.$aFiber) == FiberDescriptor.ExecutionState.RUNNING;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                A_Fiber.Companion.setExecutionState(this.$aFiber, this.$state);
                A_Fiber.Companion.setContinuation(this.$aFiber, NilDescriptor.Companion.getNil());
                A_BasicObject a_BasicObject = this.$finalObject;
                Intrinsics.checkNotNull((Object)a_BasicObject, (String)"null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
                A_Fiber.Companion.setFiberResult(this.$aFiber, (AvailObject)a_BasicObject);
                boolean bound = A_Fiber.Companion.getAndSetSynchronizationFlag(this.$aFiber, FiberDescriptor.SynchronizationFlag.BOUND, false);
                A_Fiber.Companion.getFiberHelper(this.$aFiber).stopCountingCPU();
                if (_Assertions.ENABLED && !bound) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
                this.this$0.fiber(null, "exitFiber");
            }
        });
        this.startTick = -1L;
        this.exitNow = true;
        if (debugL2) {
            Level level = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"INFO");
            Companion.log(loggerDebugL2, level, this.debugModeString + "Set exitNow and clear latestResult (exitFiber)", new Object[0]);
        }
        this.setLatestResult(null);
        this.levelOneStepper.wipeRegisters();
        this.postExitContinuation((Function0<Unit>)((Function0)new Function0<Unit>(aFiber, this){
            final /* synthetic */ A_Fiber $aFiber;
            final /* synthetic */ Interpreter this$0;
            {
                this.$aFiber = $aFiber;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                A_Set joining2 = (A_Set)this.$aFiber.lock((Function0)new Function0<A_Set>(this.$aFiber){
                    final /* synthetic */ A_Fiber $aFiber;
                    {
                        this.$aFiber = $aFiber;
                        super(0);
                    }

                    @NotNull
                    public final A_Set invoke() {
                        A_Set temp = A_Fiber.Companion.getJoiningFibers(this.$aFiber).makeShared();
                        A_Fiber.Companion.setJoiningFibers(this.$aFiber, NilDescriptor.Companion.getNil());
                        return temp;
                    }
                });
                Iterable iterable = joining2;
                Interpreter interpreter = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    AvailObject joiner = (AvailObject)element$iv;
                    boolean bl = false;
                    joiner.lock((Function0)new Function0<Unit>(joiner, interpreter){
                        final /* synthetic */ AvailObject $joiner;
                        final /* synthetic */ Interpreter this$0;
                        {
                            this.$joiner = $joiner;
                            this.this$0 = $receiver;
                            super(0);
                        }

                        public final void invoke() {
                            A_Fiber.Companion.getAndSetSynchronizationFlag(this.$joiner, FiberDescriptor.SynchronizationFlag.PERMIT_UNAVAILABLE, false);
                            if (A_Fiber.Companion.getExecutionState(this.$joiner) == FiberDescriptor.ExecutionState.PARKED) {
                                boolean bl;
                                A_Fiber.Companion.setExecutionState(this.$joiner, FiberDescriptor.ExecutionState.SUSPENDED);
                                Primitive primitive2 = A_Fiber.Companion.getSuspendingFunction(this.$joiner).code().codePrimitive();
                                Intrinsics.checkNotNull((Object)primitive2);
                                Primitive suspended = primitive2;
                                boolean bl2 = bl = suspended == P_AttemptJoinFiber.INSTANCE || suspended == P_ParkCurrentFiber.INSTANCE;
                                if (_Assertions.ENABLED && !bl) {
                                    String string2 = "Assertion failed";
                                    throw new AssertionError((Object)string2);
                                }
                                this.this$0.runtime.resumeFromSuccessfulPrimitive(this.$joiner, suspended, NilDescriptor.Companion.getNil());
                            }
                        }
                    });
                }
            }
        }));
    }

    public final void terminateFiber(@NotNull A_BasicObject value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.exitFiber(value, FiberDescriptor.ExecutionState.TERMINATED);
    }

    public final void abortFiber() {
        this.exitFiber(NilDescriptor.Companion.getNil(), FiberDescriptor.ExecutionState.ABORTED);
    }

    @ReferencedInGeneratedCode
    @Nullable
    public final StackReifier attemptThePrimitive(@NotNull A_Function primitiveFunction, @NotNull Primitive primitive2) {
        Intrinsics.checkNotNullParameter((Object)primitiveFunction, (String)"primitiveFunction");
        Intrinsics.checkNotNullParameter((Object)primitive2, (String)"primitive");
        return primitive2.hasFlag(Primitive.Flag.CanInline) ? this.attemptInlinePrimitive(primitiveFunction, primitive2) : this.attemptNonInlinePrimitive(primitiveFunction, primitive2);
    }

    @ReferencedInGeneratedCode
    @Nullable
    public final StackReifier attemptInlinePrimitive(@NotNull A_Function primitiveFunction, @NotNull Primitive primitive2) {
        StackReifier stackReifier;
        Intrinsics.checkNotNullParameter((Object)primitiveFunction, (String)"primitiveFunction");
        Intrinsics.checkNotNullParameter((Object)primitive2, (String)"primitive");
        if (debugL2) {
            Level level = Level.FINER;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"FINER");
            Object[] objectArray = new Object[]{this.debugModeString, primitive2.getName()};
            Companion.log(loggerDebugL2, level, "{0}          inline prim = {1}", objectArray);
        }
        long timeBefore = this.beforeAttemptPrimitive(primitive2);
        Primitive.Result result2 = primitive2.attempt(this);
        this.afterAttemptPrimitive(primitive2, timeBefore, result2);
        switch (WhenMappings.$EnumSwitchMapping$0[result2.ordinal()]) {
            case 1: {
                boolean bl;
                boolean bl2 = bl = this.latestResultOrNull() != null;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                this.function = null;
                this.returnNow = true;
                this.returningFunction = primitiveFunction;
                stackReifier = null;
                break;
            }
            case 2: {
                boolean bl;
                boolean bl3 = bl = this.latestResultOrNull() != null;
                if (_Assertions.ENABLED && !bl) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
                this.function = primitiveFunction;
                L2Chunk l2Chunk = this.chunk;
                Intrinsics.checkNotNull((Object)l2Chunk);
                this.setOffset(l2Chunk.getOffsetAfterInitialTryPrimitive());
                boolean bl4 = bl = !this.returnNow;
                if (_Assertions.ENABLED && !bl) {
                    String string4 = "Assertion failed";
                    throw new AssertionError((Object)string4);
                }
                stackReifier = null;
                break;
            }
            case 3: {
                boolean bl;
                boolean bl5 = primitive2.hasFlag(Primitive.Flag.Invokes);
                if (_Assertions.ENABLED && !bl5) {
                    String string5 = "Assertion failed";
                    throw new AssertionError((Object)string5);
                }
                L1InstructionStepper stepper = this.levelOneStepper;
                L2Chunk savedChunk = this.chunk;
                int savedOffset = this.offset;
                AvailObject[] savedPointers = stepper.getPointers();
                A_Function a_Function = this.function;
                Intrinsics.checkNotNull((Object)a_Function);
                StackReifier reifier = this.invokeFunction(a_Function);
                this.function = primitiveFunction;
                this.chunk = savedChunk;
                this.setOffset(savedOffset);
                stepper.setPointers(savedPointers);
                if (reifier != null) {
                    return reifier;
                }
                boolean bl6 = bl = this.latestResultOrNull() != null;
                if (_Assertions.ENABLED && !bl) {
                    String string6 = "Assertion failed";
                    throw new AssertionError((Object)string6);
                }
                this.returnNow = true;
                this.returningFunction = this.function;
                stackReifier = null;
                break;
            }
            case 4: {
                boolean stepper = primitive2.hasFlag(Primitive.Flag.CanSwitchContinuations);
                if (_Assertions.ENABLED && !stepper) {
                    String savedChunk = "Assertion failed";
                    throw new AssertionError((Object)savedChunk);
                }
                AvailObject availObject = this.getReifiedContinuation();
                Intrinsics.checkNotNull((Object)availObject);
                AvailObject newContinuation = availObject;
                A_Function newFunction = this.function;
                L2Chunk newChunk = this.chunk;
                int newOffset = this.offset;
                boolean newReturnNow = this.returnNow;
                AvailObject newReturnValue = this.latestResultOrNull();
                this.isReifying = true;
                Statistic statistic = primitive2.getReificationAbandonmentStat();
                Intrinsics.checkNotNull((Object)statistic);
                stackReifier = new StackReifier(false, statistic, (Function0<Unit>)((Function0)new Function0<Unit>(this, newContinuation, newFunction, newChunk, newOffset, newReturnNow, newReturnValue){
                    final /* synthetic */ Interpreter this$0;
                    final /* synthetic */ AvailObject $newContinuation;
                    final /* synthetic */ A_Function $newFunction;
                    final /* synthetic */ L2Chunk $newChunk;
                    final /* synthetic */ int $newOffset;
                    final /* synthetic */ boolean $newReturnNow;
                    final /* synthetic */ AvailObject $newReturnValue;
                    {
                        this.this$0 = $receiver;
                        this.$newContinuation = $newContinuation;
                        this.$newFunction = $newFunction;
                        this.$newChunk = $newChunk;
                        this.$newOffset = $newOffset;
                        this.$newReturnNow = $newReturnNow;
                        this.$newReturnValue = $newReturnValue;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.setReifiedContinuation(this.$newContinuation);
                        this.this$0.function = this.$newFunction;
                        this.this$0.chunk = this.$newChunk;
                        this.this$0.setOffset(this.$newOffset);
                        this.this$0.returnNow = this.$newReturnNow;
                        this.this$0.setLatestResult(this.$newReturnValue);
                        this.this$0.setReifying(false);
                    }
                }));
                break;
            }
            case 5: {
                if (_Assertions.ENABLED) {
                    boolean bl = false;
                    String string7 = "CanInline primitive must not suspend fiber";
                    throw new AssertionError((Object)string7);
                }
                stackReifier = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return stackReifier;
    }

    @ReferencedInGeneratedCode
    @NotNull
    public final StackReifier attemptNonInlinePrimitive(@Nullable A_Function primitiveFunction, @NotNull Primitive primitive2) {
        Intrinsics.checkNotNullParameter((Object)primitive2, (String)"primitive");
        if (debugL2) {
            Level level = Level.FINER;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"FINER");
            Object[] objectArray = new Object[]{this.debugModeString, primitive2.getName()};
            Companion.log(loggerDebugL2, level, "{0}          reifying for {1}", objectArray);
        }
        L1InstructionStepper stepper = this.levelOneStepper;
        L2Chunk l2Chunk = this.chunk;
        Intrinsics.checkNotNull((Object)l2Chunk);
        L2Chunk savedChunk = l2Chunk;
        int savedOffset = this.offset;
        AvailObject[] savedPointers = stepper.getPointers();
        Collection $this$toTypedArray$iv = this.argsBuffer;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        AvailObject[] availObjectArray = thisCollection$iv.toArray(new AvailObject[0]);
        Intrinsics.checkNotNull((Object)availObjectArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        AvailObject[] savedArgs = availObjectArray;
        this.isReifying = true;
        Statistic statistic = primitive2.getReificationForNoninlineStat();
        Intrinsics.checkNotNull((Object)statistic);
        return new StackReifier(true, statistic, (Function0<Unit>)((Function0)new Function0<Unit>(this, savedChunk, savedOffset, stepper, savedPointers, primitiveFunction, primitive2, savedArgs){
            final /* synthetic */ Interpreter this$0;
            final /* synthetic */ L2Chunk $savedChunk;
            final /* synthetic */ int $savedOffset;
            final /* synthetic */ L1InstructionStepper $stepper;
            final /* synthetic */ AvailObject[] $savedPointers;
            final /* synthetic */ A_Function $primitiveFunction;
            final /* synthetic */ Primitive $primitive;
            final /* synthetic */ AvailObject[] $savedArgs;
            {
                this.this$0 = $receiver;
                this.$savedChunk = $savedChunk;
                this.$savedOffset = $savedOffset;
                this.$stepper = $stepper;
                this.$savedPointers = $savedPointers;
                this.$primitiveFunction = $primitiveFunction;
                this.$primitive = $primitive;
                this.$savedArgs = $savedArgs;
                super(0);
            }

            public final void invoke() {
                boolean bl;
                boolean bl2 = bl = this.this$0.unreifiedCallDepth() == 0;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string2 = "Should have reified stack for non-inlineable primitive";
                    throw new AssertionError((Object)string2);
                }
                this.this$0.chunk = this.$savedChunk;
                this.this$0.setOffset(this.$savedOffset);
                this.$stepper.setPointers(this.$savedPointers);
                this.this$0.function = this.$primitiveFunction;
                if (Interpreter.Companion.getDebugL2()) {
                    Logger logger = Interpreter.Companion.getLoggerDebugL2();
                    Level level = Level.FINER;
                    Intrinsics.checkNotNullExpressionValue((Object)level, (String)"FINER");
                    Object[] objectArray = new Object[]{this.this$0.getDebugModeString(), this.$primitive.getName()};
                    Interpreter.Companion.log(logger, level, "{0}          reified, now starting {1}", objectArray);
                }
                this.this$0.argsBuffer.clear();
                CollectionsKt.addAll((Collection)this.this$0.argsBuffer, (Object[])this.$savedArgs);
                long timeBefore = this.this$0.beforeAttemptPrimitive(this.$primitive);
                Primitive.Result result2 = this.$primitive.attempt(this.this$0);
                this.this$0.afterAttemptPrimitive(this.$primitive, timeBefore, result2);
                switch (attemptNonInlinePrimitive.WhenMappings.$EnumSwitchMapping$0[result2.ordinal()]) {
                    case 1: {
                        boolean bl4;
                        boolean bl5 = bl4 = this.this$0.latestResultOrNull() != null;
                        if (_Assertions.ENABLED && !bl4) {
                            String string3 = "Assertion failed";
                            throw new AssertionError((Object)string3);
                        }
                        this.this$0.returnNow = true;
                        this.this$0.returningFunction = this.$primitiveFunction;
                        break;
                    }
                    case 2: {
                        boolean bl6;
                        boolean bl7 = bl6 = this.this$0.latestResultOrNull() != null;
                        if (_Assertions.ENABLED && !bl6) {
                            String string4 = "Assertion failed";
                            throw new AssertionError((Object)string4);
                        }
                        this.this$0.function = this.$primitiveFunction;
                        L2Chunk l2Chunk = this.this$0.chunk;
                        Intrinsics.checkNotNull((Object)l2Chunk);
                        this.this$0.setOffset(l2Chunk.getOffsetAfterInitialTryPrimitive());
                        boolean bl8 = bl6 = !this.this$0.returnNow;
                        if (!_Assertions.ENABLED || bl6) break;
                        String string5 = "Assertion failed";
                        throw new AssertionError((Object)string5);
                    }
                    case 3: {
                        if (!_Assertions.ENABLED) break;
                        boolean bl9 = false;
                        String string6 = "Invoking primitives should be inlineable";
                        throw new AssertionError((Object)string6);
                    }
                    case 4: {
                        boolean bl10 = this.$primitive.hasFlag(Primitive.Flag.CanSwitchContinuations);
                        if (!_Assertions.ENABLED || bl10) break;
                        String string7 = "Assertion failed";
                        throw new AssertionError((Object)string7);
                    }
                    case 5: {
                        boolean bl11 = this.this$0.getExitNow();
                        if (_Assertions.ENABLED && !bl11) {
                            String string8 = "Assertion failed";
                            throw new AssertionError((Object)string8);
                        }
                        this.this$0.returnNow = false;
                    }
                }
                this.this$0.setReifying(false);
            }
        }));
    }

    @ReferencedInGeneratedCode
    public final long beforeAttemptPrimitive(@NotNull Primitive primitive2) {
        Intrinsics.checkNotNullParameter((Object)primitive2, (String)"primitive");
        if (debugPrimitives) {
            StringBuilder builder2 = new StringBuilder();
            int argCount = 1;
            for (AvailObject arg : this.argsBuffer) {
                Object argString = arg.toString();
                if (((String)argString).length() > 70) {
                    String string2 = ((String)argString).substring(0, 70);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    argString = string2 + "...";
                }
                CharSequence charSequence = (CharSequence)argString;
                Regex regex = new Regex("\\n");
                String string3 = "\\\\n";
                argString = regex.replace(charSequence, string3);
                builder2.append("\n\t\t").append(this.debugModeString).append("\t#").append(argCount).append(". ").append((String)argString);
                ++argCount;
            }
            Logger logger = loggerDebugPrimitives;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"loggerDebugPrimitives");
            Level level = Level.FINER;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"FINER");
            Object[] objectArray = new Object[]{this.debugModeString, primitive2.getName(), builder2.toString()};
            Companion.log(logger, level, "{0}attempt {1}{2}", objectArray);
        }
        this.returnNow = false;
        this.setLatestResult(null);
        boolean bl = Intrinsics.areEqual((Object)Companion.current(), (Object)this);
        if (_Assertions.ENABLED && !bl) {
            String string4 = "Assertion failed";
            throw new AssertionError((Object)string4);
        }
        return AvailRuntimeSupport.INSTANCE.captureNanos();
    }

    @ReferencedInGeneratedCode
    @NotNull
    public final Primitive.Result afterAttemptPrimitive(@NotNull Primitive primitive2, long timeBefore, @NotNull Primitive.Result success2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)primitive2, (String)"primitive");
        Intrinsics.checkNotNullParameter((Object)((Object)success2), (String)"success");
        long timeAfter = AvailRuntimeSupport.INSTANCE.captureNanos();
        primitive2.addNanosecondsRunning(timeAfter - timeBefore, this.interpreterIndex);
        boolean bl2 = bl = success2 != Primitive.Result.FAILURE || !primitive2.hasFlag(Primitive.Flag.CannotFail);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        if (debugPrimitives && loggerDebugPrimitives.isLoggable(Level.FINER)) {
            Object object;
            if (success2 == Primitive.Result.SUCCESS) {
                Object result2 = this.getLatestResult().toString();
                if (((String)result2).length() > 70) {
                    String string3 = ((String)result2).substring(0, 70);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    result2 = string3 + "...";
                }
                object = " --> " + (String)result2;
            } else if (success2 == Primitive.Result.FAILURE && A_Number.Companion.isInt(this.getLatestResult())) {
                int errorInt = A_Number.Companion.getExtractInt(this.getLatestResult());
                object = " (" + AvailErrorCode.Companion.byNumericCode(errorInt) + ")";
            } else {
                object = "";
            }
            String detailPart = object;
            Logger logger = loggerDebugPrimitives;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"loggerDebugPrimitives");
            Level level = Level.FINER;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"FINER");
            Object[] objectArray = new Object[]{this.debugModeString, primitive2.getName(), success2.name(), detailPart};
            Companion.log(logger, level, "{0}... completed primitive {1} => {2}{3}", objectArray);
            if (success2 != Primitive.Result.SUCCESS) {
                Logger logger2 = loggerDebugPrimitives;
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"loggerDebugPrimitives");
                Level level2 = Level.FINER;
                Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"FINER");
                objectArray = new Object[]{this.debugModeString, success2.name()};
                Companion.log(logger2, level2, "{0}      ({1})", objectArray);
            }
        }
        return success2;
    }

    @ReferencedInGeneratedCode
    @Nullable
    public final AvailObject getReifiedContinuation() {
        return this.theReifiedContinuation;
    }

    @ReferencedInGeneratedCode
    public final void setReifiedContinuation(@Nullable A_Continuation continuation) {
        this.theReifiedContinuation = (AvailObject)continuation;
        if (debugL2) {
            L2Chunk theChunk;
            String text;
            String string2 = continuation == null ? "null" : (text = ((AvailObject)continuation).isNil() ? ((AvailObject)continuation).toString() : (Intrinsics.areEqual((Object)(theChunk = A_Continuation.Companion.levelTwoChunk(continuation)), (Object)L2JVMChunk.Companion.getUnoptimizedChunk()) ? A_RawFunction.Companion.getMethodName(((AvailObject)continuation).function().code()) + " (unoptimized)" : theChunk.name() + ", offset= " + A_Continuation.Companion.levelTwoOffset(continuation)));
            Object object = this.chunk;
            if (object == null || (object = ((L2Chunk)object).getExecutableChunk()) == null) {
                object = L2JVMChunk.Companion.getUnoptimizedChunk().getExecutableChunk();
            }
            Companion.traceL2((ExecutableChunk)object, -999999, "Set continuation = ", text);
        }
    }

    @ReferencedInGeneratedCode
    public final void popContinuation() {
        if (debugL2) {
            StringBuilder builder2 = new StringBuilder();
            AvailObject availObject = this.theReifiedContinuation;
            Intrinsics.checkNotNull((Object)availObject);
            A_Continuation ptr = availObject;
            while (ptr.getNotNil()) {
                builder2.append("\n\t\toffset ").append(A_Continuation.Companion.levelTwoOffset(ptr)).append(" in ");
                L2Chunk ch = A_Continuation.Companion.levelTwoChunk(ptr);
                if (Intrinsics.areEqual((Object)ch, (Object)L2JVMChunk.Companion.getUnoptimizedChunk())) {
                    builder2.append("(L1) - ").append(A_RawFunction.Companion.getMethodName(A_Continuation.Companion.function(ptr).code()));
                } else {
                    builder2.append(A_Continuation.Companion.levelTwoChunk(ptr).name());
                }
                ptr = A_Continuation.Companion.caller(ptr);
            }
            Object object = this.chunk;
            if (object == null || (object = ((L2Chunk)object).getExecutableChunk()) == null) {
                object = L2JVMChunk.Companion.getUnoptimizedChunk().getExecutableChunk();
            }
            Companion.traceL2((ExecutableChunk)object, -100000, "POPPING CONTINUATION from:", builder2);
        }
        AvailObject availObject = this.getReifiedContinuation();
        Intrinsics.checkNotNull((Object)availObject);
        this.setReifiedContinuation(A_Continuation.Companion.caller(availObject));
    }

    public final void setOffset(int newOffset) {
        this.offset = newOffset;
    }

    public final void checkArgumentCount(int expectedCount) {
        boolean bl;
        boolean bl2 = bl = this.argsBuffer.size() == expectedCount;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
    }

    @NotNull
    public final AvailObject argument(int zeroBasedIndex) {
        return this.argsBuffer.get(zeroBasedIndex);
    }

    @ReferencedInGeneratedCode
    public final boolean isInterruptRequested() {
        return this.runtime.getSafePointRequested() || this.unreifiedCallDepth > 50 || this.runtime.getClock().get() - this.startTick >= 20L || A_Fiber.Companion.interruptRequestFlag(this.fiber(), FiberDescriptor.InterruptRequestFlag.REIFICATION_REQUESTED);
    }

    public final void processInterrupt(@NotNull A_Continuation continuation) {
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)continuation, (String)"continuation");
        boolean bl3 = bl2 = !this.exitNow;
        if (_Assertions.ENABLED && !bl2) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean bl4 = bl2 = !this.returnNow;
        if (_Assertions.ENABLED && !bl2) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        A_Fiber aFiber = this.fiber();
        Ref.ObjectRef waiters = new Ref.ObjectRef();
        waiters.element = CollectionsKt.emptyList();
        aFiber.lock((Function0)new Function0<Unit>(aFiber, continuation, (Ref.ObjectRef<List<Function1<A_Continuation, Unit>>>)waiters, this){
            final /* synthetic */ A_Fiber $aFiber;
            final /* synthetic */ A_Continuation $continuation;
            final /* synthetic */ Ref.ObjectRef<List<Function1<A_Continuation, Unit>>> $waiters;
            final /* synthetic */ Interpreter this$0;
            {
                this.$aFiber = $aFiber;
                this.$continuation = $continuation;
                this.$waiters = $waiters;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                A_Fiber a_Fiber = this.$aFiber;
                A_Fiber a_Fiber2 = this.$aFiber;
                A_Continuation a_Continuation = this.$continuation;
                Ref.ObjectRef<List<Function1<A_Continuation, Unit>>> objectRef = this.$waiters;
                Interpreter interpreter = this.this$0;
                A_Fiber a_Fiber3 = a_Fiber;
                synchronized (a_Fiber3) {
                    boolean bl;
                    boolean bl2 = false;
                    boolean bl3 = bl = A_Fiber.Companion.getExecutionState(a_Fiber2) == FiberDescriptor.ExecutionState.RUNNING;
                    if (_Assertions.ENABLED && !bl) {
                        String string2 = "Assertion failed";
                        throw new AssertionError((Object)string2);
                    }
                    A_Fiber.Companion.setExecutionState(a_Fiber2, FiberDescriptor.ExecutionState.INTERRUPTED);
                    A_Fiber.Companion.setContinuation(a_Fiber2, a_Continuation);
                    if (A_Fiber.Companion.getAndClearInterruptRequestFlag(a_Fiber2, FiberDescriptor.InterruptRequestFlag.REIFICATION_REQUESTED)) {
                        a_Continuation.makeShared();
                        objectRef.element = A_Fiber.Companion.getAndClearReificationWaiters(a_Fiber2);
                        boolean bl4 = bl = !((Collection)objectRef.element).isEmpty();
                        if (_Assertions.ENABLED && !bl) {
                            String string3 = "Assertion failed";
                            throw new AssertionError((Object)string3);
                        }
                    }
                    boolean bound = A_Fiber.Companion.getAndSetSynchronizationFlag(interpreter.fiber(), FiberDescriptor.SynchronizationFlag.BOUND, false);
                    A_Fiber.Companion.getFiberHelper(a_Fiber2).stopCountingCPU();
                    if (_Assertions.ENABLED && !bound) {
                        String string4 = "Assertion failed";
                        throw new AssertionError((Object)string4);
                    }
                    interpreter.fiber(null, "processInterrupt");
                    Unit unit = Unit.INSTANCE;
                }
            }
        });
        boolean bl5 = bl = !this.exitNow;
        if (_Assertions.ENABLED && !bl) {
            String string4 = "Assertion failed";
            throw new AssertionError((Object)string4);
        }
        this.returnNow = false;
        this.exitNow = true;
        this.offset = Integer.MAX_VALUE;
        if (debugL2) {
            Level level = Level.FINER;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"FINER");
            Object[] objectArray = new Object[]{this.debugModeString};
            Companion.log(loggerDebugL2, level, "{0}Set exitNow (processInterrupt)", objectArray);
        }
        this.startTick = -1L;
        this.setLatestResult(null);
        this.levelOneStepper.wipeRegisters();
        this.postExitContinuation((Function0<Unit>)((Function0)new Function0<Unit>((Ref.ObjectRef<List<Function1<A_Continuation, Unit>>>)waiters, this, aFiber, continuation){
            final /* synthetic */ Ref.ObjectRef<List<Function1<A_Continuation, Unit>>> $waiters;
            final /* synthetic */ Interpreter this$0;
            final /* synthetic */ A_Fiber $aFiber;
            final /* synthetic */ A_Continuation $continuation;
            {
                this.$waiters = $waiters;
                this.this$0 = $receiver;
                this.$aFiber = $aFiber;
                this.$continuation = $continuation;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                Iterable iterable = (Iterable)this.$waiters.element;
                A_Continuation a_Continuation = this.$continuation;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Function1 action2 = (Function1)element$iv;
                    boolean bl = false;
                    action2.invoke((Object)a_Continuation);
                }
                this.this$0.runtime.resumeFromInterrupt(this.$aFiber);
            }
        }));
    }

    @NotNull
    public final Primitive.Result searchForExceptionHandler(@NotNull AvailObject exceptionValue) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)exceptionValue, (String)"exceptionValue");
        boolean bl2 = bl = this.argsBuffer.size() == 1;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.argsBuffer.set(0, exceptionValue);
        AvailObject continuation = null;
        AvailObject availObject = this.getReifiedContinuation();
        Intrinsics.checkNotNull((Object)availObject);
        continuation = availObject;
        int depth = 0;
        while (continuation.getNotNil()) {
            int n;
            A_RawFunction code = continuation.function().code();
            if (Intrinsics.areEqual((Object)code.codePrimitive(), (Object)P_CatchException.INSTANCE)) {
                int n2 = n = A_RawFunction.Companion.numArgs(code) == 3 ? 1 : 0;
                if (_Assertions.ENABLED && n == 0) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
                A_Variable failureVariable = A_Continuation.Companion.frameAt(continuation, 4);
                if (A_Number.Companion.equalsInt(failureVariable.value().value(), 0)) {
                    A_Tuple handlerTuple = A_Continuation.Companion.frameAt(continuation, 2);
                    boolean bl3 = handlerTuple.isTuple();
                    if (_Assertions.ENABLED && !bl3) {
                        String string4 = "Assertion failed";
                        throw new AssertionError((Object)string4);
                    }
                    Iterable $this$forEach$iv = handlerTuple;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        AvailObject handler = (AvailObject)element$iv;
                        boolean bl4 = false;
                        if (!exceptionValue.isInstanceOf(A_Type.Companion.typeAtIndex(A_Type.Companion.getArgsTupleType(handler.kind()), 1))) continue;
                        if (debugL2) {
                            Logger logger = loggerDebugPrimitives;
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"loggerDebugPrimitives");
                            Level level = Level.FINER;
                            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"FINER");
                            Object[] objectArray = new Object[]{this.debugModeString, depth};
                            Companion.log(logger, level, "{0}Raised (->handler) at depth {1}", objectArray);
                        }
                        failureVariable.value().setValueNoCheck(AvailErrorCode.E_HANDLER_SENTINEL.numericCode());
                        this.setReifiedContinuation(continuation);
                        this.function = handler;
                        this.chunk = A_RawFunction.Companion.getStartingChunk(handler.code());
                        this.offset = 0;
                        this.levelOneStepper.wipeRegisters();
                        this.returnNow = false;
                        this.setLatestResult(null);
                        return Primitive.Result.CONTINUATION_CHANGED;
                    }
                }
            }
            A_Continuation a_Continuation = A_Continuation.Companion.caller(continuation);
            Intrinsics.checkNotNull((Object)a_Continuation, (String)"null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
            continuation = (AvailObject)a_Continuation;
            n = depth;
            depth = n + 1;
        }
        return this.primitiveFailure(exceptionValue);
    }

    @NotNull
    public final Primitive.Result markGuardVariable(@NotNull A_Variable guardVariable, @NotNull A_Number marker) {
        Intrinsics.checkNotNullParameter((Object)guardVariable, (String)"guardVariable");
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        int oldState = A_Number.Companion.getExtractInt(guardVariable.value());
        if (marker.equals(AvailErrorCode.E_HANDLER_SENTINEL.numericCode()) && oldState != 0) {
            return this.primitiveFailure(AvailErrorCode.E_CANNOT_MARK_HANDLER_FRAME);
        }
        if (marker.equals(AvailErrorCode.E_UNWIND_SENTINEL.numericCode()) && oldState != AvailErrorCode.E_HANDLER_SENTINEL.nativeCode()) {
            return this.primitiveFailure(AvailErrorCode.E_CANNOT_MARK_HANDLER_FRAME);
        }
        if (debugL2) {
            Level level = Level.FINER;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"FINER");
            Object[] objectArray = new Object[]{this.debugModeString, marker};
            Companion.log(loggerDebugL2, level, "{0}Marked guard var {1}", objectArray);
        }
        guardVariable.setValueNoCheck(marker);
        return this.primitiveSuccess(NilDescriptor.Companion.getNil());
    }

    @NotNull
    public final Primitive.Result markNearestGuard(@NotNull A_Number marker) {
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        AvailObject availObject = this.getReifiedContinuation();
        Intrinsics.checkNotNull((Object)availObject);
        A_Continuation continuation = availObject;
        int depth = 0;
        while (continuation.getNotNil()) {
            A_RawFunction code = A_Continuation.Companion.function(continuation).code();
            if (Intrinsics.areEqual((Object)code.codePrimitive(), (Object)P_CatchException.INSTANCE)) {
                boolean bl;
                boolean bl2 = bl = A_RawFunction.Companion.numArgs(code) == 3;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                A_Variable failureVariable = A_Continuation.Companion.frameAt(continuation, 4);
                A_Variable guardVariable = failureVariable.value();
                int oldState = A_Number.Companion.getExtractInt(guardVariable.value());
                if (marker.equals(AvailErrorCode.E_HANDLER_SENTINEL.numericCode()) && oldState != 0) {
                    return this.primitiveFailure(AvailErrorCode.E_CANNOT_MARK_HANDLER_FRAME);
                }
                if (marker.equals(AvailErrorCode.E_UNWIND_SENTINEL.numericCode()) && oldState != AvailErrorCode.E_HANDLER_SENTINEL.nativeCode()) {
                    return this.primitiveFailure(AvailErrorCode.E_CANNOT_MARK_HANDLER_FRAME);
                }
                guardVariable.setValueNoCheck(marker);
                if (debugL2) {
                    Level level = Level.FINER;
                    Intrinsics.checkNotNullExpressionValue((Object)level, (String)"FINER");
                    Object[] objectArray = new Object[]{this.debugModeString, marker, depth};
                    Companion.log(loggerDebugL2, level, "{0}Marked {1} at depth {2}", objectArray);
                }
                return this.primitiveSuccess(NilDescriptor.Companion.getNil());
            }
            continuation = A_Continuation.Companion.caller(continuation);
            ++depth;
        }
        return this.primitiveFailure(AvailErrorCode.E_NO_HANDLER_FRAME);
    }

    @ReferencedInGeneratedCode
    public final boolean checkValidity(int offsetInDefaultChunkIfInvalid) {
        boolean bl;
        L2Chunk l2Chunk = this.chunk;
        Intrinsics.checkNotNull((Object)l2Chunk);
        if (l2Chunk.isValid() && this.debugger == null) {
            bl = true;
        } else {
            this.chunk = L2JVMChunk.Companion.getUnoptimizedChunk();
            this.offset = offsetInDefaultChunkIfInvalid;
            bl = false;
        }
        return bl;
    }

    public final boolean isReifying() {
        return this.isReifying;
    }

    public final void setReifying(boolean bl) {
        this.isReifying = bl;
    }

    @ReferencedInGeneratedCode
    @NotNull
    public final StackReifier reifierToRestart(@NotNull A_Continuation continuation) {
        Intrinsics.checkNotNullParameter((Object)continuation, (String)"continuation");
        this.isReifying = true;
        return new StackReifier(false, L2_REIFY.StatisticCategory.ABANDON_BEFORE_RESTART_IN_L2.getStatistic(), (Function0<Unit>)((Function0)new Function0<Unit>(continuation, this){
            final /* synthetic */ A_Continuation $continuation;
            final /* synthetic */ Interpreter this$0;
            {
                this.$continuation = $continuation;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                A_Function whichFunction = A_Continuation.Companion.function(this.$continuation);
                int numArgs = A_RawFunction.Companion.numArgs(whichFunction.code());
                this.this$0.argsBuffer.clear();
                Iterable iterable = (Iterable)new IntRange(1, numArgs);
                Interpreter interpreter = this.this$0;
                A_Continuation a_Continuation = this.$continuation;
                boolean $i$f$forEach = false;
                Iterator<T> iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl = false;
                    interpreter.argsBuffer.add(A_Continuation.Companion.frameAt(a_Continuation, it));
                }
                this.this$0.setReifiedContinuation(A_Continuation.Companion.caller(this.$continuation));
                this.this$0.function = whichFunction;
                this.this$0.chunk = A_Continuation.Companion.levelTwoChunk(this.$continuation);
                this.this$0.offset = A_Continuation.Companion.levelTwoOffset(this.$continuation);
                this.this$0.returnNow = false;
                this.this$0.setLatestResult(null);
                this.this$0.setReifying(false);
            }
        }));
    }

    @ReferencedInGeneratedCode
    @NotNull
    public final StackReifier reify(boolean actuallyReify, boolean processInterrupt2, @NotNull Statistic statistic) {
        StackReifier stackReifier;
        Intrinsics.checkNotNullParameter((Object)statistic, (String)"statistic");
        if (processInterrupt2) {
            this.isReifying = true;
            stackReifier = new StackReifier(actuallyReify, statistic, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ Interpreter this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.returnNow = false;
                    this.this$0.setReifying(false);
                    AvailObject availObject = this.this$0.getReifiedContinuation();
                    Intrinsics.checkNotNull((Object)availObject);
                    this.this$0.processInterrupt(availObject);
                }
            }));
        } else {
            A_Function a_Function = this.function;
            Intrinsics.checkNotNull((Object)a_Function);
            A_Function savedFunction = a_Function;
            boolean newReturnNow = this.returnNow;
            AvailObject newReturnValue = this.latestResultOrNull();
            this.isReifying = true;
            stackReifier = new StackReifier(actuallyReify, statistic, (Function0<Unit>)((Function0)new Function0<Unit>(this, savedFunction, newReturnNow, newReturnValue){
                final /* synthetic */ Interpreter this$0;
                final /* synthetic */ A_Function $savedFunction;
                final /* synthetic */ boolean $newReturnNow;
                final /* synthetic */ AvailObject $newReturnValue;
                {
                    this.this$0 = $receiver;
                    this.$savedFunction = $savedFunction;
                    this.$newReturnNow = $newReturnNow;
                    this.$newReturnValue = $newReturnValue;
                    super(0);
                }

                public final void invoke() {
                    AvailObject availObject = this.this$0.getReifiedContinuation();
                    Intrinsics.checkNotNull((Object)availObject);
                    AvailObject continuation = availObject;
                    this.this$0.function = this.$savedFunction;
                    this.this$0.chunk = A_Continuation.Companion.levelTwoChunk(continuation);
                    this.this$0.offset = A_Continuation.Companion.levelTwoOffset(continuation);
                    this.this$0.returnNow = this.$newReturnNow;
                    this.this$0.setLatestResult(this.$newReturnValue);
                    this.this$0.setReifying(false);
                }
            }));
        }
        return stackReifier;
    }

    @ReferencedInGeneratedCode
    @NotNull
    public final StackReifier reifierToRestartWithArguments(@NotNull A_Continuation continuation, @NotNull AvailObject[] arguments) {
        Intrinsics.checkNotNullParameter((Object)continuation, (String)"continuation");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        this.isReifying = true;
        return new StackReifier(false, L2_REIFY.StatisticCategory.ABANDON_BEFORE_RESTART_IN_L2.getStatistic(), (Function0<Unit>)((Function0)new Function0<Unit>(continuation, arguments, this){
            final /* synthetic */ A_Continuation $continuation;
            final /* synthetic */ AvailObject[] $arguments;
            final /* synthetic */ Interpreter this$0;
            {
                this.$continuation = $continuation;
                this.$arguments = $arguments;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                boolean bl;
                A_Function whichFunction = A_Continuation.Companion.function(this.$continuation);
                int numArgs = A_RawFunction.Companion.numArgs(whichFunction.code());
                boolean bl2 = bl = this.$arguments.length == numArgs;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                this.this$0.argsBuffer.clear();
                CollectionsKt.addAll((Collection)this.this$0.argsBuffer, (Object[])this.$arguments);
                this.this$0.setReifiedContinuation(A_Continuation.Companion.caller(this.$continuation));
                this.this$0.function = whichFunction;
                this.this$0.chunk = A_Continuation.Companion.levelTwoChunk(this.$continuation);
                this.this$0.offset = A_Continuation.Companion.levelTwoOffset(this.$continuation);
                this.this$0.returnNow = false;
                this.this$0.setLatestResult(null);
                this.this$0.setReifying(false);
            }
        }));
    }

    @ReferencedInGeneratedCode
    @NotNull
    public final AvailObject preinvoke0(@NotNull A_Function calledFunction) {
        Intrinsics.checkNotNullParameter((Object)calledFunction, (String)"calledFunction");
        A_Function a_Function = this.function;
        Intrinsics.checkNotNull((Object)a_Function);
        AvailObject savedFunction = (AvailObject)a_Function;
        this.argsBuffer.clear();
        this.function = calledFunction;
        this.chunk = A_RawFunction.Companion.getStartingChunk(calledFunction.code());
        this.offset = 0;
        this.adjustUnreifiedCallDepthBy(1);
        return savedFunction;
    }

    @ReferencedInGeneratedCode
    @NotNull
    public final AvailObject preinvoke1(@NotNull A_Function calledFunction, @NotNull AvailObject arg1) {
        Intrinsics.checkNotNullParameter((Object)calledFunction, (String)"calledFunction");
        Intrinsics.checkNotNullParameter((Object)arg1, (String)"arg1");
        A_Function a_Function = this.function;
        Intrinsics.checkNotNull((Object)a_Function);
        AvailObject savedFunction = (AvailObject)a_Function;
        this.argsBuffer.clear();
        this.argsBuffer.add(arg1);
        this.function = calledFunction;
        this.chunk = A_RawFunction.Companion.getStartingChunk(calledFunction.code());
        this.offset = 0;
        this.adjustUnreifiedCallDepthBy(1);
        return savedFunction;
    }

    @ReferencedInGeneratedCode
    @NotNull
    public final AvailObject preinvoke2(@NotNull A_Function calledFunction, @NotNull AvailObject arg1, @NotNull AvailObject arg2) {
        Intrinsics.checkNotNullParameter((Object)calledFunction, (String)"calledFunction");
        Intrinsics.checkNotNullParameter((Object)arg1, (String)"arg1");
        Intrinsics.checkNotNullParameter((Object)arg2, (String)"arg2");
        A_Function a_Function = this.function;
        Intrinsics.checkNotNull((Object)a_Function);
        AvailObject savedFunction = (AvailObject)a_Function;
        this.argsBuffer.clear();
        this.argsBuffer.add(arg1);
        this.argsBuffer.add(arg2);
        this.function = calledFunction;
        this.chunk = A_RawFunction.Companion.getStartingChunk(calledFunction.code());
        this.offset = 0;
        this.adjustUnreifiedCallDepthBy(1);
        return savedFunction;
    }

    @ReferencedInGeneratedCode
    @NotNull
    public final AvailObject preinvoke3(@NotNull A_Function calledFunction, @NotNull AvailObject arg1, @NotNull AvailObject arg2, @NotNull AvailObject arg3) {
        Intrinsics.checkNotNullParameter((Object)calledFunction, (String)"calledFunction");
        Intrinsics.checkNotNullParameter((Object)arg1, (String)"arg1");
        Intrinsics.checkNotNullParameter((Object)arg2, (String)"arg2");
        Intrinsics.checkNotNullParameter((Object)arg3, (String)"arg3");
        A_Function a_Function = this.function;
        Intrinsics.checkNotNull((Object)a_Function);
        AvailObject savedFunction = (AvailObject)a_Function;
        this.argsBuffer.clear();
        this.argsBuffer.add(arg1);
        this.argsBuffer.add(arg2);
        this.argsBuffer.add(arg3);
        this.function = calledFunction;
        this.chunk = A_RawFunction.Companion.getStartingChunk(calledFunction.code());
        this.offset = 0;
        this.adjustUnreifiedCallDepthBy(1);
        return savedFunction;
    }

    @ReferencedInGeneratedCode
    @NotNull
    public final AvailObject preinvoke(@NotNull A_Function calledFunction, @NotNull AvailObject[] args) {
        Intrinsics.checkNotNullParameter((Object)calledFunction, (String)"calledFunction");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        A_Function a_Function = this.function;
        Intrinsics.checkNotNull((Object)a_Function);
        AvailObject savedFunction = (AvailObject)a_Function;
        this.argsBuffer.clear();
        CollectionsKt.addAll((Collection)this.argsBuffer, (Object[])args);
        this.function = calledFunction;
        this.chunk = A_RawFunction.Companion.getStartingChunk(calledFunction.code());
        this.offset = 0;
        this.adjustUnreifiedCallDepthBy(1);
        return savedFunction;
    }

    @ReferencedInGeneratedCode
    @Nullable
    public final StackReifier postinvoke(@NotNull L2Chunk callingChunk, @NotNull A_Function callingFunction, @Nullable StackReifier reifier) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)callingChunk, (String)"callingChunk");
        Intrinsics.checkNotNullParameter((Object)callingFunction, (String)"callingFunction");
        this.chunk = callingChunk;
        this.function = callingFunction;
        this.returnNow = false;
        boolean bl2 = bl = !this.exitNow;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.adjustUnreifiedCallDepthBy(-1);
        return reifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final StackReifier invokeFunction(@NotNull A_Function aFunction) {
        StackReifier stackReifier;
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)aFunction, (String)"aFunction");
        boolean bl3 = bl2 = !this.exitNow;
        if (_Assertions.ENABLED && !bl2) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.function = aFunction;
        A_RawFunction code = aFunction.code();
        boolean bl4 = bl = A_RawFunction.Companion.numArgs(code) == this.argsBuffer.size();
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        L2Chunk l2Chunk = this.chunk = A_RawFunction.Companion.getStartingChunk(code);
        Intrinsics.checkNotNull((Object)l2Chunk);
        bl = l2Chunk.isValid();
        if (_Assertions.ENABLED && !bl) {
            String string4 = "Assertion failed";
            throw new AssertionError((Object)string4);
        }
        this.offset = 0;
        this.returnNow = false;
        this.adjustUnreifiedCallDepthBy(1);
        try {
            stackReifier = this.runChunk();
        }
        finally {
            this.adjustUnreifiedCallDepthBy(-1);
        }
        return stackReifier;
    }

    public final void run() {
        boolean bl;
        boolean bl2 = bl = this.unreifiedCallDepth() == 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean bl3 = bl = this.fiber != null;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        boolean bl4 = bl = !this.exitNow;
        if (_Assertions.ENABLED && !bl) {
            String string4 = "Assertion failed";
            throw new AssertionError((Object)string4);
        }
        boolean bl5 = bl = !this.returnNow;
        if (_Assertions.ENABLED && !bl) {
            String string5 = "Assertion failed";
            throw new AssertionError((Object)string5);
        }
        this.nanosToExclude = 0L;
        this.startTick = this.runtime.getClock().get();
        if (debugL2) {
            this.debugModeString = "";
            Logger logger = loggerDebugPrimitives;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"loggerDebugPrimitives");
            Level level = Level.FINER;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"FINER");
            Object[] objectArray = new Object[2];
            objectArray[0] = this.debugModeString;
            A_Fiber a_Fiber = this.fiber;
            Intrinsics.checkNotNull((Object)a_Fiber);
            objectArray[1] = A_Fiber.Companion.getFiberName(a_Fiber);
            Companion.log(logger, level, "\n{0}Run: ({1})", objectArray);
        }
        while (true) {
            A_Continuation frame;
            A_Function calledFunction;
            boolean bl6;
            Intrinsics.checkNotNull((Object)this.function);
            StackReifier reifier = this.runChunk();
            boolean bl7 = bl6 = this.unreifiedCallDepth() == 0;
            if (_Assertions.ENABLED && !bl6) {
                String string6 = "Assertion failed";
                throw new AssertionError((Object)string6);
            }
            this.returningFunction = calledFunction;
            if (reifier != null) {
                if (reifier.actuallyReify()) {
                    reifier.runActions(this);
                }
                reifier.recordCompletedReification(this.interpreterIndex);
                this.chunk = null;
                reifier.getPostReificationAction().invoke();
                if (this.exitNow) {
                    boolean bl8 = bl6 = this.fiber == null;
                    if (_Assertions.ENABLED && !bl6) {
                        String string7 = "Assertion failed";
                        throw new AssertionError((Object)string7);
                    }
                    if (debugL2) {
                        Level level = Level.FINER;
                        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"FINER");
                        Object[] objectArray = new Object[]{this.debugModeString};
                        Companion.log(loggerDebugL2, level, "{0}Exit1 run\n", objectArray);
                    }
                    return;
                }
                if (!this.returnNow) continue;
            }
            bl6 = this.returnNow;
            if (_Assertions.ENABLED && !bl6) {
                String string8 = "Assertion failed";
                throw new AssertionError((Object)string8);
            }
            boolean bl9 = bl6 = this.latestResult != null;
            if (_Assertions.ENABLED && !bl6) {
                String string9 = "Assertion failed";
                throw new AssertionError((Object)string9);
            }
            this.returnNow = false;
            AvailObject availObject = this.getReifiedContinuation();
            Intrinsics.checkNotNull((Object)availObject);
            if (availObject.isNil()) {
                this.terminateFiber(this.getLatestResult());
                this.exitNow = true;
                if (debugL2) {
                    Level level = Level.FINER;
                    Intrinsics.checkNotNullExpressionValue((Object)level, (String)"FINER");
                    Object[] objectArray = new Object[]{this.debugModeString};
                    Companion.log(loggerDebugL2, level, "{0}Exit2 run and set exitNow (fall off Interpreter.run)\n", objectArray);
                }
                return;
            }
            A_Continuation a_Continuation = frame = (A_Continuation)this.getReifiedContinuation();
            Intrinsics.checkNotNull((Object)a_Continuation);
            this.function = A_Continuation.Companion.function(a_Continuation);
            this.chunk = A_Continuation.Companion.levelTwoChunk(frame);
            this.offset = A_Continuation.Companion.levelTwoOffset(frame);
        }
    }

    @ReferencedInGeneratedCode
    @Nullable
    public final StackReifier runChunk() {
        boolean bl;
        boolean bl2 = bl = !this.exitNow;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        while (!this.returnNow && !this.exitNow) {
            StackReifier reifier;
            L2Chunk currentChunk;
            Intrinsics.checkNotNull((Object)this.chunk);
            currentChunk.beforeRunChunk(this.offset);
            StackReifier stackReifier = reifier = currentChunk.getExecutableChunk().runChunk(this, this.offset);
            if (stackReifier == null) continue;
            return stackReifier;
        }
        return null;
    }

    @NotNull
    public final String nameForDebugger() {
        return this.toString();
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u2d5 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u2d5.append(this.getClass().getSimpleName());
        $this$toString_u24lambda_u2d5.append(" #" + this.interpreterIndex);
        if (this.fiber == null) {
            $this$toString_u24lambda_u2d5.append(" [\u00abunbound\u00bb]");
        } else {
            Object[] objectArray = new Object[1];
            A_Fiber a_Fiber = this.fiber;
            Intrinsics.checkNotNull((Object)a_Fiber);
            objectArray[0] = A_Fiber.Companion.getFiberName(a_Fiber);
            $this$toString_u24lambda_u2d5.append(StringDescriptor.Companion.formatString(" [%s]", objectArray));
            if (this.getReifiedContinuation() == null) {
                $this$toString_u24lambda_u2d5.append(StringDescriptor.Companion.formatString("%n\t\u00abnull stack\u00bb", new Object[0]));
            } else {
                AvailObject availObject = this.getReifiedContinuation();
                Intrinsics.checkNotNull((Object)availObject);
                if (availObject.isNil()) {
                    $this$toString_u24lambda_u2d5.append(StringDescriptor.Companion.formatString("%n\t\u00abempty call stack\u00bb", new Object[0]));
                }
            }
            $this$toString_u24lambda_u2d5.append("\n\n");
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @ReferencedInGeneratedCode
    @NotNull
    public final StackReifier reportWrongReturnType(@NotNull A_BasicObject returnedValueOrNil, @NotNull A_Type expectedReturnType, int pc, int stackp, A_BasicObject ... slots) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)returnedValueOrNil, (String)"returnedValueOrNil");
        Intrinsics.checkNotNullParameter((Object)expectedReturnType, (String)"expectedReturnType");
        Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
        A_Function a_Function = this.returningFunction;
        Intrinsics.checkNotNull((Object)a_Function);
        A_Function returner = a_Function;
        A_Function a_Function2 = this.function;
        Intrinsics.checkNotNull((Object)a_Function2);
        A_Function caller = a_Function2;
        AvailObject wrappedReturnValue = VariableDescriptor.Companion.newVariableWithContentType$default(VariableDescriptor.Companion, PrimitiveTypeDescriptor.Types.ANY.getO(), null, 2, null);
        if (returnedValueOrNil.getNotNil()) {
            wrappedReturnValue.setValueNoCheck(returnedValueOrNil);
        }
        this.argsBuffer.clear();
        this.argsBuffer.add((AvailObject)returner);
        this.argsBuffer.add((AvailObject)expectedReturnType);
        this.argsBuffer.add(wrappedReturnValue);
        StackReifier reifier = this.invokeFunction(this.runtime.resultDisagreedWithExpectedTypeFunction());
        boolean bl2 = bl = reifier != null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "return type handler must not return.";
            throw new AssertionError((Object)string2);
        }
        StackReifier stackReifier = reifier;
        Intrinsics.checkNotNull((Object)stackReifier);
        stackReifier.pushAction((Function1<? super Interpreter, Unit>)((Function1)new Function1<Interpreter, Unit>(caller, pc, stackp, slots){
            final /* synthetic */ A_Function $caller;
            final /* synthetic */ int $pc;
            final /* synthetic */ int $stackp;
            final /* synthetic */ A_BasicObject[] $slots;
            {
                this.$caller = $caller;
                this.$pc = $pc;
                this.$stackp = $stackp;
                this.$slots = $slots;
                super(1);
            }

            public final void invoke(@NotNull Interpreter it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AvailObject availObject = it.getReifiedContinuation();
                if (availObject == null) {
                    availObject = NilDescriptor.Companion.getNil();
                }
                AvailObject continuation = ContinuationDescriptor.Companion.createContinuationWithFrame(this.$caller, availObject, ContinuationRegisterDumpDescriptor.Companion.createRegisterDump(JVMChunk.noObjects, JVMChunk.noLongs), this.$pc, this.$stackp, L2JVMChunk.Companion.getUnoptimizedChunk(), L2JVMChunk.ChunkEntryPoint.UNREACHABLE.getOffsetInDefaultChunk(), CollectionsKt.listOf((Object[])Arrays.copyOf(this.$slots, this.$slots.length)), 0);
                it.setReifiedContinuation(continuation);
            }
        }));
        return reifier;
    }

    @ReferencedInGeneratedCode
    @NotNull
    public final StackReifier reportUnassignedVariableRead(int pc, int stackp, A_BasicObject ... slots) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
        A_Function a_Function = this.function;
        Intrinsics.checkNotNull((Object)a_Function);
        A_Function currentFunction = a_Function;
        this.argsBuffer.clear();
        StackReifier reifier = this.invokeFunction(this.runtime.unassignedVariableReadFunction());
        boolean bl2 = bl = reifier != null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "unassigned-variable-read handler must not return.";
            throw new AssertionError((Object)string2);
        }
        StackReifier stackReifier = reifier;
        Intrinsics.checkNotNull((Object)stackReifier);
        stackReifier.pushAction((Function1<? super Interpreter, Unit>)((Function1)new Function1<Interpreter, Unit>(currentFunction, pc, stackp, slots){
            final /* synthetic */ A_Function $currentFunction;
            final /* synthetic */ int $pc;
            final /* synthetic */ int $stackp;
            final /* synthetic */ A_BasicObject[] $slots;
            {
                this.$currentFunction = $currentFunction;
                this.$pc = $pc;
                this.$stackp = $stackp;
                this.$slots = $slots;
                super(1);
            }

            public final void invoke(@NotNull Interpreter it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AvailObject availObject = it.getReifiedContinuation();
                if (availObject == null) {
                    availObject = NilDescriptor.Companion.getNil();
                }
                AvailObject continuation = ContinuationDescriptor.Companion.createContinuationWithFrame(this.$currentFunction, availObject, ContinuationRegisterDumpDescriptor.Companion.createRegisterDump(JVMChunk.noObjects, JVMChunk.noLongs), this.$pc, this.$stackp, L2JVMChunk.Companion.getUnoptimizedChunk(), L2JVMChunk.ChunkEntryPoint.UNREACHABLE.getOffsetInDefaultChunk(), CollectionsKt.listOf((Object[])Arrays.copyOf(this.$slots, this.$slots.length)), 0);
                it.setReifiedContinuation(continuation);
            }
        }));
        return reifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void recordTopStatementEvaluation(double sample, @NotNull A_Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Statistic statistic = null;
        Map<A_String, Statistic> map = topStatementEvaluationStats;
        synchronized (map) {
            boolean bl = false;
            Statistic statistic2 = topStatementEvaluationStats.computeIfAbsent(A_Module.Companion.getModuleName(module), Interpreter::recordTopStatementEvaluation$lambda-9$lambda-8);
            Intrinsics.checkNotNullExpressionValue((Object)statistic2, (String)"topStatementEvaluationSt\u2026it.asNativeString())\n\t\t\t}");
            statistic = statistic2;
            Unit unit = Unit.INSTANCE;
        }
        statistic.record(sample, this.interpreterIndex);
    }

    @NotNull
    public final Map<List<Integer>, Integer[]> getArraysForL2Simple() {
        return this.arraysForL2Simple;
    }

    private static final Statistic recordTopStatementEvaluation$lambda-9$lambda-8(A_String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new Statistic(StatisticReport.TOP_LEVEL_STATEMENTS, it.asNativeString());
    }

    @ReferencedInGeneratedCode
    @JvmStatic
    public static final void traceL2(@NotNull ExecutableChunk executableChunk, int offset, @NotNull String description, @NotNull Object firstReadOperandValue) {
        Companion.traceL2(executableChunk, offset, description, firstReadOperandValue);
    }

    static {
        mainLogger = Logger.getLogger(Interpreter.class.getCanonicalName());
        Logger logger = Logger.getLogger(Interpreter.class.getCanonicalName() + ".debugL1");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(\n\t\t\tInterprete\u2026nonicalName + \".debugL1\")");
        loggerDebugL1 = logger;
        Logger logger2 = Logger.getLogger(Interpreter.class.getCanonicalName() + ".debugL2");
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(\n\t\t\tInterprete\u2026nonicalName + \".debugL2\")");
        loggerDebugL2 = logger2;
        Logger logger3 = Logger.getLogger(Interpreter.class.getCanonicalName() + ".debugJVM");
        Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getLogger(\n\t\t\tInterprete\u2026onicalName + \".debugJVM\")");
        loggerDebugJVM = logger3;
        loggerDebugPrimitives = Logger.getLogger(Interpreter.class.getCanonicalName() + ".debugPrimitives");
        Class<Void> clazz = Void.TYPE;
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"TYPE");
        Class[] classArray = new Class[4];
        classArray[0] = ExecutableChunk.class;
        Intrinsics.checkNotNull(Integer.TYPE);
        classArray[2] = String.class;
        classArray[3] = Object.class;
        traceL2Method = CheckedMethod.Companion.staticMethod(Interpreter.class, "traceL2", clazz, classArray);
        Class<Boolean> clazz2 = Boolean.TYPE;
        Intrinsics.checkNotNull(clazz2);
        callerIsReifiedMethod = CheckedMethod.Companion.instanceMethod(Interpreter.class, "callerIsReified", clazz2, new Class[0]);
        runtimeField = CheckedField.Companion.instanceField(Interpreter.class, "runtime", AvailRuntime.class);
        Class<Void> clazz3 = Void.TYPE;
        Intrinsics.checkNotNullExpressionValue(clazz3, (String)"TYPE");
        classArray = new Class[]{A_BasicObject.class};
        setLatestResultMethod = CheckedMethod.Companion.instanceMethod(Interpreter.class, "setLatestResult", clazz3, classArray);
        getLatestResultMethod = CheckedMethod.Companion.instanceMethod(Interpreter.class, "getLatestResult", AvailObject.class, new Class[0]);
        interpreterReturningFunctionField = CheckedField.Companion.instanceField(Interpreter.class, "returningFunction", A_Function.class);
        Class<Boolean> clazz4 = Boolean.TYPE;
        Intrinsics.checkNotNull(clazz4);
        returnNowField = CheckedField.Companion.instanceField(Interpreter.class, "returnNow", clazz4);
        Class<Long> clazz5 = Long.TYPE;
        Intrinsics.checkNotNull(clazz5);
        classArray = new Class[]{Primitive.class};
        beforeAttemptPrimitiveMethod = CheckedMethod.Companion.instanceMethod(Interpreter.class, "beforeAttemptPrimitive", clazz5, classArray);
        classArray = new Class[3];
        classArray[0] = Primitive.class;
        Intrinsics.checkNotNull(Long.TYPE);
        classArray[2] = Primitive.Result.class;
        afterAttemptPrimitiveMethod = CheckedMethod.Companion.instanceMethod(Interpreter.class, "afterAttemptPrimitive", Primitive.Result.class, classArray);
        getReifiedContinuationMethod = CheckedMethod.Companion.instanceMethod(Interpreter.class, "getReifiedContinuation", AvailObject.class, new Class[0]);
        Class<Void> clazz6 = Void.TYPE;
        Intrinsics.checkNotNullExpressionValue(clazz6, (String)"TYPE");
        classArray = new Class[]{A_Continuation.class};
        setReifiedContinuationMethod = CheckedMethod.Companion.instanceMethod(Interpreter.class, "setReifiedContinuation", clazz6, classArray);
        Class<Void> clazz7 = Void.TYPE;
        Intrinsics.checkNotNullExpressionValue(clazz7, (String)"TYPE");
        popContinuationMethod = CheckedMethod.Companion.instanceMethod(Interpreter.class, "popContinuation", clazz7, new Class[0]);
        interpreterFunctionField = CheckedField.Companion.instanceField(Interpreter.class, "function", A_Function.class);
        chunkField = CheckedField.Companion.instanceField(Interpreter.class, "chunk", L2Chunk.class);
        Class<Integer> clazz8 = Integer.TYPE;
        Intrinsics.checkNotNull(clazz8);
        offsetField = CheckedField.Companion.instanceField(Interpreter.class, "offset", clazz8);
        argsBufferField = CheckedField.Companion.instanceField(Interpreter.class, "argsBuffer", List.class);
        levelOneStepperField = CheckedField.Companion.instanceField(Interpreter.class, "levelOneStepper", L1InstructionStepper.class);
        Class<Boolean> clazz9 = Boolean.TYPE;
        Intrinsics.checkNotNull(clazz9);
        isInterruptRequestedMethod = CheckedMethod.Companion.instanceMethod(Interpreter.class, "isInterruptRequested", clazz9, new Class[0]);
        Class<Boolean> clazz10 = Boolean.TYPE;
        Intrinsics.checkNotNull(clazz10);
        classArray = new Class[1];
        Intrinsics.checkNotNull(Integer.TYPE);
        checkValidityMethod = CheckedMethod.Companion.instanceMethod(Interpreter.class, "checkValidity", clazz10, classArray);
        classArray = new Class[]{A_Continuation.class};
        reifierToRestartMethod = CheckedMethod.Companion.instanceMethod(Interpreter.class, "reifierToRestart", StackReifier.class, classArray);
        classArray = new Class[3];
        Intrinsics.checkNotNull(Boolean.TYPE);
        Intrinsics.checkNotNull(Boolean.TYPE);
        classArray[2] = Statistic.class;
        reifyMethod = CheckedMethod.Companion.instanceMethod(Interpreter.class, "reify", StackReifier.class, classArray);
        classArray = new Class[]{A_Continuation.class, AvailObject[].class};
        reifierToRestartWithArgumentsMethod = CheckedMethod.Companion.instanceMethod(Interpreter.class, "reifierToRestartWithArguments", StackReifier.class, classArray);
        classArray = new Class[]{A_Function.class};
        preinvoke0Method = CheckedMethod.Companion.instanceMethod(Interpreter.class, "preinvoke0", AvailObject.class, classArray);
        classArray = new Class[]{A_Function.class, AvailObject.class};
        preinvoke1Method = CheckedMethod.Companion.instanceMethod(Interpreter.class, "preinvoke1", AvailObject.class, classArray);
        classArray = new Class[]{A_Function.class, AvailObject.class, AvailObject.class};
        preinvoke2Method = CheckedMethod.Companion.instanceMethod(Interpreter.class, "preinvoke2", AvailObject.class, classArray);
        classArray = new Class[]{A_Function.class, AvailObject.class, AvailObject.class, AvailObject.class};
        preinvoke3Method = CheckedMethod.Companion.instanceMethod(Interpreter.class, "preinvoke3", AvailObject.class, classArray);
        classArray = new Class[]{A_Function.class, AvailObject[].class};
        preinvokeMethod = CheckedMethod.Companion.instanceMethod(Interpreter.class, "preinvoke", AvailObject.class, classArray);
        classArray = new Class[]{L2Chunk.class, A_Function.class, StackReifier.class};
        postinvokeMethod = CheckedMethod.Companion.instanceMethod(Interpreter.class, "postinvoke", StackReifier.class, classArray);
        interpreterRunChunkMethod = CheckedMethod.Companion.instanceMethod(Interpreter.class, "runChunk", StackReifier.class, new Class[0]);
        classArray = new Class[]{A_Function.class, Primitive.class};
        attemptThePrimitiveMethod = CheckedMethod.Companion.instanceMethod(Interpreter.class, "attemptThePrimitive", StackReifier.class, classArray);
        classArray = new Class[]{A_Function.class, Primitive.class};
        attemptTheInlinePrimitiveMethod = CheckedMethod.Companion.instanceMethod(Interpreter.class, "attemptInlinePrimitive", StackReifier.class, classArray);
        classArray = new Class[]{A_Function.class, Primitive.class};
        attemptTheNonInlinePrimitiveMethod = CheckedMethod.Companion.instanceMethod(Interpreter.class, "attemptNonInlinePrimitive", StackReifier.class, classArray);
        classArray = new Class[5];
        classArray[0] = A_BasicObject.class;
        classArray[1] = A_Type.class;
        Intrinsics.checkNotNull(Integer.TYPE);
        Intrinsics.checkNotNull(Integer.TYPE);
        classArray[4] = A_BasicObject[].class;
        reportWrongReturnTypeMethod = CheckedMethod.Companion.instanceMethod(Interpreter.class, "reportWrongReturnType", StackReifier.class, classArray);
        classArray = new Class[3];
        Intrinsics.checkNotNull(Integer.TYPE);
        Intrinsics.checkNotNull(Integer.TYPE);
        classArray[2] = A_BasicObject[].class;
        reportUnassignedVariableReadMethod = CheckedMethod.Companion.instanceMethod(Interpreter.class, "reportUnassignedVariableRead", StackReifier.class, classArray);
        topStatementEvaluationStats = new LinkedHashMap();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B-\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u0013\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000fR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lavail/interpreter/execution/Interpreter$SuspensionHelper;", "A", "", "toSucceed", "Lkotlin/Function1;", "", "toFail", "Lavail/descriptor/representation/A_BasicObject;", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "fail", "errorNumber", "errorCode", "Lavail/exceptions/AvailErrorCode;", "succeed", "value", "(Ljava/lang/Object;)V", "avail"})
    public static final class SuspensionHelper<A> {
        @NotNull
        private final Function1<A, Unit> toSucceed;
        @NotNull
        private final Function1<A_BasicObject, Unit> toFail;

        public SuspensionHelper(@NotNull Function1<? super A, Unit> toSucceed, @NotNull Function1<? super A_BasicObject, Unit> toFail) {
            Intrinsics.checkNotNullParameter(toSucceed, (String)"toSucceed");
            Intrinsics.checkNotNullParameter(toFail, (String)"toFail");
            this.toSucceed = toSucceed;
            this.toFail = toFail;
        }

        public final void succeed(A value) {
            this.toSucceed.invoke(value);
        }

        public final void fail(@NotNull A_BasicObject errorNumber) {
            Intrinsics.checkNotNullParameter((Object)errorNumber, (String)"errorNumber");
            this.toFail.invoke((Object)errorNumber);
        }

        public final void fail(@NotNull AvailErrorCode errorCode) {
            Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
            this.toFail.invoke((Object)errorCode.numericCode());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b$\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b/\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0084\u0001\u001a\u00030\u0085\u0001J\b\u0010\u0086\u0001\u001a\u00030\u0087\u0001J\u0007\u0010\u0088\u0001\u001a\u00020OJ\n\u0010\u0089\u0001\u001a\u0005\u0018\u00010\u0087\u0001JS\u0010\u008a\u0001\u001a\u00030\u008b\u00012\n\u0010\u008c\u0001\u001a\u0005\u0018\u00010\u008d\u00012\u0007\u0010\u008e\u0001\u001a\u00020D2\n\u0010\u008f\u0001\u001a\u0005\u0018\u00010\u0090\u00012\b\u0010\u0091\u0001\u001a\u00030\u0092\u00012\u0018\u0010\u0093\u0001\u001a\r\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0094\u0001\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0003\u0010\u0095\u0001JE\u0010\u008a\u0001\u001a\u00030\u008b\u00012\u0007\u0010\u008e\u0001\u001a\u00020D2\b\u0010\u008f\u0001\u001a\u00030\u0090\u00012\b\u0010\u0091\u0001\u001a\u00030\u0092\u00012\u0018\u0010\u0093\u0001\u001a\r\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0094\u0001\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0003\u0010\u0096\u0001J\u0012\u0010\u0097\u0001\u001a\u00030\u008b\u00012\b\u0010\u008f\u0001\u001a\u00030\u0090\u0001J0\u0010\u0098\u0001\u001a\u00030\u008b\u00012\b\u0010\u0099\u0001\u001a\u00030\u009a\u00012\u0007\u0010\u009b\u0001\u001a\u00020O2\b\u0010\u009c\u0001\u001a\u00030\u0092\u00012\u0007\u0010\u009d\u0001\u001a\u00020\u0001H\u0007R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u001a\u0010\u0013\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0006\"\u0004\b\u0015\u0010\bR\u0011\u0010\u0016\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0006R\u0011\u0010\u0018\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0006R\u001a\u0010\u001a\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\f\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010!\"\u0004\b&\u0010#R\u000e\u0010'\u001a\u00020\u001fX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010(\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010!\"\u0004\b*\u0010#R\u001a\u0010+\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010!\"\u0004\b-\u0010#R\u001a\u0010.\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010!\"\u0004\b0\u0010#R\u001a\u00101\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010!\"\u0004\b3\u0010#R\u001a\u00104\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u0006\"\u0004\b6\u0010\bR\u0011\u00107\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\u0006R\u0011\u00109\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010\fR\u0011\u0010;\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010\fR\u001a\u0010=\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010\u0006\"\u0004\b?\u0010\bR\u0011\u0010@\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010\u0006R\u0011\u0010A\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010\fR\u0011\u0010C\u001a\u00020D\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010FR\u0011\u0010G\u001a\u00020D\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010FR\u0011\u0010I\u001a\u00020D\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010FR\u0016\u0010K\u001a\n L*\u0004\u0018\u00010D0DX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010M\u001a\n L*\u0004\u0018\u00010D0DX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010N\u001a\u00020OX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010P\u001a\u00020OX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010Q\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010\fR\u001a\u0010S\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010\u0006\"\u0004\bU\u0010\bR\u001a\u0010V\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bW\u0010\u0006\"\u0004\bX\u0010\bR\u001a\u0010Y\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bZ\u0010\u0006\"\u0004\b[\u0010\bR\u001a\u0010\\\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b]\u0010\u0006\"\u0004\b^\u0010\bR\u001a\u0010_\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b`\u0010\u0006\"\u0004\ba\u0010\bR\u001a\u0010b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bc\u0010\u0006\"\u0004\bd\u0010\bR\u001a\u0010e\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bf\u0010\u0006\"\u0004\bg\u0010\bR\u0011\u0010h\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bi\u0010\u0006R\u0011\u0010j\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bk\u0010\u0006R\u0011\u0010l\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bm\u0010\u0006R\u001a\u0010n\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bo\u0010\u0006\"\u0004\bp\u0010\bR\u001a\u0010q\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\br\u0010\u0006\"\u0004\bs\u0010\bR\u0011\u0010t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\bu\u0010\fR\u0011\u0010v\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\bw\u0010\fR\u001a\u0010x\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\by\u0010\u0006\"\u0004\bz\u0010\bR\u0011\u0010{\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b|\u0010\u0006R\u000e\u0010}\u001a\u00020OX\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010~\u001a\u0010\u0012\u0005\u0012\u00030\u0080\u0001\u0012\u0005\u0012\u00030\u0081\u00010\u007fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0082\u0001\u001a\u00020\u0004\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0083\u0001\u0010\u0006\u00a8\u0006\u009e\u0001"}, d2={"Lavail/interpreter/execution/Interpreter$Companion;", "", "()V", "afterAttemptPrimitiveMethod", "Lavail/optimizer/jvm/CheckedMethod;", "getAfterAttemptPrimitiveMethod", "()Lavail/optimizer/jvm/CheckedMethod;", "setAfterAttemptPrimitiveMethod", "(Lavail/optimizer/jvm/CheckedMethod;)V", "argsBufferField", "Lavail/optimizer/jvm/CheckedField;", "getArgsBufferField", "()Lavail/optimizer/jvm/CheckedField;", "attemptTheInlinePrimitiveMethod", "getAttemptTheInlinePrimitiveMethod", "attemptTheNonInlinePrimitiveMethod", "getAttemptTheNonInlinePrimitiveMethod", "attemptThePrimitiveMethod", "getAttemptThePrimitiveMethod", "beforeAttemptPrimitiveMethod", "getBeforeAttemptPrimitiveMethod", "setBeforeAttemptPrimitiveMethod", "callerIsReifiedMethod", "getCallerIsReifiedMethod", "checkValidityMethod", "getCheckValidityMethod", "chunkField", "getChunkField", "setChunkField", "(Lavail/optimizer/jvm/CheckedField;)V", "debugCheckAfterUnload", "", "getDebugCheckAfterUnload", "()Z", "setDebugCheckAfterUnload", "(Z)V", "debugCustom", "getDebugCustom", "setDebugCustom", "debugIntoFiberDebugLog", "debugL1", "getDebugL1", "setDebugL1", "debugL2", "getDebugL2", "setDebugL2", "debugPrimitives", "getDebugPrimitives", "setDebugPrimitives", "debugWorkUnits", "getDebugWorkUnits", "setDebugWorkUnits", "getLatestResultMethod", "getGetLatestResultMethod", "setGetLatestResultMethod", "getReifiedContinuationMethod", "getGetReifiedContinuationMethod", "interpreterFunctionField", "getInterpreterFunctionField", "interpreterReturningFunctionField", "getInterpreterReturningFunctionField", "interpreterRunChunkMethod", "getInterpreterRunChunkMethod", "setInterpreterRunChunkMethod", "isInterruptRequestedMethod", "levelOneStepperField", "getLevelOneStepperField", "loggerDebugJVM", "Ljava/util/logging/Logger;", "getLoggerDebugJVM", "()Ljava/util/logging/Logger;", "loggerDebugL1", "getLoggerDebugL1", "loggerDebugL2", "getLoggerDebugL2", "loggerDebugPrimitives", "kotlin.jvm.PlatformType", "mainLogger", "maxFiberLogLength", "", "maxUnreifiedCallDepth", "offsetField", "getOffsetField", "popContinuationMethod", "getPopContinuationMethod", "setPopContinuationMethod", "postinvokeMethod", "getPostinvokeMethod", "setPostinvokeMethod", "preinvoke0Method", "getPreinvoke0Method", "setPreinvoke0Method", "preinvoke1Method", "getPreinvoke1Method", "setPreinvoke1Method", "preinvoke2Method", "getPreinvoke2Method", "setPreinvoke2Method", "preinvoke3Method", "getPreinvoke3Method", "setPreinvoke3Method", "preinvokeMethod", "getPreinvokeMethod", "setPreinvokeMethod", "reifierToRestartMethod", "getReifierToRestartMethod", "reifierToRestartWithArgumentsMethod", "getReifierToRestartWithArgumentsMethod", "reifyMethod", "getReifyMethod", "reportUnassignedVariableReadMethod", "getReportUnassignedVariableReadMethod", "setReportUnassignedVariableReadMethod", "reportWrongReturnTypeMethod", "getReportWrongReturnTypeMethod", "setReportWrongReturnTypeMethod", "returnNowField", "getReturnNowField", "runtimeField", "getRuntimeField", "setLatestResultMethod", "getSetLatestResultMethod", "setSetLatestResultMethod", "setReifiedContinuationMethod", "getSetReifiedContinuationMethod", "timeSliceTicks", "topStatementEvaluationStats", "", "Lavail/descriptor/tuples/A_String;", "Lavail/performance/Statistic;", "traceL2Method", "getTraceL2Method", "assignmentFunction", "Lavail/descriptor/functions/A_Function;", "current", "Lavail/interpreter/execution/Interpreter;", "currentIndexOrZero", "currentOrNull", "log", "", "affectedFiber", "Lavail/descriptor/fiber/A_Fiber;", "logger", "level", "Ljava/util/logging/Level;", "message", "", "arguments", "", "(Lavail/descriptor/fiber/A_Fiber;Ljava/util/logging/Logger;Ljava/util/logging/Level;Ljava/lang/String;[Ljava/lang/Object;)V", "(Ljava/util/logging/Logger;Ljava/util/logging/Level;Ljava/lang/String;[Ljava/lang/Object;)V", "setLoggerLevel", "traceL2", "executableChunk", "Lavail/optimizer/ExecutableChunk;", "offset", "description", "firstReadOperandValue", "avail"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getDebugL1() {
            return debugL1;
        }

        public final void setDebugL1(boolean bl) {
            debugL1 = bl;
        }

        public final boolean getDebugL2() {
            return debugL2;
        }

        public final void setDebugL2(boolean bl) {
            debugL2 = bl;
        }

        public final boolean getDebugPrimitives() {
            return debugPrimitives;
        }

        public final void setDebugPrimitives(boolean bl) {
            debugPrimitives = bl;
        }

        public final boolean getDebugWorkUnits() {
            return debugWorkUnits;
        }

        public final void setDebugWorkUnits(boolean bl) {
            debugWorkUnits = bl;
        }

        public final boolean getDebugCustom() {
            return debugCustom;
        }

        public final void setDebugCustom(boolean bl) {
            debugCustom = bl;
        }

        public final boolean getDebugCheckAfterUnload() {
            return debugCheckAfterUnload;
        }

        public final void setDebugCheckAfterUnload(boolean bl) {
            debugCheckAfterUnload = bl;
        }

        @NotNull
        public final Logger getLoggerDebugL1() {
            return loggerDebugL1;
        }

        @NotNull
        public final Logger getLoggerDebugL2() {
            return loggerDebugL2;
        }

        @NotNull
        public final Logger getLoggerDebugJVM() {
            return loggerDebugJVM;
        }

        public final void setLoggerLevel(@NotNull Level level) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            mainLogger.setLevel(level);
            this.getLoggerDebugL1().setLevel(level);
            this.getLoggerDebugL2().setLevel(level);
            this.getLoggerDebugJVM().setLevel(level);
            loggerDebugPrimitives.setLevel(level);
        }

        public final void log(@NotNull Logger logger, @NotNull Level level, @NotNull String message, Object ... arguments) {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            if (logger.isLoggable(level)) {
                this.log(AvailThread.Companion.currentOrNull() != null ? this.current().fiber : null, logger, level, message, Arrays.copyOf(arguments, arguments.length));
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void log(@Nullable A_Fiber affectedFiber, @NotNull Logger logger, @Nullable Level level, @NotNull String message, Object ... arguments) {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            if (logger.isLoggable(level)) {
                Interpreter interpreter;
                Interpreter interpreter2 = interpreter = this.currentOrNull();
                A_Fiber runningFiber = interpreter2 != null ? interpreter2.fiberOrNull() : null;
                if (runningFiber != null) {
                    void $this$mapTo$iv$iv;
                    StringBuilder log = A_Fiber.Companion.getDebugLog(runningFiber);
                    if (interpreter.isReifying()) {
                        log.append("R! ");
                    }
                    Strings.INSTANCE.tab(log, interpreter.unreifiedCallDepth);
                    if (log.length() > 50000) {
                        log.delete(0, log.length() - 37500);
                    }
                    Object[] $this$map$iv = arguments;
                    boolean $i$f$map = false;
                    Object[] objectArray = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                    boolean $i$f$mapTo = false;
                    int n = ((void)$this$mapTo$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void it;
                        void item$iv$iv;
                        void var18_19 = item$iv$iv = $this$mapTo$iv$iv[i];
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(!(it instanceof AvailObject) ? it : (((AvailObject)it).getTypeTag() == TypeTag.OBJECT_TAG ? "(some object)" : (!((AvailObject)it).isTuple() ? it : (((AvailObject)it).isString() && A_Tuple.Companion.getTupleSize((A_Tuple)it) > 200 ? ((AvailObject)it).copyStringFromToCanDestroy(1, 200, false).asNativeString() + "..." : (!((AvailObject)it).isString() && A_Tuple.Companion.getTupleSize((A_Tuple)it) > 20 ? CollectionsKt.plus((Iterable)A_Tuple.Companion.copyTupleFromToCanDestroy((A_Tuple)it, 1, 20, false), (Object)"...") : it)))));
                    }
                    List tidyArguments = (List)destination$iv$iv;
                    Collection $this$toTypedArray$iv = tidyArguments;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    Object[] objectArray2 = thisCollection$iv.toArray(new Object[0]);
                    Intrinsics.checkNotNull((Object)objectArray2, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    Object[] objectArray3 = objectArray2;
                    log.append(MessageFormat.format(message, Arrays.copyOf(objectArray3, objectArray3.length)));
                    log.append('\n');
                }
                return;
            }
        }

        @ReferencedInGeneratedCode
        @JvmStatic
        public final void traceL2(@NotNull ExecutableChunk executableChunk, int offset, @NotNull String description, @NotNull Object firstReadOperandValue) {
            Intrinsics.checkNotNullParameter((Object)executableChunk, (String)"executableChunk");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)firstReadOperandValue, (String)"firstReadOperandValue");
            if (this.getDebugL2() && mainLogger.isLoggable(Level.SEVERE)) {
                String str = "L2 = " + offset + " of " + executableChunk.name() + " " + description + " <- " + firstReadOperandValue;
                A_Fiber fiber2 = this.current().fiberOrNull();
                Logger logger = mainLogger;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"mainLogger");
                Object[] objectArray = new Object[]{str};
                this.log(fiber2, logger, Level.SEVERE, "{0}", objectArray);
            }
        }

        @NotNull
        public final CheckedMethod getTraceL2Method() {
            return traceL2Method;
        }

        @NotNull
        public final Interpreter current() {
            return AvailThread.Companion.current().getInterpreter();
        }

        public final int currentIndexOrZero() {
            Thread thread = Thread.currentThread();
            if (thread instanceof AvailThread) {
                return ((AvailThread)thread).getInterpreter().getInterpreterIndex();
            }
            if (thread instanceof ForkJoinWorkerThread) {
                return ((ForkJoinWorkerThread)thread).getPoolIndex() % AvailRuntimeConfiguration.INSTANCE.getMaxInterpreters();
            }
            return 0;
        }

        @Nullable
        public final Interpreter currentOrNull() {
            AvailThread availThread = AvailThread.Companion.currentOrNull();
            return availThread != null ? availThread.getInterpreter() : null;
        }

        @NotNull
        public final CheckedMethod getCallerIsReifiedMethod() {
            return callerIsReifiedMethod;
        }

        @NotNull
        public final CheckedField getRuntimeField() {
            return runtimeField;
        }

        @NotNull
        public final CheckedMethod getSetLatestResultMethod() {
            return setLatestResultMethod;
        }

        public final void setSetLatestResultMethod(@NotNull CheckedMethod checkedMethod) {
            Intrinsics.checkNotNullParameter((Object)checkedMethod, (String)"<set-?>");
            setLatestResultMethod = checkedMethod;
        }

        @NotNull
        public final CheckedMethod getGetLatestResultMethod() {
            return getLatestResultMethod;
        }

        public final void setGetLatestResultMethod(@NotNull CheckedMethod checkedMethod) {
            Intrinsics.checkNotNullParameter((Object)checkedMethod, (String)"<set-?>");
            getLatestResultMethod = checkedMethod;
        }

        @NotNull
        public final CheckedField getInterpreterReturningFunctionField() {
            return interpreterReturningFunctionField;
        }

        @NotNull
        public final CheckedField getReturnNowField() {
            return returnNowField;
        }

        @NotNull
        public final CheckedMethod getBeforeAttemptPrimitiveMethod() {
            return beforeAttemptPrimitiveMethod;
        }

        public final void setBeforeAttemptPrimitiveMethod(@NotNull CheckedMethod checkedMethod) {
            Intrinsics.checkNotNullParameter((Object)checkedMethod, (String)"<set-?>");
            beforeAttemptPrimitiveMethod = checkedMethod;
        }

        @NotNull
        public final CheckedMethod getAfterAttemptPrimitiveMethod() {
            return afterAttemptPrimitiveMethod;
        }

        public final void setAfterAttemptPrimitiveMethod(@NotNull CheckedMethod checkedMethod) {
            Intrinsics.checkNotNullParameter((Object)checkedMethod, (String)"<set-?>");
            afterAttemptPrimitiveMethod = checkedMethod;
        }

        @NotNull
        public final CheckedMethod getGetReifiedContinuationMethod() {
            return getReifiedContinuationMethod;
        }

        @NotNull
        public final CheckedMethod getSetReifiedContinuationMethod() {
            return setReifiedContinuationMethod;
        }

        @NotNull
        public final CheckedMethod getPopContinuationMethod() {
            return popContinuationMethod;
        }

        public final void setPopContinuationMethod(@NotNull CheckedMethod checkedMethod) {
            Intrinsics.checkNotNullParameter((Object)checkedMethod, (String)"<set-?>");
            popContinuationMethod = checkedMethod;
        }

        @NotNull
        public final CheckedField getInterpreterFunctionField() {
            return interpreterFunctionField;
        }

        @NotNull
        public final CheckedField getChunkField() {
            return chunkField;
        }

        public final void setChunkField(@NotNull CheckedField checkedField) {
            Intrinsics.checkNotNullParameter((Object)checkedField, (String)"<set-?>");
            chunkField = checkedField;
        }

        @NotNull
        public final CheckedField getOffsetField() {
            return offsetField;
        }

        @NotNull
        public final CheckedField getArgsBufferField() {
            return argsBufferField;
        }

        @NotNull
        public final CheckedField getLevelOneStepperField() {
            return levelOneStepperField;
        }

        @NotNull
        public final CheckedMethod isInterruptRequestedMethod() {
            return isInterruptRequestedMethod;
        }

        @NotNull
        public final CheckedMethod getCheckValidityMethod() {
            return checkValidityMethod;
        }

        @NotNull
        public final CheckedMethod getReifierToRestartMethod() {
            return reifierToRestartMethod;
        }

        @NotNull
        public final CheckedMethod getReifyMethod() {
            return reifyMethod;
        }

        @NotNull
        public final CheckedMethod getReifierToRestartWithArgumentsMethod() {
            return reifierToRestartWithArgumentsMethod;
        }

        @NotNull
        public final CheckedMethod getPreinvoke0Method() {
            return preinvoke0Method;
        }

        public final void setPreinvoke0Method(@NotNull CheckedMethod checkedMethod) {
            Intrinsics.checkNotNullParameter((Object)checkedMethod, (String)"<set-?>");
            preinvoke0Method = checkedMethod;
        }

        @NotNull
        public final CheckedMethod getPreinvoke1Method() {
            return preinvoke1Method;
        }

        public final void setPreinvoke1Method(@NotNull CheckedMethod checkedMethod) {
            Intrinsics.checkNotNullParameter((Object)checkedMethod, (String)"<set-?>");
            preinvoke1Method = checkedMethod;
        }

        @NotNull
        public final CheckedMethod getPreinvoke2Method() {
            return preinvoke2Method;
        }

        public final void setPreinvoke2Method(@NotNull CheckedMethod checkedMethod) {
            Intrinsics.checkNotNullParameter((Object)checkedMethod, (String)"<set-?>");
            preinvoke2Method = checkedMethod;
        }

        @NotNull
        public final CheckedMethod getPreinvoke3Method() {
            return preinvoke3Method;
        }

        public final void setPreinvoke3Method(@NotNull CheckedMethod checkedMethod) {
            Intrinsics.checkNotNullParameter((Object)checkedMethod, (String)"<set-?>");
            preinvoke3Method = checkedMethod;
        }

        @NotNull
        public final CheckedMethod getPreinvokeMethod() {
            return preinvokeMethod;
        }

        public final void setPreinvokeMethod(@NotNull CheckedMethod checkedMethod) {
            Intrinsics.checkNotNullParameter((Object)checkedMethod, (String)"<set-?>");
            preinvokeMethod = checkedMethod;
        }

        @NotNull
        public final CheckedMethod getPostinvokeMethod() {
            return postinvokeMethod;
        }

        public final void setPostinvokeMethod(@NotNull CheckedMethod checkedMethod) {
            Intrinsics.checkNotNullParameter((Object)checkedMethod, (String)"<set-?>");
            postinvokeMethod = checkedMethod;
        }

        @NotNull
        public final CheckedMethod getInterpreterRunChunkMethod() {
            return interpreterRunChunkMethod;
        }

        public final void setInterpreterRunChunkMethod(@NotNull CheckedMethod checkedMethod) {
            Intrinsics.checkNotNullParameter((Object)checkedMethod, (String)"<set-?>");
            interpreterRunChunkMethod = checkedMethod;
        }

        @NotNull
        public final CheckedMethod getAttemptThePrimitiveMethod() {
            return attemptThePrimitiveMethod;
        }

        @NotNull
        public final CheckedMethod getAttemptTheInlinePrimitiveMethod() {
            return attemptTheInlinePrimitiveMethod;
        }

        @NotNull
        public final CheckedMethod getAttemptTheNonInlinePrimitiveMethod() {
            return attemptTheNonInlinePrimitiveMethod;
        }

        @NotNull
        public final CheckedMethod getReportWrongReturnTypeMethod() {
            return reportWrongReturnTypeMethod;
        }

        public final void setReportWrongReturnTypeMethod(@NotNull CheckedMethod checkedMethod) {
            Intrinsics.checkNotNullParameter((Object)checkedMethod, (String)"<set-?>");
            reportWrongReturnTypeMethod = checkedMethod;
        }

        @NotNull
        public final CheckedMethod getReportUnassignedVariableReadMethod() {
            return reportUnassignedVariableReadMethod;
        }

        public final void setReportUnassignedVariableReadMethod(@NotNull CheckedMethod checkedMethod) {
            Intrinsics.checkNotNullParameter((Object)checkedMethod, (String)"<set-?>");
            reportUnassignedVariableReadMethod = checkedMethod;
        }

        @NotNull
        public final A_Function assignmentFunction() {
            return VariableDescriptor.Companion.getBootstrapAssignmentFunction();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Primitive.Result.values().length];
            nArray[Primitive.Result.SUCCESS.ordinal()] = 1;
            nArray[Primitive.Result.FAILURE.ordinal()] = 2;
            nArray[Primitive.Result.READY_TO_INVOKE.ordinal()] = 3;
            nArray[Primitive.Result.CONTINUATION_CHANGED.ordinal()] = 4;
            nArray[Primitive.Result.FIBER_SUSPENDED.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

