/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwoSimple;

import avail.descriptor.functions.A_Continuation;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.variables.VariableDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.L2Chunk;
import avail.interpreter.levelTwoSimple.L2SimpleInstruction;
import avail.optimizer.ExecutableChunk;
import avail.optimizer.OptimizationLevel;
import avail.optimizer.StackReifier;
import avail.utility.Strings;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lavail/interpreter/levelTwoSimple/L2SimpleExecutableChunk;", "Lavail/optimizer/ExecutableChunk;", "code", "Lavail/descriptor/functions/A_RawFunction;", "instructions", "", "Lavail/interpreter/levelTwoSimple/L2SimpleInstruction;", "nextOptimizationLevel", "Lavail/optimizer/OptimizationLevel;", "(Lavail/descriptor/functions/A_RawFunction;[Lavail/interpreter/levelTwoSimple/L2SimpleInstruction;Lavail/optimizer/OptimizationLevel;)V", "[Lavail/interpreter/levelTwoSimple/L2SimpleInstruction;", "primitive", "Lavail/interpreter/Primitive;", "name", "", "runChunk", "Lavail/optimizer/StackReifier;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "offset", "", "avail"})
public final class L2SimpleExecutableChunk
implements ExecutableChunk {
    @NotNull
    private final A_RawFunction code;
    @NotNull
    private final L2SimpleInstruction[] instructions;
    @NotNull
    private final OptimizationLevel nextOptimizationLevel;
    @Nullable
    private final Primitive primitive;

    public L2SimpleExecutableChunk(@NotNull A_RawFunction code, @NotNull L2SimpleInstruction[] instructions, @NotNull OptimizationLevel nextOptimizationLevel) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)instructions, (String)"instructions");
        Intrinsics.checkNotNullParameter((Object)((Object)nextOptimizationLevel), (String)"nextOptimizationLevel");
        this.code = code;
        this.instructions = instructions;
        this.nextOptimizationLevel = nextOptimizationLevel;
        this.primitive = this.code.codePrimitive();
    }

    @Override
    @NotNull
    public String name() {
        return "simple chunk for " + A_RawFunction.Companion.getMethodName(this.code);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public StackReifier runChunk(@NotNull Interpreter interpreter, int offset) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        savedArguments = new Ref.ObjectRef();
        if (offset == 0 && this.primitive != null) {
            savedArguments.element = CollectionsKt.toList((Iterable)interpreter.argsBuffer);
            v0 = interpreter.function;
            Intrinsics.checkNotNull((Object)v0);
            reifier = interpreter.attemptThePrimitive(v0, this.primitive);
            if (reifier != null) {
                it = reifier;
                $i$a$-let-L2SimpleExecutableChunk$runChunk$1 = false;
                return it;
            }
            if (interpreter.returnNow) {
                return null;
            }
            v1 = var5_20 = this.primitive.hasFlag(Primitive.Flag.CannotFail) == false ? 1 : 0;
            if (_Assertions.ENABLED && var5_20 == 0) {
                it = "Assertion failed";
                throw new AssertionError((Object)it);
            }
            $this$runChunk_u24lambda_u2d1 = interpreter.argsBuffer;
            $i$a$-run-L2SimpleExecutableChunk$runChunk$2 = false;
            $this$runChunk_u24lambda_u2d1.clear();
            v2 = savedArguments.element;
            Intrinsics.checkNotNull((Object)v2);
            $this$runChunk_u24lambda_u2d1.addAll((Collection)v2);
        }
        if (offset <= 0 && (chunkChanged = A_RawFunction.Companion.decrementCountdownToReoptimize(this.code, (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>((Ref.ObjectRef<List<AvailObject>>)savedArguments, this, interpreter){
            final /* synthetic */ Ref.ObjectRef<List<AvailObject>> $savedArguments;
            final /* synthetic */ L2SimpleExecutableChunk this$0;
            final /* synthetic */ Interpreter $interpreter;
            {
                this.$savedArguments = $savedArguments;
                this.this$0 = $receiver;
                this.$interpreter = $interpreter;
                super(1);
            }

            public final void invoke(boolean optimize) {
                L2Chunk chunk;
                List list2 = (List)this.$savedArguments.element;
                if (list2 == null) {
                    L2SimpleExecutableChunk l2SimpleExecutableChunk = this.this$0;
                    Ref.ObjectRef<List<AvailObject>> objectRef = this.$savedArguments;
                    Interpreter interpreter = this.$interpreter;
                    L2SimpleExecutableChunk $this$invoke_u24lambda_u2d0 = l2SimpleExecutableChunk;
                    boolean bl = false;
                    objectRef.element = CollectionsKt.toList((Iterable)interpreter.argsBuffer);
                    list2 = Unit.INSTANCE;
                }
                if (optimize) {
                    OptimizationLevel.Companion.optimizationLevel(L2SimpleExecutableChunk.access$getNextOptimizationLevel$p(this.this$0).ordinal()).optimize(L2SimpleExecutableChunk.access$getCode$p(this.this$0), this.$interpreter);
                }
                this.$interpreter.chunk = chunk = A_RawFunction.Companion.getStartingChunk(L2SimpleExecutableChunk.access$getCode$p(this.this$0));
                this.$interpreter.setOffset(chunk.getOffsetAfterInitialTryPrimitive());
            }
        })))) {
            $this$runChunk_u24lambda_u2d2 = interpreter.argsBuffer;
            $i$a$-run-L2SimpleExecutableChunk$runChunk$3 = false;
            $this$runChunk_u24lambda_u2d2.clear();
            v3 = savedArguments.element;
            Intrinsics.checkNotNull((Object)v3);
            $this$runChunk_u24lambda_u2d2.addAll((Collection)v3);
            return null;
        }
        var5_20 = 0;
        $this$runChunk_u24lambda_u2d2 = A_RawFunction.Companion.getNumSlots(this.code) + 1;
        $i$a$-run-L2SimpleExecutableChunk$runChunk$3 = new AvailObject[$this$runChunk_u24lambda_u2d2];
        while (var5_20 < $this$runChunk_u24lambda_u2d2) {
            var8_24 = var5_20++;
            $i$a$-run-L2SimpleExecutableChunk$runChunk$3[var8_24] = NilDescriptor.Companion.getNil();
        }
        registers = $i$a$-run-L2SimpleExecutableChunk$runChunk$3;
        v4 = interpreter.function;
        Intrinsics.checkNotNull((Object)v4, (String)"null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
        registers[0] = (AvailObject)v4;
        if (offset <= 0) {
            i = 1;
            numArgs = A_RawFunction.Companion.numArgs(this.code);
            if (i <= numArgs) {
                while (true) {
                    registers[i] = interpreter.argsBuffer.get(i - 1);
                    if (i == numArgs) break;
                    ++i;
                }
            }
            if ((i = 1) <= ($i$a$-run-L2SimpleExecutableChunk$runChunk$3 = A_RawFunction.Companion.getNumLocals(this.code))) {
                while (true) {
                    registers[i + numArgs] = VariableDescriptor.Companion.newVariableWithOuterType$default(VariableDescriptor.Companion, A_RawFunction.Companion.localTypeAt(this.code, i), null, 2, null);
                    if (i == $i$a$-run-L2SimpleExecutableChunk$runChunk$3) break;
                    ++i;
                }
            }
            if (this.primitive != null) {
                try {
                    failureValue = interpreter.getLatestResult();
                    $i$a$-run-L2SimpleExecutableChunk$runChunk$3 = (int)failureValue.getNotNil();
                    if (_Assertions.ENABLED && $i$a$-run-L2SimpleExecutableChunk$runChunk$3 == 0) {
                        var8_25 = "Assertion failed";
                        throw new AssertionError((Object)var8_25);
                    }
                    registers[numArgs + 1].setValueNoCheck(failureValue);
                }
                catch (Exception e) {
                    if (!_Assertions.ENABLED) ** GOTO lbl99
                    $i$a$-assert-L2SimpleExecutableChunk$runChunk$4 = false;
                    $i$a$-assert-L2SimpleExecutableChunk$runChunk$4 = "Failure variable was not suitable for failure value";
                    throw new AssertionError((Object)$i$a$-assert-L2SimpleExecutableChunk$runChunk$4);
                }
            }
        } else {
            if (Interpreter.Companion.getDebugL2()) {
                v5 = interpreter.getReifiedContinuation();
                Intrinsics.checkNotNull((Object)v5);
                continuation = v5;
                depth = 0;
                pointer = continuation;
                while (pointer.getNotNil()) {
                    ++depth;
                    pointer = A_Continuation.Companion.caller(pointer);
                }
                prefix = interpreter.getInterpreterIndex() + "-" + Strings.INSTANCE.tabs(depth) + "|" + Strings.INSTANCE.tabs(interpreter.unreifiedCallDepth());
                System.out.println((Object)(prefix + (offset - 1) + ": (reentering)"));
                v6 = Interpreter.Companion.getLoggerDebugL2();
                v7 = Level.FINER;
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"FINER");
                var9_29 = new Object[]{interpreter.getDebugModeString(), offset - 1, this.instructions[offset - 1], interpreter.unreifiedCallDepth(), depth};
                Interpreter.Companion.log(v6, v7, "{0}L2Simple REENTER: {1}:{2}, unreified={3}, reified={4}", var9_29);
            }
            v8 = reifier = this.instructions[offset - 1].reenter(registers, interpreter);
            if (v8 != null) {
                return v8;
            }
            v9 = interpreter.chunk;
            if ((v9 != null ? v9.getExecutableChunk() : null) != this) {
                return null;
            }
        }
lbl99:
        // 5 sources

        off = Math.max(offset, 0);
        size = this.instructions.length;
        if (Interpreter.Companion.getDebugL2()) {
            depth = 0;
            v10 = interpreter.getReifiedContinuation();
            Intrinsics.checkNotNull((Object)v10);
            pointer = v10;
            while (pointer.getNotNil()) {
                ++depth;
                pointer = A_Continuation.Companion.caller(pointer);
            }
            prefix = interpreter.getInterpreterIndex() + "-" + Strings.INSTANCE.tabs(depth) + "|" + Strings.INSTANCE.tabs(interpreter.unreifiedCallDepth());
            while (off < size) {
                instruction = this.instructions[off++];
                var11_31 = prefix + (off - 1) + ": " + StringsKt.replace$default((String)instruction.toString(), (String)"\n", (String)("\n" + Strings.INSTANCE.tabs(depth + interpreter.unreifiedCallDepth() + 1)), (boolean)false, (int)4, null);
                System.out.println((Object)var11_31);
                v11 = Interpreter.Companion.getLoggerDebugL1();
                v12 = Level.FINER;
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"FINER");
                var11_31 = new Object[]{interpreter.getDebugModeString(), instruction};
                Interpreter.Companion.log(v11, v12, "{0}L2Simple step: {1}", (Object[])var11_31);
                reifier = instruction.step(registers, interpreter);
                if (reifier == null) continue;
                var12_32 = prefix + (off - 1) + ": (reifying, actual=" + reifier.actuallyReify() + ")";
                System.out.println((Object)var12_32);
                return reifier;
            }
        } else {
            while (off < size) {
                v13 = reifier = this.instructions[off++].step(registers, interpreter);
                if (v13 == null) continue;
                return v13;
            }
        }
        interpreter.returnNow = true;
        interpreter.setLatestResult(registers[registers.length - 1]);
        return null;
    }

    public static final /* synthetic */ OptimizationLevel access$getNextOptimizationLevel$p(L2SimpleExecutableChunk $this) {
        return $this.nextOptimizationLevel;
    }

    public static final /* synthetic */ A_RawFunction access$getCode$p(L2SimpleExecutableChunk $this) {
        return $this.code;
    }
}

