/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.general;

import avail.descriptor.maps.A_Map;
import avail.descriptor.maps.MapDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.MapTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import java.lang.ref.SoftReference;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0005H\u0002J\b\u0010\u000b\u001a\u00020\fH\u0014R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lavail/interpreter/primitive/general/P_EnvironmentMap;", "Lavail/interpreter/Primitive;", "()V", "environmentMap", "Ljava/lang/ref/SoftReference;", "Lavail/descriptor/maps/A_Map;", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "getEnvironmentMap", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "avail"})
public final class P_EnvironmentMap
extends Primitive {
    @NotNull
    public static final P_EnvironmentMap INSTANCE = new P_EnvironmentMap();
    @NotNull
    private static SoftReference<A_Map> environmentMap = new SoftReference<Object>(null);

    private P_EnvironmentMap() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CannotFail, Primitive.Flag.CanInline, Primitive.Flag.HasSideEffect};
        super(0, flagArray);
    }

    private final A_Map getEnvironmentMap() {
        A_Map result2 = environmentMap.get();
        if (result2 == null) {
            result2 = MapDescriptor.Companion.getEmptyMap();
            Map<String, String> map = System.getenv();
            Intrinsics.checkNotNullExpressionValue(map, (String)"map");
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                A_Map a_Map = result2;
                Intrinsics.checkNotNull((Object)a_Map);
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                A_BasicObject a_BasicObject = StringDescriptor.Companion.stringFrom(key);
                Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                result2 = A_Map.Companion.mapAtPuttingCanDestroy(a_Map, a_BasicObject, StringDescriptor.Companion.stringFrom(value), true);
            }
            A_Map a_Map = result2;
            Intrinsics.checkNotNull((Object)a_Map);
            environmentMap = new SoftReference<AvailObject>(a_Map.makeShared());
        }
        return result2;
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(0);
        return interpreter.primitiveSuccess(this.getEnvironmentMap());
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, TupleDescriptor.Companion.getEmptyTuple(), MapTypeDescriptor.Companion.mapTypeForSizesKeyTypeValueType(IntegerRangeTypeDescriptor.Companion.getWholeNumbers(), TupleTypeDescriptor.Companion.getStringType(), TupleTypeDescriptor.Companion.getStringType()), null, 4, null);
    }
}

