/*
 * Decompiled with CFR 0.152.
 */
package avail.builder;

import avail.AvailTask;
import avail.builder.AvailBuilder;
import avail.builder.ResolvedModuleName;
import avail.descriptor.module.A_Module;
import avail.error.ErrorCode;
import avail.interpreter.execution.AvailLoader;
import avail.persistence.cache.Repository;
import avail.resolver.ResolverReference;
import java.io.Serializable;
import java.util.Arrays;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0002J\u001e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0002J\u001e\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0002J\u0010\u0010\r\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\bJ\u0006\u0010\u000f\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lavail/builder/BuildUnloader;", "", "availBuilder", "Lavail/builder/AvailBuilder;", "(Lavail/builder/AvailBuilder;)V", "determineDirtyModules", "", "moduleName", "Lavail/builder/ResolvedModuleName;", "completionAction", "Lkotlin/Function0;", "determineSuccessorModules", "scheduleUnloadOneModule", "unload", "targetName", "unloadModified", "avail"})
public final class BuildUnloader {
    @NotNull
    private final AvailBuilder availBuilder;

    public BuildUnloader(@NotNull AvailBuilder availBuilder) {
        Intrinsics.checkNotNullParameter(availBuilder, "availBuilder");
        this.availBuilder = availBuilder;
    }

    private final void determineSuccessorModules(ResolvedModuleName moduleName2, Function0<Unit> completionAction) {
        this.availBuilder.getRuntime().execute(50, new Function0<Unit>(this, moduleName2, completionAction){
            final /* synthetic */ BuildUnloader this$0;
            final /* synthetic */ ResolvedModuleName $moduleName;
            final /* synthetic */ Function0<Unit> $completionAction;
            {
                this.this$0 = $receiver;
                this.$moduleName = $moduleName;
                this.$completionAction = $completionAction;
                super(0);
            }

            public final void invoke() {
                for (ResolvedModuleName predecessor : BuildUnloader.access$getAvailBuilder$p(this.this$0).getModuleGraph().predecessorsOf(this.$moduleName)) {
                    AvailBuilder.LoadedModule predecessorLoadedModule;
                    Intrinsics.checkNotNull(BuildUnloader.access$getAvailBuilder$p(this.this$0).getLoadedModule(predecessor));
                    if (!predecessorLoadedModule.getDeletionRequest$avail()) continue;
                    AvailBuilder.LoadedModule loadedModule = BuildUnloader.access$getAvailBuilder$p(this.this$0).getLoadedModule(this.$moduleName);
                    Intrinsics.checkNotNull(loadedModule);
                    AvailBuilder.LoadedModule loadedModule2 = loadedModule;
                    loadedModule2.setDeletionRequest$avail(true);
                    break;
                }
                this.$completionAction.invoke();
            }
        });
    }

    private final void determineDirtyModules(ResolvedModuleName moduleName2, Function0<Unit> completionAction) {
        this.availBuilder.getRuntime().execute(50, new Function0<Unit>(this, moduleName2, completionAction){
            final /* synthetic */ BuildUnloader this$0;
            final /* synthetic */ ResolvedModuleName $moduleName;
            final /* synthetic */ Function0<Unit> $completionAction;
            {
                this.this$0 = $receiver;
                this.$moduleName = $moduleName;
                this.$completionAction = $completionAction;
                super(0);
            }

            public final void invoke() {
                boolean dirty = false;
                for (ResolvedModuleName predecessor : BuildUnloader.access$getAvailBuilder$p(this.this$0).getModuleGraph().predecessorsOf(this.$moduleName)) {
                    AvailBuilder.LoadedModule loadedModule;
                    Intrinsics.checkNotNull(BuildUnloader.access$getAvailBuilder$p(this.this$0).getLoadedModule(predecessor));
                    if (!loadedModule.getDeletionRequest$avail()) continue;
                    dirty = true;
                    break;
                }
                if (!dirty) {
                    AvailBuilder.LoadedModule loadedModule = BuildUnloader.access$getAvailBuilder$p(this.this$0).getLoadedModule(this.$moduleName);
                    Intrinsics.checkNotNull(loadedModule);
                    loadedModule = loadedModule;
                    Repository repository = this.$moduleName.getRepository();
                    Repository.ModuleArchive archive = repository.getArchive(this.$moduleName.getRootRelativeName());
                    ResolverReference resolverReference = this.$moduleName.getResolverReference();
                    if (resolverReference.isPackage()) {
                        loadedModule.setDeletionRequest$avail(dirty);
                        Level level = Level.FINEST;
                        Intrinsics.checkNotNullExpressionValue(level, "FINEST");
                        Object[] objectArray = new Object[]{this.$moduleName};
                        AvailBuilder.Companion.log$avail(level, "(Module %s is dirty)", objectArray);
                        this.$completionAction.invoke();
                    } else {
                        archive.digestForFile(this.$moduleName, false, (Function1<? super byte[], Unit>)new Function1<byte[], Unit>(loadedModule, this.$moduleName, this.$completionAction){
                            final /* synthetic */ AvailBuilder.LoadedModule $loadedModule;
                            final /* synthetic */ ResolvedModuleName $moduleName;
                            final /* synthetic */ Function0<Unit> $completionAction;
                            {
                                this.$loadedModule = $loadedModule;
                                this.$moduleName = $moduleName;
                                this.$completionAction = $completionAction;
                                super(1);
                            }

                            public final void invoke(@NotNull byte[] latestDigest) {
                                Intrinsics.checkNotNullParameter(latestDigest, "latestDigest");
                                if (!Arrays.equals(latestDigest, this.$loadedModule.getSourceDigest$avail())) {
                                    this.$loadedModule.setDeletionRequest$avail(true);
                                    Level level = Level.FINEST;
                                    Intrinsics.checkNotNullExpressionValue(level, "FINEST");
                                    Object[] objectArray = new Object[]{this.$moduleName};
                                    AvailBuilder.Companion.log$avail(level, "(Module %s is dirty)", objectArray);
                                }
                                this.$completionAction.invoke();
                            }
                        }, (Function2<? super ErrorCode, ? super Throwable, Unit>)new Function2<ErrorCode, Throwable, Unit>(this.$moduleName, this.$completionAction){
                            final /* synthetic */ ResolvedModuleName $moduleName;
                            final /* synthetic */ Function0<Unit> $completionAction;
                            {
                                this.$moduleName = $moduleName;
                                this.$completionAction = $completionAction;
                                super(2);
                            }

                            public final void invoke(@NotNull ErrorCode code, @Nullable Throwable ex) {
                                Intrinsics.checkNotNullParameter(code, "code");
                                Level level = Level.SEVERE;
                                Intrinsics.checkNotNullExpressionValue(level, "SEVERE");
                                Object[] objectArray = new Object[3];
                                objectArray[0] = this.$moduleName;
                                objectArray[1] = code;
                                Throwable throwable = ex;
                                objectArray[2] = throwable != null ? (Serializable)throwable : (Serializable)((Object)"");
                                AvailBuilder.Companion.log$avail(level, "Could not determineDirtyModules for %s. Received %s: %s", objectArray);
                                this.$completionAction.invoke();
                            }
                        });
                    }
                } else {
                    AvailBuilder.LoadedModule loadedModule = BuildUnloader.access$getAvailBuilder$p(this.this$0).getLoadedModule(this.$moduleName);
                    Intrinsics.checkNotNull(loadedModule);
                    loadedModule = loadedModule;
                    loadedModule.setDeletionRequest$avail(dirty);
                    Level level = Level.FINEST;
                    Intrinsics.checkNotNullExpressionValue(level, "FINEST");
                    Object[] objectArray = new Object[]{this.$moduleName};
                    AvailBuilder.Companion.log$avail(level, "(Module %s is dirty)", objectArray);
                    this.$completionAction.invoke();
                }
            }
        });
    }

    private final void scheduleUnloadOneModule(ResolvedModuleName moduleName2, Function0<Unit> completionAction) {
        this.availBuilder.getRuntime().whenSafePointDo(50, new Function0<Unit>(this, moduleName2, completionAction){
            final /* synthetic */ BuildUnloader this$0;
            final /* synthetic */ ResolvedModuleName $moduleName;
            final /* synthetic */ Function0<Unit> $completionAction;
            {
                this.this$0 = $receiver;
                this.$moduleName = $moduleName;
                this.$completionAction = $completionAction;
                super(0);
            }

            public final void invoke() {
                AvailBuilder.LoadedModule loadedModule = BuildUnloader.access$getAvailBuilder$p(this.this$0).getLoadedModule(this.$moduleName);
                Intrinsics.checkNotNull(loadedModule);
                AvailBuilder.LoadedModule loadedModule2 = loadedModule;
                if (!loadedModule2.getDeletionRequest$avail()) {
                    this.$completionAction.invoke();
                    return;
                }
                Level level = Level.FINER;
                Intrinsics.checkNotNullExpressionValue(level, "FINER");
                Object[] objectArray = new Object[]{this.$moduleName};
                AvailBuilder.Companion.log$avail(level, "Beginning unload of: %s", objectArray);
                A_Module module = loadedModule2.getModule$avail();
                A_Module.Companion.removeFrom(module, AvailLoader.Companion.forUnloading(BuildUnloader.access$getAvailBuilder$p(this.this$0).getRuntime(), module, BuildUnloader.access$getAvailBuilder$p(this.this$0).getTextInterface()), new Function0<Unit>(this.this$0, module, this.$moduleName, this.$completionAction){
                    final /* synthetic */ BuildUnloader this$0;
                    final /* synthetic */ A_Module $module;
                    final /* synthetic */ ResolvedModuleName $moduleName;
                    final /* synthetic */ Function0<Unit> $completionAction;
                    {
                        this.this$0 = $receiver;
                        this.$module = $module;
                        this.$moduleName = $moduleName;
                        this.$completionAction = $completionAction;
                        super(0);
                    }

                    public final void invoke() {
                        BuildUnloader.access$getAvailBuilder$p(this.this$0).getRuntime().unlinkModule(this.$module);
                        Level level = Level.FINER;
                        Intrinsics.checkNotNullExpressionValue(level, "FINER");
                        Object[] objectArray = new Object[]{this.$moduleName};
                        AvailBuilder.Companion.log$avail(level, "Finished unload of: %s", objectArray);
                        this.$completionAction.invoke();
                    }
                });
            }
        });
    }

    public final void unloadModified() {
        this.availBuilder.getModuleGraph().parallelVisit((Function2<ResolvedModuleName, Function0<Unit>, Unit>)new Function2<ResolvedModuleName, Function0<? extends Unit>, Unit>(this){
            final /* synthetic */ BuildUnloader this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull ResolvedModuleName moduleName2, @NotNull Function0<Unit> done) {
                Intrinsics.checkNotNullParameter(moduleName2, "moduleName");
                Intrinsics.checkNotNullParameter(done, "done");
                BuildUnloader.access$getAvailBuilder$p(this.this$0).getRuntime().execute(new AvailTask(50, new Function0<Unit>(this.this$0, moduleName2, done){
                    final /* synthetic */ BuildUnloader this$0;
                    final /* synthetic */ ResolvedModuleName $moduleName;
                    final /* synthetic */ Function0<Unit> $done;
                    {
                        this.this$0 = $receiver;
                        this.$moduleName = $moduleName;
                        this.$done = $done;
                        super(0);
                    }

                    public final void invoke() {
                        BuildUnloader.access$determineDirtyModules(this.this$0, this.$moduleName, this.$done);
                    }
                }));
            }
        });
        this.availBuilder.getModuleGraph().getReverse().parallelVisit((Function2<ResolvedModuleName, Function0<Unit>, Unit>)new Function2<ResolvedModuleName, Function0<? extends Unit>, Unit>(this){
            final /* synthetic */ BuildUnloader this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull ResolvedModuleName moduleName2, @NotNull Function0<Unit> done) {
                Intrinsics.checkNotNullParameter(moduleName2, "moduleName");
                Intrinsics.checkNotNullParameter(done, "done");
                BuildUnloader.access$getAvailBuilder$p(this.this$0).getRuntime().execute(new AvailTask(50, new Function0<Unit>(this.this$0, moduleName2, done){
                    final /* synthetic */ BuildUnloader this$0;
                    final /* synthetic */ ResolvedModuleName $moduleName;
                    final /* synthetic */ Function0<Unit> $done;
                    {
                        this.this$0 = $receiver;
                        this.$moduleName = $moduleName;
                        this.$done = $done;
                        super(0);
                    }

                    public final void invoke() {
                        BuildUnloader.access$scheduleUnloadOneModule(this.this$0, this.$moduleName, this.$done);
                    }
                }));
            }
        });
        for (AvailBuilder.LoadedModule loadedModule : this.availBuilder.loadedModulesCopy()) {
            if (!loadedModule.getDeletionRequest$avail()) continue;
            ResolvedModuleName moduleName2 = loadedModule.getName();
            this.availBuilder.removeLoadedModule$avail(moduleName2);
            this.availBuilder.getModuleGraph().exciseVertex(moduleName2);
        }
    }

    public final void unload(@Nullable ResolvedModuleName targetName) {
        boolean bl;
        if (targetName == null) {
            for (AvailBuilder.LoadedModule loadedModule : this.availBuilder.loadedModulesCopy()) {
                loadedModule.setDeletionRequest$avail(true);
            }
        } else {
            AvailBuilder.LoadedModule target = this.availBuilder.getLoadedModule(targetName);
            if (target != null) {
                target.setDeletionRequest$avail(true);
            }
        }
        int moduleCount = 0;
        moduleCount = this.availBuilder.getModuleGraph().getVertexCount();
        this.availBuilder.getModuleGraph().parallelVisit((Function2<ResolvedModuleName, Function0<Unit>, Unit>)new Function2<ResolvedModuleName, Function0<? extends Unit>, Unit>(this){
            final /* synthetic */ BuildUnloader this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull ResolvedModuleName moduleName2, @NotNull Function0<Unit> done) {
                Intrinsics.checkNotNullParameter(moduleName2, "moduleName");
                Intrinsics.checkNotNullParameter(done, "done");
                BuildUnloader.access$getAvailBuilder$p(this.this$0).getRuntime().execute(new AvailTask(50, new Function0<Unit>(this.this$0, moduleName2, done){
                    final /* synthetic */ BuildUnloader this$0;
                    final /* synthetic */ ResolvedModuleName $moduleName;
                    final /* synthetic */ Function0<Unit> $done;
                    {
                        this.this$0 = $receiver;
                        this.$moduleName = $moduleName;
                        this.$done = $done;
                        super(0);
                    }

                    public final void invoke() {
                        BuildUnloader.access$determineSuccessorModules(this.this$0, this.$moduleName, this.$done);
                    }
                }));
            }
        });
        this.availBuilder.getModuleGraph().getReverse().parallelVisit((Function2<ResolvedModuleName, Function0<Unit>, Unit>)new Function2<ResolvedModuleName, Function0<? extends Unit>, Unit>(this){
            final /* synthetic */ BuildUnloader this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull ResolvedModuleName moduleName2, @NotNull Function0<Unit> done) {
                Intrinsics.checkNotNullParameter(moduleName2, "moduleName");
                Intrinsics.checkNotNullParameter(done, "done");
                BuildUnloader.access$getAvailBuilder$p(this.this$0).getRuntime().execute(new AvailTask(50, new Function0<Unit>(this.this$0, moduleName2, done){
                    final /* synthetic */ BuildUnloader this$0;
                    final /* synthetic */ ResolvedModuleName $moduleName;
                    final /* synthetic */ Function0<Unit> $done;
                    {
                        this.this$0 = $receiver;
                        this.$moduleName = $moduleName;
                        this.$done = $done;
                        super(0);
                    }

                    public final void invoke() {
                        BuildUnloader.access$scheduleUnloadOneModule(this.this$0, this.$moduleName, this.$done);
                    }
                }));
            }
        });
        for (AvailBuilder.LoadedModule loadedModule : this.availBuilder.loadedModulesCopy()) {
            if (!loadedModule.getDeletionRequest$avail()) continue;
            ResolvedModuleName moduleName2 = loadedModule.getName();
            this.availBuilder.removeLoadedModule$avail(moduleName2);
            this.availBuilder.getModuleGraph().exciseVertex(moduleName2);
            int n = moduleCount;
            moduleCount = n + -1;
        }
        boolean bl2 = bl = this.availBuilder.getModuleGraph().getVertexCount() == moduleCount;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Expected " + moduleCount + " modules are loaded, however after unload " + this.availBuilder.getModuleGraph().getVertexCount() + " modules are loaded.";
            throw new AssertionError((Object)string2);
        }
    }

    public static final /* synthetic */ AvailBuilder access$getAvailBuilder$p(BuildUnloader $this) {
        return $this.availBuilder;
    }

    public static final /* synthetic */ void access$determineDirtyModules(BuildUnloader $this, ResolvedModuleName moduleName2, Function0 completionAction) {
        $this.determineDirtyModules(moduleName2, completionAction);
    }

    public static final /* synthetic */ void access$scheduleUnloadOneModule(BuildUnloader $this, ResolvedModuleName moduleName2, Function0 completionAction) {
        $this.scheduleUnloadOneModule(moduleName2, completionAction);
    }

    public static final /* synthetic */ void access$determineSuccessorModules(BuildUnloader $this, ResolvedModuleName moduleName2, Function0 completionAction) {
        $this.determineSuccessorModules(moduleName2, completionAction);
    }
}

