/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.atoms;

import avail.descriptor.atoms.A_Atom;
import avail.descriptor.methods.MethodDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.effects.LoadingEffectToRunPrimitive;
import avail.interpreter.execution.AvailLoader;
import avail.interpreter.execution.Interpreter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/atoms/P_AtomRemoveProperty;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_AtomRemoveProperty
extends Primitive {
    @NotNull
    public static final P_AtomRemoveProperty INSTANCE = new P_AtomRemoveProperty();

    private P_AtomRemoveProperty() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.HasSideEffect, Primitive.Flag.WritesToHiddenGlobalState};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        block2: {
            Intrinsics.checkNotNullParameter(interpreter, "interpreter");
            interpreter.checkArgumentCount(2);
            AvailObject atom = interpreter.argument(0);
            AvailObject propertyKey = interpreter.argument(1);
            if (A_Atom.Companion.isAtomSpecial(atom) || A_Atom.Companion.isAtomSpecial(propertyKey)) {
                return interpreter.primitiveFailure(AvailErrorCode.E_SPECIAL_ATOM);
            }
            AvailObject propertyValue = A_Atom.Companion.getAtomProperty(atom, propertyKey);
            if (propertyValue.isNil()) {
                return interpreter.primitiveFailure(AvailErrorCode.E_NO_SUCH_FIELD);
            }
            A_Atom.Companion.setAtomProperty(atom, propertyKey, NilDescriptor.Companion.getNil());
            AvailLoader availLoader = interpreter.availLoaderOrNull();
            if (availLoader == null) break block2;
            A_BasicObject[] a_BasicObjectArray = new A_BasicObject[]{atom, propertyKey};
            availLoader.recordEffect(new LoadingEffectToRunPrimitive(MethodDescriptor.SpecialMethodAtom.ATOM_REMOVE_PROPERTY.getBundle(), a_BasicObjectArray));
        }
        return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PrimitiveTypeDescriptor.Types.ATOM.getO(), PrimitiveTypeDescriptor.Types.ATOM.getO()), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_NO_SUCH_FIELD};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

