/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.pojos;

import avail.descriptor.functions.A_Function;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.pojos.PojoDescriptor;
import avail.descriptor.pojos.RawPojoDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.BottomTypeDescriptor;
import avail.descriptor.types.PojoTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.MarshalingException;
import avail.interpreter.Primitive;
import avail.interpreter.execution.AvailLoader;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.primitive.pojos.PrimitiveHelper;
import avail.utility.Mutable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014J\u001e\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lavail/interpreter/primitive/pojos/P_InvokePojoConstructor;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "argumentTypes", "", "avail"})
public final class P_InvokePojoConstructor
extends Primitive {
    @NotNull
    public static final P_InvokePojoConstructor INSTANCE = new P_InvokePojoConstructor();

    private P_InvokePojoConstructor() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.Private, Primitive.Flag.HasSideEffect};
        super(-1, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Primitive.Result result2;
        boolean bl;
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        A_Tuple constructorArgs = ObjectTupleDescriptor.Companion.tupleFromList(interpreter.argsBuffer);
        A_Function a_Function = interpreter.function;
        Intrinsics.checkNotNull(a_Function);
        A_Function primitiveFunction = a_Function;
        A_RawFunction primitiveRawFunction = primitiveFunction.code();
        boolean bl2 = bl = primitiveRawFunction.codePrimitive() == this;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        AvailObject constructorPojo = primitiveFunction.outerVarAt(1);
        AvailObject marshaledTypes = primitiveFunction.outerVarAt(2);
        A_Type expectedType = A_Type.Companion.getReturnType(primitiveRawFunction.functionType());
        AvailLoader availLoader = interpreter.availLoaderOrNull();
        if (availLoader != null) {
            availLoader.statementCanBeSummarized(false);
        }
        Constructor constructor = (Constructor)constructorPojo.javaObjectNotNull();
        Mutable<Object> errorOut = new Mutable<Object>(null);
        Object[] marshaledArgs = PrimitiveHelper.INSTANCE.marshalValues$avail(marshaledTypes, constructorArgs, errorOut);
        if (errorOut.getValue() != null) {
            Object v3 = errorOut.getValue();
            Intrinsics.checkNotNull(v3);
            AvailErrorCode e = v3;
            return interpreter.primitiveFailure(PojoDescriptor.Companion.newPojo(RawPojoDescriptor.Companion.identityPojo((Object)e), PojoTypeDescriptor.Companion.pojoTypeForClass(((Object)((Object)e)).getClass())));
        }
        Primitive.Result result3 = null;
        try {
            Primitive.Result result4;
            if (marshaledArgs != null) {
                Object[] it = marshaledArgs;
                boolean bl3 = false;
                v4 = (Primitive.Result)((Object)constructor.newInstance(Arrays.copyOf(it, it.length)));
            } else {
                v4 = result2 = null;
            }
            if (result2 == null) {
                Object[] objectArray = new Object[]{null};
                Object t = constructor.newInstance(objectArray);
                result4 = (Primitive.Result)((Object)t);
                Intrinsics.checkNotNullExpressionValue(t, "constructor.newInstance(null)");
            } else {
                result4 = result2;
            }
            result3 = result4;
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getCause();
            Intrinsics.checkNotNull(throwable);
            Throwable cause = throwable;
            return interpreter.primitiveFailure(PojoDescriptor.Companion.newPojo(RawPojoDescriptor.Companion.identityPojo(cause), PojoTypeDescriptor.Companion.pojoTypeForClass(cause.getClass())));
        }
        catch (Throwable e) {
            return interpreter.primitiveFailure(PojoDescriptor.Companion.newPojo(RawPojoDescriptor.Companion.identityPojo(e), PojoTypeDescriptor.Companion.pojoTypeForClass(e.getClass())));
        }
        try {
            result2 = interpreter.primitiveSuccess(PojoTypeDescriptor.Companion.unmarshal((Object)result3, expectedType));
        }
        catch (MarshalingException e) {
            result2 = interpreter.primitiveFailure(PojoDescriptor.Companion.newPojo(RawPojoDescriptor.Companion.identityPojo(e), PojoTypeDescriptor.Companion.pojoTypeForClass(e.getClass())));
        }
        return result2;
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return BottomTypeDescriptor.Companion.getBottom();
    }

    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction, @NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter(rawFunction, "rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        return A_Type.Companion.getReturnType(rawFunction.functionType());
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        return PojoTypeDescriptor.Companion.pojoTypeForClass(Throwable.class);
    }
}

