/*
 * A_RegisterDump.kt
 * Copyright © 1993-2022, The Avail Foundation, LLC.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * * Neither the name of the copyright holder nor the names of the contributors
 *   may be used to endorse or promote products derived from this software
 *   without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package avail.descriptor.functions

import avail.descriptor.representation.A_BasicObject
import avail.descriptor.representation.AvailObject
import avail.interpreter.levelTwo.L2Chunk
import avail.optimizer.L2Generator
import avail.optimizer.jvm.CheckedMethod
import avail.optimizer.jvm.CheckedMethod.Companion.instanceMethod
import avail.optimizer.jvm.ReferencedInGeneratedCode

/**
 * `A_RegisterDump` is an interface for
 * [register&#32;dumps][ContinuationRegisterDumpDescriptor] created for
 * reification within an [L2Chunk], generated by the [L2Generator].
 *
 * @author Mark van Gulik &lt;mark@availlang.org&gt;
 */
interface A_RegisterDump : A_BasicObject
{
	/**
	 * Given a continuation register dump, extract the object at the given
	 * slot index.
	 *
	 * @param index
	 *   The index at which to extract an [AvailObject].
	 * @return
	 *   The extracted [AvailObject].
	 */
	@ReferencedInGeneratedCode
	fun extractDumpedObjectAt(index: Int): AvailObject

	/**
	 * Given a continuation register dump, extract the [Long] at the given
	 * slot index.
	 *
	 * @param index
	 *   The index at which to extract a [Long].
	 * @return
	 *   The extracted [Long].
	 */
	@ReferencedInGeneratedCode
	fun extractDumpedLongAt(index: Int): Long

	companion object {
		/**
		 * A [CheckedMethod] for invoking the method [extractDumpedObjectAt].
		 */
		val extractDumpedObjectAtMethod = instanceMethod(
			A_RegisterDump::class.java,
			A_RegisterDump::extractDumpedObjectAt.name,
			AvailObject::class.java,
			Int::class.javaPrimitiveType!!)

		/**
		 * A [CheckedMethod] for invoking the method [extractDumpedLongAt].
		 */
		val extractDumpedLongAtMethod = instanceMethod(
			A_RegisterDump::class.java,
			A_RegisterDump::extractDumpedLongAt.name,
			Long::class.javaPrimitiveType!!,
			Int::class.javaPrimitiveType!!)
	}
}
