/*
 * Decompiled with CFR 0.152.
 */
package avail.descriptor.objects;

import avail.annotations.HideFieldInDebugger;
import avail.annotations.ThreadSafe;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.maps.A_Map;
import avail.descriptor.maps.MapDescriptor;
import avail.descriptor.objects.ObjectDescriptor;
import avail.descriptor.objects.ObjectLayoutVariant;
import avail.descriptor.objects.ObjectTypeDescriptor;
import avail.descriptor.objects.VettingsCache;
import avail.descriptor.pojos.RawPojoDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AbstractDescriptor;
import avail.descriptor.representation.AbstractSlotsEnum;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.AvailObjectFieldHelper;
import avail.descriptor.representation.AvailObjectRepresentation;
import avail.descriptor.representation.BitField;
import avail.descriptor.representation.Descriptor;
import avail.descriptor.representation.IntegerSlotsEnum;
import avail.descriptor.representation.Mutability;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.representation.ObjectSlotsEnum;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TypeTag;
import avail.optimizer.jvm.CheckedMethod;
import avail.optimizer.jvm.ReferencedInGeneratedCode;
import avail.serialization.SerializerOperation;
import avail.utility.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import org.availlang.json.JSONWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 A2\u00020\u0001:\u0003ABCB\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0000H\u0016J\b\u0010\u000e\u001a\u00020\u0000H\u0016J\u001b\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013H\u0016J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001a\u0010 \u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J(\u0010!\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\nH\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010(\u001a\u00020\u001f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010)\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020+2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010/\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u00100\u001a\u0002012\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\u0010\u00102\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u00103\u001a\u0002042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00105\u001a\u000206H\u0016J\u0018\u00107\u001a\u0002042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00105\u001a\u000206H\u0016J8\u00108\u001a\u0002042\u0006\u0010\u0012\u001a\u00020\u00132\n\u00109\u001a\u00060:j\u0002`;2\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020>0=2\u0006\u0010?\u001a\u00020\u001fH\u0016J\b\u0010@\u001a\u00020\u0000H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006D"}, d2={"Lavail/descriptor/objects/ObjectDescriptor;", "Lavail/descriptor/representation/Descriptor;", "mutability", "Lavail/descriptor/representation/Mutability;", "variant", "Lavail/descriptor/objects/ObjectLayoutVariant;", "(Lavail/descriptor/representation/Mutability;Lavail/descriptor/objects/ObjectLayoutVariant;)V", "getVariant", "()Lavail/descriptor/objects/ObjectLayoutVariant;", "allowsImmutableToMutableReferenceInField", "", "e", "Lavail/descriptor/representation/AbstractSlotsEnum;", "immutable", "mutable", "o_DescribeForDebugger", "", "Lavail/descriptor/representation/AvailObjectFieldHelper;", "self", "Lavail/descriptor/representation/AvailObject;", "(Lavail/descriptor/representation/AvailObject;)[Lavail/descriptor/representation/AvailObjectFieldHelper;", "o_Equals", "another", "Lavail/descriptor/representation/A_BasicObject;", "o_EqualsObject", "anObject", "o_FieldAt", "field", "Lavail/descriptor/atoms/A_Atom;", "o_FieldAtIndex", "index", "", "o_FieldAtOrNull", "o_FieldAtPuttingCanDestroy", "value", "canDestroy", "o_FieldMap", "Lavail/descriptor/maps/A_Map;", "o_FieldTuple", "Lavail/descriptor/tuples/A_Tuple;", "o_Hash", "o_IsInstanceOfKind", "aType", "Lavail/descriptor/types/A_Type;", "o_Kind", "o_NameForDebugger", "", "o_ObjectVariant", "o_SerializerOperation", "Lavail/serialization/SerializerOperation;", "o_ShowValueInNameForDebugger", "o_WriteSummaryTo", "", "writer", "Lorg/availlang/json/JSONWriter;", "o_WriteTo", "printObjectOnAvoidingIndent", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "recursionMap", "Ljava/util/IdentityHashMap;", "Ljava/lang/Void;", "indent", "shared", "Companion", "IntegerSlots", "ObjectSlots", "avail"})
public final class ObjectDescriptor
extends Descriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ObjectLayoutVariant variant;
    @NotNull
    private static final CheckedMethod setFieldMethod;
    @NotNull
    private static final CheckedMethod objectFromMapMethod;
    @NotNull
    private static final CheckedMethod createUninitializedObjectMethod;
    @NotNull
    private static final CheckedMethod staticObjectVariantIdMethod;

    public ObjectDescriptor(@NotNull Mutability mutability, @NotNull ObjectLayoutVariant variant) {
        Intrinsics.checkNotNullParameter((Object)((Object)mutability), (String)"mutability");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        super(mutability, TypeTag.OBJECT_TAG, ObjectSlots.class, IntegerSlots.class);
        this.variant = variant;
    }

    @NotNull
    public final ObjectLayoutVariant getVariant() {
        return this.variant;
    }

    @Override
    public boolean allowsImmutableToMutableReferenceInField(@NotNull AbstractSlotsEnum e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e == IntegerSlots.HASH_AND_MORE || e == ObjectSlots.KIND || e == ObjectSlots.TYPE_VETTINGS_CACHE;
    }

    @Override
    @NotNull
    public AvailObjectFieldHelper[] o_DescribeForDebugger(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        List fields = new ArrayList();
        fields.add(new AvailObjectFieldHelper(self, ObjectSlots.KIND, -1, self.slot(ObjectSlots.KIND), null, null, null, 112, null));
        List otherAtoms = new ArrayList();
        Map<A_Atom, Integer> $this$forEach$iv = this.variant.getFieldToSlotIndex();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<A_Atom, Integer>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<A_Atom, Integer> element$iv;
            Map.Entry<A_Atom, Integer> entry = element$iv = iterator2.next();
            boolean bl = false;
            A_Atom fieldKey = entry.getKey();
            int index2 = ((Number)entry.getValue()).intValue();
            if (index2 == 0) {
                otherAtoms.add(fieldKey);
                continue;
            }
            fields.add(new AvailObjectFieldHelper(self, AbstractDescriptor.DebuggerObjectSlots.DUMMY_DEBUGGER_SLOT, -1, self.slot(ObjectSlots.FIELD_VALUES_, index2), "FIELD " + A_Atom.Companion.getAtomName(fieldKey), null, null, 96, null));
        }
        List $this$sortBy$iv = fields;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    AvailObjectFieldHelper p0 = (AvailObjectFieldHelper)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)p0.nameForDebugger());
                    p0 = (AvailObjectFieldHelper)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)p0.nameForDebugger())));
                }
            });
        }
        if (!((Collection)otherAtoms).isEmpty()) {
            fields.add(new AvailObjectFieldHelper(self, AbstractDescriptor.DebuggerObjectSlots.DUMMY_DEBUGGER_SLOT, -1, ObjectTupleDescriptor.Companion.tupleFromList(otherAtoms), "SUBCLASS_FIELDS", null, null, 96, null));
        }
        Collection $this$toTypedArray$iv = fields;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        AvailObjectFieldHelper[] availObjectFieldHelperArray = thisCollection$iv.toArray(new AvailObjectFieldHelper[0]);
        Intrinsics.checkNotNull((Object)availObjectFieldHelperArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        return availObjectFieldHelperArray;
    }

    @Override
    public boolean o_Equals(@NotNull AvailObject self, @NotNull A_BasicObject another) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        return another.equalsObject(self);
    }

    @Override
    public boolean o_EqualsObject(@NotNull AvailObject self, @NotNull AvailObject anObject) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)anObject, (String)"anObject");
        if (self.sameAddressAs(anObject)) {
            return true;
        }
        if (this.variant != A_BasicObject.Companion.getObjectVariant(anObject)) {
            return false;
        }
        int myHash = self.slot(IntegerSlots.Companion.getHASH_OR_ZERO());
        int otherHash = anObject.slot(IntegerSlots.Companion.getHASH_OR_ZERO());
        if (myHash != 0 && otherHash == 0) {
            otherHash = anObject.hash();
        } else if (otherHash != 0 && myHash == 0) {
            myHash = self.hash();
        }
        if (myHash != otherHash) {
            return false;
        }
        int i = 1;
        int n = self.variableObjectSlotsCount();
        if (i <= n) {
            while (true) {
                if (!self.slot(ObjectSlots.FIELD_VALUES_, i).equals(anObject.slot(ObjectSlots.FIELD_VALUES_, i))) {
                    return false;
                }
                if (i == n) break;
                ++i;
            }
        }
        AvailObject kind2 = (AvailObject)A_BasicObject.Companion.ifNil((A_BasicObject)self.slot(ObjectSlots.KIND), (Function0)new Function0<AvailObject>(anObject){
            final /* synthetic */ AvailObject $anObject;
            {
                this.$anObject = $anObject;
                super(0);
            }

            @NotNull
            public final AvailObject invoke() {
                return this.$anObject.slot(ObjectSlots.KIND);
            }
        });
        if (!this.isShared()) {
            anObject.setSlot(ObjectSlots.KIND, kind2.makeImmutable());
            self.becomeIndirectionTo(anObject);
        } else if (!anObject.descriptor().isShared()) {
            self.setSlot(ObjectSlots.KIND, kind2.makeImmutable());
            anObject.becomeIndirectionTo(self);
        }
        return true;
    }

    @Override
    @NotNull
    public AvailObject o_FieldAt(@NotNull AvailObject self, @NotNull A_Atom field) {
        AvailObject availObject;
        Integer slotIndex;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Integer n = slotIndex = this.variant.getFieldToSlotIndex().get(field);
        if (n != null && n == 0) {
            availObject = (AvailObject)field;
        } else {
            ObjectSlotsEnum objectSlotsEnum = ObjectSlots.FIELD_VALUES_;
            Integer n2 = slotIndex;
            Intrinsics.checkNotNull((Object)n2);
            availObject = self.slot(objectSlotsEnum, (int)n2);
        }
        return availObject;
    }

    @Override
    @NotNull
    public AvailObject o_FieldAtIndex(@NotNull AvailObject self, int index2) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return self.slot(ObjectSlots.FIELD_VALUES_, index2);
    }

    @Override
    @Nullable
    public AvailObject o_FieldAtOrNull(@NotNull AvailObject self, @NotNull A_Atom field) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Integer slotIndex = this.variant.getFieldToSlotIndex().get(field);
        return slotIndex == null ? null : (slotIndex == 0 ? (AvailObject)field : self.slot(ObjectSlots.FIELD_VALUES_, (int)slotIndex));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public A_BasicObject o_FieldAtPuttingCanDestroy(@NotNull AvailObject self, @NotNull A_Atom field, @NotNull A_BasicObject value, boolean canDestroy) {
        AvailObject availObject;
        Integer slotIndex;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!canDestroy && this.isMutable()) {
            self.makeImmutable();
        }
        if ((slotIndex = this.variant.getFieldToSlotIndex().get(field)) == null) {
            void this_$iv;
            void indexedSlotCount$iv;
            AvailObject availObject2;
            A_Set newFieldsSet = A_Set.Companion.setWithElementCanDestroy(this.variant.getAllFields(), field, false);
            ObjectLayoutVariant newVariant = ObjectLayoutVariant.Companion.variantForFields(newFieldsSet);
            Map<A_Atom, Integer> newVariantSlotMap = newVariant.getFieldToSlotIndex();
            AbstractDescriptor abstractDescriptor = newVariant.getMutableObjectDescriptor();
            int n = newVariant.getRealSlotCount();
            boolean $i$f$create = false;
            AvailObject $this$o_FieldAtPuttingCanDestroy_u24lambda_u2d2 = availObject2 = AvailObject.Companion.newIndexedDescriptor((int)indexedSlotCount$iv, (AbstractDescriptor)this_$iv);
            boolean bl = false;
            Map<A_Atom, Integer> $this$forEach$iv = this.variant.getFieldToSlotIndex();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<A_Atom, Integer>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<A_Atom, Integer> element$iv;
                Map.Entry<A_Atom, Integer> entry = element$iv = iterator2.next();
                boolean bl2 = false;
                A_Atom key = entry.getKey();
                int value1 = ((Number)entry.getValue()).intValue();
                ObjectSlotsEnum objectSlotsEnum = ObjectSlots.FIELD_VALUES_;
                Integer n2 = newVariantSlotMap.get(key);
                Intrinsics.checkNotNull((Object)n2);
                $this$o_FieldAtPuttingCanDestroy_u24lambda_u2d2.setSlot(objectSlotsEnum, ((Number)n2).intValue(), self.slot(ObjectSlots.FIELD_VALUES_, value1));
            }
            Integer n3 = newVariantSlotMap.get(field);
            Intrinsics.checkNotNull((Object)n3);
            int newVariantSlotIndex = ((Number)n3).intValue();
            if (newVariantSlotIndex != 0) {
                $this$o_FieldAtPuttingCanDestroy_u24lambda_u2d2.setSlot(ObjectSlots.FIELD_VALUES_, newVariantSlotIndex, value);
            }
            $this$o_FieldAtPuttingCanDestroy_u24lambda_u2d2.setSlot(ObjectSlots.KIND, NilDescriptor.Companion.getNil());
            $this$o_FieldAtPuttingCanDestroy_u24lambda_u2d2.setSlot(ObjectSlots.TYPE_VETTINGS_CACHE, NilDescriptor.Companion.getNil());
            $this$o_FieldAtPuttingCanDestroy_u24lambda_u2d2.setSlot(IntegerSlots.Companion.getHASH_OR_ZERO(), 0);
            return availObject2;
        }
        if (slotIndex == 0) {
            boolean bl = value.equals(field);
            if (_Assertions.ENABLED && !bl) {
                String newVariant = "Assertion failed";
                throw new AssertionError((Object)newVariant);
            }
            return self;
        }
        AvailObject $this$o_FieldAtPuttingCanDestroy_u24lambda_u2d3 = availObject = canDestroy && this.isMutable() ? self : AvailObjectRepresentation.Companion.newLike(this.variant.getMutableObjectDescriptor(), self, 0, 0);
        boolean bl = false;
        $this$o_FieldAtPuttingCanDestroy_u24lambda_u2d3.setSlot(ObjectSlots.FIELD_VALUES_, (int)slotIndex, value);
        $this$o_FieldAtPuttingCanDestroy_u24lambda_u2d3.setSlot(ObjectSlots.KIND, NilDescriptor.Companion.getNil());
        $this$o_FieldAtPuttingCanDestroy_u24lambda_u2d3.setSlot(ObjectSlots.TYPE_VETTINGS_CACHE, NilDescriptor.Companion.getNil());
        $this$o_FieldAtPuttingCanDestroy_u24lambda_u2d3.setSlot(IntegerSlots.Companion.getHASH_OR_ZERO(), 0);
        return availObject;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public A_Map o_FieldMap(@NotNull AvailObject self) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Iterable iterable = this.variant.getFieldToSlotIndex().entrySet();
        A_Map initial$iv = MapDescriptor.Companion.getEmptyMap();
        boolean $i$f$fold = false;
        A_Map accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            A_Map map = accumulator$iv;
            boolean bl = false;
            A_Atom field = (A_Atom)entry.getKey();
            int slotIndex = ((Number)entry.getValue()).intValue();
            accumulator$iv = A_Map.Companion.mapAtPuttingCanDestroy(map, field, slotIndex == 0 ? field : (A_Atom)self.slot(ObjectSlots.FIELD_VALUES_, slotIndex), true);
        }
        return accumulator$iv;
    }

    @Override
    @NotNull
    public A_Tuple o_FieldTuple(@NotNull AvailObject self) {
        boolean bl;
        AvailObject availObject;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Iterator<Map.Entry<A_Atom, Integer>> fieldIterator = this.variant.getFieldToSlotIndex().entrySet().iterator();
        AvailObject it = availObject = ObjectTupleDescriptor.Companion.generateObjectTupleFrom(this.variant.getFieldToSlotIndex().size(), (Function1<? super Integer, ? extends A_BasicObject>)((Function1)new Function1<Integer, A_BasicObject>(fieldIterator, self){
            final /* synthetic */ Iterator<Map.Entry<A_Atom, Integer>> $fieldIterator;
            final /* synthetic */ AvailObject $self;
            {
                this.$fieldIterator = $fieldIterator;
                this.$self = $self;
                super(1);
            }

            @NotNull
            public final A_BasicObject invoke(int it) {
                Map.Entry<A_Atom, Integer> entry = this.$fieldIterator.next();
                A_Atom field = entry.getKey();
                int slotIndex = ((Number)entry.getValue()).intValue();
                return slotIndex == 0 ? (A_BasicObject)ObjectTupleDescriptor.Companion.tuple(field, field) : (A_BasicObject)ObjectTupleDescriptor.Companion.tuple(field, this.$self.slot(ObjectSlots.FIELD_VALUES_, slotIndex));
            }
        }));
        boolean bl2 = false;
        boolean bl3 = bl = !fieldIterator.hasNext();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return availObject;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int o_Hash(@NotNull AvailObject self) {
        int n;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        int $this$ifZero$iv = self.slot(IntegerSlots.Companion.getHASH_OR_ZERO());
        boolean $i$f$ifZero = false;
        if ($this$ifZero$iv != 0) {
            n = $this$ifZero$iv;
        } else {
            int n2;
            void $this$fold$iv;
            boolean bl = false;
            Iterable iterable = (Iterable)new IntRange(1, self.variableObjectSlotsCount());
            int initial$iv = AvailObject.Companion.combine2(this.variant.getVariantId(), -2102210345);
            boolean $i$f$fold = false;
            int accumulator$iv = initial$iv;
            Iterator iterator2 = $this$fold$iv.iterator();
            while (iterator2.hasNext()) {
                void i;
                int element$iv;
                int n3 = element$iv = ((IntIterator)iterator2).nextInt();
                int h = accumulator$iv;
                boolean bl2 = false;
                accumulator$iv = AvailObject.Companion.combine3(h, self.slot(ObjectSlots.FIELD_VALUES_, (int)i).hash(), 1560122342);
            }
            int it = n2 = accumulator$iv;
            boolean bl3 = false;
            self.setSlot(IntegerSlots.Companion.getHASH_OR_ZERO(), it);
            n = n2;
        }
        return n;
    }

    @Override
    public boolean o_IsInstanceOfKind(@NotNull AvailObject self, @NotNull A_Type aType) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)aType, (String)"aType");
        if (A_Type.Companion.isSupertypeOfPrimitiveTypeEnum(aType, PrimitiveTypeDescriptor.Types.NONTYPE)) {
            return true;
        }
        AvailObject typeTraversed = aType.traversed();
        AbstractDescriptor typeDescriptor = typeTraversed.descriptor();
        if (!(typeDescriptor instanceof ObjectTypeDescriptor)) {
            return false;
        }
        if (!typeDescriptor.isShared()) {
            return A_Type.Companion.hasObjectInstance(typeTraversed, self);
        }
        AvailObject cachePojo = self.slot(ObjectSlots.TYPE_VETTINGS_CACHE);
        if (cachePojo.isNil()) {
            cachePojo = RawPojoDescriptor.Companion.identityPojo(new VettingsCache()).makeShared();
            self.setSlot(ObjectSlots.TYPE_VETTINGS_CACHE, cachePojo);
        }
        VettingsCache cache2 = (VettingsCache)cachePojo.javaObjectNotNull();
        return cache2.testObjectAgainstType(self, typeTraversed);
    }

    @Override
    @NotNull
    public A_Type o_Kind(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        AvailObject kind2 = self.slot(ObjectSlots.KIND);
        if (kind2.getNotNil()) {
            return kind2;
        }
        self.makeImmutable();
        AvailObject objectType = this.variant.getMutableObjectTypeDescriptor().createFromObject(self);
        self.setSlot(ObjectSlots.KIND, this.isShared() ? objectType.makeShared() : objectType.makeImmutable());
        return objectType;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String o_NameForDebugger(@NotNull AvailObject self) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        StringBuilder $this$o_NameForDebugger_u24lambda_u2d10 = stringBuilder = new StringBuilder();
        boolean bl = false;
        AvailObject names = A_Tuple.Companion.component1(ObjectTypeDescriptor.Companion.namesAndBaseTypesForObjectType(self.kind()));
        $this$o_NameForDebugger_u24lambda_u2d10.append("a/an ");
        if (A_Set.Companion.getSetSize(names) == 0) {
            $this$o_NameForDebugger_u24lambda_u2d10.append("object");
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = names;
            StringBuilder stringBuilder2 = $this$o_NameForDebugger_u24lambda_u2d10;
            boolean $i$f$map = false;
            void var10_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                AvailObject availObject = (AvailObject)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(p0.asNativeString());
            }
            stringBuilder2.append(CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), (CharSequence)" \u2229 ", null, null, (int)0, null, null, (int)62, null));
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        String baseName = string2;
        return super.o_NameForDebugger(self) + " = " + baseName;
    }

    @Override
    @NotNull
    public ObjectLayoutVariant o_ObjectVariant(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return this.variant;
    }

    @Override
    @ThreadSafe
    @NotNull
    public SerializerOperation o_SerializerOperation(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return SerializerOperation.OBJECT;
    }

    @Override
    public boolean o_ShowValueInNameForDebugger(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void o_WriteTo(@NotNull AvailObject self, @NotNull JSONWriter writer) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        JSONWriter this_$iv = writer;
        boolean $i$f$writeObject = false;
        this_$iv.startObject();
        try {
            JSONWriter this_$iv2;
            JSONWriter $this$o_WriteTo_u24lambda_u2d15 = this_$iv;
            boolean bl = false;
            JSONWriter jSONWriter = $this$o_WriteTo_u24lambda_u2d15;
            String key$iv = "kind";
            boolean $i$f$at = false;
            this_$iv2.write(key$iv);
            void $this$o_WriteTo_u24lambda_u2d15_u24lambda_u2d11 = this_$iv2;
            boolean bl2 = false;
            $this$o_WriteTo_u24lambda_u2d15_u24lambda_u2d11.write("object");
            this_$iv2 = $this$o_WriteTo_u24lambda_u2d15;
            key$iv = "map";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$o_WriteTo_u24lambda_u2d15_u24lambda_u2d14 = this_$iv2;
            boolean bl3 = false;
            JSONWriter this_$iv3 = $this$o_WriteTo_u24lambda_u2d15_u24lambda_u2d14;
            boolean $i$f$writeObject2 = false;
            this_$iv3.startObject();
            try {
                JSONWriter $this$o_WriteTo_u24lambda_u2d15_u24lambda_u2d14_u24lambda_u2d13 = this_$iv3;
                boolean bl4 = false;
                Map<A_Atom, Integer> $this$forEach$iv = this.variant.getFieldToSlotIndex();
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<A_Atom, Integer>> iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<A_Atom, Integer> element$iv;
                    Map.Entry<A_Atom, Integer> entry = element$iv = iterator2.next();
                    boolean bl5 = false;
                    A_Atom field = entry.getKey();
                    int slotIndex = ((Number)entry.getValue()).intValue();
                    A_Atom value = slotIndex == 0 ? field : (A_Atom)self.slot(ObjectSlots.FIELD_VALUES_, slotIndex);
                    A_Atom.Companion.getAtomName(field).writeTo(writer);
                    value.writeTo(writer);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                this_$iv3.endObject();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.endObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void o_WriteSummaryTo(@NotNull AvailObject self, @NotNull JSONWriter writer) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        JSONWriter this_$iv = writer;
        boolean $i$f$writeObject = false;
        this_$iv.startObject();
        try {
            JSONWriter this_$iv2;
            JSONWriter $this$o_WriteSummaryTo_u24lambda_u2d20 = this_$iv;
            boolean bl = false;
            JSONWriter jSONWriter = $this$o_WriteSummaryTo_u24lambda_u2d20;
            String key$iv = "kind";
            boolean $i$f$at = false;
            this_$iv2.write(key$iv);
            void $this$o_WriteSummaryTo_u24lambda_u2d20_u24lambda_u2d16 = this_$iv2;
            boolean bl2 = false;
            $this$o_WriteSummaryTo_u24lambda_u2d20_u24lambda_u2d16.write("object");
            this_$iv2 = $this$o_WriteSummaryTo_u24lambda_u2d20;
            key$iv = "map";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$o_WriteSummaryTo_u24lambda_u2d20_u24lambda_u2d19 = this_$iv2;
            boolean bl3 = false;
            JSONWriter this_$iv3 = $this$o_WriteSummaryTo_u24lambda_u2d20_u24lambda_u2d19;
            boolean $i$f$writeObject2 = false;
            this_$iv3.startObject();
            try {
                JSONWriter $this$o_WriteSummaryTo_u24lambda_u2d20_u24lambda_u2d19_u24lambda_u2d18 = this_$iv3;
                boolean bl4 = false;
                Map<A_Atom, Integer> $this$forEach$iv = this.variant.getFieldToSlotIndex();
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<A_Atom, Integer>> iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<A_Atom, Integer> element$iv;
                    Map.Entry<A_Atom, Integer> entry = element$iv = iterator2.next();
                    boolean bl5 = false;
                    A_Atom field = entry.getKey();
                    int slotIndex = ((Number)entry.getValue()).intValue();
                    A_Atom value = slotIndex == 0 ? field : (A_Atom)self.slot(ObjectSlots.FIELD_VALUES_, slotIndex);
                    A_Atom.Companion.getAtomName(field).writeTo(writer);
                    value.writeSummaryTo(writer);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                this_$iv3.endObject();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.endObject();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void printObjectOnAvoidingIndent(@NotNull AvailObject self, @NotNull StringBuilder builder2, @NotNull IdentityHashMap<A_BasicObject, Void> recursionMap, int indent) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter(recursionMap, (String)"recursionMap");
        StringBuilder $this$printObjectOnAvoidingIndent_u24lambda_u2d23 = builder2;
        boolean bl = false;
        A_Tuple a_Tuple = ObjectTypeDescriptor.Companion.namesAndBaseTypesForObjectType(self.kind());
        AvailObject names = A_Tuple.Companion.component1(a_Tuple);
        AvailObject baseTypes = A_Tuple.Companion.component2(a_Tuple);
        $this$printObjectOnAvoidingIndent_u24lambda_u2d23.append("a/an ");
        if (A_Set.Companion.getSetSize(names) == 0) {
            $this$printObjectOnAvoidingIndent_u24lambda_u2d23.append("object");
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = names;
            StringBuilder stringBuilder = $this$printObjectOnAvoidingIndent_u24lambda_u2d23;
            boolean $i$f$map = false;
            void var13_14 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AvailObject availObject = (AvailObject)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.asNativeString());
            }
            stringBuilder.append(CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), (CharSequence)" \u2229 ", null, null, (int)0, null, null, (int)62, null));
        }
        A_Atom explicitSubclassingKey = AtomDescriptor.SpecialAtom.EXPLICIT_SUBCLASSING_KEY.getAtom();
        Ref.ObjectRef ignoreKeys = new Ref.ObjectRef();
        ignoreKeys.element = SetDescriptor.Companion.getEmptySet();
        Iterable $this$forEach$iv = baseTypes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AvailObject baseType = (AvailObject)element$iv;
            boolean bl3 = false;
            A_Map.Companion.forEach(A_Type.Companion.getFieldTypeMap(baseType), (Function2<? super AvailObject, ? super AvailObject, Unit>)((Function2)new Function2<AvailObject, AvailObject, Unit>(explicitSubclassingKey, (Ref.ObjectRef<A_Set>)ignoreKeys){
                final /* synthetic */ A_Atom $explicitSubclassingKey;
                final /* synthetic */ Ref.ObjectRef<A_Set> $ignoreKeys;
                {
                    this.$explicitSubclassingKey = $explicitSubclassingKey;
                    this.$ignoreKeys = $ignoreKeys;
                    super(2);
                }

                public final void invoke(@NotNull AvailObject k, @NotNull AvailObject availObject) {
                    Intrinsics.checkNotNullParameter((Object)k, (String)"k");
                    Intrinsics.checkNotNullParameter((Object)availObject, (String)"<anonymous parameter 1>");
                    if (A_Atom.Companion.getAtomProperty(k, this.$explicitSubclassingKey).getNotNil()) {
                        this.$ignoreKeys.element = A_Set.Companion.setWithElementCanDestroy((A_Set)this.$ignoreKeys.element, k, true);
                    }
                }
            }));
        }
        Ref.BooleanRef first = new Ref.BooleanRef();
        first.element = true;
        A_Map.Companion.forEach(self.fieldMap(), (Function2<? super AvailObject, ? super AvailObject, Unit>)((Function2)new Function2<AvailObject, AvailObject, Unit>((Ref.ObjectRef<A_Set>)ignoreKeys, $this$printObjectOnAvoidingIndent_u24lambda_u2d23, first, indent, builder2, recursionMap){
            final /* synthetic */ Ref.ObjectRef<A_Set> $ignoreKeys;
            final /* synthetic */ StringBuilder $this_with;
            final /* synthetic */ Ref.BooleanRef $first;
            final /* synthetic */ int $indent;
            final /* synthetic */ StringBuilder $builder;
            final /* synthetic */ IdentityHashMap<A_BasicObject, Void> $recursionMap;
            {
                this.$ignoreKeys = $ignoreKeys;
                this.$this_with = $receiver;
                this.$first = $first;
                this.$indent = $indent;
                this.$builder = $builder;
                this.$recursionMap = $recursionMap;
                super(2);
            }

            public final void invoke(@NotNull AvailObject key, @NotNull AvailObject value) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                if (!A_Set.Companion.hasElement((A_Set)this.$ignoreKeys.element, key)) {
                    this.$this_with.append(this.$first.element ? " with:" : ",");
                    this.$first.element = false;
                    Strings.INSTANCE.newlineTab(this.$this_with, this.$indent);
                    this.$this_with.append(A_Atom.Companion.getAtomName(key).asNativeString());
                    this.$this_with.append(" = ");
                    value.printOnAvoidingIndent(this.$builder, this.$recursionMap, this.$indent + 1);
                }
            }
        }));
    }

    @Override
    @NotNull
    public ObjectDescriptor mutable() {
        return this.variant.getMutableObjectDescriptor();
    }

    @Override
    @NotNull
    public ObjectDescriptor immutable() {
        return this.variant.getImmutableObjectDescriptor();
    }

    @Override
    @NotNull
    public ObjectDescriptor shared() {
        return this.variant.getSharedObjectDescriptor();
    }

    @ReferencedInGeneratedCode
    @JvmStatic
    @NotNull
    public static final AvailObject setField(@NotNull AvailObject self, int slotIndex, @NotNull A_BasicObject value) {
        return Companion.setField(self, slotIndex, value);
    }

    @ReferencedInGeneratedCode
    @JvmStatic
    @NotNull
    public static final AvailObject objectFromMap(@NotNull A_Map map) {
        return Companion.objectFromMap(map);
    }

    @ReferencedInGeneratedCode
    @JvmStatic
    @NotNull
    public static final AvailObject createUninitializedObject(@NotNull ObjectLayoutVariant variant) {
        return Companion.createUninitializedObject(variant);
    }

    @ReferencedInGeneratedCode
    @JvmStatic
    public static final int staticObjectVariantId(@NotNull AvailObject anObject) {
        return Companion.staticObjectVariantId(anObject);
    }

    static {
        Class[] classArray = new Class[3];
        classArray[0] = AvailObject.class;
        Intrinsics.checkNotNull(Integer.TYPE);
        classArray[2] = A_BasicObject.class;
        setFieldMethod = CheckedMethod.Companion.staticMethod(ObjectDescriptor.class, "setField", AvailObject.class, classArray);
        classArray = new Class[]{A_Map.class};
        objectFromMapMethod = CheckedMethod.Companion.staticMethod(ObjectDescriptor.class, "objectFromMap", AvailObject.class, classArray);
        classArray = new Class[]{ObjectLayoutVariant.class};
        createUninitializedObjectMethod = CheckedMethod.Companion.staticMethod(ObjectDescriptor.class, "createUninitializedObject", AvailObject.class, classArray);
        Class<Integer> clazz = Integer.TYPE;
        Intrinsics.checkNotNull(clazz);
        classArray = new Class[]{AvailObject.class};
        staticObjectVariantIdMethod = CheckedMethod.Companion.staticMethod(ObjectDescriptor.class, "staticObjectVariantId", clazz, classArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0001\u0018\u0000 \u00052\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004\u00a8\u0006\u0006"}, d2={"Lavail/descriptor/objects/ObjectDescriptor$IntegerSlots;", "", "Lavail/descriptor/representation/IntegerSlotsEnum;", "(Ljava/lang/String;I)V", "HASH_AND_MORE", "Companion", "avail"})
    public static final class IntegerSlots
    extends Enum<IntegerSlots>
    implements IntegerSlotsEnum {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private static final BitField HASH_OR_ZERO;
        public static final /* enum */ IntegerSlots HASH_AND_MORE;
        private static final /* synthetic */ IntegerSlots[] $VALUES;

        public static IntegerSlots[] values() {
            return (IntegerSlots[])$VALUES.clone();
        }

        public static IntegerSlots valueOf(String value) {
            return Enum.valueOf(IntegerSlots.class, value);
        }

        static {
            HASH_AND_MORE = new IntegerSlots();
            $VALUES = integerSlotsArray = new IntegerSlots[]{IntegerSlots.HASH_AND_MORE};
            Companion = new Companion(null);
            HASH_OR_ZERO = new BitField(HASH_AND_MORE, 0, 32, (Function1<? super Integer, String>)((Function1)Companion.HASH_OR_ZERO.1.INSTANCE));
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lavail/descriptor/objects/ObjectDescriptor$IntegerSlots$Companion;", "", "()V", "HASH_OR_ZERO", "Lavail/descriptor/representation/BitField;", "getHASH_OR_ZERO", "()Lavail/descriptor/representation/BitField;", "avail"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final BitField getHASH_OR_ZERO() {
                return HASH_OR_ZERO;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lavail/descriptor/objects/ObjectDescriptor$ObjectSlots;", "", "Lavail/descriptor/representation/ObjectSlotsEnum;", "(Ljava/lang/String;I)V", "KIND", "TYPE_VETTINGS_CACHE", "FIELD_VALUES_", "avail"})
    public static final class ObjectSlots
    extends Enum<ObjectSlots>
    implements ObjectSlotsEnum {
        public static final /* enum */ ObjectSlots KIND = new ObjectSlots();
        @HideFieldInDebugger
        public static final /* enum */ ObjectSlots TYPE_VETTINGS_CACHE = new ObjectSlots();
        public static final /* enum */ ObjectSlots FIELD_VALUES_ = new ObjectSlots();
        private static final /* synthetic */ ObjectSlots[] $VALUES;

        public static ObjectSlots[] values() {
            return (ObjectSlots[])$VALUES.clone();
        }

        public static ObjectSlots valueOf(String value) {
            return Enum.valueOf(ObjectSlots.class, value);
        }

        static {
            $VALUES = objectSlotsArray = new ObjectSlots[]{ObjectSlots.KIND, ObjectSlots.TYPE_VETTINGS_CACHE, ObjectSlots.FIELD_VALUES_};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0016\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u000e\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bJ \u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u000fH\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\u0006R\u0011\u0010\n\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0006R\u0011\u0010\f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0006\u00a8\u0006!"}, d2={"Lavail/descriptor/objects/ObjectDescriptor$Companion;", "", "()V", "createUninitializedObjectMethod", "Lavail/optimizer/jvm/CheckedMethod;", "getCreateUninitializedObjectMethod", "()Lavail/optimizer/jvm/CheckedMethod;", "objectFromMapMethod", "getObjectFromMapMethod$annotations", "getObjectFromMapMethod", "setFieldMethod", "getSetFieldMethod", "staticObjectVariantIdMethod", "getStaticObjectVariantIdMethod", "createUninitializedObject", "Lavail/descriptor/representation/AvailObject;", "variant", "Lavail/descriptor/objects/ObjectLayoutVariant;", "getField", "self", "slotIndex", "", "objectFromMap", "map", "Lavail/descriptor/maps/A_Map;", "objectFromTuple", "tuple", "Lavail/descriptor/tuples/A_Tuple;", "setField", "value", "Lavail/descriptor/representation/A_BasicObject;", "staticObjectVariantId", "anObject", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AvailObject getField(@NotNull AvailObject self, int slotIndex) {
            Intrinsics.checkNotNullParameter((Object)self, (String)"self");
            return self.slot(ObjectSlots.FIELD_VALUES_, slotIndex);
        }

        @ReferencedInGeneratedCode
        @JvmStatic
        @NotNull
        public final AvailObject setField(@NotNull AvailObject self, int slotIndex, @NotNull A_BasicObject value) {
            Intrinsics.checkNotNullParameter((Object)self, (String)"self");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            self.setSlot(ObjectSlots.FIELD_VALUES_, slotIndex, (AvailObject)value);
            return self;
        }

        @NotNull
        public final CheckedMethod getSetFieldMethod() {
            return setFieldMethod;
        }

        /*
         * WARNING - void declaration
         */
        @ReferencedInGeneratedCode
        @JvmStatic
        @NotNull
        public final AvailObject objectFromMap(@NotNull A_Map map) {
            void this_$iv;
            AvailObject availObject;
            Intrinsics.checkNotNullParameter((Object)map, (String)"map");
            ObjectLayoutVariant variant = ObjectLayoutVariant.Companion.variantForFields(A_Map.Companion.getKeysAsSet(map));
            ObjectDescriptor mutableDescriptor = variant.getMutableObjectDescriptor();
            Map<A_Atom, Integer> slotMap = variant.getFieldToSlotIndex();
            AbstractDescriptor abstractDescriptor = mutableDescriptor;
            int indexedSlotCount$iv = variant.getRealSlotCount();
            boolean $i$f$create = false;
            AvailObject $this$objectFromMap_u24lambda_u2d0 = availObject = AvailObject.Companion.newIndexedDescriptor(indexedSlotCount$iv, (AbstractDescriptor)this_$iv);
            boolean bl = false;
            A_Map.Companion.forEach(map, (Function2<? super AvailObject, ? super AvailObject, Unit>)((Function2)new Function2<AvailObject, AvailObject, Unit>(slotMap, $this$objectFromMap_u24lambda_u2d0){
                final /* synthetic */ Map<A_Atom, Integer> $slotMap;
                final /* synthetic */ AvailObject $this_create;
                {
                    this.$slotMap = $slotMap;
                    this.$this_create = $receiver;
                    super(2);
                }

                public final void invoke(@NotNull AvailObject key, @NotNull AvailObject value) {
                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    Integer n = this.$slotMap.get(key);
                    Intrinsics.checkNotNull((Object)n);
                    int slotIndex = ((Number)n).intValue();
                    if (slotIndex > 0) {
                        this.$this_create.setSlot(ObjectSlots.FIELD_VALUES_, slotIndex, value);
                    }
                }
            }));
            $this$objectFromMap_u24lambda_u2d0.setSlot(ObjectSlots.KIND, NilDescriptor.Companion.getNil());
            $this$objectFromMap_u24lambda_u2d0.setSlot(ObjectSlots.TYPE_VETTINGS_CACHE, NilDescriptor.Companion.getNil());
            $this$objectFromMap_u24lambda_u2d0.setSlot(IntegerSlots.Companion.getHASH_OR_ZERO(), 0);
            return availObject;
        }

        @NotNull
        public final CheckedMethod getObjectFromMapMethod() {
            return objectFromMapMethod;
        }

        public static /* synthetic */ void getObjectFromMapMethod$annotations() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final AvailObject objectFromTuple(@NotNull A_Tuple tuple2) {
            void $this$fold$iv;
            void initial$iv;
            Intrinsics.checkNotNullParameter((Object)tuple2, (String)"tuple");
            Iterable iterable = tuple2;
            A_Map a_Map = MapDescriptor.Companion.getEmptyMap();
            Companion companion = this;
            boolean $i$f$fold = false;
            A_Map accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                AvailObject availObject = (AvailObject)element$iv;
                void m = accumulator$iv;
                boolean bl = false;
                AvailObject atom = A_Tuple.Companion.component1(availObject);
                AvailObject value = A_Tuple.Companion.component2(availObject);
                accumulator$iv = A_Map.Companion.mapAtPuttingCanDestroy((A_Map)m, atom, value, true);
            }
            return companion.objectFromMap(accumulator$iv);
        }

        /*
         * WARNING - void declaration
         */
        @ReferencedInGeneratedCode
        @JvmStatic
        @NotNull
        public final AvailObject createUninitializedObject(@NotNull ObjectLayoutVariant variant) {
            void this_$iv;
            AvailObject availObject;
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            AbstractDescriptor abstractDescriptor = variant.getMutableObjectDescriptor();
            int indexedSlotCount$iv = variant.getRealSlotCount();
            boolean $i$f$create = false;
            AvailObject $this$createUninitializedObject_u24lambda_u2d2 = availObject = AvailObject.Companion.newIndexedDescriptor(indexedSlotCount$iv, (AbstractDescriptor)this_$iv);
            boolean bl = false;
            $this$createUninitializedObject_u24lambda_u2d2.setSlot(ObjectSlots.KIND, NilDescriptor.Companion.getNil());
            $this$createUninitializedObject_u24lambda_u2d2.setSlot(ObjectSlots.TYPE_VETTINGS_CACHE, NilDescriptor.Companion.getNil());
            $this$createUninitializedObject_u24lambda_u2d2.setSlot(IntegerSlots.Companion.getHASH_OR_ZERO(), 0);
            return availObject;
        }

        @NotNull
        public final CheckedMethod getCreateUninitializedObjectMethod() {
            return createUninitializedObjectMethod;
        }

        @ReferencedInGeneratedCode
        @JvmStatic
        public final int staticObjectVariantId(@NotNull AvailObject anObject) {
            Intrinsics.checkNotNullParameter((Object)anObject, (String)"anObject");
            return A_BasicObject.Companion.getObjectVariant(anObject).getVariantId();
        }

        @NotNull
        public final CheckedMethod getStaticObjectVariantIdMethod() {
            return staticObjectVariantIdMethod;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

