/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo.operation;

import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2NamedOperandType;
import avail.interpreter.levelTwo.L2OperandType;
import avail.interpreter.levelTwo.L2Operation;
import avail.interpreter.levelTwo.WritesHiddenVariable;
import avail.interpreter.levelTwo.operand.L2ArbitraryConstantOperand;
import avail.interpreter.levelTwo.operand.L2IntImmediateOperand;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2PcOperand;
import avail.interpreter.levelTwo.operation.L2ControlFlowOperation;
import avail.optimizer.jvm.JVMTranslator;
import avail.performance.Statistic;
import avail.performance.StatisticReport;
import avail.utility.Strings;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.MethodVisitor;

@WritesHiddenVariable(value={L2Operation.HiddenVariable.STACK_REIFIER.class})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0012H\u0016J \u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lavail/interpreter/levelTwo/operation/L2_REIFY;", "Lavail/interpreter/levelTwo/operation/L2ControlFlowOperation;", "()V", "hasSideEffect", "", "getHasSideEffect", "()Z", "appendToWithWarnings", "", "instruction", "Lavail/interpreter/levelTwo/L2Instruction;", "desiredTypes", "", "Lavail/interpreter/levelTwo/L2OperandType;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "warningStyleChange", "Lkotlin/Function1;", "translateToJVM", "translator", "Lavail/optimizer/jvm/JVMTranslator;", "method", "Lorg/objectweb/asm/MethodVisitor;", "StatisticCategory", "avail"})
public final class L2_REIFY
extends L2ControlFlowOperation {
    @NotNull
    public static final L2_REIFY INSTANCE = new L2_REIFY();

    private L2_REIFY() {
        L2NamedOperandType[] l2NamedOperandTypeArray = new L2NamedOperandType[]{L2OperandType.INT_IMMEDIATE.named("capture frames"), L2OperandType.INT_IMMEDIATE.named("process interrupt"), L2OperandType.ARBITRARY_CONSTANT.named("statistic"), L2OperandType.PC.named("on reification", L2NamedOperandType.Purpose.OFF_RAMP)};
        super(l2NamedOperandTypeArray);
    }

    @Override
    public boolean getHasSideEffect() {
        return true;
    }

    @Override
    public void appendToWithWarnings(@NotNull L2Instruction instruction2, @NotNull Set<? extends L2OperandType> desiredTypes, @NotNull StringBuilder builder2, @NotNull Function1<? super Boolean, Unit> warningStyleChange) {
        L2NamedOperandType type;
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        Intrinsics.checkNotNullParameter(desiredTypes, (String)"desiredTypes");
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter(warningStyleChange, (String)"warningStyleChange");
        boolean bl = Intrinsics.areEqual((Object)this, (Object)instruction2.getOperation());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2IntImmediateOperand actuallyReify = (L2IntImmediateOperand)instruction2.operand(0);
        L2IntImmediateOperand processInterrupt2 = (L2IntImmediateOperand)instruction2.operand(1);
        L2ArbitraryConstantOperand statisticConstant = (L2ArbitraryConstantOperand)instruction2.operand(2);
        Object object = statisticConstant.getConstant();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type avail.performance.Statistic");
        Statistic statistic = (Statistic)object;
        this.renderPreamble(instruction2, builder2);
        builder2.append(' ');
        builder2.append(statistic.name());
        if (actuallyReify.getValue() != 0 || processInterrupt2.getValue() != 0) {
            builder2.append(" [");
            if (actuallyReify.getValue() != 0) {
                builder2.append("actually reify");
                if (processInterrupt2.getValue() != 0) {
                    builder2.append(", ");
                }
            }
            if (processInterrupt2.getValue() != 0) {
                builder2.append("process interrupt");
            }
            builder2.append(']');
        }
        if (desiredTypes.contains((Object)(type = this.operandTypes()[3]).operandType())) {
            boolean bl2;
            Object operand = instruction2.operand(3);
            builder2.append("\n\t");
            boolean bl3 = bl2 = ((L2Operand)operand).getOperandType() == type.operandType();
            if (_Assertions.ENABLED && !bl2) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            builder2.append(type.name());
            builder2.append(" = ");
            builder2.append(Strings.INSTANCE.increaseIndentation(((L2Operand)operand).toString(), 1));
        }
    }

    @Override
    public void translateToJVM(@NotNull JVMTranslator translator, @NotNull MethodVisitor method, @NotNull L2Instruction instruction2) {
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        L2IntImmediateOperand actuallyReify = (L2IntImmediateOperand)instruction2.operand(0);
        L2IntImmediateOperand processInterrupt2 = (L2IntImmediateOperand)instruction2.operand(1);
        L2ArbitraryConstantOperand statisticConstant = (L2ArbitraryConstantOperand)instruction2.operand(2);
        L2PcOperand onReification = (L2PcOperand)instruction2.operand(3);
        translator.loadInterpreter(method);
        translator.literal(method, actuallyReify.getValue());
        translator.literal(method, processInterrupt2.getValue());
        Object object = statisticConstant.getConstant();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type avail.performance.Statistic");
        translator.literal(method, (Statistic)object);
        Interpreter.Companion.getReifyMethod().generateCall(method);
        method.visitVarInsn(58, translator.reifierLocal());
        translator.generateReificationPreamble(method, onReification);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0001\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\n"}, d2={"Lavail/interpreter/levelTwo/operation/L2_REIFY$StatisticCategory;", "", "(Ljava/lang/String;I)V", "statistic", "Lavail/performance/Statistic;", "getStatistic", "()Lavail/performance/Statistic;", "INTERRUPT_OFF_RAMP_IN_L2", "ABANDON_BEFORE_RESTART_IN_L2", "Companion", "avail"})
    public static final class StatisticCategory
    extends Enum<StatisticCategory> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final Statistic statistic = new Statistic(StatisticReport.REIFICATIONS, "Explicit L2_REIFY for " + this.name());
        @NotNull
        private static final StatisticCategory[] all;
        public static final /* enum */ StatisticCategory INTERRUPT_OFF_RAMP_IN_L2;
        public static final /* enum */ StatisticCategory ABANDON_BEFORE_RESTART_IN_L2;
        private static final /* synthetic */ StatisticCategory[] $VALUES;

        @NotNull
        public final Statistic getStatistic() {
            return this.statistic;
        }

        public static StatisticCategory[] values() {
            return (StatisticCategory[])$VALUES.clone();
        }

        public static StatisticCategory valueOf(String value) {
            return Enum.valueOf(StatisticCategory.class, value);
        }

        static {
            INTERRUPT_OFF_RAMP_IN_L2 = new StatisticCategory();
            ABANDON_BEFORE_RESTART_IN_L2 = new StatisticCategory();
            $VALUES = statisticCategoryArray = new StatisticCategory[]{StatisticCategory.INTERRUPT_OFF_RAMP_IN_L2, StatisticCategory.ABANDON_BEFORE_RESTART_IN_L2};
            Companion = new Companion(null);
            all = StatisticCategory.values();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tR\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\n"}, d2={"Lavail/interpreter/levelTwo/operation/L2_REIFY$StatisticCategory$Companion;", "", "()V", "all", "", "Lavail/interpreter/levelTwo/operation/L2_REIFY$StatisticCategory;", "[Lavail/interpreter/levelTwo/operation/L2_REIFY$StatisticCategory;", "lookup", "ordinal", "", "avail"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final StatisticCategory lookup(int ordinal) {
                return all[ordinal];
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

