/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.bootstrap.syntax;

import avail.descriptor.atoms.A_Atom;
import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.maps.A_Map;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lavail/interpreter/primitive/bootstrap/syntax/P_BootstrapPrefixStartOfBlock;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "avail"})
public final class P_BootstrapPrefixStartOfBlock
extends Primitive {
    @NotNull
    public static final P_BootstrapPrefixStartOfBlock INSTANCE = new P_BootstrapPrefixStartOfBlock();

    private P_BootstrapPrefixStartOfBlock() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.Bootstrap};
        super(0, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(0);
        if (A_Fiber.Companion.getAvailLoader(interpreter.fiber()) == null) {
            return interpreter.primitiveFailure(AvailErrorCode.E_LOADING_IS_OVER);
        }
        A_Atom clientDataGlobalKey = AtomDescriptor.SpecialAtom.CLIENT_DATA_GLOBAL_KEY.getAtom();
        A_Atom compilerScopeMapKey = AtomDescriptor.SpecialAtom.COMPILER_SCOPE_MAP_KEY.getAtom();
        A_Atom compilerScopeStackKey = AtomDescriptor.SpecialAtom.COMPILER_SCOPE_STACK_KEY.getAtom();
        A_Fiber fiber2 = interpreter.fiber();
        A_Map fiberGlobals = A_Fiber.Companion.getFiberGlobals(fiber2);
        A_Map clientData = A_Map.Companion.mapAt(fiberGlobals, clientDataGlobalKey);
        AvailObject bindings2 = A_Map.Companion.mapAt(clientData, compilerScopeMapKey);
        AvailObject availObject = A_Map.Companion.mapAtOrNull(clientData, compilerScopeStackKey);
        A_Tuple stack = availObject != null ? (A_Tuple)availObject : (A_Tuple)TupleDescriptor.Companion.getEmptyTuple();
        stack = A_Tuple.Companion.appendCanDestroy(stack, bindings2, false);
        clientData = A_Map.Companion.mapAtPuttingCanDestroy(clientData, compilerScopeStackKey, stack, true);
        A_Fiber.Companion.setFiberGlobals(fiber2, A_Map.Companion.mapAtPuttingCanDestroy(fiberGlobals, clientDataGlobalKey, clientData, true));
        return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, TupleDescriptor.Companion.getEmptyTuple(), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }
}

