/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.variables;

import avail.descriptor.methods.MethodDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.BottomTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.MapTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.VariableTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.VariableGetException;
import avail.exceptions.VariableSetException;
import avail.interpreter.Primitive;
import avail.interpreter.effects.LoadingEffectToRunPrimitive;
import avail.interpreter.execution.AvailLoader;
import avail.interpreter.execution.Interpreter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/variables/P_AtomicAddToMap;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_AtomicAddToMap
extends Primitive {
    @NotNull
    public static final P_AtomicAddToMap INSTANCE = new P_AtomicAddToMap();

    private P_AtomicAddToMap() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.HasSideEffect};
        super(3, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
            interpreter.checkArgumentCount(3);
            AvailObject variable = interpreter.argument(0);
            AvailObject key = interpreter.argument(1);
            AvailObject value = interpreter.argument(2);
            try {
                variable.atomicAddToMap(key, value);
            }
            catch (VariableGetException e) {
                return interpreter.primitiveFailure(e);
            }
            catch (VariableSetException e) {
                return interpreter.primitiveFailure(e);
            }
            AvailLoader availLoader = interpreter.availLoaderOrNull();
            if (availLoader == null) break block3;
            A_BasicObject[] a_BasicObjectArray = new A_BasicObject[]{variable, key, value};
            availLoader.recordEffect(new LoadingEffectToRunPrimitive(MethodDescriptor.SpecialMethodAtom.ADD_TO_MAP_VARIABLE.getBundle(), a_BasicObjectArray));
        }
        return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(VariableTypeDescriptor.Companion.variableReadWriteType(MapTypeDescriptor.Companion.mostGeneralMapType(), BottomTypeDescriptor.Companion.getBottom()), PrimitiveTypeDescriptor.Types.ANY.getO(), PrimitiveTypeDescriptor.Types.ANY.getO()), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_CANNOT_READ_UNASSIGNED_VARIABLE, AvailErrorCode.E_CANNOT_STORE_INCORRECTLY_TYPED_VALUE};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

