/*
 * Decompiled with CFR 0.152.
 */
package avail.optimizer;

import avail.AvailRuntimeSupport;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2NamedOperandType;
import avail.interpreter.levelTwo.L2Operation;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2PcOperand;
import avail.interpreter.levelTwo.operand.L2ReadOperand;
import avail.interpreter.levelTwo.operand.L2ReadVectorOperand;
import avail.interpreter.levelTwo.operand.L2WriteOperand;
import avail.interpreter.levelTwo.operation.L2_JUMP;
import avail.interpreter.levelTwo.operation.L2_JUMP_BACK;
import avail.interpreter.levelTwo.operation.L2_PHI_PSEUDO_OPERATION;
import avail.interpreter.levelTwo.register.L2Register;
import avail.optimizer.DataCouplingMode;
import avail.optimizer.DeadCodeAnalyzer;
import avail.optimizer.L2BasicBlock;
import avail.optimizer.L2ControlFlowGraph;
import avail.optimizer.L2Entity;
import avail.optimizer.L2EntityAndKind;
import avail.optimizer.L2Generator;
import avail.optimizer.L2Optimizer;
import avail.optimizer.L2RegisterColorer;
import avail.optimizer.OptimizationPhase;
import avail.optimizer.reoptimizer.L2Regenerator;
import avail.optimizer.values.L2SemanticValue;
import avail.performance.Statistic;
import avail.performance.StatisticReport;
import avail.utility.PublicCloneable;
import avail.utility.Strings;
import avail.utility.structures.EnumMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 C2\u00020\u0001:\u0002CDB\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0010\u001a\u00020\u0011J\u001c\u0010\u0012\u001a\u00020\u00112\u0014\u0010\u0013\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u00150\u0014J\b\u0010\u0017\u001a\u00020\u0011H\u0002J\b\u0010\u0018\u001a\u00020\u0011H\u0002J\b\u0010\u0019\u001a\u00020\u0011H\u0002J\u001c\u0010\u001a\u001a\u00020\u00112\u0014\u0010\u0013\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u00150\u0014J\u001c\u0010\u001b\u001a\u00020\u00112\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001dH\u0002J\b\u0010 \u001a\u00020\u0011H\u0002J\u001c\u0010!\u001a\u00020\u00112\u0014\u0010\u0013\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u00150\u0014J\u0006\u0010\"\u001a\u00020\u0011J\u0006\u0010#\u001a\u00020\u0011J\u0006\u0010$\u001a\u00020\u0011J\u0006\u0010%\u001a\u00020\u0011J\u0006\u0010&\u001a\u00020\u0011J\u000e\u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020\u0011J\u0006\u0010+\u001a\u00020\u0011J\u0006\u0010,\u001a\u00020\u0011J/\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020/2\u001d\u00100\u001a\u0019\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020\u001101\u00a2\u0006\u0002\b4H\u0002J\u0018\u00105\u001a\u00020\u00112\u0006\u00106\u001a\u0002072\b\b\u0002\u0010.\u001a\u00020/J\u0018\u00108\u001a\u00020/2\u0006\u00106\u001a\u0002072\u0006\u0010.\u001a\u00020/H\u0002J\u0006\u00109\u001a\u00020\u0011J\u0006\u0010:\u001a\u00020/J\u0006\u0010;\u001a\u00020\u0011J\u0006\u0010<\u001a\u00020\u0011J\u0006\u0010=\u001a\u00020\u0011J\u0010\u0010>\u001a\u00020\u00112\u0006\u0010(\u001a\u00020)H\u0002J\u001c\u0010?\u001a\u00020\u00112\u0014\u0010\u0013\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u00150\u0014J\b\u0010@\u001a\u00020AH\u0016J\u0006\u0010B\u001a\u00020\u0011R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006E"}, d2={"Lavail/optimizer/L2Optimizer;", "", "generator", "Lavail/optimizer/L2Generator;", "(Lavail/optimizer/L2Generator;)V", "blocks", "", "Lavail/optimizer/L2BasicBlock;", "getBlocks", "()Ljava/util/List;", "colorer", "Lavail/optimizer/L2RegisterColorer;", "controlFlowGraph", "Lavail/optimizer/L2ControlFlowGraph;", "getGenerator", "()Lavail/optimizer/L2Generator;", "adjustEdgesLeadingToJumps", "", "check", "flags", "", "Lkotlin/reflect/KClass;", "Lavail/optimizer/L2ControlFlowGraph$StateFlag;", "checkBlocksAndInstructions", "checkEdgesAndPhis", "checkEntryPoints", "checkNot", "checkRegistersAreInitialized", "registerIdFunction", "Lkotlin/Function1;", "Lavail/interpreter/levelTwo/register/L2Register;", "", "checkUniqueOperands", "clear", "coalesceNoninterferingMoves", "computeColors", "computeInterferenceGraph", "computeLivenessAtEachEdge", "insertPhiMoves", "optimize", "interpreter", "Lavail/interpreter/execution/Interpreter;", "orderBlocks", "postOptimizationCleanup", "postponeConditionallyUsedValues", "regenerateGraph", "generatePhis", "", "transformer", "Lkotlin/Function2;", "Lavail/optimizer/reoptimizer/L2Regenerator;", "Lavail/interpreter/levelTwo/L2Instruction;", "Lkotlin/ExtensionFunctionType;", "removeDeadCode", "dataCouplingMode", "Lavail/optimizer/DataCouplingMode;", "removeDeadInstructions", "removeSameColorMoves", "removeUnreachableBlocks", "replaceConstantRegisters", "replacePlaceholderInstructions", "replaceRegistersByColor", "sanityCheck", "set", "toString", "", "transformToEdgeSplitSSA", "Companion", "UsedRegisters", "avail"})
public final class L2Optimizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final L2Generator generator;
    @NotNull
    private final L2ControlFlowGraph controlFlowGraph;
    @NotNull
    private final List<L2BasicBlock> blocks;
    @Nullable
    private L2RegisterColorer colorer;
    private static boolean shouldSanityCheck;
    @NotNull
    private static final Statistic sanityCheckStat;

    public L2Optimizer(@NotNull L2Generator generator) {
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        this.generator = generator;
        this.controlFlowGraph = this.generator.getControlFlowGraph();
        this.blocks = this.controlFlowGraph.getBasicBlockOrder();
    }

    @NotNull
    public final L2Generator getGenerator() {
        return this.generator;
    }

    @NotNull
    public final List<L2BasicBlock> getBlocks() {
        return this.blocks;
    }

    public final void set(@NotNull Collection<? extends KClass<? extends L2ControlFlowGraph.StateFlag>> flags) {
        Intrinsics.checkNotNullParameter(flags, (String)"flags");
        this.controlFlowGraph.set(flags);
    }

    public final void clear(@NotNull Collection<? extends KClass<? extends L2ControlFlowGraph.StateFlag>> flags) {
        Intrinsics.checkNotNullParameter(flags, (String)"flags");
        this.controlFlowGraph.clear(flags);
    }

    public final void check(@NotNull Collection<? extends KClass<? extends L2ControlFlowGraph.StateFlag>> flags) {
        Intrinsics.checkNotNullParameter(flags, (String)"flags");
        this.controlFlowGraph.check(flags);
    }

    public final void checkNot(@NotNull Collection<? extends KClass<? extends L2ControlFlowGraph.StateFlag>> flags) {
        Intrinsics.checkNotNullParameter(flags, (String)"flags");
        this.controlFlowGraph.checkNot(flags);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean removeUnreachableBlocks() {
        void $this$filterTo$iv;
        Iterable iterable = this.blocks;
        Collection destination$iv = new ArrayDeque();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            L2BasicBlock it = (L2BasicBlock)element$iv;
            boolean bl = false;
            if (!it.isIrremovable()) continue;
            destination$iv.add(element$iv);
        }
        ArrayDeque blocksToVisit = (ArrayDeque)destination$iv;
        Set reachableBlocks = new LinkedHashSet();
        while (!blocksToVisit.isEmpty()) {
            L2BasicBlock block = (L2BasicBlock)blocksToVisit.removeLast();
            if (reachableBlocks.contains(block)) continue;
            reachableBlocks.add(block);
            Iterable $this$mapTo$iv = block.successorEdges();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                L2PcOperand bl = (L2PcOperand)item$iv;
                Collection collection = blocksToVisit;
                boolean bl2 = false;
                collection.add(it.targetBlock());
            }
        }
        Set unreachableBlocks = CollectionsKt.toMutableSet((Iterable)this.blocks);
        TypeIntrinsics.asMutableCollection((Object)unreachableBlocks).removeAll(reachableBlocks);
        for (L2BasicBlock block : unreachableBlocks) {
            Iterable $this$forEach$iv = block.instructions();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                L2Instruction it = (L2Instruction)element$iv;
                boolean bl = false;
                it.justRemoved();
            }
            block.instructions().clear();
        }
        boolean changed = TypeIntrinsics.asMutableCollection((Object)this.blocks).retainAll(reachableBlocks);
        if (changed) {
            for (L2BasicBlock block : this.blocks) {
                boolean bl;
                block10: {
                    if (!block.isLoopHead()) continue;
                    Iterable $this$none$iv = block.predecessorEdges();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            L2PcOperand p0 = (L2PcOperand)element$iv;
                            boolean bl3 = false;
                            if (!p0.isBackward()) continue;
                            bl = false;
                            break block10;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                block.setLoopHead(false);
            }
        }
        return changed;
    }

    private final boolean removeDeadInstructions(DataCouplingMode dataCouplingMode, boolean generatePhis) {
        DeadCodeAnalyzer analyzer = new DeadCodeAnalyzer(dataCouplingMode, this.controlFlowGraph);
        analyzer.analyzeReads();
        Set<L2Instruction> liveInstructions = analyzer.liveInstructions();
        Ref.BooleanRef anyRemoved = new Ref.BooleanRef();
        this.regenerateGraph(generatePhis, (Function2<? super L2Regenerator, ? super L2Instruction, Unit>)((Function2)new Function2<L2Regenerator, L2Instruction, Unit>(liveInstructions, anyRemoved){
            final /* synthetic */ Set<L2Instruction> $liveInstructions;
            final /* synthetic */ Ref.BooleanRef $anyRemoved;
            {
                this.$liveInstructions = $liveInstructions;
                this.$anyRemoved = $anyRemoved;
                super(2);
            }

            public final void invoke(@NotNull L2Regenerator $this$regenerateGraph, @NotNull L2Instruction sourceInstruction) {
                Intrinsics.checkNotNullParameter((Object)$this$regenerateGraph, (String)"$this$regenerateGraph");
                Intrinsics.checkNotNullParameter((Object)sourceInstruction, (String)"sourceInstruction");
                if (this.$liveInstructions.contains(sourceInstruction)) {
                    $this$regenerateGraph.basicProcessInstruction(sourceInstruction);
                } else {
                    this.$anyRemoved.element = true;
                }
            }
        }));
        return anyRemoved.element;
    }

    public final void removeDeadCode(@NotNull DataCouplingMode dataCouplingMode, boolean generatePhis) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)dataCouplingMode), (String)"dataCouplingMode");
        this.removeUnreachableBlocks();
        if (!this.removeDeadInstructions(dataCouplingMode, generatePhis)) {
            return;
        }
        Map visibleRegisters = new LinkedHashMap();
        Map visibleSemanticValues = new LinkedHashMap();
        Iterable $this$deepForEach$iv = this.blocks;
        boolean $i$f$deepForEach = false;
        Iterable $this$forEach$iv$iv = $this$deepForEach$iv;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object t;
            Object b$iv = t = iterator2.next();
            boolean bl = false;
            L2BasicBlock p0 = (L2BasicBlock)b$iv;
            boolean bl2 = false;
            Iterable $this$forEach$iv$iv2 = p0.predecessorEdges();
            boolean $i$f$forEach2 = false;
            for (Object element$iv$iv2 : $this$forEach$iv$iv2) {
                L2PcOperand it = (L2PcOperand)element$iv$iv2;
                boolean bl3 = false;
                visibleRegisters.put(it, (Set)new LinkedHashSet());
                visibleSemanticValues.put(it, (Set)new LinkedHashSet());
            }
        }
        Deque toVisitQueue = new ArrayDeque(this.blocks);
        Set toVisitSet = CollectionsKt.toMutableSet((Iterable)this.blocks);
        while (!((Collection)toVisitQueue).isEmpty()) {
            Object e = toVisitQueue.removeFirst();
            Intrinsics.checkNotNull(e);
            L2BasicBlock block = (L2BasicBlock)e;
            toVisitSet.remove(block);
            Set regs = null;
            Set values = null;
            Iterator<L2PcOperand> iterator3 = block.predecessorEdges().iterator();
            if (iterator3.hasNext()) {
                L2PcOperand first = iterator3.next();
                Object v = visibleRegisters.get(first);
                Intrinsics.checkNotNull(v);
                regs = CollectionsKt.toMutableSet((Iterable)((Iterable)v));
                Object v2 = visibleSemanticValues.get(first);
                Intrinsics.checkNotNull(v2);
                values = CollectionsKt.toMutableSet((Iterable)((Iterable)v2));
                iterator3.forEachRemaining(arg_0 -> L2Optimizer.removeDeadCode$lambda-5(regs, visibleRegisters, values, visibleSemanticValues, arg_0));
            } else {
                regs = new LinkedHashSet();
                values = new LinkedHashSet();
            }
            for (L2Instruction instruction2 : block.instructions()) {
                if (!instruction2.getAltersControlFlow()) {
                    Iterable $this$forEach$iv = instruction2.getWriteOperands();
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv : $this$forEach$iv) {
                        L2WriteOperand it = (L2WriteOperand)element$iv;
                        boolean bl = false;
                        regs.add(it.register());
                        values.addAll((Collection)it.semanticValues());
                    }
                    continue;
                }
                instruction2.edgesAndPurposesDo((Function2<? super L2PcOperand, ? super L2NamedOperandType.Purpose, Unit>)((Function2)new Function2<L2PcOperand, L2NamedOperandType.Purpose, Unit>((Set<L2Register>)regs, (Set<L2SemanticValue>)values, instruction2, (Map<L2PcOperand, Set<L2Register>>)visibleRegisters, (Map<L2PcOperand, Set<L2SemanticValue>>)visibleSemanticValues, (Set<L2BasicBlock>)toVisitSet, (Deque<L2BasicBlock>)toVisitQueue){
                    final /* synthetic */ Set<L2Register> $regs;
                    final /* synthetic */ Set<L2SemanticValue> $values;
                    final /* synthetic */ L2Instruction $instruction;
                    final /* synthetic */ Map<L2PcOperand, Set<L2Register>> $visibleRegisters;
                    final /* synthetic */ Map<L2PcOperand, Set<L2SemanticValue>> $visibleSemanticValues;
                    final /* synthetic */ Set<L2BasicBlock> $toVisitSet;
                    final /* synthetic */ Deque<L2BasicBlock> $toVisitQueue;
                    {
                        this.$regs = $regs;
                        this.$values = $values;
                        this.$instruction = $instruction;
                        this.$visibleRegisters = $visibleRegisters;
                        this.$visibleSemanticValues = $visibleSemanticValues;
                        this.$toVisitSet = $toVisitSet;
                        this.$toVisitQueue = $toVisitQueue;
                        super(2);
                    }

                    public final void invoke(@NotNull L2PcOperand edge2, @Nullable L2NamedOperandType.Purpose purpose) {
                        Intrinsics.checkNotNullParameter((Object)edge2, (String)"edge");
                        Set regsForEdge = CollectionsKt.toMutableSet((Iterable)this.$regs);
                        Set valuesForEdge = CollectionsKt.toMutableSet((Iterable)this.$values);
                        L2NamedOperandType.Purpose purpose2 = purpose;
                        Intrinsics.checkNotNull((Object)((Object)purpose2));
                        this.$instruction.writesForPurposeDo(purpose2, (Function1)new Function1<L2WriteOperand<?>, Unit>((Set<L2Register>)regsForEdge, (Set<L2SemanticValue>)valuesForEdge){
                            final /* synthetic */ Set<L2Register> $regsForEdge;
                            final /* synthetic */ Set<L2SemanticValue> $valuesForEdge;
                            {
                                this.$regsForEdge = $regsForEdge;
                                this.$valuesForEdge = $valuesForEdge;
                                super(1);
                            }

                            public final void invoke(@NotNull L2WriteOperand<?> it) {
                                Intrinsics.checkNotNullParameter(it, (String)"it");
                                this.$regsForEdge.add((L2Register)it.register());
                                this.$valuesForEdge.addAll((Collection<L2SemanticValue>)it.semanticValues());
                            }
                        });
                        Set<L2Register> set2 = this.$visibleRegisters.get(edge2);
                        Intrinsics.checkNotNull(set2);
                        boolean changed = set2.addAll(regsForEdge);
                        Set<L2SemanticValue> set3 = this.$visibleSemanticValues.get(edge2);
                        Intrinsics.checkNotNull(set3);
                        if ((changed |= set3.addAll(valuesForEdge)) && this.$toVisitSet.add(edge2.targetBlock())) {
                            this.$toVisitQueue.add(edge2.targetBlock());
                        }
                    }
                }));
            }
        }
        Map $this$forEach$iv = visibleRegisters;
        $i$f$forEach = false;
        for (Map.Entry entry : $this$forEach$iv.entrySet()) {
            object = entry;
            boolean bl = false;
            L2PcOperand edge2 = (L2PcOperand)object.getKey();
            Set regs = (Set)object.getValue();
            edge2.manifest().retainRegisters(regs);
        }
        $this$forEach$iv = visibleSemanticValues;
        $i$f$forEach = false;
        for (Map.Entry entry : $this$forEach$iv.entrySet()) {
            object = entry;
            boolean bl = false;
            L2PcOperand edge2 = (L2PcOperand)object.getKey();
            Set values = (Set)object.getValue();
            edge2.manifest().retainSemanticValues(values);
        }
    }

    public static /* synthetic */ void removeDeadCode$default(L2Optimizer l2Optimizer, DataCouplingMode dataCouplingMode, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        l2Optimizer.removeDeadCode(dataCouplingMode, bl);
    }

    public final void transformToEdgeSplitSSA() {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.blocks);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            L2BasicBlock sourceBlock = (L2BasicBlock)element$iv;
            boolean bl = false;
            if (sourceBlock.successorEdges().size() <= 1) continue;
            Iterable $this$forEach$iv2 = sourceBlock.successorEdges();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                L2PcOperand edge2 = (L2PcOperand)element$iv2;
                boolean bl2 = false;
                L2BasicBlock targetBlock = edge2.targetBlock();
                if (targetBlock.predecessorEdges().size() <= 1) continue;
                L2BasicBlock newBlock = edge2.splitEdgeWith(this.controlFlowGraph);
                this.blocks.add(this.blocks.indexOf(targetBlock), newBlock);
            }
        }
    }

    public final void computeLivenessAtEachEdge() {
        int n;
        Iterable $this$deepForEach$iv = this.blocks;
        boolean $i$f$deepForEach = false;
        Iterable $this$forEach$iv$iv = $this$deepForEach$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv;
            Object b$iv = element$iv$iv = iterator2.next();
            n = 0;
            L2BasicBlock $this$computeLivenessAtEachEdge_u24lambda_u2d11 = (L2BasicBlock)b$iv;
            boolean bl = false;
            Iterable $this$forEach$iv$iv2 = $this$computeLivenessAtEachEdge_u24lambda_u2d11.predecessorEdges();
            boolean $i$f$forEach2 = false;
            for (Object element$iv$iv2 : $this$forEach$iv$iv2) {
                L2PcOperand predecessor = (L2PcOperand)element$iv$iv2;
                boolean bl2 = false;
                predecessor.getAlwaysLiveInRegisters().clear();
                predecessor.getSometimesLiveInRegisters().clear();
            }
        }
        ArrayDeque<L2BasicBlock> workQueue = new ArrayDeque<L2BasicBlock>((Collection)this.blocks);
        Set workSet = CollectionsKt.toMutableSet((Iterable)this.blocks);
        while (!workQueue.isEmpty()) {
            L2BasicBlock block = (L2BasicBlock)workQueue.removeLast();
            workSet.remove(block);
            Set alwaysLive = new LinkedHashSet();
            if (!((Collection)block.successorEdges()).isEmpty()) {
                alwaysLive.addAll((Collection)block.successorEdges().get(0).getAlwaysLiveInRegisters());
            }
            Set sometimesLive = new LinkedHashSet();
            Iterable $this$forEach$iv = block.successorEdges();
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv) {
                L2PcOperand edge2 = (L2PcOperand)element$iv;
                boolean bl = false;
                sometimesLive.addAll((Collection)edge2.getSometimesLiveInRegisters());
                alwaysLive.retainAll((Collection)edge2.getAlwaysLiveInRegisters());
            }
            List<L2Instruction> instructions = block.instructions();
            int lastPhiIndex = -1;
            n = instructions.size() + -1;
            if (0 <= n) {
                do {
                    int i;
                    L2Instruction instruction2;
                    if ((instruction2 = instructions.get(i = n--)).getOperation().isPhi()) {
                        lastPhiIndex = i;
                        break;
                    }
                    sometimesLive.removeAll((Collection)instruction2.getDestinationRegisters());
                    sometimesLive.addAll((Collection)instruction2.getSourceRegisters());
                    alwaysLive.removeAll((Collection)instruction2.getDestinationRegisters());
                    alwaysLive.addAll((Collection)instruction2.getSourceRegisters());
                } while (0 <= n);
            }
            int finalLastPhiIndex = lastPhiIndex;
            int edgeIndex = 0;
            Iterable $this$forEach$iv2 = block.predecessorEdges();
            boolean $i$f$forEach4 = false;
            for (Object element$iv : $this$forEach$iv2) {
                L2BasicBlock predecessor;
                L2PcOperand edge3 = (L2PcOperand)element$iv;
                boolean bl = false;
                Set edgeAlwaysLiveIn = CollectionsKt.toMutableSet((Iterable)alwaysLive);
                Set edgeSometimesLiveIn = CollectionsKt.toMutableSet((Iterable)sometimesLive);
                for (int i = finalLastPhiIndex; -1 < i; --i) {
                    L2Instruction phiInstruction = instructions.get(i);
                    L2Operation $this$cast$iv = phiInstruction.getOperation();
                    boolean $i$f$cast = false;
                    L2_PHI_PSEUDO_OPERATION phiOperation = (L2_PHI_PSEUDO_OPERATION)$this$cast$iv;
                    edgeSometimesLiveIn.removeAll((Collection)phiInstruction.getDestinationRegisters());
                    edgeAlwaysLiveIn.removeAll((Collection)phiInstruction.getDestinationRegisters());
                    List sources = phiOperation.sourceRegisterReads(phiInstruction);
                    Object source2 = ((L2ReadOperand)sources.get(edgeIndex)).register();
                    edgeSometimesLiveIn.add(source2);
                    edgeAlwaysLiveIn.add(source2);
                }
                L2PcOperand predecessorEdge = block.predecessorEdges().get(edgeIndex);
                boolean changed = predecessorEdge.getSometimesLiveInRegisters().addAll(edgeSometimesLiveIn);
                if ((changed |= predecessorEdge.getAlwaysLiveInRegisters().addAll(edgeAlwaysLiveIn)) && !workSet.contains(predecessor = edge3.sourceBlock())) {
                    workQueue.addFirst(predecessor);
                    workSet.add(predecessor);
                }
                ++edgeIndex;
            }
        }
    }

    public final void replaceConstantRegisters() {
    }

    public final void postponeConditionallyUsedValues() {
        this.regenerateGraph(true, (Function2<? super L2Regenerator, ? super L2Instruction, Unit>)((Function2)postponeConditionallyUsedValues.1.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    private final void regenerateGraph(boolean generatePhis, Function2<? super L2Regenerator, ? super L2Instruction, Unit> transformer) {
        void $this$associateTo$iv$iv;
        L2ControlFlowGraph oldGraph = new L2ControlFlowGraph();
        this.controlFlowGraph.evacuateTo(oldGraph);
        Iterable $this$associate$iv = this.generator.getSpecialBlocks().entrySet();
        boolean $i$f$associate22 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            L2Generator.SpecialBlock s = (L2Generator.SpecialBlock)((Object)entry.getKey());
            L2BasicBlock b = (L2BasicBlock)entry.getValue();
            entry = TuplesKt.to((Object)b, (Object)((Object)s));
            map.put(entry.getFirst(), entry.getSecond());
        }
        Map inverseSpecialBlockMap = destination$iv$iv;
        L2Generator $i$f$associate22 = this.generator;
        L2Regenerator regenerator2 = new L2Regenerator(generatePhis, transformer, $i$f$associate22){
            final /* synthetic */ Function2<L2Regenerator, L2Instruction, Unit> $transformer;
            {
                this.$transformer = $transformer;
                super($super_call_param$1, $generatePhis);
            }

            public void processInstruction(@NotNull L2Instruction sourceInstruction) {
                Intrinsics.checkNotNullParameter((Object)sourceInstruction, (String)"sourceInstruction");
                if (!sourceInstruction.getOperation().isPhi()) {
                    this.$transformer.invoke((Object)this, (Object)sourceInstruction);
                }
            }
        };
        regenerator2.getInverseSpecialBlockMap().clear();
        regenerator2.getInverseSpecialBlockMap().putAll(inverseSpecialBlockMap);
        this.generator.getSpecialBlocks().clear();
        L2BasicBlock originalStartBlock = oldGraph.getBasicBlockOrder().get(0);
        L2BasicBlock start = new L2BasicBlock(originalStartBlock.name(), false, null, 6, null);
        start.makeIrremovable();
        this.generator.startBlock(start, generatePhis, regenerator2);
        regenerator2.processSourceGraphStartingAt(originalStartBlock.instructions().get(0));
    }

    public final void replacePlaceholderInstructions() {
        boolean bl;
        block8: {
            Iterable $this$all$iv = this.blocks;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    boolean bl2;
                    block7: {
                        L2BasicBlock it = (L2BasicBlock)element$iv;
                        boolean bl3 = false;
                        Iterable $this$all$iv2 = it.instructions();
                        boolean $i$f$all2 = false;
                        if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                            bl2 = true;
                        } else {
                            for (Object element$iv2 : $this$all$iv2) {
                                L2Instruction i = (L2Instruction)element$iv2;
                                boolean bl4 = false;
                                if (!i.isPlaceholder()) continue;
                                bl2 = false;
                                break block7;
                            }
                            bl2 = true;
                        }
                    }
                    if (bl2) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        this.regenerateGraph(true, (Function2<? super L2Regenerator, ? super L2Instruction, Unit>)((Function2)replacePlaceholderInstructions.2.INSTANCE));
    }

    public final void insertPhiMoves() {
        for (L2BasicBlock block : this.blocks) {
            L2Instruction instruction2;
            Iterator<L2Instruction> instructionIterator = block.instructions().iterator();
            while (instructionIterator.hasNext() && (instruction2 = instructionIterator.next()).getOperation().isPhi()) {
                boolean bl;
                L2Operation $this$cast$iv = instruction2.getOperation();
                boolean $i$f$cast = false;
                L2_PHI_PSEUDO_OPERATION phiOperation = (L2_PHI_PSEUDO_OPERATION)$this$cast$iv;
                List phiSources = phiOperation.sourceRegisterReads(instruction2);
                int fanIn = block.predecessorEdges().size();
                boolean bl2 = bl = fanIn == phiSources.size();
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                Object targetWriter = phiOperation.destinationRegisterWrite(instruction2);
                for (int i = 0; i < fanIn; ++i) {
                    Set<L2EntityAndKind> clamped;
                    L2PcOperand edge2 = block.predecessorEdges().get(i);
                    L2BasicBlock predecessor = edge2.sourceBlock();
                    List<L2Instruction> instructions = predecessor.instructions();
                    boolean bl3 = predecessor.finalInstruction().getOperation().isUnconditionalJump();
                    if (_Assertions.ENABLED && !bl3) {
                        String string3 = "Assertion failed";
                        throw new AssertionError((Object)string3);
                    }
                    L2ReadOperand sourceRead = (L2ReadOperand)phiSources.get(i);
                    L2Operand[] l2OperandArray = new L2Operand[]{sourceRead, (L2Operand)((PublicCloneable)targetWriter).clone()};
                    L2Instruction move = new L2Instruction(predecessor, (L2Operation)phiOperation.getMoveOperation(), l2OperandArray);
                    predecessor.insertInstruction(instructions.size() - 1, move);
                    if (edge2.isBackward()) {
                        edge2.manifest().replaceDefinitions((L2WriteOperand<?>)phiOperation.getMoveOperation().destinationOf(move));
                    } else {
                        edge2.manifest().recordDefinitionNoCheck((L2WriteOperand<?>)phiOperation.getMoveOperation().destinationOf(move));
                    }
                    if (edge2.getForcedClampedEntities() == null) continue;
                    Intrinsics.checkNotNull(edge2.getForcedClampedEntities());
                    if (clamped.remove(new L2EntityAndKind(sourceRead.semanticValue(), sourceRead.getRegisterKind()))) {
                        Iterable $this$forEach$iv = ((L2WriteOperand)targetWriter).semanticValues();
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            L2SemanticValue it = (L2SemanticValue)element$iv;
                            boolean bl4 = false;
                            clamped.add(new L2EntityAndKind(it, ((L2WriteOperand)targetWriter).getRegisterKind()));
                        }
                    }
                    if (!clamped.remove(new L2EntityAndKind((L2Entity)sourceRead.register(), sourceRead.getRegisterKind()))) continue;
                    clamped.add(new L2EntityAndKind((L2Entity)((L2WriteOperand)targetWriter).register(), ((L2WriteOperand)targetWriter).getRegisterKind()));
                }
                instructionIterator.remove();
                instruction2.justRemoved();
            }
        }
    }

    public final void computeInterferenceGraph() {
        this.computeLivenessAtEachEdge();
        L2RegisterColorer l2RegisterColorer = this.colorer = new L2RegisterColorer(this.controlFlowGraph);
        Intrinsics.checkNotNull((Object)l2RegisterColorer);
        l2RegisterColorer.computeInterferenceGraph();
    }

    public final void coalesceNoninterferingMoves() {
        L2RegisterColorer l2RegisterColorer = this.colorer;
        Intrinsics.checkNotNull((Object)l2RegisterColorer);
        l2RegisterColorer.coalesceNoninterferingMoves();
    }

    public final void computeColors() {
        L2RegisterColorer l2RegisterColorer = this.colorer;
        Intrinsics.checkNotNull((Object)l2RegisterColorer);
        l2RegisterColorer.computeColors();
        this.colorer = null;
    }

    public final void replaceRegistersByColor() {
        boolean $i$f$forEach;
        Iterable $this$forEach$iv$iv;
        boolean bl;
        Object b$iv;
        Object element$iv$iv;
        EnumMap.Companion this_$iv = EnumMap.Companion;
        boolean $i$f$enumMap = false;
        T[] TArray = L2Register.RegisterKind.class.getEnumConstants();
        Intrinsics.checkNotNullExpressionValue(TArray, (String)"K::class.java.enumConstants");
        EnumMap byKindAndIndex = new EnumMap((Enum[])TArray);
        Map remap = new LinkedHashMap();
        Set oldRegisters = new LinkedHashSet();
        Function1 action2 = (Function1)new Function1<L2Register, Unit>((Map<L2Register, L2Register>)remap, (EnumMap<L2Register.RegisterKind, Map<Integer, L2Register>>)byKindAndIndex, (Set<L2Register>)oldRegisters){
            final /* synthetic */ Map<L2Register, L2Register> $remap;
            final /* synthetic */ EnumMap<L2Register.RegisterKind, Map<Integer, L2Register>> $byKindAndIndex;
            final /* synthetic */ Set<L2Register> $oldRegisters;
            {
                this.$remap = $remap;
                this.$byKindAndIndex = $byKindAndIndex;
                this.$oldRegisters = $oldRegisters;
                super(1);
            }

            public final void invoke(@NotNull L2Register reg) {
                Intrinsics.checkNotNullParameter((Object)reg, (String)"reg");
                Map<L2Register, L2Register> map = this.$remap;
                L2Register l2Register = this.$byKindAndIndex.getOrPut((L2Register.RegisterKind)((Enum)reg.getRegisterKind()), (Function1<L2Register.RegisterKind, Map<Integer, L2Register>>)((Function1)replaceRegistersByColor.action.1.INSTANCE)).computeIfAbsent(reg.finalIndex(), arg_0 -> replaceRegistersByColor.action.1.invoke$lambda-0(reg, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)l2Register, (String)"byKindAndIndex\n\t\t\t\t.getO\u2026reg.copyAfterColoring() }");
                L2Register l2Register2 = l2Register;
                map.put(reg, l2Register2);
                this.$oldRegisters.add(reg);
            }

            private static final L2Register invoke$lambda-0(L2Register $reg, Integer it) {
                Intrinsics.checkNotNullParameter((Object)$reg, (String)"$reg");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return $reg.copyAfterColoring();
            }
        };
        Iterable $this$deepForEach$iv = this.blocks;
        boolean $i$f$deepForEach = false;
        Iterable $this$forEach$iv$iv2 = $this$deepForEach$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            b$iv = element$iv$iv = iterator2.next();
            bl = false;
            L2BasicBlock $this$replaceRegistersByColor_u24lambda_u2d19 = (L2BasicBlock)b$iv;
            boolean bl2 = false;
            $this$forEach$iv$iv = $this$replaceRegistersByColor_u24lambda_u2d19.instructions();
            $i$f$forEach = false;
            for (Object element$iv$iv2 : $this$forEach$iv$iv) {
                L2Instruction instruction2 = (L2Instruction)element$iv$iv2;
                boolean bl3 = false;
                Iterable $this$forEach$iv = instruction2.getSourceRegisters();
                boolean $i$f$forEach3 = false;
                for (Object element$iv : $this$forEach$iv) {
                    action2.invoke(element$iv);
                }
                $this$forEach$iv = instruction2.getDestinationRegisters();
                $i$f$forEach3 = false;
                for (Object element$iv : $this$forEach$iv) {
                    action2.invoke(element$iv);
                }
            }
        }
        $this$deepForEach$iv = this.blocks;
        $i$f$deepForEach = false;
        $this$forEach$iv$iv2 = $this$deepForEach$iv;
        $i$f$forEach2 = false;
        iterator2 = $this$forEach$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            b$iv = element$iv$iv = iterator2.next();
            bl = false;
            L2BasicBlock $this$replaceRegistersByColor_u24lambda_u2d21 = (L2BasicBlock)b$iv;
            boolean bl4 = false;
            $this$forEach$iv$iv = $this$replaceRegistersByColor_u24lambda_u2d21.instructions();
            $i$f$forEach = false;
            for (Object element$iv$iv2 : $this$forEach$iv$iv) {
                L2Instruction it = (L2Instruction)element$iv$iv2;
                boolean bl5 = false;
                it.replaceRegisters(remap);
            }
        }
        Iterable $this$forEach$iv = oldRegisters;
        boolean $i$f$forEach4 = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl6;
            L2Register r = (L2Register)element$iv;
            boolean bl7 = false;
            boolean bl8 = bl6 = r.uses().isEmpty() && r.definitions().isEmpty();
            if (!_Assertions.ENABLED || bl6) continue;
            boolean bl9 = false;
            String string2 = "OBSOLETE register still refers to instructions";
            throw new AssertionError((Object)string2);
        }
    }

    public final void removeSameColorMoves() {
        for (L2BasicBlock block : this.blocks) {
            Iterator<L2Instruction> iterator2 = block.instructions().iterator();
            while (iterator2.hasNext()) {
                L2Instruction instruction2 = iterator2.next();
                if (!instruction2.getOperation().isMove() || instruction2.getSourceRegisters().get(0).finalIndex() != instruction2.getDestinationRegisters().get(0).finalIndex()) continue;
                iterator2.remove();
                instruction2.justRemoved();
            }
        }
    }

    public final void adjustEdgesLeadingToJumps() {
        boolean changed = false;
        do {
            changed = false;
            Iterator<L2BasicBlock> blockIterator = this.blocks.iterator();
            while (blockIterator.hasNext()) {
                L2PcOperand l2PcOperand;
                L2BasicBlock block = blockIterator.next();
                if (block.isLoopHead() || block.instructions().size() != 1) continue;
                L2Instruction soleInstruction = block.finalInstruction();
                if (soleInstruction.getOperation() == L2_JUMP.INSTANCE) {
                    l2PcOperand = L2_JUMP.jumpTarget(soleInstruction);
                } else {
                    if (soleInstruction.getOperation() != L2_JUMP_BACK.INSTANCE) continue;
                    l2PcOperand = L2_JUMP_BACK.jumpTarget(soleInstruction);
                }
                L2PcOperand jumpEdge = l2PcOperand;
                L2BasicBlock jumpTarget = jumpEdge.targetBlock();
                boolean isBackward = jumpEdge.isBackward();
                for (L2PcOperand inEdge : CollectionsKt.toList((Iterable)block.predecessorEdges())) {
                    changed = true;
                    inEdge.switchTargetBlockNonSSA(jumpTarget, isBackward);
                }
                boolean bl = block.predecessorEdges().isEmpty();
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                if (block.isIrremovable()) continue;
                block.instructions().clear();
                soleInstruction.justRemoved();
                blockIterator.remove();
            }
        } while (changed);
    }

    public final void orderBlocks() {
        boolean bl;
        Map countdowns = new LinkedHashMap();
        for (L2BasicBlock block : this.blocks) {
            countdowns.put(block, new AtomicInteger(block.predecessorEdges().size()));
        }
        List order = new ArrayList();
        boolean block = this.blocks.get(0).predecessorEdges().isEmpty();
        if (_Assertions.ENABLED && !block) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        Deque zeroed = new ArrayDeque();
        int n = this.blocks.size() + -1;
        if (0 <= n) {
            do {
                int i;
                if (!this.blocks.get(i = n--).predecessorEdges().isEmpty()) continue;
                zeroed.add(this.blocks.get(i));
            } while (0 <= n);
        }
        n = Intrinsics.areEqual(zeroed.getLast(), (Object)this.blocks.get(0)) ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String i = "Assertion failed";
            throw new AssertionError((Object)i);
        }
        while (!countdowns.isEmpty()) {
            if (!((Collection)zeroed).isEmpty()) {
                L2BasicBlock block2 = (L2BasicBlock)zeroed.removeLast();
                Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"block");
                order.add(block2);
                Iterable $this$forEach$iv = block2.successorEdges();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    L2PcOperand edge2 = (L2PcOperand)element$iv;
                    boolean bl2 = false;
                    AtomicInteger countdown = (AtomicInteger)countdowns.get(edge2.targetBlock());
                    if (countdown == null || countdown.decrementAndGet() != 0) continue;
                    countdowns.remove(edge2.targetBlock());
                    zeroed.add(edge2.targetBlock());
                }
                continue;
            }
            L2BasicBlock victim = null;
            for (Map.Entry entry : countdowns.entrySet()) {
                L2BasicBlock key = (L2BasicBlock)entry.getKey();
                AtomicInteger value = (AtomicInteger)entry.getValue();
                if (value.get() >= key.predecessorEdges().size()) continue;
                victim = key;
                break;
            }
            if (victim == null) {
                victim = (L2BasicBlock)CollectionsKt.first((Iterable)countdowns.keySet());
            }
            countdowns.remove(victim);
            zeroed.add(victim);
        }
        boolean bl3 = bl = order.size() == this.blocks.size();
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        bl = Intrinsics.areEqual(order.get(0), (Object)this.blocks.get(0));
        if (_Assertions.ENABLED && !bl) {
            String string4 = "Assertion failed";
            throw new AssertionError((Object)string4);
        }
        this.blocks.clear();
        this.blocks.addAll(order);
    }

    public final void postOptimizationCleanup() {
        Iterable $this$deepForEach$iv = this.blocks;
        boolean $i$f$deepForEach = false;
        Iterable $this$forEach$iv$iv = $this$deepForEach$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv;
            Object b$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            L2BasicBlock $this$postOptimizationCleanup_u24lambda_u2d26 = (L2BasicBlock)b$iv;
            boolean bl2 = false;
            Iterable $this$forEach$iv$iv2 = $this$postOptimizationCleanup_u24lambda_u2d26.instructions();
            boolean $i$f$forEach2 = false;
            for (Object element$iv$iv2 : $this$forEach$iv$iv2) {
                L2Instruction p0 = (L2Instruction)element$iv$iv2;
                boolean bl3 = false;
                p0.postOptimizationCleanup();
            }
        }
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u2d28 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (L2BasicBlock block : this.blocks) {
            $this$toString_u24lambda_u2d28.append(block.name());
            $this$toString_u24lambda_u2d28.append(":\n");
            for (L2Instruction instruction2 : block.instructions()) {
                $this$toString_u24lambda_u2d28.append('\t');
                $this$toString_u24lambda_u2d28.append(Strings.INSTANCE.increaseIndentation(instruction2.toString(), 1));
                $this$toString_u24lambda_u2d28.append('\n');
            }
            $this$toString_u24lambda_u2d28.append('\n');
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    private final void checkBlocksAndInstructions() {
        Map uses2 = new LinkedHashMap();
        Map definitions = new LinkedHashMap();
        Iterable $this$deepForEach$iv = this.blocks;
        boolean $i$f$deepForEach = false;
        Iterable $this$forEach$iv$iv = $this$deepForEach$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv;
            Object b$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            L2BasicBlock $this$checkBlocksAndInstructions_u24lambda_u2d29 = (L2BasicBlock)b$iv;
            boolean bl2 = false;
            Iterable $this$forEach$iv$iv2 = $this$checkBlocksAndInstructions_u24lambda_u2d29.instructions();
            boolean $i$f$forEach2 = false;
            for (Object element$iv$iv2 : $this$forEach$iv$iv2) {
                Set answer$iv;
                Object value$iv;
                Map $this$getOrPut$iv;
                boolean $i$f$getOrPut;
                Object key$iv;
                L2Operand it;
                L2Instruction instruction2 = (L2Instruction)element$iv$iv2;
                boolean bl3 = false;
                instruction2.assertHasBeenEmitted();
                Iterable $this$forEach$iv = instruction2.getReadOperands();
                boolean $i$f$forEach3 = false;
                for (Object element$iv : $this$forEach$iv) {
                    Object object;
                    it = (L2ReadOperand)element$iv;
                    boolean bl4 = false;
                    Map map = uses2;
                    key$iv = ((L2ReadOperand)it).register();
                    $i$f$getOrPut = false;
                    value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl5 = false;
                        answer$iv = new LinkedHashSet();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ((Set)object).add(it);
                }
                $this$forEach$iv = instruction2.getWriteOperands();
                $i$f$forEach3 = false;
                for (Object element$iv : $this$forEach$iv) {
                    Object object;
                    it = (L2WriteOperand)element$iv;
                    boolean bl6 = false;
                    $this$getOrPut$iv = definitions;
                    key$iv = ((L2WriteOperand)it).register();
                    $i$f$getOrPut = false;
                    value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl7 = false;
                        answer$iv = new LinkedHashSet();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ((Set)object).add(it);
                }
            }
        }
        Set mentionedRegs = CollectionsKt.toMutableSet((Iterable)uses2.keySet());
        mentionedRegs.addAll(definitions.keySet());
        Set myEmptySet = SetsKt.emptySet();
        for (L2Register reg : mentionedRegs) {
            String string2;
            Set set2 = (Set)uses2.get(reg);
            if (set2 == null) {
                set2 = myEmptySet;
            }
            boolean bl = Intrinsics.areEqual((Object)set2, reg.uses());
            if (_Assertions.ENABLED && !bl) {
                string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            Set set3 = (Set)definitions.get(reg);
            if (set3 == null) {
                set3 = myEmptySet;
            }
            bl = Intrinsics.areEqual((Object)set3, reg.definitions());
            if (!_Assertions.ENABLED || bl) continue;
            string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
    }

    private final void checkUniqueOperands() {
        Set allOperands = new LinkedHashSet();
        Iterable $this$deepForEach$iv = this.blocks;
        boolean $i$f$deepForEach = false;
        Iterable $this$forEach$iv$iv = $this$deepForEach$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv;
            Object b$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            L2BasicBlock $this$checkUniqueOperands_u24lambda_u2d35 = (L2BasicBlock)b$iv;
            boolean bl2 = false;
            Iterable $this$forEach$iv$iv2 = $this$checkUniqueOperands_u24lambda_u2d35.instructions();
            boolean $i$f$forEach2 = false;
            for (Object element$iv$iv2 : $this$forEach$iv$iv2) {
                L2Instruction instruction2 = (L2Instruction)element$iv$iv2;
                boolean bl3 = false;
                L2Operand[] $this$forEach$iv = instruction2.getOperands();
                boolean $i$f$forEach3 = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    L2Operand element$iv;
                    L2Operand operand = element$iv = $this$forEach$iv[i];
                    boolean bl4 = false;
                    boolean added = allOperands.add(operand);
                    if (_Assertions.ENABLED && !added) {
                        String string2 = "Assertion failed";
                        throw new AssertionError((Object)string2);
                    }
                    if (!(operand instanceof L2ReadVectorOperand)) continue;
                    Iterable $this$forEach$iv2 = ((L2ReadVectorOperand)operand).getElements();
                    boolean $i$f$forEach4 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        L2ReadOperand it = (L2ReadOperand)element$iv2;
                        boolean bl5 = false;
                        boolean ok = allOperands.add(it);
                        if (!_Assertions.ENABLED || ok) continue;
                        String string3 = "Assertion failed";
                        throw new AssertionError((Object)string3);
                    }
                }
            }
        }
    }

    private final void checkEdgesAndPhis() {
        for (L2BasicBlock block : this.blocks) {
            boolean bl;
            List allEdgesFromBlock = new ArrayList();
            for (L2Instruction l2Instruction : block.instructions()) {
                boolean bl2;
                boolean bl3 = bl2 = !l2Instruction.getOperation().isPhi() || l2Instruction.getSourceRegisters().size() == block.predecessorEdges().size();
                if (_Assertions.ENABLED && !bl2) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                allEdgesFromBlock.addAll((Collection)l2Instruction.getTargetEdges());
            }
            boolean bl4 = Intrinsics.areEqual(block.successorEdges(), (Object)allEdgesFromBlock);
            if (_Assertions.ENABLED && !bl4) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            bl4 = Intrinsics.areEqual((Object)CollectionsKt.toSet((Iterable)allEdgesFromBlock), (Object)CollectionsKt.toSet((Iterable)block.successorEdges()));
            if (_Assertions.ENABLED && !bl4) {
                String string4 = "Assertion failed";
                throw new AssertionError((Object)string4);
            }
            Iterable $this$forEach$iv = block.successorEdges();
            boolean bl5 = false;
            for (Object element$iv : $this$forEach$iv) {
                L2PcOperand edge2 = (L2PcOperand)element$iv;
                boolean bl52 = false;
                boolean bl6 = Intrinsics.areEqual((Object)edge2.sourceBlock(), (Object)block);
                if (_Assertions.ENABLED && !bl6) {
                    String string5 = "Assertion failed";
                    throw new AssertionError((Object)string5);
                }
                L2BasicBlock targetBlock = edge2.targetBlock();
                boolean bl7 = bl = !edge2.isBackward() || targetBlock.isLoopHead();
                if (_Assertions.ENABLED && !bl) {
                    String string8 = "Assertion failed";
                    throw new AssertionError((Object)string8);
                }
                bl = this.blocks.contains(targetBlock);
                if (_Assertions.ENABLED && !bl) {
                    String string9 = "Assertion failed";
                    throw new AssertionError((Object)string9);
                }
                bl = targetBlock.predecessorEdges().contains(edge2);
                if (!_Assertions.ENABLED || bl) continue;
                String string6 = "Assertion failed";
                throw new AssertionError((Object)string6);
            }
            $this$forEach$iv = block.predecessorEdges();
            boolean bl8 = false;
            for (Object element$iv : $this$forEach$iv) {
                L2PcOperand inEdge = (L2PcOperand)element$iv;
                boolean bl82 = false;
                boolean targetBlock = Intrinsics.areEqual((Object)inEdge.targetBlock(), (Object)block);
                if (_Assertions.ENABLED && !targetBlock) {
                    String string7 = "Assertion failed";
                    throw new AssertionError((Object)string7);
                }
                L2BasicBlock predecessorBlock = inEdge.sourceBlock();
                bl = this.blocks.contains(predecessorBlock);
                if (_Assertions.ENABLED && !bl) {
                    String string8 = "Assertion failed";
                    throw new AssertionError((Object)string8);
                }
                bl = predecessorBlock.successorEdges().contains(inEdge);
                if (!_Assertions.ENABLED || bl) continue;
                String string9 = "Assertion failed";
                throw new AssertionError((Object)string9);
            }
        }
    }

    private final void checkRegistersAreInitialized(Function1<? super L2Register, Integer> registerIdFunction) {
        Deque blocksToCheck = new ArrayDeque();
        blocksToCheck.add(TuplesKt.to((Object)this.blocks.get(0), (Object)new UsedRegisters()));
        Map inSets = new HashMap();
        while (!blocksToCheck.isEmpty()) {
            Pair pair = (Pair)blocksToCheck.removeLast();
            L2BasicBlock block = (L2BasicBlock)pair.getFirst();
            UsedRegisters newUsed = (UsedRegisters)pair.getSecond();
            UsedRegisters checked = (UsedRegisters)inSets.get(block);
            if (checked == null) {
                checked = new UsedRegisters(newUsed);
                inSets.put(block, checked);
            } else if (!checked.restrictTo(newUsed)) continue;
            UsedRegisters workingSet = new UsedRegisters(checked);
            for (L2Instruction instruction2 : block.instructions()) {
                if (instruction2.getOperation().isPhi()) continue;
                for (L2Register register : instruction2.getSourceRegisters()) {
                    workingSet.readRegister(register, registerIdFunction);
                }
                for (L2Register register : instruction2.getDestinationRegisters()) {
                    workingSet.writeRegister(register, registerIdFunction);
                }
            }
            Iterable $this$forEach$iv = block.successorEdges();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                L2PcOperand edge2 = (L2PcOperand)element$iv;
                boolean bl = false;
                UsedRegisters workingCopy = new UsedRegisters(workingSet);
                L2BasicBlock targetBlock = edge2.targetBlock();
                int predecessorIndex = targetBlock.predecessorEdges().indexOf(edge2);
                if (predecessorIndex == -1) {
                    System.err.println("Phi predecessor not found");
                    if (_Assertions.ENABLED) {
                        boolean $i$a$-assert-L2Optimizer$checkRegistersAreInitialized$1$22 = false;
                        String $i$a$-assert-L2Optimizer$checkRegistersAreInitialized$1$22 = "Phi predecessor not found";
                        throw new AssertionError((Object)$i$a$-assert-L2Optimizer$checkRegistersAreInitialized$1$22);
                    }
                }
                for (L2Instruction phiInTarget : targetBlock.instructions()) {
                    if (!phiInTarget.getOperation().isPhi()) break;
                    L2Register phiSource = phiInTarget.getSourceRegisters().get(predecessorIndex);
                    workingCopy.readRegister(phiSource, registerIdFunction);
                    workingCopy.writeRegister(phiInTarget.getDestinationRegisters().get(0), registerIdFunction);
                }
                blocksToCheck.add(TuplesKt.to((Object)targetBlock, (Object)workingCopy));
            }
        }
    }

    private final void checkEntryPoints() {
        Iterable $this$forEach$iv = this.blocks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            L2BasicBlock b = (L2BasicBlock)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = b.instructions();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                boolean bl2;
                L2Instruction it = (L2Instruction)element$iv2;
                boolean bl3 = false;
                boolean bl4 = bl2 = !it.isEntryPoint() || Intrinsics.areEqual((Object)b.instructions().get(0), (Object)it);
                if (!_Assertions.ENABLED || bl2) continue;
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
        }
    }

    private final void sanityCheck(Interpreter interpreter) {
        if (shouldSanityCheck) {
            long before = AvailRuntimeSupport.INSTANCE.captureNanos();
            this.checkBlocksAndInstructions();
            this.checkUniqueOperands();
            this.checkEdgesAndPhis();
            this.checkRegistersAreInitialized((Function1<? super L2Register, Integer>)((Function1)sanityCheck.1.INSTANCE));
            this.checkEntryPoints();
            long after = AvailRuntimeSupport.INSTANCE.captureNanos();
            sanityCheckStat.record(after - before, interpreter.getInterpreterIndex());
        }
    }

    public final void optimize(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        try {
            this.sanityCheck(interpreter);
            for (OptimizationPhase phase : OptimizationPhase.values()) {
                long before = AvailRuntimeSupport.INSTANCE.captureNanos();
                phase.run(this);
                long after = AvailRuntimeSupport.INSTANCE.captureNanos();
                phase.getStat().record(after - before, interpreter.getInterpreterIndex());
                this.sanityCheck(interpreter);
            }
        }
        catch (Throwable e) {
            System.err.println("Unrecoverable problem during optimization.");
            throw e;
        }
    }

    private static final void removeDeadCode$lambda-5(Set $regs, Map $visibleRegisters, Set $values, Map $visibleSemanticValues, L2PcOperand it) {
        Intrinsics.checkNotNullParameter((Object)$regs, (String)"$regs");
        Intrinsics.checkNotNullParameter((Object)$visibleRegisters, (String)"$visibleRegisters");
        Intrinsics.checkNotNullParameter((Object)$values, (String)"$values");
        Intrinsics.checkNotNullParameter((Object)$visibleSemanticValues, (String)"$visibleSemanticValues");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object v = $visibleRegisters.get(it);
        Intrinsics.checkNotNull(v);
        $regs.retainAll((Collection)v);
        Object v2 = $visibleSemanticValues.get(it);
        Intrinsics.checkNotNull(v2);
        $values.retainAll((Collection)v2);
    }

    static {
        sanityCheckStat = new Statistic(StatisticReport.L2_OPTIMIZATION_TIME, "(Sanity check)");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\fJ\"\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00120\u0011J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0000J\"\u0010\u0016\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00120\u0011R\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lavail/optimizer/L2Optimizer$UsedRegisters;", "", "()V", "original", "(Lavail/optimizer/L2Optimizer$UsedRegisters;)V", "liveRegistersByKind", "", "Ljava/util/BitSet;", "getLiveRegistersByKind", "()[Ljava/util/BitSet;", "[Ljava/util/BitSet;", "clearAll", "", "readRegister", "register", "Lavail/interpreter/levelTwo/register/L2Register;", "registerIdFunction", "Lkotlin/Function1;", "", "restrictTo", "", "another", "writeRegister", "avail"})
    private static final class UsedRegisters {
        @NotNull
        private final BitSet[] liveRegistersByKind;

        @NotNull
        public final BitSet[] getLiveRegistersByKind() {
            return this.liveRegistersByKind;
        }

        public final boolean restrictTo(@NotNull UsedRegisters another) {
            Intrinsics.checkNotNullParameter((Object)another, (String)"another");
            boolean changed = false;
            int n = this.liveRegistersByKind.length;
            for (int i = 0; i < n; ++i) {
                BitSet registers = this.liveRegistersByKind[i];
                int count = registers.cardinality();
                registers.and(another.liveRegistersByKind[i]);
                changed |= registers.cardinality() != count;
            }
            return changed;
        }

        public final void readRegister(@NotNull L2Register register, @NotNull Function1<? super L2Register, Integer> registerIdFunction) {
            Intrinsics.checkNotNullParameter((Object)register, (String)"register");
            Intrinsics.checkNotNullParameter(registerIdFunction, (String)"registerIdFunction");
            boolean bl = this.liveRegistersByKind[register.getRegisterKind().ordinal()].get(((Number)registerIdFunction.invoke((Object)register)).intValue());
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
        }

        public final void writeRegister(@NotNull L2Register register, @NotNull Function1<? super L2Register, Integer> registerIdFunction) {
            Intrinsics.checkNotNullParameter((Object)register, (String)"register");
            Intrinsics.checkNotNullParameter(registerIdFunction, (String)"registerIdFunction");
            this.liveRegistersByKind[register.getRegisterKind().ordinal()].set(((Number)registerIdFunction.invoke((Object)register)).intValue());
        }

        public final void clearAll() {
            int n = this.liveRegistersByKind.length;
            for (int i = 0; i < n; ++i) {
                this.liveRegistersByKind[i].clear();
            }
        }

        public UsedRegisters() {
            L2Register.RegisterKind[] kinds = L2Register.RegisterKind.values();
            int n = 0;
            int n2 = kinds.length;
            BitSet[] bitSetArray = new BitSet[n2];
            UsedRegisters usedRegisters = this;
            while (n < n2) {
                int n3 = n++;
                bitSetArray[n3] = new BitSet();
            }
            usedRegisters.liveRegistersByKind = bitSetArray;
        }

        public UsedRegisters(@NotNull UsedRegisters original) {
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            L2Register.RegisterKind[] kinds = L2Register.RegisterKind.values();
            int n = 0;
            int n2 = kinds.length;
            BitSet[] bitSetArray = new BitSet[n2];
            UsedRegisters usedRegisters = this;
            while (n < n2) {
                int n3 = n++;
                Object object = original.liveRegistersByKind[n3].clone();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.BitSet");
                bitSetArray[n3] = (BitSet)object;
            }
            usedRegisters.liveRegistersByKind = bitSetArray;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lavail/optimizer/L2Optimizer$Companion;", "", "()V", "sanityCheckStat", "Lavail/performance/Statistic;", "shouldSanityCheck", "", "getShouldSanityCheck", "()Z", "setShouldSanityCheck", "(Z)V", "avail"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getShouldSanityCheck() {
            return shouldSanityCheck;
        }

        public final void setShouldSanityCheck(boolean bl) {
            shouldSanityCheck = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

