/*
 * Decompiled with CFR 0.152.
 */
package avail.compiler.splitter;

import avail.compiler.ParsingOperation;
import avail.compiler.splitter.Expression;
import avail.compiler.splitter.InstructionGenerator;
import avail.compiler.splitter.MessageSplitter;
import avail.compiler.splitter.Optional;
import avail.compiler.splitter.SectionCheckpoint;
import avail.compiler.splitter.WrapState;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.ListPhraseTypeDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.MalformedMessageException;
import avail.exceptions.SignatureException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0001J\r\u0010'\u001a\u00020\u0000H\u0010\u00a2\u0006\u0002\b(J\u0006\u0010)\u001a\u00020%J\u0010\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020,H\u0016J\u0016\u0010-\u001a\u00020%2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0003J\u001d\u00101\u001a\u00020%2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b2J\u001e\u00103\u001a\u00020%2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u00032\u0006\u00104\u001a\u000205J%\u00106\u001a\u0002072\u0006\u00108\u001a\u00020/2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u000207H\u0010\u00a2\u0006\u0002\b<J:\u0010=\u001a\u00020%2\u0018\u0010>\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00030\u00070\u00062\u0006\u0010?\u001a\u00020\u00032\u0006\u00109\u001a\u00020:2\u0006\u0010@\u001a\u00020/H\u0002J\u001b\u0010A\u001a\u00020%2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020C0\tH\u0010\u00a2\u0006\u0002\bDJ\u0015\u0010E\u001a\u00020\r2\u0006\u00108\u001a\u00020/H\u0010\u00a2\u0006\u0002\bFJ1\u0010G\u001a\u00020%2\u000e\u0010H\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010I2\n\u0010J\u001a\u00060Kj\u0002`L2\u0006\u0010M\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\bNJ \u0010O\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00030\u00070\u00060\u0006H\u0002J\b\u0010P\u001a\u00020QH\u0016R(\u0010\u0005\u001a\u001c\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00030\u00070\u0006\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u000f\"\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000bR\u0014\u0010\u0015\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000fR\u0014\u0010\u0017\u001a\u00020\r8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000fR\u0014\u0010\u0019\u001a\u00020\r8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000fR\u0014\u0010\u001b\u001a\u00020\u00038PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u000bR\u001a\u0010 \u001a\u00020\r8PX\u0091\u0004\u00a2\u0006\f\u0012\u0004\b!\u0010\"\u001a\u0004\b#\u0010\u000f\u00a8\u0006R"}, d2={"Lavail/compiler/splitter/Sequence;", "Lavail/compiler/splitter/Expression;", "positionInName", "", "(I)V", "cachedRunsForCodeSplitting", "", "Lkotlin/Pair;", "expressions", "", "getExpressions", "()Ljava/util/List;", "isLowerCase", "", "isLowerCase$avail", "()Z", "isReordered", "setReordered", "(Z)V", "permutation", "getPermutation", "recursivelyContainsReorders", "getRecursivelyContainsReorders", "shouldBeSeparatedOnLeft", "getShouldBeSeparatedOnLeft$avail", "shouldBeSeparatedOnRight", "getShouldBeSeparatedOnRight$avail", "underscoreCount", "getUnderscoreCount$avail", "()I", "yielders", "getYielders", "yieldsValue", "getYieldsValue$avail$annotations", "()V", "getYieldsValue$avail", "addExpression", "", "e", "applyCaseInsensitive", "applyCaseInsensitive$avail", "checkForConsistentOrdinals", "checkListStructure", "phrase", "Lavail/descriptor/phrases/A_Phrase;", "checkRootType", "argumentType", "Lavail/descriptor/types/A_Type;", "sectionNumber", "checkType", "checkType$avail", "checkTypeWithErrorCode", "errorCode", "Lavail/exceptions/AvailErrorCode;", "emitOn", "Lavail/compiler/splitter/WrapState;", "phraseType", "generator", "Lavail/compiler/splitter/InstructionGenerator;", "wrapState", "emitOn$avail", "emitRunOn", "run", "positionInRun", "subexpressionsTupleType", "extractSectionCheckpointsInto", "sectionCheckpoints", "Lavail/compiler/splitter/SectionCheckpoint;", "extractSectionCheckpointsInto$avail", "mightBeEmpty", "mightBeEmpty$avail", "printWithArguments", "arguments", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "indent", "printWithArguments$avail", "runsForCodeSplitting", "toString", "", "avail"})
public final class Sequence
extends Expression {
    @NotNull
    private final List<Expression> expressions = new ArrayList();
    @NotNull
    private final List<Expression> yielders = new ArrayList();
    @NotNull
    private final List<Integer> permutation = new ArrayList();
    private boolean isReordered;
    @Nullable
    private volatile List<? extends List<? extends Pair<? extends Expression, Integer>>> cachedRunsForCodeSplitting;

    public Sequence(int positionInName) {
        super(positionInName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getRecursivelyContainsReorders() {
        Expression it;
        if (this.isReordered) return true;
        Iterable $this$any$iv = this.expressions;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (Expression)element$iv;
            boolean bl = false;
        } while (!it.getRecursivelyContainsReorders());
        return true;
    }

    @NotNull
    public final List<Expression> getExpressions() {
        return this.expressions;
    }

    @NotNull
    public final List<Expression> getYielders() {
        return this.yielders;
    }

    @NotNull
    public final List<Integer> getPermutation() {
        return this.permutation;
    }

    public final boolean isReordered() {
        return this.isReordered;
    }

    public final void setReordered(boolean bl) {
        this.isReordered = bl;
    }

    @Override
    public boolean isLowerCase$avail() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = this.expressions;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Expression p0 = (Expression)element$iv;
                    boolean bl2 = false;
                    if (p0.isLowerCase$avail()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Sequence applyCaseInsensitive$avail() {
        Sequence copy2 = new Sequence(this.getPositionInName());
        Iterable $this$forEach$iv = this.expressions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Expression it = (Expression)element$iv;
            boolean bl = false;
            copy2.addExpression(it.applyCaseInsensitive$avail());
        }
        return copy2;
    }

    public final void addExpression(@NotNull Expression e) throws MalformedMessageException {
        Intrinsics.checkNotNullParameter(e, "e");
        this.expressions.add(e);
        if (e.getYieldsValue$avail()) {
            boolean alsoReordered;
            boolean bl = e.getCanBeReordered();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            boolean bl2 = alsoReordered = e.getExplicitOrdinal() != -1;
            if (this.yielders.isEmpty()) {
                this.isReordered = alsoReordered;
            } else if (this.isReordered != alsoReordered) {
                MessageSplitter.Companion.throwMalformedMessageException(AvailErrorCode.E_INCONSISTENT_ARGUMENT_REORDERING, "The sequence of subexpressions before or after a double-dagger (\u2021) in a group must have either all or none of its arguments or direct subgroups numbered for reordering");
                throw new KotlinNothingValueException();
            }
            this.yielders.add(e);
        }
    }

    @Override
    public boolean getYieldsValue$avail() {
        if (_Assertions.ENABLED) {
            boolean bl = false;
            String string2 = "Should not ask sequence if it yields a value";
            throw new AssertionError((Object)string2);
        }
        return false;
    }

    @Deprecated(message="Not applicable to Sequence")
    public static /* synthetic */ void getYieldsValue$avail$annotations() {
    }

    @Override
    public int getUnderscoreCount$avail() {
        return this.expressions.stream().mapToInt(Sequence::_get_underscoreCount_$lambda-3).sum();
    }

    @Override
    public void extractSectionCheckpointsInto$avail(@NotNull List<SectionCheckpoint> sectionCheckpoints) {
        Intrinsics.checkNotNullParameter(sectionCheckpoints, "sectionCheckpoints");
        Iterable $this$forEach$iv = this.expressions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Expression expression = (Expression)element$iv;
            boolean bl = false;
            expression.extractSectionCheckpointsInto$avail(sectionCheckpoints);
        }
    }

    public final void checkRootType(@NotNull A_Type argumentType, int sectionNumber) throws SignatureException {
        Intrinsics.checkNotNullParameter(argumentType, "argumentType");
        this.checkTypeWithErrorCode(argumentType, sectionNumber, AvailErrorCode.E_INCORRECT_NUMBER_OF_ARGUMENTS);
    }

    @Override
    public void checkType$avail(@NotNull A_Type argumentType, int sectionNumber) throws SignatureException {
        Intrinsics.checkNotNullParameter(argumentType, "argumentType");
        this.checkTypeWithErrorCode(argumentType, sectionNumber, AvailErrorCode.E_INCORRECT_TYPE_FOR_GROUP);
    }

    public final void checkTypeWithErrorCode(@NotNull A_Type argumentType, int sectionNumber, @NotNull AvailErrorCode errorCode) throws SignatureException {
        Intrinsics.checkNotNullParameter(argumentType, "argumentType");
        Intrinsics.checkNotNullParameter((Object)errorCode, "errorCode");
        if (argumentType.isBottom()) {
            MessageSplitter.Companion.throwSignatureException(AvailErrorCode.E_INCORRECT_ARGUMENT_TYPE);
            throw new KotlinNothingValueException();
        }
        if (!argumentType.isTupleType()) {
            MessageSplitter.Companion.throwSignatureException(AvailErrorCode.E_INCORRECT_TYPE_FOR_GROUP);
            throw new KotlinNothingValueException();
        }
        int expected2 = this.yielders.size();
        A_Type sizes = A_Type.Companion.getSizeRange(argumentType);
        if (!A_Number.Companion.equalsInt(A_Type.Companion.getLowerBound(sizes), expected2) || !A_Number.Companion.equalsInt(A_Type.Companion.getUpperBound(sizes), expected2)) {
            MessageSplitter.Companion.throwSignatureException(errorCode);
            throw new KotlinNothingValueException();
        }
        if (this.isReordered) {
            Iterable $this$forEach$iv = new IntRange(1, expected2);
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                boolean bl;
                int element$iv;
                int i = element$iv = ((IntIterator)iterator2).nextInt();
                boolean bl2 = false;
                Expression argumentOrGroup = this.yielders.get(i - 1);
                A_Type providedType = A_Type.Companion.typeAtIndex(argumentType, ((Number)this.permutation.get(i - 1)).intValue());
                boolean bl3 = bl = !providedType.isBottom();
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                argumentOrGroup.checkType$avail(providedType, sectionNumber);
            }
        } else {
            int i = 1;
            if (i <= expected2) {
                while (true) {
                    boolean bl;
                    Expression argumentOrGroup = this.yielders.get(i - 1);
                    A_Type providedType = A_Type.Companion.typeAtIndex(argumentType, i);
                    boolean bl4 = bl = !providedType.isBottom();
                    if (_Assertions.ENABLED && !bl) {
                        String string3 = "Assertion failed";
                        throw new AssertionError((Object)string3);
                    }
                    argumentOrGroup.checkType$avail(providedType, sectionNumber);
                    if (i == expected2) break;
                    ++i;
                }
            }
        }
    }

    private final List<List<Pair<Expression, Integer>>> runsForCodeSplitting() {
        List<List<Pair<Expression, Integer>>> cached = this.cachedRunsForCodeSplitting;
        if (cached != null) {
            return cached;
        }
        List result2 = new ArrayList();
        List currentRun = new ArrayList();
        int typeIndex = 0;
        Iterable $this$forEach$iv = this.expressions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Expression expression = (Expression)element$iv;
            boolean bl = false;
            if (expression.getHasSectionCheckpoints$avail()) {
                if (!((Collection)currentRun).isEmpty()) {
                    result2.add(CollectionsKt.toList(currentRun));
                    currentRun.clear();
                }
                result2.add(CollectionsKt.listOf(new Pair<Expression, Integer>(expression, expression.getYieldsValue$avail() ? ++typeIndex : 0)));
                continue;
            }
            currentRun.add(new Pair<Expression, Integer>(expression, expression.getYieldsValue$avail() ? ++typeIndex : 0));
            if (expression instanceof Optional) continue;
            result2.add(CollectionsKt.toList(currentRun));
            currentRun.clear();
        }
        if (!((Collection)currentRun).isEmpty()) {
            result2.add(currentRun);
        }
        this.cachedRunsForCodeSplitting = result2;
        return result2;
    }

    private final void emitRunOn(List<? extends Pair<? extends Expression, Integer>> run2, int positionInRun, InstructionGenerator generator, A_Type subexpressionsTupleType2) throws SignatureException {
        A_Type subexpressionType;
        int runSize = run2.size();
        Pair<? extends Expression, Integer> pair = run2.get(positionInRun);
        Expression expression = pair.getFirst();
        int typeIndex = ((Number)pair.getSecond()).intValue();
        int realTypeIndex = typeIndex != 0 && this.isReordered ? ((Number)this.permutation.get(typeIndex - 1)).intValue() : typeIndex;
        A_Type a_Type = subexpressionType = typeIndex == 0 ? ListPhraseTypeDescriptor.Companion.emptyListPhraseType() : A_Type.Companion.typeAtIndex(subexpressionsTupleType2, realTypeIndex);
        if (positionInRun == runSize - 1) {
            expression.emitOn$avail(subexpressionType, generator, WrapState.SHOULD_NOT_PUSH_LIST);
        } else {
            boolean lastElementPushed;
            int permutationSize;
            Intrinsics.checkNotNull(expression, "null cannot be cast to non-null type avail.compiler.splitter.Optional");
            ((Optional)expression).emitInRunThen(generator, new Function0<Unit>(this, run2, positionInRun, generator, subexpressionsTupleType2){
                final /* synthetic */ Sequence this$0;
                final /* synthetic */ List<Pair<Expression, Integer>> $run;
                final /* synthetic */ int $positionInRun;
                final /* synthetic */ InstructionGenerator $generator;
                final /* synthetic */ A_Type $subexpressionsTupleType;
                {
                    this.this$0 = $receiver;
                    this.$run = $run;
                    this.$positionInRun = $positionInRun;
                    this.$generator = $generator;
                    this.$subexpressionsTupleType = $subexpressionsTupleType;
                    super(0);
                }

                public final void invoke() {
                    Sequence.access$emitRunOn(this.this$0, this.$run, this.$positionInRun + 1, this.$generator, this.$subexpressionsTupleType);
                }
            });
            if (positionInRun == 0 && (permutationSize = runSize + ((lastElementPushed = run2.get(runSize - 1).getFirst().getYieldsValue$avail()) ? 0 : -1)) > 1) {
                generator.emit((Expression)this, ParsingOperation.REVERSE_STACK, permutationSize);
            }
        }
    }

    @Override
    @NotNull
    public WrapState emitOn$avail(@NotNull A_Type phraseType, @NotNull InstructionGenerator generator, @NotNull WrapState wrapState) throws SignatureException {
        Intrinsics.checkNotNullParameter(phraseType, "phraseType");
        Intrinsics.checkNotNullParameter(generator, "generator");
        Intrinsics.checkNotNullParameter((Object)wrapState, "wrapState");
        AvailObject intersected = A_Type.Companion.typeIntersection(phraseType.makeImmutable(), PhraseTypeDescriptor.PhraseKind.LIST_PHRASE.getMostGeneralType()).makeShared();
        if (intersected.isBottom()) {
            MessageSplitter.Companion.throwSignatureException(AvailErrorCode.E_INCORRECT_TYPE_FOR_GROUP);
            throw new KotlinNothingValueException();
        }
        A_Type subexpressionsTupleType2 = A_Type.Companion.getSubexpressionsTupleType(intersected);
        int argIndex = 0;
        int ungroupedArguments = 0;
        boolean listIsPushed = false;
        listIsPushed = wrapState == WrapState.PUSHED_LIST;
        List<List<Pair<Expression, Integer>>> allRuns = this.runsForCodeSplitting();
        Iterable $this$forEach$iv22 = allRuns;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv22) {
            List run2 = (List)element$iv;
            boolean bl = false;
            int runSize = run2.size();
            Expression lastInRun = (Expression)((Pair)run2.get(runSize - 1)).getFirst();
            if (lastInRun.getHasSectionCheckpoints$avail()) {
                boolean bl2;
                boolean bl3 = bl2 = runSize == 1;
                if (_Assertions.ENABLED && !bl2) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                generator.flushDelayed();
                if (listIsPushed) {
                    if (ungroupedArguments == 1) {
                        generator.emit(this, ParsingOperation.APPEND_ARGUMENT);
                    } else if (ungroupedArguments > 1) {
                        generator.emitWrapped(this, ungroupedArguments);
                        generator.emit(this, ParsingOperation.CONCATENATE);
                    }
                    ungroupedArguments = 0;
                } else if (wrapState == WrapState.NEEDS_TO_PUSH_LIST) {
                    generator.emitWrapped(this, ungroupedArguments);
                    listIsPushed = true;
                    ungroupedArguments = 0;
                }
            }
            this.emitRunOn(run2, 0, generator, subexpressionsTupleType2);
            int argsInRun = lastInRun.getYieldsValue$avail() ? runSize : runSize - 1;
            ungroupedArguments += argsInRun;
            argIndex += argsInRun;
        }
        generator.flushDelayed();
        if (listIsPushed) {
            if (ungroupedArguments == 1) {
                generator.emit(this, ParsingOperation.APPEND_ARGUMENT);
            } else if (ungroupedArguments > 1) {
                generator.emitWrapped(this, ungroupedArguments);
                generator.emit(this, ParsingOperation.CONCATENATE);
            }
        } else if (wrapState == WrapState.NEEDS_TO_PUSH_LIST) {
            generator.emitWrapped(this, ungroupedArguments);
            listIsPushed = true;
        }
        boolean bl = $this$forEach$iv22 = listIsPushed || wrapState == WrapState.SHOULD_NOT_PUSH_LIST || wrapState == WrapState.SHOULD_NOT_HAVE_ARGUMENTS;
        if (_Assertions.ENABLED && !$this$forEach$iv22) {
            String $i$f$forEach2 = "Assertion failed";
            throw new AssertionError((Object)$i$f$forEach2);
        }
        boolean bl4 = $this$forEach$iv22 = this.yielders.size() == argIndex;
        if (_Assertions.ENABLED && !$this$forEach$iv22) {
            String $i$f$forEach2 = "Assertion failed";
            throw new AssertionError((Object)$i$f$forEach2);
        }
        boolean $this$forEach$iv22 = A_Number.Companion.equalsInt(A_Type.Companion.getLowerBound(A_Type.Companion.getSizeRange(subexpressionsTupleType2)), argIndex);
        if (_Assertions.ENABLED && !$this$forEach$iv22) {
            String $i$f$forEach2 = "Assertion failed";
            throw new AssertionError((Object)$i$f$forEach2);
        }
        $this$forEach$iv22 = A_Number.Companion.equalsInt(A_Type.Companion.getUpperBound(A_Type.Companion.getSizeRange(subexpressionsTupleType2)), argIndex);
        if (_Assertions.ENABLED && !$this$forEach$iv22) {
            String $i$f$forEach2 = "Assertion failed";
            throw new AssertionError((Object)$i$f$forEach2);
        }
        if (this.isReordered) {
            $this$forEach$iv22 = listIsPushed;
            if (_Assertions.ENABLED && !$this$forEach$iv22) {
                String $i$f$forEach2 = "Assertion failed";
                throw new AssertionError((Object)$i$f$forEach2);
            }
            A_Tuple permutationTuple = TupleDescriptor.Companion.tupleFromIntegerList(this.permutation);
            int permutationIndex = MessageSplitter.Companion.indexForPermutation(permutationTuple);
            generator.flushDelayed();
            generator.emit((Expression)this, ParsingOperation.PERMUTE_LIST, permutationIndex);
        }
        return wrapState == WrapState.NEEDS_TO_PUSH_LIST ? WrapState.PUSHED_LIST : wrapState;
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u2d9 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u2d9.append("Sequence(");
        boolean first = false;
        first = true;
        Iterable $this$forEach$iv = this.expressions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Expression e = (Expression)element$iv;
            boolean bl2 = false;
            if (!first) {
                $this$toString_u24lambda_u2d9.append(", ");
            }
            $this$toString_u24lambda_u2d9.append(e);
            if (e.getCanBeReordered() && e.getExplicitOrdinal() != -1) {
                $this$toString_u24lambda_u2d9.appendCodePoint(MessageSplitter.Companion.circledNumberCodePoint(e.getExplicitOrdinal()));
            }
            first = false;
        }
        $this$toString_u24lambda_u2d9.append(')');
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @Override
    public void printWithArguments$avail(@Nullable Iterator<? extends A_Phrase> arguments2, @NotNull StringBuilder builder2, int indent) {
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter(builder2, "builder");
        boolean bl3 = bl2 = arguments2 != null;
        if (_Assertions.ENABLED && !bl2) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean needsSpace = false;
        Iterable $this$forEach$iv = this.expressions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Expression expression = (Expression)element$iv;
            boolean bl4 = false;
            if (expression.getShouldBeSeparatedOnLeft$avail() && needsSpace) {
                builder2.append(' ');
            }
            int oldLength = builder2.length();
            expression.printWithArguments$avail(arguments2, builder2, indent);
            needsSpace = builder2.length() != oldLength && expression.getShouldBeSeparatedOnRight$avail();
        }
        Iterator<? extends A_Phrase> iterator2 = arguments2;
        Intrinsics.checkNotNull(iterator2);
        boolean bl5 = bl = !iterator2.hasNext();
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
    }

    @Override
    public boolean getShouldBeSeparatedOnLeft$avail() {
        return !((Collection)this.expressions).isEmpty() && this.expressions.get(0).getShouldBeSeparatedOnLeft$avail();
    }

    @Override
    public boolean getShouldBeSeparatedOnRight$avail() {
        return !((Collection)this.expressions).isEmpty() && this.expressions.get(this.expressions.size() - 1).getShouldBeSeparatedOnRight$avail();
    }

    /*
     * WARNING - void declaration
     */
    public final void checkForConsistentOrdinals() throws MalformedMessageException {
        void $this$mapTo$iv$iv;
        Expression p0;
        Iterable $this$filterTo$iv$iv;
        if (!this.isReordered) {
            return;
        }
        Iterable $this$filter$iv = this.expressions;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            p0 = (Expression)element$iv$iv;
            boolean bl = false;
            if (!p0.getCanBeReordered()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            p0 = (Expression)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getExplicitOrdinal());
        }
        List usedOrdinalsList = (List)destination$iv$iv;
        int size = usedOrdinalsList.size();
        List sortedOrdinalsList = CollectionsKt.sorted(usedOrdinalsList);
        Set usedOrdinalsSet = CollectionsKt.toSet(usedOrdinalsList);
        if (usedOrdinalsSet.size() < usedOrdinalsList.size() || ((Number)sortedOrdinalsList.get(0)).intValue() != 1 || ((Number)sortedOrdinalsList.get(size - 1)).intValue() != size || Intrinsics.areEqual(usedOrdinalsList, sortedOrdinalsList)) {
            MessageSplitter.Companion.throwMalformedMessageException(AvailErrorCode.E_INCONSISTENT_ARGUMENT_REORDERING, "The circled numbers for this clause must range from 1 to the number of arguments/groups, but must not be in ascending order (got " + usedOrdinalsList + ")");
            throw new KotlinNothingValueException();
        }
        boolean bl = this.permutation.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.permutation.addAll(usedOrdinalsList);
    }

    @Override
    public boolean mightBeEmpty$avail(@NotNull A_Type phraseType) {
        Intrinsics.checkNotNullParameter(phraseType, "phraseType");
        A_Type subexpressionsTupleType2 = A_Type.Companion.getSubexpressionsTupleType(phraseType);
        int index2 = 0;
        Iterable $this$forEach$iv = this.expressions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int realTypeIndex;
            A_Type entryType;
            Expression expression = (Expression)element$iv;
            boolean bl = false;
            if (!(expression.getYieldsValue$avail() ? !expression.mightBeEmpty$avail(entryType = A_Type.Companion.typeAtIndex(subexpressionsTupleType2, realTypeIndex = this.isReordered ? ((Number)this.permutation.get(index2 - 1)).intValue() : ++index2)) : !expression.mightBeEmpty$avail(ListPhraseTypeDescriptor.Companion.emptyListPhraseType()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean checkListStructure(@NotNull A_Phrase phrase) {
        boolean bl;
        block10: {
            Intrinsics.checkNotNullParameter(phrase, "phrase");
            if (A_Phrase.Companion.phraseKindIsUnder(phrase, PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE)) {
                return true;
            }
            A_Tuple subphrases = A_Phrase.Companion.getExpressionsTuple(phrase);
            int subphrasesSize = A_Tuple.Companion.getTupleSize(subphrases);
            if (subphrasesSize != this.yielders.size()) {
                return false;
            }
            if (this.isReordered) {
                if (!A_Phrase.Companion.phraseKindIsUnder(phrase, PhraseTypeDescriptor.PhraseKind.PERMUTED_LIST_PHRASE)) {
                    return false;
                }
                if (!TupleDescriptor.Companion.tupleFromIntegerList(this.permutation).equals(A_Phrase.Companion.getPermutation(phrase))) {
                    return false;
                }
            } else if (A_Phrase.Companion.phraseKindIsUnder(phrase, PhraseTypeDescriptor.PhraseKind.PERMUTED_LIST_PHRASE)) {
                return false;
            }
            Iterable $this$all$iv = CollectionsKt.zip((Iterable)this.yielders, subphrases);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    AvailObject subphrase;
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    Expression yielder = (Expression)pair.component1();
                    if (yielder.checkListStructure(subphrase = (AvailObject)pair.component2())) continue;
                    bl = false;
                    break block10;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final int _get_underscoreCount_$lambda-3(Expression it) {
        Expression expression = it;
        Intrinsics.checkNotNull(expression);
        return expression.getUnderscoreCount$avail();
    }

    public static final /* synthetic */ void access$emitRunOn(Sequence $this, List run2, int positionInRun, InstructionGenerator generator, A_Type subexpressionsTupleType2) {
        $this.emitRunOn(run2, positionInRun, generator, subexpressionsTupleType2);
    }
}

