/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo.operand;

import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.TypeRestriction;
import avail.interpreter.levelTwo.register.L2Register;
import avail.optimizer.L2ValueManifest;
import avail.optimizer.values.L2SemanticValue;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B#\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017H\u0016J\u001a\u0010\u0018\u001a\u00020\u00152\u0010\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00000\u0017H\u0016J\u0014\u0010\u001a\u001a\u00020\u00152\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dH\u0016J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"H\u0016J\u0016\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"J\u0016\u0010%\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"J\u0010\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u0015H\u0016J\b\u0010*\u001a\u00020\u0006H\u0016J\u0006\u0010+\u001a\u00020\u0006J\b\u0010,\u001a\u00020\u0015H\u0016J\u000b\u0010\t\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\fJ\u0006\u0010-\u001a\u00020.J$\u0010/\u001a\u00020\u00152\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002012\u0006\u00102\u001a\u00020(H\u0016J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u00103\u001a\u00020\u00152\u0006\u00104\u001a\u00020\u0006J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005R\u001c\u0010\t\u001a\u00028\u0000X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0012\u0010\u0010\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lavail/interpreter/levelTwo/operand/L2WriteOperand;", "R", "Lavail/interpreter/levelTwo/register/L2Register;", "Lavail/interpreter/levelTwo/operand/L2Operand;", "semanticValues", "", "Lavail/optimizer/values/L2SemanticValue;", "restriction", "Lavail/interpreter/levelTwo/operand/TypeRestriction;", "register", "(Ljava/util/Set;Lavail/interpreter/levelTwo/operand/TypeRestriction;Lavail/interpreter/levelTwo/register/L2Register;)V", "getRegister", "()Lavail/interpreter/levelTwo/register/L2Register;", "setRegister", "(Lavail/interpreter/levelTwo/register/L2Register;)V", "Lavail/interpreter/levelTwo/register/L2Register;", "registerKind", "Lavail/interpreter/levelTwo/register/L2Register$RegisterKind;", "getRegisterKind", "()Lavail/interpreter/levelTwo/register/L2Register$RegisterKind;", "addDestinationRegistersTo", "", "destinationRegisters", "", "addWritesTo", "writeOperands", "appendTo", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "finalIndex", "", "instructionWasAdded", "manifest", "Lavail/optimizer/L2ValueManifest;", "instructionWasAddedForMakeImmutable", "sourceSemanticValue", "instructionWasAddedForMove", "instructionWasInserted", "newInstruction", "Lavail/interpreter/levelTwo/L2Instruction;", "instructionWasRemoved", "onlySemanticValue", "pickSemanticValue", "postOptimizationCleanup", "registerString", "", "replaceRegisters", "registerRemap", "", "theInstruction", "retroactivelyIncludeSemanticValue", "newSemanticValue", "avail"})
public abstract class L2WriteOperand<R extends L2Register>
extends L2Operand {
    @NotNull
    private Set<? extends L2SemanticValue> semanticValues;
    @NotNull
    private final TypeRestriction restriction;
    @NotNull
    private R register;

    public L2WriteOperand(@NotNull Set<? extends L2SemanticValue> semanticValues, @NotNull TypeRestriction restriction, @NotNull R register) {
        Intrinsics.checkNotNullParameter(semanticValues, "semanticValues");
        Intrinsics.checkNotNullParameter(restriction, "restriction");
        Intrinsics.checkNotNullParameter(register, "register");
        this.semanticValues = semanticValues;
        this.restriction = restriction;
        this.register = register;
    }

    @NotNull
    protected final R getRegister() {
        return this.register;
    }

    protected final void setRegister(@NotNull R r) {
        Intrinsics.checkNotNullParameter(r, "<set-?>");
        this.register = r;
    }

    @NotNull
    public final Set<L2SemanticValue> semanticValues() {
        return this.semanticValues;
    }

    @NotNull
    public L2SemanticValue onlySemanticValue() {
        boolean bl;
        boolean bl2 = bl = this.semanticValues.size() == 1;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return (L2SemanticValue)CollectionsKt.single((Iterable)this.semanticValues);
    }

    @NotNull
    public final L2SemanticValue pickSemanticValue() {
        return (L2SemanticValue)CollectionsKt.first((Iterable)this.semanticValues);
    }

    @NotNull
    public final TypeRestriction restriction() {
        return this.restriction;
    }

    @NotNull
    public abstract L2Register.RegisterKind getRegisterKind();

    public final int finalIndex() {
        return ((L2Register)this.register).finalIndex();
    }

    @NotNull
    public final R register() {
        return this.register;
    }

    @NotNull
    public final String registerString() {
        return !((Collection)this.semanticValues).isEmpty() ? "" + this.register + this.semanticValues : ((L2Register)this.register).toString();
    }

    @Override
    public void instructionWasAdded(@NotNull L2ValueManifest manifest2) {
        Intrinsics.checkNotNullParameter(manifest2, "manifest");
        super.instructionWasAdded(manifest2);
        ((L2Register)this.register).addDefinition(this);
        manifest2.recordDefinition(this);
    }

    public final void instructionWasAddedForMakeImmutable(@NotNull L2SemanticValue sourceSemanticValue, @NotNull L2ValueManifest manifest2) {
        Intrinsics.checkNotNullParameter(sourceSemanticValue, "sourceSemanticValue");
        Intrinsics.checkNotNullParameter(manifest2, "manifest");
        super.instructionWasAdded(manifest2);
        ((L2Register)this.register).addDefinition(this);
        boolean bl = manifest2.hasSemanticValue(sourceSemanticValue);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        manifest2.recordDefinitionForMakeImmutable(this, sourceSemanticValue);
    }

    public final void instructionWasAddedForMove(@NotNull L2SemanticValue sourceSemanticValue, @NotNull L2ValueManifest manifest2) {
        Intrinsics.checkNotNullParameter(sourceSemanticValue, "sourceSemanticValue");
        Intrinsics.checkNotNullParameter(manifest2, "manifest");
        super.instructionWasAdded(manifest2);
        ((L2Register)this.register).addDefinition(this);
        manifest2.recordDefinitionForMove(this, sourceSemanticValue);
    }

    @Override
    public void instructionWasInserted(@NotNull L2Instruction newInstruction) {
        Intrinsics.checkNotNullParameter(newInstruction, "newInstruction");
        super.instructionWasInserted(newInstruction);
        ((L2Register)this.register).addDefinition(this);
    }

    @Override
    public void instructionWasRemoved() {
        super.instructionWasRemoved();
        ((L2Register)this.register()).removeDefinition(this);
    }

    /*
     * WARNING - void declaration
     */
    public final void retroactivelyIncludeSemanticValue(@NotNull L2SemanticValue newSemanticValue) {
        void $this$retroactivelyIncludeSemanticValue_u24lambda_u2d0;
        Set set2;
        Intrinsics.checkNotNullParameter(newSemanticValue, "newSemanticValue");
        Set set3 = set2 = CollectionsKt.toMutableSet((Iterable)this.semanticValues);
        L2WriteOperand l2WriteOperand = this;
        boolean bl = false;
        $this$retroactivelyIncludeSemanticValue_u24lambda_u2d0.add(newSemanticValue);
        l2WriteOperand.semanticValues = set2;
    }

    @Override
    public void replaceRegisters(@NotNull Map<L2Register, ? extends L2Register> registerRemap, @NotNull L2Instruction theInstruction) {
        Intrinsics.checkNotNullParameter(registerRemap, "registerRemap");
        Intrinsics.checkNotNullParameter(theInstruction, "theInstruction");
        L2Register replacement2 = registerRemap.get(this.register);
        if (replacement2 == null || replacement2 == this.register) {
            return;
        }
        ((L2Register)this.register()).removeDefinition(this);
        replacement2.addDefinition(this);
        L2Register $this$cast$iv = replacement2;
        boolean $i$f$cast = false;
        this.register = (L2Register)((Object)$this$cast$iv);
    }

    @Override
    public void addWritesTo(@NotNull List<L2WriteOperand<?>> writeOperands) {
        Intrinsics.checkNotNullParameter(writeOperands, "writeOperands");
        writeOperands.add(this);
    }

    @Override
    public void addDestinationRegistersTo(@NotNull List<L2Register> destinationRegisters) {
        Intrinsics.checkNotNullParameter(destinationRegisters, "destinationRegisters");
        destinationRegisters.add((L2Register)this.register);
    }

    @Override
    public void appendTo(@NotNull StringBuilder builder2) {
        Intrinsics.checkNotNullParameter(builder2, "builder");
        builder2.append("\u2192").append(this.registerString());
    }

    @Override
    public void postOptimizationCleanup() {
        this.semanticValues = SetsKt.emptySet();
        this.restriction.makeShared();
    }
}

